# This file auto-generated by `generate_schema_interface.py`.
# Do not modify this file directly.

import traitlets as T
from ..baseobject import BaseObject


class AxisConfig(BaseObject):
    """Wrapper for Vega-Lite AxisConfig definition.
    
    Attributes
    ----------
    axisColor: Unicode
        Color of axis line.
    axisWidth: CFloat
        Width of the axis line.
    characterWidth: CFloat
        Character width for automatically determining title max length.
    grid: Bool
        A flag indicate if gridlines should be created in addition to ticks.
    gridColor: Unicode
        Color of gridlines.
    gridDash: List(CFloat)
        The offset (in pixels) into which to begin drawing with the grid dash array.
    gridOpacity: CFloat
        The stroke opacity of grid (value between [0,1]).
    gridWidth: CFloat
        The grid width, in pixels.
    labelAlign: Unicode
        Text alignment for the Label.
    labelAngle: CFloat
        The rotation angle of the axis labels.
    labelBaseline: Unicode
        Text baseline for the label.
    labelMaxLength: CFloat
        Truncate labels that are too long.
    labels: Bool
        Enable or disable labels.
    layer: Unicode
        A string indicating if the axis (and any gridlines) should be placed above or below the data marks.
    offset: CFloat
        The offset, in pixels, by which to displace the axis from the edge of the enclosing group or data rectangle.
    properties: Any
        Optional mark property definitions for custom axis styling.
    shortTimeLabels: Bool
        Whether month and day names should be abbreviated.
    subdivide: CFloat
        If provided, sets the number of minor ticks between major ticks (the value 9 results in decimal subdivision).
    tickColor: Unicode
        The color of the axis's tick.
    tickLabelColor: Unicode
        The color of the tick label, can be in hex color code or regular color name.
    tickLabelFont: Unicode
        The font of the tick label.
    tickLabelFontSize: CFloat
        The font size of label, in pixels.
    tickPadding: CFloat
        The padding, in pixels, between ticks and text labels.
    tickSize: CFloat
        The size, in pixels, of major, minor and end ticks.
    tickSizeEnd: CFloat
        The size, in pixels, of end ticks.
    tickSizeMajor: CFloat
        The size, in pixels, of major ticks.
    tickSizeMinor: CFloat
        The size, in pixels, of minor ticks.
    tickWidth: CFloat
        The width, in pixels, of ticks.
    ticks: CFloat
        A desired number of ticks, for axes visualizing quantitative scales.
    titleColor: Unicode
        Color of the title, can be in hex color code or regular color name.
    titleFont: Unicode
        Font of the title.
    titleFontSize: CFloat
        Size of the title.
    titleFontWeight: Unicode
        Weight of the title.
    titleMaxLength: CFloat
        Max length for axis title if the title is automatically generated from the field's description.
    titleOffset: CFloat
        A title offset value for the axis.
    """
    axisColor = T.Unicode(allow_none=True, default_value=None, help="""Color of axis line.""")
    axisWidth = T.CFloat(allow_none=True, default_value=None, help="""Width of the axis line.""")
    characterWidth = T.CFloat(allow_none=True, default_value=None, help="""Character width for automatically determining title max length.""")
    grid = T.Bool(allow_none=True, default_value=None, help="""A flag indicate if gridlines should be created in addition to ticks.""")
    gridColor = T.Unicode(allow_none=True, default_value=None, help="""Color of gridlines.""")
    gridDash = T.List(T.CFloat(), allow_none=True, default_value=None, help="""The offset (in pixels) into which to begin drawing with the grid dash array.""")
    gridOpacity = T.CFloat(allow_none=True, default_value=None, help="""The stroke opacity of grid (value between [0,1]).""")
    gridWidth = T.CFloat(allow_none=True, default_value=None, help="""The grid width, in pixels.""")
    labelAlign = T.Unicode(allow_none=True, default_value=None, help="""Text alignment for the Label.""")
    labelAngle = T.CFloat(allow_none=True, default_value=None, help="""The rotation angle of the axis labels.""")
    labelBaseline = T.Unicode(allow_none=True, default_value=None, help="""Text baseline for the label.""")
    labelMaxLength = T.CFloat(allow_none=True, default_value=None, min=1, help="""Truncate labels that are too long.""")
    labels = T.Bool(allow_none=True, default_value=None, help="""Enable or disable labels.""")
    layer = T.Unicode(allow_none=True, default_value=None, help="""A string indicating if the axis (and any gridlines) should be placed above or below the data marks.""")
    offset = T.CFloat(allow_none=True, default_value=None, help="""The offset, in pixels, by which to displace the axis from the edge of the enclosing group or data rectangle.""")
    properties = T.Any(allow_none=True, default_value=None, help="""Optional mark property definitions for custom axis styling.""")
    shortTimeLabels = T.Bool(allow_none=True, default_value=None, help="""Whether month and day names should be abbreviated.""")
    subdivide = T.CFloat(allow_none=True, default_value=None, help="""If provided, sets the number of minor ticks between major ticks (the value 9 results in decimal subdivision).""")
    tickColor = T.Unicode(allow_none=True, default_value=None, help="""The color of the axis's tick.""")
    tickLabelColor = T.Unicode(allow_none=True, default_value=None, help="""The color of the tick label, can be in hex color code or regular color name.""")
    tickLabelFont = T.Unicode(allow_none=True, default_value=None, help="""The font of the tick label.""")
    tickLabelFontSize = T.CFloat(allow_none=True, default_value=None, help="""The font size of label, in pixels.""")
    tickPadding = T.CFloat(allow_none=True, default_value=None, help="""The padding, in pixels, between ticks and text labels.""")
    tickSize = T.CFloat(allow_none=True, default_value=None, min=0, help="""The size, in pixels, of major, minor and end ticks.""")
    tickSizeEnd = T.CFloat(allow_none=True, default_value=None, min=0, help="""The size, in pixels, of end ticks.""")
    tickSizeMajor = T.CFloat(allow_none=True, default_value=None, min=0, help="""The size, in pixels, of major ticks.""")
    tickSizeMinor = T.CFloat(allow_none=True, default_value=None, min=0, help="""The size, in pixels, of minor ticks.""")
    tickWidth = T.CFloat(allow_none=True, default_value=None, help="""The width, in pixels, of ticks.""")
    ticks = T.CFloat(allow_none=True, default_value=None, min=0, help="""A desired number of ticks, for axes visualizing quantitative scales.""")
    titleColor = T.Unicode(allow_none=True, default_value=None, help="""Color of the title, can be in hex color code or regular color name.""")
    titleFont = T.Unicode(allow_none=True, default_value=None, help="""Font of the title.""")
    titleFontSize = T.CFloat(allow_none=True, default_value=None, help="""Size of the title.""")
    titleFontWeight = T.Unicode(allow_none=True, default_value=None, help="""Weight of the title.""")
    titleMaxLength = T.CFloat(allow_none=True, default_value=None, min=0, help="""Max length for axis title if the title is automatically generated from the field's description.""")
    titleOffset = T.CFloat(allow_none=True, default_value=None, help="""A title offset value for the axis.""")
    
    def __init__(self, axisColor=None, axisWidth=None, characterWidth=None, grid=None, gridColor=None, gridDash=None, gridOpacity=None, gridWidth=None, labelAlign=None, labelAngle=None, labelBaseline=None, labelMaxLength=None, labels=None, layer=None, offset=None, properties=None, shortTimeLabels=None, subdivide=None, tickColor=None, tickLabelColor=None, tickLabelFont=None, tickLabelFontSize=None, tickPadding=None, tickSize=None, tickSizeEnd=None, tickSizeMajor=None, tickSizeMinor=None, tickWidth=None, ticks=None, titleColor=None, titleFont=None, titleFontSize=None, titleFontWeight=None, titleMaxLength=None, titleOffset=None, **kwargs):
        kwds = dict(axisColor=axisColor, axisWidth=axisWidth, characterWidth=characterWidth, grid=grid, gridColor=gridColor, gridDash=gridDash, gridOpacity=gridOpacity, gridWidth=gridWidth, labelAlign=labelAlign, labelAngle=labelAngle, labelBaseline=labelBaseline, labelMaxLength=labelMaxLength, labels=labels, layer=layer, offset=offset, properties=properties, shortTimeLabels=shortTimeLabels, subdivide=subdivide, tickColor=tickColor, tickLabelColor=tickLabelColor, tickLabelFont=tickLabelFont, tickLabelFontSize=tickLabelFontSize, tickPadding=tickPadding, tickSize=tickSize, tickSizeEnd=tickSizeEnd, tickSizeMajor=tickSizeMajor, tickSizeMinor=tickSizeMinor, tickWidth=tickWidth, ticks=ticks, titleColor=titleColor, titleFont=titleFont, titleFontSize=titleFontSize, titleFontWeight=titleFontWeight, titleMaxLength=titleMaxLength, titleOffset=titleOffset)
        kwargs.update({k:v for k, v in kwds.items() if v is not None})
        super(AxisConfig, self).__init__(**kwargs)