/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.annotations.DecorateTypes;
import org.jboss.resteasy.annotations.Decorator;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.spi.interception.DecoratorProcessor;

public class DecoratorMatcher {
    public <T> T decorate(Class<T> targetClass, T target, Class type, Annotation[] annotations, MediaType mediaType) {
        HashMap meta = new HashMap();
        if (type != null) {
            this.registerDecorators(targetClass, meta, type.getAnnotations());
        }
        if (annotations != null) {
            this.registerDecorators(targetClass, meta, annotations);
        }
        if (meta.size() == 0) {
            return target;
        }
        MediaTypeMap typeMap = new MediaTypeMap();
        for (Class<?> decoratorAnnotation : meta.keySet()) {
            Decorator decorator = decoratorAnnotation.getAnnotation(Decorator.class);
            String[] mediaTypes = new String[]{"*/*"};
            DecorateTypes produces = decorator.processor().getAnnotation(DecorateTypes.class);
            if (produces != null) {
                mediaTypes = produces.value();
            }
            for (String pType : mediaTypes) {
                typeMap.add(MediaType.valueOf((String)pType), decoratorAnnotation);
            }
        }
        List list = typeMap.getPossible(mediaType);
        for (Class decoratorAnnotation : list) {
            Annotation annotation = meta.get(decoratorAnnotation);
            Decorator decorator = decoratorAnnotation.getAnnotation(Decorator.class);
            DecoratorProcessor processor = null;
            try {
                processor = decorator.processor().newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            target = processor.decorate(target, annotation, type, annotations, mediaType);
        }
        return target;
    }

    private <T> void registerDecorators(Class<T> targetClass, HashMap<Class<?>, Annotation> meta, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Decorator decorator = annotation.annotationType().getAnnotation(Decorator.class);
            if (decorator == null || !targetClass.isAssignableFrom(decorator.target())) continue;
            meta.put(annotation.annotationType(), annotation);
        }
    }
}

