/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.authentication.crypto;

import at.favre.lib.crypto.bcrypt.BCrypt;
import java.io.UnsupportedEncodingException;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.ow2.proactive.authentication.crypto.KeyPairUtil;
import org.ow2.proactive.authentication.crypto.KeyUtil;

public class HybridEncryptionUtil {
    private static final String ENCRYPTED_STRING_CHARSET = "UTF-8";
    private static final int AES_KEYSIZE = 128;
    private static final String AES_ALGO = "AES";
    private static final String AES_CIPHER = "AES";
    private static final String STRING_ENCRYPTION_CIPHER = "RSA/ECB/PKCS1Padding";

    public static byte[] decrypt(PrivateKey privateKey, String cipher, HybridEncryptedData encryptedData) throws KeyException {
        byte[] decryptedData;
        byte[] decryptedSymmetricKey;
        try {
            decryptedSymmetricKey = KeyPairUtil.decrypt(privateKey, cipher, encryptedData.getEncryptedSymmetricKey());
        }
        catch (KeyException e) {
            throw new KeyException("Could not decrypt symmetric key", e);
        }
        try {
            decryptedData = KeyUtil.decrypt(new SecretKeySpec(decryptedSymmetricKey, "AES"), "AES", encryptedData.getEncryptedData());
        }
        catch (KeyException e) {
            throw new KeyException("Could not decrypt data", e);
        }
        return decryptedData;
    }

    public static HybridEncryptedData encrypt(PublicKey publicKey, String cipher, byte[] message) throws KeyException {
        byte[] encData;
        byte[] encAes;
        SecretKey aesKey = KeyUtil.generateKey("AES", 128);
        try {
            encAes = KeyPairUtil.encrypt(publicKey, cipher, aesKey.getEncoded());
        }
        catch (KeyException e) {
            throw new KeyException("Symmetric key encryption failed", e);
        }
        try {
            encData = KeyUtil.encrypt(aesKey, "AES", message);
        }
        catch (KeyException e) {
            throw new KeyException("Message encryption failed", e);
        }
        return new HybridEncryptedData(encAes, encData);
    }

    public static String decryptString(HybridEncryptedData encryptedData, PrivateKey privateKey) throws KeyException {
        try {
            return new String(HybridEncryptionUtil.decrypt(privateKey, STRING_ENCRYPTION_CIPHER, encryptedData), ENCRYPTED_STRING_CHARSET);
        }
        catch (UnsupportedEncodingException ignored) {
            return null;
        }
    }

    public static HybridEncryptedData encryptString(String value, PublicKey publicKey) throws KeyException {
        try {
            byte[] valueAsBytes = value.getBytes(ENCRYPTED_STRING_CHARSET);
            return HybridEncryptionUtil.encrypt(publicKey, STRING_ENCRYPTION_CIPHER, valueAsBytes);
        }
        catch (UnsupportedEncodingException ignored) {
            return null;
        }
    }

    public static String decryptBase64String(String encryptedString, PrivateKey privateKey, String separator) throws KeyException {
        String[] encryptedStrings = encryptedString.split(separator);
        HybridEncryptedData encryptedData = new HybridEncryptedData(Base64.decodeBase64((String)encryptedStrings[1]), Base64.decodeBase64((String)encryptedStrings[0]));
        return HybridEncryptionUtil.decryptString(encryptedData, privateKey);
    }

    public static String encryptStringToBase64(String value, PublicKey publicKey, String separator) throws KeyException {
        HybridEncryptedData data = HybridEncryptionUtil.encryptString(value, publicKey);
        return Base64.encodeBase64String((byte[])data.getEncryptedData()) + separator + Base64.encodeBase64String((byte[])data.getEncryptedSymmetricKey());
    }

    public static String hashPassword(String password) {
        return BCrypt.withDefaults().hashToString(12, password.toCharArray());
    }

    public static boolean verifyPassword(String inputPassword, String storedHash) {
        BCrypt.Result result = BCrypt.verifyer().verify(inputPassword.toCharArray(), (CharSequence)storedHash);
        return result.verified;
    }

    public static class HybridEncryptedData {
        private byte[] encryptedData;
        private byte[] encryptedSymmetricKey;

        public HybridEncryptedData(byte[] encryptedSymmetricKey, byte[] encryptedData) {
            this.encryptedSymmetricKey = encryptedSymmetricKey;
            this.encryptedData = encryptedData;
        }

        public byte[] getEncryptedData() {
            return this.encryptedData;
        }

        public byte[] getEncryptedSymmetricKey() {
            return this.encryptedSymmetricKey;
        }
    }
}

