/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job;

import java.io.Serializable;
import java.util.Set;
import java.util.TimerTask;
import org.objectweb.proactive.annotation.PublicAPI;

@PublicAPI
public abstract class UserIdentification
implements Serializable,
Comparable<UserIdentification> {
    public static final int SORT_BY_NAME = 1;
    public static final int SORT_BY_SUBMIT = 3;
    public static final int SORT_BY_HOST = 4;
    public static final int SORT_BY_CONNECTION = 5;
    public static final int SORT_BY_LASTSUBMIT = 6;
    public static final int ASC_ORDER = 1;
    public static final int DESC_ORDER = 2;
    private static int currentSort = 1;
    private static int currentOrder = 1;
    protected volatile boolean toRemove = false;

    public abstract String getUsername();

    public abstract Set<String> getGroups();

    public abstract boolean isAllTenantPermission();

    public abstract boolean isAllJobPlannerPermission();

    public abstract boolean isAllCatalogPermission();

    public abstract boolean isCanCreateAssociationPermission();

    public abstract boolean isPcaAdminPermission();

    public abstract boolean isNotificationAdminPermission();

    public abstract boolean isRMCoreAllPermission();

    public abstract boolean isSchedulerAdminPermission();

    public abstract boolean isHandleOnlyMyJobsPermission();

    public abstract boolean isOtherUsersJobReadPermission();

    public abstract String getTenant();

    public abstract String getDomain();

    public abstract int getSubmitNumber();

    public abstract String getHostName();

    public abstract long getConnectionTime();

    public abstract long getLastSubmitTime();

    public abstract boolean isMyEventsOnly();

    public abstract TimerTask getSession();

    public static void setSortingBy(int sortBy) {
        currentSort = sortBy;
    }

    public static void setSortingOrder(int order) {
        currentOrder = order == 1 || order == 2 ? order : 1;
    }

    @Override
    public int compareTo(UserIdentification user) {
        switch (currentSort) {
            case 3: {
                return currentOrder == 1 ? this.getSubmitNumber() - user.getSubmitNumber() : user.getSubmitNumber() - this.getSubmitNumber();
            }
            case 4: {
                return currentOrder == 1 ? this.getHostName().compareTo(user.getHostName()) : user.getHostName().compareTo(this.getHostName());
            }
            case 5: {
                return currentOrder == 1 ? (int)(this.getConnectionTime() - user.getConnectionTime()) : (int)(user.getConnectionTime() - this.getConnectionTime());
            }
            case 6: {
                return currentOrder == 1 ? (int)(this.getLastSubmitTime() - user.getLastSubmitTime()) : (int)(user.getLastSubmitTime() - this.getLastSubmitTime());
            }
        }
        return currentOrder == 1 ? this.getHostName().compareTo(user.getHostName()) : user.getHostName().compareTo(this.getHostName());
    }

    public boolean isToRemove() {
        return this.toRemove;
    }
}

