/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.future;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.ConnectionPoolPartitioning;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Request;
import com.ning.http.client.listenable.AbstractListenableFuture;
import com.ning.http.client.providers.netty.channel.Channels;
import com.ning.http.client.providers.netty.request.NettyRequest;
import com.ning.http.client.providers.netty.request.timeout.TimeoutsHolder;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.DateUtils;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyResponseFuture<V>
extends AbstractListenableFuture<V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyResponseFuture.class);
    private final long start = DateUtils.millisTime();
    private final ConnectionPoolPartitioning connectionPoolPartitioning;
    private final ProxyServer proxyServer;
    private final int maxRetry;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    private final AtomicInteger redirectCount = new AtomicInteger();
    private final AtomicBoolean inAuth = new AtomicBoolean(false);
    private final AtomicBoolean statusReceived = new AtomicBoolean(false);
    private final AtomicLong touch = new AtomicLong(DateUtils.millisTime());
    private final AtomicReference<STATE> state = new AtomicReference<STATE>(STATE.NEW);
    private final AtomicBoolean contentProcessed = new AtomicBoolean(false);
    private final AtomicInteger currentRetry = new AtomicInteger(0);
    private final AtomicBoolean onThrowableCalled = new AtomicBoolean(false);
    private final AtomicReference<V> content = new AtomicReference();
    private final AtomicReference<ExecutionException> exEx = new AtomicReference();
    private volatile TimeoutsHolder timeoutsHolder;
    private Channel channel;
    private Uri uri;
    private boolean keepAlive = true;
    private Request request;
    private NettyRequest nettyRequest;
    private HttpHeaders httpHeaders;
    private AsyncHandler<V> asyncHandler;
    private boolean streamWasAlreadyConsumed;
    private boolean reuseChannel;
    private boolean headersAlreadyWrittenOnContinue;
    private boolean dontWriteBodyBecauseExpectContinue;
    private boolean allowConnect;

    public NettyResponseFuture(Uri uri, Request request, AsyncHandler<V> asyncHandler, NettyRequest nettyRequest, int maxRetry, ConnectionPoolPartitioning connectionPoolPartitioning, ProxyServer proxyServer) {
        this.asyncHandler = asyncHandler;
        this.request = request;
        this.nettyRequest = nettyRequest;
        this.uri = uri;
        this.connectionPoolPartitioning = connectionPoolPartitioning;
        this.proxyServer = proxyServer;
        this.maxRetry = maxRetry;
    }

    @Override
    public boolean isDone() {
        return this.isDone.get() || this.isCancelled();
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled.get();
    }

    @Override
    public boolean cancel(boolean force) {
        this.cancelTimeouts();
        if (this.isCancelled.getAndSet(true)) {
            return false;
        }
        if (this.channel != null) {
            Channels.setDiscard(this.channel);
            Channels.silentlyCloseChannel(this.channel);
        }
        if (!this.onThrowableCalled.getAndSet(true)) {
            try {
                this.asyncHandler.onThrowable(new CancellationException());
            }
            catch (Throwable t) {
                LOGGER.warn("cancel", t);
            }
        }
        this.latch.countDown();
        this.runListeners();
        return true;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.getContent();
    }

    @Override
    public V get(long l, TimeUnit tu) throws InterruptedException, TimeoutException, ExecutionException {
        if (!this.latch.await(l, tu)) {
            throw new TimeoutException();
        }
        return this.getContent();
    }

    private V getContent() throws ExecutionException {
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        ExecutionException e = this.exEx.get();
        if (e != null) {
            throw e;
        }
        V update = this.content.get();
        this.currentRetry.set(this.maxRetry);
        if (!this.contentProcessed.getAndSet(true)) {
            block9: {
                try {
                    update = this.asyncHandler.onCompleted();
                }
                catch (Throwable ex) {
                    if (this.onThrowableCalled.getAndSet(true)) break block9;
                    try {
                        try {
                            this.asyncHandler.onThrowable(ex);
                        }
                        catch (Throwable t) {
                            LOGGER.debug("asyncHandler.onThrowable", t);
                        }
                        throw new RuntimeException(ex);
                    }
                    catch (Throwable throwable) {
                        this.cancelTimeouts();
                        throw throwable;
                    }
                }
            }
            this.content.compareAndSet(null, update);
        }
        return update;
    }

    private boolean terminateAndExit() {
        this.cancelTimeouts();
        this.channel = null;
        this.reuseChannel = false;
        return this.isDone.getAndSet(true) || this.isCancelled.get();
    }

    @Override
    public final void done() {
        if (this.terminateAndExit()) {
            return;
        }
        try {
            this.getContent();
        }
        catch (ExecutionException t) {
            return;
        }
        catch (RuntimeException t) {
            Throwable exception = t.getCause() != null ? t.getCause() : t;
            this.exEx.compareAndSet(null, new ExecutionException(exception));
        }
        finally {
            this.latch.countDown();
        }
        this.runListeners();
    }

    @Override
    public final void abort(Throwable t) {
        this.exEx.compareAndSet(null, new ExecutionException(t));
        if (this.terminateAndExit()) {
            return;
        }
        if (this.onThrowableCalled.compareAndSet(false, true)) {
            try {
                this.asyncHandler.onThrowable(t);
            }
            catch (Throwable te) {
                LOGGER.debug("asyncHandler.onThrowable", te);
            }
        }
        this.latch.countDown();
        this.runListeners();
    }

    @Override
    public void touch() {
        this.touch.set(DateUtils.millisTime());
    }

    public Uri getUri() {
        return this.uri;
    }

    public void setUri(Uri uri) {
        this.uri = uri;
    }

    public ConnectionPoolPartitioning getConnectionPoolPartitioning() {
        return this.connectionPoolPartitioning;
    }

    public ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    public void setAsyncHandler(AsyncHandler<V> asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    public void cancelTimeouts() {
        if (this.timeoutsHolder != null) {
            this.timeoutsHolder.cancel();
            this.timeoutsHolder = null;
        }
    }

    public final Request getRequest() {
        return this.request;
    }

    public final NettyRequest getNettyRequest() {
        return this.nettyRequest;
    }

    public final void setNettyRequest(NettyRequest nettyRequest) {
        this.nettyRequest = nettyRequest;
    }

    public final AsyncHandler<V> getAsyncHandler() {
        return this.asyncHandler;
    }

    public final boolean isKeepAlive() {
        return this.keepAlive;
    }

    public final void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public final HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public final void setHttpHeaders(HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public int incrementAndGetCurrentRedirectCount() {
        return this.redirectCount.incrementAndGet();
    }

    public void setTimeoutsHolder(TimeoutsHolder timeoutsHolder) {
        this.timeoutsHolder = timeoutsHolder;
    }

    public boolean isInAuth() {
        return this.inAuth.get();
    }

    public boolean getAndSetAuth(boolean inDigestAuth) {
        return this.inAuth.getAndSet(inDigestAuth);
    }

    public STATE getState() {
        return this.state.get();
    }

    public void setState(STATE state) {
        this.state.set(state);
    }

    public boolean getAndSetStatusReceived(boolean sr) {
        return this.statusReceived.getAndSet(sr);
    }

    public boolean isStreamWasAlreadyConsumed() {
        return this.streamWasAlreadyConsumed;
    }

    public void setStreamWasAlreadyConsumed(boolean streamWasAlreadyConsumed) {
        this.streamWasAlreadyConsumed = streamWasAlreadyConsumed;
    }

    public long getLastTouch() {
        return this.touch.get();
    }

    public void setHeadersAlreadyWrittenOnContinue(boolean headersAlreadyWrittenOnContinue) {
        this.headersAlreadyWrittenOnContinue = headersAlreadyWrittenOnContinue;
    }

    public boolean isHeadersAlreadyWrittenOnContinue() {
        return this.headersAlreadyWrittenOnContinue;
    }

    public void setDontWriteBodyBecauseExpectContinue(boolean dontWriteBodyBecauseExpectContinue) {
        this.dontWriteBodyBecauseExpectContinue = dontWriteBodyBecauseExpectContinue;
    }

    public boolean isDontWriteBodyBecauseExpectContinue() {
        return this.dontWriteBodyBecauseExpectContinue;
    }

    public void setReuseChannel(boolean reuseChannel) {
        this.reuseChannel = reuseChannel;
    }

    public boolean isConnectAllowed() {
        return this.allowConnect;
    }

    public void setConnectAllowed(boolean allowConnect) {
        this.allowConnect = allowConnect;
    }

    public void attachChannel(Channel channel, boolean reuseChannel) {
        if (this.isDone()) {
            Channels.silentlyCloseChannel(channel);
        }
        this.channel = channel;
        this.reuseChannel = reuseChannel;
    }

    public Channel channel() {
        return this.channel;
    }

    public boolean reuseChannel() {
        return this.reuseChannel;
    }

    public boolean canRetry() {
        return this.maxRetry > 0 && this.currentRetry.incrementAndGet() <= this.maxRetry;
    }

    public SocketAddress getChannelRemoteAddress() {
        return this.channel != null ? this.channel.getRemoteAddress() : null;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public boolean canBeReplayed() {
        return !this.isDone() && this.canRetry() && (!Channels.isChannelValid(this.channel) || this.uri.getScheme().equalsIgnoreCase("https")) && !this.isInAuth();
    }

    public long getStart() {
        return this.start;
    }

    public Object getPartitionKey() {
        return this.connectionPoolPartitioning.getPartitionKey(this.uri, this.proxyServer);
    }

    public String toString() {
        return "NettyResponseFuture{currentRetry=" + this.currentRetry + ",\n\tisDone=" + this.isDone + ",\n\tisCancelled=" + this.isCancelled + ",\n\tasyncHandler=" + this.asyncHandler + ",\n\tnettyRequest=" + this.nettyRequest + ",\n\tcontent=" + this.content + ",\n\turi=" + this.uri + ",\n\tkeepAlive=" + this.keepAlive + ",\n\thttpHeaders=" + this.httpHeaders + ",\n\texEx=" + this.exEx + ",\n\tredirectCount=" + this.redirectCount + ",\n\ttimeoutsHolder=" + this.timeoutsHolder + ",\n\tinAuth=" + this.inAuth + ",\n\tstatusReceived=" + this.statusReceived + ",\n\ttouch=" + this.touch + '}';
    }

    public static enum STATE {
        NEW,
        POOLED,
        RECONNECTED,
        CLOSED;

    }
}

