# -*- coding: utf-8 -*-
#
# This file was automatically generated.
#
from datetime import datetime
from typing import Optional

from .amount_data import AmountData
from .dcc_data import DccData
from .payment_references import PaymentReferences
from .terminal_data import TerminalData

from worldline.acquiring.sdk.domain.data_object import DataObject


class ApiCaptureRequest(DataObject):

    __amount: Optional[AmountData] = None
    __capture_sequence_number: Optional[int] = None
    __dynamic_currency_conversion: Optional[DccData] = None
    __is_final: Optional[bool] = None
    __operation_id: Optional[str] = None
    __references: Optional[PaymentReferences] = None
    __terminal_data: Optional[TerminalData] = None
    __transaction_timestamp: Optional[datetime] = None

    @property
    def amount(self) -> Optional[AmountData]:
        """
        | Amount to capture. If not provided, the full amount will be captured.

        Type: :class:`worldline.acquiring.sdk.v1.domain.amount_data.AmountData`
        """
        return self.__amount

    @amount.setter
    def amount(self, value: Optional[AmountData]) -> None:
        self.__amount = value

    @property
    def capture_sequence_number(self) -> Optional[int]:
        """
        | The index of the partial capture. Not needed for full capture.

        Type: int
        """
        return self.__capture_sequence_number

    @capture_sequence_number.setter
    def capture_sequence_number(self, value: Optional[int]) -> None:
        self.__capture_sequence_number = value

    @property
    def dynamic_currency_conversion(self) -> Optional[DccData]:
        """
        | Dynamic Currency Conversion (DCC) rate data from DCC lookup response.
        | Mandatory for DCC transactions.

        Type: :class:`worldline.acquiring.sdk.v1.domain.dcc_data.DccData`
        """
        return self.__dynamic_currency_conversion

    @dynamic_currency_conversion.setter
    def dynamic_currency_conversion(self, value: Optional[DccData]) -> None:
        self.__dynamic_currency_conversion = value

    @property
    def is_final(self) -> Optional[bool]:
        """
        | Indicates whether this partial capture is the final one.
        | Not needed for full capture.

        Type: bool
        """
        return self.__is_final

    @is_final.setter
    def is_final(self, value: Optional[bool]) -> None:
        self.__is_final = value

    @property
    def operation_id(self) -> Optional[str]:
        """
        | A globally unique identifier of the operation, generated by you.
        | We advise you to submit a UUID or an identifier composed of an arbitrary string and a UUID/URL-safe Base64 UUID (RFC 4648 §5).
        | It's used to detect duplicate requests or to reference an operation in technical reversals.

        Type: str
        """
        return self.__operation_id

    @operation_id.setter
    def operation_id(self, value: Optional[str]) -> None:
        self.__operation_id = value

    @property
    def references(self) -> Optional[PaymentReferences]:
        """
        | Payment References

        Type: :class:`worldline.acquiring.sdk.v1.domain.payment_references.PaymentReferences`
        """
        return self.__references

    @references.setter
    def references(self, value: Optional[PaymentReferences]) -> None:
        self.__references = value

    @property
    def terminal_data(self) -> Optional[TerminalData]:
        """
        Type: :class:`worldline.acquiring.sdk.v1.domain.terminal_data.TerminalData`
        """
        return self.__terminal_data

    @terminal_data.setter
    def terminal_data(self, value: Optional[TerminalData]) -> None:
        self.__terminal_data = value

    @property
    def transaction_timestamp(self) -> Optional[datetime]:
        """
        | Timestamp of transaction in ISO 8601 format (YYYY-MM-DDThh:mm:ss+TZD)
        | It can be expressed in merchant time zone (ex: 2023-10-10T08:00+02:00) or in UTC (ex: 2023-10-10T08:00Z)

        Type: datetime
        """
        return self.__transaction_timestamp

    @transaction_timestamp.setter
    def transaction_timestamp(self, value: Optional[datetime]) -> None:
        self.__transaction_timestamp = value

    def to_dictionary(self) -> dict:
        dictionary = super(ApiCaptureRequest, self).to_dictionary()
        if self.amount is not None:
            dictionary['amount'] = self.amount.to_dictionary()
        if self.capture_sequence_number is not None:
            dictionary['captureSequenceNumber'] = self.capture_sequence_number
        if self.dynamic_currency_conversion is not None:
            dictionary['dynamicCurrencyConversion'] = self.dynamic_currency_conversion.to_dictionary()
        if self.is_final is not None:
            dictionary['isFinal'] = self.is_final
        if self.operation_id is not None:
            dictionary['operationId'] = self.operation_id
        if self.references is not None:
            dictionary['references'] = self.references.to_dictionary()
        if self.terminal_data is not None:
            dictionary['terminalData'] = self.terminal_data.to_dictionary()
        if self.transaction_timestamp is not None:
            dictionary['transactionTimestamp'] = DataObject.format_datetime(self.transaction_timestamp)
        return dictionary

    def from_dictionary(self, dictionary: dict) -> 'ApiCaptureRequest':
        super(ApiCaptureRequest, self).from_dictionary(dictionary)
        if 'amount' in dictionary:
            if not isinstance(dictionary['amount'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['amount']))
            value = AmountData()
            self.amount = value.from_dictionary(dictionary['amount'])
        if 'captureSequenceNumber' in dictionary:
            self.capture_sequence_number = dictionary['captureSequenceNumber']
        if 'dynamicCurrencyConversion' in dictionary:
            if not isinstance(dictionary['dynamicCurrencyConversion'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['dynamicCurrencyConversion']))
            value = DccData()
            self.dynamic_currency_conversion = value.from_dictionary(dictionary['dynamicCurrencyConversion'])
        if 'isFinal' in dictionary:
            self.is_final = dictionary['isFinal']
        if 'operationId' in dictionary:
            self.operation_id = dictionary['operationId']
        if 'references' in dictionary:
            if not isinstance(dictionary['references'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['references']))
            value = PaymentReferences()
            self.references = value.from_dictionary(dictionary['references'])
        if 'terminalData' in dictionary:
            if not isinstance(dictionary['terminalData'], dict):
                raise TypeError('value \'{}\' is not a dictionary'.format(dictionary['terminalData']))
            value = TerminalData()
            self.terminal_data = value.from_dictionary(dictionary['terminalData'])
        if 'transactionTimestamp' in dictionary:
            self.transaction_timestamp = DataObject.parse_datetime(dictionary['transactionTimestamp'])
        return self
