# Copyright (c) 2015, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

from mixbox import fields

import stix.bindings.ttp as ttp_binding
from stix.common.related import GenericRelationshipList, RelatedExploitTarget


class ExploitTargets(GenericRelationshipList):
    _namespace = "http://docs.oasis-open.org/cti/ns/stix/ttp-1"
    _binding = ttp_binding
    _binding_class = _binding.ExploitTargetsType

    exploit_target = fields.TypedField("Exploit_Target", RelatedExploitTarget, multiple=True, key_name="exploit_targets")
