# Copyright (c) 2015, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Apr 11 15:06:23 2013 by generateDS.py version 2.9a.
#

import sys

from mixbox.binding_utils import *

from stix.bindings import lookup_extension, register_extension
import stix.bindings.stix_common as stix_common_binding
import stix.bindings.data_marking as data_marking_binding

XML_NS = "http://docs.oasis-open.org/cti/ns/stix/exploit-target-1"

#
# Data representation classes.
#

class VulnerabilityType(GeneratedsSuper):
    """Characterizes an individual vulnerability.In addition to capturing
    basic information and references to vulnerability registries,
    this type is intended to be extended to enable the structured
    description of a vulnerability by using the XML Schema extension
    feature. The STIX default extension uses the Common
    Vulnerability Reporting Format (CVRF) schema to do so. The
    extension that defines this is captured in the
    CVRF1.1InstanceType in the
    http://docs.oasis-open.org/cti/ns/stix/extensions/vulnerability/cvrf-1
    namespace. This type is defined in the
    extensions/vulnerability/cvrf_1.1_vulnerability.xsd file or at
    the URL http://docs.oasis-open.org/cti/stix/v1.2.1/csd01/xml-schemas/
    extensions/vulnerability/cvrf-1.1-vulnerability.xsd. The @is_known field
    captures whether or not the vulnerability is known (i.e. not a
    0-day) at the time of characterization.The
    @is_publicly_acknowledged field captures whether or not the
    vulnerability is publicly acknowledged by the vendor."""
    subclass = None
    superclass = None
    def __init__(self, is_publicly_acknowledged=None, is_known=None, Title=None, Description=None, Short_Description=None, CVE_ID=None, OSVDB_ID=None, Source=None, CVSS_Score=None, Discovered_DateTime=None, Published_DateTime=None, Affected_Software=None, References=None):
        self.is_publicly_acknowledged = _cast(bool, is_publicly_acknowledged)
        self.is_known = _cast(bool, is_known)
        self.Title = Title
        if Description is None:
            self.Description = []
        else:
            self.Description = Description

        if Short_Description is None:
            self.Short_Description = []
        else:
            self.Short_Description = Short_Description
        self.CVE_ID = CVE_ID
        self.OSVDB_ID = OSVDB_ID
        self.Source = Source
        self.CVSS_Score = CVSS_Score
        self.Discovered_DateTime = Discovered_DateTime
        self.Published_DateTime = Published_DateTime
        self.Affected_Software = Affected_Software
        self.References = References
    def factory(*args_, **kwargs_):
        if VulnerabilityType.subclass:
            return VulnerabilityType.subclass(*args_, **kwargs_)
        else:
            return VulnerabilityType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Title(self): return self.Title
    def set_Title(self, Title): self.Title = Title
    def insert_Description(self, index, value): self.Description[index] = value
    def add_Description(self, Description): self.Description.append(Description)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def insert_Short_Description(self, index, value): self.Short_Description[index] = value
    def add_Short_Description(self, Short_Description): self.Short_Description.append(Short_Description)
    def get_Short_Description(self): return self.Short_Description
    def set_Short_Description(self, Short_Description): self.Short_Description = Short_Description
    def get_CVE_ID(self): return self.CVE_ID
    def set_CVE_ID(self, CVE_ID): self.CVE_ID = CVE_ID
    def get_OSVDB_ID(self): return self.OSVDB_ID
    def set_OSVDB_ID(self, OSVDB_ID): self.OSVDB_ID = OSVDB_ID
    def get_Source(self): return self.Source
    def set_Source(self, Source): self.Source = Source
    def get_CVSS_Score(self): return self.CVSS_Score
    def set_CVSS_Score(self, CVSS_Score): self.CVSS_Score = CVSS_Score
    def get_Discovered_DateTime(self): return self.Discovered_DateTime
    def set_Discovered_DateTime(self, Discovered_DateTime): self.Discovered_DateTime = Discovered_DateTime
    def get_Published_DateTime(self): return self.Published_DateTime
    def set_Published_DateTime(self, Published_DateTime): self.Published_DateTime = Published_DateTime
    def get_Affected_Software(self): return self.Affected_Software
    def set_Affected_Software(self, Affected_Software): self.Affected_Software = Affected_Software
    def get_References(self): return self.References
    def set_References(self, References): self.References = References
    def get_is_publicly_acknowledged(self): return self.is_publicly_acknowledged
    def set_is_publicly_acknowledged(self, is_publicly_acknowledged): self.is_publicly_acknowledged = is_publicly_acknowledged
    def get_is_known(self): return self.is_known
    def set_is_known(self, is_known): self.is_known = is_known
    def hasContent_(self):
        if (
            self.Title is not None or
            self.Description or
            self.Short_Description or
            self.CVE_ID is not None or
            self.OSVDB_ID is not None or
            self.Source is not None or
            self.CVSS_Score is not None or
            self.Discovered_DateTime is not None or
            self.Published_DateTime is not None or
            self.Affected_Software is not None or
            self.References is not None
            ):
            return True
        else:
            return False
    def export(self, lwrite, level, nsmap, namespace_=XML_NS, name_='VulnerabilityType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(lwrite, level, pretty_print)
        lwrite('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(lwrite, level, already_processed, namespace_, name_='VulnerabilityType')
        if self.hasContent_():
            lwrite('>%s' % (eol_, ))
            self.exportChildren(lwrite, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(lwrite, level, pretty_print)
            lwrite('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            lwrite('/>%s' % (eol_, ))
    def exportAttributes(self, lwrite, level, already_processed, namespace_='et:', name_='VulnerabilityType'):
        if self.is_publicly_acknowledged is not None and 'is_publicly_acknowledged' not in already_processed:
            already_processed.add('is_publicly_acknowledged')
            lwrite(' is_publicly_acknowledged="%s"' % self.gds_format_boolean(self.is_publicly_acknowledged, input_name='is_publicly_acknowledged'))
        if self.is_known is not None and 'is_known' not in already_processed:
            already_processed.add('is_known')
            lwrite(' is_known="%s"' % self.gds_format_boolean(self.is_known, input_name='is_known'))
    def exportChildren(self, lwrite, level, nsmap, namespace_=XML_NS, name_='VulnerabilityType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Title is not None:
            showIndent(lwrite, level, pretty_print)
            lwrite('<%s:Title>%s</%s:Title>%s' % (nsmap[namespace_], quote_xml(self.Title), nsmap[namespace_], eol_))
        for Description in self.Description:
            Description.export(lwrite, level, nsmap, namespace_, name_='Description', pretty_print=pretty_print)
        for Short_Description in self.Short_Description:
            Short_Description.export(lwrite, level, nsmap, namespace_, name_='Short_Description', pretty_print=pretty_print)
        if self.CVE_ID is not None:
            showIndent(lwrite, level, pretty_print)
            lwrite('<%s:CVE_ID>%s</%s:CVE_ID>%s' % (nsmap[namespace_],quote_xml(self.CVE_ID), nsmap[namespace_], eol_))
        if self.OSVDB_ID is not None:
            showIndent(lwrite, level, pretty_print)
            lwrite('<%s:OSVDB_ID>%s</%s:OSVDB_ID>%s' % (nsmap[namespace_],self.gds_format_integer(self.OSVDB_ID, input_name='OSVDB_ID'), nsmap[namespace_], eol_))
        if self.Source is not None:
            showIndent(lwrite, level, pretty_print)
            lwrite('<%s:Source>%s</%s:Source>%s' % (nsmap[namespace_],quote_xml(self.Source), nsmap[namespace_], eol_))
        if self.CVSS_Score is not None:
            self.CVSS_Score.export(lwrite, level, nsmap, namespace_, name_='CVSS_Score', pretty_print=pretty_print)
        if self.Discovered_DateTime is not None:
            self.Discovered_DateTime.export(lwrite, level, nsmap, namespace_, name_='Discovered_DateTime', pretty_print=pretty_print)
        if self.Published_DateTime is not None:
            self.Published_DateTime.export(lwrite, level, nsmap, namespace_, name_='Published_DateTime', pretty_print=pretty_print)
        if self.Affected_Software is not None:
            self.Affected_Software.export(lwrite, level, nsmap, namespace_, name_='Affected_Software', pretty_print=pretty_print)
        if self.References is not None:
            self.References.export(lwrite, level, nsmap, namespace_, name_='References', pretty_print=pretty_print)
    def build(self, node):
        self.__sourcenode__ = node
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('is_publicly_acknowledged', node)
        if value is not None and 'is_publicly_acknowledged' not in already_processed:
            already_processed.add('is_publicly_acknowledged')
            if value in ('true', '1'):
                self.is_publicly_acknowledged = True
            elif value in ('false', '0'):
                self.is_publicly_acknowledged = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('is_known', node)
        if value is not None and 'is_known' not in already_processed:
            already_processed.add('is_known')
            if value in ('true', '1'):
                self.is_known = True
            elif value in ('false', '0'):
                self.is_known = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Title':
            Title_ = child_.text
            Title_ = self.gds_validate_string(Title_, node, 'Title')
            self.Title = Title_
        elif nodeName_ == 'Description':
            obj_ = stix_common_binding.StructuredTextType.factory()
            obj_.build(child_)
            self.add_Description(obj_)
        elif nodeName_ == 'Short_Description':
            obj_ = stix_common_binding.StructuredTextType.factory()
            obj_.build(child_)
            self.add_Short_Description(obj_)
        elif nodeName_ == 'CVE_ID':
            CVE_ID_ = child_.text
            CVE_ID_ = self.gds_validate_string(CVE_ID_, node, 'CVE_ID')
            self.CVE_ID = CVE_ID_
        elif nodeName_ == 'OSVDB_ID':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'OSVDB_ID')
            self.OSVDB_ID = ival_
        elif nodeName_ == 'Source':
            Source_ = child_.text
            Source_ = self.gds_validate_string(Source_, node, 'Source')
            self.Source = Source_
        elif nodeName_ == 'CVSS_Score':
            obj_ = CVSSVectorType.factory()
            obj_.build(child_)
            self.set_CVSS_Score(obj_)
        elif nodeName_ == 'Discovered_DateTime':
            obj_ = stix_common_binding.DateTimeWithPrecisionType.factory()
            obj_.build(child_)
            self.set_Discovered_DateTime(obj_)
        elif nodeName_ == 'Published_DateTime':
            obj_ = stix_common_binding.DateTimeWithPrecisionType.factory()
            obj_.build(child_)
            self.set_Published_DateTime(obj_)
        elif nodeName_ == 'Affected_Software':
            obj_ = AffectedSoftwareType.factory()
            obj_.build(child_)
            self.set_Affected_Software(obj_)
        elif nodeName_ == 'References':
            obj_ = stix_common_binding.ReferencesType.factory()
            obj_.build(child_)
            self.set_References(obj_)
# end class VulnerabilityType

class ConfigurationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Description=None, Short_Description=None, CCE_ID=None):
        if Description is None:
            self.Description = []
        else:
            self.Description = Description

        if Short_Description is None:
            self.Short_Description = []
        else:
            self.Short_Description = Short_Description

        self.CCE_ID = CCE_ID
    def factory(*args_, **kwargs_):
        if ConfigurationType.subclass:
            return ConfigurationType.subclass(*args_, **kwargs_)
        else:
            return ConfigurationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def insert_Description(self, index, value): self.Description[index] = value
    def add_Description(self, Description): self.Description.append(Description)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def insert_Short_Description(self, index, value): self.Short_Description[index] = value
    def add_Short_Description(self, Short_Description): self.Short_Description.append(Short_Description)
    def get_Short_Description(self): return self.Short_Description
    def set_Short_Description(self, Short_Description): self.Short_Description = Short_Description
    def get_CCE_ID(self): return self.CCE_ID
    def set_CCE_ID(self, CCE_ID): self.CCE_ID = CCE_ID
    def hasContent_(self):
        if (
            self.Description or
            self.Short_Description or
            self.CCE_ID is not None
            ):
            return True
        else:
            return False
    def export(self, lwrite, level, nsmap, namespace_=XML_NS, name_='ConfigurationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(lwrite, level, pretty_print)
        lwrite('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(lwrite, level, already_processed, namespace_, name_='ConfigurationType')
        if self.hasContent_():
            lwrite('>%s' % (eol_, ))
            self.exportChildren(lwrite, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(lwrite, level, pretty_print)
            lwrite('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            lwrite('/>%s' % (eol_, ))
    def exportAttributes(self, lwrite, level, already_processed, namespace_='et:', name_='ConfigurationType'):
        pass
    def exportChildren(self, lwrite, level, nsmap, namespace_=XML_NS, name_='ConfigurationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Description in self.Description:
            Description.export(lwrite, level, nsmap, namespace_, name_='Description', pretty_print=pretty_print)
        for Short_Description in self.Short_Description:
            Short_Description.export(lwrite, level, nsmap, namespace_, name_='Short_Description', pretty_print=pretty_print)
        if self.CCE_ID is not None:
            showIndent(lwrite, level, pretty_print)
            lwrite('<%s:CCE_ID>%s</%s:CCE_ID>%s' % (nsmap[namespace_], quote_xml(self.CCE_ID), nsmap[namespace_], eol_))
    def build(self, node):
        self.__sourcenode__ = node
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            obj_ = stix_common_binding.StructuredTextType.factory()
            obj_.build(child_)
            self.add_Description(obj_)
        if nodeName_ == 'Short_Description':
            obj_ = stix_common_binding.StructuredTextType.factory()
            obj_.build(child_)
            self.add_Short_Description(obj_)
        elif nodeName_ == 'CCE_ID':
            CCE_ID_ = child_.text
            CCE_ID_ = self.gds_validate_string(CCE_ID_, node, 'CCE_ID')
            self.CCE_ID = CCE_ID_
# end class ConfigurationType

class AffectedSoftwareType(stix_common_binding.GenericRelationshipListType):
    subclass = None
    superclass = stix_common_binding.GenericRelationshipListType
    def __init__(self, scope='exclusive', Affected_Software=None):
        super(AffectedSoftwareType, self).__init__(scope=scope)
        if Affected_Software is None:
            self.Affected_Software = []
        else:
            self.Affected_Software = Affected_Software
    def factory(*args_, **kwargs_):
        if AffectedSoftwareType.subclass:
            return AffectedSoftwareType.subclass(*args_, **kwargs_)
        else:
            return AffectedSoftwareType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Affected_Software(self): return self.Affected_Software
    def set_Affected_Software(self, Affected_Software): self.Affected_Software = Affected_Software
    def add_Affected_Software(self, value): self.Affected_Software.append(value)
    def insert_Affected_Software(self, index, value): self.Affected_Software[index] = value
    def hasContent_(self):
        if (
            self.Affected_Software or
            super(AffectedSoftwareType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, lwrite, level, nsmap, namespace_=XML_NS, name_='AffectedSoftwareType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(lwrite, level, pretty_print)
        lwrite('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(lwrite, level, already_processed, namespace_, name_='AffectedSoftwareType')
        if self.hasContent_():
            lwrite('>%s' % (eol_, ))
            self.exportChildren(lwrite, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(lwrite, level, pretty_print)
            lwrite('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            lwrite('/>%s' % (eol_, ))
    def exportAttributes(self, lwrite, level, already_processed, namespace_='et:', name_='AffectedSoftwareType'):
        super(AffectedSoftwareType, self).exportAttributes(lwrite, level, already_processed, namespace_, name_='AffectedSoftwareType')
    def exportChildren(self, lwrite, level, nsmap, namespace_=XML_NS, name_='AffectedSoftwareType', fromsubclass_=False, pretty_print=True):
        super(AffectedSoftwareType, self).exportChildren(lwrite, level, nsmap, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Affected_Software_ in self.Affected_Software:
            Affected_Software_.export(lwrite, level, nsmap, namespace_, name_='Affected_Software', pretty_print=pretty_print)
    def build(self, node):
        self.__sourcenode__ = node
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(AffectedSoftwareType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Affected_Software':
            obj_ = stix_common_binding.RelatedObservableType.factory()
            obj_.build(child_)
            self.Affected_Software.append(obj_)
        super(AffectedSoftwareType, self).buildChildren(child_, node, nodeName_, True)
# end class AffectedSoftwareType

class RelatedExploitTargetsType(stix_common_binding.GenericRelationshipListType):
    subclass = None
    superclass = stix_common_binding.GenericRelationshipListType
    def __init__(self, scope='exclusive', Related_Exploit_Target=None):
        super(RelatedExploitTargetsType, self).__init__(scope=scope)
        if Related_Exploit_Target is None:
            self.Related_Exploit_Target = []
        else:
            self.Related_Exploit_Target = Related_Exploit_Target
    def factory(*args_, **kwargs_):
        if RelatedExploitTargetsType.subclass:
            return RelatedExploitTargetsType.subclass(*args_, **kwargs_)
        else:
            return RelatedExploitTargetsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Related_Exploit_Target(self): return self.Related_Exploit_Target
    def set_Related_Exploit_Target(self, Related_Exploit_Target): self.Related_Exploit_Target = Related_Exploit_Target
    def add_Related_Exploit_Target(self, value): self.Related_Exploit_Target.append(value)
    def insert_Related_Exploit_Target(self, index, value): self.Related_Exploit_Target[index] = value
    def hasContent_(self):
        if (
            self.Related_Exploit_Target or
            super(RelatedExploitTargetsType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, lwrite, level, nsmap, namespace_=XML_NS, name_='RelatedExploitTargetsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(lwrite, level, pretty_print)
        lwrite('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(lwrite, level, already_processed, namespace_, name_='RelatedExploitTargetsType')
        if self.hasContent_():
            lwrite('>%s' % (eol_, ))
            self.exportChildren(lwrite, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(lwrite, level, pretty_print)
            lwrite('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            lwrite('/>%s' % (eol_, ))
    def exportAttributes(self, lwrite, level, already_processed, namespace_='et:', name_='RelatedExploitTargetsType'):
        super(RelatedExploitTargetsType, self).exportAttributes(lwrite, level, already_processed, namespace_, name_='RelatedExploitTargetsType')
    def exportChildren(self, lwrite, level, nsmap, namespace_=XML_NS, name_='RelatedExploitTargetsType', fromsubclass_=False, pretty_print=True):
        super(RelatedExploitTargetsType, self).exportChildren(lwrite, level, nsmap, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Related_Exploit_Target_ in self.Related_Exploit_Target:
            Related_Exploit_Target_.export(lwrite, level, nsmap, namespace_, name_='Related_Exploit_Target', pretty_print=pretty_print)
    def build(self, node):
        self.__sourcenode__ = node
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RelatedExploitTargetsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Related_Exploit_Target':
            obj_ = stix_common_binding.RelatedExploitTargetType.factory()
            obj_.build(child_)
            self.Related_Exploit_Target.append(obj_)
        super(RelatedExploitTargetsType, self).buildChildren(child_, node, nodeName_, True)
# end class RelatedExploitTargetsType


class WeaknessType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Description=None, CWE_ID=None):
        if Description is None:
            self.Description = []
        else:
            self.Description = Description
        self.CWE_ID = CWE_ID
    def factory(*args_, **kwargs_):
        if WeaknessType.subclass:
            return WeaknessType.subclass(*args_, **kwargs_)
        else:
            return WeaknessType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def insert_Description(self, index, value): self.Description[index] = value
    def add_Description(self, Description): self.Description.append(Description)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def get_CWE_ID(self): return self.CWE_ID
    def set_CWE_ID(self, CWE_ID): self.CWE_ID = CWE_ID
    def hasContent_(self):
        if (
            self.Description or
            self.CWE_ID is not None
            ):
            return True
        else:
            return False
    def export(self, lwrite, level, nsmap, namespace_=XML_NS, name_='WeaknessType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(lwrite, level, pretty_print)
        lwrite('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(lwrite, level, already_processed, namespace_, name_='WeaknessType')
        if self.hasContent_():
            lwrite('>%s' % (eol_, ))
            self.exportChildren(lwrite, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(lwrite, level, pretty_print)
            lwrite('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            lwrite('/>%s' % (eol_, ))
    def exportAttributes(self, lwrite, level, already_processed, namespace_='et:', name_='WeaknessType'):
        pass
    def exportChildren(self, lwrite, level, nsmap, namespace_=XML_NS, name_='WeaknessType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Description in self.Description:
            Description.export(lwrite, level, nsmap, namespace_, name_='Description', pretty_print=pretty_print)
        if self.CWE_ID is not None:
            showIndent(lwrite, level, pretty_print)
            lwrite('<%s:CWE_ID>%s</%s:CWE_ID>%s' % (nsmap[namespace_], quote_xml(self.CWE_ID), nsmap[namespace_], eol_))
    def build(self, node):
        self.__sourcenode__ = node
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Description':
            obj_ = stix_common_binding.StructuredTextType.factory()
            obj_.build(child_)
            self.add_Description(obj_)
        elif nodeName_ == 'CWE_ID':
            CWE_ID_ = child_.text
            CWE_ID_ = self.gds_validate_string(CWE_ID_, node, 'CWE_ID')
            self.CWE_ID = CWE_ID_
# end class WeaknessType

class CVSSVectorType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, Overall_Score=None, Base_Score=None, Base_Vector=None, Temporal_Score=None, Temporal_Vector=None, Environmental_Score=None, Environmental_Vector=None):
        self.Overall_Score = Overall_Score
        self.Base_Score = Base_Score
        self.Base_Vector = Base_Vector
        self.Temporal_Score = Temporal_Score
        self.Temporal_Vector = Temporal_Vector
        self.Environmental_Score = Environmental_Score
        self.Environmental_Vector = Environmental_Vector
    def factory(*args_, **kwargs_):
        if CVSSVectorType.subclass:
            return CVSSVectorType.subclass(*args_, **kwargs_)
        else:
            return CVSSVectorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Overall_Score(self): return self.Overall_Score
    def set_Overall_Score(self, Overall_Score): self.Overall_Score = Overall_Score
    def validate_CVSSScoreType(self, value):
        # Validate type CVSSScoreType, a restriction on xs:string.
        pass
    def get_Base_Score(self): return self.Base_Score
    def set_Base_Score(self, Base_Score): self.Base_Score = Base_Score
    def get_Base_Vector(self): return self.Base_Vector
    def set_Base_Vector(self, Base_Vector): self.Base_Vector = Base_Vector
    def validate_CVSSBaseVectorType(self, value):
        # Validate type CVSSBaseVectorType, a restriction on xs:string.
        pass
    def get_Temporal_Score(self): return self.Temporal_Score
    def set_Temporal_Score(self, Temporal_Score): self.Temporal_Score = Temporal_Score
    def get_Temporal_Vector(self): return self.Temporal_Vector
    def set_Temporal_Vector(self, Temporal_Vector): self.Temporal_Vector = Temporal_Vector
    def validate_CVSSTemporalVectorType(self, value):
        # Validate type CVSSTemporalVectorType, a restriction on xs:string.
        pass
    def get_Environmental_Score(self): return self.Environmental_Score
    def set_Environmental_Score(self, Environmental_Score): self.Environmental_Score = Environmental_Score
    def get_Environmental_Vector(self): return self.Environmental_Vector
    def set_Environmental_Vector(self, Environmental_Vector): self.Environmental_Vector = Environmental_Vector
    def validate_CVSSEnvironmentalVectorType(self, value):
        # Validate type CVSSEnvironmentalVectorType, a restriction on xs:string.
        pass
    def hasContent_(self):
        if (
            self.Overall_Score is not None or
            self.Base_Score is not None or
            self.Base_Vector is not None or
            self.Temporal_Score is not None or
            self.Temporal_Vector is not None or
            self.Environmental_Score is not None or
            self.Environmental_Vector is not None
            ):
            return True
        else:
            return False
    def export(self, lwrite, level, nsmap, namespace_=XML_NS, name_='CVSSVectorType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(lwrite, level, pretty_print)
        lwrite('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(lwrite, level, already_processed, namespace_, name_='CVSSVectorType')
        if self.hasContent_():
            lwrite('>%s' % (eol_, ))
            self.exportChildren(lwrite, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(lwrite, level, pretty_print)
            lwrite('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            lwrite('/>%s' % (eol_, ))
    def exportAttributes(self, lwrite, level, already_processed, namespace_='et:', name_='CVSSVectorType'):
        pass
    def exportChildren(self, lwrite, level, nsmap, namespace_=XML_NS, name_='CVSSVectorType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Overall_Score is not None:
            lwrite('<%s:Overall_Score>%s</%s:Overall_Score>%s' % (nsmap[namespace_], quote_xml(self.Overall_Score), nsmap[namespace_], eol_))
        if self.Base_Score is not None:
            lwrite('<%s:Base_Score>%s</%s:Base_Score>%s' % (nsmap[namespace_], quote_xml(self.Base_Score), nsmap[namespace_], eol_))
        if self.Base_Vector is not None:
            lwrite('<%s:Base_Vector>%s</%s:Base_Vector>%s' % (nsmap[namespace_], quote_xml(self.Base_Vector), nsmap[namespace_], eol_))
        if self.Temporal_Score is not None:
            lwrite('<%s:Temporal_Score>%s</%s:Temporal_Score>%s' % (nsmap[namespace_], quote_xml(self.Temporal_Score), nsmap[namespace_], eol_))
        if self.Temporal_Vector is not None:
            lwrite('<%s:Temporal_Vector>%s</%s:Temporal_Vector>%s' % (nsmap[namespace_], quote_xml(self.Temporal_Vector), nsmap[namespace_], eol_))
        if self.Environmental_Score is not None:
            lwrite('<%s:Environmental_Score>%s</%s:Environmental_Score>%s' % (nsmap[namespace_], quote_xml(self.Environmental_Score), nsmap[namespace_], eol_))
        if self.Environmental_Vector is not None:
            lwrite('<%s:Environmental_Vector>%s</%s:Environmental_Vector>%s' % (nsmap[namespace_], quote_xml(self.Environmental_Vector), nsmap[namespace_], eol_))
    def build(self, node):
        self.__sourcenode__ = node
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Overall_Score':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'Overall_Score')
            self.set_Overall_Score(text_)
        elif nodeName_ == 'Base_Score':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'Base_Score')
            self.set_Base_Score(text_)
        elif nodeName_ == 'Base_Vector':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'Base_Vector')
            self.set_Base_Vector(text_)
        elif nodeName_ == 'Temporal_Score':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'Temporal_Score')
            self.set_Temporal_Score(text_)
        elif nodeName_ == 'Temporal_Vector':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'Temporal_Vector')
            self.set_Temporal_Vector(text_)
        elif nodeName_ == 'Environmental_Score':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'Environmental_Score')
            self.set_Environmental_Score(text_)
        elif nodeName_ == 'Environmental_Vector':
            text_ = child_.text
            text_ = self.gds_validate_string(text_, node, 'Environmental_Vector')
            self.set_Environmental_Vector(text_)
# end class CVSSVectorType

class PotentialCOAsType(stix_common_binding.GenericRelationshipListType):
    subclass = None
    superclass = stix_common_binding.GenericRelationshipListType
    def __init__(self, scope='exclusive', Potential_COA=None):
        super(PotentialCOAsType, self).__init__(scope=scope)
        if Potential_COA is None:
            self.Potential_COA = []
        else:
            self.Potential_COA = Potential_COA
    def factory(*args_, **kwargs_):
        if PotentialCOAsType.subclass:
            return PotentialCOAsType.subclass(*args_, **kwargs_)
        else:
            return PotentialCOAsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Potential_COA(self): return self.Potential_COA
    def set_Potential_COA(self, Potential_COA): self.Potential_COA = Potential_COA
    def add_Potential_COA(self, value): self.Potential_COA.append(value)
    def insert_Potential_COA(self, index, value): self.Potential_COA[index] = value
    def hasContent_(self):
        if (
            self.Potential_COA or
            super(PotentialCOAsType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, lwrite, level, nsmap, namespace_=XML_NS, name_='PotentialCOAsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(lwrite, level, pretty_print)
        lwrite('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(lwrite, level, already_processed, namespace_, name_='PotentialCOAsType')
        if self.hasContent_():
            lwrite('>%s' % (eol_, ))
            self.exportChildren(lwrite, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(lwrite, level, pretty_print)
            lwrite('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            lwrite('/>%s' % (eol_, ))
    def exportAttributes(self, lwrite, level, already_processed, namespace_='et:', name_='PotentialCOAsType'):
        super(PotentialCOAsType, self).exportAttributes(lwrite, level, already_processed, namespace_, name_='PotentialCOAsType')
    def exportChildren(self, lwrite, level, nsmap, namespace_=XML_NS, name_='PotentialCOAsType', fromsubclass_=False, pretty_print=True):
        super(PotentialCOAsType, self).exportChildren(lwrite, level, nsmap, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Potential_COA_ in self.Potential_COA:
            Potential_COA_.export(lwrite, level, nsmap, namespace_, name_='Potential_COA', pretty_print=pretty_print)
    def build(self, node):
        self.__sourcenode__ = node
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(PotentialCOAsType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Potential_COA':
            obj_ = stix_common_binding.RelatedCourseOfActionType.factory()
            obj_.build(child_)
            self.Potential_COA.append(obj_)
        super(PotentialCOAsType, self).buildChildren(child_, node, nodeName_, True)
# end class PotentialCOAsType


@register_extension
class ExploitTargetType(stix_common_binding.ExploitTargetBaseType):
    """Specifies the relevant STIX-ExploitTarget schema version for this
    content."""
    subclass = None
    superclass = stix_common_binding.ExploitTargetBaseType

    xmlns          = "http://docs.oasis-open.org/cti/ns/stix/exploit-target-1"
    xmlns_prefix   = "et"
    xml_type       = "ExploitTargetType"
    xsi_type       = "%s:%s" % (xmlns_prefix, xml_type)

    def __init__(self, idref=None, id=None, timestamp=None, version=None, Title=None, Description=None, Short_Description=None, Vulnerability=None, Weakness=None, Configuration=None, Potential_COAs=None, Information_Source=None, Handling=None, Related_Exploit_Targets=None, Related_Packages=None):
        super(ExploitTargetType, self).__init__(timestamp=timestamp, idref=idref, id=id)

        self.version = _cast(None, version)
        self.Title = Title
        if Description is None:
            self.Description = []
        else:
            self.Description = Description
        if Short_Description is None:
            self.Short_Description = []
        else:
            self.Short_Description = Short_Description
        if Vulnerability is None:
            self.Vulnerability = []
        else:
            self.Vulnerability = Vulnerability
        if Weakness is None:
            self.Weakness = []
        else:
            self.Weakness = Weakness
        if Configuration is None:
            self.Configuration = []
        else:
            self.Configuration = Configuration
        self.Potential_COAs = Potential_COAs
        self.Information_Source = Information_Source
        self.Handling = Handling
        self.Related_Exploit_Targets = Related_Exploit_Targets
        self.Related_Packages = Related_Packages
    def factory(*args_, **kwargs_):
        if ExploitTargetType.subclass:
            return ExploitTargetType.subclass(*args_, **kwargs_)
        else:
            return ExploitTargetType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Title(self): return self.Title
    def set_Title(self, Title): self.Title = Title
    def insert_Description(self, index, value): self.Description[index] = value
    def add_Description(self, Description): self.Description.append(Description)
    def get_Description(self): return self.Description
    def set_Description(self, Description): self.Description = Description
    def insert_Short_Description(self, index, value): self.Short_Description[index] = value
    def add_Short_Description(self, Short_Description): self.Short_Description.append(Short_Description)
    def get_Short_Description(self): return self.Short_Description
    def set_Short_Description(self, Short_Description): self.Short_Description = Short_Description
    def get_Vulnerability(self): return self.Vulnerability
    def set_Vulnerability(self, Vulnerability): self.Vulnerability = Vulnerability
    def add_Vulnerability(self, value): self.Vulnerability.append(value)
    def insert_Vulnerability(self, index, value): self.Vulnerability[index] = value
    def get_Weakness(self): return self.Weakness
    def set_Weakness(self, Weakness): self.Weakness = Weakness
    def add_Weakness(self, value): self.Weakness.append(value)
    def insert_Weakness(self, index, value): self.Weakness[index] = value
    def get_Configuration(self): return self.Configuration
    def set_Configuration(self, Configuration): self.Configuration = Configuration
    def add_Configuration(self, value): self.Configuration.append(value)
    def insert_Configuration(self, index, value): self.Configuration[index] = value
    def get_Potential_COAs(self): return self.Potential_COAs
    def set_Potential_COAs(self, Potential_COAs): self.Potential_COAs = Potential_COAs
    def get_Information_Source(self): return self.Information_Source
    def set_Information_Source(self, Information_Source): self.Information_Source = Information_Source
    def get_Handling(self): return self.Handling
    def set_Handling(self, Handling): self.Handling = Handling
    def get_Related_Exploit_Targets(self): return self.Related_Exploit_Targets
    def set_Related_Exploit_Targets(self, Related_Exploit_Targets): self.Related_Exploit_Targets = Related_Exploit_Targets
    def get_Related_Packages(self): return self.Related_Packages
    def set_Related_Packages(self, Related_Packages): self.Related_Packages = Related_Packages
    def get_version(self): return self.version
    def set_version(self, version): self.version = version
    def hasContent_(self):
        if (
            self.Title is not None or
            self.Description or
            self.Short_Description or
            self.Vulnerability or
            self.Weakness or
            self.Configuration or
            self.Potential_COAs is not None or
            self.Information_Source is not None or
            self.Handling is not None or
            self.Related_Exploit_Targets is not None or
            self.Related_Packages is not None or
            super(ExploitTargetType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, lwrite, level, nsmap, namespace_=XML_NS, name_='Exploit_Target', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(lwrite, level, pretty_print)
        lwrite('<%s:%s%s' % (nsmap[namespace_], name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(lwrite, level, already_processed, namespace_, name_='Exploit_Target')
        if self.hasContent_():
            lwrite('>%s' % (eol_, ))
            self.exportChildren(lwrite, level + 1, nsmap, XML_NS, name_, pretty_print=pretty_print)
            showIndent(lwrite, level, pretty_print)
            lwrite('</%s:%s>%s' % (nsmap[namespace_], name_, eol_))
        else:
            lwrite('/>%s' % (eol_, ))
    def exportAttributes(self, lwrite, level, already_processed, namespace_='et:', name_='Exploit_Target'):
        super(ExploitTargetType, self).exportAttributes(lwrite, level, already_processed, namespace_, name_='Exploit_Target')
        #if 'xmlns' not in already_processed:
        #    already_processed.add('xmlns')
        #    xmlns = " xmlns:%s='%s'" % (self.xmlns_prefix, self.xmlns)
        #    lwrite(xmlns)
        if 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            xsi_type = " xsi:type='%s:%s'" % (self.xmlns_prefix, self.xml_type)
            lwrite(xsi_type)
        if self.version is not None and 'version' not in already_processed:
            already_processed.add('version')
            lwrite(' version=%s' % (quote_attrib(self.version), ))
    def exportChildren(self, lwrite, level, nsmap, namespace_=XML_NS, name_='ExploitTargetType', fromsubclass_=False, pretty_print=True):
        super(ExploitTargetType, self).exportChildren(lwrite, level, nsmap, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Title is not None:
            showIndent(lwrite, level, pretty_print)
            lwrite('<%s:Title>%s</%s:Title>%s' % (nsmap[namespace_],quote_xml(self.Title), nsmap[namespace_], eol_))
        for Description in self.Description:
            Description.export(lwrite, level, nsmap, namespace_, name_='Description', pretty_print=pretty_print)
        for Short_Description in self.Short_Description:
            Short_Description.export(lwrite, level, nsmap, namespace_, name_='Short_Description', pretty_print=pretty_print)
        for Vulnerability_ in self.Vulnerability:
            Vulnerability_.export(lwrite, level, nsmap, namespace_, name_='Vulnerability', pretty_print=pretty_print)
        for Weakness_ in self.Weakness:
            Weakness_.export(lwrite, level, nsmap, namespace_, name_='Weakness', pretty_print=pretty_print)
        for Configuration_ in self.Configuration:
            Configuration_.export(lwrite, level, nsmap, namespace_, name_='Configuration', pretty_print=pretty_print)
        if self.Potential_COAs is not None:
            self.Potential_COAs.export(lwrite, level, nsmap, namespace_, name_='Potential_COAs', pretty_print=pretty_print)
        if self.Information_Source is not None:
            self.Information_Source.export(lwrite, level, nsmap, namespace_, name_='Information_Source', pretty_print=pretty_print)
        if self.Handling is not None:
            self.Handling.export(lwrite, level, nsmap, namespace_, name_='Handling', pretty_print=pretty_print)
        if self.Related_Exploit_Targets is not None:
            self.Related_Exploit_Targets.export(lwrite, level, nsmap, namespace_, name_='Related_Exploit_Targets', pretty_print=pretty_print)
        if self.Related_Packages is not None:
            self.Related_Packages.export(lwrite, level, nsmap, namespace_, name_='Related_Packages', pretty_print=pretty_print)
    def build(self, node):
        self.__sourcenode__ = node
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('version', node)
        if value is not None and 'version' not in already_processed:
            already_processed.add('version')
            self.version = value
        super(ExploitTargetType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Title':
            Title_ = child_.text
            Title_ = self.gds_validate_string(Title_, node, 'Title')
            self.Title = Title_
        elif nodeName_ == 'Description':
            obj_ = stix_common_binding.StructuredTextType.factory()
            obj_.build(child_)
            self.add_Description(obj_)
        elif nodeName_ == 'Short_Description':
            obj_ = stix_common_binding.StructuredTextType.factory()
            obj_.build(child_)
            self.add_Short_Description(obj_)
        elif nodeName_ == 'Vulnerability':
            import stix.bindings.extensions.vulnerability.cvrf_1_1 as cvrf_1_1_binding
            obj_ = lookup_extension(child_, VulnerabilityType).factory()
            obj_.build(child_)
            self.Vulnerability.append(obj_)
        elif nodeName_ == 'Weakness':
            obj_ = WeaknessType.factory()
            obj_.build(child_)
            self.Weakness.append(obj_)
        elif nodeName_ == 'Configuration':
            obj_ = ConfigurationType.factory()
            obj_.build(child_)
            self.Configuration.append(obj_)
        elif nodeName_ == 'Potential_COAs':
            obj_ = PotentialCOAsType.factory()
            obj_.build(child_)
            self.set_Potential_COAs(obj_)
        elif nodeName_ == 'Information_Source':
            obj_ = stix_common_binding.InformationSourceType.factory()
            obj_.build(child_)
            self.set_Information_Source(obj_)
        elif nodeName_ == 'Handling':
            obj_ = data_marking_binding.MarkingType.factory()
            obj_.build(child_)
            self.set_Handling(obj_)
        elif nodeName_ == 'Related_Exploit_Targets':
            obj_ = RelatedExploitTargetsType.factory()
            obj_.build(child_)
            self.set_Related_Exploit_Targets(obj_)
        elif nodeName_ == 'Related_Packages':
            obj_ = stix_common_binding.RelatedPackageRefsType.factory()
            obj_.build(child_)
            self.set_Related_Packages(obj_)
        super(ExploitTargetType, self).buildChildren(child_, node, nodeName_, True)
# end class ExploitTargetType

GDSClassesMapping = {}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print(USAGE_TEXT)
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Exploit_Target'
        rootClass = ExploitTargetType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    # sys.stdout.write('<?xml version="1.0" ?>\n')
    # rootObj.export(sys.stdout, 0, name_=rootTag,
    #     namespacedef_='',
    #     pretty_print=True)
    return rootObj

def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Exploit_Target'
        rootClass = ExploitTargetType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    rootElement = rootObj.to_etree(None, name_=rootTag)
    content = etree_.tostring(rootElement, pretty_print=True,
        xml_declaration=True, encoding="utf-8")
    sys.stdout.write(content)
    sys.stdout.write('\n')
    return rootObj, rootElement

def parseString(inString):
    from mixbox.vendor.six import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Exploit_Target'
        rootClass = ExploitTargetType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    # sys.stdout.write('<?xml version="1.0" ?>\n')
    # rootObj.export(sys.stdout, 0, name_="Exploit_Target",
    #     namespacedef_='')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "VulnerabilityType",
    "ConfigurationType",
    "WeaknessType",
    "CVSSVectorType",
    "PotentialCOAsType",
    "ExploitTargetType"
    ]
