from django.db import models
from django.utils.translation import ugettext_lazy as _
from jsonfield import JSONField


PAYMENT_RECEIVED = "received"
PAYMENT_PENDING = "pending"


class MpesaPayment(models.Model):

    original = JSONField(help_text=_("A full copy of the original data received from IPN"))
    received = models.DateTimeField(auto_now_add=True)
    # This code is generated by Safaricom to identify a payment
    mpesa_code = models.CharField(_('Code'), max_length=128, help_text=_("Unique identifier for a payment. This code will be sent to the sender in the receipt."), unique=True)
    # This account number is (optionally) input by the sender
    # It accepts blank as we cannot rely on incoming IPNs
    mpesa_acc = models.CharField(_('Account'), blank=True, max_length=128, help_text=_("The account entered by the sender on their Pay Bill transaction"))
    # Amount can be overloaded by IPN to indicate non-payment notifications
    # e.g., -1 signifies withdrawls from the merchant's account
    mpesa_amt = models.DecimalField(_('Amount'), decimal_places=2, max_digits=12)

    def __unicode__(self):
        return "%s, KSh %s" % (self.mpesa_acc, self.mpesa_amt)
