#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2013, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

#
# Generated Tue Apr 09 11:14:54 2013 by generateDS.py version 2.9a.
#

import sys
import getopt
import re as re_

import cybox_common
import base64
from datetime import datetime, tzinfo, timedelta

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(tzinfo):
            def __init__(self, offset, name):
                self.__offset = timedelta(minutes = offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S')
            else:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S.%f')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_datetime(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S')
            return dt.replace(tzinfo = tz)

        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = input_data.strftime('%Y-%m-%d')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_date(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            return datetime.strptime(input_data,
                '%Y-%m-%d').replace(tzinfo = tz)
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return unicode(s1).encode(ExternalEncoding)

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return unicode(s1).encode(ExternalEncoding)

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' %
                (self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class SharedResourceType(cybox_common.BaseObjectPropertyType):
    """SharedResourceType specifies Windows shared resource types via a
    union of the SharedResourceTypeEnum type and the atomic
    xs:string type. Its base type is the CybOX Core
    cybox_common.BaseObjectPropertyType, for permitting complex (i.e. regular-
    expression based) specifications.This attribute is optional and
    specifies the expected type for the value of the specified
    property."""
    member_data_items_ = {
        'datatype': MemberSpec_('datatype', 'cyboxCommon:DatatypeEnum', 0),
        'valueOf_': MemberSpec_('valueOf_', ['SharedResourceType', 'cybox_common.BaseObjectPropertyType'], 0),
        }
    subclass = None
    superclass = cybox_common.BaseObjectPropertyType
    def __init__(self, obfuscation_algorithm_ref=None, refanging_transform_type=None, has_changed=None, pattern_type=None, datatype='string', refanging_transform=None, bit_mask=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, apply_condition='ANY', idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(SharedResourceType, self).__init__(obfuscation_algorithm_ref, refanging_transform_type, has_changed, pattern_type, datatype, refanging_transform, bit_mask, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, apply_condition, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if SharedResourceType.subclass:
            return SharedResourceType.subclass(*args_, **kwargs_)
        else:
            return SharedResourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(SharedResourceType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinNetworkShareObj:', name_='SharedResourceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SharedResourceType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(unicode(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinNetworkShareObj:', name_='SharedResourceType'):
        super(SharedResourceType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SharedResourceType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='WinNetworkShareObj:', name_='SharedResourceType', fromsubclass_=False, pretty_print=True):
        super(SharedResourceType, self).exportChildren(outfile, level, 'WinNetworkShareObj:', name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='SharedResourceType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(SharedResourceType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(SharedResourceType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            self.datatype = value
        super(SharedResourceType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class SharedResourceType

class WindowsNetworkShareObjectType(cybox_common.ObjectPropertiesType):
    """he WindowsNetworkShareObjectType type is intended to characterize
    Windows network shares."""
    member_data_items_ = {
        'ACCESS_PERM': MemberSpec_('ACCESS_PERM', 'xs:boolean', 0),
        'ACCESS_ATRIB': MemberSpec_('ACCESS_ATRIB', 'xs:boolean', 0),
        'ACCESS_ALL': MemberSpec_('ACCESS_ALL', 'xs:boolean', 0),
        'ACCESS_READ': MemberSpec_('ACCESS_READ', 'xs:boolean', 0),
        'ACCESS_DELETE': MemberSpec_('ACCESS_DELETE', 'xs:boolean', 0),
        'ACCESS_WRITE': MemberSpec_('ACCESS_WRITE', 'xs:boolean', 0),
        'ACCESS_CREATE': MemberSpec_('ACCESS_CREATE', 'xs:boolean', 0),
        'ACCESS_EXEC': MemberSpec_('ACCESS_EXEC', 'xs:boolean', 0),
        'Current_Uses': MemberSpec_('Current_Uses', 'cybox_common.NonNegativeIntegerObjectPropertyType', 0),
        'Local_Path': MemberSpec_('Local_Path', 'cybox_common.StringObjectPropertyType', 0),
        'Max_Uses': MemberSpec_('Max_Uses', 'cybox_common.NonNegativeIntegerObjectPropertyType', 0),
        'Netname': MemberSpec_('Netname', 'cybox_common.StringObjectPropertyType', 0),
        'Type': MemberSpec_('Type', 'SharedResourceType', 0),
        }
    subclass = None
    superclass = cybox_common.ObjectPropertiesType
    def __init__(self, object_reference=None, Custom_Properties=None, xsi_type=None, ACCESS_PERM=None, ACCESS_ATRIB=None, ACCESS_ALL=None, ACCESS_READ=None, ACCESS_DELETE=None, ACCESS_WRITE=None, ACCESS_CREATE=None, ACCESS_EXEC=None, Current_Uses=None, Local_Path=None, Max_Uses=None, Netname=None, Type=None):
        super(WindowsNetworkShareObjectType, self).__init__(object_reference, Custom_Properties, xsi_type )
        self.ACCESS_PERM = _cast(bool, ACCESS_PERM)
        self.ACCESS_ATRIB = _cast(bool, ACCESS_ATRIB)
        self.ACCESS_ALL = _cast(bool, ACCESS_ALL)
        self.ACCESS_READ = _cast(bool, ACCESS_READ)
        self.ACCESS_DELETE = _cast(bool, ACCESS_DELETE)
        self.ACCESS_WRITE = _cast(bool, ACCESS_WRITE)
        self.ACCESS_CREATE = _cast(bool, ACCESS_CREATE)
        self.ACCESS_EXEC = _cast(bool, ACCESS_EXEC)
        self.Current_Uses = Current_Uses
        self.Local_Path = Local_Path
        self.Max_Uses = Max_Uses
        self.Netname = Netname
        self.Type = Type
    def factory(*args_, **kwargs_):
        if WindowsNetworkShareObjectType.subclass:
            return WindowsNetworkShareObjectType.subclass(*args_, **kwargs_)
        else:
            return WindowsNetworkShareObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Current_Uses(self): return self.Current_Uses
    def set_Current_Uses(self, Current_Uses): self.Current_Uses = Current_Uses
    def validate_NonNegativeIntegerObjectPropertyType(self, value):
        # Validate type cybox_common.NonNegativeIntegerObjectPropertyType, a restriction on None.
        pass
    def get_Local_Path(self): return self.Local_Path
    def set_Local_Path(self, Local_Path): self.Local_Path = Local_Path
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Max_Uses(self): return self.Max_Uses
    def set_Max_Uses(self, Max_Uses): self.Max_Uses = Max_Uses
    def get_Netname(self): return self.Netname
    def set_Netname(self, Netname): self.Netname = Netname
    def get_Type(self): return self.Type
    def set_Type(self, Type): self.Type = Type
    def validate_SharedResourceType(self, value):
        # Validate type SharedResourceType, a restriction on None.
        pass
    def get_ACCESS_PERM(self): return self.ACCESS_PERM
    def set_ACCESS_PERM(self, ACCESS_PERM): self.ACCESS_PERM = ACCESS_PERM
    def get_ACCESS_ATRIB(self): return self.ACCESS_ATRIB
    def set_ACCESS_ATRIB(self, ACCESS_ATRIB): self.ACCESS_ATRIB = ACCESS_ATRIB
    def get_ACCESS_ALL(self): return self.ACCESS_ALL
    def set_ACCESS_ALL(self, ACCESS_ALL): self.ACCESS_ALL = ACCESS_ALL
    def get_ACCESS_READ(self): return self.ACCESS_READ
    def set_ACCESS_READ(self, ACCESS_READ): self.ACCESS_READ = ACCESS_READ
    def get_ACCESS_DELETE(self): return self.ACCESS_DELETE
    def set_ACCESS_DELETE(self, ACCESS_DELETE): self.ACCESS_DELETE = ACCESS_DELETE
    def get_ACCESS_WRITE(self): return self.ACCESS_WRITE
    def set_ACCESS_WRITE(self, ACCESS_WRITE): self.ACCESS_WRITE = ACCESS_WRITE
    def get_ACCESS_CREATE(self): return self.ACCESS_CREATE
    def set_ACCESS_CREATE(self, ACCESS_CREATE): self.ACCESS_CREATE = ACCESS_CREATE
    def get_ACCESS_EXEC(self): return self.ACCESS_EXEC
    def set_ACCESS_EXEC(self, ACCESS_EXEC): self.ACCESS_EXEC = ACCESS_EXEC
    def hasContent_(self):
        if (
            self.Current_Uses is not None or
            self.Local_Path is not None or
            self.Max_Uses is not None or
            self.Netname is not None or
            self.Type is not None or
            super(WindowsNetworkShareObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='WinNetworkShareObj:', name_='WindowsNetworkShareObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsNetworkShareObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='WinNetworkShareObj:', name_='WindowsNetworkShareObjectType'):
        super(WindowsNetworkShareObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='WindowsNetworkShareObjectType')
        if self.ACCESS_PERM is not None and 'ACCESS_PERM' not in already_processed:
            already_processed.add('ACCESS_PERM')
            outfile.write(' ACCESS_PERM="%s"' % self.gds_format_boolean(self.ACCESS_PERM, input_name='ACCESS_PERM'))
        if self.ACCESS_ATRIB is not None and 'ACCESS_ATRIB' not in already_processed:
            already_processed.add('ACCESS_ATRIB')
            outfile.write(' ACCESS_ATRIB="%s"' % self.gds_format_boolean(self.ACCESS_ATRIB, input_name='ACCESS_ATRIB'))
        if self.ACCESS_ALL is not None and 'ACCESS_ALL' not in already_processed:
            already_processed.add('ACCESS_ALL')
            outfile.write(' ACCESS_ALL="%s"' % self.gds_format_boolean(self.ACCESS_ALL, input_name='ACCESS_ALL'))
        if self.ACCESS_READ is not None and 'ACCESS_READ' not in already_processed:
            already_processed.add('ACCESS_READ')
            outfile.write(' ACCESS_READ="%s"' % self.gds_format_boolean(self.ACCESS_READ, input_name='ACCESS_READ'))
        if self.ACCESS_DELETE is not None and 'ACCESS_DELETE' not in already_processed:
            already_processed.add('ACCESS_DELETE')
            outfile.write(' ACCESS_DELETE="%s"' % self.gds_format_boolean(self.ACCESS_DELETE, input_name='ACCESS_DELETE'))
        if self.ACCESS_WRITE is not None and 'ACCESS_WRITE' not in already_processed:
            already_processed.add('ACCESS_WRITE')
            outfile.write(' ACCESS_WRITE="%s"' % self.gds_format_boolean(self.ACCESS_WRITE, input_name='ACCESS_WRITE'))
        if self.ACCESS_CREATE is not None and 'ACCESS_CREATE' not in already_processed:
            already_processed.add('ACCESS_CREATE')
            outfile.write(' ACCESS_CREATE="%s"' % self.gds_format_boolean(self.ACCESS_CREATE, input_name='ACCESS_CREATE'))
        if self.ACCESS_EXEC is not None and 'ACCESS_EXEC' not in already_processed:
            already_processed.add('ACCESS_EXEC')
            outfile.write(' ACCESS_EXEC="%s"' % self.gds_format_boolean(self.ACCESS_EXEC, input_name='ACCESS_EXEC'))
    def exportChildren(self, outfile, level, namespace_='WinNetworkShareObj:', name_='WindowsNetworkShareObjectType', fromsubclass_=False, pretty_print=True):
        super(WindowsNetworkShareObjectType, self).exportChildren(outfile, level, 'WinNetworkShareObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Current_Uses is not None:
            self.Current_Uses.export(outfile, level, 'WinNetworkShareObj:', name_='Current_Uses', pretty_print=pretty_print)
        if self.Local_Path is not None:
            self.Local_Path.export(outfile, level, 'WinNetworkShareObj:', name_='Local_Path', pretty_print=pretty_print)
        if self.Max_Uses is not None:
            self.Max_Uses.export(outfile, level, 'WinNetworkShareObj:', name_='Max_Uses', pretty_print=pretty_print)
        if self.Netname is not None:
            self.Netname.export(outfile, level, 'WinNetworkShareObj:', name_='Netname', pretty_print=pretty_print)
        if self.Type is not None:
            self.Type.export(outfile, level, 'WinNetworkShareObj:', name_='Type', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='WindowsNetworkShareObjectType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.ACCESS_PERM is not None and 'ACCESS_PERM' not in already_processed:
            already_processed.add('ACCESS_PERM')
            showIndent(outfile, level)
            outfile.write('ACCESS_PERM = %s,\n' % (self.ACCESS_PERM,))
        if self.ACCESS_ATRIB is not None and 'ACCESS_ATRIB' not in already_processed:
            already_processed.add('ACCESS_ATRIB')
            showIndent(outfile, level)
            outfile.write('ACCESS_ATRIB = %s,\n' % (self.ACCESS_ATRIB,))
        if self.ACCESS_ALL is not None and 'ACCESS_ALL' not in already_processed:
            already_processed.add('ACCESS_ALL')
            showIndent(outfile, level)
            outfile.write('ACCESS_ALL = %s,\n' % (self.ACCESS_ALL,))
        if self.ACCESS_READ is not None and 'ACCESS_READ' not in already_processed:
            already_processed.add('ACCESS_READ')
            showIndent(outfile, level)
            outfile.write('ACCESS_READ = %s,\n' % (self.ACCESS_READ,))
        if self.ACCESS_DELETE is not None and 'ACCESS_DELETE' not in already_processed:
            already_processed.add('ACCESS_DELETE')
            showIndent(outfile, level)
            outfile.write('ACCESS_DELETE = %s,\n' % (self.ACCESS_DELETE,))
        if self.ACCESS_WRITE is not None and 'ACCESS_WRITE' not in already_processed:
            already_processed.add('ACCESS_WRITE')
            showIndent(outfile, level)
            outfile.write('ACCESS_WRITE = %s,\n' % (self.ACCESS_WRITE,))
        if self.ACCESS_CREATE is not None and 'ACCESS_CREATE' not in already_processed:
            already_processed.add('ACCESS_CREATE')
            showIndent(outfile, level)
            outfile.write('ACCESS_CREATE = %s,\n' % (self.ACCESS_CREATE,))
        if self.ACCESS_EXEC is not None and 'ACCESS_EXEC' not in already_processed:
            already_processed.add('ACCESS_EXEC')
            showIndent(outfile, level)
            outfile.write('ACCESS_EXEC = %s,\n' % (self.ACCESS_EXEC,))
        super(WindowsNetworkShareObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(WindowsNetworkShareObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Current_Uses is not None:
            outfile.write('Current_Uses=model_.cybox_common.NonNegativeIntegerObjectPropertyType(\n')
            self.Current_Uses.exportLiteral(outfile, level, name_='Current_Uses')
            outfile.write('),\n')
        if self.Local_Path is not None:
            outfile.write('Local_Path=model_.cybox_common.StringObjectPropertyType(\n')
            self.Local_Path.exportLiteral(outfile, level, name_='Local_Path')
            outfile.write('),\n')
        if self.Max_Uses is not None:
            outfile.write('Max_Uses=model_.cybox_common.NonNegativeIntegerObjectPropertyType(\n')
            self.Max_Uses.exportLiteral(outfile, level, name_='Max_Uses')
            outfile.write('),\n')
        if self.Netname is not None:
            outfile.write('Netname=model_.cybox_common.StringObjectPropertyType(\n')
            self.Netname.exportLiteral(outfile, level, name_='Netname')
            outfile.write('),\n')
        if self.Type is not None:
            outfile.write('Type=model_.SharedResourceType(\n')
            self.Type.exportLiteral(outfile, level, name_='Type')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('ACCESS_PERM', node)
        if value is not None and 'ACCESS_PERM' not in already_processed:
            already_processed.add('ACCESS_PERM')
            if value in ('true', '1'):
                self.ACCESS_PERM = True
            elif value in ('false', '0'):
                self.ACCESS_PERM = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('ACCESS_ATRIB', node)
        if value is not None and 'ACCESS_ATRIB' not in already_processed:
            already_processed.add('ACCESS_ATRIB')
            if value in ('true', '1'):
                self.ACCESS_ATRIB = True
            elif value in ('false', '0'):
                self.ACCESS_ATRIB = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('ACCESS_ALL', node)
        if value is not None and 'ACCESS_ALL' not in already_processed:
            already_processed.add('ACCESS_ALL')
            if value in ('true', '1'):
                self.ACCESS_ALL = True
            elif value in ('false', '0'):
                self.ACCESS_ALL = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('ACCESS_READ', node)
        if value is not None and 'ACCESS_READ' not in already_processed:
            already_processed.add('ACCESS_READ')
            if value in ('true', '1'):
                self.ACCESS_READ = True
            elif value in ('false', '0'):
                self.ACCESS_READ = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('ACCESS_DELETE', node)
        if value is not None and 'ACCESS_DELETE' not in already_processed:
            already_processed.add('ACCESS_DELETE')
            if value in ('true', '1'):
                self.ACCESS_DELETE = True
            elif value in ('false', '0'):
                self.ACCESS_DELETE = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('ACCESS_WRITE', node)
        if value is not None and 'ACCESS_WRITE' not in already_processed:
            already_processed.add('ACCESS_WRITE')
            if value in ('true', '1'):
                self.ACCESS_WRITE = True
            elif value in ('false', '0'):
                self.ACCESS_WRITE = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('ACCESS_CREATE', node)
        if value is not None and 'ACCESS_CREATE' not in already_processed:
            already_processed.add('ACCESS_CREATE')
            if value in ('true', '1'):
                self.ACCESS_CREATE = True
            elif value in ('false', '0'):
                self.ACCESS_CREATE = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('ACCESS_EXEC', node)
        if value is not None and 'ACCESS_EXEC' not in already_processed:
            already_processed.add('ACCESS_EXEC')
            if value in ('true', '1'):
                self.ACCESS_EXEC = True
            elif value in ('false', '0'):
                self.ACCESS_EXEC = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        super(WindowsNetworkShareObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Current_Uses':
            obj_ = cybox_common.NonNegativeIntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Current_Uses(obj_)
        elif nodeName_ == 'Local_Path':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Local_Path(obj_)
        elif nodeName_ == 'Max_Uses':
            obj_ = cybox_common.NonNegativeIntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Max_Uses(obj_)
        elif nodeName_ == 'Netname':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Netname(obj_)
        elif nodeName_ == 'Type':
            obj_ = SharedResourceType.factory()
            obj_.build(child_)
            self.set_Type(obj_)
        super(WindowsNetworkShareObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class WindowsNetworkShareObjectType

GDSClassesMapping = {
    'Build_Utility': cybox_common.BuildUtilityType,
    'Errors': cybox_common.ErrorsType,
    'Time': cybox_common.TimeType,
    'Certificate_Issuer': cybox_common.StringObjectPropertyType,
    'Metadata': cybox_common.MetadataType,
    'Hash': cybox_common.HashType,
    'Information_Source_Type': cybox_common.ControlledVocabularyStringType,
    'Block_Hash_Value': cybox_common.HashValueType,
    'Fuzzy_Hash_Structure': cybox_common.FuzzyHashStructureType,
    'SubDatum': cybox_common.MetadataType,
    'Segment_Hash': cybox_common.HashValueType,
    'Digital_Signature': cybox_common.DigitalSignatureInfoType,
    'Code_Snippets': cybox_common.CodeSnippetsType,
    'Value': cybox_common.StringObjectPropertyType,
    'Length': cybox_common.IntegerObjectPropertyType,
    'Reference': cybox_common.ReferenceType,
    'Encoding': cybox_common.ControlledVocabularyStringType,
    'Internationalization_Settings': cybox_common.InternationalizationSettingsType,
    'Tool_Configuration': cybox_common.ToolConfigurationType,
    'English_Translation': cybox_common.StringObjectPropertyType,
    'Functions': cybox_common.FunctionsType,
    'String_Value': cybox_common.StringObjectPropertyType,
    'Build_Utility_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Compiler_Informal_Description': cybox_common.CompilerInformalDescriptionType,
    'System': cybox_common.ObjectPropertiesType,
    'Platform': cybox_common.PlatformSpecificationType,
    'Usage_Context_Assumptions': cybox_common.UsageContextAssumptionsType,
    'Type': cybox_common.ControlledVocabularyStringType,
    'Compilers': cybox_common.CompilersType,
    'Tool_Type': cybox_common.ControlledVocabularyStringType,
    'String': cybox_common.ExtractedStringType,
    'Tool': cybox_common.ToolInformationType,
    'Build_Information': cybox_common.BuildInformationType,
    'Tool_Hashes': cybox_common.HashListType,
    'Max_Uses': cybox_common.NonNegativeIntegerObjectPropertyType,
    'Error_Instances': cybox_common.ErrorInstancesType,
    'Data_Segment': cybox_common.StringObjectPropertyType,
    'Certificate_Subject': cybox_common.StringObjectPropertyType,
    'Language': cybox_common.StringObjectPropertyType,
    'Property': cybox_common.PropertyType,
    'Strings': cybox_common.ExtractedStringsType,
    'File_System_Offset': cybox_common.IntegerObjectPropertyType,
    'Compiler_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Reference_Description': cybox_common.StructuredTextType,
    'Code_Snippet': cybox_common.ObjectPropertiesType,
    'Local_Path': cybox_common.StringObjectPropertyType,
    'Configuration_Settings': cybox_common.ConfigurationSettingsType,
    'Simple_Hash_Value': cybox_common.SimpleHashValueType,
    'Byte_String_Value': cybox_common.HexBinaryObjectPropertyType,
    'Instance': cybox_common.ObjectPropertiesType,
    'Import': cybox_common.StringObjectPropertyType,
    'Identifier': cybox_common.PlatformIdentifierType,
    'Tool_Specific_Data': cybox_common.ToolSpecificDataType,
    'Execution_Environment': cybox_common.ExecutionEnvironmentType,
    'Dependencies': cybox_common.DependenciesType,
    'Offset': cybox_common.IntegerObjectPropertyType,
    'Date': cybox_common.DateRangeType,
    'Hashes': cybox_common.HashListType,
    'Segments': cybox_common.HashSegmentsType,
    'Segment_Count': cybox_common.IntegerObjectPropertyType,
    'Usage_Context_Assumption': cybox_common.StructuredTextType,
    'Block_Hash': cybox_common.FuzzyHashBlockType,
    'Dependency': cybox_common.DependencyType,
    'Error': cybox_common.ErrorType,
    'Trigger_Point': cybox_common.HexBinaryObjectPropertyType,
    'Environment_Variable': cybox_common.EnvironmentVariableType,
    'Byte_Run': cybox_common.ByteRunType,
    'Contributors': cybox_common.PersonnelType,
    'Image_Offset': cybox_common.IntegerObjectPropertyType,
    'Imports': cybox_common.ImportsType,
    'Library': cybox_common.LibraryType,
    'References': cybox_common.ToolReferencesType,
    'Netname': cybox_common.StringObjectPropertyType,
    'Internal_Strings': cybox_common.InternalStringsType,
    'Custom_Properties': cybox_common.CustomPropertiesType,
    'Configuration_Setting': cybox_common.ConfigurationSettingType,
    'Libraries': cybox_common.LibrariesType,
    'Function': cybox_common.StringObjectPropertyType,
    'Description': cybox_common.StructuredTextType,
    'User_Account_Info': cybox_common.ObjectPropertiesType,
    'Build_Configuration': cybox_common.BuildConfigurationType,
    'Address': cybox_common.HexBinaryObjectPropertyType,
    'Search_Within': cybox_common.IntegerObjectPropertyType,
    'Segment': cybox_common.HashSegmentType,
    'Compiler': cybox_common.CompilerType,
    'Name': cybox_common.StringObjectPropertyType,
    'Signature_Description': cybox_common.StringObjectPropertyType,
    'Block_Size': cybox_common.IntegerObjectPropertyType,
    'Search_Distance': cybox_common.IntegerObjectPropertyType,
    'Fuzzy_Hash_Value': cybox_common.FuzzyHashValueType,
    'Current_Uses': cybox_common.NonNegativeIntegerObjectPropertyType,
    'Dependency_Description': cybox_common.StructuredTextType,
    'Contributor': cybox_common.ContributorType,
    'Tools': cybox_common.ToolsInformationType,
    'Data_Size': cybox_common.DataSizeType,
}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Network_Share'
        rootClass = WindowsNetworkShareObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
#    sys.stdout.write('<?xml version="1.0" ?>\n')
#    rootObj.export(sys.stdout, 0, name_=rootTag,
#        namespacedef_='',
#        pretty_print=True)
    return rootObj

def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Network_Share'
        rootClass = WindowsNetworkShareObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    rootElement = rootObj.to_etree(None, name_=rootTag)
    content = etree_.tostring(rootElement, pretty_print=True,
        xml_declaration=True, encoding="utf-8")
    sys.stdout.write(content)
    sys.stdout.write('\n')
    return rootObj, rootElement

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Network_Share'
        rootClass = WindowsNetworkShareObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
#    sys.stdout.write('<?xml version="1.0" ?>\n')
#    rootObj.export(sys.stdout, 0, name_="Windows_Network_Share",
#        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Windows_Network_Share'
        rootClass = WindowsNetworkShareObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('from datetime import datetime as datetime_\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "WindowsNetworkShareObjectType",
    "SharedResourceType"
    ]
