#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2013, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

#
# Generated Tue Apr 09 11:10:11 2013 by generateDS.py version 2.9a.
#

import sys
import getopt
import re as re_

import cybox_common
import address_object
import port_object
import uri_object
import base64
from datetime import datetime, tzinfo, timedelta

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(tzinfo):
            def __init__(self, offset, name):
                self.__offset = timedelta(minutes = offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S')
            else:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S.%f')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_datetime(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S')
            return dt.replace(tzinfo = tz)

        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = input_data.strftime('%Y-%m-%d')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_date(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            return datetime.strptime(input_data,
                '%Y-%m-%d').replace(tzinfo = tz)
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return unicode(s1).encode(ExternalEncoding)

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return unicode(s1).encode(ExternalEncoding)

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' %
                (self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class HTTPRequestResponseType(GeneratedsSuper):
    """The HTTPRequestResponseType captures a single HTTP request/response
    pair."""
    member_data_items_ = {
        'HTTP_Client_Request': MemberSpec_('HTTP_Client_Request', 'HTTPClientRequestType', 0),
        'HTTP_Server_Response': MemberSpec_('HTTP_Server_Response', 'HTTPServerResponseType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, HTTP_Client_Request=None, HTTP_Server_Response=None):
        self.HTTP_Client_Request = HTTP_Client_Request
        self.HTTP_Server_Response = HTTP_Server_Response
    def factory(*args_, **kwargs_):
        if HTTPRequestResponseType.subclass:
            return HTTPRequestResponseType.subclass(*args_, **kwargs_)
        else:
            return HTTPRequestResponseType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_HTTP_Client_Request(self): return self.HTTP_Client_Request
    def set_HTTP_Client_Request(self, HTTP_Client_Request): self.HTTP_Client_Request = HTTP_Client_Request
    def get_HTTP_Server_Response(self): return self.HTTP_Server_Response
    def set_HTTP_Server_Response(self, HTTP_Server_Response): self.HTTP_Server_Response = HTTP_Server_Response
    def hasContent_(self):
        if (
            self.HTTP_Client_Request is not None or
            self.HTTP_Server_Response is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPRequestResponseType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HTTPRequestResponseType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='HTTPSessionObj:', name_='HTTPRequestResponseType'):
        pass
    def exportChildren(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPRequestResponseType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.HTTP_Client_Request is not None:
            self.HTTP_Client_Request.export(outfile, level, 'HTTPSessionObj:', name_='HTTP_Client_Request', pretty_print=pretty_print)
        if self.HTTP_Server_Response is not None:
            self.HTTP_Server_Response.export(outfile, level, 'HTTPSessionObj:', name_='HTTP_Server_Response', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HTTPRequestResponseType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.HTTP_Client_Request is not None:
            outfile.write('HTTP_Client_Request=model_.HTTPClientRequestType(\n')
            self.HTTP_Client_Request.exportLiteral(outfile, level, name_='HTTP_Client_Request')
            outfile.write('),\n')
        if self.HTTP_Server_Response is not None:
            outfile.write('HTTP_Server_Response=model_.HTTPServerResponseType(\n')
            self.HTTP_Server_Response.exportLiteral(outfile, level, name_='HTTP_Server_Response')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'HTTP_Client_Request':
            obj_ = HTTPClientRequestType.factory()
            obj_.build(child_)
            self.set_HTTP_Client_Request(obj_)
        elif nodeName_ == 'HTTP_Server_Response':
            obj_ = HTTPServerResponseType.factory()
            obj_.build(child_)
            self.set_HTTP_Server_Response(obj_)
# end class HTTPRequestResponseType

class HTTPClientRequestType(GeneratedsSuper):
    """The HTTPClientRequestType field captures the details of an HTTP
    client request."""
    member_data_items_ = {
        'HTTP_Request_Line': MemberSpec_('HTTP_Request_Line', 'HTTPRequestLineType', 0),
        'HTTP_Request_Header': MemberSpec_('HTTP_Request_Header', 'HTTPRequestHeaderType', 0),
        'HTTP_Message_Body': MemberSpec_('HTTP_Message_Body', 'HTTPMessageType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, HTTP_Request_Line=None, HTTP_Request_Header=None, HTTP_Message_Body=None):
        self.HTTP_Request_Line = HTTP_Request_Line
        self.HTTP_Request_Header = HTTP_Request_Header
        self.HTTP_Message_Body = HTTP_Message_Body
    def factory(*args_, **kwargs_):
        if HTTPClientRequestType.subclass:
            return HTTPClientRequestType.subclass(*args_, **kwargs_)
        else:
            return HTTPClientRequestType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_HTTP_Request_Line(self): return self.HTTP_Request_Line
    def set_HTTP_Request_Line(self, HTTP_Request_Line): self.HTTP_Request_Line = HTTP_Request_Line
    def get_HTTP_Request_Header(self): return self.HTTP_Request_Header
    def set_HTTP_Request_Header(self, HTTP_Request_Header): self.HTTP_Request_Header = HTTP_Request_Header
    def get_HTTP_Message_Body(self): return self.HTTP_Message_Body
    def set_HTTP_Message_Body(self, HTTP_Message_Body): self.HTTP_Message_Body = HTTP_Message_Body
    def hasContent_(self):
        if (
            self.HTTP_Request_Line is not None or
            self.HTTP_Request_Header is not None or
            self.HTTP_Message_Body is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPClientRequestType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HTTPClientRequestType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='HTTPSessionObj:', name_='HTTPClientRequestType'):
        pass
    def exportChildren(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPClientRequestType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.HTTP_Request_Line is not None:
            self.HTTP_Request_Line.export(outfile, level, 'HTTPSessionObj:', name_='HTTP_Request_Line', pretty_print=pretty_print)
        if self.HTTP_Request_Header is not None:
            self.HTTP_Request_Header.export(outfile, level, 'HTTPSessionObj:', name_='HTTP_Request_Header', pretty_print=pretty_print)
        if self.HTTP_Message_Body is not None:
            self.HTTP_Message_Body.export(outfile, level, 'HTTPSessionObj:', name_='HTTP_Message_Body', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HTTPClientRequestType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.HTTP_Request_Line is not None:
            outfile.write('HTTP_Request_Line=model_.HTTPRequestLineType(\n')
            self.HTTP_Request_Line.exportLiteral(outfile, level, name_='HTTP_Request_Line')
            outfile.write('),\n')
        if self.HTTP_Request_Header is not None:
            outfile.write('HTTP_Request_Header=model_.HTTPRequestHeaderType(\n')
            self.HTTP_Request_Header.exportLiteral(outfile, level, name_='HTTP_Request_Header')
            outfile.write('),\n')
        if self.HTTP_Message_Body is not None:
            outfile.write('HTTP_Message_Body=model_.HTTPMessageType(\n')
            self.HTTP_Message_Body.exportLiteral(outfile, level, name_='HTTP_Message_Body')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'HTTP_Request_Line':
            obj_ = HTTPRequestLineType.factory()
            obj_.build(child_)
            self.set_HTTP_Request_Line(obj_)
        elif nodeName_ == 'HTTP_Request_Header':
            obj_ = HTTPRequestHeaderType.factory()
            obj_.build(child_)
            self.set_HTTP_Request_Header(obj_)
        elif nodeName_ == 'HTTP_Message_Body':
            obj_ = HTTPMessageType.factory()
            obj_.build(child_)
            self.set_HTTP_Message_Body(obj_)
# end class HTTPClientRequestType

class HTTPServerResponseType(GeneratedsSuper):
    """The HTTPServerResponseType captures the details of an HTTP server
    response."""
    member_data_items_ = {
        'HTTP_Status_Line': MemberSpec_('HTTP_Status_Line', 'HTTPStatusLineType', 0),
        'HTTP_Response_Header': MemberSpec_('HTTP_Response_Header', 'HTTPResponseHeaderType', 0),
        'HTTP_Message_Body': MemberSpec_('HTTP_Message_Body', 'HTTPMessageType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, HTTP_Status_Line=None, HTTP_Response_Header=None, HTTP_Message_Body=None):
        self.HTTP_Status_Line = HTTP_Status_Line
        self.HTTP_Response_Header = HTTP_Response_Header
        self.HTTP_Message_Body = HTTP_Message_Body
    def factory(*args_, **kwargs_):
        if HTTPServerResponseType.subclass:
            return HTTPServerResponseType.subclass(*args_, **kwargs_)
        else:
            return HTTPServerResponseType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_HTTP_Status_Line(self): return self.HTTP_Status_Line
    def set_HTTP_Status_Line(self, HTTP_Status_Line): self.HTTP_Status_Line = HTTP_Status_Line
    def get_HTTP_Response_Header(self): return self.HTTP_Response_Header
    def set_HTTP_Response_Header(self, HTTP_Response_Header): self.HTTP_Response_Header = HTTP_Response_Header
    def get_HTTP_Message_Body(self): return self.HTTP_Message_Body
    def set_HTTP_Message_Body(self, HTTP_Message_Body): self.HTTP_Message_Body = HTTP_Message_Body
    def hasContent_(self):
        if (
            self.HTTP_Status_Line is not None or
            self.HTTP_Response_Header is not None or
            self.HTTP_Message_Body is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPServerResponseType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HTTPServerResponseType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='HTTPSessionObj:', name_='HTTPServerResponseType'):
        pass
    def exportChildren(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPServerResponseType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.HTTP_Status_Line is not None:
            self.HTTP_Status_Line.export(outfile, level, 'HTTPSessionObj:', name_='HTTP_Status_Line', pretty_print=pretty_print)
        if self.HTTP_Response_Header is not None:
            self.HTTP_Response_Header.export(outfile, level, 'HTTPSessionObj:', name_='HTTP_Response_Header', pretty_print=pretty_print)
        if self.HTTP_Message_Body is not None:
            self.HTTP_Message_Body.export(outfile, level, 'HTTPSessionObj:', name_='HTTP_Message_Body', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HTTPServerResponseType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.HTTP_Status_Line is not None:
            outfile.write('HTTP_Status_Line=model_.HTTPStatusLineType(\n')
            self.HTTP_Status_Line.exportLiteral(outfile, level, name_='HTTP_Status_Line')
            outfile.write('),\n')
        if self.HTTP_Response_Header is not None:
            outfile.write('HTTP_Response_Header=model_.HTTPResponseHeaderType(\n')
            self.HTTP_Response_Header.exportLiteral(outfile, level, name_='HTTP_Response_Header')
            outfile.write('),\n')
        if self.HTTP_Message_Body is not None:
            outfile.write('HTTP_Message_Body=model_.HTTPMessageType(\n')
            self.HTTP_Message_Body.exportLiteral(outfile, level, name_='HTTP_Message_Body')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'HTTP_Status_Line':
            obj_ = HTTPStatusLineType.factory()
            obj_.build(child_)
            self.set_HTTP_Status_Line(obj_)
        elif nodeName_ == 'HTTP_Response_Header':
            obj_ = HTTPResponseHeaderType.factory()
            obj_.build(child_)
            self.set_HTTP_Response_Header(obj_)
        elif nodeName_ == 'HTTP_Message_Body':
            obj_ = HTTPMessageType.factory()
            obj_.build(child_)
            self.set_HTTP_Message_Body(obj_)
# end class HTTPServerResponseType

class HTTPRequestLineType(GeneratedsSuper):
    """The HTTPRequestLineType captures a single HTTP request line."""
    member_data_items_ = {
        'HTTP_Method': MemberSpec_('HTTP_Method', 'HTTPMethodType', 0),
        'Value': MemberSpec_('Value', 'cybox_common.StringObjectPropertyType', 0),
        'Version': MemberSpec_('Version', 'cybox_common.StringObjectPropertyType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, HTTP_Method=None, Value=None, Version=None):
        self.HTTP_Method = HTTP_Method
        self.Value = Value
        self.Version = Version
    def factory(*args_, **kwargs_):
        if HTTPRequestLineType.subclass:
            return HTTPRequestLineType.subclass(*args_, **kwargs_)
        else:
            return HTTPRequestLineType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_HTTP_Method(self): return self.HTTP_Method
    def set_HTTP_Method(self, HTTP_Method): self.HTTP_Method = HTTP_Method
    def validate_HTTPMethodType(self, value):
        # Validate type HTTPMethodType, a restriction on None.
        pass
    def get_Value(self): return self.Value
    def set_Value(self, Value): self.Value = Value
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def hasContent_(self):
        if (
            self.HTTP_Method is not None or
            self.Value is not None or
            self.Version is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPRequestLineType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HTTPRequestLineType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='HTTPSessionObj:', name_='HTTPRequestLineType'):
        pass
    def exportChildren(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPRequestLineType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.HTTP_Method is not None:
            self.HTTP_Method.export(outfile, level, 'HTTPSessionObj:', name_='HTTP_Method', pretty_print=pretty_print)
        if self.Value is not None:
            self.Value.export(outfile, level, 'HTTPSessionObj:', name_='Value', pretty_print=pretty_print)
        if self.Version is not None:
            self.Version.export(outfile, level, 'HTTPSessionObj:', name_='Version', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HTTPRequestLineType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.HTTP_Method is not None:
            outfile.write('HTTP_Method=model_.HTTPMethodType(\n')
            self.HTTP_Method.exportLiteral(outfile, level, name_='HTTP_Method')
            outfile.write('),\n')
        if self.Value is not None:
            outfile.write('Value=model_.cybox_common.StringObjectPropertyType(\n')
            self.Value.exportLiteral(outfile, level, name_='Value')
            outfile.write('),\n')
        if self.Version is not None:
            outfile.write('Version=model_.cybox_common.StringObjectPropertyType(\n')
            self.Version.exportLiteral(outfile, level, name_='Version')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'HTTP_Method':
            obj_ = HTTPMethodType.factory()
            obj_.build(child_)
            self.set_HTTP_Method(obj_)
        elif nodeName_ == 'Value':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Value(obj_)
        elif nodeName_ == 'Version':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Version(obj_)
# end class HTTPRequestLineType

class HTTPRequestHeaderType(GeneratedsSuper):
    """The HTTPRequestHeaderType captures the raw or parsed header of an
    HTTP request."""
    member_data_items_ = {
        'Raw_Header': MemberSpec_('Raw_Header', 'cybox_common.StringObjectPropertyType', 0),
        'Parsed_Header': MemberSpec_('Parsed_Header', 'HTTPRequestHeaderFieldsType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, Raw_Header=None, Parsed_Header=None):
        self.Raw_Header = Raw_Header
        self.Parsed_Header = Parsed_Header
    def factory(*args_, **kwargs_):
        if HTTPRequestHeaderType.subclass:
            return HTTPRequestHeaderType.subclass(*args_, **kwargs_)
        else:
            return HTTPRequestHeaderType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Raw_Header(self): return self.Raw_Header
    def set_Raw_Header(self, Raw_Header): self.Raw_Header = Raw_Header
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Parsed_Header(self): return self.Parsed_Header
    def set_Parsed_Header(self, Parsed_Header): self.Parsed_Header = Parsed_Header
    def hasContent_(self):
        if (
            self.Raw_Header is not None or
            self.Parsed_Header is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPRequestHeaderType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HTTPRequestHeaderType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='HTTPSessionObj:', name_='HTTPRequestHeaderType'):
        pass
    def exportChildren(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPRequestHeaderType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Raw_Header is not None:
            if self.Raw_Header.get_valueOf_() is not None:
                value = self.Raw_Header.get_valueOf_()
                if not value.startswith('<![CDATA['):
                    value = '<![CDATA[' + value + ']]>'
                    self.Raw_Header.set_valueOf_(value)   
            self.Raw_Header.export(outfile, level, 'HTTPSessionObj:', name_='Raw_Header', pretty_print=pretty_print)
        if self.Parsed_Header is not None:
            self.Parsed_Header.export(outfile, level, 'HTTPSessionObj:', name_='Parsed_Header', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HTTPRequestHeaderType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Raw_Header is not None:
            outfile.write('Raw_Header=model_.cybox_common.StringObjectPropertyType(\n')
            self.Raw_Header.exportLiteral(outfile, level, name_='Raw_Header')
            outfile.write('),\n')
        if self.Parsed_Header is not None:
            outfile.write('Parsed_Header=model_.HTTPRequestHeaderFieldsType(\n')
            self.Parsed_Header.exportLiteral(outfile, level, name_='Parsed_Header')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Raw_Header':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Raw_Header(obj_)
        elif nodeName_ == 'Parsed_Header':
            obj_ = HTTPRequestHeaderFieldsType.factory()
            obj_.build(child_)
            self.set_Parsed_Header(obj_)
# end class HTTPRequestHeaderType

class HTTPRequestHeaderFieldsType(GeneratedsSuper):
    """The HTTPRequestHeaderFieldsType captures parsed HTTP request header
    fields."""
    member_data_items_ = {
        'Accept': MemberSpec_('Accept', 'cybox_common.StringObjectPropertyType', 0),
        'Accept_Charset': MemberSpec_('Accept_Charset', 'cybox_common.StringObjectPropertyType', 0),
        'Accept_Language': MemberSpec_('Accept_Language', 'cybox_common.StringObjectPropertyType', 0),
        'Accept_Datetime': MemberSpec_('Accept_Datetime', 'cybox_common.StringObjectPropertyType', 0),
        'Accept_Encoding': MemberSpec_('Accept_Encoding', 'cybox_common.StringObjectPropertyType', 0),
        'Authorization': MemberSpec_('Authorization', 'cybox_common.StringObjectPropertyType', 0),
        'Cache_Control': MemberSpec_('Cache_Control', 'cybox_common.StringObjectPropertyType', 0),
        'Connection': MemberSpec_('Connection', 'cybox_common.StringObjectPropertyType', 0),
        'Cookie': MemberSpec_('Cookie', 'cybox_common.StringObjectPropertyType', 0),
        'Content_Length': MemberSpec_('Content_Length', 'cybox_common.IntegerObjectPropertyType', 0),
        'Content_MD5': MemberSpec_('Content_MD5', 'cybox_common.StringObjectPropertyType', 0),
        'Content_Type': MemberSpec_('Content_Type', 'cybox_common.StringObjectPropertyType', 0),
        'Date': MemberSpec_('Date', 'cybox_common.DateTimeObjectPropertyType', 0),
        'Expect': MemberSpec_('Expect', 'cybox_common.StringObjectPropertyType', 0),
        'From': MemberSpec_('From', 'address_object.AddressObjectType', 0),
        'Host': MemberSpec_('Host', 'HostFieldType', 0),
        'If_Match': MemberSpec_('If_Match', 'cybox_common.StringObjectPropertyType', 0),
        'If_Modified_Since': MemberSpec_('If_Modified_Since', 'cybox_common.DateTimeObjectPropertyType', 0),
        'If_None_Match': MemberSpec_('If_None_Match', 'cybox_common.StringObjectPropertyType', 0),
        'If_Range': MemberSpec_('If_Range', 'cybox_common.StringObjectPropertyType', 0),
        'If_Unmodified_Since': MemberSpec_('If_Unmodified_Since', 'cybox_common.DateTimeObjectPropertyType', 0),
        'Max_Forwards': MemberSpec_('Max_Forwards', 'cybox_common.IntegerObjectPropertyType', 0),
        'Pragma': MemberSpec_('Pragma', 'cybox_common.StringObjectPropertyType', 0),
        'Proxy_Authorization': MemberSpec_('Proxy_Authorization', 'cybox_common.StringObjectPropertyType', 0),
        'Range': MemberSpec_('Range', 'cybox_common.StringObjectPropertyType', 0),
        'Referer': MemberSpec_('Referer', 'uri_object.URIObjectType', 0),
        'TE': MemberSpec_('TE', 'cybox_common.StringObjectPropertyType', 0),
        'User_Agent': MemberSpec_('User_Agent', 'cybox_common.StringObjectPropertyType', 0),
        'Via': MemberSpec_('Via', 'cybox_common.StringObjectPropertyType', 0),
        'Warning': MemberSpec_('Warning', 'cybox_common.StringObjectPropertyType', 0),
        'DNT': MemberSpec_('DNT', 'uri_object.URIObjectType', 0),
        'X_Requested_With': MemberSpec_('X_Requested_With', 'cybox_common.StringObjectPropertyType', 0),
        'X_Requested_For': MemberSpec_('X_Requested_For', 'cybox_common.StringObjectPropertyType', 0),
        'X_ATT_DeviceId': MemberSpec_('X_ATT_DeviceId', 'cybox_common.StringObjectPropertyType', 0),
        'X_Wap_Profile': MemberSpec_('X_Wap_Profile', 'uri_object.URIObjectType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, Accept=None, Accept_Charset=None, Accept_Language=None, Accept_Datetime=None, Accept_Encoding=None, Authorization=None, Cache_Control=None, Connection=None, Cookie=None, Content_Length=None, Content_MD5=None, Content_Type=None, Date=None, Expect=None, From=None, Host=None, If_Match=None, If_Modified_Since=None, If_None_Match=None, If_Range=None, If_Unmodified_Since=None, Max_Forwards=None, Pragma=None, Proxy_Authorization=None, Range=None, Referer=None, TE=None, User_Agent=None, Via=None, Warning=None, DNT=None, X_Requested_With=None, X_Requested_For=None, X_ATT_DeviceId=None, X_Wap_Profile=None):
        self.Accept = Accept
        self.Accept_Charset = Accept_Charset
        self.Accept_Language = Accept_Language
        self.Accept_Datetime = Accept_Datetime
        self.Accept_Encoding = Accept_Encoding
        self.Authorization = Authorization
        self.Cache_Control = Cache_Control
        self.Connection = Connection
        self.Cookie = Cookie
        self.Content_Length = Content_Length
        self.Content_MD5 = Content_MD5
        self.Content_Type = Content_Type
        self.Date = Date
        self.Expect = Expect
        self.From = From
        self.Host = Host
        self.If_Match = If_Match
        self.If_Modified_Since = If_Modified_Since
        self.If_None_Match = If_None_Match
        self.If_Range = If_Range
        self.If_Unmodified_Since = If_Unmodified_Since
        self.Max_Forwards = Max_Forwards
        self.Pragma = Pragma
        self.Proxy_Authorization = Proxy_Authorization
        self.Range = Range
        self.Referer = Referer
        self.TE = TE
        self.User_Agent = User_Agent
        self.Via = Via
        self.Warning = Warning
        self.DNT = DNT
        self.X_Requested_With = X_Requested_With
        self.X_Requested_For = X_Requested_For
        self.X_ATT_DeviceId = X_ATT_DeviceId
        self.X_Wap_Profile = X_Wap_Profile
    def factory(*args_, **kwargs_):
        if HTTPRequestHeaderFieldsType.subclass:
            return HTTPRequestHeaderFieldsType.subclass(*args_, **kwargs_)
        else:
            return HTTPRequestHeaderFieldsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Accept(self): return self.Accept
    def set_Accept(self, Accept): self.Accept = Accept
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Accept_Charset(self): return self.Accept_Charset
    def set_Accept_Charset(self, Accept_Charset): self.Accept_Charset = Accept_Charset
    def get_Accept_Language(self): return self.Accept_Language
    def set_Accept_Language(self, Accept_Language): self.Accept_Language = Accept_Language
    def get_Accept_Datetime(self): return self.Accept_Datetime
    def set_Accept_Datetime(self, Accept_Datetime): self.Accept_Datetime = Accept_Datetime
    def get_Accept_Encoding(self): return self.Accept_Encoding
    def set_Accept_Encoding(self, Accept_Encoding): self.Accept_Encoding = Accept_Encoding
    def get_Authorization(self): return self.Authorization
    def set_Authorization(self, Authorization): self.Authorization = Authorization
    def get_Cache_Control(self): return self.Cache_Control
    def set_Cache_Control(self, Cache_Control): self.Cache_Control = Cache_Control
    def get_Connection(self): return self.Connection
    def set_Connection(self, Connection): self.Connection = Connection
    def get_Cookie(self): return self.Cookie
    def set_Cookie(self, Cookie): self.Cookie = Cookie
    def get_Content_Length(self): return self.Content_Length
    def set_Content_Length(self, Content_Length): self.Content_Length = Content_Length
    def validate_IntegerObjectPropertyType(self, value):
        # Validate type cybox_common.IntegerObjectPropertyType, a restriction on None.
        pass
    def get_Content_MD5(self): return self.Content_MD5
    def set_Content_MD5(self, Content_MD5): self.Content_MD5 = Content_MD5
    def get_Content_Type(self): return self.Content_Type
    def set_Content_Type(self, Content_Type): self.Content_Type = Content_Type
    def get_Date(self): return self.Date
    def set_Date(self, Date): self.Date = Date
    def validate_DateTimeObjectPropertyType(self, value):
        # Validate type cybox_common.DateTimeObjectPropertyType, a restriction on None.
        pass
    def get_Expect(self): return self.Expect
    def set_Expect(self, Expect): self.Expect = Expect
    def get_From(self): return self.From
    def set_From(self, From): self.From = From
    def get_Host(self): return self.Host
    def set_Host(self, Host): self.Host = Host
    def get_If_Match(self): return self.If_Match
    def set_If_Match(self, If_Match): self.If_Match = If_Match
    def get_If_Modified_Since(self): return self.If_Modified_Since
    def set_If_Modified_Since(self, If_Modified_Since): self.If_Modified_Since = If_Modified_Since
    def get_If_None_Match(self): return self.If_None_Match
    def set_If_None_Match(self, If_None_Match): self.If_None_Match = If_None_Match
    def get_If_Range(self): return self.If_Range
    def set_If_Range(self, If_Range): self.If_Range = If_Range
    def get_If_Unmodified_Since(self): return self.If_Unmodified_Since
    def set_If_Unmodified_Since(self, If_Unmodified_Since): self.If_Unmodified_Since = If_Unmodified_Since
    def get_Max_Forwards(self): return self.Max_Forwards
    def set_Max_Forwards(self, Max_Forwards): self.Max_Forwards = Max_Forwards
    def get_Pragma(self): return self.Pragma
    def set_Pragma(self, Pragma): self.Pragma = Pragma
    def get_Proxy_Authorization(self): return self.Proxy_Authorization
    def set_Proxy_Authorization(self, Proxy_Authorization): self.Proxy_Authorization = Proxy_Authorization
    def get_Range(self): return self.Range
    def set_Range(self, Range): self.Range = Range
    def get_Referer(self): return self.Referer
    def set_Referer(self, Referer): self.Referer = Referer
    def get_TE(self): return self.TE
    def set_TE(self, TE): self.TE = TE
    def get_User_Agent(self): return self.User_Agent
    def set_User_Agent(self, User_Agent): self.User_Agent = User_Agent
    def get_Via(self): return self.Via
    def set_Via(self, Via): self.Via = Via
    def get_Warning(self): return self.Warning
    def set_Warning(self, Warning): self.Warning = Warning
    def get_DNT(self): return self.DNT
    def set_DNT(self, DNT): self.DNT = DNT
    def get_X_Requested_With(self): return self.X_Requested_With
    def set_X_Requested_With(self, X_Requested_With): self.X_Requested_With = X_Requested_With
    def get_X_Requested_For(self): return self.X_Requested_For
    def set_X_Requested_For(self, X_Requested_For): self.X_Requested_For = X_Requested_For
    def get_X_ATT_DeviceId(self): return self.X_ATT_DeviceId
    def set_X_ATT_DeviceId(self, X_ATT_DeviceId): self.X_ATT_DeviceId = X_ATT_DeviceId
    def get_X_Wap_Profile(self): return self.X_Wap_Profile
    def set_X_Wap_Profile(self, X_Wap_Profile): self.X_Wap_Profile = X_Wap_Profile
    def hasContent_(self):
        if (
            self.Accept is not None or
            self.Accept_Charset is not None or
            self.Accept_Language is not None or
            self.Accept_Datetime is not None or
            self.Accept_Encoding is not None or
            self.Authorization is not None or
            self.Cache_Control is not None or
            self.Connection is not None or
            self.Cookie is not None or
            self.Content_Length is not None or
            self.Content_MD5 is not None or
            self.Content_Type is not None or
            self.Date is not None or
            self.Expect is not None or
            self.From is not None or
            self.Host is not None or
            self.If_Match is not None or
            self.If_Modified_Since is not None or
            self.If_None_Match is not None or
            self.If_Range is not None or
            self.If_Unmodified_Since is not None or
            self.Max_Forwards is not None or
            self.Pragma is not None or
            self.Proxy_Authorization is not None or
            self.Range is not None or
            self.Referer is not None or
            self.TE is not None or
            self.User_Agent is not None or
            self.Via is not None or
            self.Warning is not None or
            self.DNT is not None or
            self.X_Requested_With is not None or
            self.X_Requested_For is not None or
            self.X_ATT_DeviceId is not None or
            self.X_Wap_Profile is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPRequestHeaderFieldsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HTTPRequestHeaderFieldsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='HTTPSessionObj:', name_='HTTPRequestHeaderFieldsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPRequestHeaderFieldsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Accept is not None:
            self.Accept.export(outfile, level, 'HTTPSessionObj:', name_='Accept', pretty_print=pretty_print)
        if self.Accept_Charset is not None:
            self.Accept_Charset.export(outfile, level, 'HTTPSessionObj:', name_='Accept_Charset', pretty_print=pretty_print)
        if self.Accept_Language is not None:
            self.Accept_Language.export(outfile, level, 'HTTPSessionObj:', name_='Accept_Language', pretty_print=pretty_print)
        if self.Accept_Datetime is not None:
            self.Accept_Datetime.export(outfile, level, 'HTTPSessionObj:', name_='Accept_Datetime', pretty_print=pretty_print)
        if self.Accept_Encoding is not None:
            self.Accept_Encoding.export(outfile, level, 'HTTPSessionObj:', name_='Accept_Encoding', pretty_print=pretty_print)
        if self.Authorization is not None:
            self.Authorization.export(outfile, level, 'HTTPSessionObj:', name_='Authorization', pretty_print=pretty_print)
        if self.Cache_Control is not None:
            self.Cache_Control.export(outfile, level, 'HTTPSessionObj:', name_='Cache_Control', pretty_print=pretty_print)
        if self.Connection is not None:
            self.Connection.export(outfile, level, 'HTTPSessionObj:', name_='Connection', pretty_print=pretty_print)
        if self.Cookie is not None:
            self.Cookie.export(outfile, level, 'HTTPSessionObj:', name_='Cookie', pretty_print=pretty_print)
        if self.Content_Length is not None:
            self.Content_Length.export(outfile, level, 'HTTPSessionObj:', name_='Content_Length', pretty_print=pretty_print)
        if self.Content_MD5 is not None:
            self.Content_MD5.export(outfile, level, 'HTTPSessionObj:', name_='Content_MD5', pretty_print=pretty_print)
        if self.Content_Type is not None:
            self.Content_Type.export(outfile, level, 'HTTPSessionObj:', name_='Content_Type', pretty_print=pretty_print)
        if self.Date is not None:
            self.Date.export(outfile, level, 'HTTPSessionObj:', name_='Date', pretty_print=pretty_print)
        if self.Expect is not None:
            self.Expect.export(outfile, level, 'HTTPSessionObj:', name_='Expect', pretty_print=pretty_print)
        if self.From is not None:
            self.From.export(outfile, level, 'HTTPSessionObj:', name_='From', pretty_print=pretty_print)
        if self.Host is not None:
            self.Host.export(outfile, level, 'HTTPSessionObj:', name_='Host', pretty_print=pretty_print)
        if self.If_Match is not None:
            self.If_Match.export(outfile, level, 'HTTPSessionObj:', name_='If_Match', pretty_print=pretty_print)
        if self.If_Modified_Since is not None:
            self.If_Modified_Since.export(outfile, level, 'HTTPSessionObj:', name_='If_Modified_Since', pretty_print=pretty_print)
        if self.If_None_Match is not None:
            self.If_None_Match.export(outfile, level, 'HTTPSessionObj:', name_='If_None_Match', pretty_print=pretty_print)
        if self.If_Range is not None:
            self.If_Range.export(outfile, level, 'HTTPSessionObj:', name_='If_Range', pretty_print=pretty_print)
        if self.If_Unmodified_Since is not None:
            self.If_Unmodified_Since.export(outfile, level, 'HTTPSessionObj:', name_='If_Unmodified_Since', pretty_print=pretty_print)
        if self.Max_Forwards is not None:
            self.Max_Forwards.export(outfile, level, 'HTTPSessionObj:', name_='Max_Forwards', pretty_print=pretty_print)
        if self.Pragma is not None:
            self.Pragma.export(outfile, level, 'HTTPSessionObj:', name_='Pragma', pretty_print=pretty_print)
        if self.Proxy_Authorization is not None:
            self.Proxy_Authorization.export(outfile, level, 'HTTPSessionObj:', name_='Proxy_Authorization', pretty_print=pretty_print)
        if self.Range is not None:
            self.Range.export(outfile, level, 'HTTPSessionObj:', name_='Range', pretty_print=pretty_print)
        if self.Referer is not None:
            self.Referer.export(outfile, level, 'HTTPSessionObj:', name_='Referer', pretty_print=pretty_print)
        if self.TE is not None:
            self.TE.export(outfile, level, 'HTTPSessionObj:', name_='TE', pretty_print=pretty_print)
        if self.User_Agent is not None:
            self.User_Agent.export(outfile, level, 'HTTPSessionObj:', name_='User_Agent', pretty_print=pretty_print)
        if self.Via is not None:
            self.Via.export(outfile, level, 'HTTPSessionObj:', name_='Via', pretty_print=pretty_print)
        if self.Warning is not None:
            self.Warning.export(outfile, level, 'HTTPSessionObj:', name_='Warning', pretty_print=pretty_print)
        if self.DNT is not None:
            self.DNT.export(outfile, level, 'HTTPSessionObj:', name_='DNT', pretty_print=pretty_print)
        if self.X_Requested_With is not None:
            self.X_Requested_With.export(outfile, level, 'HTTPSessionObj:', name_='X_Requested_With', pretty_print=pretty_print)
        if self.X_Requested_For is not None:
            self.X_Requested_For.export(outfile, level, 'HTTPSessionObj:', name_='X_Requested_For', pretty_print=pretty_print)
        if self.X_ATT_DeviceId is not None:
            self.X_ATT_DeviceId.export(outfile, level, 'HTTPSessionObj:', name_='X_ATT_DeviceId', pretty_print=pretty_print)
        if self.X_Wap_Profile is not None:
            self.X_Wap_Profile.export(outfile, level, 'HTTPSessionObj:', name_='X_Wap_Profile', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HTTPRequestHeaderFieldsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Accept is not None:
            outfile.write('Accept=model_.cybox_common.StringObjectPropertyType(\n')
            self.Accept.exportLiteral(outfile, level, name_='Accept')
            outfile.write('),\n')
        if self.Accept_Charset is not None:
            outfile.write('Accept_Charset=model_.cybox_common.StringObjectPropertyType(\n')
            self.Accept_Charset.exportLiteral(outfile, level, name_='Accept_Charset')
            outfile.write('),\n')
        if self.Accept_Language is not None:
            outfile.write('Accept_Language=model_.cybox_common.StringObjectPropertyType(\n')
            self.Accept_Language.exportLiteral(outfile, level, name_='Accept_Language')
            outfile.write('),\n')
        if self.Accept_Datetime is not None:
            outfile.write('Accept_Datetime=model_.cybox_common.StringObjectPropertyType(\n')
            self.Accept_Datetime.exportLiteral(outfile, level, name_='Accept_Datetime')
            outfile.write('),\n')
        if self.Accept_Encoding is not None:
            outfile.write('Accept_Encoding=model_.cybox_common.StringObjectPropertyType(\n')
            self.Accept_Encoding.exportLiteral(outfile, level, name_='Accept_Encoding')
            outfile.write('),\n')
        if self.Authorization is not None:
            outfile.write('Authorization=model_.cybox_common.StringObjectPropertyType(\n')
            self.Authorization.exportLiteral(outfile, level, name_='Authorization')
            outfile.write('),\n')
        if self.Cache_Control is not None:
            outfile.write('Cache_Control=model_.cybox_common.StringObjectPropertyType(\n')
            self.Cache_Control.exportLiteral(outfile, level, name_='Cache_Control')
            outfile.write('),\n')
        if self.Connection is not None:
            outfile.write('Connection=model_.cybox_common.StringObjectPropertyType(\n')
            self.Connection.exportLiteral(outfile, level, name_='Connection')
            outfile.write('),\n')
        if self.Cookie is not None:
            outfile.write('Cookie=model_.cybox_common.StringObjectPropertyType(\n')
            self.Cookie.exportLiteral(outfile, level, name_='Cookie')
            outfile.write('),\n')
        if self.Content_Length is not None:
            outfile.write('Content_Length=model_.cybox_common.IntegerObjectPropertyType(\n')
            self.Content_Length.exportLiteral(outfile, level, name_='Content_Length')
            outfile.write('),\n')
        if self.Content_MD5 is not None:
            outfile.write('Content_MD5=model_.cybox_common.StringObjectPropertyType(\n')
            self.Content_MD5.exportLiteral(outfile, level, name_='Content_MD5')
            outfile.write('),\n')
        if self.Content_Type is not None:
            outfile.write('Content_Type=model_.cybox_common.StringObjectPropertyType(\n')
            self.Content_Type.exportLiteral(outfile, level, name_='Content_Type')
            outfile.write('),\n')
        if self.Date is not None:
            outfile.write('Date=model_.cybox_common.DateTimeObjectPropertyType(\n')
            self.Date.exportLiteral(outfile, level, name_='Date')
            outfile.write('),\n')
        if self.Expect is not None:
            outfile.write('Expect=model_.cybox_common.StringObjectPropertyType(\n')
            self.Expect.exportLiteral(outfile, level, name_='Expect')
            outfile.write('),\n')
        if self.From is not None:
            outfile.write('From=model_.address_object.AddressObjectType(\n')
            self.From.exportLiteral(outfile, level, name_='From')
            outfile.write('),\n')
        if self.Host is not None:
            outfile.write('Host=model_.HostFieldType(\n')
            self.Host.exportLiteral(outfile, level, name_='Host')
            outfile.write('),\n')
        if self.If_Match is not None:
            outfile.write('If_Match=model_.cybox_common.StringObjectPropertyType(\n')
            self.If_Match.exportLiteral(outfile, level, name_='If_Match')
            outfile.write('),\n')
        if self.If_Modified_Since is not None:
            outfile.write('If_Modified_Since=model_.cybox_common.DateTimeObjectPropertyType(\n')
            self.If_Modified_Since.exportLiteral(outfile, level, name_='If_Modified_Since')
            outfile.write('),\n')
        if self.If_None_Match is not None:
            outfile.write('If_None_Match=model_.cybox_common.StringObjectPropertyType(\n')
            self.If_None_Match.exportLiteral(outfile, level, name_='If_None_Match')
            outfile.write('),\n')
        if self.If_Range is not None:
            outfile.write('If_Range=model_.cybox_common.StringObjectPropertyType(\n')
            self.If_Range.exportLiteral(outfile, level, name_='If_Range')
            outfile.write('),\n')
        if self.If_Unmodified_Since is not None:
            outfile.write('If_Unmodified_Since=model_.cybox_common.DateTimeObjectPropertyType(\n')
            self.If_Unmodified_Since.exportLiteral(outfile, level, name_='If_Unmodified_Since')
            outfile.write('),\n')
        if self.Max_Forwards is not None:
            outfile.write('Max_Forwards=model_.cybox_common.IntegerObjectPropertyType(\n')
            self.Max_Forwards.exportLiteral(outfile, level, name_='Max_Forwards')
            outfile.write('),\n')
        if self.Pragma is not None:
            outfile.write('Pragma=model_.cybox_common.StringObjectPropertyType(\n')
            self.Pragma.exportLiteral(outfile, level, name_='Pragma')
            outfile.write('),\n')
        if self.Proxy_Authorization is not None:
            outfile.write('Proxy_Authorization=model_.cybox_common.StringObjectPropertyType(\n')
            self.Proxy_Authorization.exportLiteral(outfile, level, name_='Proxy_Authorization')
            outfile.write('),\n')
        if self.Range is not None:
            outfile.write('Range=model_.cybox_common.StringObjectPropertyType(\n')
            self.Range.exportLiteral(outfile, level, name_='Range')
            outfile.write('),\n')
        if self.Referer is not None:
            outfile.write('Referer=model_.uri_object.URIObjectType(\n')
            self.Referer.exportLiteral(outfile, level, name_='Referer')
            outfile.write('),\n')
        if self.TE is not None:
            outfile.write('TE=model_.cybox_common.StringObjectPropertyType(\n')
            self.TE.exportLiteral(outfile, level, name_='TE')
            outfile.write('),\n')
        if self.User_Agent is not None:
            outfile.write('User_Agent=model_.cybox_common.StringObjectPropertyType(\n')
            self.User_Agent.exportLiteral(outfile, level, name_='User_Agent')
            outfile.write('),\n')
        if self.Via is not None:
            outfile.write('Via=model_.cybox_common.StringObjectPropertyType(\n')
            self.Via.exportLiteral(outfile, level, name_='Via')
            outfile.write('),\n')
        if self.Warning is not None:
            outfile.write('Warning=model_.cybox_common.StringObjectPropertyType(\n')
            self.Warning.exportLiteral(outfile, level, name_='Warning')
            outfile.write('),\n')
        if self.DNT is not None:
            outfile.write('DNT=model_.uri_object.URIObjectType(\n')
            self.DNT.exportLiteral(outfile, level, name_='DNT')
            outfile.write('),\n')
        if self.X_Requested_With is not None:
            outfile.write('X_Requested_With=model_.cybox_common.StringObjectPropertyType(\n')
            self.X_Requested_With.exportLiteral(outfile, level, name_='X_Requested_With')
            outfile.write('),\n')
        if self.X_Requested_For is not None:
            outfile.write('X_Requested_For=model_.cybox_common.StringObjectPropertyType(\n')
            self.X_Requested_For.exportLiteral(outfile, level, name_='X_Requested_For')
            outfile.write('),\n')
        if self.X_ATT_DeviceId is not None:
            outfile.write('X_ATT_DeviceId=model_.cybox_common.StringObjectPropertyType(\n')
            self.X_ATT_DeviceId.exportLiteral(outfile, level, name_='X_ATT_DeviceId')
            outfile.write('),\n')
        if self.X_Wap_Profile is not None:
            outfile.write('X_Wap_Profile=model_.uri_object.URIObjectType(\n')
            self.X_Wap_Profile.exportLiteral(outfile, level, name_='X_Wap_Profile')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Accept':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Accept(obj_)
        elif nodeName_ == 'Accept_Charset':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Accept_Charset(obj_)
        elif nodeName_ == 'Accept_Language':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Accept_Language(obj_)
        elif nodeName_ == 'Accept_Datetime':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Accept_Datetime(obj_)
        elif nodeName_ == 'Accept_Encoding':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Accept_Encoding(obj_)
        elif nodeName_ == 'Authorization':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Authorization(obj_)
        elif nodeName_ == 'Cache_Control':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Cache_Control(obj_)
        elif nodeName_ == 'Connection':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Connection(obj_)
        elif nodeName_ == 'Cookie':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Cookie(obj_)
        elif nodeName_ == 'Content_Length':
            obj_ = cybox_common.IntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Content_Length(obj_)
        elif nodeName_ == 'Content_MD5':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Content_MD5(obj_)
        elif nodeName_ == 'Content_Type':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Content_Type(obj_)
        elif nodeName_ == 'Date':
            obj_ = cybox_common.DateTimeObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Date(obj_)
        elif nodeName_ == 'Expect':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Expect(obj_)
        elif nodeName_ == 'From':
            obj_ = address_object.AddressObjectType.factory()
            obj_.build(child_)
            self.set_From(obj_)
        elif nodeName_ == 'Host':
            obj_ = HostFieldType.factory()
            obj_.build(child_)
            self.set_Host(obj_)
        elif nodeName_ == 'If_Match':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_If_Match(obj_)
        elif nodeName_ == 'If_Modified_Since':
            obj_ = cybox_common.DateTimeObjectPropertyType.factory()
            obj_.build(child_)
            self.set_If_Modified_Since(obj_)
        elif nodeName_ == 'If_None_Match':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_If_None_Match(obj_)
        elif nodeName_ == 'If_Range':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_If_Range(obj_)
        elif nodeName_ == 'If_Unmodified_Since':
            obj_ = cybox_common.DateTimeObjectPropertyType.factory()
            obj_.build(child_)
            self.set_If_Unmodified_Since(obj_)
        elif nodeName_ == 'Max_Forwards':
            obj_ = cybox_common.IntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Max_Forwards(obj_)
        elif nodeName_ == 'Pragma':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Pragma(obj_)
        elif nodeName_ == 'Proxy_Authorization':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Proxy_Authorization(obj_)
        elif nodeName_ == 'Range':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Range(obj_)
        elif nodeName_ == 'Referer':
            obj_ = uri_object.URIObjectType.factory()
            obj_.build(child_)
            self.set_Referer(obj_)
        elif nodeName_ == 'TE':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_TE(obj_)
        elif nodeName_ == 'User_Agent':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_User_Agent(obj_)
        elif nodeName_ == 'Via':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Via(obj_)
        elif nodeName_ == 'Warning':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Warning(obj_)
        elif nodeName_ == 'DNT':
            obj_ = uri_object.URIObjectType.factory()
            obj_.build(child_)
            self.set_DNT(obj_)
        elif nodeName_ == 'X_Requested_With':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_X_Requested_With(obj_)
        elif nodeName_ == 'X_Requested_For':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_X_Requested_For(obj_)
        elif nodeName_ == 'X_ATT_DeviceId':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_X_ATT_DeviceId(obj_)
        elif nodeName_ == 'X_Wap_Profile':
            obj_ = uri_object.URIObjectType.factory()
            obj_.build(child_)
            self.set_X_Wap_Profile(obj_)
# end class HTTPRequestHeaderFieldsType

class HTTPResponseHeaderType(GeneratedsSuper):
    """The HTTPResponseHeaderType captures the raw or parsed header of an
    HTTP response."""
    member_data_items_ = {
        'Raw_Header': MemberSpec_('Raw_Header', 'cybox_common.StringObjectPropertyType', 0),
        'Parsed_Header': MemberSpec_('Parsed_Header', 'HTTPResponseHeaderFieldsType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, Raw_Header=None, Parsed_Header=None):
        self.Raw_Header = Raw_Header
        self.Parsed_Header = Parsed_Header
    def factory(*args_, **kwargs_):
        if HTTPResponseHeaderType.subclass:
            return HTTPResponseHeaderType.subclass(*args_, **kwargs_)
        else:
            return HTTPResponseHeaderType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Raw_Header(self): return self.Raw_Header
    def set_Raw_Header(self, Raw_Header): self.Raw_Header = Raw_Header
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Parsed_Header(self): return self.Parsed_Header
    def set_Parsed_Header(self, Parsed_Header): self.Parsed_Header = Parsed_Header
    def hasContent_(self):
        if (
            self.Raw_Header is not None or
            self.Parsed_Header is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPResponseHeaderType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HTTPResponseHeaderType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='HTTPSessionObj:', name_='HTTPResponseHeaderType'):
        pass
    def exportChildren(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPResponseHeaderType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Raw_Header is not None:
            if self.Raw_Header.get_valueOf_() is not None:
                value = self.Raw_Header.get_valueOf_()
                if not value.startswith('<![CDATA['):
                    value = '<![CDATA[' + value + ']]>'
                    self.Raw_Header.set_valueOf_(value)   
            self.Raw_Header.export(outfile, level, 'HTTPSessionObj:', name_='Raw_Header', pretty_print=pretty_print)
        if self.Parsed_Header is not None:
            self.Parsed_Header.export(outfile, level, 'HTTPSessionObj:', name_='Parsed_Header', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HTTPResponseHeaderType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Raw_Header is not None:
            outfile.write('Raw_Header=model_.cybox_common.StringObjectPropertyType(\n')
            self.Raw_Header.exportLiteral(outfile, level, name_='Raw_Header')
            outfile.write('),\n')
        if self.Parsed_Header is not None:
            outfile.write('Parsed_Header=model_.HTTPResponseHeaderFieldsType(\n')
            self.Parsed_Header.exportLiteral(outfile, level, name_='Parsed_Header')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Raw_Header':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Raw_Header(obj_)
        elif nodeName_ == 'Parsed_Header':
            obj_ = HTTPRequestHeaderFieldsType.factory()
            obj_.build(child_)
            self.set_Parsed_Header(obj_)
# end class HTTPResponseHeaderType

class HTTPResponseHeaderFieldsType(GeneratedsSuper):
    """The HTTPRequestHeaderFieldsType captures parsed HTTP request header
    fields."""
    member_data_items_ = {
        'Access_Control_Allow_Origin': MemberSpec_('Access_Control_Allow_Origin', 'cybox_common.StringObjectPropertyType', 0),
        'Accept_Ranges': MemberSpec_('Accept_Ranges', 'cybox_common.StringObjectPropertyType', 0),
        'Age': MemberSpec_('Age', 'cybox_common.IntegerObjectPropertyType', 0),
        'Cache_Control': MemberSpec_('Cache_Control', 'cybox_common.StringObjectPropertyType', 0),
        'Connection': MemberSpec_('Connection', 'cybox_common.StringObjectPropertyType', 0),
        'Content_Encoding': MemberSpec_('Content_Encoding', 'cybox_common.StringObjectPropertyType', 0),
        'Content_Language': MemberSpec_('Content_Language', 'cybox_common.StringObjectPropertyType', 0),
        'Content_Length': MemberSpec_('Content_Length', 'cybox_common.IntegerObjectPropertyType', 0),
        'Content_Location': MemberSpec_('Content_Location', 'cybox_common.StringObjectPropertyType', 0),
        'Content_MD5': MemberSpec_('Content_MD5', 'cybox_common.StringObjectPropertyType', 0),
        'Content_Disposition': MemberSpec_('Content_Disposition', 'cybox_common.StringObjectPropertyType', 0),
        'Content_Range': MemberSpec_('Content_Range', 'cybox_common.StringObjectPropertyType', 0),
        'Content_Type': MemberSpec_('Content_Type', 'cybox_common.StringObjectPropertyType', 0),
        'Date': MemberSpec_('Date', 'cybox_common.DateTimeObjectPropertyType', 0),
        'ETag': MemberSpec_('ETag', 'cybox_common.StringObjectPropertyType', 0),
        'Expires': MemberSpec_('Expires', 'cybox_common.DateTimeObjectPropertyType', 0),
        'Last_Modified': MemberSpec_('Last_Modified', 'cybox_common.DateTimeObjectPropertyType', 0),
        'Link': MemberSpec_('Link', 'cybox_common.StringObjectPropertyType', 0),
        'Location': MemberSpec_('Location', 'uri_object.URIObjectType', 0),
        'P3P': MemberSpec_('P3P', 'cybox_common.StringObjectPropertyType', 0),
        'Pragma': MemberSpec_('Pragma', 'cybox_common.StringObjectPropertyType', 0),
        'Proxy_Authenticate': MemberSpec_('Proxy_Authenticate', 'cybox_common.StringObjectPropertyType', 0),
        'Refresh': MemberSpec_('Refresh', 'cybox_common.IntegerObjectPropertyType', 0),
        'Retry_After': MemberSpec_('Retry_After', 'cybox_common.IntegerObjectPropertyType', 0),
        'Server': MemberSpec_('Server', 'cybox_common.StringObjectPropertyType', 0),
        'Set_Cookie': MemberSpec_('Set_Cookie', 'cybox_common.StringObjectPropertyType', 0),
        'Strict_Transport_Security': MemberSpec_('Strict_Transport_Security', 'cybox_common.StringObjectPropertyType', 0),
        'Trailer': MemberSpec_('Trailer', 'cybox_common.StringObjectPropertyType', 0),
        'Transfer_Encoding': MemberSpec_('Transfer_Encoding', 'cybox_common.StringObjectPropertyType', 0),
        'Vary': MemberSpec_('Vary', 'uri_object.URIObjectType', 0),
        'Via': MemberSpec_('Via', 'cybox_common.StringObjectPropertyType', 0),
        'Warning': MemberSpec_('Warning', 'cybox_common.StringObjectPropertyType', 0),
        'WWW_Authenticate': MemberSpec_('WWW_Authenticate', 'cybox_common.StringObjectPropertyType', 0),
        'X_Frame_Options': MemberSpec_('X_Frame_Options', 'cybox_common.StringObjectPropertyType', 0),
        'X_XSS_Protection': MemberSpec_('X_XSS_Protection', 'cybox_common.StringObjectPropertyType', 0),
        'X_Content_Type_Options': MemberSpec_('X_Content_Type_Options', 'cybox_common.StringObjectPropertyType', 0),
        'X_Forwarded_Proto': MemberSpec_('X_Forwarded_Proto', 'cybox_common.StringObjectPropertyType', 0),
        'X_Powered_By': MemberSpec_('X_Powered_By', 'cybox_common.StringObjectPropertyType', 0),
        'X_UA_Compatible': MemberSpec_('X_UA_Compatible', 'cybox_common.StringObjectPropertyType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, Access_Control_Allow_Origin=None, Accept_Ranges=None, Age=None, Cache_Control=None, Connection=None, Content_Encoding=None, Content_Language=None, Content_Length=None, Content_Location=None, Content_MD5=None, Content_Disposition=None, Content_Range=None, Content_Type=None, Date=None, ETag=None, Expires=None, Last_Modified=None, Link=None, Location=None, P3P=None, Pragma=None, Proxy_Authenticate=None, Refresh=None, Retry_After=None, Server=None, Set_Cookie=None, Strict_Transport_Security=None, Trailer=None, Transfer_Encoding=None, Vary=None, Via=None, Warning=None, WWW_Authenticate=None, X_Frame_Options=None, X_XSS_Protection=None, X_Content_Type_Options=None, X_Forwarded_Proto=None, X_Powered_By=None, X_UA_Compatible=None):
        self.Access_Control_Allow_Origin = Access_Control_Allow_Origin
        self.Accept_Ranges = Accept_Ranges
        self.Age = Age
        self.Cache_Control = Cache_Control
        self.Connection = Connection
        self.Content_Encoding = Content_Encoding
        self.Content_Language = Content_Language
        self.Content_Length = Content_Length
        self.Content_Location = Content_Location
        self.Content_MD5 = Content_MD5
        self.Content_Disposition = Content_Disposition
        self.Content_Range = Content_Range
        self.Content_Type = Content_Type
        self.Date = Date
        self.ETag = ETag
        self.Expires = Expires
        self.Last_Modified = Last_Modified
        self.Link = Link
        self.Location = Location
        self.P3P = P3P
        self.Pragma = Pragma
        self.Proxy_Authenticate = Proxy_Authenticate
        self.Refresh = Refresh
        self.Retry_After = Retry_After
        self.Server = Server
        self.Set_Cookie = Set_Cookie
        self.Strict_Transport_Security = Strict_Transport_Security
        self.Trailer = Trailer
        self.Transfer_Encoding = Transfer_Encoding
        self.Vary = Vary
        self.Via = Via
        self.Warning = Warning
        self.WWW_Authenticate = WWW_Authenticate
        self.X_Frame_Options = X_Frame_Options
        self.X_XSS_Protection = X_XSS_Protection
        self.X_Content_Type_Options = X_Content_Type_Options
        self.X_Forwarded_Proto = X_Forwarded_Proto
        self.X_Powered_By = X_Powered_By
        self.X_UA_Compatible = X_UA_Compatible
    def factory(*args_, **kwargs_):
        if HTTPResponseHeaderFieldsType.subclass:
            return HTTPResponseHeaderFieldsType.subclass(*args_, **kwargs_)
        else:
            return HTTPResponseHeaderFieldsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Access_Control_Allow_Origin(self): return self.Access_Control_Allow_Origin
    def set_Access_Control_Allow_Origin(self, Access_Control_Allow_Origin): self.Access_Control_Allow_Origin = Access_Control_Allow_Origin
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Accept_Ranges(self): return self.Accept_Ranges
    def set_Accept_Ranges(self, Accept_Ranges): self.Accept_Ranges = Accept_Ranges
    def get_Age(self): return self.Age
    def set_Age(self, Age): self.Age = Age
    def validate_IntegerObjectPropertyType(self, value):
        # Validate type cybox_common.IntegerObjectPropertyType, a restriction on None.
        pass
    def get_Cache_Control(self): return self.Cache_Control
    def set_Cache_Control(self, Cache_Control): self.Cache_Control = Cache_Control
    def get_Connection(self): return self.Connection
    def set_Connection(self, Connection): self.Connection = Connection
    def get_Content_Encoding(self): return self.Content_Encoding
    def set_Content_Encoding(self, Content_Encoding): self.Content_Encoding = Content_Encoding
    def get_Content_Language(self): return self.Content_Language
    def set_Content_Language(self, Content_Language): self.Content_Language = Content_Language
    def get_Content_Length(self): return self.Content_Length
    def set_Content_Length(self, Content_Length): self.Content_Length = Content_Length
    def get_Content_Location(self): return self.Content_Location
    def set_Content_Location(self, Content_Location): self.Content_Location = Content_Location
    def get_Content_MD5(self): return self.Content_MD5
    def set_Content_MD5(self, Content_MD5): self.Content_MD5 = Content_MD5
    def get_Content_Disposition(self): return self.Content_Disposition
    def set_Content_Disposition(self, Content_Disposition): self.Content_Disposition = Content_Disposition
    def get_Content_Range(self): return self.Content_Range
    def set_Content_Range(self, Content_Range): self.Content_Range = Content_Range
    def get_Content_Type(self): return self.Content_Type
    def set_Content_Type(self, Content_Type): self.Content_Type = Content_Type
    def get_Date(self): return self.Date
    def set_Date(self, Date): self.Date = Date
    def validate_DateTimeObjectPropertyType(self, value):
        # Validate type cybox_common.DateTimeObjectPropertyType, a restriction on None.
        pass
    def get_ETag(self): return self.ETag
    def set_ETag(self, ETag): self.ETag = ETag
    def get_Expires(self): return self.Expires
    def set_Expires(self, Expires): self.Expires = Expires
    def get_Last_Modified(self): return self.Last_Modified
    def set_Last_Modified(self, Last_Modified): self.Last_Modified = Last_Modified
    def get_Link(self): return self.Link
    def set_Link(self, Link): self.Link = Link
    def get_Location(self): return self.Location
    def set_Location(self, Location): self.Location = Location
    def get_P3P(self): return self.P3P
    def set_P3P(self, P3P): self.P3P = P3P
    def get_Pragma(self): return self.Pragma
    def set_Pragma(self, Pragma): self.Pragma = Pragma
    def get_Proxy_Authenticate(self): return self.Proxy_Authenticate
    def set_Proxy_Authenticate(self, Proxy_Authenticate): self.Proxy_Authenticate = Proxy_Authenticate
    def get_Refresh(self): return self.Refresh
    def set_Refresh(self, Refresh): self.Refresh = Refresh
    def get_Retry_After(self): return self.Retry_After
    def set_Retry_After(self, Retry_After): self.Retry_After = Retry_After
    def get_Server(self): return self.Server
    def set_Server(self, Server): self.Server = Server
    def get_Set_Cookie(self): return self.Set_Cookie
    def set_Set_Cookie(self, Set_Cookie): self.Set_Cookie = Set_Cookie
    def get_Strict_Transport_Security(self): return self.Strict_Transport_Security
    def set_Strict_Transport_Security(self, Strict_Transport_Security): self.Strict_Transport_Security = Strict_Transport_Security
    def get_Trailer(self): return self.Trailer
    def set_Trailer(self, Trailer): self.Trailer = Trailer
    def get_Transfer_Encoding(self): return self.Transfer_Encoding
    def set_Transfer_Encoding(self, Transfer_Encoding): self.Transfer_Encoding = Transfer_Encoding
    def get_Vary(self): return self.Vary
    def set_Vary(self, Vary): self.Vary = Vary
    def get_Via(self): return self.Via
    def set_Via(self, Via): self.Via = Via
    def get_Warning(self): return self.Warning
    def set_Warning(self, Warning): self.Warning = Warning
    def get_WWW_Authenticate(self): return self.WWW_Authenticate
    def set_WWW_Authenticate(self, WWW_Authenticate): self.WWW_Authenticate = WWW_Authenticate
    def get_X_Frame_Options(self): return self.X_Frame_Options
    def set_X_Frame_Options(self, X_Frame_Options): self.X_Frame_Options = X_Frame_Options
    def get_X_XSS_Protection(self): return self.X_XSS_Protection
    def set_X_XSS_Protection(self, X_XSS_Protection): self.X_XSS_Protection = X_XSS_Protection
    def get_X_Content_Type_Options(self): return self.X_Content_Type_Options
    def set_X_Content_Type_Options(self, X_Content_Type_Options): self.X_Content_Type_Options = X_Content_Type_Options
    def get_X_Forwarded_Proto(self): return self.X_Forwarded_Proto
    def set_X_Forwarded_Proto(self, X_Forwarded_Proto): self.X_Forwarded_Proto = X_Forwarded_Proto
    def get_X_Powered_By(self): return self.X_Powered_By
    def set_X_Powered_By(self, X_Powered_By): self.X_Powered_By = X_Powered_By
    def get_X_UA_Compatible(self): return self.X_UA_Compatible
    def set_X_UA_Compatible(self, X_UA_Compatible): self.X_UA_Compatible = X_UA_Compatible
    def hasContent_(self):
        if (
            self.Access_Control_Allow_Origin is not None or
            self.Accept_Ranges is not None or
            self.Age is not None or
            self.Cache_Control is not None or
            self.Connection is not None or
            self.Content_Encoding is not None or
            self.Content_Language is not None or
            self.Content_Length is not None or
            self.Content_Location is not None or
            self.Content_MD5 is not None or
            self.Content_Disposition is not None or
            self.Content_Range is not None or
            self.Content_Type is not None or
            self.Date is not None or
            self.ETag is not None or
            self.Expires is not None or
            self.Last_Modified is not None or
            self.Link is not None or
            self.Location is not None or
            self.P3P is not None or
            self.Pragma is not None or
            self.Proxy_Authenticate is not None or
            self.Refresh is not None or
            self.Retry_After is not None or
            self.Server is not None or
            self.Set_Cookie is not None or
            self.Strict_Transport_Security is not None or
            self.Trailer is not None or
            self.Transfer_Encoding is not None or
            self.Vary is not None or
            self.Via is not None or
            self.Warning is not None or
            self.WWW_Authenticate is not None or
            self.X_Frame_Options is not None or
            self.X_XSS_Protection is not None or
            self.X_Content_Type_Options is not None or
            self.X_Forwarded_Proto is not None or
            self.X_Powered_By is not None or
            self.X_UA_Compatible is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPResponseHeaderFieldsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HTTPResponseHeaderFieldsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='HTTPSessionObj:', name_='HTTPResponseHeaderFieldsType'):
        pass
    def exportChildren(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPResponseHeaderFieldsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Access_Control_Allow_Origin is not None:
            self.Access_Control_Allow_Origin.export(outfile, level, 'HTTPSessionObj:', name_='Access_Control_Allow_Origin', pretty_print=pretty_print)
        if self.Accept_Ranges is not None:
            self.Accept_Ranges.export(outfile, level, 'HTTPSessionObj:', name_='Accept_Ranges', pretty_print=pretty_print)
        if self.Age is not None:
            self.Age.export(outfile, level, 'HTTPSessionObj:', name_='Age', pretty_print=pretty_print)
        if self.Cache_Control is not None:
            self.Cache_Control.export(outfile, level, 'HTTPSessionObj:', name_='Cache_Control', pretty_print=pretty_print)
        if self.Connection is not None:
            self.Connection.export(outfile, level, 'HTTPSessionObj:', name_='Connection', pretty_print=pretty_print)
        if self.Content_Encoding is not None:
            self.Content_Encoding.export(outfile, level, 'HTTPSessionObj:', name_='Content_Encoding', pretty_print=pretty_print)
        if self.Content_Language is not None:
            self.Content_Language.export(outfile, level, 'HTTPSessionObj:', name_='Content_Language', pretty_print=pretty_print)
        if self.Content_Length is not None:
            self.Content_Length.export(outfile, level, 'HTTPSessionObj:', name_='Content_Length', pretty_print=pretty_print)
        if self.Content_Location is not None:
            self.Content_Location.export(outfile, level, 'HTTPSessionObj:', name_='Content_Location', pretty_print=pretty_print)
        if self.Content_MD5 is not None:
            self.Content_MD5.export(outfile, level, 'HTTPSessionObj:', name_='Content_MD5', pretty_print=pretty_print)
        if self.Content_Disposition is not None:
            self.Content_Disposition.export(outfile, level, 'HTTPSessionObj:', name_='Content_Disposition', pretty_print=pretty_print)
        if self.Content_Range is not None:
            self.Content_Range.export(outfile, level, 'HTTPSessionObj:', name_='Content_Range', pretty_print=pretty_print)
        if self.Content_Type is not None:
            self.Content_Type.export(outfile, level, 'HTTPSessionObj:', name_='Content_Type', pretty_print=pretty_print)
        if self.Date is not None:
            self.Date.export(outfile, level, 'HTTPSessionObj:', name_='Date', pretty_print=pretty_print)
        if self.ETag is not None:
            self.ETag.export(outfile, level, 'HTTPSessionObj:', name_='ETag', pretty_print=pretty_print)
        if self.Expires is not None:
            self.Expires.export(outfile, level, 'HTTPSessionObj:', name_='Expires', pretty_print=pretty_print)
        if self.Last_Modified is not None:
            self.Last_Modified.export(outfile, level, 'HTTPSessionObj:', name_='Last_Modified', pretty_print=pretty_print)
        if self.Link is not None:
            self.Link.export(outfile, level, 'HTTPSessionObj:', name_='Link', pretty_print=pretty_print)
        if self.Location is not None:
            self.Location.export(outfile, level, 'HTTPSessionObj:', name_='Location', pretty_print=pretty_print)
        if self.P3P is not None:
            self.P3P.export(outfile, level, 'HTTPSessionObj:', name_='P3P', pretty_print=pretty_print)
        if self.Pragma is not None:
            self.Pragma.export(outfile, level, 'HTTPSessionObj:', name_='Pragma', pretty_print=pretty_print)
        if self.Proxy_Authenticate is not None:
            self.Proxy_Authenticate.export(outfile, level, 'HTTPSessionObj:', name_='Proxy_Authenticate', pretty_print=pretty_print)
        if self.Refresh is not None:
            self.Refresh.export(outfile, level, 'HTTPSessionObj:', name_='Refresh', pretty_print=pretty_print)
        if self.Retry_After is not None:
            self.Retry_After.export(outfile, level, 'HTTPSessionObj:', name_='Retry_After', pretty_print=pretty_print)
        if self.Server is not None:
            self.Server.export(outfile, level, 'HTTPSessionObj:', name_='Server', pretty_print=pretty_print)
        if self.Set_Cookie is not None:
            self.Set_Cookie.export(outfile, level, 'HTTPSessionObj:', name_='Set_Cookie', pretty_print=pretty_print)
        if self.Strict_Transport_Security is not None:
            self.Strict_Transport_Security.export(outfile, level, 'HTTPSessionObj:', name_='Strict_Transport_Security', pretty_print=pretty_print)
        if self.Trailer is not None:
            self.Trailer.export(outfile, level, 'HTTPSessionObj:', name_='Trailer', pretty_print=pretty_print)
        if self.Transfer_Encoding is not None:
            self.Transfer_Encoding.export(outfile, level, 'HTTPSessionObj:', name_='Transfer_Encoding', pretty_print=pretty_print)
        if self.Vary is not None:
            self.Vary.export(outfile, level, 'HTTPSessionObj:', name_='Vary', pretty_print=pretty_print)
        if self.Via is not None:
            self.Via.export(outfile, level, 'HTTPSessionObj:', name_='Via', pretty_print=pretty_print)
        if self.Warning is not None:
            self.Warning.export(outfile, level, 'HTTPSessionObj:', name_='Warning', pretty_print=pretty_print)
        if self.WWW_Authenticate is not None:
            self.WWW_Authenticate.export(outfile, level, 'HTTPSessionObj:', name_='WWW_Authenticate', pretty_print=pretty_print)
        if self.X_Frame_Options is not None:
            self.X_Frame_Options.export(outfile, level, 'HTTPSessionObj:', name_='X_Frame_Options', pretty_print=pretty_print)
        if self.X_XSS_Protection is not None:
            self.X_XSS_Protection.export(outfile, level, 'HTTPSessionObj:', name_='X_XSS_Protection', pretty_print=pretty_print)
        if self.X_Content_Type_Options is not None:
            self.X_Content_Type_Options.export(outfile, level, 'HTTPSessionObj:', name_='X_Content_Type_Options', pretty_print=pretty_print)
        if self.X_Forwarded_Proto is not None:
            self.X_Forwarded_Proto.export(outfile, level, 'HTTPSessionObj:', name_='X_Forwarded_Proto', pretty_print=pretty_print)
        if self.X_Powered_By is not None:
            self.X_Powered_By.export(outfile, level, 'HTTPSessionObj:', name_='X_Powered_By', pretty_print=pretty_print)
        if self.X_UA_Compatible is not None:
            self.X_UA_Compatible.export(outfile, level, 'HTTPSessionObj:', name_='X_UA_Compatible', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HTTPResponseHeaderFieldsType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Access_Control_Allow_Origin is not None:
            outfile.write('Access_Control_Allow_Origin=model_.cybox_common.StringObjectPropertyType(\n')
            self.Access_Control_Allow_Origin.exportLiteral(outfile, level, name_='Access_Control_Allow_Origin')
            outfile.write('),\n')
        if self.Accept_Ranges is not None:
            outfile.write('Accept_Ranges=model_.cybox_common.StringObjectPropertyType(\n')
            self.Accept_Ranges.exportLiteral(outfile, level, name_='Accept_Ranges')
            outfile.write('),\n')
        if self.Age is not None:
            outfile.write('Age=model_.cybox_common.IntegerObjectPropertyType(\n')
            self.Age.exportLiteral(outfile, level, name_='Age')
            outfile.write('),\n')
        if self.Cache_Control is not None:
            outfile.write('Cache_Control=model_.cybox_common.StringObjectPropertyType(\n')
            self.Cache_Control.exportLiteral(outfile, level, name_='Cache_Control')
            outfile.write('),\n')
        if self.Connection is not None:
            outfile.write('Connection=model_.cybox_common.StringObjectPropertyType(\n')
            self.Connection.exportLiteral(outfile, level, name_='Connection')
            outfile.write('),\n')
        if self.Content_Encoding is not None:
            outfile.write('Content_Encoding=model_.cybox_common.StringObjectPropertyType(\n')
            self.Content_Encoding.exportLiteral(outfile, level, name_='Content_Encoding')
            outfile.write('),\n')
        if self.Content_Language is not None:
            outfile.write('Content_Language=model_.cybox_common.StringObjectPropertyType(\n')
            self.Content_Language.exportLiteral(outfile, level, name_='Content_Language')
            outfile.write('),\n')
        if self.Content_Length is not None:
            outfile.write('Content_Length=model_.cybox_common.IntegerObjectPropertyType(\n')
            self.Content_Length.exportLiteral(outfile, level, name_='Content_Length')
            outfile.write('),\n')
        if self.Content_Location is not None:
            outfile.write('Content_Location=model_.cybox_common.StringObjectPropertyType(\n')
            self.Content_Location.exportLiteral(outfile, level, name_='Content_Location')
            outfile.write('),\n')
        if self.Content_MD5 is not None:
            outfile.write('Content_MD5=model_.cybox_common.StringObjectPropertyType(\n')
            self.Content_MD5.exportLiteral(outfile, level, name_='Content_MD5')
            outfile.write('),\n')
        if self.Content_Disposition is not None:
            outfile.write('Content_Disposition=model_.cybox_common.StringObjectPropertyType(\n')
            self.Content_Disposition.exportLiteral(outfile, level, name_='Content_Disposition')
            outfile.write('),\n')
        if self.Content_Range is not None:
            outfile.write('Content_Range=model_.cybox_common.StringObjectPropertyType(\n')
            self.Content_Range.exportLiteral(outfile, level, name_='Content_Range')
            outfile.write('),\n')
        if self.Content_Type is not None:
            outfile.write('Content_Type=model_.cybox_common.StringObjectPropertyType(\n')
            self.Content_Type.exportLiteral(outfile, level, name_='Content_Type')
            outfile.write('),\n')
        if self.Date is not None:
            outfile.write('Date=model_.cybox_common.DateTimeObjectPropertyType(\n')
            self.Date.exportLiteral(outfile, level, name_='Date')
            outfile.write('),\n')
        if self.ETag is not None:
            outfile.write('ETag=model_.cybox_common.StringObjectPropertyType(\n')
            self.ETag.exportLiteral(outfile, level, name_='ETag')
            outfile.write('),\n')
        if self.Expires is not None:
            outfile.write('Expires=model_.cybox_common.DateTimeObjectPropertyType(\n')
            self.Expires.exportLiteral(outfile, level, name_='Expires')
            outfile.write('),\n')
        if self.Last_Modified is not None:
            outfile.write('Last_Modified=model_.cybox_common.DateTimeObjectPropertyType(\n')
            self.Last_Modified.exportLiteral(outfile, level, name_='Last_Modified')
            outfile.write('),\n')
        if self.Link is not None:
            outfile.write('Link=model_.cybox_common.StringObjectPropertyType(\n')
            self.Link.exportLiteral(outfile, level, name_='Link')
            outfile.write('),\n')
        if self.Location is not None:
            outfile.write('Location=model_.uri_object.URIObjectType(\n')
            self.Location.exportLiteral(outfile, level, name_='Location')
            outfile.write('),\n')
        if self.P3P is not None:
            outfile.write('P3P=model_.cybox_common.StringObjectPropertyType(\n')
            self.P3P.exportLiteral(outfile, level, name_='P3P')
            outfile.write('),\n')
        if self.Pragma is not None:
            outfile.write('Pragma=model_.cybox_common.StringObjectPropertyType(\n')
            self.Pragma.exportLiteral(outfile, level, name_='Pragma')
            outfile.write('),\n')
        if self.Proxy_Authenticate is not None:
            outfile.write('Proxy_Authenticate=model_.cybox_common.StringObjectPropertyType(\n')
            self.Proxy_Authenticate.exportLiteral(outfile, level, name_='Proxy_Authenticate')
            outfile.write('),\n')
        if self.Refresh is not None:
            outfile.write('Refresh=model_.cybox_common.IntegerObjectPropertyType(\n')
            self.Refresh.exportLiteral(outfile, level, name_='Refresh')
            outfile.write('),\n')
        if self.Retry_After is not None:
            outfile.write('Retry_After=model_.cybox_common.IntegerObjectPropertyType(\n')
            self.Retry_After.exportLiteral(outfile, level, name_='Retry_After')
            outfile.write('),\n')
        if self.Server is not None:
            outfile.write('Server=model_.cybox_common.StringObjectPropertyType(\n')
            self.Server.exportLiteral(outfile, level, name_='Server')
            outfile.write('),\n')
        if self.Set_Cookie is not None:
            outfile.write('Set_Cookie=model_.cybox_common.StringObjectPropertyType(\n')
            self.Set_Cookie.exportLiteral(outfile, level, name_='Set_Cookie')
            outfile.write('),\n')
        if self.Strict_Transport_Security is not None:
            outfile.write('Strict_Transport_Security=model_.cybox_common.StringObjectPropertyType(\n')
            self.Strict_Transport_Security.exportLiteral(outfile, level, name_='Strict_Transport_Security')
            outfile.write('),\n')
        if self.Trailer is not None:
            outfile.write('Trailer=model_.cybox_common.StringObjectPropertyType(\n')
            self.Trailer.exportLiteral(outfile, level, name_='Trailer')
            outfile.write('),\n')
        if self.Transfer_Encoding is not None:
            outfile.write('Transfer_Encoding=model_.cybox_common.StringObjectPropertyType(\n')
            self.Transfer_Encoding.exportLiteral(outfile, level, name_='Transfer_Encoding')
            outfile.write('),\n')
        if self.Vary is not None:
            outfile.write('Vary=model_.uri_object.URIObjectType(\n')
            self.Vary.exportLiteral(outfile, level, name_='Vary')
            outfile.write('),\n')
        if self.Via is not None:
            outfile.write('Via=model_.cybox_common.StringObjectPropertyType(\n')
            self.Via.exportLiteral(outfile, level, name_='Via')
            outfile.write('),\n')
        if self.Warning is not None:
            outfile.write('Warning=model_.cybox_common.StringObjectPropertyType(\n')
            self.Warning.exportLiteral(outfile, level, name_='Warning')
            outfile.write('),\n')
        if self.WWW_Authenticate is not None:
            outfile.write('WWW_Authenticate=model_.cybox_common.StringObjectPropertyType(\n')
            self.WWW_Authenticate.exportLiteral(outfile, level, name_='WWW_Authenticate')
            outfile.write('),\n')
        if self.X_Frame_Options is not None:
            outfile.write('X_Frame_Options=model_.cybox_common.StringObjectPropertyType(\n')
            self.X_Frame_Options.exportLiteral(outfile, level, name_='X_Frame_Options')
            outfile.write('),\n')
        if self.X_XSS_Protection is not None:
            outfile.write('X_XSS_Protection=model_.cybox_common.StringObjectPropertyType(\n')
            self.X_XSS_Protection.exportLiteral(outfile, level, name_='X_XSS_Protection')
            outfile.write('),\n')
        if self.X_Content_Type_Options is not None:
            outfile.write('X_Content_Type_Options=model_.cybox_common.StringObjectPropertyType(\n')
            self.X_Content_Type_Options.exportLiteral(outfile, level, name_='X_Content_Type_Options')
            outfile.write('),\n')
        if self.X_Forwarded_Proto is not None:
            outfile.write('X_Forwarded_Proto=model_.cybox_common.StringObjectPropertyType(\n')
            self.X_Forwarded_Proto.exportLiteral(outfile, level, name_='X_Forwarded_Proto')
            outfile.write('),\n')
        if self.X_Powered_By is not None:
            outfile.write('X_Powered_By=model_.cybox_common.StringObjectPropertyType(\n')
            self.X_Powered_By.exportLiteral(outfile, level, name_='X_Powered_By')
            outfile.write('),\n')
        if self.X_UA_Compatible is not None:
            outfile.write('X_UA_Compatible=model_.cybox_common.StringObjectPropertyType(\n')
            self.X_UA_Compatible.exportLiteral(outfile, level, name_='X_UA_Compatible')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Access_Control_Allow_Origin':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Access_Control_Allow_Origin(obj_)
        elif nodeName_ == 'Accept_Ranges':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Accept_Ranges(obj_)
        elif nodeName_ == 'Age':
            obj_ = cybox_common.IntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Age(obj_)
        elif nodeName_ == 'Cache_Control':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Cache_Control(obj_)
        elif nodeName_ == 'Connection':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Connection(obj_)
        elif nodeName_ == 'Content_Encoding':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Content_Encoding(obj_)
        elif nodeName_ == 'Content_Language':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Content_Language(obj_)
        elif nodeName_ == 'Content_Length':
            obj_ = cybox_common.IntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Content_Length(obj_)
        elif nodeName_ == 'Content_Location':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Content_Location(obj_)
        elif nodeName_ == 'Content_MD5':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Content_MD5(obj_)
        elif nodeName_ == 'Content_Disposition':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Content_Disposition(obj_)
        elif nodeName_ == 'Content_Range':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Content_Range(obj_)
        elif nodeName_ == 'Content_Type':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Content_Type(obj_)
        elif nodeName_ == 'Date':
            obj_ = cybox_common.DateTimeObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Date(obj_)
        elif nodeName_ == 'ETag':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_ETag(obj_)
        elif nodeName_ == 'Expires':
            obj_ = cybox_common.DateTimeObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Expires(obj_)
        elif nodeName_ == 'Last_Modified':
            obj_ = cybox_common.DateTimeObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Last_Modified(obj_)
        elif nodeName_ == 'Link':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Link(obj_)
        elif nodeName_ == 'Location':
            obj_ = uri_object.URIObjectType.factory()
            obj_.build(child_)
            self.set_Location(obj_)
        elif nodeName_ == 'P3P':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_P3P(obj_)
        elif nodeName_ == 'Pragma':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Pragma(obj_)
        elif nodeName_ == 'Proxy_Authenticate':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Proxy_Authenticate(obj_)
        elif nodeName_ == 'Refresh':
            obj_ = cybox_common.IntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Refresh(obj_)
        elif nodeName_ == 'Retry_After':
            obj_ = cybox_common.IntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Retry_After(obj_)
        elif nodeName_ == 'Server':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Server(obj_)
        elif nodeName_ == 'Set_Cookie':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Set_Cookie(obj_)
        elif nodeName_ == 'Strict_Transport_Security':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Strict_Transport_Security(obj_)
        elif nodeName_ == 'Trailer':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Trailer(obj_)
        elif nodeName_ == 'Transfer_Encoding':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Transfer_Encoding(obj_)
        elif nodeName_ == 'Vary':
            obj_ = uri_object.URIObjectType.factory()
            obj_.build(child_)
            self.set_Vary(obj_)
        elif nodeName_ == 'Via':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Via(obj_)
        elif nodeName_ == 'Warning':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Warning(obj_)
        elif nodeName_ == 'WWW_Authenticate':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_WWW_Authenticate(obj_)
        elif nodeName_ == 'X_Frame_Options':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_X_Frame_Options(obj_)
        elif nodeName_ == 'X_XSS_Protection':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_X_XSS_Protection(obj_)
        elif nodeName_ == 'X_Content_Type_Options':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_X_Content_Type_Options(obj_)
        elif nodeName_ == 'X_Forwarded_Proto':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_X_Forwarded_Proto(obj_)
        elif nodeName_ == 'X_Powered_By':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_X_Powered_By(obj_)
        elif nodeName_ == 'X_UA_Compatible':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_X_UA_Compatible(obj_)
# end class HTTPResponseHeaderFieldsType

class HTTPMessageType(GeneratedsSuper):
    """The HTTPMessageType captures a single HTTP message body and its
    length."""
    member_data_items_ = {
        'Length': MemberSpec_('Length', 'cybox_common.PositiveIntegerObjectPropertyType', 0),
        'Message_Body': MemberSpec_('Message_Body', 'cybox_common.StringObjectPropertyType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, Length=None, Message_Body=None):
        self.Length = Length
        self.Message_Body = Message_Body
    def factory(*args_, **kwargs_):
        if HTTPMessageType.subclass:
            return HTTPMessageType.subclass(*args_, **kwargs_)
        else:
            return HTTPMessageType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Length(self): return self.Length
    def set_Length(self, Length): self.Length = Length
    def validate_PositiveIntegerObjectPropertyType(self, value):
        # Validate type cybox_common.PositiveIntegerObjectPropertyType, a restriction on None.
        pass
    def get_Message_Body(self): return self.Message_Body
    def set_Message_Body(self, Message_Body): self.Message_Body = Message_Body
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def hasContent_(self):
        if (
            self.Length is not None or
            self.Message_Body is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPMessageType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HTTPMessageType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='HTTPSessionObj:', name_='HTTPMessageType'):
        pass
    def exportChildren(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPMessageType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Length is not None:
            self.Length.export(outfile, level, 'HTTPSessionObj:', name_='Length', pretty_print=pretty_print)
        if self.Message_Body is not None:
            self.Message_Body.export(outfile, level, 'HTTPSessionObj:', name_='Message_Body', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HTTPMessageType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Length is not None:
            outfile.write('Length=model_.cybox_common.PositiveIntegerObjectPropertyType(\n')
            self.Length.exportLiteral(outfile, level, name_='Length')
            outfile.write('),\n')
        if self.Message_Body is not None:
            outfile.write('Message_Body=model_.cybox_common.StringObjectPropertyType(\n')
            self.Message_Body.exportLiteral(outfile, level, name_='Message_Body')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Length':
            obj_ = cybox_common.PositiveIntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Length(obj_)
        elif nodeName_ == 'Message_Body':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Message_Body(obj_)
# end class HTTPMessageType

class HTTPStatusLineType(GeneratedsSuper):
    """The HTTPStatusLineType captures a single HTTP response status line."""
    member_data_items_ = {
        'Version': MemberSpec_('Version', 'cybox_common.StringObjectPropertyType', 0),
        'Status_Code': MemberSpec_('Status_Code', 'cybox_common.PositiveIntegerObjectPropertyType', 0),
        'Reason_Phrase': MemberSpec_('Reason_Phrase', 'cybox_common.StringObjectPropertyType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, Version=None, Status_Code=None, Reason_Phrase=None):
        self.Version = Version
        self.Status_Code = Status_Code
        self.Reason_Phrase = Reason_Phrase
    def factory(*args_, **kwargs_):
        if HTTPStatusLineType.subclass:
            return HTTPStatusLineType.subclass(*args_, **kwargs_)
        else:
            return HTTPStatusLineType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Version(self): return self.Version
    def set_Version(self, Version): self.Version = Version
    def validate_StringObjectPropertyType(self, value):
        # Validate type cybox_common.StringObjectPropertyType, a restriction on None.
        pass
    def get_Status_Code(self): return self.Status_Code
    def set_Status_Code(self, Status_Code): self.Status_Code = Status_Code
    def validate_PositiveIntegerObjectPropertyType(self, value):
        # Validate type cybox_common.PositiveIntegerObjectPropertyType, a restriction on None.
        pass
    def get_Reason_Phrase(self): return self.Reason_Phrase
    def set_Reason_Phrase(self, Reason_Phrase): self.Reason_Phrase = Reason_Phrase
    def hasContent_(self):
        if (
            self.Version is not None or
            self.Status_Code is not None or
            self.Reason_Phrase is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPStatusLineType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HTTPStatusLineType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='HTTPSessionObj:', name_='HTTPStatusLineType'):
        pass
    def exportChildren(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPStatusLineType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Version is not None:
            self.Version.export(outfile, level, 'HTTPSessionObj:', name_='Version', pretty_print=pretty_print)
        if self.Status_Code is not None:
            self.Status_Code.export(outfile, level, 'HTTPSessionObj:', name_='Status_Code', pretty_print=pretty_print)
        if self.Reason_Phrase is not None:
            self.Reason_Phrase.export(outfile, level, 'HTTPSessionObj:', name_='Reason_Phrase', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HTTPStatusLineType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Version is not None:
            outfile.write('Version=model_.cybox_common.StringObjectPropertyType(\n')
            self.Version.exportLiteral(outfile, level, name_='Version')
            outfile.write('),\n')
        if self.Status_Code is not None:
            outfile.write('Status_Code=model_.cybox_common.PositiveIntegerObjectPropertyType(\n')
            self.Status_Code.exportLiteral(outfile, level, name_='Status_Code')
            outfile.write('),\n')
        if self.Reason_Phrase is not None:
            outfile.write('Reason_Phrase=model_.cybox_common.StringObjectPropertyType(\n')
            self.Reason_Phrase.exportLiteral(outfile, level, name_='Reason_Phrase')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Version':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Version(obj_)
        elif nodeName_ == 'Status_Code':
            obj_ = cybox_common.PositiveIntegerObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Status_Code(obj_)
        elif nodeName_ == 'Reason_Phrase':
            obj_ = cybox_common.StringObjectPropertyType.factory()
            obj_.build(child_)
            self.set_Reason_Phrase(obj_)
# end class HTTPStatusLineType

class HostFieldType(GeneratedsSuper):
    """The HostFieldType captures the details of the HTTP request Host
    header field."""
    member_data_items_ = {
        'Domain_Name': MemberSpec_('Domain_Name', 'uri_object.URIObjectType', 0),
        'Port': MemberSpec_('Port', 'port_object.PortObjectType', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, Domain_Name=None, Port=None):
        self.Domain_Name = Domain_Name
        self.Port = Port
    def factory(*args_, **kwargs_):
        if HostFieldType.subclass:
            return HostFieldType.subclass(*args_, **kwargs_)
        else:
            return HostFieldType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Domain_Name(self): return self.Domain_Name
    def set_Domain_Name(self, Domain_Name): self.Domain_Name = Domain_Name
    def get_Port(self): return self.Port
    def set_Port(self, Port): self.Port = Port
    def hasContent_(self):
        if (
            self.Domain_Name is not None or
            self.Port is not None
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='HTTPSessionObj:', name_='HostFieldType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HostFieldType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='HTTPSessionObj:', name_='HostFieldType'):
        pass
    def exportChildren(self, outfile, level, namespace_='HTTPSessionObj:', name_='HostFieldType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Domain_Name is not None:
            self.Domain_Name.export(outfile, level, 'HTTPSessionObj:', name_='Domain_Name', pretty_print=pretty_print)
        if self.Port is not None:
            self.Port.export(outfile, level, 'HTTPSessionObj:', name_='Port', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HostFieldType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass
    def exportLiteralChildren(self, outfile, level, name_):
        if self.Domain_Name is not None:
            outfile.write('Domain_Name=model_.uri_object.URIObjectType(\n')
            self.Domain_Name.exportLiteral(outfile, level, name_='Domain_Name')
            outfile.write('),\n')
        if self.Port is not None:
            outfile.write('Port=model_.port_object.PortObjectType(\n')
            self.Port.exportLiteral(outfile, level, name_='Port')
            outfile.write('),\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Domain_Name':
            obj_ = uri_object.URIObjectType.factory()
            obj_.build(child_)
            self.set_Domain_Name(obj_)
        elif nodeName_ == 'Port':
            obj_ = port_object.PortObjectType.factory()
            obj_.build(child_)
            self.set_Port(obj_)
# end class HostFieldType

class HTTPMethodType(cybox_common.BaseObjectPropertyType):
    """HTTPMethodType specifies HTTP method types, via a union of the
    HTTPMethodEnum type and the atomic xs:string type. Its base type
    is the CybOX Core cybox_common.BaseObjectPropertyType, for permitting complex
    (i.e. regular-expression based) specifications.This attribute is
    optional and specifies the expected type for the value of the
    specified property."""
    member_data_items_ = {
        'datatype': MemberSpec_('datatype', 'cyboxCommon:DatatypeEnum', 0),
        'valueOf_': MemberSpec_('valueOf_', ['HTTPMethodType', 'cybox_common.BaseObjectPropertyType'], 0),
        }
    subclass = None
    superclass = cybox_common.BaseObjectPropertyType
    def __init__(self, obfuscation_algorithm_ref=None, refanging_transform_type=None, has_changed=None, pattern_type=None, datatype='string', refanging_transform=None, bit_mask=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, apply_condition='ANY', idref=None, is_defanged=None, id=None, condition=None, valueOf_=None):
        super(HTTPMethodType, self).__init__(obfuscation_algorithm_ref, refanging_transform_type, has_changed, pattern_type, datatype, refanging_transform, bit_mask, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, apply_condition, idref, is_defanged, id, condition, valueOf_, )
        self.datatype = _cast(None, datatype)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if HTTPMethodType.subclass:
            return HTTPMethodType.subclass(*args_, **kwargs_)
        else:
            return HTTPMethodType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_datatype(self): return self.datatype
    def set_datatype(self, datatype): self.datatype = datatype
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_ or
            super(HTTPMethodType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPMethodType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HTTPMethodType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(unicode(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='HTTPSessionObj:', name_='HTTPMethodType'):
        super(HTTPMethodType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='HTTPMethodType')
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            outfile.write(' datatype=%s' % (quote_attrib(self.datatype), ))
    def exportChildren(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPMethodType', fromsubclass_=False, pretty_print=True):
        super(HTTPMethodType, self).exportChildren(outfile, level, 'HTTPSessionObj:', name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='HTTPMethodType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.datatype is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            showIndent(outfile, level)
            outfile.write('datatype = %s,\n' % (self.datatype,))
        super(HTTPMethodType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(HTTPMethodType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('datatype', node)
        if value is not None and 'datatype' not in already_processed:
            already_processed.add('datatype')
            self.datatype = value
        super(HTTPMethodType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class HTTPMethodType

class HTTPSessionObjectType(cybox_common.ObjectPropertiesType):
    """The HTTPSessionObjectType is intended to capture the details of an
    HTTP session."""
    member_data_items_ = {
        'HTTP_Request_Response': MemberSpec_('HTTP_Request_Response', 'HTTPRequestResponseType', 1),
        }
    subclass = None
    superclass = cybox_common.ObjectPropertiesType
    def __init__(self, object_reference=None, Custom_Properties=None, xsi_type=None, HTTP_Request_Response=None):
        super(HTTPSessionObjectType, self).__init__(object_reference, Custom_Properties, xsi_type )
        if HTTP_Request_Response is None:
            self.HTTP_Request_Response = []
        else:
            self.HTTP_Request_Response = HTTP_Request_Response
    def factory(*args_, **kwargs_):
        if HTTPSessionObjectType.subclass:
            return HTTPSessionObjectType.subclass(*args_, **kwargs_)
        else:
            return HTTPSessionObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_HTTP_Request_Response(self): return self.HTTP_Request_Response
    def set_HTTP_Request_Response(self, HTTP_Request_Response): self.HTTP_Request_Response = HTTP_Request_Response
    def add_HTTP_Request_Response(self, value): self.HTTP_Request_Response.append(value)
    def insert_HTTP_Request_Response(self, index, value): self.HTTP_Request_Response[index] = value
    def hasContent_(self):
        if (
            self.HTTP_Request_Response or
            super(HTTPSessionObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPSessionObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='HTTPSessionObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='HTTPSessionObj:', name_='HTTPSessionObjectType'):
        super(HTTPSessionObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='HTTPSessionObjectType')
    def exportChildren(self, outfile, level, namespace_='HTTPSessionObj:', name_='HTTPSessionObjectType', fromsubclass_=False, pretty_print=True):
        super(HTTPSessionObjectType, self).exportChildren(outfile, level, 'HTTPSessionObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for HTTP_Request_Response_ in self.HTTP_Request_Response:
            HTTP_Request_Response_.export(outfile, level, 'HTTPSessionObj:', name_='HTTP_Request_Response', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='HTTPSessionObjectType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(HTTPSessionObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(HTTPSessionObjectType, self).exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('HTTP_Request_Response=[\n')
        level += 1
        for HTTP_Request_Response_ in self.HTTP_Request_Response:
            outfile.write('model_.HTTPRequestResponseType(\n')
            HTTP_Request_Response_.exportLiteral(outfile, level, name_='HTTPRequestResponseType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(HTTPSessionObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'HTTP_Request_Response':
            obj_ = HTTPRequestResponseType.factory()
            obj_.build(child_)
            self.HTTP_Request_Response.append(obj_)
        super(HTTPSessionObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class HTTPSessionObjectType

GDSClassesMapping = {
    'Build_Utility': cybox_common.BuildUtilityType,
    'Errors': cybox_common.ErrorsType,
    'Environment_Variable': cybox_common.EnvironmentVariableType,
    'Accept_Charset': cybox_common.StringObjectPropertyType,
    'Search_Distance': cybox_common.IntegerObjectPropertyType,
    'Error': cybox_common.ErrorType,
    'Certificate_Issuer': cybox_common.StringObjectPropertyType,
    'Max_Forwards': cybox_common.IntegerObjectPropertyType,
    'Proxy_Authorization': cybox_common.StringObjectPropertyType,
    'Metadata': cybox_common.MetadataType,
    'Hash': cybox_common.HashType,
    'Content_Range': cybox_common.StringObjectPropertyType,
    'User_Agent': cybox_common.StringObjectPropertyType,
    'Information_Source_Type': cybox_common.ControlledVocabularyStringType,
    'Internal_Strings': cybox_common.InternalStringsType,
    'Fuzzy_Hash_Structure': cybox_common.FuzzyHashStructureType,
    'SubDatum': cybox_common.MetadataType,
    'Segment_Hash': cybox_common.HashValueType,
    'Digital_Signature': cybox_common.DigitalSignatureInfoType,
    'X_Forwarded_Proto': cybox_common.StringObjectPropertyType,
    'X_ATT_DeviceId': cybox_common.StringObjectPropertyType,
    'Code_Snippets': cybox_common.CodeSnippetsType,
    'URI': uri_object.URIObjectType,
    'Value': cybox_common.AnyURIObjectPropertyType,
    'Length': cybox_common.IntegerObjectPropertyType,
    'If_Range': cybox_common.StringObjectPropertyType,
    'Reference': cybox_common.ReferenceType,
    'Strict_Transport_Security': cybox_common.StringObjectPropertyType,
    'Internationalization_Settings': cybox_common.InternationalizationSettingsType,
    'Encoding': cybox_common.ControlledVocabularyStringType,
    'Warning': cybox_common.StringObjectPropertyType,
    'English_Translation': cybox_common.StringObjectPropertyType,
    'Segments': cybox_common.HashSegmentsType,
    'Layer4_Protocol': port_object.Layer4ProtocolType,
    'Content_Length': cybox_common.IntegerObjectPropertyType,
    'X_UA_Compatible': cybox_common.StringObjectPropertyType,
    'Functions': cybox_common.FunctionsType,
    'From': address_object.AddressObjectType,
    'String_Value': cybox_common.StringObjectPropertyType,
    'If_Modified_Since': cybox_common.DateTimeObjectPropertyType,
    'Compiler_Informal_Description': cybox_common.CompilerInformalDescriptionType,
    'System': cybox_common.ObjectPropertiesType,
    'Platform': cybox_common.PlatformSpecificationType,
    'Version': cybox_common.StringObjectPropertyType,
    'Location': uri_object.URIObjectType,
    'Accept_Language': cybox_common.StringObjectPropertyType,
    'Error_Instances': cybox_common.ErrorInstancesType,
    'Type': cybox_common.ControlledVocabularyStringType,
    'Compilers': cybox_common.CompilersType,
    'Tool_Type': cybox_common.ControlledVocabularyStringType,
    'If_None_Match': cybox_common.StringObjectPropertyType,
    'Tool': cybox_common.ToolInformationType,
    'Build_Information': cybox_common.BuildInformationType,
    'Link': cybox_common.StringObjectPropertyType,
    'Search_Within': cybox_common.IntegerObjectPropertyType,
    'Tool_Hashes': cybox_common.HashListType,
    'X_Frame_Options': cybox_common.StringObjectPropertyType,
    'Message_Body': cybox_common.StringObjectPropertyType,
    'Raw_Header': cybox_common.StringObjectPropertyType,
    'Age': cybox_common.IntegerObjectPropertyType,
    'Retry_After': cybox_common.IntegerObjectPropertyType,
    'Server': cybox_common.StringObjectPropertyType,
    'Range': cybox_common.StringObjectPropertyType,
    'Certificate_Subject': cybox_common.StringObjectPropertyType,
    'Data_Segment': cybox_common.StringObjectPropertyType,
    'Property': cybox_common.PropertyType,
    'Strings': cybox_common.ExtractedStringsType,
    'Via': cybox_common.StringObjectPropertyType,
    'Tool_Specific_Data': cybox_common.ToolSpecificDataType,
    'Contributors': cybox_common.PersonnelType,
    'Transfer_Encoding': cybox_common.StringObjectPropertyType,
    'Reference_Description': cybox_common.StructuredTextType,
    'User_Account_Info': cybox_common.ObjectPropertiesType,
    'Expect': cybox_common.StringObjectPropertyType,
    'Execution_Environment': cybox_common.ExecutionEnvironmentType,
    'Configuration_Settings': cybox_common.ConfigurationSettingsType,
    'Compiler_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Byte_String_Value': cybox_common.HexBinaryObjectPropertyType,
    'Image_Offset': cybox_common.IntegerObjectPropertyType,
    'Reason_Phrase': cybox_common.StringObjectPropertyType,
    'Instance': cybox_common.ObjectPropertiesType,
    'Import': cybox_common.StringObjectPropertyType,
    'Authorization': cybox_common.StringObjectPropertyType,
    'Accept_Encoding': cybox_common.StringObjectPropertyType,
    'Identifier': cybox_common.PlatformIdentifierType,
    'X_Requested_For': cybox_common.StringObjectPropertyType,
    'X_XSS_Protection': cybox_common.StringObjectPropertyType,
    'X_Content_Type_Options': cybox_common.StringObjectPropertyType,
    'Domain_Name': uri_object.URIObjectType,
    'Dependencies': cybox_common.DependenciesType,
    'Cookie': cybox_common.StringObjectPropertyType,
    'Offset': cybox_common.IntegerObjectPropertyType,
    'Date': cybox_common.DateRangeType,
    'Referer': uri_object.URIObjectType,
    'Hashes': cybox_common.HashListType,
    'Content_Disposition': cybox_common.StringObjectPropertyType,
    'Cache_Control': cybox_common.StringObjectPropertyType,
    'Language': cybox_common.StringObjectPropertyType,
    'Usage_Context_Assumption': cybox_common.StructuredTextType,
    'Block_Hash': cybox_common.FuzzyHashBlockType,
    'DNT': uri_object.URIObjectType,
    'Connection': cybox_common.StringObjectPropertyType,
    'X_Requested_With': cybox_common.StringObjectPropertyType,
    'Time': cybox_common.TimeType,
    'P3P': cybox_common.StringObjectPropertyType,
    'If_Unmodified_Since': cybox_common.DateTimeObjectPropertyType,
    'Trigger_Point': cybox_common.HexBinaryObjectPropertyType,
    'Trailer': cybox_common.StringObjectPropertyType,
    'ETag': cybox_common.StringObjectPropertyType,
    'Byte_Run': cybox_common.ByteRunType,
    'File_System_Offset': cybox_common.IntegerObjectPropertyType,
    'Tool_Configuration': cybox_common.ToolConfigurationType,
    'Imports': cybox_common.ImportsType,
    'X_Powered_By': cybox_common.StringObjectPropertyType,
    'Vary': uri_object.URIObjectType,
    'Library': cybox_common.LibraryType,
    'References': cybox_common.ToolReferencesType,
    'Access_Control_Allow_Origin': cybox_common.StringObjectPropertyType,
    'Usage_Context_Assumptions': cybox_common.UsageContextAssumptionsType,
    'Block_Hash_Value': cybox_common.HashValueType,
    'Custom_Properties': cybox_common.CustomPropertiesType,
    'Status_Code': cybox_common.PositiveIntegerObjectPropertyType,
    'Configuration_Setting': cybox_common.ConfigurationSettingType,
    'Libraries': cybox_common.LibrariesType,
    'Content_Language': cybox_common.StringObjectPropertyType,
    'Content_Location': cybox_common.StringObjectPropertyType,
    'Content_MD5': cybox_common.StringObjectPropertyType,
    'Segment_Count': cybox_common.IntegerObjectPropertyType,
    'Function': cybox_common.StringObjectPropertyType,
    'Description': cybox_common.StructuredTextType,
    'Code_Snippet': cybox_common.ObjectPropertiesType,
    'Build_Configuration': cybox_common.BuildConfigurationType,
    'X_Wap_Profile': uri_object.URIObjectType,
    'Expires': cybox_common.DateTimeObjectPropertyType,
    'VLAN_Name': cybox_common.StringObjectPropertyType,
    'Content_Encoding': cybox_common.StringObjectPropertyType,
    'Pragma': cybox_common.StringObjectPropertyType,
    'Address': address_object.AddressObjectType,
    'TE': cybox_common.StringObjectPropertyType,
    'Segment': cybox_common.HashSegmentType,
    'Port_Value': cybox_common.PositiveIntegerObjectPropertyType,
    'Compiler': cybox_common.CompilerType,
    'Name': cybox_common.StringObjectPropertyType,
    'Set_Cookie': cybox_common.StringObjectPropertyType,
    'Address_Value': cybox_common.StringObjectPropertyType,
    'Dependency': cybox_common.DependencyType,
    'Accept_Datetime': cybox_common.StringObjectPropertyType,
    'Last_Modified': cybox_common.DateTimeObjectPropertyType,
    'Refresh': cybox_common.IntegerObjectPropertyType,
    'Content_Type': cybox_common.StringObjectPropertyType,
    'Signature_Description': cybox_common.StringObjectPropertyType,
    'Block_Size': cybox_common.IntegerObjectPropertyType,
    'Simple_Hash_Value': cybox_common.SimpleHashValueType,
    'Proxy_Authenticate': cybox_common.StringObjectPropertyType,
    'String': cybox_common.ExtractedStringType,
    'Tools': cybox_common.ToolsInformationType,
    'Build_Utility_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Fuzzy_Hash_Value': cybox_common.FuzzyHashValueType,
    'Accept': cybox_common.StringObjectPropertyType,
    'Data_Size': cybox_common.DataSizeType,
    'Dependency_Description': cybox_common.StructuredTextType,
    'WWW_Authenticate': cybox_common.StringObjectPropertyType,
    'Contributor': cybox_common.ContributorType,
    'If_Match': cybox_common.StringObjectPropertyType,
    'Accept_Ranges': cybox_common.StringObjectPropertyType,
    'Port': port_object.PortObjectType,
    'VLAN_Num': cybox_common.IntegerObjectPropertyType,
}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'HTTP_Session'
        rootClass = HTTPSessionObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
#    sys.stdout.write('<?xml version="1.0" ?>\n')
#    rootObj.export(sys.stdout, 0, name_=rootTag,
#        namespacedef_='',
#        pretty_print=True)
    return rootObj

def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'HTTP_Session'
        rootClass = HTTPSessionObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    rootElement = rootObj.to_etree(None, name_=rootTag)
    content = etree_.tostring(rootElement, pretty_print=True,
        xml_declaration=True, encoding="utf-8")
    sys.stdout.write(content)
    sys.stdout.write('\n')
    return rootObj, rootElement

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'HTTP_Session'
        rootClass = HTTPSessionObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
#    sys.stdout.write('<?xml version="1.0" ?>\n')
#    rootObj.export(sys.stdout, 0, name_="HTTP_Session",
#        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'HTTP_Session'
        rootClass = HTTPSessionObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('from datetime import datetime as datetime_\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "HTTPSessionObjectType",
    "HTTPRequestResponseType",
    "HTTPClientRequestType",
    "HTTPServerResponseType",
    "HTTPRequestLineType",
    "HTTPRequestHeaderType",
    "HTTPRequestHeaderFieldsType",
    "HTTPResponseHeaderType",
    "HTTPResponseHeaderFieldsType",
    "HTTPMessageType",
    "HTTPStatusLineType",
    "HostFieldType",
    "HTTPMethodType"
    ]
