#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2013, The MITRE Corporation. All rights reserved.
# See LICENSE.txt for complete terms.

#
# Generated Tue Apr 09 11:09:56 2013 by generateDS.py version 2.9a.
#

import sys
import getopt
import re as re_

import cybox_common
import base64
from datetime import datetime, tzinfo, timedelta

etree_ = None
Verbose_import_ = False
(   XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
    ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError(
                        "Failed to import ElementTree from any known place")

def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
        'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(tzinfo):
            def __init__(self, offset, name):
                self.__offset = timedelta(minutes = offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data
        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return input_data
        def gds_validate_datetime(self, input_data, node, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S')
            else:
                _svalue = input_data.strftime('%Y-%m-%dT%H:%M:%S.%f')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_datetime(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime.strptime(
                        input_data, '%Y-%m-%dT%H:%M:%S')
            return dt.replace(tzinfo = tz)

        def gds_validate_date(self, input_data, node, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = input_data.strftime('%Y-%m-%d')
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_parse_date(self, input_data, node, input_name=''):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'GMT')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            return datetime.strptime(input_data,
                '%Y-%m-%d').replace(tzinfo = tz)
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#

def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')

def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return unicode(s1).encode(ExternalEncoding)

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return unicode(s1).encode(ExternalEncoding)

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1

def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text

def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass

def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (
            msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' %
                (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' %
                (self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class RawArtifactType(cybox_common.StringObjectPropertyType):
    """The RawArtifactType is intended to convey, with minimal
    characterization, the content of the Raw Artifact itself."""
    member_data_items_ = {
        }
    subclass = None
    superclass = None
    def __init__(self, obfuscation_algorithm_ref=None, refanging_transform_type=None, has_changed=None, pattern_type=None, datatype='string', refanging_transform=None, bit_mask=None, appears_random=None, trend=None, defanging_algorithm_ref=None, is_obfuscated=None, regex_syntax=None, apply_condition='ANY', idref=None, is_defanged=None, id=None, condition=None, valueOf_=None, extensiontype_=None):
        super(RawArtifactType, self).__init__(obfuscation_algorithm_ref, refanging_transform_type, has_changed, pattern_type, datatype, refanging_transform, bit_mask, appears_random, trend, defanging_algorithm_ref, is_obfuscated, regex_syntax, apply_condition, idref, is_defanged, id, condition, valueOf_, extensiontype_)
    def factory(*args_, **kwargs_):
        if RawArtifactType.subclass:
            return RawArtifactType.subclass(*args_, **kwargs_)
        else:
            return RawArtifactType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(RawArtifactType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ArtifactObj:', name_='RawArtifactType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='RawArtifactType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(unicode(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ArtifactObj:', name_='RawArtifactType'):
        super(RawArtifactType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='RawArtifactType')
    def exportChildren(self, outfile, level, namespace_='ArtifactObj:', name_='RawArtifactType', fromsubclass_=False, pretty_print=True):
        super(RawArtifactType, self).exportChildren(outfile, level, 'ArtifactObj:', name_, True, pretty_print=pretty_print)
        pass
    def exportLiteral(self, outfile, level, name_='RawArtifactType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        super(RawArtifactType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(RawArtifactType, self).exportLiteralChildren(outfile, level, name_)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        super(RawArtifactType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(RawArtifactType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class RawArtifactType

class PackagingType(GeneratedsSuper):
    """The PackagingType captures any packaging layers applied to an
    artifact.The is_encrypted field is optional and specifies
    whether the Raw_Artifact content is protected/encrypted.The
    is_compressed field is optional and specifies whether the
    Raw_Artifact content is compressed."""
    member_data_items_ = {
        'is_compressed': MemberSpec_('is_compressed', 'xs:boolean', 0),
        'is_encrypted': MemberSpec_('is_encrypted', 'xs:boolean', 0),
        'Compression': MemberSpec_('Compression', 'CompressionType', 1),
        'Encryption': MemberSpec_('Encryption', 'EncryptionType', 1),
        'Encoding': MemberSpec_('Encoding', 'EncodingType', 1),
        }
    subclass = None
    superclass = None
    def __init__(self, is_compressed=None, is_encrypted=None, Compression=None, Encryption=None, Encoding=None):
        self.is_compressed = _cast(bool, is_compressed)
        self.is_encrypted = _cast(bool, is_encrypted)
        if Compression is None:
            self.Compression = []
        else:
            self.Compression = Compression
        if Encryption is None:
            self.Encryption = []
        else:
            self.Encryption = Encryption
        if Encoding is None:
            self.Encoding = []
        else:
            self.Encoding = Encoding
    def factory(*args_, **kwargs_):
        if PackagingType.subclass:
            return PackagingType.subclass(*args_, **kwargs_)
        else:
            return PackagingType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Compression(self): return self.Compression
    def set_Compression(self, Compression): self.Compression = Compression
    def add_Compression(self, value): self.Compression.append(value)
    def insert_Compression(self, index, value): self.Compression[index] = value
    def get_Encryption(self): return self.Encryption
    def set_Encryption(self, Encryption): self.Encryption = Encryption
    def add_Encryption(self, value): self.Encryption.append(value)
    def insert_Encryption(self, index, value): self.Encryption[index] = value
    def get_Encoding(self): return self.Encoding
    def set_Encoding(self, Encoding): self.Encoding = Encoding
    def add_Encoding(self, value): self.Encoding.append(value)
    def insert_Encoding(self, index, value): self.Encoding[index] = value
    def get_is_compressed(self): return self.is_compressed
    def set_is_compressed(self, is_compressed): self.is_compressed = is_compressed
    def get_is_encrypted(self): return self.is_encrypted
    def set_is_encrypted(self, is_encrypted): self.is_encrypted = is_encrypted
    def hasContent_(self):
        if (
            self.Compression or
            self.Encryption or
            self.Encoding
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ArtifactObj:', name_='PackagingType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PackagingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ArtifactObj:', name_='PackagingType'):
        if self.is_compressed is not None and 'is_compressed' not in already_processed:
            already_processed.add('is_compressed')
            outfile.write(' is_compressed="%s"' % self.gds_format_boolean(self.is_compressed, input_name='is_compressed'))
        if self.is_encrypted is not None and 'is_encrypted' not in already_processed:
            already_processed.add('is_encrypted')
            outfile.write(' is_encrypted="%s"' % self.gds_format_boolean(self.is_encrypted, input_name='is_encrypted'))
    def exportChildren(self, outfile, level, namespace_='ArtifactObj:', name_='PackagingType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for Compression_ in self.Compression:
            Compression_.export(outfile, level, 'ArtifactObj:', name_='Compression', pretty_print=pretty_print)
        for Encryption_ in self.Encryption:
            Encryption_.export(outfile, level, 'ArtifactObj:', name_='Encryption', pretty_print=pretty_print)
        for Encoding_ in self.Encoding:
            Encoding_.export(outfile, level, 'ArtifactObj:', name_='Encoding', pretty_print=pretty_print)
    def exportLiteral(self, outfile, level, name_='PackagingType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.is_compressed is not None and 'is_compressed' not in already_processed:
            already_processed.add('is_compressed')
            showIndent(outfile, level)
            outfile.write('is_compressed = %s,\n' % (self.is_compressed,))
        if self.is_encrypted is not None and 'is_encrypted' not in already_processed:
            already_processed.add('is_encrypted')
            showIndent(outfile, level)
            outfile.write('is_encrypted = %s,\n' % (self.is_encrypted,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('Compression=[\n')
        level += 1
        for Compression_ in self.Compression:
            outfile.write('model_.CompressionType(\n')
            Compression_.exportLiteral(outfile, level, name_='CompressionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Encryption=[\n')
        level += 1
        for Encryption_ in self.Encryption:
            outfile.write('model_.EncryptionType(\n')
            Encryption_.exportLiteral(outfile, level, name_='EncryptionType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('Encoding=[\n')
        level += 1
        for Encoding_ in self.Encoding:
            outfile.write('model_.EncodingType(\n')
            Encoding_.exportLiteral(outfile, level, name_='EncodingType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('is_compressed', node)
        if value is not None and 'is_compressed' not in already_processed:
            already_processed.add('is_compressed')
            if value in ('true', '1'):
                self.is_compressed = True
            elif value in ('false', '0'):
                self.is_compressed = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('is_encrypted', node)
        if value is not None and 'is_encrypted' not in already_processed:
            already_processed.add('is_encrypted')
            if value in ('true', '1'):
                self.is_encrypted = True
            elif value in ('false', '0'):
                self.is_encrypted = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Compression':
            obj_ = CompressionType.factory()
            obj_.build(child_)
            self.Compression.append(obj_)
        elif nodeName_ == 'Encryption':
            obj_ = EncryptionType.factory()
            obj_.build(child_)
            self.Encryption.append(obj_)
        elif nodeName_ == 'Encoding':
            obj_ = EncodingType.factory()
            obj_.build(child_)
            self.Encoding.append(obj_)
# end class PackagingType

class CompressionType(GeneratedsSuper):
    """The CompressionType captures any compression packaging details for
    an artifact.The compression_mechanism field is optional and
    specifies the compression algorithm utilized to protect the
    Raw_Artifact content.The compression_mechanism_ref field is
    optional and conveys a reference to a description of the
    compression algorithm utilized to protect the Raw_Artifact
    content."""
    member_data_items_ = {
        'compression_mechanism': MemberSpec_('compression_mechanism', 'xs:string', 0),
        'compression_mechanism_ref': MemberSpec_('compression_mechanism_ref', 'xs:anyURI', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, compression_mechanism=None, compression_mechanism_ref=None):
        self.compression_mechanism = _cast(None, compression_mechanism)
        self.compression_mechanism_ref = _cast(None, compression_mechanism_ref)
        pass
    def factory(*args_, **kwargs_):
        if CompressionType.subclass:
            return CompressionType.subclass(*args_, **kwargs_)
        else:
            return CompressionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_compression_mechanism(self): return self.compression_mechanism
    def set_compression_mechanism(self, compression_mechanism): self.compression_mechanism = compression_mechanism
    def get_compression_mechanism_ref(self): return self.compression_mechanism_ref
    def set_compression_mechanism_ref(self, compression_mechanism_ref): self.compression_mechanism_ref = compression_mechanism_ref
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ArtifactObj:', name_='CompressionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CompressionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ArtifactObj:', name_='CompressionType'):
        if self.compression_mechanism is not None and 'compression_mechanism' not in already_processed:
            already_processed.add('compression_mechanism')
            outfile.write(' compression_mechanism=%s' % (self.gds_format_string(quote_attrib(self.compression_mechanism).encode(ExternalEncoding), input_name='compression_mechanism'), ))
        if self.compression_mechanism_ref is not None and 'compression_mechanism_ref' not in already_processed:
            already_processed.add('compression_mechanism_ref')
            outfile.write(' compression_mechanism_ref=%s' % (self.gds_format_string(quote_attrib(self.compression_mechanism_ref).encode(ExternalEncoding), input_name='compression_mechanism_ref'), ))
    def exportChildren(self, outfile, level, namespace_='ArtifactObj:', name_='CompressionType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='CompressionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.compression_mechanism is not None and 'compression_mechanism' not in already_processed:
            already_processed.add('compression_mechanism')
            showIndent(outfile, level)
            outfile.write('compression_mechanism = "%s",\n' % (self.compression_mechanism,))
        if self.compression_mechanism_ref is not None and 'compression_mechanism_ref' not in already_processed:
            already_processed.add('compression_mechanism_ref')
            showIndent(outfile, level)
            outfile.write('compression_mechanism_ref = "%s",\n' % (self.compression_mechanism_ref,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('compression_mechanism', node)
        if value is not None and 'compression_mechanism' not in already_processed:
            already_processed.add('compression_mechanism')
            self.compression_mechanism = value
        value = find_attr_value_('compression_mechanism_ref', node)
        if value is not None and 'compression_mechanism_ref' not in already_processed:
            already_processed.add('compression_mechanism_ref')
            self.compression_mechanism_ref = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class CompressionType

class EncryptionType(GeneratedsSuper):
    """The EncryptionType captures any encryption packaging details for an
    artifact.The encryption_mechanism field is optional and
    specifies the protection/encryption algorithm utilized to
    protect the Raw_Artifact content.The encryption_mechanism_ref
    field is optional and conveys a reference to a description of
    the protection/encryption algorithm utilized to protect the
    Raw_Artifact content.The encryption_key field is optional and
    locally specifies the password for unprotecting/decrypting the
    Raw_Artifact content. The encryption_key_ref field is optional
    and specifies a reference to a remote specification of the
    password for unprotecting/decrypting the Raw_Artifact content."""
    member_data_items_ = {
        'encryption_mechanism': MemberSpec_('encryption_mechanism', 'xs:string', 0),
        'encryption_key_ref': MemberSpec_('encryption_key_ref', 'xs:anyURI', 0),
        'encryption_key': MemberSpec_('encryption_key', 'xs:string', 0),
        'encryption_mechanism_ref': MemberSpec_('encryption_mechanism_ref', 'xs:anyURI', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, encryption_mechanism=None, encryption_key_ref=None, encryption_key=None, encryption_mechanism_ref=None):
        self.encryption_mechanism = _cast(None, encryption_mechanism)
        self.encryption_key_ref = _cast(None, encryption_key_ref)
        self.encryption_key = _cast(None, encryption_key)
        self.encryption_mechanism_ref = _cast(None, encryption_mechanism_ref)
        pass
    def factory(*args_, **kwargs_):
        if EncryptionType.subclass:
            return EncryptionType.subclass(*args_, **kwargs_)
        else:
            return EncryptionType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_encryption_mechanism(self): return self.encryption_mechanism
    def set_encryption_mechanism(self, encryption_mechanism): self.encryption_mechanism = encryption_mechanism
    def get_encryption_key_ref(self): return self.encryption_key_ref
    def set_encryption_key_ref(self, encryption_key_ref): self.encryption_key_ref = encryption_key_ref
    def get_encryption_key(self): return self.encryption_key
    def set_encryption_key(self, encryption_key): self.encryption_key = encryption_key
    def get_encryption_mechanism_ref(self): return self.encryption_mechanism_ref
    def set_encryption_mechanism_ref(self, encryption_mechanism_ref): self.encryption_mechanism_ref = encryption_mechanism_ref
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ArtifactObj:', name_='EncryptionType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EncryptionType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ArtifactObj:', name_='EncryptionType'):
        if self.encryption_mechanism is not None and 'encryption_mechanism' not in already_processed:
            already_processed.add('encryption_mechanism')
            outfile.write(' encryption_mechanism=%s' % (self.gds_format_string(quote_attrib(self.encryption_mechanism).encode(ExternalEncoding), input_name='encryption_mechanism'), ))
        if self.encryption_key_ref is not None and 'encryption_key_ref' not in already_processed:
            already_processed.add('encryption_key_ref')
            outfile.write(' encryption_key_ref=%s' % (self.gds_format_string(quote_attrib(self.encryption_key_ref).encode(ExternalEncoding), input_name='encryption_key_ref'), ))
        if self.encryption_key is not None and 'encryption_key' not in already_processed:
            already_processed.add('encryption_key')
            outfile.write(' encryption_key=%s' % (self.gds_format_string(quote_attrib(self.encryption_key).encode(ExternalEncoding), input_name='encryption_key'), ))
        if self.encryption_mechanism_ref is not None and 'encryption_mechanism_ref' not in already_processed:
            already_processed.add('encryption_mechanism_ref')
            outfile.write(' encryption_mechanism_ref=%s' % (self.gds_format_string(quote_attrib(self.encryption_mechanism_ref).encode(ExternalEncoding), input_name='encryption_mechanism_ref'), ))
    def exportChildren(self, outfile, level, namespace_='ArtifactObj:', name_='EncryptionType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='EncryptionType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.encryption_mechanism is not None and 'encryption_mechanism' not in already_processed:
            already_processed.add('encryption_mechanism')
            showIndent(outfile, level)
            outfile.write('encryption_mechanism = "%s",\n' % (self.encryption_mechanism,))
        if self.encryption_key_ref is not None and 'encryption_key_ref' not in already_processed:
            already_processed.add('encryption_key_ref')
            showIndent(outfile, level)
            outfile.write('encryption_key_ref = "%s",\n' % (self.encryption_key_ref,))
        if self.encryption_key is not None and 'encryption_key' not in already_processed:
            already_processed.add('encryption_key')
            showIndent(outfile, level)
            outfile.write('encryption_key = "%s",\n' % (self.encryption_key,))
        if self.encryption_mechanism_ref is not None and 'encryption_mechanism_ref' not in already_processed:
            already_processed.add('encryption_mechanism_ref')
            showIndent(outfile, level)
            outfile.write('encryption_mechanism_ref = "%s",\n' % (self.encryption_mechanism_ref,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('encryption_mechanism', node)
        if value is not None and 'encryption_mechanism' not in already_processed:
            already_processed.add('encryption_mechanism')
            self.encryption_mechanism = value
        value = find_attr_value_('encryption_key_ref', node)
        if value is not None and 'encryption_key_ref' not in already_processed:
            already_processed.add('encryption_key_ref')
            self.encryption_key_ref = value
        value = find_attr_value_('encryption_key', node)
        if value is not None and 'encryption_key' not in already_processed:
            already_processed.add('encryption_key')
            self.encryption_key = value
        value = find_attr_value_('encryption_mechanism_ref', node)
        if value is not None and 'encryption_mechanism_ref' not in already_processed:
            already_processed.add('encryption_mechanism_ref')
            self.encryption_mechanism_ref = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class EncryptionType

class EncodingType(GeneratedsSuper):
    """The EncodingType captures any encoding packaging details for an
    artifact.The algorithm field is optional and specifies the
    encoding algorithm utilized to encode the Raw_Artifact.The
    character_set field is optional and specifies the character set
    utilized in the Raw_Artifact content encoding.The
    custom_character_set_ref field is optional and conveys a
    reference to a specification of the custom character set used to
    encode the Raw_Artifact."""
    member_data_items_ = {
        'custom_character_set_ref': MemberSpec_('custom_character_set_ref', 'xs:anyURI', 0),
        'character_set': MemberSpec_('character_set', 'xs:string', 0),
        'algorithm': MemberSpec_('algorithm', 'xs:string', 0),
        }
    subclass = None
    superclass = None
    def __init__(self, custom_character_set_ref=None, character_set=None, algorithm='Base64'):
        self.custom_character_set_ref = _cast(None, custom_character_set_ref)
        self.character_set = _cast(None, character_set)
        self.algorithm = _cast(None, algorithm)
        pass
    def factory(*args_, **kwargs_):
        if EncodingType.subclass:
            return EncodingType.subclass(*args_, **kwargs_)
        else:
            return EncodingType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_custom_character_set_ref(self): return self.custom_character_set_ref
    def set_custom_character_set_ref(self, custom_character_set_ref): self.custom_character_set_ref = custom_character_set_ref
    def get_character_set(self): return self.character_set
    def set_character_set(self, character_set): self.character_set = character_set
    def get_algorithm(self): return self.algorithm
    def set_algorithm(self, algorithm): self.algorithm = algorithm
    def hasContent_(self):
        if (

            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ArtifactObj:', name_='EncodingType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='EncodingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ArtifactObj:', name_='EncodingType'):
        if self.custom_character_set_ref is not None and 'custom_character_set_ref' not in already_processed:
            already_processed.add('custom_character_set_ref')
            outfile.write(' custom_character_set_ref=%s' % (self.gds_format_string(quote_attrib(self.custom_character_set_ref).encode(ExternalEncoding), input_name='custom_character_set_ref'), ))
        if self.character_set is not None and 'character_set' not in already_processed:
            already_processed.add('character_set')
            outfile.write(' character_set=%s' % (self.gds_format_string(quote_attrib(self.character_set).encode(ExternalEncoding), input_name='character_set'), ))
        if self.algorithm is not None and 'algorithm' not in already_processed:
            already_processed.add('algorithm')
            outfile.write(' algorithm=%s' % (self.gds_format_string(quote_attrib(self.algorithm).encode(ExternalEncoding), input_name='algorithm'), ))
    def exportChildren(self, outfile, level, namespace_='ArtifactObj:', name_='EncodingType', fromsubclass_=False, pretty_print=True):
        pass
    def exportLiteral(self, outfile, level, name_='EncodingType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.custom_character_set_ref is not None and 'custom_character_set_ref' not in already_processed:
            already_processed.add('custom_character_set_ref')
            showIndent(outfile, level)
            outfile.write('custom_character_set_ref = "%s",\n' % (self.custom_character_set_ref,))
        if self.character_set is not None and 'character_set' not in already_processed:
            already_processed.add('character_set')
            showIndent(outfile, level)
            outfile.write('character_set = "%s",\n' % (self.character_set,))
        if self.algorithm is not None and 'algorithm' not in already_processed:
            already_processed.add('algorithm')
            showIndent(outfile, level)
            outfile.write('algorithm = "%s",\n' % (self.algorithm,))
    def exportLiteralChildren(self, outfile, level, name_):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('custom_character_set_ref', node)
        if value is not None and 'custom_character_set_ref' not in already_processed:
            already_processed.add('custom_character_set_ref')
            self.custom_character_set_ref = value
        value = find_attr_value_('character_set', node)
        if value is not None and 'character_set' not in already_processed:
            already_processed.add('character_set')
            self.character_set = value
        value = find_attr_value_('algorithm', node)
        if value is not None and 'algorithm' not in already_processed:
            already_processed.add('algorithm')
            self.algorithm = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class EncodingType

class ArtifactObjectType(cybox_common.ObjectPropertiesType):
    """The ArtifactObjectType type is intended to encapsulate and convey
    the content of a Raw Artifact.The type field specifies the
    general type of the artifact contained in this Defined
    Object.The content_type field is optional and specifies the
    Internet Media Type of the artifact contained in this Defined
    Object.The content_type_version field is optional and specifies
    the content type version of the artifact contained in this
    Defined Object.The suspected_malicious field is optional and
    conveys whether the content of the Raw_Artifact is believed to
    be malicoius."""
    member_data_items_ = {
        'suspected_malicious': MemberSpec_('suspected_malicious', 'xs:boolean', 0),
        'content_type_version': MemberSpec_('content_type_version', 'xs:string', 0),
        'type': MemberSpec_('type', 'ArtifactObj:ArtifactTypeEnum', 0),
        'content_type': MemberSpec_('content_type', 'xs:string', 0),
        'Hashes': MemberSpec_('Hashes', 'cybox_common.HashListType', 0),
        'Packaging': MemberSpec_('Packaging', 'PackagingType', 0),
        'Raw_Artifact': MemberSpec_('Raw_Artifact', 'RawArtifactType', 0),
        'Raw_Artifact_Reference': MemberSpec_('Raw_Artifact_Reference', 'xs:anyURI', 0),
        }
    subclass = None
    superclass = cybox_common.ObjectPropertiesType
    def __init__(self, object_reference=None, Custom_Properties=None, xsi_type=None, suspected_malicious=None, content_type_version=None, type_=None, content_type=None, Hashes=None, Packaging=None, Raw_Artifact=None, Raw_Artifact_Reference=None):
        super(ArtifactObjectType, self).__init__(object_reference, Custom_Properties, xsi_type )
        self.suspected_malicious = _cast(bool, suspected_malicious)
        self.content_type_version = _cast(None, content_type_version)
        self.type_ = _cast(None, type_)
        self.content_type = _cast(None, content_type)
        self.Hashes = Hashes
        self.Packaging = Packaging
        self.Raw_Artifact = Raw_Artifact
        self.Raw_Artifact_Reference = Raw_Artifact_Reference
    def factory(*args_, **kwargs_):
        if ArtifactObjectType.subclass:
            return ArtifactObjectType.subclass(*args_, **kwargs_)
        else:
            return ArtifactObjectType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_Hashes(self): return self.Hashes
    def set_Hashes(self, Hashes): self.Hashes = Hashes
    def get_Packaging(self): return self.Packaging
    def set_Packaging(self, Packaging): self.Packaging = Packaging
    def get_Raw_Artifact(self): return self.Raw_Artifact
    def set_Raw_Artifact(self, Raw_Artifact): self.Raw_Artifact = Raw_Artifact
    def get_Raw_Artifact_Reference(self): return self.Raw_Artifact_Reference
    def set_Raw_Artifact_Reference(self, Raw_Artifact_Reference): self.Raw_Artifact_Reference = Raw_Artifact_Reference
    def get_suspected_malicious(self): return self.suspected_malicious
    def set_suspected_malicious(self, suspected_malicious): self.suspected_malicious = suspected_malicious
    def get_content_type_version(self): return self.content_type_version
    def set_content_type_version(self, content_type_version): self.content_type_version = content_type_version
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_content_type(self): return self.content_type
    def set_content_type(self, content_type): self.content_type = content_type
    def hasContent_(self):
        if (
            self.Hashes is not None or
            self.Packaging is not None or
            self.Raw_Artifact is not None or
            self.Raw_Artifact_Reference is not None or
            super(ArtifactObjectType, self).hasContent_()
            ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='ArtifactObj:', name_='ArtifactObjectType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ArtifactObjectType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='ArtifactObj:', name_='ArtifactObjectType'):
        super(ArtifactObjectType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='ArtifactObjectType')
        if self.suspected_malicious is not None and 'suspected_malicious' not in already_processed:
            already_processed.add('suspected_malicious')
            outfile.write(' suspected_malicious="%s"' % self.gds_format_boolean(self.suspected_malicious, input_name='suspected_malicious'))
        if self.content_type_version is not None and 'content_type_version' not in already_processed:
            already_processed.add('content_type_version')
            outfile.write(' content_type_version=%s' % (self.gds_format_string(quote_attrib(self.content_type_version).encode(ExternalEncoding), input_name='content_type_version'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.content_type is not None and 'content_type' not in already_processed:
            already_processed.add('content_type')
            outfile.write(' content_type=%s' % (self.gds_format_string(quote_attrib(self.content_type).encode(ExternalEncoding), input_name='content_type'), ))
    def exportChildren(self, outfile, level, namespace_='ArtifactObj:', name_='ArtifactObjectType', fromsubclass_=False, pretty_print=True):
        super(ArtifactObjectType, self).exportChildren(outfile, level, 'ArtifactObj:', name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Hashes is not None:
            self.Hashes.export(outfile, level, 'ArtifactObj:', name_='Hashes', pretty_print=pretty_print)
        if self.Packaging is not None:
            self.Packaging.export(outfile, level, 'ArtifactObj:', name_='Packaging', pretty_print=pretty_print)
        if self.Raw_Artifact is not None:
            if self.Raw_Artifact.get_valueOf_() is not None:
                value = self.Raw_Artifact.get_valueOf_()
                if not value.startswith('<![CDATA['):
                    value = '<![CDATA[' + value + ']]>'
                    self.Raw_Artifact.set_valueOf_(value)
            self.Raw_Artifact.export(outfile, level, 'ArtifactObj:', name_='Raw_Artifact', pretty_print=pretty_print)
        if self.Raw_Artifact_Reference is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRaw_Artifact_Reference>%s</%sRaw_Artifact_Reference>%s' % ('ArtifactObj:', self.gds_format_string(quote_xml(self.Raw_Artifact_Reference).encode(ExternalEncoding), input_name='Raw_Artifact_Reference'), 'ArtifactObj:', eol_))
    def exportLiteral(self, outfile, level, name_='ArtifactObjectType'):
        level += 1
        already_processed = set()
        self.exportLiteralAttributes(outfile, level, already_processed, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.suspected_malicious is not None and 'suspected_malicious' not in already_processed:
            already_processed.add('suspected_malicious')
            showIndent(outfile, level)
            outfile.write('suspected_malicious = %s,\n' % (self.suspected_malicious,))
        if self.content_type_version is not None and 'content_type_version' not in already_processed:
            already_processed.add('content_type_version')
            showIndent(outfile, level)
            outfile.write('content_type_version = "%s",\n' % (self.content_type_version,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            showIndent(outfile, level)
            outfile.write('type_ = %s,\n' % (self.type_,))
        if self.content_type is not None and 'content_type' not in already_processed:
            already_processed.add('content_type')
            showIndent(outfile, level)
            outfile.write('content_type = "%s",\n' % (self.content_type,))
        super(ArtifactObjectType, self).exportLiteralAttributes(outfile, level, already_processed, name_)
    def exportLiteralChildren(self, outfile, level, name_):
        super(ArtifactObjectType, self).exportLiteralChildren(outfile, level, name_)
        if self.Hashes is not None:
            outfile.write('Hashes=model_.cybox_common.HashListType(\n')
            self.Hashes.exportLiteral(outfile, level, name_='Hashes')
            outfile.write('),\n')
        if self.Packaging is not None:
            outfile.write('Packaging=model_.PackagingType(\n')
            self.Packaging.exportLiteral(outfile, level, name_='Packaging')
            outfile.write('),\n')
        if self.Raw_Artifact is not None:
            outfile.write('Raw_Artifact=model_.RawArtifactType(\n')
            self.Raw_Artifact.exportLiteral(outfile, level, name_='Raw_Artifact')
            outfile.write('),\n')
        if self.Raw_Artifact_Reference is not None:
            showIndent(outfile, level)
            outfile.write('Raw_Artifact_Reference=%s,\n' % quote_python(self.Raw_Artifact_Reference).encode(ExternalEncoding))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('suspected_malicious', node)
        if value is not None and 'suspected_malicious' not in already_processed:
            already_processed.add('suspected_malicious')
            if value in ('true', '1'):
                self.suspected_malicious = True
            elif value in ('false', '0'):
                self.suspected_malicious = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('content_type_version', node)
        if value is not None and 'content_type_version' not in already_processed:
            already_processed.add('content_type_version')
            self.content_type_version = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
        value = find_attr_value_('content_type', node)
        if value is not None and 'content_type' not in already_processed:
            already_processed.add('content_type')
            self.content_type = value
        super(ArtifactObjectType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'Hashes':
            obj_ = cybox_common.HashListType.factory()
            obj_.build(child_)
            self.set_Hashes(obj_)
        elif nodeName_ == 'Packaging':
            obj_ = PackagingType.factory()
            obj_.build(child_)
            self.set_Packaging(obj_)
        elif nodeName_ == 'Raw_Artifact':
            obj_ = RawArtifactType.factory()
            obj_.build(child_)
            self.set_Raw_Artifact(obj_)
        elif nodeName_ == 'Raw_Artifact_Reference':
            Raw_Artifact_Reference_ = child_.text
            Raw_Artifact_Reference_ = self.gds_validate_string(Raw_Artifact_Reference_, node, 'Raw_Artifact_Reference')
            self.Raw_Artifact_Reference = Raw_Artifact_Reference_
        super(ArtifactObjectType, self).buildChildren(child_, node, nodeName_, True)
# end class ArtifactObjectType

GDSClassesMapping = {
    'Build_Utility': cybox_common.BuildUtilityType,
    'Errors': cybox_common.ErrorsType,
    'Time': cybox_common.TimeType,
    'Certificate_Issuer': cybox_common.StringObjectPropertyType,
    'Metadata': cybox_common.MetadataType,
    'Hash': cybox_common.HashType,
    'Information_Source_Type': cybox_common.ControlledVocabularyStringType,
    'Block_Hash_Value': cybox_common.HashValueType,
    'Fuzzy_Hash_Structure': cybox_common.FuzzyHashStructureType,
    'SubDatum': cybox_common.MetadataType,
    'Segment_Hash': cybox_common.HashValueType,
    'Digital_Signature': cybox_common.DigitalSignatureInfoType,
    'Code_Snippets': cybox_common.CodeSnippetsType,
    'Value': cybox_common.StringObjectPropertyType,
    'Length': cybox_common.IntegerObjectPropertyType,
    'Reference': cybox_common.ReferenceType,
    'Encoding': cybox_common.ControlledVocabularyStringType,
    'Internationalization_Settings': cybox_common.InternationalizationSettingsType,
    'Tool_Configuration': cybox_common.ToolConfigurationType,
    'English_Translation': cybox_common.StringObjectPropertyType,
    'Functions': cybox_common.FunctionsType,
    'String_Value': cybox_common.StringObjectPropertyType,
    'Build_Utility_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Compiler_Informal_Description': cybox_common.CompilerInformalDescriptionType,
    'System': cybox_common.ObjectPropertiesType,
    'Platform': cybox_common.PlatformSpecificationType,
    'Usage_Context_Assumptions': cybox_common.UsageContextAssumptionsType,
    'Type': cybox_common.ControlledVocabularyStringType,
    'Compilers': cybox_common.CompilersType,
    'Tool_Type': cybox_common.ControlledVocabularyStringType,
    'String': cybox_common.ExtractedStringType,
    'Tool': cybox_common.ToolInformationType,
    'Build_Information': cybox_common.BuildInformationType,
    'Tool_Hashes': cybox_common.HashListType,
    'Compiler_Platform_Specification': cybox_common.PlatformSpecificationType,
    'Error_Instances': cybox_common.ErrorInstancesType,
    'Data_Segment': cybox_common.StringObjectPropertyType,
    'Certificate_Subject': cybox_common.StringObjectPropertyType,
    'Language': cybox_common.StringObjectPropertyType,
    'Property': cybox_common.PropertyType,
    'Strings': cybox_common.ExtractedStringsType,
    'File_System_Offset': cybox_common.IntegerObjectPropertyType,
    'Reference_Description': cybox_common.StructuredTextType,
    'Code_Snippet': cybox_common.ObjectPropertiesType,
    'Configuration_Settings': cybox_common.ConfigurationSettingsType,
    'Simple_Hash_Value': cybox_common.SimpleHashValueType,
    'Byte_String_Value': cybox_common.HexBinaryObjectPropertyType,
    'Instance': cybox_common.ObjectPropertiesType,
    'Import': cybox_common.StringObjectPropertyType,
    'Identifier': cybox_common.PlatformIdentifierType,
    'Tool_Specific_Data': cybox_common.ToolSpecificDataType,
    'Execution_Environment': cybox_common.ExecutionEnvironmentType,
    'Dependencies': cybox_common.DependenciesType,
    'Offset': cybox_common.IntegerObjectPropertyType,
    'Date': cybox_common.DateRangeType,
    'Hashes': cybox_common.HashListType,
    'Segments': cybox_common.HashSegmentsType,
    'Segment_Count': cybox_common.IntegerObjectPropertyType,
    'Usage_Context_Assumption': cybox_common.StructuredTextType,
    'Block_Hash': cybox_common.FuzzyHashBlockType,
    'Dependency': cybox_common.DependencyType,
    'Error': cybox_common.ErrorType,
    'Trigger_Point': cybox_common.HexBinaryObjectPropertyType,
    'Environment_Variable': cybox_common.EnvironmentVariableType,
    'Byte_Run': cybox_common.ByteRunType,
    'Contributors': cybox_common.PersonnelType,
    'Image_Offset': cybox_common.IntegerObjectPropertyType,
    'Imports': cybox_common.ImportsType,
    'Library': cybox_common.LibraryType,
    'References': cybox_common.ToolReferencesType,
    'Internal_Strings': cybox_common.InternalStringsType,
    'Custom_Properties': cybox_common.CustomPropertiesType,
    'Configuration_Setting': cybox_common.ConfigurationSettingType,
    'Libraries': cybox_common.LibrariesType,
    'Function': cybox_common.StringObjectPropertyType,
    'Description': cybox_common.StructuredTextType,
    'User_Account_Info': cybox_common.ObjectPropertiesType,
    'Build_Configuration': cybox_common.BuildConfigurationType,
    'Address': cybox_common.HexBinaryObjectPropertyType,
    'Search_Within': cybox_common.IntegerObjectPropertyType,
    'Segment': cybox_common.HashSegmentType,
    'Compiler': cybox_common.CompilerType,
    'Name': cybox_common.StringObjectPropertyType,
    'Signature_Description': cybox_common.StringObjectPropertyType,
    'Block_Size': cybox_common.IntegerObjectPropertyType,
    'Search_Distance': cybox_common.IntegerObjectPropertyType,
    'Fuzzy_Hash_Value': cybox_common.FuzzyHashValueType,
    'Dependency_Description': cybox_common.StructuredTextType,
    'Contributor': cybox_common.ContributorType,
    'Tools': cybox_common.ToolsInformationType,
    'Data_Size': cybox_common.DataSizeType,
}

USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)

def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass

def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Artifact'
        rootClass = ArtifactObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
#    sys.stdout.write('<?xml version="1.0" ?>\n')
#    rootObj.export(sys.stdout, 0, name_=rootTag,
#        namespacedef_='',
#        pretty_print=True)
    return rootObj

def parseEtree(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Artifact'
        rootClass = ArtifactObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    rootElement = rootObj.to_etree(None, name_=rootTag)
    content = etree_.tostring(rootElement, pretty_print=True,
        xml_declaration=True, encoding="utf-8")
    sys.stdout.write(content)
    sys.stdout.write('\n')
    return rootObj, rootElement

def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Artifact'
        rootClass = ArtifactObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
#    sys.stdout.write('<?xml version="1.0" ?>\n')
#    rootObj.export(sys.stdout, 0, name_="Artifact",
#        namespacedef_='')
    return rootObj

def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'Artifact'
        rootClass = ArtifactObjectType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from temp import *\n\n')
    sys.stdout.write('from datetime import datetime as datetime_\n\n')
    sys.stdout.write('import temp as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj

def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()

if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

__all__ = [
    "ArtifactObjectType",
    "RawArtifactType",
    "PackagingType",
    "CompressionType",
    "EncryptionType",
    "EncodingType"
    ]
