#!/usr/bin/env python
# vim: set fileencoding=utf-8 :
# @author: Manuel Guenther <Manuel.Guenther@idiap.ch>
# @date:   Fri May 11 17:20:46 CEST 2012
#
# Copyright (C) 2011-2012 Idiap Research Institute, Martigny, Switzerland
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""
The GBU (Good, Bad and Ugly) database consists of parts of the MBGC-V1 image set.
It defines three protocols, i.e., Good, Bad and Ugly for which different model and probe images are used.

Installation
------------
To be able to use this database, please have a look at the NIST webpage: http://www.nist.gov/itl/iad/ig/focs.cfm
and download:

* The Multiple Biometric Grand Challenge (MBGC)-V1 image database.

Unfortunately, the directory structure in this image database changed. If you have an older version of it,
and the ``bob_dbmanage.py gbu checkfiles --directory <YOUR_PATH_TO_MBGC-V1>`` fails (i.e. reports missing files), you have two possible options:

* Download the GBU-sigsets.zip file from https://github.com/bioidiap/xbob.db.gbu/downloads, extract the zip file to a directory of your choice and call
  ``bob_dbmanage.py gbu create --recreate --list-directory <YOUR_PATH_TO_THE_XML_LISTS> --rescan-image-directory <YOUR_PATH_TO_MBGC-V1>``
  (you might need root access to recreate the database)

* Copy (or link) the images of the MBGC-V1 database into a directory that has the required directory structure by calling:
  ``bob_dbmanage.py gbu copy-image-files --soft-link --original-image-directory <YOUR_PATH_TO_MBGC-V1> --new-image-directory <NEW_IMAGE_PATH_TO_BE_CREATED>``

To be sure that the procedure succeeded, please call ``bob_dbmanage.py gbu checkfiles --directory <YOUR_PATH_TO_MBGC-V1>``
or ``bob_dbmanage.py gbu checkfiles --directory <NEW_IMAGE_PATH_TO_BE_CREATED>`` afterwards.
If this fails again, your copy of the MBGC-V1 database is corrupted, and you might consider to get a new copy of it.

.. note::
  The lists from https://github.com/bioidiap/xbob.db.gbu/downloads contains the file lists as provided by the CSU Face Recognition Resources, see http://www.cs.colostate.edu/facerec/algorithms/baselines2011.php.
  In these files, the directory structure is adapted to our (the latest?) version of the MBGC-V1 database.


Creating the annotation files compatible with other xbob databases
------------------------------------------------------------------
The hand-labeled annotations of the eyes are stored in the database itself (after reading them from the file lists, see above).
Other databases provide the annotations in files, one file per image.
To be compatible with other databases, you can create the annotation files by calling:
``bob_dbmanage.py gbu create-annotation-files --directory <NEW_ANNOTATION_FILE_PATH_TO_BE_CREATED>``

.. note::
  Using these file lists for the GBU database is deprecated.
  Please query Database.annotations(file_id) instead.


Specialties of this database interface
--------------------------------------
This implementation of the GBU database wrapper provides two different types of protocols:

* 'gbu': In the original protocol models are extracted for each file. This means that there may be
  several models for the same client.
* 'multi': The new protocol provides one **or more** files for each model. Hence, only one model
  per client is generated.

There are slight differences between the two protocol types:

1. The amount of models differs, and so the amount of scores does.
2. The model id differs. For a 'multi' protocol, model id and client id are the same,
   whereas for a 'gbu' protocol, model id and file id are identical.
3. Only the results generated by the 'gbu' protocol are comparable to results that other groups reported on the GBU database.

.. note::
  To be consistent with results published in literature, the default protocol type is 'gbu'.

.. warning::
  **Do never mix 'gbu' and 'multi' protocol types. When you are lucky, you will get an exception,
  but also other weird things might happen!**


The three protocols 'Good', 'Bad' and 'Ugly' are provided for both protocol types.

Additionally, there are four different training sets (sub-worlds), called 'x1', 'x2', 'x4' and 'x8' with different
numbers of training images (the number of training identities is the same for all training sets).

The GBU protocols do only provide a 'dev' set, but no 'eval' set. The default measurement reported is the ROC curve on the 'dev' set.
When a single number is required, usually the FRR (or the CAR) at FAR=0.1% is reported by other researchers.
"""

from .query import Database

__all__ = ['Database']

