import os
from setuptools import setup

README = open(os.path.join(os.path.dirname(__file__), 'README.md')).read()
LICENCE = open(os.path.join(os.path.dirname(__file__), 'LICENCE.md')).read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name='django-highrise',
    version='0.2.1',
    packages=['django_highrise'],
    include_package_data=True,
    license=LICENCE,
    description='Highrise CRM integration for Django projects.',
    long_description=README,
    url='https://github.com/hugorodgerbrown/django-highrise',
    author='Hugo Rodger-Brown',
    author_email='hugo@yunojuno.com',
    classifiers=[
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
)
