##############################################################################
#
# Copyright (c) 2003 Zope Foundation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
""" Historical timezone data, ported from Zope2's DateTime.DateTimeZone.
"""
from __future__ import print_function

historical_zone_info = {
'Brazil/Acre': ('Brazil/Acre', 101, 2,
[ '561970800', '571644000', '593420400', '603093600', '625561200',
'634543200', '656924400', '665992800', '688374000', '697442400',
'719823600', '729496800', '751273200', '760946400', '782722800',
'792396000', '814863600', '823845600', '846226800', '855295200',
'877676400', '887436000', '909126000', '918799200', '940575600',
'950248800', '972716400', '981698400', '1004079600', '1013148000',
'1035529200', '1044597600', '1066978800', '1076738400', '1098428400',
'1108101600', '1129878000', '1139551200', '1162018800', '1171000800',
'1193382000', '1202450400', '1224831600', '1234591200', '1256281200',
'1265954400', '1287730800', '1297404000', '1319180400', '1328853600',
'1351234800', '1360303200', '1382684400', '1391752800', '1414134000',
'1423893600', '1445583600', '1455256800', '1477033200', '1486706400',
'1509174000', '1518156000', '1540537200', '1549605600', '1571986800',
'1581055200', '1603436400', '1613109600', '1634886000', '1644559200',
'1666335600', '1676008800', '1698476400', '1707458400', '1729839600',
'1738908000', '1761289200', '1771048800', '1792738800', '1802412000',
'1824188400', '1833861600', '1856329200', '1865311200', '1887692400',
'1896760800', '1919142000', '1928210400', '1950591600', '1960351200',
'1982041200', '1991714400', '2013490800', '2023164000', '2045631600',
'2054613600', '2076994800', '2086063200', '2108444400', '2118204000',
'2139894000',
],
'\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-18000, 0, 0), (-14400, 1, 4)], 'AST\x00ADT\x00'),
'Brazil/DeNoronha': ('Brazil/DeNoronha', 101, 2,
[ '561960000', '571633200', '593409600', '603082800', '625550400',
'634532400', '656913600', '665982000', '688363200', '697431600',
'719812800', '729486000', '751262400', '760935600', '782712000',
'792385200', '814852800', '823834800', '846216000', '855284400',
'877665600', '887425200', '909115200', '918788400', '940564800',
'950238000', '972705600', '981687600', '1004068800', '1013137200',
'1035518400', '1044586800', '1066968000', '1076727600', '1098417600',
'1108090800', '1129867200', '1139540400', '1162008000', '1170990000',
'1193371200', '1202439600', '1224820800', '1234580400', '1256270400',
'1265943600', '1287720000', '1297393200', '1319169600', '1328842800',
'1351224000', '1360292400', '1382673600', '1391742000', '1414123200',
'1423882800', '1445572800', '1455246000', '1477022400', '1486695600',
'1509163200', '1518145200', '1540526400', '1549594800', '1571976000',
'1581044400', '1603425600', '1613098800', '1634875200', '1644548400',
'1666324800', '1675998000', '1698465600', '1707447600', '1729828800',
'1738897200', '1761278400', '1771038000', '1792728000', '1802401200',
'1824177600', '1833850800', '1856318400', '1865300400', '1887681600',
'1896750000', '1919131200', '1928199600', '1950580800', '1960340400',
'1982030400', '1991703600', '2013480000', '2023153200', '2045620800',
'2054602800', '2076984000', '2086052400', '2108433600', '2118193200',
'2139883200',
],
'\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-7200, 0, 0), (-3600, 1, 4)], 'FST\x00FDT\x00'),
'Brazil/East': ('Brazil/East', 101, 2,
[ '561963600', '571636800', '593413200', '603086400', '625554000',
'634536000', '656917200', '665985600', '688366800', '697435200',
'719816400', '729489600', '751266000', '760939200', '782715600',
'792388800', '814856400', '823838400', '846219600', '855288000',
'877669200', '887428800', '909118800', '918792000', '940568400',
'950241600', '972709200', '981691200', '1004072400', '1013140800',
'1035522000', '1044590400', '1066971600', '1076731200', '1098421200',
'1108094400', '1129870800', '1139544000', '1162011600', '1170993600',
'1193374800', '1202443200', '1224824400', '1234584000', '1256274000',
'1265947200', '1287723600', '1297396800', '1319173200', '1328846400',
'1351227600', '1360296000', '1382677200', '1391745600', '1414126800',
'1423886400', '1445576400', '1455249600', '1477026000', '1486699200',
'1509166800', '1518148800', '1540530000', '1549598400', '1571979600',
'1581048000', '1603429200', '1613102400', '1634878800', '1644552000',
'1666328400', '1676001600', '1698469200', '1707451200', '1729832400',
'1738900800', '1761282000', '1771041600', '1792731600', '1802404800',
'1824181200', '1833854400', '1856322000', '1865304000', '1887685200',
'1896753600', '1919134800', '1928203200', '1950584400', '1960344000',
'1982034000', '1991707200', '2013483600', '2023156800', '2045624400',
'2054606400', '2076987600', '2086056000', '2108437200', '2118196800',
'2139886800',
],
'\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-10800, 0, 0), (-7200, 1, 4)], 'EST\x00EDT\x00'),
'Brazil/West': ('Brazil/West', 101, 2,
[ '561967200', '571640400', '593416800', '603090000', '625557600',
'634539600', '656920800', '665989200', '688370400', '697438800',
'719820000', '729493200', '751269600', '760942800', '782719200',
'792392400', '814860000', '823842000', '846223200', '855291600',
'877672800', '887432400', '909122400', '918795600', '940572000',
'950245200', '972712800', '981694800', '1004076000', '1013144400',
'1035525600', '1044594000', '1066975200', '1076734800', '1098424800',
'1108098000', '1129874400', '1139547600', '1162015200', '1170997200',
'1193378400', '1202446800', '1224828000', '1234587600', '1256277600',
'1265950800', '1287727200', '1297400400', '1319176800', '1328850000',
'1351231200', '1360299600', '1382680800', '1391749200', '1414130400',
'1423890000', '1445580000', '1455253200', '1477029600', '1486702800',
'1509170400', '1518152400', '1540533600', '1549602000', '1571983200',
'1581051600', '1603432800', '1613106000', '1634882400', '1644555600',
'1666332000', '1676005200', '1698472800', '1707454800', '1729836000',
'1738904400', '1761285600', '1771045200', '1792735200', '1802408400',
'1824184800', '1833858000', '1856325600', '1865307600', '1887688800',
'1896757200', '1919138400', '1928206800', '1950588000', '1960347600',
'1982037600', '1991710800', '2013487200', '2023160400', '2045628000',
'2054610000', '2076991200', '2086059600', '2108440800', '2118200400',
'2139890400',
],
'\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-14400, 0, 0), (-10800, 1, 4)], 'WST\x00WDT\x00'),
'Canada/Atlantic': ('Canada/Atlantic', 138, 2,
[ '-21492000', '-5770800', '9957600', '25678800', '41407200',
'57733200', '73461600', '89182800', '104911200', '120632400',
'136360800', '152082000', '167810400', '183531600', '199260000',
'215586000', '230709600', '247035600', '262764000', '278485200',
'294213600', '309934800', '325663200', '341384400', '357112800',
'372834000', '388562400', '404888400', '420012000', '436338000',
'452066400', '467787600', '483516000', '499237200', '514965600',
'530686800', '544600800', '562136400', '576050400', '594190800',
'607500000', '625640400', '638949600', '657090000', '671004000',
'688539600', '702453600', '719989200', '733903200', '752043600',
'765352800', '783493200', '796802400', '814942800', '828856800',
'846392400', '860306400', '877842000', '891756000', '909291600',
'923205600', '941346000', '954655200', '972795600', '986104800',
'1004245200', '1018159200', '1035694800', '1049608800', '1067144400',
'1081058400', '1099198800', '1112508000', '1130648400', '1143957600',
'1162098000', '1175407200', '1193547600', '1207461600', '1224997200',
'1238911200', '1256446800', '1270360800', '1288501200', '1301810400',
'1319950800', '1333260000', '1351400400', '1365314400', '1382850000',
'1396764000', '1414299600', '1428213600', '1445749200', '1459663200',
'1477803600', '1491112800', '1509253200', '1522562400', '1540702800',
'1554616800', '1572152400', '1586066400', '1603602000', '1617516000',
'1635656400', '1648965600', '1667106000', '1680415200', '1698555600',
'1712469600', '1730005200', '1743919200', '1761454800', '1775368800',
'1792904400', '1806818400', '1824958800', '1838268000', '1856408400',
'1869717600', '1887858000', '1901772000', '1919307600', '1933221600',
'1950757200', '1964671200', '1982811600', '1996120800', '2014261200',
'2027570400', '2045710800', '2059020000', '2077160400', '2091074400',
'2108610000', '2122524000', '2140059600',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-10800, 1, 0), (-14400, 0, 4)], 'ADT\x00AST\x00'),
'Canada/Central': ('Canada/Central', 138, 2,
[ '-21484800', '-5763600', '9964800', '25686000', '41414400',
'57740400', '73468800', '89190000', '104918400', '120639600',
'136368000', '152089200', '167817600', '183538800', '199267200',
'215593200', '230716800', '247042800', '262771200', '278492400',
'294220800', '309942000', '325670400', '341391600', '357120000',
'372841200', '388569600', '404895600', '420019200', '436345200',
'452073600', '467794800', '483523200', '499244400', '514972800',
'530694000', '544608000', '562143600', '576057600', '594198000',
'607507200', '625647600', '638956800', '657097200', '671011200',
'688546800', '702460800', '719996400', '733910400', '752050800',
'765360000', '783500400', '796809600', '814950000', '828864000',
'846399600', '860313600', '877849200', '891763200', '909298800',
'923212800', '941353200', '954662400', '972802800', '986112000',
'1004252400', '1018166400', '1035702000', '1049616000', '1067151600',
'1081065600', '1099206000', '1112515200', '1130655600', '1143964800',
'1162105200', '1175414400', '1193554800', '1207468800', '1225004400',
'1238918400', '1256454000', '1270368000', '1288508400', '1301817600',
'1319958000', '1333267200', '1351407600', '1365321600', '1382857200',
'1396771200', '1414306800', '1428220800', '1445756400', '1459670400',
'1477810800', '1491120000', '1509260400', '1522569600', '1540710000',
'1554624000', '1572159600', '1586073600', '1603609200', '1617523200',
'1635663600', '1648972800', '1667113200', '1680422400', '1698562800',
'1712476800', '1730012400', '1743926400', '1761462000', '1775376000',
'1792911600', '1806825600', '1824966000', '1838275200', '1856415600',
'1869724800', '1887865200', '1901779200', '1919314800', '1933228800',
'1950764400', '1964678400', '1982818800', '1996128000', '2014268400',
'2027577600', '2045718000', '2059027200', '2077167600', '2091081600',
'2108617200', '2122531200', '2140066800',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-18000, 1, 0), (-21600, 0, 4)], 'CDT\x00CST\x00'),
'Canada/East-Saskatchewan': ('Canada/East-Saskatchewan', 0, 1,
[ ],
'',
[(-21600, 0, 0)], 'CST\x00'),
'Canada/Eastern': ('Canada/Eastern', 138, 2,
[ '-21488400', '-5767200', '9961200', '25682400', '41410800',
'57736800', '73465200', '89186400', '104914800', '120636000',
'136364400', '152085600', '167814000', '183535200', '199263600',
'215589600', '230713200', '247039200', '262767600', '278488800',
'294217200', '309938400', '325666800', '341388000', '357116400',
'372837600', '388566000', '404892000', '420015600', '436341600',
'452070000', '467791200', '483519600', '499240800', '514969200',
'530690400', '544604400', '562140000', '576054000', '594194400',
'607503600', '625644000', '638953200', '657093600', '671007600',
'688543200', '702457200', '719992800', '733906800', '752047200',
'765356400', '783496800', '796806000', '814946400', '828860400',
'846396000', '860310000', '877845600', '891759600', '909295200',
'923209200', '941349600', '954658800', '972799200', '986108400',
'1004248800', '1018162800', '1035698400', '1049612400', '1067148000',
'1081062000', '1099202400', '1112511600', '1130652000', '1143961200',
'1162101600', '1175410800', '1193551200', '1207465200', '1225000800',
'1238914800', '1256450400', '1270364400', '1288504800', '1301814000',
'1319954400', '1333263600', '1351404000', '1365318000', '1382853600',
'1396767600', '1414303200', '1428217200', '1445752800', '1459666800',
'1477807200', '1491116400', '1509256800', '1522566000', '1540706400',
'1554620400', '1572156000', '1586070000', '1603605600', '1617519600',
'1635660000', '1648969200', '1667109600', '1680418800', '1698559200',
'1712473200', '1730008800', '1743922800', '1761458400', '1775372400',
'1792908000', '1806822000', '1824962400', '1838271600', '1856412000',
'1869721200', '1887861600', '1901775600', '1919311200', '1933225200',
'1950760800', '1964674800', '1982815200', '1996124400', '2014264800',
'2027574000', '2045714400', '2059023600', '2077164000', '2091078000',
'2108613600', '2122527600', '2140063200',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-14400, 1, 0), (-18000, 0, 4)], 'EDT\x00EST\x00'),
'Canada/Mountain': ('Canada/Mountain', 138, 2,
[ '-21481200', '-5760000', '9968400', '25689600', '41418000',
'57744000', '73472400', '89193600', '104922000', '120643200',
'136371600', '152092800', '167821200', '183542400', '199270800',
'215596800', '230720400', '247046400', '262774800', '278496000',
'294224400', '309945600', '325674000', '341395200', '357123600',
'372844800', '388573200', '404899200', '420022800', '436348800',
'452077200', '467798400', '483526800', '499248000', '514976400',
'530697600', '544611600', '562147200', '576061200', '594201600',
'607510800', '625651200', '638960400', '657100800', '671014800',
'688550400', '702464400', '720000000', '733914000', '752054400',
'765363600', '783504000', '796813200', '814953600', '828867600',
'846403200', '860317200', '877852800', '891766800', '909302400',
'923216400', '941356800', '954666000', '972806400', '986115600',
'1004256000', '1018170000', '1035705600', '1049619600', '1067155200',
'1081069200', '1099209600', '1112518800', '1130659200', '1143968400',
'1162108800', '1175418000', '1193558400', '1207472400', '1225008000',
'1238922000', '1256457600', '1270371600', '1288512000', '1301821200',
'1319961600', '1333270800', '1351411200', '1365325200', '1382860800',
'1396774800', '1414310400', '1428224400', '1445760000', '1459674000',
'1477814400', '1491123600', '1509264000', '1522573200', '1540713600',
'1554627600', '1572163200', '1586077200', '1603612800', '1617526800',
'1635667200', '1648976400', '1667116800', '1680426000', '1698566400',
'1712480400', '1730016000', '1743930000', '1761465600', '1775379600',
'1792915200', '1806829200', '1824969600', '1838278800', '1856419200',
'1869728400', '1887868800', '1901782800', '1919318400', '1933232400',
'1950768000', '1964682000', '1982822400', '1996131600', '2014272000',
'2027581200', '2045721600', '2059030800', '2077171200', '2091085200',
'2108620800', '2122534800', '2140070400',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-21600, 1, 0), (-25200, 0, 4)], 'MDT\x00MST\x00'),
'Canada/Newfoundland': ('Canada/Newfoundland', 138, 2,
[ '-21493800', '-5772600', '9955800', '25677000', '41405400',
'57731400', '73459800', '89181000', '104909400', '120630600',
'136359000', '152080200', '167808600', '183529800', '199258200',
'215584200', '230707800', '247033800', '262762200', '278483400',
'294211800', '309933000', '325661400', '341382600', '357111000',
'372832200', '388560600', '404886600', '420010200', '436336200',
'452064600', '467785800', '483514200', '499235400', '514963800',
'530685000', '544599000', '562134600', '576048600', '594189000',
'607498200', '625638600', '638947800', '657088200', '671002200',
'688537800', '702451800', '719987400', '733901400', '752041800',
'765351000', '783491400', '796800600', '814941000', '828855000',
'846390600', '860304600', '877840200', '891754200', '909289800',
'923203800', '941344200', '954653400', '972793800', '986103000',
'1004243400', '1018157400', '1035693000', '1049607000', '1067142600',
'1081056600', '1099197000', '1112506200', '1130646600', '1143955800',
'1162096200', '1175405400', '1193545800', '1207459800', '1224995400',
'1238909400', '1256445000', '1270359000', '1288499400', '1301808600',
'1319949000', '1333258200', '1351398600', '1365312600', '1382848200',
'1396762200', '1414297800', '1428211800', '1445747400', '1459661400',
'1477801800', '1491111000', '1509251400', '1522560600', '1540701000',
'1554615000', '1572150600', '1586064600', '1603600200', '1617514200',
'1635654600', '1648963800', '1667104200', '1680413400', '1698553800',
'1712467800', '1730003400', '1743917400', '1761453000', '1775367000',
'1792902600', '1806816600', '1824957000', '1838266200', '1856406600',
'1869715800', '1887856200', '1901770200', '1919305800', '1933219800',
'1950755400', '1964669400', '1982809800', '1996119000', '2014259400',
'2027568600', '2045709000', '2059018200', '2077158600', '2091072600',
'2108608200', '2122522200', '2140057800',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-9000, 1, 0), (-12600, 0, 4)], 'NDT\x00NST\x00'),
'Canada/Pacific': ('Canada/Pacific', 138, 2,
[ '-21477600', '-5756400', '9972000', '25693200', '41421600',
'57747600', '73476000', '89197200', '104925600', '120646800',
'136375200', '152096400', '167824800', '183546000', '199274400',
'215600400', '230724000', '247050000', '262778400', '278499600',
'294228000', '309949200', '325677600', '341398800', '357127200',
'372848400', '388576800', '404902800', '420026400', '436352400',
'452080800', '467802000', '483530400', '499251600', '514980000',
'530701200', '544615200', '562150800', '576064800', '594205200',
'607514400', '625654800', '638964000', '657104400', '671018400',
'688554000', '702468000', '720003600', '733917600', '752058000',
'765367200', '783507600', '796816800', '814957200', '828871200',
'846406800', '860320800', '877856400', '891770400', '909306000',
'923220000', '941360400', '954669600', '972810000', '986119200',
'1004259600', '1018173600', '1035709200', '1049623200', '1067158800',
'1081072800', '1099213200', '1112522400', '1130662800', '1143972000',
'1162112400', '1175421600', '1193562000', '1207476000', '1225011600',
'1238925600', '1256461200', '1270375200', '1288515600', '1301824800',
'1319965200', '1333274400', '1351414800', '1365328800', '1382864400',
'1396778400', '1414314000', '1428228000', '1445763600', '1459677600',
'1477818000', '1491127200', '1509267600', '1522576800', '1540717200',
'1554631200', '1572166800', '1586080800', '1603616400', '1617530400',
'1635670800', '1648980000', '1667120400', '1680429600', '1698570000',
'1712484000', '1730019600', '1743933600', '1761469200', '1775383200',
'1792918800', '1806832800', '1824973200', '1838282400', '1856422800',
'1869732000', '1887872400', '1901786400', '1919322000', '1933236000',
'1950771600', '1964685600', '1982826000', '1996135200', '2014275600',
'2027584800', '2045725200', '2059034400', '2077174800', '2091088800',
'2108624400', '2122538400', '2140074000',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-25200, 1, 0), (-28800, 0, 4)], 'PDT\x00PST\x00'),
'Canada/Yukon': ('Canada/Yukon', 138, 2,
[ '-21474000', '-5752800', '9975600', '25696800', '41425200',
'57751200', '73479600', '89200800', '104929200', '120650400',
'136378800', '152100000', '167828400', '183549600', '199278000',
'215604000', '230727600', '247053600', '262782000', '278503200',
'294231600', '309952800', '325681200', '341402400', '357130800',
'372852000', '388580400', '404906400', '420030000', '436356000',
'452084400', '467805600', '483534000', '499255200', '514983600',
'530704800', '544618800', '562154400', '576068400', '594208800',
'607518000', '625658400', '638967600', '657108000', '671022000',
'688557600', '702471600', '720007200', '733921200', '752061600',
'765370800', '783511200', '796820400', '814960800', '828874800',
'846410400', '860324400', '877860000', '891774000', '909309600',
'923223600', '941364000', '954673200', '972813600', '986122800',
'1004263200', '1018177200', '1035712800', '1049626800', '1067162400',
'1081076400', '1099216800', '1112526000', '1130666400', '1143975600',
'1162116000', '1175425200', '1193565600', '1207479600', '1225015200',
'1238929200', '1256464800', '1270378800', '1288519200', '1301828400',
'1319968800', '1333278000', '1351418400', '1365332400', '1382868000',
'1396782000', '1414317600', '1428231600', '1445767200', '1459681200',
'1477821600', '1491130800', '1509271200', '1522580400', '1540720800',
'1554634800', '1572170400', '1586084400', '1603620000', '1617534000',
'1635674400', '1648983600', '1667124000', '1680433200', '1698573600',
'1712487600', '1730023200', '1743937200', '1761472800', '1775386800',
'1792922400', '1806836400', '1824976800', '1838286000', '1856426400',
'1869735600', '1887876000', '1901790000', '1919325600', '1933239600',
'1950775200', '1964689200', '1982829600', '1996138800', '2014279200',
'2027588400', '2045728800', '2059038000', '2077178400', '2091092400',
'2108628000', '2122542000', '2140077600',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-28800, 1, 0), (-32400, 0, 4)], 'YDT\x00YST\x00'),
'Chile/Continental': ('Chile/Continental', 121, 2,
[ '245217600', '258519600', '276667200', '289969200', '308721600',
'321418800', '340171200', '352868400', '371620800', '384922800',
'403070400', '416372400', '434520000', '447822000', '466574400',
'479271600', '498024000', '510721200', '529473600', '542170800',
'560923200', '574225200', '592372800', '605674800', '623822400',
'637124400', '655876800', '668574000', '687326400', '700023600',
'718776000', '732078000', '750225600', '763527600', '781675200',
'794977200', '813124800', '826426800', '845179200', '857876400',
'876628800', '889326000', '908078400', '921380400', '939528000',
'952830000', '970977600', '984279600', '1003032000', '1015729200',
'1034481600', '1047178800', '1065931200', '1079233200', '1097380800',
'1110682800', '1128830400', '1142132400', '1160280000', '1173582000',
'1192334400', '1205031600', '1223784000', '1236481200', '1255233600',
'1268535600', '1286683200', '1299985200', '1318132800', '1331434800',
'1350187200', '1362884400', '1381636800', '1394334000', '1413086400',
'1425783600', '1444536000', '1457838000', '1475985600', '1489287600',
'1507435200', '1520737200', '1539489600', '1552186800', '1570939200',
'1583636400', '1602388800', '1615690800', '1633838400', '1647140400',
'1665288000', '1678590000', '1696737600', '1710039600', '1728792000',
'1741489200', '1760241600', '1772938800', '1791691200', '1804993200',
'1823140800', '1836442800', '1854590400', '1867892400', '1886644800',
'1899342000', '1918094400', '1930791600', '1949544000', '1962846000',
'1980993600', '1994295600', '2012443200', '2025745200', '2043892800',
'2057194800', '2075947200', '2088644400', '2107396800', '2120094000',
'2138846400',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00',
[(-10800, 1, 0), (-14400, 0, 4)], 'CDT\x00CST\x00'),
'Chile/EasterIsland': ('Chile/EasterIsland', 121, 2,
[ '245224800', '258526800', '276674400', '289976400', '308728800',
'321426000', '340178400', '352875600', '371628000', '384930000',
'403077600', '416379600', '434527200', '447829200', '466581600',
'479278800', '498031200', '510728400', '529480800', '542178000',
'560930400', '574232400', '592380000', '605682000', '623829600',
'637131600', '655884000', '668581200', '687333600', '700030800',
'718783200', '732085200', '750232800', '763534800', '781682400',
'794984400', '813132000', '826434000', '845186400', '857883600',
'876636000', '889333200', '908085600', '921387600', '939535200',
'952837200', '970984800', '984286800', '1003039200', '1015736400',
'1034488800', '1047186000', '1065938400', '1079240400', '1097388000',
'1110690000', '1128837600', '1142139600', '1160287200', '1173589200',
'1192341600', '1205038800', '1223791200', '1236488400', '1255240800',
'1268542800', '1286690400', '1299992400', '1318140000', '1331442000',
'1350194400', '1362891600', '1381644000', '1394341200', '1413093600',
'1425790800', '1444543200', '1457845200', '1475992800', '1489294800',
'1507442400', '1520744400', '1539496800', '1552194000', '1570946400',
'1583643600', '1602396000', '1615698000', '1633845600', '1647147600',
'1665295200', '1678597200', '1696744800', '1710046800', '1728799200',
'1741496400', '1760248800', '1772946000', '1791698400', '1805000400',
'1823148000', '1836450000', '1854597600', '1867899600', '1886652000',
'1899349200', '1918101600', '1930798800', '1949551200', '1962853200',
'1981000800', '1994302800', '2012450400', '2025752400', '2043900000',
'2057202000', '2075954400', '2088651600', '2107404000', '2120101200',
'2138853600',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00',
[(-18000, 1, 0), (-21600, 0, 4)], 'EDT\x00EST\x00'),
'Cuba': ('Cuba', 118, 2,
[ '290581200', '308721600', '322030800', '340171200', '358318800',
'371620800', '389768400', '403070400', '421218000', '434520000',
'453272400', '466574400', '484722000', '498024000', '516171600',
'529473600', '547621200', '560923200', '579070800', '592372800',
'611125200', '623822400', '642574800', '655876800', '674024400',
'687326400', '705474000', '718776000', '736923600', '750225600',
'768373200', '781675200', '800427600', '813124800', '831877200',
'845179200', '863326800', '876628800', '894776400', '908078400',
'926226000', '939528000', '958280400', '970977600', '989730000',
'1003032000', '1021179600', '1034481600', '1052629200', '1065931200',
'1084078800', '1097380800', '1115528400', '1128830400', '1147582800',
'1160280000', '1179032400', '1192334400', '1210482000', '1223784000',
'1241931600', '1255233600', '1273381200', '1286683200', '1304830800',
'1318132800', '1336885200', '1350187200', '1368334800', '1381636800',
'1399784400', '1413086400', '1431234000', '1444536000', '1462683600',
'1475985600', '1494738000', '1507435200', '1526187600', '1539489600',
'1557637200', '1570939200', '1589086800', '1602388800', '1620536400',
'1633838400', '1651986000', '1665288000', '1684040400', '1696737600',
'1715490000', '1728792000', '1746939600', '1760241600', '1778389200',
'1791691200', '1809838800', '1823140800', '1841893200', '1854590400',
'1873342800', '1886644800', '1904792400', '1918094400', '1936242000',
'1949544000', '1967691600', '1980993600', '1999141200', '2012443200',
'2031195600', '2043892800', '2062645200', '2075947200', '2094094800',
'2107396800', '2125544400', '2138846400',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-14400, 1, 0), (-18000, 0, 4)], 'CDT\x00CST\x00'),
'Egypt': ('Egypt', 152, 2,
[ '-305164800', '-291949200', '-273628800', '-260413200', '-242092800',
'-228877200', '-210556800', '-197341200', '-178934400', '-165718800',
'-147398400', '-134182800', '-115862400', '-102646800', '-84326400',
'-71110800', '-52704000', '-39488400', '-21168000', '-7952400',
'10368000', '23583600', '41904000', '55119600', '73526400',
'86742000', '105062400', '118278000', '136598400', '149814000',
'168134400', '181350000', '199756800', '212972400', '231292800',
'244508400', '262828800', '276044400', '294364800', '307580400',
'325987200', '339202800', '420595200', '433810800', '452217600',
'465433200', '483753600', '496969200', '515289600', '528505200',
'546825600', '560041200', '578448000', '591663600', '609984000',
'623199600', '641520000', '654735600', '673056000', '686271600',
'704678400', '717894000', '736214400', '749430000', '767750400',
'780966000', '799286400', '812502000', '830908800', '844124400',
'862444800', '875660400', '893980800', '907196400', '925516800',
'938732400', '957139200', '970354800', '988675200', '1001890800',
'1020211200', '1033426800', '1051747200', '1064962800', '1083369600',
'1096585200', '1114905600', '1128121200', '1146441600', '1159657200',
'1177977600', '1191193200', '1209600000', '1222815600', '1241136000',
'1254351600', '1272672000', '1285887600', '1304208000', '1317423600',
'1335830400', '1349046000', '1367366400', '1380582000', '1398902400',
'1412118000', '1430438400', '1443654000', '1462060800', '1475276400',
'1493596800', '1506812400', '1525132800', '1538348400', '1556668800',
'1569884400', '1588291200', '1601506800', '1619827200', '1633042800',
'1651363200', '1664578800', '1682899200', '1696114800', '1714521600',
'1727737200', '1746057600', '1759273200', '1777593600', '1790809200',
'1809129600', '1822345200', '1840752000', '1853967600', '1872288000',
'1885503600', '1903824000', '1917039600', '1935360000', '1948575600',
'1966982400', '1980198000', '1998518400', '2011734000', '2030054400',
'2043270000', '2061590400', '2074806000', '2093212800', '2106428400',
'2124748800', '2137964400',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(10800, 1, 0), (7200, 0, 8)], 'EET DST\x00EET\x00'),
'GB-Eire': ('GB-Eire', 241, 4,
[ '-1697238000', '-1680476400', '-1664146800', '-1650150000', '-1633906800',
'-1617490800', '-1601852400', '-1586041200', '-1570402800', '-1552172400',
'-1538348400', '-1522537200', '-1507503600', '-1490569200', '-1473634800',
'-1458342000', '-1441321200', '-1428879600', '-1410735600', '-1396220400',
'-1379286000', '-1364770800', '-1347836400', '-1333321200', '-1316386800',
'-1301266800', '-1284332400', '-1269817200', '-1252882800', '-1238367600',
'-1221433200', '-1206918000', '-1189983600', '-1175468400', '-1158534000',
'-1144018800', '-1127084400', '-1111964400', '-1095030000', '-1080514800',
'-1063580400', '-1049065200', '-1032130800', '-1017615600', '-1000681200',
'-986166000', '-969231600', '-950482800', '-942015600', '-904518000',
'-896050800', '-875487600', '-864601200', '-844038000', '-832546800',
'-812588400', '-798073200', '-781052400', '-772066800', '-764809200',
'-748479600', '-733359600', '-719449200', '-717030000', '-706748400',
'-699490800', '-687999600', '-668041200', '-654735600', '-636591600',
'-622076400', '-605746800', '-590626800', '-574297200', '-558572400',
'-542242800', '-527122800', '-512607600', '-496278000', '-481158000',
'-464223600', '-449708400', '-432774000', '-417654000', '-401324400',
'-386204400', '-369270000', '-354754800', '-337820400', '-323305200',
'-306975600', '-291855600', '-276735600', '-257986800', '-245286000',
'-226537200', '-213231600', '-195087600', '-182386800', '-163638000',
'-150937200', '-132188400', '-119487600', '-100738800', '-88038000',
'-68684400', '-59007600', '-37238400', '57715200', '69814800',
'89168400', '101264400', '120618000', '132714000', '152067600',
'164163600', '183517200', '196218000', '214966800', '227667600',
'246416400', '259117200', '278470800', '290566800', '309920400',
'322016400', '341370000', '354675600', '372819600', '386125200',
'404269200', '417574800', '435718800', '449024400', '467773200',
'481078800', '499222800', '512528400', '530672400', '543978000',
'562122000', '575427600', '593571600', '606877200', '625626000',
'638326800', '657075600', '670381200', '688525200', '701830800',
'719974800', '733280400', '751424400', '764730000', '782874000',
'796179600', '814928400', '828234000', '846378000', '859683600',
'877827600', '891133200', '909277200', '922582800', '940726800',
'954032400', '972781200', '985482000', '1004230800', '1017536400',
'1035680400', '1048986000', '1067130000', '1080435600', '1098579600',
'1111885200', '1130029200', '1143334800', '1162083600', '1174784400',
'1193533200', '1206838800', '1224982800', '1238288400', '1256432400',
'1269738000', '1287882000', '1301187600', '1319331600', '1332637200',
'1351386000', '1364691600', '1382835600', '1396141200', '1414285200',
'1427590800', '1445734800', '1459040400', '1477184400', '1490490000',
'1509238800', '1521939600', '1540688400', '1553994000', '1572138000',
'1585443600', '1603587600', '1616893200', '1635037200', '1648342800',
'1666486800', '1679792400', '1698541200', '1711846800', '1729990800',
'1743296400', '1761440400', '1774746000', '1792890000', '1806195600',
'1824339600', '1837645200', '1856394000', '1869094800', '1887843600',
'1901149200', '1919293200', '1932598800', '1950742800', '1964048400',
'1982192400', '1995498000', '2013642000', '2026947600', '2045696400',
'2058397200', '2077146000', '2090451600', '2108595600', '2121901200',
'2140045200',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x02\x00\x02\x00\x02\x00\x02\x00\x02\x00\x01\x00\x01\x00\x02\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x03\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(3600, 1, 0), (0, 0, 4), (7200, 1, 8), (3600, 0, 0)], 'BST\x00GMT\x00DST\x00'),
'GMT': ('GMT', 0, 1,
[ ],
'',
[(0, 0, 0)], 'GMT\x00'),
'GMT+0': ('GMT+0', 0, 1,
[ ],
'',
[(0, 0, 0)], 'GMT+0000\x00'),
'GMT+0130': ('GMT+0130', 0, 1,
[ ],
'',
[(5400, 0, 0)], 'GMT+0130\x00'),
'GMT+0230': ('GMT+0230', 0, 1,
[ ],
'',
[(9000, 0, 0)], 'GMT+0230\x00'),
'GMT+0330': ('GMT+0330', 0, 1,
[ ],
'',
[(12600, 0, 0)], 'GMT+0330\x00'),
'GMT+0430': ('GMT+0430', 0, 1,
[ ],
'',
[(16200, 0, 0)], 'GMT+0430\x00'),
'GMT+0530': ('GMT+0530', 0, 1,
[ ],
'',
[(19800, 0, 0)], 'GMT+0530\x00'),
'GMT+0630': ('GMT+0630', 0, 1,
[ ],
'',
[(23400, 0, 0)], 'GMT+0630\x00'),
'GMT+0730': ('GMT+0730', 0, 1,
[ ],
'',
[(27000, 0, 0)], 'GMT+0730\x00'),
'GMT+0830': ('GMT+0830', 0, 1,
[ ],
'',
[(30600, 0, 0)], 'GMT+0830\x00'),
'GMT+0930': ('GMT+0930', 0, 1,
[ ],
'',
[(34200, 0, 0)], 'GMT+0930\x00'),
'GMT+1': ('GMT+1', 0, 1,
[ ],
'',
[(3600, 0, 0)], 'GMT+0100\x00'),
'GMT+10': ('GMT+10', 0, 1,
[ ],
'',
[(36000, 0, 0)], 'GMT+1000\x00'),
'GMT+1030': ('GMT+1030', 0, 1,
[ ],
'',
[(37800, 0, 0)], 'GMT+1030\x00'),
'GMT+11': ('GMT+11', 0, 1,
[ ],
'',
[(39600, 0, 0)], 'GMT+1100\x00'),
'GMT+1130': ('GMT+1130', 0, 1,
[ ],
'',
[(41400, 0, 0)], 'GMT+1130\x00'),
'GMT+12': ('GMT+12', 0, 1,
[ ],
'',
[(43200, 0, 0)], 'GMT+1200\x00'),
'GMT+1230': ('GMT+1230', 0, 1,
[ ],
'',
[(45000, 0, 0)], 'GMT+1230\x00'),
'GMT+13': ('GMT+13', 0, 1,
[ ],
'',
[(46800, 0, 0)], 'GMT+1300\x00'),
'GMT+2': ('GMT+2', 0, 1,
[ ],
'',
[(7200, 0, 0)], 'GMT+0200\x00'),
'GMT+3': ('GMT+3', 0, 1,
[ ],
'',
[(10800, 0, 0)], 'GMT+0300\x00'),
'GMT+4': ('GMT+4', 0, 1,
[ ],
'',
[(14400, 0, 0)], 'GMT+0400\x00'),
'GMT+5': ('GMT+5', 0, 1,
[ ],
'',
[(18000, 0, 0)], 'GMT+0500\x00'),
'GMT+6': ('GMT+6', 0, 1,
[ ],
'',
[(21600, 0, 0)], 'GMT+0600\x00'),
'GMT+7': ('GMT+7', 0, 1,
[ ],
'',
[(25200, 0, 0)], 'GMT+0700\x00'),
'GMT+8': ('GMT+8', 0, 1,
[ ],
'',
[(28800, 0, 0)], 'GMT+0800\x00'),
'GMT+9': ('GMT+9', 0, 1,
[ ],
'',
[(32400, 0, 0)], 'GMT+0900\x00'),
'GMT-0130': ('GMT-0130', 0, 1,
[ ],
'',
[(-5400, 0, 0)], 'GMT-0130\x00'),
'GMT-0230': ('GMT-0230', 0, 1,
[ ],
'',
[(-9000, 0, 0)], 'GMT-0230\x00'),
'GMT-0330': ('GMT-0330', 0, 1,
[ ],
'',
[(-12600, 0, 0)], 'GMT-0330\x00'),
'GMT-0430': ('GMT-0430', 0, 1,
[ ],
'',
[(-16200, 0, 0)], 'GMT-0430\x00'),
'GMT-0530': ('GMT-0530', 0, 1,
[ ],
'',
[(-19800, 0, 0)], 'GMT-0530\x00'),
'GMT-0630': ('GMT-0630', 0, 1,
[ ],
'',
[(-23400, 0, 0)], 'GMT-0630\x00'),
'GMT-0730': ('GMT-0730', 0, 1,
[ ],
'',
[(-27000, 0, 0)], 'GMT-0730\x00'),
'GMT-0830': ('GMT-0830', 0, 1,
[ ],
'',
[(-30600, 0, 0)], 'GMT-0830\x00'),
'GMT-0930': ('GMT-0930', 0, 1,
[ ],
'',
[(-34200, 0, 0)], 'GMT-0930\x00'),
'GMT-1': ('GMT-1', 0, 1,
[ ],
'',
[(-3600, 0, 0)], 'GMT-0100\x00'),
'GMT-10': ('GMT-10', 0, 1,
[ ],
'',
[(-36000, 0, 0)], 'GMT-1000\x00'),
'GMT-1030': ('GMT-1030', 0, 1,
[ ],
'',
[(-37800, 0, 0)], 'GMT-1030\x00'),
'GMT-11': ('GMT-11', 0, 1,
[ ],
'',
[(-39600, 0, 0)], 'GMT-1100\x00'),
'GMT-1130': ('GMT-1130', 0, 1,
[ ],
'',
[(-41400, 0, 0)], 'GMT-1130\x00'),
'GMT-12': ('GMT-12', 0, 1,
[ ],
'',
[(-43200, 0, 0)], 'GMT-1200\x00'),
'GMT-1230': ('GMT-1230', 0, 1,
[ ],
'',
[(-45000, 0, 0)], 'GMT-1230\x00'),
'GMT-2': ('GMT-2', 0, 1,
[ ],
'',
[(-7200, 0, 0)], 'GMT-0200\x00'),
'GMT-3': ('GMT-3', 0, 1,
[ ],
'',
[(-10800, 0, 0)], 'GMT-0300\x00'),
'GMT-4': ('GMT-4', 0, 1,
[ ],
'',
[(-14400, 0, 0)], 'GMT-0400\x00'),
'GMT-5': ('GMT-5', 0, 1,
[ ],
'',
[(-18000, 0, 0)], 'GMT-0500\x00'),
'GMT-6': ('GMT-6', 0, 1,
[ ],
'',
[(-21600, 0, 0)], 'GMT-0600\x00'),
'GMT-7': ('GMT-7', 0, 1,
[ ],
'',
[(-25200, 0, 0)], 'GMT-0700\x00'),
'GMT-8': ('GMT-8', 0, 1,
[ ],
'',
[(-28800, 0, 0)], 'GMT-0800\x00'),
'GMT-9': ('GMT-9', 0, 1,
[ ],
'',
[(-32400, 0, 0)], 'GMT-0900\x00'),
'Greenwich': ('Greenwich', 0, 1,
[ ],
'',
[(0, 0, 0)], 'GMT\x00'),
'Hongkong': ('Hongkong', 0, 1,
[ ],
'',
[(28800, 0, 0)], 'HKT\x00'),
'Iceland': ('Iceland', 0, 1,
[ ],
'',
[(0, 0, 0)], 'WET\x00'),
'Iran': ('Iran', 100, 2,
[ '575418600', '590535000', '606868200', '621984600', '638317800',
'653434200', '670372200', '684883800', '701821800', '716938200',
'733271400', '748387800', '764721000', '779837400', '796170600',
'811287000', '828225000', '842736600', '859674600', '874791000',
'891124200', '906240600', '922573800', '937690200', '954023400',
'969139800', '985473000', '1000589400', '1017527400', '1032039000',
'1048977000', '1064093400', '1080426600', '1095543000', '1111876200',
'1126992600', '1143325800', '1158442200', '1174775400', '1189891800',
'1206829800', '1221946200', '1238279400', '1253395800', '1269729000',
'1284845400', '1301178600', '1316295000', '1332628200', '1347744600',
'1364682600', '1379194200', '1396132200', '1411248600', '1427581800',
'1442698200', '1459031400', '1474147800', '1490481000', '1505597400',
'1521930600', '1537047000', '1553985000', '1568496600', '1585434600',
'1600551000', '1616884200', '1632000600', '1648333800', '1663450200',
'1679783400', '1694899800', '1711837800', '1726349400', '1743287400',
'1758403800', '1774737000', '1789853400', '1806186600', '1821303000',
'1837636200', '1852752600', '1869085800', '1884202200', '1901140200',
'1915651800', '1932589800', '1947706200', '1964039400', '1979155800',
'1995489000', '2010605400', '2026938600', '2042055000', '2058388200',
'2073504600', '2090442600', '2105559000', '2121892200', '2137008600',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(16200, 1, 0), (12600, 0, 4)], 'IDT\x00IST\x00'),
'Israel': ('Israel', 42, 2,
[ '609890400', '622587600', '640735200', '653432400', '670975200',
'683672400', '704239200', '716936400', '735084000', '747781200',
'765324000', '778021200', '798588000', '811285200', '829432800',
'842130000', '862696800', '875394000', '892936800', '905634000',
'923781600', '936478800', '957045600', '969742800', '987285600',
'999982800', '1018130400', '1030827600', '1051394400', '1064091600',
'1082239200', '1094936400', '1114898400', '1127595600', '1145743200',
'1158440400', '1176588000', '1189285200', '1209247200', '1221944400',
'1240092000', '1252789200',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(10800, 1, 0), (7200, 0, 4)], 'IDT\x00IST\x00'),
'Jamaica': ('Jamaica', 148, 3,
[ '-1633280400', '-1615140000', '-1601830800', '-1583690400', '-880218000',
'-765396000', '-84387600', '-68666400', '-52938000', '-37216800',
'-21488400', '-5767200', '9961200', '25682400', '41410800',
'57736800', '73465200', '89186400', '104914800', '120636000',
'126687600', '152085600', '162370800', '183535200', '199263600',
'215589600', '230713200', '247039200', '262767600', '278488800',
'294217200', '309938400', '325666800', '341388000', '357116400',
'372837600', '388566000', '404892000', '420015600', '436341600',
'452070000', '467791200', '483519600', '499240800', '514969200',
'530690400', '544604400', '562140000', '576054000', '594194400',
'607503600', '625644000', '638953200', '657093600', '671007600',
'688543200', '702457200', '719992800', '733906800', '752047200',
'765356400', '783496800', '796806000', '814946400', '828860400',
'846396000', '860310000', '877845600', '891759600', '909295200',
'923209200', '941349600', '954658800', '972799200', '986108400',
'1004248800', '1018162800', '1035698400', '1049612400', '1067148000',
'1081062000', '1099202400', '1112511600', '1130652000', '1143961200',
'1162101600', '1175410800', '1193551200', '1207465200', '1225000800',
'1238914800', '1256450400', '1270364400', '1288504800', '1301814000',
'1319954400', '1333263600', '1351404000', '1365318000', '1382853600',
'1396767600', '1414303200', '1428217200', '1445752800', '1459666800',
'1477807200', '1491116400', '1509256800', '1522566000', '1540706400',
'1554620400', '1572156000', '1586070000', '1603605600', '1617519600',
'1635660000', '1648969200', '1667109600', '1680418800', '1698559200',
'1712473200', '1730008800', '1743922800', '1761458400', '1775372400',
'1792908000', '1806822000', '1824962400', '1838271600', '1856412000',
'1869721200', '1887861600', '1901775600', '1919311200', '1933225200',
'1950760800', '1964674800', '1982815200', '1996124400', '2014264800',
'2027574000', '2045714400', '2059023600', '2077164000', '2091078000',
'2108613600', '2122527600', '2140063200',
],
'\x00\x01\x00\x01\x02\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-14400, 1, 0), (-18000, 0, 4), (-14400, 1, 8)], 'EDT\x00EST\x00EWT\x00'),
'Japan': ('Japan', 0, 1,
[ ],
'',
[(32400, 0, 0)], 'JST\x00'),
'Mexico/BajaNorte': ('Mexico/BajaNorte', 102, 2,
[ '544615200', '562150800', '576064800', '594205200', '607514400',
'625654800', '638964000', '657104400', '671018400', '688554000',
'702468000', '720003600', '733917600', '752058000', '765367200',
'783507600', '796816800', '814957200', '828871200', '846406800',
'860320800', '877856400', '891770400', '909306000', '923220000',
'941360400', '954669600', '972810000', '986119200', '1004259600',
'1018173600', '1035709200', '1049623200', '1067158800', '1081072800',
'1099213200', '1112522400', '1130662800', '1143972000', '1162112400',
'1175421600', '1193562000', '1207476000', '1225011600', '1238925600',
'1256461200', '1270375200', '1288515600', '1301824800', '1319965200',
'1333274400', '1351414800', '1365328800', '1382864400', '1396778400',
'1414314000', '1428228000', '1445763600', '1459677600', '1477818000',
'1491127200', '1509267600', '1522576800', '1540717200', '1554631200',
'1572166800', '1586080800', '1603616400', '1617530400', '1635670800',
'1648980000', '1667120400', '1680429600', '1698570000', '1712484000',
'1730019600', '1743933600', '1761469200', '1775383200', '1792918800',
'1806832800', '1824973200', '1838282400', '1856422800', '1869732000',
'1887872400', '1901786400', '1919322000', '1933236000', '1950771600',
'1964685600', '1982826000', '1996135200', '2014275600', '2027584800',
'2045725200', '2059034400', '2077174800', '2091088800', '2108624400',
'2122538400', '2140074000',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-25200, 1, 0), (-28800, 0, 4)], 'PDT\x00PST\x00'),
'Mexico/BajaSur': ('Mexico/BajaSur', 0, 1,
[ ],
'',
[(-25200, 0, 0)], 'MST\x00'),
'Mexico/General': ('Mexico/General', 0, 1,
[ ],
'',
[(-21600, 0, 0)], 'CST\x00'),
'Poland': ('Poland', 104, 2,
[ '512524800', '528249600', '543974400', '559699200', '575424000',
'591148800', '606873600', '622598400', '638323200', '654652800',
'670377600', '686102400', '701827200', '717552000', '733276800',
'749001600', '764726400', '780451200', '796176000', '811900800',
'828230400', '843955200', '859680000', '875404800', '891129600',
'906854400', '922579200', '938304000', '954028800', '969753600',
'985478400', '1001808000', '1017532800', '1033257600', '1048982400',
'1064707200', '1080432000', '1096156800', '1111881600', '1127606400',
'1143331200', '1159056000', '1174780800', '1191110400', '1206835200',
'1222560000', '1238284800', '1254009600', '1269734400', '1285459200',
'1301184000', '1316908800', '1332633600', '1348963200', '1364688000',
'1380412800', '1396137600', '1411862400', '1427587200', '1443312000',
'1459036800', '1474761600', '1490486400', '1506211200', '1521936000',
'1538265600', '1553990400', '1569715200', '1585440000', '1601164800',
'1616889600', '1632614400', '1648339200', '1664064000', '1679788800',
'1695513600', '1711843200', '1727568000', '1743292800', '1759017600',
'1774742400', '1790467200', '1806192000', '1821916800', '1837641600',
'1853366400', '1869091200', '1885420800', '1901145600', '1916870400',
'1932595200', '1948320000', '1964044800', '1979769600', '1995494400',
'2011219200', '2026944000', '2042668800', '2058393600', '2074723200',
'2090448000', '2106172800', '2121897600', '2137622400',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(7200, 1, 0), (3600, 0, 8)], 'MET DST\x00MET\x00'),
'Singapore': ('Singapore', 0, 1,
[ ],
'',
[(28800, 0, 0)], 'SST\x00'),
'Turkey': ('Turkey', 104, 2,
[ '512517600', '528238800', '543967200', '559688400', '575416800',
'591138000', '606866400', '622587600', '638316000', '654642000',
'670370400', '686091600', '701820000', '717541200', '733269600',
'748990800', '764719200', '780440400', '796168800', '811890000',
'828223200', '843944400', '859672800', '875394000', '891122400',
'906843600', '922572000', '938293200', '954021600', '969742800',
'985471200', '1001797200', '1017525600', '1033246800', '1048975200',
'1064696400', '1080424800', '1096146000', '1111874400', '1127595600',
'1143324000', '1159045200', '1174773600', '1191099600', '1206828000',
'1222549200', '1238277600', '1253998800', '1269727200', '1285448400',
'1301176800', '1316898000', '1332626400', '1348952400', '1364680800',
'1380402000', '1396130400', '1411851600', '1427580000', '1443301200',
'1459029600', '1474750800', '1490479200', '1506200400', '1521928800',
'1538254800', '1553983200', '1569704400', '1585432800', '1601154000',
'1616882400', '1632603600', '1648332000', '1664053200', '1679781600',
'1695502800', '1711836000', '1727557200', '1743285600', '1759006800',
'1774735200', '1790456400', '1806184800', '1821906000', '1837634400',
'1853355600', '1869084000', '1885410000', '1901138400', '1916859600',
'1932588000', '1948309200', '1964037600', '1979758800', '1995487200',
'2011208400', '2026936800', '2042658000', '2058386400', '2074712400',
'2090440800', '2106162000', '2121890400', '2137611600',
],
'\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(14400, 1, 0), (10800, 0, 8)], 'EET DST\x00EET\x00'),
'US/Alaska': ('US/Alaska', 148, 3,
[ '-1633266000', '-1615125600', '-1601816400', '-1583676000', '-880203600',
'-765381600', '-84373200', '-68652000', '-52923600', '-37202400',
'-21474000', '-5752800', '9975600', '25696800', '41425200',
'57751200', '73479600', '89200800', '104929200', '120650400',
'126702000', '152100000', '162385200', '183549600', '199278000',
'215604000', '230727600', '247053600', '262782000', '278503200',
'294231600', '309952800', '325681200', '341402400', '357130800',
'372852000', '388580400', '404906400', '420030000', '436356000',
'452084400', '467805600', '483534000', '499255200', '514983600',
'530704800', '544618800', '562154400', '576068400', '594208800',
'607518000', '625658400', '638967600', '657108000', '671022000',
'688557600', '702471600', '720007200', '733921200', '752061600',
'765370800', '783511200', '796820400', '814960800', '828874800',
'846410400', '860324400', '877860000', '891774000', '909309600',
'923223600', '941364000', '954673200', '972813600', '986122800',
'1004263200', '1018177200', '1035712800', '1049626800', '1067162400',
'1081076400', '1099216800', '1112526000', '1130666400', '1143975600',
'1162116000', '1175425200', '1193565600', '1207479600', '1225015200',
'1238929200', '1256464800', '1270378800', '1288519200', '1301828400',
'1319968800', '1333278000', '1351418400', '1365332400', '1382868000',
'1396782000', '1414317600', '1428231600', '1445767200', '1459681200',
'1477821600', '1491130800', '1509271200', '1522580400', '1540720800',
'1554634800', '1572170400', '1586084400', '1603620000', '1617534000',
'1635674400', '1648983600', '1667124000', '1680433200', '1698573600',
'1712487600', '1730023200', '1743937200', '1761472800', '1775386800',
'1792922400', '1806836400', '1824976800', '1838286000', '1856426400',
'1869735600', '1887876000', '1901790000', '1919325600', '1933239600',
'1950775200', '1964689200', '1982829600', '1996138800', '2014279200',
'2027588400', '2045728800', '2059038000', '2077178400', '2091092400',
'2108628000', '2122542000', '2140077600',
],
'\x00\x01\x00\x01\x02\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-28800, 1, 0), (-32400, 0, 5), (-28800, 1, 10)], 'AKDT\x00AKST\x00AKWT\x00'),
'US/Aleutian': ('US/Aleutian', 149, 5,
[ '-1633262400', '-1615122000', '-1601812800', '-1583672400', '-880200000',
'-765378000', '-84369600', '-68648400', '-52920000', '-37198800',
'-21470400', '-5749200', '9979200', '25700400', '41428800',
'57754800', '73483200', '89204400', '104932800', '120654000',
'126705600', '152103600', '162388800', '183553200', '199281600',
'215607600', '230731200', '247057200', '262785600', '278506800',
'294235200', '309956400', '325684800', '341406000', '357134400',
'372855600', '388584000', '404910000', '420033600', '436359600',
'439034400', '452088000', '467809200', '483537600', '499258800',
'514987200', '530708400', '544622400', '562158000', '576072000',
'594212400', '607521600', '625662000', '638971200', '657111600',
'671025600', '688561200', '702475200', '720010800', '733924800',
'752065200', '765374400', '783514800', '796824000', '814964400',
'828878400', '846414000', '860328000', '877863600', '891777600',
'909313200', '923227200', '941367600', '954676800', '972817200',
'986126400', '1004266800', '1018180800', '1035716400', '1049630400',
'1067166000', '1081080000', '1099220400', '1112529600', '1130670000',
'1143979200', '1162119600', '1175428800', '1193569200', '1207483200',
'1225018800', '1238932800', '1256468400', '1270382400', '1288522800',
'1301832000', '1319972400', '1333281600', '1351422000', '1365336000',
'1382871600', '1396785600', '1414321200', '1428235200', '1445770800',
'1459684800', '1477825200', '1491134400', '1509274800', '1522584000',
'1540724400', '1554638400', '1572174000', '1586088000', '1603623600',
'1617537600', '1635678000', '1648987200', '1667127600', '1680436800',
'1698577200', '1712491200', '1730026800', '1743940800', '1761476400',
'1775390400', '1792926000', '1806840000', '1824980400', '1838289600',
'1856430000', '1869739200', '1887879600', '1901793600', '1919329200',
'1933243200', '1950778800', '1964692800', '1982833200', '1996142400',
'2014282800', '2027592000', '2045732400', '2059041600', '2077182000',
'2091096000', '2108631600', '2122545600', '2140081200',
],
'\x00\x01\x00\x01\x02\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03\x04\x03',
[(-32400, 1, 0), (-36000, 0, 5), (-32400, 1, 10), (-36000, 0, 15), (-32400, 1, 20)], 'AHDT\x00AHST\x00AHWT\x00HAST\x00HADT\x00'),
'US/Arizona': ('US/Arizona', 6, 3,
[ '-1633273200', '-1615132800', '-1601823600', '-1583683200', '-880210800',
'-765388800',
],
'\x00\x01\x00\x01\x02\x01',
[(-21600, 1, 0), (-25200, 0, 4), (-21600, 1, 8)], 'MDT\x00MST\x00MWT\x00'),
'US/Central': ('US/Central', 148, 3,
[ '-1633276800', '-1615136400', '-1601827200', '-1583686800', '-880214400',
'-765392400', '-84384000', '-68662800', '-52934400', '-37213200',
'-21484800', '-5763600', '9964800', '25686000', '41414400',
'57740400', '73468800', '89190000', '104918400', '120639600',
'126691200', '152089200', '162374400', '183538800', '199267200',
'215593200', '230716800', '247042800', '262771200', '278492400',
'294220800', '309942000', '325670400', '341391600', '357120000',
'372841200', '388569600', '404895600', '420019200', '436345200',
'452073600', '467794800', '483523200', '499244400', '514972800',
'530694000', '544608000', '562143600', '576057600', '594198000',
'607507200', '625647600', '638956800', '657097200', '671011200',
'688546800', '702460800', '719996400', '733910400', '752050800',
'765360000', '783500400', '796809600', '814950000', '828864000',
'846399600', '860313600', '877849200', '891763200', '909298800',
'923212800', '941353200', '954662400', '972802800', '986112000',
'1004252400', '1018166400', '1035702000', '1049616000', '1067151600',
'1081065600', '1099206000', '1112515200', '1130655600', '1143964800',
'1162105200', '1175414400', '1193554800', '1207468800', '1225004400',
'1238918400', '1256454000', '1270368000', '1288508400', '1301817600',
'1319958000', '1333267200', '1351407600', '1365321600', '1382857200',
'1396771200', '1414306800', '1428220800', '1445756400', '1459670400',
'1477810800', '1491120000', '1509260400', '1522569600', '1540710000',
'1554624000', '1572159600', '1586073600', '1603609200', '1617523200',
'1635663600', '1648972800', '1667113200', '1680422400', '1698562800',
'1712476800', '1730012400', '1743926400', '1761462000', '1775376000',
'1792911600', '1806825600', '1824966000', '1838275200', '1856415600',
'1869724800', '1887865200', '1901779200', '1919314800', '1933228800',
'1950764400', '1964678400', '1982818800', '1996128000', '2014268400',
'2027577600', '2045718000', '2059027200', '2077167600', '2091081600',
'2108617200', '2122531200', '2140066800',
],
'\x00\x01\x00\x01\x02\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-18000, 1, 0), (-21600, 0, 4), (-18000, 1, 8)], 'CDT\x00CST\x00CWT\x00'),
'US/East-Indiana': ('US/East-Indiana', 6, 3,
[ '-1633280400', '-1615140000', '-1601830800', '-1583690400', '-880218000',
'-765396000',
],
'\x00\x01\x00\x01\x02\x01',
[(-14400, 1, 0), (-18000, 0, 4), (-14400, 1, 8)], 'EDT\x00EST\x00EWT\x00'),
'US/Eastern': ('US/Eastern', 148, 3,
[ '-1633280400', '-1615140000', '-1601830800', '-1583690400', '-880218000',
'-765396000', '-84387600', '-68666400', '-52938000', '-37216800',
'-21488400', '-5767200', '9961200', '25682400', '41410800',
'57736800', '73465200', '89186400', '104914800', '120636000',
'126687600', '152085600', '162370800', '183535200', '199263600',
'215589600', '230713200', '247039200', '262767600', '278488800',
'294217200', '309938400', '325666800', '341388000', '357116400',
'372837600', '388566000', '404892000', '420015600', '436341600',
'452070000', '467791200', '483519600', '499240800', '514969200',
'530690400', '544604400', '562140000', '576054000', '594194400',
'607503600', '625644000', '638953200', '657093600', '671007600',
'688543200', '702457200', '719992800', '733906800', '752047200',
'765356400', '783496800', '796806000', '814946400', '828860400',
'846396000', '860310000', '877845600', '891759600', '909295200',
'923209200', '941349600', '954658800', '972799200', '986108400',
'1004248800', '1018162800', '1035698400', '1049612400', '1067148000',
'1081062000', '1099202400', '1112511600', '1130652000', '1143961200',
'1162101600', '1175410800', '1193551200', '1207465200', '1225000800',
'1238914800', '1256450400', '1270364400', '1288504800', '1301814000',
'1319954400', '1333263600', '1351404000', '1365318000', '1382853600',
'1396767600', '1414303200', '1428217200', '1445752800', '1459666800',
'1477807200', '1491116400', '1509256800', '1522566000', '1540706400',
'1554620400', '1572156000', '1586070000', '1603605600', '1617519600',
'1635660000', '1648969200', '1667109600', '1680418800', '1698559200',
'1712473200', '1730008800', '1743922800', '1761458400', '1775372400',
'1792908000', '1806822000', '1824962400', '1838271600', '1856412000',
'1869721200', '1887861600', '1901775600', '1919311200', '1933225200',
'1950760800', '1964674800', '1982815200', '1996124400', '2014264800',
'2027574000', '2045714400', '2059023600', '2077164000', '2091078000',
'2108613600', '2122527600', '2140063200',
],
'\x00\x01\x00\x01\x02\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-14400, 1, 0), (-18000, 0, 4), (-14400, 1, 8)], 'EDT\x00EST\x00EWT\x00'),
'US/Hawaii': ('US/Hawaii', 9, 4,
[ '-1633260600', '-1615120200', '-1601811000', '-1583670600', '-1157283000',
'-1157200200', '-880198200', '-765376200', '-712150200',
],
'\x00\x01\x00\x01\x00\x01\x02\x01\x03',
[(-34200, 1, 0), (-37800, 0, 4), (-34200, 1, 8), (-36000, 0, 4)], 'HDT\x00HST\x00HWT\x00'),
'US/Indiana-Starke': ('US/Indiana-Starke', 56, 4,
[ '-1633276800', '-1615136400', '-1601827200', '-1583686800', '-880214400',
'-765392400', '-84384000', '-68662800', '-52934400', '-37213200',
'-21484800', '-5763600', '9964800', '25686000', '41414400',
'57740400', '73468800', '89190000', '104918400', '120639600',
'126691200', '152089200', '162374400', '183538800', '199267200',
'215593200', '230716800', '247042800', '262771200', '278492400',
'294220800', '309942000', '325670400', '341391600', '357120000',
'372841200', '388569600', '404895600', '420019200', '436345200',
'452073600', '467794800', '483523200', '499244400', '514972800',
'530694000', '544608000', '562143600', '576057600', '594198000',
'607507200', '625647600', '638956800', '657097200', '671011200',
'688546800',
],
'\x00\x01\x00\x01\x02\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x03',
[(-18000, 1, 0), (-21600, 0, 4), (-18000, 1, 8), (-18000, 0, 12)], 'CDT\x00CST\x00CWT\x00EST\x00'),
'US/Michigan': ('US/Michigan', 138, 3,
[ '-1633280400', '-1615140000', '-1601830800', '-1583690400', '-880218000',
'-765396000', '-84387600', '-68666400', '104914800', '120636000',
'126687600', '152085600', '162370800', '183535200', '199263600',
'215589600', '230713200', '247039200', '262767600', '278488800',
'294217200', '309938400', '325666800', '341388000', '357116400',
'372837600', '388566000', '404892000', '420015600', '436341600',
'452070000', '467791200', '483519600', '499240800', '514969200',
'530690400', '544604400', '562140000', '576054000', '594194400',
'607503600', '625644000', '638953200', '657093600', '671007600',
'688543200', '702457200', '719992800', '733906800', '752047200',
'765356400', '783496800', '796806000', '814946400', '828860400',
'846396000', '860310000', '877845600', '891759600', '909295200',
'923209200', '941349600', '954658800', '972799200', '986108400',
'1004248800', '1018162800', '1035698400', '1049612400', '1067148000',
'1081062000', '1099202400', '1112511600', '1130652000', '1143961200',
'1162101600', '1175410800', '1193551200', '1207465200', '1225000800',
'1238914800', '1256450400', '1270364400', '1288504800', '1301814000',
'1319954400', '1333263600', '1351404000', '1365318000', '1382853600',
'1396767600', '1414303200', '1428217200', '1445752800', '1459666800',
'1477807200', '1491116400', '1509256800', '1522566000', '1540706400',
'1554620400', '1572156000', '1586070000', '1603605600', '1617519600',
'1635660000', '1648969200', '1667109600', '1680418800', '1698559200',
'1712473200', '1730008800', '1743922800', '1761458400', '1775372400',
'1792908000', '1806822000', '1824962400', '1838271600', '1856412000',
'1869721200', '1887861600', '1901775600', '1919311200', '1933225200',
'1950760800', '1964674800', '1982815200', '1996124400', '2014264800',
'2027574000', '2045714400', '2059023600', '2077164000', '2091078000',
'2108613600', '2122527600', '2140063200',
],
'\x00\x01\x00\x01\x02\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-14400, 1, 0), (-18000, 0, 4), (-14400, 1, 8)], 'EDT\x00EST\x00EWT\x00'),
'US/Mountain': ('US/Mountain', 148, 3,
[ '-1633273200', '-1615132800', '-1601823600', '-1583683200', '-880210800',
'-765388800', '-84380400', '-68659200', '-52930800', '-37209600',
'-21481200', '-5760000', '9968400', '25689600', '41418000',
'57744000', '73472400', '89193600', '104922000', '120643200',
'126694800', '152092800', '162378000', '183542400', '199270800',
'215596800', '230720400', '247046400', '262774800', '278496000',
'294224400', '309945600', '325674000', '341395200', '357123600',
'372844800', '388573200', '404899200', '420022800', '436348800',
'452077200', '467798400', '483526800', '499248000', '514976400',
'530697600', '544611600', '562147200', '576061200', '594201600',
'607510800', '625651200', '638960400', '657100800', '671014800',
'688550400', '702464400', '720000000', '733914000', '752054400',
'765363600', '783504000', '796813200', '814953600', '828867600',
'846403200', '860317200', '877852800', '891766800', '909302400',
'923216400', '941356800', '954666000', '972806400', '986115600',
'1004256000', '1018170000', '1035705600', '1049619600', '1067155200',
'1081069200', '1099209600', '1112518800', '1130659200', '1143968400',
'1162108800', '1175418000', '1193558400', '1207472400', '1225008000',
'1238922000', '1256457600', '1270371600', '1288512000', '1301821200',
'1319961600', '1333270800', '1351411200', '1365325200', '1382860800',
'1396774800', '1414310400', '1428224400', '1445760000', '1459674000',
'1477814400', '1491123600', '1509264000', '1522573200', '1540713600',
'1554627600', '1572163200', '1586077200', '1603612800', '1617526800',
'1635667200', '1648976400', '1667116800', '1680426000', '1698566400',
'1712480400', '1730016000', '1743930000', '1761465600', '1775379600',
'1792915200', '1806829200', '1824969600', '1838278800', '1856419200',
'1869728400', '1887868800', '1901782800', '1919318400', '1933232400',
'1950768000', '1964682000', '1982822400', '1996131600', '2014272000',
'2027581200', '2045721600', '2059030800', '2077171200', '2091085200',
'2108620800', '2122534800', '2140070400',
],
'\x00\x01\x00\x01\x02\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-21600, 1, 0), (-25200, 0, 4), (-21600, 1, 8)], 'MDT\x00MST\x00MWT\x00'),
'US/Pacific': ('US/Pacific', 148, 3,
[ '-1633269600', '-1615129200', '-1601820000', '-1583679600', '-880207200',
'-765385200', '-84376800', '-68655600', '-52927200', '-37206000',
'-21477600', '-5756400', '9972000', '25693200', '41421600',
'57747600', '73476000', '89197200', '104925600', '120646800',
'126698400', '152096400', '162381600', '183546000', '199274400',
'215600400', '230724000', '247050000', '262778400', '278499600',
'294228000', '309949200', '325677600', '341398800', '357127200',
'372848400', '388576800', '404902800', '420026400', '436352400',
'452080800', '467802000', '483530400', '499251600', '514980000',
'530701200', '544615200', '562150800', '576064800', '594205200',
'607514400', '625654800', '638964000', '657104400', '671018400',
'688554000', '702468000', '720003600', '733917600', '752058000',
'765367200', '783507600', '796816800', '814957200', '828871200',
'846406800', '860320800', '877856400', '891770400', '909306000',
'923220000', '941360400', '954669600', '972810000', '986119200',
'1004259600', '1018173600', '1035709200', '1049623200', '1067158800',
'1081072800', '1099213200', '1112522400', '1130662800', '1143972000',
'1162112400', '1175421600', '1193562000', '1207476000', '1225011600',
'1238925600', '1256461200', '1270375200', '1288515600', '1301824800',
'1319965200', '1333274400', '1351414800', '1365328800', '1382864400',
'1396778400', '1414314000', '1428228000', '1445763600', '1459677600',
'1477818000', '1491127200', '1509267600', '1522576800', '1540717200',
'1554631200', '1572166800', '1586080800', '1603616400', '1617530400',
'1635670800', '1648980000', '1667120400', '1680429600', '1698570000',
'1712484000', '1730019600', '1743933600', '1761469200', '1775383200',
'1792918800', '1806832800', '1824973200', '1838282400', '1856422800',
'1869732000', '1887872400', '1901786400', '1919322000', '1933236000',
'1950771600', '1964685600', '1982826000', '1996135200', '2014275600',
'2027584800', '2045725200', '2059034400', '2077174800', '2091088800',
'2108624400', '2122538400', '2140074000',
],
'\x00\x01\x00\x01\x02\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01\x00\x01',
[(-25200, 1, 0), (-28800, 0, 4), (-25200, 1, 8)], 'PDT\x00PST\x00PWT\x00'),
'US/Samoa': ('US/Samoa', 2, 3,
[ '-86878800', '439038000',
],
'\x01\x02',
[(-39600, 0, 0), (-39600, 0, 4), (-39600, 0, 8)], 'NST\x00BST\x00SST\x00'),
'Universal': ('Universal', 0, 1,
[ ],
'',
[(0, 0, 0)], 'GMT\x00'),
}

def dumpTimezoneInfo(_data):

    print("historical_zone_info = {")

    items = _data.items()
    items.sort()
    for key, value in items:
        v1, v2, v3, ilist, bitmap, two_by_three, two_nullterm = value
        print("'%s': ('%s', %s, %s," % (key, v1, v2, v3))
        print("[", end='')
        while ilist:
            next_5, ilist = ilist[:5], ilist[5:]
            line = ", ".join(["'%s'" % x for x in next_5])
            print("%s," % line)
        print("], ")
        print("%s," % repr(bitmap))
        print("%s, %s)," % (repr(two_by_three), repr(two_nullterm)))

    print("}")

if __name__ == '__main__':
    dumpTimezoneInfo(historical_zone_info)
