/*
 * Decompiled with CFR 0.152.
 */
package py4j.reflection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import py4j.CallbackClient;
import py4j.Gateway;
import py4j.Protocol;

public class PythonProxyHandler
implements InvocationHandler {
    private final String id;
    private final CallbackClient cbClient;
    private final Gateway gateway;
    private final Logger logger = Logger.getLogger(PythonProxyHandler.class.getName());
    private final String finalizeCommand;
    public static final String CALL_PROXY_COMMAND_NAME = "c\n";
    public static final String GARBAGE_COLLECT_PROXY_COMMAND_NAME = "g\n";

    public PythonProxyHandler(String id, CallbackClient cbClient, Gateway gateway) {
        this.id = id;
        this.cbClient = cbClient;
        this.gateway = gateway;
        this.finalizeCommand = GARBAGE_COLLECT_PROXY_COMMAND_NAME + id + "\ne\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.logger.fine("Finalizing python proxy id " + this.id);
            this.cbClient.sendCommand(this.finalizeCommand);
        }
        catch (Exception e) {
            this.logger.warning("Python Proxy ID could not send a finalize message: " + this.id);
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.logger.fine("Method " + method.getName() + " called on Python object " + this.id);
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(CALL_PROXY_COMMAND_NAME);
        sBuilder.append(this.id);
        sBuilder.append("\n");
        sBuilder.append(method.getName());
        sBuilder.append("\n");
        if (args != null) {
            for (Object arg : args) {
                sBuilder.append(this.gateway.getReturnObject(arg).getCommandPart());
                sBuilder.append("\n");
            }
        }
        sBuilder.append("e\n");
        String returnCommand = this.cbClient.sendCommand(sBuilder.toString());
        return Protocol.getReturnValue(returnCommand, this.gateway);
    }
}

