/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.model.style;

import org.brunel.data.Data;
import org.brunel.model.style.StyleSelector;
import org.brunel.model.style.StyleTarget;

class MultiComponentSelector
extends StyleSelector {
    private final StyleSelector[] components;

    public MultiComponentSelector(StyleSelector ... components) {
        super(MultiComponentSelector.sumSpecificity(components));
        this.components = components;
    }

    private static int sumSpecificity(StyleSelector[] components) {
        int sum = 0;
        for (StyleSelector s : components) {
            sum += s.specificity;
        }
        return sum;
    }

    @Override
    public StyleSelector containedIn(StyleSelector[] top) {
        StyleSelector[] c = new StyleSelector[top.length + this.components.length];
        System.arraycopy(top, 0, c, 0, top.length);
        System.arraycopy(this.components, 0, c, top.length, this.components.length);
        return new MultiComponentSelector(c);
    }

    @Override
    public String debug() {
        String s = "";
        for (int i = 0; i < this.components.length; ++i) {
            if (i > 0) {
                s = s + " > ";
            }
            s = s + this.components[i].debug();
        }
        return s;
    }

    @Override
    public boolean match(StyleTarget target) {
        if (!this.components[this.components.length - 1].match(target)) {
            return false;
        }
        int selectorToMatch = this.components.length - 2;
        target = target.parent;
        for (int i = this.components.length - 2; i >= 0; --i) {
            while (target != null && !this.components[i].match(target)) {
                target = target.parent;
            }
            if (target == null) {
                return false;
            }
            target = target.parent;
        }
        return true;
    }

    @Override
    public StyleSelector replaceClass(String target, String replace) {
        StyleSelector[] replaced = new StyleSelector[this.components.length];
        boolean changed = false;
        for (int i = 0; i < replaced.length; ++i) {
            replaced[i] = this.components[i].replaceClass(target, replace);
            if (replaced[i] == this.components[i]) continue;
            changed = true;
        }
        return changed ? new MultiComponentSelector(replaced) : this;
    }

    public String toString() {
        return Data.join((Object[])this.components, (String)" ");
    }
}

