/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.brunel.build.util.DatasetCache;
import org.brunel.data.Dataset;

public class SimpleCache
implements DatasetCache {
    private static final long MAX_ESTIMATED_MEMORY = 0x20000000L;
    private final Map<String, Dataset> map = Collections.synchronizedMap(new MapCache());
    private long estimatedMemoryUse = 0L;

    @Override
    public synchronized void store(String key, Dataset dataset) {
        Dataset previous = this.map.put(key, dataset);
        if (previous != null) {
            this.estimatedMemoryUse -= previous.expectedSize();
        }
        this.estimatedMemoryUse += dataset.expectedSize();
    }

    @Override
    public synchronized Dataset retrieve(String key) {
        return this.map.get(key);
    }

    private class MapCache
    extends LinkedHashMap<String, Dataset> {
        private MapCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Dataset> eldest) {
            SimpleCache simpleCache = SimpleCache.this;
            synchronized (simpleCache) {
                if (SimpleCache.this.estimatedMemoryUse > 0x20000000L) {
                    SimpleCache.this.estimatedMemoryUse -= eldest.getValue().expectedSize();
                    return true;
                }
                return false;
            }
        }
    }
}

