/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.brunel.data.Data;

public class ScriptWriter {
    private final int lineMaxLength;
    private static final Set<Character> NO_SPACE_BEFORE = new HashSet<Character>(Arrays.asList(Character.valueOf(':'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(']')));
    private static final String INDENT = "  ";
    private final PrintWriter out;
    private final StringWriter base;
    private int consecutiveNewLines = 0;
    private int indentLevel = 0;
    private boolean changed;
    public boolean readable = false;

    public ScriptWriter(boolean readableJavascript) {
        this.readable = readableJavascript;
        this.lineMaxLength = this.readable ? 100 : 400;
        this.base = new StringWriter();
        this.out = new PrintWriter(this.base);
        this.consecutiveNewLines = 1;
    }

    public ScriptWriter addChained(Object ... items) {
        if (this.readable) {
            return this.indentMore().onNewLine().add(".").add(items).indentLess();
        }
        return this.add(".").add(items);
    }

    public boolean changedSinceMark() {
        return this.changed;
    }

    public ScriptWriter continueOnNextLine(String ... before) {
        for (String s : before) {
            this.out.print(s);
        }
        this.ln();
        if (this.readable) {
            this.out.print(INDENT);
        }
        return this;
    }

    public ScriptWriter indentLess() {
        --this.indentLevel;
        return this;
    }

    public ScriptWriter add(Object ... items) {
        int i;
        if (this.readable && this.consecutiveNewLines > 0) {
            for (i = 0; i < this.indentLevel; ++i) {
                this.out.print(INDENT);
            }
        }
        for (i = 0; i < items.length; ++i) {
            String s;
            Object item = items[i];
            if (item == null) {
                s = "null";
            } else if (item instanceof Object[]) {
                s = Data.join((Object[])((Object[])item));
            } else if (item instanceof double[]) {
                s = Data.join((double[])((double[])item));
            } else {
                if (item.getClass().isArray()) {
                    throw new IllegalStateException("Cannot handle array of type: " + item.getClass());
                }
                s = Data.format((Object)item, (boolean)false);
            }
            if (i > 0 && !NO_SPACE_BEFORE.contains(Character.valueOf(s.charAt(0)))) {
                this.out.print(" ");
            }
            this.out.print(s);
        }
        this.consecutiveNewLines = 0;
        this.changed = true;
        return this;
    }

    public void mark() {
        this.changed = false;
    }

    public ScriptWriter onNewLine() {
        if (this.consecutiveNewLines == 0) {
            this.ln();
        }
        return this;
    }

    public ScriptWriter indentMore() {
        ++this.indentLevel;
        return this;
    }

    public ScriptWriter ln() {
        ++this.consecutiveNewLines;
        this.out.println();
        this.changed = true;
        return this;
    }

    public ScriptWriter addQuoted(Object ... items) {
        this.indentMore().indentMore();
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                this.out.print(this.readable ? ", " : ",");
            }
            if (this.currentColumn() > 77) {
                this.ln();
            }
            this.add(this.quote(items[i]));
        }
        this.indentLess().indentLess();
        return this;
    }

    private int currentColumn() {
        this.base.flush();
        StringBuffer b = this.base.getBuffer();
        int end = b.length() - 1;
        int eol = b.lastIndexOf("\n");
        if (eol < 0) {
            eol = 0;
        }
        return end - eol;
    }

    public String quote(Object item) {
        return item == null ? "null" : Data.quote((String)item.toString());
    }

    public ScriptWriter addQuotedCollection(Collection<?> items) {
        this.indentMore().indentMore();
        boolean first = true;
        for (Object o : items) {
            if (!first) {
                this.out.print(", ");
            }
            if (this.currentColumn() > this.lineMaxLength - 4) {
                this.ln();
            }
            this.add(this.quote(o));
            first = false;
        }
        this.indentLess().indentLess();
        return this;
    }

    public ScriptWriter at(int n) {
        if (this.readable) {
            for (int i = this.currentColumn(); i < n; ++i) {
                this.add(" ");
            }
        }
        return this;
    }

    public ScriptWriter comment(Object ... items) {
        if (this.readable) {
            if (this.consecutiveNewLines == 0) {
                this.add(" ");
            }
            this.add("// ").add(items);
        }
        this.ln();
        return this;
    }

    public String content() {
        this.out.close();
        return this.base.toString();
    }

    public ScriptWriter endStatement() {
        return this.add(";").ln();
    }

    public ScriptWriter titleComment(Object ... items) {
        this.ensureBlankLine();
        if (this.readable) {
            this.add("// ").add(items).add(" ");
            for (int i = this.currentColumn(); i < this.lineMaxLength; ++i) {
                this.add("/");
            }
            this.ensureBlankLine();
        }
        return this;
    }

    private void ensureBlankLine() {
        if (this.readable) {
            while (this.consecutiveNewLines < 2) {
                this.ln();
            }
        } else if (this.consecutiveNewLines == 0) {
            this.ln();
        }
    }
}

