/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.brunel.action.Param;
import org.brunel.build.Palette;
import org.brunel.build.d3.D3Interaction;
import org.brunel.build.d3.D3Util;
import org.brunel.build.util.AxisDetails;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.PositionFields;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.auto.Auto;
import org.brunel.data.auto.NumericScale;
import org.brunel.data.util.DateFormat;
import org.brunel.data.util.Range;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

class D3ScaleBuilder {
    final VisTypes.Coordinates coords;
    final boolean isDiagram;
    private final Field colorLegendField;
    private final AxisDetails hAxis;
    private final AxisDetails vAxis;
    private final double[] marginTLBR;
    private final VisSingle[] element;
    private final Dataset[] elementData;
    private final PositionFields positionFields;
    private final ScriptWriter out;

    public boolean needsAxes() {
        return this.hAxis.exists() || this.vAxis.exists();
    }

    public D3ScaleBuilder(VisSingle[] element, Dataset[] elementData, PositionFields positionFields, double chartWidth, double chartHeight, ScriptWriter out) {
        this.element = element;
        this.elementData = elementData;
        this.positionFields = positionFields;
        this.out = out;
        this.isDiagram = this.chooseIsDiagram();
        this.coords = this.makeCombinedCoords();
        VisTypes.Axes axes = this.makeCombinedAxes();
        this.colorLegendField = this.getColorLegendField();
        AxisDetails xAxis = axes == VisTypes.Axes.all || axes == VisTypes.Axes.x ? new AxisDetails("x", positionFields.allXFields, positionFields.xCategorical) : new AxisDetails("x", new Field[0], positionFields.xCategorical);
        AxisDetails yAxis = axes == VisTypes.Axes.all || axes == VisTypes.Axes.y ? new AxisDetails("y", positionFields.allYFields, positionFields.yCategorical) : new AxisDetails("y", new Field[0], positionFields.yCategorical);
        if (this.coords == VisTypes.Coordinates.transposed) {
            this.hAxis = yAxis;
            this.vAxis = xAxis;
        } else {
            this.hAxis = xAxis;
            this.vAxis = yAxis;
        }
        int legendWidth = this.legendWidth();
        this.vAxis.layoutVertically(chartHeight - (double)this.hAxis.estimatedSimpleSizeWhenHorizontal());
        this.hAxis.layoutHorizontally(chartWidth - (double)this.vAxis.size - (double)legendWidth, this.elementsFillHorizontal());
        int marginTop = this.vAxis.topGutter;
        int marginLeft = Math.max(this.vAxis.size, this.hAxis.leftGutter);
        int marginBottom = Math.max(this.hAxis.size, this.vAxis.bottomGutter);
        int marginRight = Math.max(this.hAxis.rightGutter, legendWidth);
        this.marginTLBR = new double[]{marginTop, marginLeft, marginBottom, marginRight};
    }

    private void defineAxesBuild() {
        this.out.onNewLine().ln().add("function buildAxes() {").indentMore();
        if (this.hAxis.exists()) {
            this.out.onNewLine().add("axes.select('g.axis.x').call(axis_bottom)");
            if (this.hAxis.rotatedTicks) {
                this.addRotateTicks();
            }
            this.out.endStatement();
        }
        if (this.vAxis.exists()) {
            this.out.onNewLine().add("axes.select('g.axis.y').call(axis_left)");
            if (this.vAxis.rotatedTicks) {
                this.addRotateTicks();
            }
            this.out.endStatement();
        }
        this.out.indentLess().add("}").endStatement().ln();
    }

    public List<Object> getCategories(Field[] ff) {
        LinkedHashSet all = new LinkedHashSet();
        for (Field f : ff) {
            if (!f.preferCategorical()) continue;
            Collections.addAll(all, f.categories());
        }
        return new ArrayList<Object>(all);
    }

    public Double getGranularitySuitableForSizing(Field[] ff) {
        Double r = null;
        for (Field f : ff) {
            Double g;
            if (f.isDate() || (g = f.numericProperty("granularity")) == null || !(g / (f.max() - f.min()) > 0.02) || r != null && !(g < r)) continue;
            r = g;
        }
        return r;
    }

    public double[] marginsTLBR() {
        return this.marginTLBR;
    }

    public void writeAestheticScales(VisSingle vis) {
        Param color = this.getColor(vis);
        Param[] size = this.getSize(vis);
        Param opacity = this.getOpacity(vis);
        if (color == null && opacity == null && size.length == 0) {
            return;
        }
        this.out.onNewLine().comment("Aesthetic Functions");
        if (color != null) {
            this.addColorScale(color, vis);
            this.out.onNewLine().add("var color = function(d) { return scale_color(" + D3Util.writeCall(this.fieldById(color, vis)) + ") }").endStatement();
        }
        if (opacity != null) {
            this.addOpacityScale(opacity, vis);
            this.out.onNewLine().add("var opacity = function(d) { return scale_opacity(" + D3Util.writeCall(this.fieldById(opacity, vis)) + ") }").endStatement();
        }
        if (size.length == 1) {
            String defaultTransform = vis.tElement == VisTypes.Element.point ? "sqrt" : "linear";
            this.addSizeScale("size", size[0], vis, defaultTransform);
            this.out.onNewLine().add("var size = function(d) { return scale_size(" + D3Util.writeCall(this.fieldById(size[0], vis)) + ") }").endStatement();
        } else if (size.length > 1) {
            this.addSizeScale("width", size[0], vis, "linear");
            this.addSizeScale("height", size[1], vis, "linear");
            this.out.onNewLine().add("var width = function(d) { return scale_width(" + D3Util.writeCall(this.fieldById(size[0], vis)) + ") }").endStatement();
            this.out.onNewLine().add("var height = function(d) { return scale_height(" + D3Util.writeCall(this.fieldById(size[1], vis)) + ") }").endStatement();
        }
    }

    private Field fieldById(Param p, VisSingle vis) {
        return this.fieldById(p.asField(), vis);
    }

    public boolean allNumeric(Field[] fields) {
        for (Field f : fields) {
            if (f.isNumeric()) continue;
            return false;
        }
        return true;
    }

    public void writeAxes() {
        if (this.isDiagram) {
            return;
        }
        String width = "geom.inner_width";
        String height = "geom.inner_height";
        if (this.coords == VisTypes.Coordinates.transposed) {
            String t = width;
            width = height;
            height = t;
        }
        if (this.hAxis.exists()) {
            this.out.onNewLine().add("axes.append('g').attr('class', 'x axis')").addChained("attr('transform','translate(0,' + " + height + " + ')')").endStatement();
            if (this.hAxis.title != null) {
                this.out.add("axes.select('g.axis.x').append('text').attr('class', 'title')").addChained("attr('text-anchor', 'middle')").addChained("attr('x', " + width + "/2)").addChained("attr('y', geom.inner_bottom - 6)").addChained("text(" + Data.quote((String)this.hAxis.title) + ")").endStatement();
            }
        }
        if (this.vAxis.exists()) {
            this.out.onNewLine().add("axes.append('g').attr('class', 'y axis')").addChained("attr('transform','translate(geom.chart_left, 0)')").endStatement();
            if (this.vAxis.title != null) {
                this.out.add("axes.select('g.axis.y').append('text').attr('class', 'title')").addChained("attr('text-anchor', 'middle')").addChained("attr('x', -" + height + "/2)").addChained("attr('y', 6-geom.inner_left).attr('dy', '0.7em').attr('transform', 'rotate(270)')").addChained("text(" + Data.quote((String)this.vAxis.title) + ")").endStatement();
            }
        }
        this.out.onNewLine().ln();
        if (this.hAxis.exists()) {
            this.out.add("var axis_bottom = d3.svg.axis().scale(" + this.hAxis.scale + ").innerTickSize(3).outerTickSize(0)");
            if (this.hAxis.tickValues != null) {
                this.out.addChained("tickValues([").addQuoted(this.hAxis.tickValues).add("])");
            }
            if (this.hAxis.isLog()) {
                this.out.addChained("ticks(7, ',.g3')");
            }
            this.out.endStatement();
        }
        if (this.vAxis.exists()) {
            this.out.add("var axis_left = d3.svg.axis().orient('left').scale(" + this.vAxis.scale + ").innerTickSize(3).outerTickSize(0)");
            if (this.vAxis.tickValues != null) {
                this.out.addChained("tickValues([").addQuoted(this.vAxis.tickValues).add("])");
            }
            if (this.vAxis.isLog()) {
                this.out.addChained("ticks(7, ',.g3')");
            }
            this.out.endStatement();
        }
        this.defineAxesBuild();
    }

    public void writeCoordinateScales(D3Interaction interaction) {
        this.writePositionScale("x", this.positionFields.allXFields, this.getXRange(), this.elementsFillHorizontal());
        this.writePositionScale("y", this.positionFields.allYFields, this.getYRange(), false);
        interaction.addScaleInteractivity();
    }

    public void writeLegends(VisSingle vis) {
        String legendTicks;
        if (vis.fColor.isEmpty() || this.colorLegendField == null) {
            return;
        }
        if (!vis.fColor.get(0).asField().equals(this.colorLegendField.name)) {
            return;
        }
        String legendLabels = null;
        if (this.colorLegendField.preferCategorical()) {
            legendTicks = "scale_color.domain()";
        } else {
            NumericScale details = Auto.makeNumericScale((Field)this.colorLegendField, (boolean)true, (double[])new double[]{0.0, 0.0}, (double)0.25, (int)7, (boolean)false);
            Object[] divisions = details.divisions;
            if (details.granular) {
                Double[] newDiv = new Double[divisions.length - 1];
                for (int i = 0; i < newDiv.length; ++i) {
                    newDiv[i] = (divisions[i] + (Double)divisions[i + 1]) / 2.0;
                }
                divisions = newDiv;
            }
            for (int i = 0; i < divisions.length / 2; ++i) {
                Double t = divisions[divisions.length - 1 - i];
                divisions[divisions.length - 1 - i] = divisions[i];
                divisions[i] = t;
            }
            if (this.colorLegendField.isDate()) {
                DateFormat dateFormat = (DateFormat)this.colorLegendField.property("dateFormat");
                D3Util.DateBuilder dateBuilder = new D3Util.DateBuilder();
                Object[] divs = new String[divisions.length];
                Object[] labels = new String[divisions.length];
                for (int i = 0; i < divs.length; ++i) {
                    divs[i] = dateBuilder.make(Data.asDate((Object)divisions[i]), dateFormat, true);
                    labels[i] = "'" + this.colorLegendField.format(divisions[i]) + "'";
                }
                legendTicks = "[" + Data.join((Object[])divs) + "]";
                legendLabels = "[" + Data.join((Object[])labels) + "]";
            } else {
                legendTicks = "[" + Data.join((Object[])divisions) + "]";
            }
        }
        String title = this.colorLegendField.label;
        if (title == null) {
            title = this.colorLegendField.name;
        }
        this.out.add("BrunelD3.addLegend(legends, " + this.out.quote(title) + ", scale_color, " + legendTicks);
        if (legendLabels != null) {
            this.out.add(", ").add(legendLabels);
        }
        this.out.add(")").endStatement();
    }

    private void addColorScale(Param p, VisSingle vis) {
        Field f = this.fieldById(p, vis);
        this.scaleWithDomain("color", new Field[]{f}, Purpose.color, 9, "linear");
        Object[] palette = Palette.makePalette(f, p.hasModifiers() ? p.firstModifier().asString() : null);
        this.out.addChained("range([ ").addQuoted(palette).add("])").endStatement();
    }

    private void addRotateTicks() {
        this.out.add(".selectAll('.tick text')").addChained("style('text-anchor', 'end')").addChained("attr('dx', '-.3em')").addChained("attr('dy', '.6em')").addChained("attr('transform', function(d) { return 'rotate(-45)' })");
    }

    private void addSizeScale(String name, Param p, VisSingle vis, String defaultTransform) {
        double min = 0.05;
        double max = 1.0;
        if (p.modifiers().length == 2) {
            double v1 = p.modifiers()[0].asDouble() / 100.0;
            double v2 = p.modifiers()[1].asDouble() / 100.0;
            min = Math.min(v1, v2);
            max = Math.max(v1, v2);
        } else if (p.modifiers().length == 1) {
            max = p.modifiers()[0].asDouble() / 100.0;
        }
        Field f = this.fieldById(p, vis);
        this.scaleWithDomain(name, new Field[]{f}, Purpose.size, 2, defaultTransform);
        if (f.preferCategorical()) {
            int length = f.categories().length;
            double[] sizes = new double[length];
            for (int i = 0; i < length; ++i) {
                sizes[i] = max * ((double)i + 1.0) / (double)length;
            }
            this.out.addChained("range(" + Arrays.toString(sizes) + ")");
        } else {
            this.out.addChained("range([", min, ",", max, "])");
        }
        this.out.endStatement();
    }

    private void addOpacityScale(Param p, VisSingle vis) {
        double min = p.hasModifiers() ? p.firstModifier().asDouble() : 0.2;
        Field f = this.fieldById(p, vis);
        this.scaleWithDomain("opacity", new Field[]{f}, Purpose.color, 2, "linear");
        if (f.preferCategorical()) {
            int length = f.categories().length;
            double[] sizes = new double[length];
            if (length == 1) {
                sizes[0] = min;
            } else {
                for (int i = 0; i < length; ++i) {
                    sizes[i] = min + (1.0 - min) * (double)i / (double)(length - 1);
                }
            }
            this.out.addChained("range(" + Arrays.toString(sizes) + ")");
        } else {
            this.out.addChained("range([" + min + ", 1])");
        }
        this.out.endStatement();
    }

    private boolean chooseIsDiagram() {
        for (VisSingle e : this.element) {
            if (e.tDiagram != null) continue;
            return false;
        }
        return true;
    }

    private Field combineNumericFields(Field[] ff) {
        ArrayList<Double> data = new ArrayList<Double>();
        for (Field f : ff) {
            for (int i = 0; i < f.rowCount(); ++i) {
                Object value = f.value(i);
                if (value instanceof Range) {
                    data.add(Data.asNumeric((Object)((Range)value).low));
                    data.add(Data.asNumeric((Object)((Range)value).high));
                    continue;
                }
                data.add(Data.asNumeric((Object)value));
            }
        }
        Field combined = Data.makeColumnField((String)"combined", null, (Object[])data.toArray(new Object[data.size()]));
        combined.set("numeric", (Object)true);
        return combined;
    }

    private Field fieldById(String fieldName, VisSingle vis) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] != vis) continue;
            Field field = this.elementData[i].field(fieldName);
            if (field == null) {
                throw new IllegalStateException("Unknown field " + fieldName);
            }
            return field;
        }
        throw new IllegalStateException("Passed in a vis that was not part of the system defined in the constructor");
    }

    private Param getColor(VisSingle vis) {
        return vis.fColor.isEmpty() ? null : vis.fColor.get(0);
    }

    private Param getOpacity(VisSingle vis) {
        return vis.fOpacity.isEmpty() ? null : vis.fOpacity.get(0);
    }

    private Field getColorLegendField() {
        Field result = null;
        for (VisSingle vis : this.element) {
            boolean auto;
            boolean bl = auto = vis.tLegends == VisTypes.Legends.auto;
            if (vis.fColor.isEmpty() || vis.tLegends == VisTypes.Legends.none) continue;
            Field f = this.fieldById(this.getColor(vis).asField(), vis);
            if (auto && f.name.equals("#selection")) continue;
            if (result == null) {
                result = f;
                continue;
            }
            if (this.same(result, f)) continue;
            return null;
        }
        return result;
    }

    private double getIncludeZeroFraction(Field[] fields, Purpose purpose) {
        if (purpose == Purpose.x) {
            return 0.1;
        }
        if (purpose == Purpose.size) {
            return 0.9;
        }
        if (purpose == Purpose.color) {
            return 0.2;
        }
        for (Field field : fields) {
            if (!field.name.equals("#count") && !"sum".equals(field.stringProperty("summary"))) continue;
            return 1.0;
        }
        for (VisSingle visSingle : this.element) {
            if (visSingle.tElement != VisTypes.Element.bar && visSingle.tElement != VisTypes.Element.area || visSingle.fRange != null) continue;
            return 0.8;
        }
        return 0.2;
    }

    private boolean elementsFillHorizontal() {
        boolean fillToEdge = true;
        for (VisSingle e : this.element) {
            if (e.tElement == VisTypes.Element.line || e.tElement == VisTypes.Element.area) continue;
            fillToEdge = false;
        }
        return fillToEdge;
    }

    private double[] getNumericPaddingFraction(Purpose purpose, VisTypes.Coordinates coords) {
        double[] padding = new double[]{0.0, 0.0};
        if (purpose == Purpose.color || purpose == Purpose.size) {
            return padding;
        }
        if (coords == VisTypes.Coordinates.polar) {
            return padding;
        }
        for (VisSingle e : this.element) {
            boolean noBottomYPadding;
            boolean bl = noBottomYPadding = e.tElement == VisTypes.Element.bar || e.tElement == VisTypes.Element.area || e.tElement == VisTypes.Element.line;
            if (e.tElement == VisTypes.Element.text) {
                padding[0] = Math.max(padding[0], 0.1);
                padding[1] = Math.max(padding[1], 0.1);
                continue;
            }
            if (purpose == Purpose.y && noBottomYPadding) {
                padding[1] = Math.max(padding[1], 0.02);
                continue;
            }
            padding[0] = Math.max(padding[0], 0.02);
            padding[1] = Math.max(padding[1], 0.02);
        }
        return padding;
    }

    private Param[] getSize(VisSingle vis) {
        List<Param> fSize = vis.fSize;
        return fSize.toArray(new Param[fSize.size()]);
    }

    private String getXRange() {
        if (this.coords == VisTypes.Coordinates.polar) {
            return "[0, geom.inner_radius]";
        }
        boolean reversed = this.coords == VisTypes.Coordinates.transposed && this.positionFields.xCategorical;
        return reversed ? "[geom.inner_width,0]" : "[0, geom.inner_width]";
    }

    private String getYRange() {
        if (this.coords == VisTypes.Coordinates.polar) {
            return "[0, Math.PI*2]";
        }
        boolean reversed = false;
        if (this.coords != VisTypes.Coordinates.transposed) {
            reversed = !this.positionFields.yCategorical;
        }
        return reversed ? "[geom.inner_height,0]" : "[0, geom.inner_height]";
    }

    private int legendWidth() {
        if (this.colorLegendField == null) {
            return 0;
        }
        AxisDetails legendAxis = new AxisDetails("color", new Field[]{this.colorLegendField}, this.colorLegendField.preferCategorical());
        int spaceNeededForTicks = 32 + legendAxis.maxCategoryWidth();
        int spaceNeededForTitle = this.colorLegendField.label.length() * 7;
        return 6 + Math.max(spaceNeededForTicks, spaceNeededForTitle);
    }

    private VisTypes.Axes makeCombinedAxes() {
        VisTypes.Axes result = VisTypes.Axes.auto;
        for (VisSingle e : this.element) {
            if (e.tAxes == VisTypes.Axes.all) {
                return VisTypes.Axes.all;
            }
            if (result == VisTypes.Axes.auto) {
                result = e.tAxes;
                continue;
            }
            if (e.tAxes == VisTypes.Axes.x) {
                if (result == VisTypes.Axes.y) {
                    return VisTypes.Axes.all;
                }
                result = VisTypes.Axes.x;
                continue;
            }
            if (e.tAxes != VisTypes.Axes.y) continue;
            if (result == VisTypes.Axes.x) {
                return VisTypes.Axes.all;
            }
            result = VisTypes.Axes.y;
        }
        if (result == VisTypes.Axes.auto) {
            return this.coords == VisTypes.Coordinates.polar || this.isDiagram ? VisTypes.Axes.none : VisTypes.Axes.all;
        }
        return result;
    }

    private VisTypes.Coordinates makeCombinedCoords() {
        if (this.isDiagram) {
            for (VisSingle e : this.element) {
                if (e.tDiagram != VisTypes.Diagram.chord && e.tDiagram != VisTypes.Diagram.cloud) continue;
                return VisTypes.Coordinates.polar;
            }
        }
        VisTypes.Coordinates result = this.element[0].coords;
        for (VisSingle e : this.element) {
            if (e.coords.compareTo(result) <= 0) continue;
            result = e.coords;
        }
        return result;
    }

    private boolean same(Field a, Field b) {
        return a.name.equals(b.name) && a.preferCategorical() == b.preferCategorical();
    }

    private int scaleWithDomain(String name, Field[] fields, Purpose purpose, int numericDomainDivs, String defaultTransform) {
        Field scaleField;
        this.out.onNewLine().add("var", "scale_" + name, "= ");
        if (fields.length == 0) {
            this.out.add("d3.scale.linear().domain([0,1])");
            return -1;
        }
        Field field = fields[0];
        if (ModelUtil.combinationIsCategorical(fields, purpose.isCoord)) {
            List<Object> list = this.getCategories(fields);
            this.out.add("d3.scale.ordinal()").addChained("domain([").addQuotedCollection(list).add("])");
            return list.size();
        }
        double includeZero = this.getIncludeZeroFraction(fields, purpose);
        Field field2 = scaleField = fields.length == 1 ? field : this.combineNumericFields(fields);
        if (name.equals("x")) {
            if (scaleField == field) {
                scaleField = field.rename(field.name, field.label);
            }
            scaleField.set("transform", (Object)this.positionFields.xTransform);
        }
        if (name.equals("y")) {
            if (scaleField == field) {
                scaleField = field.rename(field.name, field.label);
            }
            scaleField.set("transform", (Object)this.positionFields.yTransform);
        }
        boolean nice = (name.equals("x") || name.equals("y")) && this.coords != VisTypes.Coordinates.polar;
        double[] padding = this.getNumericPaddingFraction(purpose, this.coords);
        if (scaleField.isBinned() || purpose == Purpose.x && this.elementsFillHorizontal()) {
            nice = false;
            padding = new double[]{0.0, 0.0};
            includeZero = 0.0;
        }
        NumericScale detail = Auto.makeNumericScale((Field)scaleField, (boolean)nice, (double[])padding, (double)includeZero, (int)9, (boolean)false);
        double min = detail.min;
        double max = detail.max;
        Object[] divs = new Object[numericDomainDivs];
        if (field.isDate()) {
            DateFormat dateFormat = (DateFormat)field.property("dateFormat");
            D3Util.DateBuilder dateBuilder = new D3Util.DateBuilder();
            for (int i = 0; i < divs.length; ++i) {
                double v = min + (max - min) * (double)i / (double)(numericDomainDivs - 1);
                divs[i] = dateBuilder.make(Data.asDate((Object)v), dateFormat, true);
            }
            this.out.add("d3.time.scale()");
        } else {
            String transform = null;
            if (name.equals("x")) {
                transform = this.positionFields.xTransform;
            }
            if (name.equals("y")) {
                transform = this.positionFields.yTransform;
            }
            if (purpose == Purpose.size) {
                transform = defaultTransform;
            } else if (transform == null) {
                transform = (String)scaleField.property("transform");
                if (transform == null) {
                    transform = "linear";
                }
                if (transform.equals("linear")) {
                    transform = defaultTransform;
                }
            }
            if (transform.equals("root")) {
                transform = "sqrt";
            }
            this.out.add("d3.scale." + transform + "()");
            for (int i = 0; i < divs.length; ++i) {
                divs[i] = min + (max - min) * (double)i / (double)(numericDomainDivs - 1);
            }
        }
        this.out.addChained("domain([").add(Data.join((Object[])divs)).add("])");
        return -1;
    }

    private void writePositionScale(String name, Field[] fields, String range, boolean fillToEdge) {
        int categories = this.scaleWithDomain(name, fields, Purpose.valueOf(name), 2, "linear");
        if (fields.length == 0) {
            this.out.addChained("range(" + range + ")");
        } else if (categories > 0) {
            if (fillToEdge) {
                this.out.addChained("rangePoints(" + range + ", 0)");
            } else {
                this.out.addChained("rangePoints(" + range + ", 1)");
            }
        } else {
            this.out.addChained("range(" + range + ")");
        }
        this.out.endStatement();
    }

    private static enum Purpose {
        x(true),
        y(true),
        size(false),
        color(false);

        public final boolean isCoord;

        private Purpose(boolean isCoord) {
            this.isCoord = isCoord;
        }
    }
}

