/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.brunel.action.Param;
import org.brunel.build.d3.D3Util;
import org.brunel.build.util.ElementDetails;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class D3LabelBuilder {
    private final VisSingle vis;
    private final ScriptWriter out;
    private final Dataset data;

    public D3LabelBuilder(VisSingle vis, ScriptWriter out, Dataset data) {
        this.vis = vis;
        this.out = out;
        this.data = data;
    }

    public void addLabels(ElementDetails details) {
        String method = details.textMethod;
        String yOffset = method.equals("top") ? "-0.3em" : (method.equals("bottom") ? "0.7em" : "0.3em");
        this.out.add("var labelGroup = labels.selectAll('text').data(" + details.dataSource + ")").endStatement();
        this.out.add("labelGroup.enter().append('text').attr('dy', '" + yOffset + "').attr('class', 'label')");
        if (method.equals("left")) {
            this.out.addChained("style('text-anchor', 'end')");
        } else if (method.equals("right")) {
            this.out.addChained("style('text-anchor', 'start')");
        } else {
            this.out.addChained("style('text-anchor', 'middle')");
        }
        this.out.endStatement();
        this.out.add("BrunelD3.tween(labelGroup,transitionMillis, function(d, i) {").indentMore().onNewLine().add("return BrunelD3.makeLabeling(this, selection[0][i], labeling, true)").indentLess().onNewLine().add("})").endStatement();
        this.out.add("labelGroup.exit().remove()").endStatement();
    }

    public void addFontSizeAttribute(VisSingle vis) {
        if (!vis.fSize.isEmpty()) {
            ModelUtil.Size parts = ModelUtil.getFontSize(vis);
            if (parts == null) {
                this.out.addChained("style('font-size', function(d) { return (100*size(d)) + '%' })");
            } else {
                this.out.addChained("style('font-size', function(d) { return (", parts.value(), "* size(d)) +'" + parts.suffix() + "' })");
            }
        }
    }

    public void addTooltips(ElementDetails details) {
        if (this.vis.itemsTooltip.isEmpty()) {
            return;
        }
        this.out.onNewLine().ln();
        this.defineLabeling(details.modifyForTooltip(this.vis.coords == VisTypes.Coordinates.transposed), this.prettify(this.vis.itemsTooltip, true), true);
        this.out.add("BrunelD3.addTooltip(selection, tooltipLabeling, geom)").endStatement();
    }

    public void addTreeInternalLabels(ElementDetails details, String where) {
        this.out.add("diagramLabels.attr('class', 'axis diagram treemap hierarchy')").endStatement();
        this.out.add("var treeLabels = diagramLabels.selectAll('text').data(d3Data)").endStatement();
        this.out.add("treeLabels.enter().append('text')");
        this.out.addChained("attr('class', function(d) { return 'axis label L' + d.depth })");
        this.out.addChained("attr('dx', 2)").addChained("attr('dy', '0.85em')").endStatement();
        this.out.add("var treeLabeling = {method:'box', fit:true, content:function(d){return d.innerNodeName}, ");
        this.out.indentMore().ln().add("where : function(box) { return", where, "}").indentLess();
        this.out.add("}").endStatement();
        this.out.add("BrunelD3.tween(treeLabels,transitionMillis, function(d, i) { return BrunelD3.makeLabeling(this, selection[0][i], treeLabeling, false)})");
        this.out.endStatement();
        this.out.add("treeLabels.exit().remove()").endStatement();
    }

    public void defineLabeling(ElementDetails details, List<Param> items, boolean forTooltip) {
        String name = forTooltip ? "tooltipLabeling" : "labeling";
        this.out.add("var", name, "= {").ln().indentMore();
        String textMethod = details.textMethod;
        this.out.add("method:", this.out.quote(textMethod), ",").ln();
        this.out.add("fit:", details.textMustFit, ",").ln();
        if (details.producesPath) {
            this.out.add("path: path,").ln();
        }
        this.out.add("content: function(d) {").ln().indentMore();
        this.out.add("return d.row == null ? null : ");
        this.writeContent(items, forTooltip);
        this.out.indentLess().onNewLine().add("}");
        this.out.indentLess().onNewLine().add("}").endStatement();
    }

    public boolean needed() {
        return this.vis.itemsLabel.size() > 0 || this.vis.tElement == VisTypes.Element.text;
    }

    private List<Param> prettify(List<Param> items, boolean longForm) {
        if (items.size() < 2) {
            return items;
        }
        ArrayList<Param> result = new ArrayList<Param>();
        for (int i = 0; i < items.size(); ++i) {
            Param p = items.get(i);
            if (!p.isField()) {
                return items;
            }
            Field f = this.data.field(p.asField());
            if (i > 0) {
                result.add(Param.makeString(longForm ? "<br/>" : ", "));
            }
            if (longForm) {
                result.add(Param.makeString("<span class=\"title\">" + f.label + ": </span>"));
            }
            result.add(p);
        }
        return result;
    }

    private void writeContent(List<Param> items, boolean forTooltip) {
        if (items.isEmpty()) {
            if (this.vis.tDiagram != null) {
                items = Param.makeFields(this.vis.positionFields());
            }
            if (items.isEmpty()) {
                items = Collections.singletonList(Param.makeField("#row"));
            }
        }
        boolean first = true;
        for (Param p : this.prettify(items, false)) {
            if (!first) {
                this.out.add("\n\t\t\t+ ");
            }
            if (p.isField()) {
                Field f = this.data.field(p.asField());
                if (forTooltip) {
                    this.out.add("'<span class=\"field\">' + ");
                }
                if (p.hasModifiers()) {
                    this.out.add("BrunelD3.shorten(");
                }
                this.out.add("data." + D3Util.baseFieldID(f) + "_f(d)");
                if (p.hasModifiers()) {
                    this.out.add(",", (int)p.firstModifier().asDouble(), ")");
                }
                if (forTooltip) {
                    this.out.add(" + '</span>'");
                }
            } else {
                String o = p.asString();
                if (forTooltip) {
                    o = o.replaceAll("\\\\n", "&#10;");
                }
                this.out.add(Data.quote((String)o));
            }
            first = false;
        }
    }
}

