/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.summary;

import java.util.Arrays;
import java.util.Comparator;
import org.brunel.data.Data;
import org.brunel.data.Field;

public class FieldRowComparison
implements Comparator<Integer> {
    private final boolean[] ascending;
    private final boolean rowsBreakTies;
    private final int n;
    private final Field[] fields;

    public FieldRowComparison(Field[] fields, boolean[] ascending, boolean rowsBreakTies) {
        this.fields = fields;
        this.ascending = ascending;
        this.rowsBreakTies = rowsBreakTies;
        this.n = fields.length;
    }

    @Override
    public int compare(Integer a, Integer b) {
        for (int i = 0; i < this.n; ++i) {
            int n = this.fields[i].compareRows(a, b);
            if (n == 0) continue;
            return this.ascending != null && !this.ascending[i] ? -n : n;
        }
        return this.rowsBreakTies ? a - b : 0;
    }

    public int[] makeSortedOrder(int len) {
        Integer[] items = new Integer[len];
        for (int i = 0; i < len; ++i) {
            items[i] = i;
        }
        Arrays.sort(items, this);
        return Data.toPrimitive(items);
    }
}

