/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.modify;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.modify.DataOperation;
import org.brunel.data.summary.FieldRowComparison;

public class Sort
extends DataOperation {
    public static Dataset transform(Dataset base, String command) {
        String[] sortFields = Sort.parts(command);
        if (sortFields == null) {
            return base;
        }
        Field[] dimensions = Sort.getFields(base, sortFields);
        boolean[] ascending = Sort.getAscending(dimensions, sortFields);
        int[] rowOrder = new FieldRowComparison(dimensions, ascending, true).makeSortedOrder(base.rowCount());
        for (int i = base.fields.length - 1; i >= 0; --i) {
            Field f = base.fields[i];
            if (!f.isBinned() || !f.preferCategorical()) continue;
            rowOrder = Sort.moveCatchAllToEnd(rowOrder, f);
        }
        Field[] fields = new Field[base.fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Object[] newOrder = null;
            Field field = base.fields[i];
            if (!field.ordered()) {
                newOrder = Sort.makeOrder(field, dimensions, ascending);
            }
            fields[i] = Data.permute(field, rowOrder, true);
            if (newOrder == null) continue;
            fields[i].setCategories(newOrder);
        }
        return base.replaceFields(fields);
    }

    private static Object[] makeOrder(Field field, Field[] dimensions, boolean[] ascending) {
        HashMap<Object, ArrayList<Integer>> categorySums = new HashMap<Object, ArrayList<Integer>>();
        for (int i = 0; i < field.rowCount(); ++i) {
            Object category = field.value(i);
            if (category == null) continue;
            ArrayList<Integer> value = (ArrayList<Integer>)categorySums.get(category);
            if (value == null) {
                value = new ArrayList<Integer>();
                categorySums.put(category, value);
            }
            value.add(i);
        }
        Object[] categories = field.categories();
        int n = categories.length;
        Object[][] dimensionData = new Object[dimensions.length][n];
        for (int r = 0; r < n; ++r) {
            List value = (List)categorySums.get(categories[r]);
            for (int i = 0; i < dimensions.length; ++i) {
                dimensionData[i][r] = dimensions[i].isNumeric() ? Sort.sum(dimensions[i], value) : Sort.mode(dimensions[i], value);
            }
        }
        Field[] summaries = new Field[dimensions.length];
        for (int i = 0; i < dimensions.length; ++i) {
            summaries[i] = Data.makeColumnField("", null, dimensionData[i]);
            if (!dimensions[i].isNumeric()) continue;
            summaries[i].set("numeric", true);
        }
        int[] order = new FieldRowComparison(summaries, ascending, true).makeSortedOrder(n);
        Object[] result = new Object[n];
        for (int i = 0; i < n; ++i) {
            result[i] = categories[order[i]];
        }
        return result;
    }

    private static Object sum(Field field, List<Integer> rows) {
        double sum = 0.0;
        for (int i : rows) {
            Double v = Data.asNumeric(field.value(i));
            if (v == null) continue;
            sum += v.doubleValue();
        }
        return sum;
    }

    private static Object mode(Field field, List<Integer> rows) {
        Object mode = null;
        int max = 0;
        HashMap<Object, Integer> count = new HashMap<Object, Integer>();
        for (int i : rows) {
            Object v = field.value(i);
            Integer c = (Integer)count.get(v);
            if (c == null) {
                c = 0;
            }
            if ((c = Integer.valueOf(c + 1)) > max) {
                max = c;
                mode = v;
            }
            count.put(v, c);
        }
        return mode;
    }

    static double[] makeRowRanking(int[] order, FieldRowComparison comparison) {
        double[] ranks = new double[order.length];
        int runStart = 0;
        while (runStart < order.length) {
            int runEnd;
            for (runEnd = runStart + 1; runEnd < order.length && comparison.compare(order[runStart], order[runEnd]) == 0; ++runEnd) {
            }
            double v = (double)(runEnd + runStart + 1) / 2.0;
            while (runStart < runEnd) {
                ranks[order[runStart++]] = v;
            }
        }
        return ranks;
    }

    private static Field[] getFields(Dataset base, String[] names) {
        Field[] fields = new Field[names.length];
        for (int i = 0; i < fields.length; ++i) {
            String name = names[i].split(":")[0];
            fields[i] = base.field(name.trim());
            if (fields[i] != null) continue;
            throw new IllegalArgumentException("Could not find field: " + name);
        }
        return fields;
    }

    private static boolean[] getAscending(Field[] dimensions, String[] names) {
        boolean[] ascending = new boolean[dimensions.length];
        for (int i = 0; i < ascending.length; ++i) {
            String[] parts = names[i].split(":");
            if (parts.length > 1) {
                String p = parts[1].trim();
                if (p.equalsIgnoreCase("ascending")) {
                    ascending[i] = true;
                    continue;
                }
                if (p.equalsIgnoreCase("descending")) {
                    ascending[i] = false;
                    continue;
                }
                throw new IllegalArgumentException("Sort options must be 'ascending' or 'descending'");
            }
            ascending[i] = dimensions[i].isDate() || !dimensions[i].isNumeric();
        }
        return ascending;
    }

    private static int[] moveCatchAllToEnd(int[] order, Field f) {
        int[] result = new int[order.length];
        ArrayList<Integer> atEnd = new ArrayList<Integer>();
        int at = 0;
        for (int j : order) {
            if ("\u2026".equals(f.value(j))) {
                atEnd.add(j);
                continue;
            }
            result[at++] = j;
        }
        for (Integer i : atEnd) {
            result[at++] = i;
        }
        return result;
    }

    static Object[] categoriesFromRanks(Field field, double[] rowRanking) {
        double n = field.rowCount();
        Object[] categories = field.categories();
        int[] counts = (int[])field.property("categoryCounts");
        Object[] means = new Double[counts.length];
        for (int i = 0; i < means.length; ++i) {
            means[i] = (double)i / 100.0 / (double)means.length;
        }
        HashMap<Object, Integer> index = new HashMap<Object, Integer>();
        for (Object o : categories) {
            index.put(o, index.size());
        }
        int i = 0;
        while ((double)i < n) {
            Object o = field.value(i);
            if (o != null) {
                int idx = (Integer)index.get(o);
                Object[] objectArray = means;
                int n2 = idx;
                Double.valueOf((Double)objectArray[n2] + rowRanking[i] / (double)counts[idx]);
            }
            ++i;
        }
        Integer[] which = Data.order(means, true);
        Object[] cats = new Object[which.length];
        for (int i2 = 0; i2 < which.length; ++i2) {
            cats[i2] = categories[which[i2]];
        }
        return cats;
    }
}

