# -*- coding: utf-8 -*-

u'''Single-instance strings, C{intern}'ed across modules.
'''

__all__ = ('NN',)
__version__ = '20.08.17'

NN = ''  # no name, empty str, Nomen Nescio <https://Wiktionary.org/wiki/N.N.>

# __DUNDER__ would get mangled in classes
_0_                  = '0'                    # PYCHOK expected
_1_                  = '1'                    # PYCHOK expected
_2_                  = '2'                    # PYCHOK expected
_areaOf_             = 'areaOf'               # PYCHOK expected
_ambiguous_          = 'ambiguous'            # PYCHOK expected
_angle_              = 'angle'                # PYCHOK expected
_AT_                 = '@'                    # PYCHOK expected
_azimuth_            = 'azimuth'              # PYCHOK expected
_band_               = 'band'                 # PYCHOK expected
_bearing_            = 'bearing'              # PYCHOK expected
_beta_               = 'beta'                 # PYCHOK expected
_C_                  = 'C'                    # PYCHOK expected
_Cartesian_          = 'Cartesian'            # PYCHOK expected
_center1_            = 'center1'              # PYCHOK expected
_center2_            = 'center2'              # PYCHOK expected
_coincident_         = 'coincident'           # PYCHOK expected
_colinear_           = 'colinear'             # PYCHOK expected
_COLON_              = ':'                    # PYCHOK expected
_COMMA_              = ','                    # PYCHOK expected
_convergence_        = 'convergence'          # PYCHOK expected
_cubic_              = 'cubic'                # PYCHOK expected
_CURLY_              = '{%s}'                 # PYCHOK expected
_datum_              = 'datum'                # PYCHOK expected
_decode3_            = 'decode3'              # PYCHOK expected
_deg_                = 'deg'                  # PYCHOK expected
_degrees_            = 'degrees'              # PYCHOK expected
_distance_           = 'distance'             # PYCHOK expected
_distanceTo_         = 'distanceTo'           # PYCHOK expected
_doesn_t_exist_      = "doesn't exist"        # PYCHOK expected
_DOT_                = '.'                    # PYCHOK expected
_E_                  = 'E'                    # PYCHOK expected
_easting_            = 'easting'              # PYCHOK expected
_elevation_          = 'elevation'            # PYCHOK expected
_ellipsoid_          = 'ellipsoid'            # PYCHOK expected
_ellipsoidal_        = 'ellipsoidal'          # PYCHOK expected
_encode_             = 'encode'               # PYCHOK expected
_end_                = 'end'                  # PYCHOK expected
_EQUAL_              = '='                    # PYCHOK expected
_exceed_PI_radians_  = 'exceed PI radians'    # PYCHOK expected
_feet_               = 'feet'                 # PYCHOK expected
_fraction_           = 'fraction'             # PYCHOK expected
_gamma_              = 'gamma'                # PYCHOK expected
_h_                  = 'h'                    # PYCHOK expected
_height_             = 'height'               # PYCHOK expected
_hemipole_           = 'hemipole'             # PYCHOK expected
_intersection_       = 'intersection'         # PYCHOK expected
_inside_             = 'inside'               # PYCHOK expected
_invalid_            = 'invalid'              # PYCHOK expected
_isclockwise_        = 'isclockwise'          # PYCHOK expected
_ispolar_            = 'ispolar'              # PYCHOK expected
_k0_                 = 'k0'                   # PYCHOK expected
_knots_              = 'knots'                # PYCHOK expected
_lam_                = 'lam'                  # PYCHOK expected
_lat_                = 'lat'                  # PYCHOK expected
_lat0_               = 'lat0'                 # PYCHOK expected
_lat1_               = 'lat1'                 # PYCHOK expected
_lat2_               = 'lat2'                 # PYCHOK expected
_LatLon_             = 'LatLon'               # PYCHOK expected
_len_                = 'len'                  # PYCHOK expected
_linear_             = 'linear'               # PYCHOK expected
_lon_                = 'lon'                  # PYCHOK expected
_lon0_               = 'lon0'                 # PYCHOK expected
_lon1_               = 'lon1'                 # PYCHOK expected
_m_                  = 'm'                    # PYCHOK expected
_meanOf_             = 'meanOf'               # PYCHOK expected
_meter_              = 'meter'                # PYCHOK expected
_MGRS_               = 'MGRS'                 # PYCHOK expected
_N_                  = 'N'                    # PYCHOK expected
_n_a_                = 'n/a'                  # PYCHOK expected
_name_               = 'name'                 # PYCHOK expected
_near_concentric_    = 'near-concentric'      # PYCHOK expected
_nearestOn2_         = 'nearestOn2'           # PYCHOK expected
_no_convergence_     = 'no convergence'       # PYCHOK expected
_no_convergence_fmt_ = 'no convergence (%g)'  # PYCHOK expected
_no_conversion_      = 'no conversion'        # PYCHOK expected
_northing_           = 'northing'             # PYCHOK expected
_NorthPole_          = 'NorthPole'            # PYCHOK expected
_not_convex_         = 'not convex'           # PYCHOK expected
_number_             = 'number'               # PYCHOK expected
_Nvector_            = 'Nvector'              # PYCHOK expected
_other_              = 'other'                # PYCHOK expected
_outside_            = 'outside'              # PYCHOK expected
_PARENTH_            = '(%s)'                 # PYCHOK expected
_PERCENT_            = '%'                    # PYCHOK expected
_perimeterOf_        = 'perimeterOf'          # PYCHOK expected
_phi_                = 'phi'                  # PYCHOK expected
_PLUS_               = '+'                    # PYCHOK expected
_point_              = 'point'                # PYCHOK expected
_points_             = 'points'               # PYCHOK expected
_pole_               = 'pole'                 # PYCHOK expected
_prec_               = 'prec'                 # PYCHOK expected
_precision_          = 'precision'            # PYCHOK expected
_radians_            = 'radians'              # PYCHOK expected
_radians2_           = 'radians**2'           # PYCHOK expected
_radius_             = 'radius'               # PYCHOK expected
_radius1_            = 'radius1'              # PYCHOK expected
_radius2_            = 'radius2'              # PYCHOK expected
_range_              = 'range'                # PYCHOK expected
_reciprocal_         = 'reciprocal'           # PYCHOK expected
_res_                = 'res'                  # PYCHOK expected
_resolution_         = 'resolution'           # PYCHOK expected
_S_                  = 'S'                    # PYCHOK expected
_scalar_             = 'scalar'               # PYCHOK expected
_scale_              = 'scale'                # PYCHOK expected
_spherical_          = 'spherical'            # PYCHOK expected
_SouthPole_          = 'SouthPole'            # PYCHOK expected
_SPACE_              = ' '                    # PYCHOK expected
_SQUARE_             = '[%s]'                 # PYCHOK expected
_STAR_               = '*'                    # PYCHOK expected
_start_              = 'start'                # PYCHOK expected
_start1_             = 'start1'               # PYCHOK expected
_start2_             = 'start2'               # PYCHOK expected
_std_                = 'std'                  # PYCHOK expected
_sumOf_              = 'sumOf'                # PYCHOK expected
_too_distant_        = 'too distant'          # PYCHOK expected
_too_distant_fmt_    = 'too distant (%.3g)'   # PYCHOK expected
_too_few_            = 'too few'              # PYCHOK expected
_too_small_          = 'too small'            # PYCHOK expected
_transform_          = 'transform'            # PYCHOK expected
_UNDERSCORE_         = '_'                    # PYCHOK expected
_units_              = 'units'                # PYCHOK expected
_UPS_                = 'UPS'                  # PYCHOK expected
_utf_8_              = 'utf-8'                # PYCHOK expected
_UTM_                = 'UTM'                  # PYCHOK expected
_valid_              = 'valid'                # PYCHOK expected
_W_                  = 'W'                    # PYCHOK expected
_x_                  = 'x'                    # PYCHOK expected
_y_                  = 'y'                    # PYCHOK expected
_z_                  = 'z'                    # PYCHOK expected
_zone_               = 'zone'                 # PYCHOK expected

_COLON_SPACE_        = _COLON_ + _SPACE_      # PYCHOK expected
_COMMA_SPACE_        = _COMMA_ + _SPACE_      # PYCHOK expected
_DUNDER_             = _UNDERSCORE_ * 2       # PYCHOK expected
_EW_                 = _E_  + _W_             # PYCHOK common cardinals
_NE_                 = _N_  + _E_             # PYCHOK expected
_NS_                 = _N_  + _S_             # PYCHOK expected
_NSEW_               = _NS_ + _EW_            # PYCHOK expected
_NW_                 = _N_  + _W_             # PYCHOK expected
_SE_                 = _S_  + _E_             # PYCHOK expected
_SW_                 = _S_  + _W_             # PYCHOK negative ones


class _Missing(object):
    '''(INTERNAL) Singleton.
    '''
    def toRepr(self, **unused):
        return 'MISSING'  # self.__class__.__name__.strip(_UNDERSCORE_),lower()

    __repr__ = toRepr
    __str__  = toRepr
    toStr    = toRepr

_Missing = _Missing()  # PYCHOK singleton


def _dot_(*prefix_names):
    '''(INTERNAL) Period-join C{prefix} and C{name}.
    '''
    return _DOT_.join(prefix_names)


def _dunder_name(inst, *dflt):
    '''(INTERNAL) Get the double_underscore __name__ attr.
    '''
    try:
        return inst.__name__
    except AttributeError:
        pass
    return dflt[0] if dflt else inst.__class__.__name__


def _item_fmt(fmt, name_value_arg, name_value_kwd):
    '''(INTERNAL) Helper for _item_pr, _item_ps and _item_sq.
    '''
    for n_v in name_value_kwd.items():
        break
    else:
        if len(name_value_arg) > 1:
            n_v = name_value_arg[:2]
        elif name_value_arg:
            n_v = name_value_arg, _Missing
        else:
            n_v = _Missing, _Missing
    return fmt % n_v


def _item_cs(*name_value_arg, **name_value_kwd):  # PYCHOK expected
    '''(INTERNAL) Return a named value string.
    '''
    return _item_fmt('%s: %s', name_value_arg, name_value_kwd)


def _item_pr(*name_value_arg, **name_value_kwd):  # PYCHOK expected
    '''(INTERNAL) Return a parenthesized name representation.
    '''
    return _item_fmt('%s(%r)', name_value_arg, name_value_kwd)


def _item_ps(*name_value_arg, **name_value_kwd):  # PYCHOK expected
    '''(INTERNAL) Return a parenthesized name string.
    '''
    return _item_fmt('%s(%s)', name_value_arg, name_value_kwd)


def _item_sq(*name_value_arg, **name_value_kwd):  # PYCHOK expected
    '''(INTERNAL) Return an indexed or keyed name.
    '''
    return _item_fmt('%s[%r]', name_value_arg, name_value_kwd)

# **) MIT License
#
# Copyright (C) 2016-2020 -- mrJean1 at Gmail -- All Rights Reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
# OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
# ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.
