/*
 * Decompiled with CFR 0.152.
 */
package morfologik.stemming;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.Iterator;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.DictionaryMetadata;
import morfologik.stemming.WordData;
import morfologik.util.BufferUtils;

public final class DictionaryIterator
implements Iterator<WordData> {
    private final CharsetDecoder decoder;
    private final Iterator<ByteBuffer> entriesIter;
    private final WordData entry;
    private final byte separator;
    private final DictionaryMetadata dictionaryMetadata;
    private final boolean decodeStems;
    private ByteBuffer inflectedBuffer = ByteBuffer.allocate(0);
    private CharBuffer inflectedCharBuffer = CharBuffer.allocate(0);
    private ByteBuffer temp = ByteBuffer.allocate(0);

    public DictionaryIterator(Dictionary dictionary, CharsetDecoder decoder, boolean decodeStems) {
        this.entriesIter = dictionary.fsa.iterator();
        this.separator = dictionary.metadata.getSeparator();
        this.dictionaryMetadata = dictionary.metadata;
        this.decoder = decoder;
        this.entry = new WordData(decoder);
        this.decodeStems = decodeStems;
    }

    @Override
    public boolean hasNext() {
        return this.entriesIter.hasNext();
    }

    @Override
    public WordData next() {
        int sepPos;
        ByteBuffer entryBuffer = this.entriesIter.next();
        this.entry.reset();
        byte[] ba = entryBuffer.array();
        int bbSize = entryBuffer.remaining();
        for (sepPos = 0; sepPos < bbSize && ba[sepPos] != this.separator; ++sepPos) {
        }
        if (sepPos == bbSize) {
            throw new RuntimeException("Invalid dictionary entry format (missing separator).");
        }
        this.inflectedBuffer.clear();
        this.inflectedBuffer = BufferUtils.ensureCapacity(this.inflectedBuffer, sepPos);
        this.inflectedBuffer.put(ba, 0, sepPos);
        this.inflectedBuffer.flip();
        this.inflectedCharBuffer = this.bytesToChars(this.inflectedBuffer, this.inflectedCharBuffer);
        this.entry.wordBuffer = this.inflectedBuffer;
        this.entry.wordCharSequence = this.inflectedCharBuffer;
        this.temp.clear();
        this.temp = BufferUtils.ensureCapacity(this.temp, bbSize - sepPos);
        this.temp.put(ba, ++sepPos, bbSize - sepPos);
        this.temp.flip();
        ba = this.temp.array();
        bbSize = this.temp.remaining();
        for (sepPos = 0; sepPos < bbSize && ba[sepPos] != this.separator; ++sepPos) {
        }
        this.entry.stemBuffer.clear();
        if (this.decodeStems) {
            this.entry.stemBuffer = DictionaryLookup.decodeBaseForm(this.entry.stemBuffer, ba, sepPos, this.inflectedBuffer, this.dictionaryMetadata);
        } else {
            this.entry.stemBuffer = BufferUtils.ensureCapacity(this.entry.stemBuffer, sepPos);
            this.entry.stemBuffer.put(ba, 0, sepPos);
        }
        this.entry.stemBuffer.flip();
        if (sepPos + 1 <= bbSize) {
            ++sepPos;
        }
        this.entry.tagBuffer = BufferUtils.ensureCapacity(this.entry.tagBuffer, bbSize - sepPos);
        this.entry.tagBuffer.clear();
        this.entry.tagBuffer.put(ba, sepPos, bbSize - sepPos);
        this.entry.tagBuffer.flip();
        return this.entry;
    }

    private CharBuffer bytesToChars(ByteBuffer bytes, CharBuffer chars) {
        chars.clear();
        int maxCapacity = (int)((float)bytes.remaining() * this.decoder.maxCharsPerByte());
        if (chars.capacity() <= maxCapacity) {
            chars = CharBuffer.allocate(maxCapacity);
        }
        bytes.mark();
        this.decoder.reset();
        this.decoder.decode(bytes, chars, true);
        chars.flip();
        bytes.reset();
        return chars;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

