#!/usr/bin/env python

from cffi import FFI
ffi = FFI()
ffi.cdef("""
int prctl(int option, unsigned long arg2, unsigned long arg3,
unsigned long arg4, unsigned long arg5);

#define PR_SET_PDEATHSIG ...
#define PR_GET_PDEATHSIG ...

#define PR_GET_DUMPABLE ...
#define PR_SET_DUMPABLE ...

#define PR_GET_UNALIGN ...
#define PR_SET_UNALIGN ...
#define PR_UNALIGN_NOPRINT ...
#define PR_UNALIGN_SIGBUS ...

#define PR_GET_KEEPCAPS ...
#define PR_SET_KEEPCAPS ...

#define PR_GET_FPEMU ...
#define PR_SET_FPEMU ...
#define PR_FPEMU_NOPRINT ...
#define PR_FPEMU_SIGFPE ...

#define PR_GET_FPEXC ...
#define PR_SET_FPEXC ...
#define PR_FP_EXC_SW_ENABLE ...
#define PR_FP_EXC_DIV ...
#define PR_FP_EXC_OVF ...
#define PR_FP_EXC_UND ...
#define PR_FP_EXC_RES ...
#define PR_FP_EXC_INV ...
#define PR_FP_EXC_DISABLED ...
#define PR_FP_EXC_NONRECOV ...
#define PR_FP_EXC_ASYNC ...
#define PR_FP_EXC_PRECISE ...

#define PR_GET_TIMING ...
#define PR_SET_TIMING ...
#define PR_TIMING_STATISTICAL ...
#define PR_TIMING_TIMESTAMP ...

#define PR_SET_NAME ...
#define PR_GET_NAME ...

#define PR_GET_ENDIAN ...
#define PR_SET_ENDIAN ...
#define PR_ENDIAN_BIG ...
#define PR_ENDIAN_LITTLE ...
#define PR_ENDIAN_PPC_LITTLE ...

#define PR_GET_SECCOMP ...
#define PR_SET_SECCOMP ...

#define PR_CAPBSET_READ ...
#define PR_CAPBSET_DROP ...

#define PR_GET_TSC ...
#define PR_SET_TSC ...
#define PR_TSC_ENABLE ...
#define PR_TSC_SIGSEGV ...

#define PR_GET_SECUREBITS ...
#define PR_SET_SECUREBITS ...

#define PR_SET_TIMERSLACK ...
#define PR_GET_TIMERSLACK ...

#define PR_TASK_PERF_EVENTS_DISABLE ...
#define PR_TASK_PERF_EVENTS_ENABLE ...

#define PR_MCE_KILL_CLEAR ...
#define PR_MCE_KILL_SET ...

#define PR_MCE_KILL_LATE ...
#define PR_MCE_KILL_EARLY ...
#define PR_MCE_KILL_DEFAULT ...

#define PR_MCE_KILL_GET ...

#define PR_SET_MM ...
#define PR_SET_MM_START_CODE ...
#define PR_SET_MM_END_CODE ...
#define PR_SET_MM_START_DATA ...
#define PR_SET_MM_END_DATA ...
#define PR_SET_MM_START_STACK ...
#define PR_SET_MM_START_BRK ...
#define PR_SET_MM_BRK ...
#define PR_SET_MM_ARG_START ...
#define PR_SET_MM_ARG_END ...
#define PR_SET_MM_ENV_START ...
#define PR_SET_MM_ENV_END ...
#define PR_SET_MM_AUXV ...
#define PR_SET_MM_EXE_FILE ...

#define PR_SET_PTRACER ...
#define PR_SET_PTRACER_ANY ...

#define PR_SET_CHILD_SUBREAPER ...
#define PR_GET_CHILD_SUBREAPER ...

#define PR_SET_NO_NEW_PRIVS	...
#define PR_GET_NO_NEW_PRIVS	...

#define PR_GET_TID_ADDRESS ...
""")


_lib = ffi.verify("""  
#include <sys/prctl.h>
""", libraries=[], ext_package="butter")

### prctl
class prctl(object):
    class capbset(object):
        def __contains__(self, val):
            return True if _lib.prctl(_lib.PR_CAPBSET_READ, val, 0, 0, 0) else False
            EINVAL = ValueError("Not a valid capability")
            
        def drop(self, val):
            _lib.prctl(_lib.PR_CAPBSET_DROP, val, 0, 0, 0)
            EPERM = PermissionError("Thread does not have CAP_PSET in its list of capabilities")
            EINVAL = ValueError("Not a valid capability or kernel had no capabilities support")
    capbset = capbset()

    @property
    @staticmethod
    def sub_reaper():
        ret = ffi.new('int *', 0)
        return _lib.prctl(_lib.PR_GET_CHILD_SUBREAPER, ffi.cast('unsigned long', ret), 0, 0, 0)
        
        return True if ret[0] else False

    @dumpable.setter
    @staticmethod
    def sub_reaper():
        _lib.prctl(_lib.PR_SET_CHILD_SUBREAPER, 0, 0, 0, 0)

    @property
    @staticmethod
    def dumpable():
        return True if _lib.prctl(_lib.PR_GET_DUMPABLE, 0, 0, 0, 0) else False

    @dumpable.setter
    @staticmethod
    def dumpable():
        _lib.prctl(_lib.PR_GET_DUMPABLE, 0, 0, 0, 0)

def main():
    from time import sleep
    
    name = ffi.new("char[]", b"DSDSADSA")
    print(_lib.prctl(_lib.PR_SET_NAME, ffi.cast('unsigned long', name), 0, 0, 0))
    sleep(3000)

if __name__ == "__main__":
    main()
