# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApnsCredentialProperties(Model):
    """Description of a NotificationHub ApnsCredential.

    :param apns_certificate: Gets or sets the APNS certificate.
    :type apns_certificate: str
    :param certificate_key: Gets or sets the certificate key.
    :type certificate_key: str
    :param endpoint: Gets or sets the endpoint of this credential.
    :type endpoint: str
    :param thumbprint: Gets or sets the Apns certificate Thumbprint
    :type thumbprint: str
    """ 

    _attribute_map = {
        'apns_certificate': {'key': 'apnsCertificate', 'type': 'str'},
        'certificate_key': {'key': 'certificateKey', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
    }

    def __init__(self, apns_certificate=None, certificate_key=None, endpoint=None, thumbprint=None):
        self.apns_certificate = apns_certificate
        self.certificate_key = certificate_key
        self.endpoint = endpoint
        self.thumbprint = thumbprint
