# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AutomaticTuningOptions(Model):
    """Automatic tuning properties for individual advisors.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param desired_state: Automatic tuning option desired state. Possible
     values include: 'Off', 'On', 'Default'
    :type desired_state: str or
     ~azure.mgmt.sql.models.AutomaticTuningOptionModeDesired
    :ivar actual_state: Automatic tuning option actual state. Possible values
     include: 'Off', 'On'
    :vartype actual_state: str or
     ~azure.mgmt.sql.models.AutomaticTuningOptionModeActual
    :ivar reason_code: Reason code if desired and actual state are different.
    :vartype reason_code: int
    :ivar reason_desc: Reason description if desired and actual state are
     different. Possible values include: 'Default', 'Disabled',
     'AutoConfigured', 'InheritedFromServer', 'QueryStoreOff',
     'QueryStoreReadOnly', 'NotSupported'
    :vartype reason_desc: str or
     ~azure.mgmt.sql.models.AutomaticTuningDisabledReason
    """

    _validation = {
        'actual_state': {'readonly': True},
        'reason_code': {'readonly': True},
        'reason_desc': {'readonly': True},
    }

    _attribute_map = {
        'desired_state': {'key': 'desiredState', 'type': 'AutomaticTuningOptionModeDesired'},
        'actual_state': {'key': 'actualState', 'type': 'AutomaticTuningOptionModeActual'},
        'reason_code': {'key': 'reasonCode', 'type': 'int'},
        'reason_desc': {'key': 'reasonDesc', 'type': 'AutomaticTuningDisabledReason'},
    }

    def __init__(self, **kwargs):
        super(AutomaticTuningOptions, self).__init__(**kwargs)
        self.desired_state = kwargs.get('desired_state', None)
        self.actual_state = None
        self.reason_code = None
        self.reason_desc = None


class AutomaticTuningServerOptions(Model):
    """Automatic tuning properties for individual advisors.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param desired_state: Automatic tuning option desired state. Possible
     values include: 'Off', 'On', 'Default'
    :type desired_state: str or
     ~azure.mgmt.sql.models.AutomaticTuningOptionModeDesired
    :ivar actual_state: Automatic tuning option actual state. Possible values
     include: 'Off', 'On'
    :vartype actual_state: str or
     ~azure.mgmt.sql.models.AutomaticTuningOptionModeActual
    :ivar reason_code: Reason code if desired and actual state are different.
    :vartype reason_code: int
    :ivar reason_desc: Reason description if desired and actual state are
     different. Possible values include: 'Default', 'Disabled',
     'AutoConfigured'
    :vartype reason_desc: str or
     ~azure.mgmt.sql.models.AutomaticTuningServerReason
    """

    _validation = {
        'actual_state': {'readonly': True},
        'reason_code': {'readonly': True},
        'reason_desc': {'readonly': True},
    }

    _attribute_map = {
        'desired_state': {'key': 'desiredState', 'type': 'AutomaticTuningOptionModeDesired'},
        'actual_state': {'key': 'actualState', 'type': 'AutomaticTuningOptionModeActual'},
        'reason_code': {'key': 'reasonCode', 'type': 'int'},
        'reason_desc': {'key': 'reasonDesc', 'type': 'AutomaticTuningServerReason'},
    }

    def __init__(self, **kwargs):
        super(AutomaticTuningServerOptions, self).__init__(**kwargs)
        self.desired_state = kwargs.get('desired_state', None)
        self.actual_state = None
        self.reason_code = None
        self.reason_desc = None


class AutoPauseDelayTimeRange(Model):
    """Supported auto pause delay time range.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar min_value: Minimum value
    :vartype min_value: int
    :ivar max_value: Maximum value
    :vartype max_value: int
    :ivar step_size: Step value for discrete values between the minimum value
     and the maximum value.
    :vartype step_size: int
    :ivar default: Default value is no value is provided
    :vartype default: int
    :ivar unit: Unit of time that delay is expressed in. Possible values
     include: 'Minutes'
    :vartype unit: str or ~azure.mgmt.sql.models.PauseDelayTimeUnit
    :ivar do_not_pause_value: Value that is used to not pause (infinite delay
     before pause)
    :vartype do_not_pause_value: int
    """

    _validation = {
        'min_value': {'readonly': True},
        'max_value': {'readonly': True},
        'step_size': {'readonly': True},
        'default': {'readonly': True},
        'unit': {'readonly': True},
        'do_not_pause_value': {'readonly': True},
    }

    _attribute_map = {
        'min_value': {'key': 'minValue', 'type': 'int'},
        'max_value': {'key': 'maxValue', 'type': 'int'},
        'step_size': {'key': 'stepSize', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'unit': {'key': 'unit', 'type': 'str'},
        'do_not_pause_value': {'key': 'doNotPauseValue', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AutoPauseDelayTimeRange, self).__init__(**kwargs)
        self.min_value = None
        self.max_value = None
        self.step_size = None
        self.default = None
        self.unit = None
        self.do_not_pause_value = None


class Resource(Model):
    """ARM resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """ARM proxy resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProxyResource, self).__init__(**kwargs)


class BackupLongTermRetentionPolicy(ProxyResource):
    """A long term retention policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param weekly_retention: The weekly retention policy for an LTR backup in
     an ISO 8601 format.
    :type weekly_retention: str
    :param monthly_retention: The monthly retention policy for an LTR backup
     in an ISO 8601 format.
    :type monthly_retention: str
    :param yearly_retention: The yearly retention policy for an LTR backup in
     an ISO 8601 format.
    :type yearly_retention: str
    :param week_of_year: The week of year to take the yearly backup in an ISO
     8601 format.
    :type week_of_year: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'weekly_retention': {'key': 'properties.weeklyRetention', 'type': 'str'},
        'monthly_retention': {'key': 'properties.monthlyRetention', 'type': 'str'},
        'yearly_retention': {'key': 'properties.yearlyRetention', 'type': 'str'},
        'week_of_year': {'key': 'properties.weekOfYear', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(BackupLongTermRetentionPolicy, self).__init__(**kwargs)
        self.weekly_retention = kwargs.get('weekly_retention', None)
        self.monthly_retention = kwargs.get('monthly_retention', None)
        self.yearly_retention = kwargs.get('yearly_retention', None)
        self.week_of_year = kwargs.get('week_of_year', None)


class BackupShortTermRetentionPolicy(ProxyResource):
    """A short term retention policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param retention_days: The backup retention period in days. This is how
     many days Point-in-Time Restore will be supported.
    :type retention_days: int
    :param diff_backup_interval_in_hours: The differential backup interval in
     hours. This is how many interval hours between each differential backup
     will be supported. This is only applicable to live databases but not
     dropped databases.
    :type diff_backup_interval_in_hours: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'diff_backup_interval_in_hours': {'key': 'properties.diffBackupIntervalInHours', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(BackupShortTermRetentionPolicy, self).__init__(**kwargs)
        self.retention_days = kwargs.get('retention_days', None)
        self.diff_backup_interval_in_hours = kwargs.get('diff_backup_interval_in_hours', None)


class CheckNameAvailabilityRequest(Model):
    """A request to check whether the specified name for a resource is available.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :ivar type: Required.  Default value: "Microsoft.Sql/servers" .
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Sql/servers"

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class CheckNameAvailabilityResponse(Model):
    """The result of a name availability check.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name whose availability was checked.
    :vartype name: str
    :ivar available: True if the name is available, otherwise false.
    :vartype available: bool
    :ivar reason: The reason code explaining why the name is unavailable. Will
     be undefined if the name is available. Possible values include: 'Invalid',
     'AlreadyExists'
    :vartype reason: str or ~azure.mgmt.sql.models.CheckNameAvailabilityReason
    :ivar message: A message explaining why the name is unavailable. Will be
     undefined if the name is available.
    :vartype message: str
    """

    _validation = {
        'name': {'readonly': True},
        'available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'available': {'key': 'available', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'CheckNameAvailabilityReason'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityResponse, self).__init__(**kwargs)
        self.name = None
        self.available = None
        self.reason = None
        self.message = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class CompleteDatabaseRestoreDefinition(Model):
    """Contains the information necessary to perform a complete database restore
    operation.

    All required parameters must be populated in order to send to Azure.

    :param last_backup_name: Required. The last backup name to apply
    :type last_backup_name: str
    """

    _validation = {
        'last_backup_name': {'required': True},
    }

    _attribute_map = {
        'last_backup_name': {'key': 'lastBackupName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CompleteDatabaseRestoreDefinition, self).__init__(**kwargs)
        self.last_backup_name = kwargs.get('last_backup_name', None)


class CreateDatabaseRestorePointDefinition(Model):
    """Contains the information necessary to perform a create database restore
    point operation.

    All required parameters must be populated in order to send to Azure.

    :param restore_point_label: Required. The restore point label to apply
    :type restore_point_label: str
    """

    _validation = {
        'restore_point_label': {'required': True},
    }

    _attribute_map = {
        'restore_point_label': {'key': 'restorePointLabel', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CreateDatabaseRestorePointDefinition, self).__init__(**kwargs)
        self.restore_point_label = kwargs.get('restore_point_label', None)


class TrackedResource(Resource):
    """ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class Database(TrackedResource):
    """A database resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param sku: The database SKU.
     The list of SKUs may vary by region and support offer. To determine the
     SKUs (including the SKU name, tier/edition, family, and capacity) that are
     available to your subscription in an Azure region, use the
     `Capabilities_ListByLocation` REST API or one of the following commands:
     ```azurecli
     az sql db list-editions -l <location> -o table
     ````
     ```powershell
     Get-AzSqlServerServiceObjective -Location <location>
     ````
    :type sku: ~azure.mgmt.sql.models.Sku
    :ivar kind: Kind of database. This is metadata used for the Azure portal
     experience.
    :vartype kind: str
    :ivar managed_by: Resource that manages the database.
    :vartype managed_by: str
    :param create_mode: Specifies the mode of database creation.
     Default: regular database creation.
     Copy: creates a database as a copy of an existing database.
     sourceDatabaseId must be specified as the resource ID of the source
     database.
     Secondary: creates a database as a secondary replica of an existing
     database. sourceDatabaseId must be specified as the resource ID of the
     existing primary database.
     PointInTimeRestore: Creates a database by restoring a point in time backup
     of an existing database. sourceDatabaseId must be specified as the
     resource ID of the existing database, and restorePointInTime must be
     specified.
     Recovery: Creates a database by restoring a geo-replicated backup.
     sourceDatabaseId must be specified as the recoverable database resource ID
     to restore.
     Restore: Creates a database by restoring a backup of a deleted database.
     sourceDatabaseId must be specified. If sourceDatabaseId is the database's
     original resource ID, then sourceDatabaseDeletionDate must be specified.
     Otherwise sourceDatabaseId must be the restorable dropped database
     resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime
     may also be specified to restore from an earlier point in time.
     RestoreLongTermRetentionBackup: Creates a database by restoring from a
     long term retention vault. recoveryServicesRecoveryPointResourceId must be
     specified as the recovery point resource ID.
     Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for
     DataWarehouse edition. Possible values include: 'Default', 'Copy',
     'Secondary', 'PointInTimeRestore', 'Restore', 'Recovery',
     'RestoreExternalBackup', 'RestoreExternalBackupSecondary',
     'RestoreLongTermRetentionBackup', 'OnlineSecondary'
    :type create_mode: str or ~azure.mgmt.sql.models.CreateMode
    :param collation: The collation of the database.
    :type collation: str
    :param max_size_bytes: The max size of the database expressed in bytes.
    :type max_size_bytes: long
    :param sample_name: The name of the sample schema to apply when creating
     this database. Possible values include: 'AdventureWorksLT',
     'WideWorldImportersStd', 'WideWorldImportersFull'
    :type sample_name: str or ~azure.mgmt.sql.models.SampleName
    :param elastic_pool_id: The resource identifier of the elastic pool
     containing this database.
    :type elastic_pool_id: str
    :param source_database_id: The resource identifier of the source database
     associated with create operation of this database.
    :type source_database_id: str
    :ivar status: The status of the database. Possible values include:
     'Online', 'Restoring', 'RecoveryPending', 'Recovering', 'Suspect',
     'Offline', 'Standby', 'Shutdown', 'EmergencyMode', 'AutoClosed',
     'Copying', 'Creating', 'Inaccessible', 'OfflineSecondary', 'Pausing',
     'Paused', 'Resuming', 'Scaling', 'OfflineChangingDwPerformanceTiers',
     'OnlineChangingDwPerformanceTiers', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.DatabaseStatus
    :ivar database_id: The ID of the database.
    :vartype database_id: str
    :ivar creation_date: The creation date of the database (ISO8601 format).
    :vartype creation_date: datetime
    :ivar current_service_objective_name: The current service level objective
     name of the database.
    :vartype current_service_objective_name: str
    :ivar requested_service_objective_name: The requested service level
     objective name of the database.
    :vartype requested_service_objective_name: str
    :ivar default_secondary_location: The default secondary region for this
     database.
    :vartype default_secondary_location: str
    :ivar failover_group_id: Failover Group resource identifier that this
     database belongs to.
    :vartype failover_group_id: str
    :param restore_point_in_time: Specifies the point in time (ISO8601 format)
     of the source database that will be restored to create the new database.
    :type restore_point_in_time: datetime
    :param source_database_deletion_date: Specifies the time that the database
     was deleted.
    :type source_database_deletion_date: datetime
    :param recovery_services_recovery_point_id: The resource identifier of the
     recovery point associated with create operation of this database.
    :type recovery_services_recovery_point_id: str
    :param long_term_retention_backup_resource_id: The resource identifier of
     the long term retention backup associated with create operation of this
     database.
    :type long_term_retention_backup_resource_id: str
    :param recoverable_database_id: The resource identifier of the recoverable
     database associated with create operation of this database.
    :type recoverable_database_id: str
    :param restorable_dropped_database_id: The resource identifier of the
     restorable dropped database associated with create operation of this
     database.
    :type restorable_dropped_database_id: str
    :param catalog_collation: Collation of the metadata catalog. Possible
     values include: 'DATABASE_DEFAULT', 'SQL_Latin1_General_CP1_CI_AS'
    :type catalog_collation: str or
     ~azure.mgmt.sql.models.CatalogCollationType
    :param zone_redundant: Whether or not this database is zone redundant,
     which means the replicas of this database will be spread across multiple
     availability zones.
    :type zone_redundant: bool
    :param license_type: The license type to apply for this database.
     `LicenseIncluded` if you need a license, or `BasePrice` if you have a
     license and are eligible for the Azure Hybrid Benefit. Possible values
     include: 'LicenseIncluded', 'BasePrice'
    :type license_type: str or ~azure.mgmt.sql.models.DatabaseLicenseType
    :ivar max_log_size_bytes: The max log size for this database.
    :vartype max_log_size_bytes: long
    :ivar earliest_restore_date: This records the earliest start date and time
     that restore is available for this database (ISO8601 format).
    :vartype earliest_restore_date: datetime
    :param read_scale: The state of read-only routing. If enabled, connections
     that have application intent set to readonly in their connection string
     may be routed to a readonly secondary replica in the same region. Possible
     values include: 'Enabled', 'Disabled'
    :type read_scale: str or ~azure.mgmt.sql.models.DatabaseReadScale
    :param high_availability_replica_count: The number of secondary replicas
     associated with the database that are used to provide high availability.
    :type high_availability_replica_count: int
    :param secondary_type: The secondary type of the database if it is a
     secondary.  Valid values are Geo and Named. Possible values include:
     'Geo', 'Named'
    :type secondary_type: str or ~azure.mgmt.sql.models.SecondaryType
    :ivar current_sku: The name and tier of the SKU.
    :vartype current_sku: ~azure.mgmt.sql.models.Sku
    :param auto_pause_delay: Time in minutes after which database is
     automatically paused. A value of -1 means that automatic pause is disabled
    :type auto_pause_delay: int
    :param storage_account_type: The storage account type used to store
     backups for this database. Currently the only supported option is GRS
     (GeoRedundantStorage). Possible values include: 'GRS', 'LRS', 'ZRS'
    :type storage_account_type: str or
     ~azure.mgmt.sql.models.StorageAccountType
    :param min_capacity: Minimal capacity that database will always have
     allocated, if not paused
    :type min_capacity: float
    :ivar paused_date: The date when database was paused by user configuration
     or action(ISO8601 format). Null if the database is ready.
    :vartype paused_date: datetime
    :ivar resumed_date: The date when database was resumed by user action or
     database login (ISO8601 format). Null if the database is paused.
    :vartype resumed_date: datetime
    :param maintenance_configuration_id: Maintenance configuration id assigned
     to the database. This configuration defines the period when the
     maintenance updates will be rolled out.
    :type maintenance_configuration_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'readonly': True},
        'managed_by': {'readonly': True},
        'status': {'readonly': True},
        'database_id': {'readonly': True},
        'creation_date': {'readonly': True},
        'current_service_objective_name': {'readonly': True},
        'requested_service_objective_name': {'readonly': True},
        'default_secondary_location': {'readonly': True},
        'failover_group_id': {'readonly': True},
        'max_log_size_bytes': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
        'current_sku': {'readonly': True},
        'paused_date': {'readonly': True},
        'resumed_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'long'},
        'sample_name': {'key': 'properties.sampleName', 'type': 'str'},
        'elastic_pool_id': {'key': 'properties.elasticPoolId', 'type': 'str'},
        'source_database_id': {'key': 'properties.sourceDatabaseId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'database_id': {'key': 'properties.databaseId', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'current_service_objective_name': {'key': 'properties.currentServiceObjectiveName', 'type': 'str'},
        'requested_service_objective_name': {'key': 'properties.requestedServiceObjectiveName', 'type': 'str'},
        'default_secondary_location': {'key': 'properties.defaultSecondaryLocation', 'type': 'str'},
        'failover_group_id': {'key': 'properties.failoverGroupId', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'source_database_deletion_date': {'key': 'properties.sourceDatabaseDeletionDate', 'type': 'iso-8601'},
        'recovery_services_recovery_point_id': {'key': 'properties.recoveryServicesRecoveryPointId', 'type': 'str'},
        'long_term_retention_backup_resource_id': {'key': 'properties.longTermRetentionBackupResourceId', 'type': 'str'},
        'recoverable_database_id': {'key': 'properties.recoverableDatabaseId', 'type': 'str'},
        'restorable_dropped_database_id': {'key': 'properties.restorableDroppedDatabaseId', 'type': 'str'},
        'catalog_collation': {'key': 'properties.catalogCollation', 'type': 'str'},
        'zone_redundant': {'key': 'properties.zoneRedundant', 'type': 'bool'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'max_log_size_bytes': {'key': 'properties.maxLogSizeBytes', 'type': 'long'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
        'read_scale': {'key': 'properties.readScale', 'type': 'str'},
        'high_availability_replica_count': {'key': 'properties.highAvailabilityReplicaCount', 'type': 'int'},
        'secondary_type': {'key': 'properties.secondaryType', 'type': 'str'},
        'current_sku': {'key': 'properties.currentSku', 'type': 'Sku'},
        'auto_pause_delay': {'key': 'properties.autoPauseDelay', 'type': 'int'},
        'storage_account_type': {'key': 'properties.storageAccountType', 'type': 'str'},
        'min_capacity': {'key': 'properties.minCapacity', 'type': 'float'},
        'paused_date': {'key': 'properties.pausedDate', 'type': 'iso-8601'},
        'resumed_date': {'key': 'properties.resumedDate', 'type': 'iso-8601'},
        'maintenance_configuration_id': {'key': 'properties.maintenanceConfigurationId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Database, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.kind = None
        self.managed_by = None
        self.create_mode = kwargs.get('create_mode', None)
        self.collation = kwargs.get('collation', None)
        self.max_size_bytes = kwargs.get('max_size_bytes', None)
        self.sample_name = kwargs.get('sample_name', None)
        self.elastic_pool_id = kwargs.get('elastic_pool_id', None)
        self.source_database_id = kwargs.get('source_database_id', None)
        self.status = None
        self.database_id = None
        self.creation_date = None
        self.current_service_objective_name = None
        self.requested_service_objective_name = None
        self.default_secondary_location = None
        self.failover_group_id = None
        self.restore_point_in_time = kwargs.get('restore_point_in_time', None)
        self.source_database_deletion_date = kwargs.get('source_database_deletion_date', None)
        self.recovery_services_recovery_point_id = kwargs.get('recovery_services_recovery_point_id', None)
        self.long_term_retention_backup_resource_id = kwargs.get('long_term_retention_backup_resource_id', None)
        self.recoverable_database_id = kwargs.get('recoverable_database_id', None)
        self.restorable_dropped_database_id = kwargs.get('restorable_dropped_database_id', None)
        self.catalog_collation = kwargs.get('catalog_collation', None)
        self.zone_redundant = kwargs.get('zone_redundant', None)
        self.license_type = kwargs.get('license_type', None)
        self.max_log_size_bytes = None
        self.earliest_restore_date = None
        self.read_scale = kwargs.get('read_scale', None)
        self.high_availability_replica_count = kwargs.get('high_availability_replica_count', None)
        self.secondary_type = kwargs.get('secondary_type', None)
        self.current_sku = None
        self.auto_pause_delay = kwargs.get('auto_pause_delay', None)
        self.storage_account_type = kwargs.get('storage_account_type', None)
        self.min_capacity = kwargs.get('min_capacity', None)
        self.paused_date = None
        self.resumed_date = None
        self.maintenance_configuration_id = kwargs.get('maintenance_configuration_id', None)


class DatabaseAutomaticTuning(ProxyResource):
    """Database-level Automatic Tuning.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param desired_state: Automatic tuning desired state. Possible values
     include: 'Inherit', 'Custom', 'Auto', 'Unspecified'
    :type desired_state: str or ~azure.mgmt.sql.models.AutomaticTuningMode
    :ivar actual_state: Automatic tuning actual state. Possible values
     include: 'Inherit', 'Custom', 'Auto', 'Unspecified'
    :vartype actual_state: str or ~azure.mgmt.sql.models.AutomaticTuningMode
    :param options: Automatic tuning options definition.
    :type options: dict[str, ~azure.mgmt.sql.models.AutomaticTuningOptions]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'actual_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'desired_state': {'key': 'properties.desiredState', 'type': 'AutomaticTuningMode'},
        'actual_state': {'key': 'properties.actualState', 'type': 'AutomaticTuningMode'},
        'options': {'key': 'properties.options', 'type': '{AutomaticTuningOptions}'},
    }

    def __init__(self, **kwargs):
        super(DatabaseAutomaticTuning, self).__init__(**kwargs)
        self.desired_state = kwargs.get('desired_state', None)
        self.actual_state = None
        self.options = kwargs.get('options', None)


class DatabaseBlobAuditingPolicy(ProxyResource):
    """A database blob auditing policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :param state: Required. Specifies the state of the policy. If state is
     Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
     Possible values include: 'Enabled', 'Disabled'
    :type state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled,
     storageEndpoint or isAzureMonitorTargetEnabled is required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the
     auditing storage account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed
     identity to access the storage.
     Prerequisites for using managed identity authentication:
     1. Assign SQL Server a system-assigned managed identity in Azure Active
     Directory (AAD).
     2. Grant SQL Server identity access to the storage account by adding
     'Storage Blob Data Contributor' RBAC role to the server identity.
     For more information, see [Auditing to storage using Managed Identity
     authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the audit
     logs in the storage account.
    :type retention_days: int
    :param audit_actions_and_groups: Specifies the Actions-Groups and Actions
     to audit.
     The recommended set of action groups to use is the following combination -
     this will audit all the queries and stored procedures executed against the
     database, as well as successful and failed logins:
     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.
     This above combination is also the set that is configured by default when
     enabling auditing from the Azure portal.
     The supported action groups to audit are (note: choose only specific
     groups that cover your auditing needs. Using unnecessary groups could lead
     to very large quantities of audit records):
     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
     These are groups that cover all sql statements and stored procedures
     executed against the database, and should not be used in combination with
     other groups as this will result in duplicate audit logs.
     For more information, see [Database-Level Audit Action
     Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
     For Database auditing policy, specific Actions can also be specified (note
     that Actions cannot be specified for Server auditing policy). The
     supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES
     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}
     Note that <object> in the above format can refer to an object like a
     table, view, or stored procedure, or an entire database or schema. For the
     latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are
     used, respectively.
     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public
     For more information, see [Database-Level Audit
     Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
    :type audit_actions_and_groups: list[str]
    :param storage_account_subscription_id: Specifies the blob storage
     subscription Id.
    :type storage_account_subscription_id: str
    :param is_storage_secondary_key_in_use: Specifies whether
     storageAccountAccessKey value is the storage's secondary key.
    :type is_storage_secondary_key_in_use: bool
    :param is_azure_monitor_target_enabled: Specifies whether audit events are
     sent to Azure Monitor.
     In order to send the events to Azure Monitor, specify 'state' as 'Enabled'
     and 'isAzureMonitorTargetEnabled' as true.
     When using REST API to configure auditing, Diagnostic Settings with
     'SQLSecurityAuditEvents' diagnostic logs category on the database should
     be also created.
     Note that for server level audit you should use the 'master' database as
     {databaseName}.
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
     For more information, see [Diagnostic Settings REST
     API](https://go.microsoft.com/fwlink/?linkid=2033207)
     or [Diagnostic Settings
     PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
    :type is_azure_monitor_target_enabled: bool
    :param queue_delay_ms: Specifies the amount of time in milliseconds that
     can elapse before audit actions are forced to be processed.
     The default minimum value is 1000 (1 second). The maximum is
     2,147,483,647.
    :type queue_delay_ms: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'BlobAuditingPolicyState'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'audit_actions_and_groups': {'key': 'properties.auditActionsAndGroups', 'type': '[str]'},
        'storage_account_subscription_id': {'key': 'properties.storageAccountSubscriptionId', 'type': 'str'},
        'is_storage_secondary_key_in_use': {'key': 'properties.isStorageSecondaryKeyInUse', 'type': 'bool'},
        'is_azure_monitor_target_enabled': {'key': 'properties.isAzureMonitorTargetEnabled', 'type': 'bool'},
        'queue_delay_ms': {'key': 'properties.queueDelayMs', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(DatabaseBlobAuditingPolicy, self).__init__(**kwargs)
        self.kind = None
        self.state = kwargs.get('state', None)
        self.storage_endpoint = kwargs.get('storage_endpoint', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.retention_days = kwargs.get('retention_days', None)
        self.audit_actions_and_groups = kwargs.get('audit_actions_and_groups', None)
        self.storage_account_subscription_id = kwargs.get('storage_account_subscription_id', None)
        self.is_storage_secondary_key_in_use = kwargs.get('is_storage_secondary_key_in_use', None)
        self.is_azure_monitor_target_enabled = kwargs.get('is_azure_monitor_target_enabled', None)
        self.queue_delay_ms = kwargs.get('queue_delay_ms', None)


class DatabaseOperation(ProxyResource):
    """A database operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar database_name: The name of the database the operation is being
     performed on.
    :vartype database_name: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar percent_complete: The percentage of the operation completed.
    :vartype percent_complete: int
    :ivar server_name: The name of the server.
    :vartype server_name: str
    :ivar start_time: The operation start time.
    :vartype start_time: datetime
    :ivar state: The operation state. Possible values include: 'Pending',
     'InProgress', 'Succeeded', 'Failed', 'CancelInProgress', 'Cancelled'
    :vartype state: str or ~azure.mgmt.sql.models.ManagementOperationState
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar is_user_error: Whether or not the error is a user error.
    :vartype is_user_error: bool
    :ivar estimated_completion_time: The estimated completion time of the
     operation.
    :vartype estimated_completion_time: datetime
    :ivar description: The operation description.
    :vartype description: str
    :ivar is_cancellable: Whether the operation can be cancelled.
    :vartype is_cancellable: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'database_name': {'readonly': True},
        'operation': {'readonly': True},
        'operation_friendly_name': {'readonly': True},
        'percent_complete': {'readonly': True},
        'server_name': {'readonly': True},
        'start_time': {'readonly': True},
        'state': {'readonly': True},
        'error_code': {'readonly': True},
        'error_description': {'readonly': True},
        'error_severity': {'readonly': True},
        'is_user_error': {'readonly': True},
        'estimated_completion_time': {'readonly': True},
        'description': {'readonly': True},
        'is_cancellable': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'operation_friendly_name': {'key': 'properties.operationFriendlyName', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'error_code': {'key': 'properties.errorCode', 'type': 'int'},
        'error_description': {'key': 'properties.errorDescription', 'type': 'str'},
        'error_severity': {'key': 'properties.errorSeverity', 'type': 'int'},
        'is_user_error': {'key': 'properties.isUserError', 'type': 'bool'},
        'estimated_completion_time': {'key': 'properties.estimatedCompletionTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_cancellable': {'key': 'properties.isCancellable', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(DatabaseOperation, self).__init__(**kwargs)
        self.database_name = None
        self.operation = None
        self.operation_friendly_name = None
        self.percent_complete = None
        self.server_name = None
        self.start_time = None
        self.state = None
        self.error_code = None
        self.error_description = None
        self.error_severity = None
        self.is_user_error = None
        self.estimated_completion_time = None
        self.description = None
        self.is_cancellable = None


class DatabaseSecurityAlertPolicy(ProxyResource):
    """Contains information about a database Threat Detection policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: The geo-location where the resource lives
    :type location: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :param state: Required. Specifies the state of the policy. If state is
     Enabled, storageEndpoint and storageAccountAccessKey are required.
     Possible values include: 'New', 'Enabled', 'Disabled'
    :type state: str or ~azure.mgmt.sql.models.SecurityAlertPolicyState
    :param disabled_alerts: Specifies the semicolon-separated list of alerts
     that are disabled, or empty string to disable no alerts. Possible values:
     Sql_Injection; Sql_Injection_Vulnerability; Access_Anomaly;
     Data_Exfiltration; Unsafe_Action.
    :type disabled_alerts: str
    :param email_addresses: Specifies the semicolon-separated list of e-mail
     addresses to which the alert is sent.
    :type email_addresses: str
    :param email_account_admins: Specifies that the alert is sent to the
     account administrators. Possible values include: 'Enabled', 'Disabled'
    :type email_account_admins: str or
     ~azure.mgmt.sql.models.SecurityAlertPolicyEmailAccountAdmins
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all
     Threat Detection audit logs. If state is Enabled, storageEndpoint is
     required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the
     Threat Detection audit storage account. If state is Enabled,
     storageAccountAccessKey is required.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the Threat
     Detection audit logs.
    :type retention_days: int
    :param use_server_default: Specifies whether to use the default server
     policy. Possible values include: 'Enabled', 'Disabled'
    :type use_server_default: str or
     ~azure.mgmt.sql.models.SecurityAlertPolicyUseServerDefault
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'SecurityAlertPolicyState'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': 'str'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': 'str'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'SecurityAlertPolicyEmailAccountAdmins'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'use_server_default': {'key': 'properties.useServerDefault', 'type': 'SecurityAlertPolicyUseServerDefault'},
    }

    def __init__(self, **kwargs):
        super(DatabaseSecurityAlertPolicy, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.kind = None
        self.state = kwargs.get('state', None)
        self.disabled_alerts = kwargs.get('disabled_alerts', None)
        self.email_addresses = kwargs.get('email_addresses', None)
        self.email_account_admins = kwargs.get('email_account_admins', None)
        self.storage_endpoint = kwargs.get('storage_endpoint', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.retention_days = kwargs.get('retention_days', None)
        self.use_server_default = kwargs.get('use_server_default', None)


class DatabaseUpdate(Model):
    """A database resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param sku: The name and tier of the SKU.
    :type sku: ~azure.mgmt.sql.models.Sku
    :param create_mode: Specifies the mode of database creation.
     Default: regular database creation.
     Copy: creates a database as a copy of an existing database.
     sourceDatabaseId must be specified as the resource ID of the source
     database.
     Secondary: creates a database as a secondary replica of an existing
     database. sourceDatabaseId must be specified as the resource ID of the
     existing primary database.
     PointInTimeRestore: Creates a database by restoring a point in time backup
     of an existing database. sourceDatabaseId must be specified as the
     resource ID of the existing database, and restorePointInTime must be
     specified.
     Recovery: Creates a database by restoring a geo-replicated backup.
     sourceDatabaseId must be specified as the recoverable database resource ID
     to restore.
     Restore: Creates a database by restoring a backup of a deleted database.
     sourceDatabaseId must be specified. If sourceDatabaseId is the database's
     original resource ID, then sourceDatabaseDeletionDate must be specified.
     Otherwise sourceDatabaseId must be the restorable dropped database
     resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime
     may also be specified to restore from an earlier point in time.
     RestoreLongTermRetentionBackup: Creates a database by restoring from a
     long term retention vault. recoveryServicesRecoveryPointResourceId must be
     specified as the recovery point resource ID.
     Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for
     DataWarehouse edition. Possible values include: 'Default', 'Copy',
     'Secondary', 'PointInTimeRestore', 'Restore', 'Recovery',
     'RestoreExternalBackup', 'RestoreExternalBackupSecondary',
     'RestoreLongTermRetentionBackup', 'OnlineSecondary'
    :type create_mode: str or ~azure.mgmt.sql.models.CreateMode
    :param collation: The collation of the database.
    :type collation: str
    :param max_size_bytes: The max size of the database expressed in bytes.
    :type max_size_bytes: long
    :param sample_name: The name of the sample schema to apply when creating
     this database. Possible values include: 'AdventureWorksLT',
     'WideWorldImportersStd', 'WideWorldImportersFull'
    :type sample_name: str or ~azure.mgmt.sql.models.SampleName
    :param elastic_pool_id: The resource identifier of the elastic pool
     containing this database.
    :type elastic_pool_id: str
    :param source_database_id: The resource identifier of the source database
     associated with create operation of this database.
    :type source_database_id: str
    :ivar status: The status of the database. Possible values include:
     'Online', 'Restoring', 'RecoveryPending', 'Recovering', 'Suspect',
     'Offline', 'Standby', 'Shutdown', 'EmergencyMode', 'AutoClosed',
     'Copying', 'Creating', 'Inaccessible', 'OfflineSecondary', 'Pausing',
     'Paused', 'Resuming', 'Scaling', 'OfflineChangingDwPerformanceTiers',
     'OnlineChangingDwPerformanceTiers', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.DatabaseStatus
    :ivar database_id: The ID of the database.
    :vartype database_id: str
    :ivar creation_date: The creation date of the database (ISO8601 format).
    :vartype creation_date: datetime
    :ivar current_service_objective_name: The current service level objective
     name of the database.
    :vartype current_service_objective_name: str
    :ivar requested_service_objective_name: The requested service level
     objective name of the database.
    :vartype requested_service_objective_name: str
    :ivar default_secondary_location: The default secondary region for this
     database.
    :vartype default_secondary_location: str
    :ivar failover_group_id: Failover Group resource identifier that this
     database belongs to.
    :vartype failover_group_id: str
    :param restore_point_in_time: Specifies the point in time (ISO8601 format)
     of the source database that will be restored to create the new database.
    :type restore_point_in_time: datetime
    :param source_database_deletion_date: Specifies the time that the database
     was deleted.
    :type source_database_deletion_date: datetime
    :param recovery_services_recovery_point_id: The resource identifier of the
     recovery point associated with create operation of this database.
    :type recovery_services_recovery_point_id: str
    :param long_term_retention_backup_resource_id: The resource identifier of
     the long term retention backup associated with create operation of this
     database.
    :type long_term_retention_backup_resource_id: str
    :param recoverable_database_id: The resource identifier of the recoverable
     database associated with create operation of this database.
    :type recoverable_database_id: str
    :param restorable_dropped_database_id: The resource identifier of the
     restorable dropped database associated with create operation of this
     database.
    :type restorable_dropped_database_id: str
    :param catalog_collation: Collation of the metadata catalog. Possible
     values include: 'DATABASE_DEFAULT', 'SQL_Latin1_General_CP1_CI_AS'
    :type catalog_collation: str or
     ~azure.mgmt.sql.models.CatalogCollationType
    :param zone_redundant: Whether or not this database is zone redundant,
     which means the replicas of this database will be spread across multiple
     availability zones.
    :type zone_redundant: bool
    :param license_type: The license type to apply for this database.
     `LicenseIncluded` if you need a license, or `BasePrice` if you have a
     license and are eligible for the Azure Hybrid Benefit. Possible values
     include: 'LicenseIncluded', 'BasePrice'
    :type license_type: str or ~azure.mgmt.sql.models.DatabaseLicenseType
    :ivar max_log_size_bytes: The max log size for this database.
    :vartype max_log_size_bytes: long
    :ivar earliest_restore_date: This records the earliest start date and time
     that restore is available for this database (ISO8601 format).
    :vartype earliest_restore_date: datetime
    :param read_scale: The state of read-only routing. If enabled, connections
     that have application intent set to readonly in their connection string
     may be routed to a readonly secondary replica in the same region. Possible
     values include: 'Enabled', 'Disabled'
    :type read_scale: str or ~azure.mgmt.sql.models.DatabaseReadScale
    :param high_availability_replica_count: The number of secondary replicas
     associated with the database that are used to provide high availability.
    :type high_availability_replica_count: int
    :param secondary_type: The secondary type of the database if it is a
     secondary.  Valid values are Geo and Named. Possible values include:
     'Geo', 'Named'
    :type secondary_type: str or ~azure.mgmt.sql.models.SecondaryType
    :ivar current_sku: The name and tier of the SKU.
    :vartype current_sku: ~azure.mgmt.sql.models.Sku
    :param auto_pause_delay: Time in minutes after which database is
     automatically paused. A value of -1 means that automatic pause is disabled
    :type auto_pause_delay: int
    :param storage_account_type: The storage account type used to store
     backups for this database. Currently the only supported option is GRS
     (GeoRedundantStorage). Possible values include: 'GRS', 'LRS', 'ZRS'
    :type storage_account_type: str or
     ~azure.mgmt.sql.models.StorageAccountType
    :param min_capacity: Minimal capacity that database will always have
     allocated, if not paused
    :type min_capacity: float
    :ivar paused_date: The date when database was paused by user configuration
     or action(ISO8601 format). Null if the database is ready.
    :vartype paused_date: datetime
    :ivar resumed_date: The date when database was resumed by user action or
     database login (ISO8601 format). Null if the database is paused.
    :vartype resumed_date: datetime
    :param maintenance_configuration_id: Maintenance configuration id assigned
     to the database. This configuration defines the period when the
     maintenance updates will be rolled out.
    :type maintenance_configuration_id: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'status': {'readonly': True},
        'database_id': {'readonly': True},
        'creation_date': {'readonly': True},
        'current_service_objective_name': {'readonly': True},
        'requested_service_objective_name': {'readonly': True},
        'default_secondary_location': {'readonly': True},
        'failover_group_id': {'readonly': True},
        'max_log_size_bytes': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
        'current_sku': {'readonly': True},
        'paused_date': {'readonly': True},
        'resumed_date': {'readonly': True},
    }

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'long'},
        'sample_name': {'key': 'properties.sampleName', 'type': 'str'},
        'elastic_pool_id': {'key': 'properties.elasticPoolId', 'type': 'str'},
        'source_database_id': {'key': 'properties.sourceDatabaseId', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'database_id': {'key': 'properties.databaseId', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'current_service_objective_name': {'key': 'properties.currentServiceObjectiveName', 'type': 'str'},
        'requested_service_objective_name': {'key': 'properties.requestedServiceObjectiveName', 'type': 'str'},
        'default_secondary_location': {'key': 'properties.defaultSecondaryLocation', 'type': 'str'},
        'failover_group_id': {'key': 'properties.failoverGroupId', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'source_database_deletion_date': {'key': 'properties.sourceDatabaseDeletionDate', 'type': 'iso-8601'},
        'recovery_services_recovery_point_id': {'key': 'properties.recoveryServicesRecoveryPointId', 'type': 'str'},
        'long_term_retention_backup_resource_id': {'key': 'properties.longTermRetentionBackupResourceId', 'type': 'str'},
        'recoverable_database_id': {'key': 'properties.recoverableDatabaseId', 'type': 'str'},
        'restorable_dropped_database_id': {'key': 'properties.restorableDroppedDatabaseId', 'type': 'str'},
        'catalog_collation': {'key': 'properties.catalogCollation', 'type': 'str'},
        'zone_redundant': {'key': 'properties.zoneRedundant', 'type': 'bool'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'max_log_size_bytes': {'key': 'properties.maxLogSizeBytes', 'type': 'long'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
        'read_scale': {'key': 'properties.readScale', 'type': 'str'},
        'high_availability_replica_count': {'key': 'properties.highAvailabilityReplicaCount', 'type': 'int'},
        'secondary_type': {'key': 'properties.secondaryType', 'type': 'str'},
        'current_sku': {'key': 'properties.currentSku', 'type': 'Sku'},
        'auto_pause_delay': {'key': 'properties.autoPauseDelay', 'type': 'int'},
        'storage_account_type': {'key': 'properties.storageAccountType', 'type': 'str'},
        'min_capacity': {'key': 'properties.minCapacity', 'type': 'float'},
        'paused_date': {'key': 'properties.pausedDate', 'type': 'iso-8601'},
        'resumed_date': {'key': 'properties.resumedDate', 'type': 'iso-8601'},
        'maintenance_configuration_id': {'key': 'properties.maintenanceConfigurationId', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(DatabaseUpdate, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.create_mode = kwargs.get('create_mode', None)
        self.collation = kwargs.get('collation', None)
        self.max_size_bytes = kwargs.get('max_size_bytes', None)
        self.sample_name = kwargs.get('sample_name', None)
        self.elastic_pool_id = kwargs.get('elastic_pool_id', None)
        self.source_database_id = kwargs.get('source_database_id', None)
        self.status = None
        self.database_id = None
        self.creation_date = None
        self.current_service_objective_name = None
        self.requested_service_objective_name = None
        self.default_secondary_location = None
        self.failover_group_id = None
        self.restore_point_in_time = kwargs.get('restore_point_in_time', None)
        self.source_database_deletion_date = kwargs.get('source_database_deletion_date', None)
        self.recovery_services_recovery_point_id = kwargs.get('recovery_services_recovery_point_id', None)
        self.long_term_retention_backup_resource_id = kwargs.get('long_term_retention_backup_resource_id', None)
        self.recoverable_database_id = kwargs.get('recoverable_database_id', None)
        self.restorable_dropped_database_id = kwargs.get('restorable_dropped_database_id', None)
        self.catalog_collation = kwargs.get('catalog_collation', None)
        self.zone_redundant = kwargs.get('zone_redundant', None)
        self.license_type = kwargs.get('license_type', None)
        self.max_log_size_bytes = None
        self.earliest_restore_date = None
        self.read_scale = kwargs.get('read_scale', None)
        self.high_availability_replica_count = kwargs.get('high_availability_replica_count', None)
        self.secondary_type = kwargs.get('secondary_type', None)
        self.current_sku = None
        self.auto_pause_delay = kwargs.get('auto_pause_delay', None)
        self.storage_account_type = kwargs.get('storage_account_type', None)
        self.min_capacity = kwargs.get('min_capacity', None)
        self.paused_date = None
        self.resumed_date = None
        self.maintenance_configuration_id = kwargs.get('maintenance_configuration_id', None)
        self.tags = kwargs.get('tags', None)


class DatabaseUsage(Model):
    """The database usages.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the usage metric.
    :vartype name: str
    :ivar resource_name: The name of the resource.
    :vartype resource_name: str
    :ivar display_name: The usage metric display name.
    :vartype display_name: str
    :ivar current_value: The current value of the usage metric.
    :vartype current_value: float
    :ivar limit: The current limit of the usage metric.
    :vartype limit: float
    :ivar unit: The units of the usage metric.
    :vartype unit: str
    :ivar next_reset_time: The next reset time for the usage metric (ISO8601
     format).
    :vartype next_reset_time: datetime
    """

    _validation = {
        'name': {'readonly': True},
        'resource_name': {'readonly': True},
        'display_name': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'unit': {'readonly': True},
        'next_reset_time': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'limit': {'key': 'limit', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(DatabaseUsage, self).__init__(**kwargs)
        self.name = None
        self.resource_name = None
        self.display_name = None
        self.current_value = None
        self.limit = None
        self.unit = None
        self.next_reset_time = None


class DatabaseVulnerabilityAssessment(ProxyResource):
    """A database vulnerability assessment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param storage_container_path: A blob storage container path to hold the
     scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It
     is required if server level vulnerability assessment policy doesn't set
    :type storage_container_path: str
    :param storage_container_sas_key: A shared access signature (SAS Key) that
     has read and write access to the blob container specified in
     'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't
     specified, StorageContainerSasKey is required.
    :type storage_container_sas_key: str
    :param storage_account_access_key: Specifies the identifier key of the
     storage account for vulnerability assessment scan results. If
     'StorageContainerSasKey' isn't specified, storageAccountAccessKey is
     required.
    :type storage_account_access_key: str
    :param recurring_scans: The recurring scans settings
    :type recurring_scans:
     ~azure.mgmt.sql.models.VulnerabilityAssessmentRecurringScansProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'storage_container_sas_key': {'key': 'properties.storageContainerSasKey', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'recurring_scans': {'key': 'properties.recurringScans', 'type': 'VulnerabilityAssessmentRecurringScansProperties'},
    }

    def __init__(self, **kwargs):
        super(DatabaseVulnerabilityAssessment, self).__init__(**kwargs)
        self.storage_container_path = kwargs.get('storage_container_path', None)
        self.storage_container_sas_key = kwargs.get('storage_container_sas_key', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.recurring_scans = kwargs.get('recurring_scans', None)


class DatabaseVulnerabilityAssessmentRuleBaseline(ProxyResource):
    """A database vulnerability assessment rule baseline.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param baseline_results: Required. The rule baseline result
    :type baseline_results:
     list[~azure.mgmt.sql.models.DatabaseVulnerabilityAssessmentRuleBaselineItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'baseline_results': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'baseline_results': {'key': 'properties.baselineResults', 'type': '[DatabaseVulnerabilityAssessmentRuleBaselineItem]'},
    }

    def __init__(self, **kwargs):
        super(DatabaseVulnerabilityAssessmentRuleBaseline, self).__init__(**kwargs)
        self.baseline_results = kwargs.get('baseline_results', None)


class DatabaseVulnerabilityAssessmentRuleBaselineItem(Model):
    """Properties for an Azure SQL Database Vulnerability Assessment rule
    baseline's result.

    All required parameters must be populated in order to send to Azure.

    :param result: Required. The rule baseline result
    :type result: list[str]
    """

    _validation = {
        'result': {'required': True},
    }

    _attribute_map = {
        'result': {'key': 'result', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(DatabaseVulnerabilityAssessmentRuleBaselineItem, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)


class DatabaseVulnerabilityAssessmentScansExport(ProxyResource):
    """A database Vulnerability Assessment scan export resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar exported_report_location: Location of the exported report (e.g.
     https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
    :vartype exported_report_location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'exported_report_location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'exported_report_location': {'key': 'properties.exportedReportLocation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DatabaseVulnerabilityAssessmentScansExport, self).__init__(**kwargs)
        self.exported_report_location = None


class DataMaskingPolicy(ProxyResource):
    """Represents a database data masking policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param data_masking_state: Required. The state of the data masking policy.
     Possible values include: 'Disabled', 'Enabled'
    :type data_masking_state: str or ~azure.mgmt.sql.models.DataMaskingState
    :param exempt_principals: The list of the exempt principals. Specifies the
     semicolon-separated list of database users for which the data masking
     policy does not apply. The specified users receive data results without
     masking for all of the database queries.
    :type exempt_principals: str
    :ivar application_principals: The list of the application principals. This
     is a legacy parameter and is no longer used.
    :vartype application_principals: str
    :ivar masking_level: The masking level. This is a legacy parameter and is
     no longer used.
    :vartype masking_level: str
    :ivar location: The location of the data masking policy.
    :vartype location: str
    :ivar kind: The kind of data masking policy. Metadata, used for Azure
     portal.
    :vartype kind: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'data_masking_state': {'required': True},
        'application_principals': {'readonly': True},
        'masking_level': {'readonly': True},
        'location': {'readonly': True},
        'kind': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data_masking_state': {'key': 'properties.dataMaskingState', 'type': 'DataMaskingState'},
        'exempt_principals': {'key': 'properties.exemptPrincipals', 'type': 'str'},
        'application_principals': {'key': 'properties.applicationPrincipals', 'type': 'str'},
        'masking_level': {'key': 'properties.maskingLevel', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataMaskingPolicy, self).__init__(**kwargs)
        self.data_masking_state = kwargs.get('data_masking_state', None)
        self.exempt_principals = kwargs.get('exempt_principals', None)
        self.application_principals = None
        self.masking_level = None
        self.location = None
        self.kind = None


class DataMaskingRule(ProxyResource):
    """Represents a database data masking rule.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar data_masking_rule_id: The rule Id.
    :vartype data_masking_rule_id: str
    :param alias_name: The alias name. This is a legacy parameter and is no
     longer used.
    :type alias_name: str
    :param rule_state: The rule state. Used to delete a rule. To delete an
     existing rule, specify the schemaName, tableName, columnName,
     maskingFunction, and specify ruleState as disabled. However, if the rule
     doesn't already exist, the rule will be created with ruleState set to
     enabled, regardless of the provided value of ruleState. Possible values
     include: 'Disabled', 'Enabled'
    :type rule_state: str or ~azure.mgmt.sql.models.DataMaskingRuleState
    :param schema_name: Required. The schema name on which the data masking
     rule is applied.
    :type schema_name: str
    :param table_name: Required. The table name on which the data masking rule
     is applied.
    :type table_name: str
    :param column_name: Required. The column name on which the data masking
     rule is applied.
    :type column_name: str
    :param masking_function: Required. The masking function that is used for
     the data masking rule. Possible values include: 'Default', 'CCN', 'Email',
     'Number', 'SSN', 'Text'
    :type masking_function: str or ~azure.mgmt.sql.models.DataMaskingFunction
    :param number_from: The numberFrom property of the masking rule. Required
     if maskingFunction is set to Number, otherwise this parameter will be
     ignored.
    :type number_from: str
    :param number_to: The numberTo property of the data masking rule. Required
     if maskingFunction is set to Number, otherwise this parameter will be
     ignored.
    :type number_to: str
    :param prefix_size: If maskingFunction is set to Text, the number of
     characters to show unmasked in the beginning of the string. Otherwise,
     this parameter will be ignored.
    :type prefix_size: str
    :param suffix_size: If maskingFunction is set to Text, the number of
     characters to show unmasked at the end of the string. Otherwise, this
     parameter will be ignored.
    :type suffix_size: str
    :param replacement_string: If maskingFunction is set to Text, the
     character to use for masking the unexposed part of the string. Otherwise,
     this parameter will be ignored.
    :type replacement_string: str
    :ivar location: The location of the data masking rule.
    :vartype location: str
    :ivar kind: The kind of Data Masking Rule. Metadata, used for Azure
     portal.
    :vartype kind: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'data_masking_rule_id': {'readonly': True},
        'schema_name': {'required': True},
        'table_name': {'required': True},
        'column_name': {'required': True},
        'masking_function': {'required': True},
        'location': {'readonly': True},
        'kind': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data_masking_rule_id': {'key': 'properties.id', 'type': 'str'},
        'alias_name': {'key': 'properties.aliasName', 'type': 'str'},
        'rule_state': {'key': 'properties.ruleState', 'type': 'DataMaskingRuleState'},
        'schema_name': {'key': 'properties.schemaName', 'type': 'str'},
        'table_name': {'key': 'properties.tableName', 'type': 'str'},
        'column_name': {'key': 'properties.columnName', 'type': 'str'},
        'masking_function': {'key': 'properties.maskingFunction', 'type': 'DataMaskingFunction'},
        'number_from': {'key': 'properties.numberFrom', 'type': 'str'},
        'number_to': {'key': 'properties.numberTo', 'type': 'str'},
        'prefix_size': {'key': 'properties.prefixSize', 'type': 'str'},
        'suffix_size': {'key': 'properties.suffixSize', 'type': 'str'},
        'replacement_string': {'key': 'properties.replacementString', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataMaskingRule, self).__init__(**kwargs)
        self.data_masking_rule_id = None
        self.alias_name = kwargs.get('alias_name', None)
        self.rule_state = kwargs.get('rule_state', None)
        self.schema_name = kwargs.get('schema_name', None)
        self.table_name = kwargs.get('table_name', None)
        self.column_name = kwargs.get('column_name', None)
        self.masking_function = kwargs.get('masking_function', None)
        self.number_from = kwargs.get('number_from', None)
        self.number_to = kwargs.get('number_to', None)
        self.prefix_size = kwargs.get('prefix_size', None)
        self.suffix_size = kwargs.get('suffix_size', None)
        self.replacement_string = kwargs.get('replacement_string', None)
        self.location = None
        self.kind = None


class EditionCapability(Model):
    """The edition capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The database edition name.
    :vartype name: str
    :ivar supported_service_level_objectives: The list of supported service
     objectives for the edition.
    :vartype supported_service_level_objectives:
     list[~azure.mgmt.sql.models.ServiceObjectiveCapability]
    :ivar zone_redundant: Whether or not zone redundancy is supported for the
     edition.
    :vartype zone_redundant: bool
    :ivar read_scale: The read scale capability for the edition.
    :vartype read_scale: ~azure.mgmt.sql.models.ReadScaleCapability
    :ivar supported_storage_capabilities: The list of supported storage
     capabilities for this edition
    :vartype supported_storage_capabilities:
     list[~azure.mgmt.sql.models.StorageCapability]
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_service_level_objectives': {'readonly': True},
        'zone_redundant': {'readonly': True},
        'read_scale': {'readonly': True},
        'supported_storage_capabilities': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_service_level_objectives': {'key': 'supportedServiceLevelObjectives', 'type': '[ServiceObjectiveCapability]'},
        'zone_redundant': {'key': 'zoneRedundant', 'type': 'bool'},
        'read_scale': {'key': 'readScale', 'type': 'ReadScaleCapability'},
        'supported_storage_capabilities': {'key': 'supportedStorageCapabilities', 'type': '[StorageCapability]'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_service_level_objectives = None
        self.zone_redundant = None
        self.read_scale = None
        self.supported_storage_capabilities = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class ElasticPool(TrackedResource):
    """An elastic pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param sku: The elastic pool SKU.
     The list of SKUs may vary by region and support offer. To determine the
     SKUs (including the SKU name, tier/edition, family, and capacity) that are
     available to your subscription in an Azure region, use the
     `Capabilities_ListByLocation` REST API or the following command:
     ```azurecli
     az sql elastic-pool list-editions -l <location> -o table
     ````
    :type sku: ~azure.mgmt.sql.models.Sku
    :ivar kind: Kind of elastic pool. This is metadata used for the Azure
     portal experience.
    :vartype kind: str
    :ivar state: The state of the elastic pool. Possible values include:
     'Creating', 'Ready', 'Disabled'
    :vartype state: str or ~azure.mgmt.sql.models.ElasticPoolState
    :ivar creation_date: The creation date of the elastic pool (ISO8601
     format).
    :vartype creation_date: datetime
    :param max_size_bytes: The storage limit for the database elastic pool in
     bytes.
    :type max_size_bytes: long
    :param per_database_settings: The per database settings for the elastic
     pool.
    :type per_database_settings:
     ~azure.mgmt.sql.models.ElasticPoolPerDatabaseSettings
    :param zone_redundant: Whether or not this elastic pool is zone redundant,
     which means the replicas of this elastic pool will be spread across
     multiple availability zones.
    :type zone_redundant: bool
    :param license_type: The license type to apply for this elastic pool.
     Possible values include: 'LicenseIncluded', 'BasePrice'
    :type license_type: str or ~azure.mgmt.sql.models.ElasticPoolLicenseType
    :param maintenance_configuration_id: Maintenance configuration id assigned
     to the elastic pool. This configuration defines the period when the
     maintenance updates will be rolled out.
    :type maintenance_configuration_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'readonly': True},
        'state': {'readonly': True},
        'creation_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'kind': {'key': 'kind', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'long'},
        'per_database_settings': {'key': 'properties.perDatabaseSettings', 'type': 'ElasticPoolPerDatabaseSettings'},
        'zone_redundant': {'key': 'properties.zoneRedundant', 'type': 'bool'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'maintenance_configuration_id': {'key': 'properties.maintenanceConfigurationId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ElasticPool, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.kind = None
        self.state = None
        self.creation_date = None
        self.max_size_bytes = kwargs.get('max_size_bytes', None)
        self.per_database_settings = kwargs.get('per_database_settings', None)
        self.zone_redundant = kwargs.get('zone_redundant', None)
        self.license_type = kwargs.get('license_type', None)
        self.maintenance_configuration_id = kwargs.get('maintenance_configuration_id', None)


class ElasticPoolActivity(ProxyResource):
    """Represents the activity on an elastic pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: The geo-location where the resource lives
    :type location: str
    :ivar end_time: The time the operation finished (ISO8601 format).
    :vartype end_time: datetime
    :ivar error_code: The error code if available.
    :vartype error_code: int
    :ivar error_message: The error message if available.
    :vartype error_message: str
    :ivar error_severity: The error severity if available.
    :vartype error_severity: int
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar operation_id: The unique operation ID.
    :vartype operation_id: str
    :ivar percent_complete: The percentage complete if available.
    :vartype percent_complete: int
    :ivar requested_database_dtu_max: The requested max DTU per database if
     available.
    :vartype requested_database_dtu_max: int
    :ivar requested_database_dtu_min: The requested min DTU per database if
     available.
    :vartype requested_database_dtu_min: int
    :ivar requested_dtu: The requested DTU for the pool if available.
    :vartype requested_dtu: int
    :ivar requested_elastic_pool_name: The requested name for the elastic pool
     if available.
    :vartype requested_elastic_pool_name: str
    :ivar requested_storage_limit_in_gb: The requested storage limit for the
     pool in GB if available.
    :vartype requested_storage_limit_in_gb: long
    :ivar elastic_pool_name: The name of the elastic pool.
    :vartype elastic_pool_name: str
    :ivar server_name: The name of the server the elastic pool is in.
    :vartype server_name: str
    :ivar start_time: The time the operation started (ISO8601 format).
    :vartype start_time: datetime
    :ivar state: The current state of the operation.
    :vartype state: str
    :ivar requested_storage_limit_in_mb: The requested storage limit in MB.
    :vartype requested_storage_limit_in_mb: int
    :ivar requested_database_dtu_guarantee: The requested per database DTU
     guarantee.
    :vartype requested_database_dtu_guarantee: int
    :ivar requested_database_dtu_cap: The requested per database DTU cap.
    :vartype requested_database_dtu_cap: int
    :ivar requested_dtu_guarantee: The requested DTU guarantee.
    :vartype requested_dtu_guarantee: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'end_time': {'readonly': True},
        'error_code': {'readonly': True},
        'error_message': {'readonly': True},
        'error_severity': {'readonly': True},
        'operation': {'readonly': True},
        'operation_id': {'readonly': True},
        'percent_complete': {'readonly': True},
        'requested_database_dtu_max': {'readonly': True},
        'requested_database_dtu_min': {'readonly': True},
        'requested_dtu': {'readonly': True},
        'requested_elastic_pool_name': {'readonly': True},
        'requested_storage_limit_in_gb': {'readonly': True},
        'elastic_pool_name': {'readonly': True},
        'server_name': {'readonly': True},
        'start_time': {'readonly': True},
        'state': {'readonly': True},
        'requested_storage_limit_in_mb': {'readonly': True},
        'requested_database_dtu_guarantee': {'readonly': True},
        'requested_database_dtu_cap': {'readonly': True},
        'requested_dtu_guarantee': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'error_code': {'key': 'properties.errorCode', 'type': 'int'},
        'error_message': {'key': 'properties.errorMessage', 'type': 'str'},
        'error_severity': {'key': 'properties.errorSeverity', 'type': 'int'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'requested_database_dtu_max': {'key': 'properties.requestedDatabaseDtuMax', 'type': 'int'},
        'requested_database_dtu_min': {'key': 'properties.requestedDatabaseDtuMin', 'type': 'int'},
        'requested_dtu': {'key': 'properties.requestedDtu', 'type': 'int'},
        'requested_elastic_pool_name': {'key': 'properties.requestedElasticPoolName', 'type': 'str'},
        'requested_storage_limit_in_gb': {'key': 'properties.requestedStorageLimitInGB', 'type': 'long'},
        'elastic_pool_name': {'key': 'properties.elasticPoolName', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'requested_storage_limit_in_mb': {'key': 'properties.requestedStorageLimitInMB', 'type': 'int'},
        'requested_database_dtu_guarantee': {'key': 'properties.requestedDatabaseDtuGuarantee', 'type': 'int'},
        'requested_database_dtu_cap': {'key': 'properties.requestedDatabaseDtuCap', 'type': 'int'},
        'requested_dtu_guarantee': {'key': 'properties.requestedDtuGuarantee', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ElasticPoolActivity, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.end_time = None
        self.error_code = None
        self.error_message = None
        self.error_severity = None
        self.operation = None
        self.operation_id = None
        self.percent_complete = None
        self.requested_database_dtu_max = None
        self.requested_database_dtu_min = None
        self.requested_dtu = None
        self.requested_elastic_pool_name = None
        self.requested_storage_limit_in_gb = None
        self.elastic_pool_name = None
        self.server_name = None
        self.start_time = None
        self.state = None
        self.requested_storage_limit_in_mb = None
        self.requested_database_dtu_guarantee = None
        self.requested_database_dtu_cap = None
        self.requested_dtu_guarantee = None


class ElasticPoolDatabaseActivity(ProxyResource):
    """Represents the activity on an elastic pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: The geo-location where the resource lives
    :type location: str
    :ivar database_name: The database name.
    :vartype database_name: str
    :ivar end_time: The time the operation finished (ISO8601 format).
    :vartype end_time: datetime
    :ivar error_code: The error code if available.
    :vartype error_code: int
    :ivar error_message: The error message if available.
    :vartype error_message: str
    :ivar error_severity: The error severity if available.
    :vartype error_severity: int
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar operation_id: The unique operation ID.
    :vartype operation_id: str
    :ivar percent_complete: The percentage complete if available.
    :vartype percent_complete: int
    :ivar requested_elastic_pool_name: The name for the elastic pool the
     database is moving into if available.
    :vartype requested_elastic_pool_name: str
    :ivar current_elastic_pool_name: The name of the current elastic pool the
     database is in if available.
    :vartype current_elastic_pool_name: str
    :ivar current_service_objective: The name of the current service objective
     if available.
    :vartype current_service_objective: str
    :ivar requested_service_objective: The name of the requested service
     objective if available.
    :vartype requested_service_objective: str
    :ivar server_name: The name of the server the elastic pool is in.
    :vartype server_name: str
    :ivar start_time: The time the operation started (ISO8601 format).
    :vartype start_time: datetime
    :ivar state: The current state of the operation.
    :vartype state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'database_name': {'readonly': True},
        'end_time': {'readonly': True},
        'error_code': {'readonly': True},
        'error_message': {'readonly': True},
        'error_severity': {'readonly': True},
        'operation': {'readonly': True},
        'operation_id': {'readonly': True},
        'percent_complete': {'readonly': True},
        'requested_elastic_pool_name': {'readonly': True},
        'current_elastic_pool_name': {'readonly': True},
        'current_service_objective': {'readonly': True},
        'requested_service_objective': {'readonly': True},
        'server_name': {'readonly': True},
        'start_time': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'error_code': {'key': 'properties.errorCode', 'type': 'int'},
        'error_message': {'key': 'properties.errorMessage', 'type': 'str'},
        'error_severity': {'key': 'properties.errorSeverity', 'type': 'int'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'requested_elastic_pool_name': {'key': 'properties.requestedElasticPoolName', 'type': 'str'},
        'current_elastic_pool_name': {'key': 'properties.currentElasticPoolName', 'type': 'str'},
        'current_service_objective': {'key': 'properties.currentServiceObjective', 'type': 'str'},
        'requested_service_objective': {'key': 'properties.requestedServiceObjective', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ElasticPoolDatabaseActivity, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.database_name = None
        self.end_time = None
        self.error_code = None
        self.error_message = None
        self.error_severity = None
        self.operation = None
        self.operation_id = None
        self.percent_complete = None
        self.requested_elastic_pool_name = None
        self.current_elastic_pool_name = None
        self.current_service_objective = None
        self.requested_service_objective = None
        self.server_name = None
        self.start_time = None
        self.state = None


class ElasticPoolEditionCapability(Model):
    """The elastic pool edition capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The elastic pool edition name.
    :vartype name: str
    :ivar supported_elastic_pool_performance_levels: The list of supported
     elastic pool DTU levels for the edition.
    :vartype supported_elastic_pool_performance_levels:
     list[~azure.mgmt.sql.models.ElasticPoolPerformanceLevelCapability]
    :ivar zone_redundant: Whether or not zone redundancy is supported for the
     edition.
    :vartype zone_redundant: bool
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_elastic_pool_performance_levels': {'readonly': True},
        'zone_redundant': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_elastic_pool_performance_levels': {'key': 'supportedElasticPoolPerformanceLevels', 'type': '[ElasticPoolPerformanceLevelCapability]'},
        'zone_redundant': {'key': 'zoneRedundant', 'type': 'bool'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ElasticPoolEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_elastic_pool_performance_levels = None
        self.zone_redundant = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class ElasticPoolOperation(ProxyResource):
    """A elastic pool operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar elastic_pool_name: The name of the elastic pool the operation is
     being performed on.
    :vartype elastic_pool_name: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar percent_complete: The percentage of the operation completed.
    :vartype percent_complete: int
    :ivar server_name: The name of the server.
    :vartype server_name: str
    :ivar start_time: The operation start time.
    :vartype start_time: datetime
    :ivar state: The operation state.
    :vartype state: str
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar is_user_error: Whether or not the error is a user error.
    :vartype is_user_error: bool
    :ivar estimated_completion_time: The estimated completion time of the
     operation.
    :vartype estimated_completion_time: datetime
    :ivar description: The operation description.
    :vartype description: str
    :ivar is_cancellable: Whether the operation can be cancelled.
    :vartype is_cancellable: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'elastic_pool_name': {'readonly': True},
        'operation': {'readonly': True},
        'operation_friendly_name': {'readonly': True},
        'percent_complete': {'readonly': True},
        'server_name': {'readonly': True},
        'start_time': {'readonly': True},
        'state': {'readonly': True},
        'error_code': {'readonly': True},
        'error_description': {'readonly': True},
        'error_severity': {'readonly': True},
        'is_user_error': {'readonly': True},
        'estimated_completion_time': {'readonly': True},
        'description': {'readonly': True},
        'is_cancellable': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'elastic_pool_name': {'key': 'properties.elasticPoolName', 'type': 'str'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'operation_friendly_name': {'key': 'properties.operationFriendlyName', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'error_code': {'key': 'properties.errorCode', 'type': 'int'},
        'error_description': {'key': 'properties.errorDescription', 'type': 'str'},
        'error_severity': {'key': 'properties.errorSeverity', 'type': 'int'},
        'is_user_error': {'key': 'properties.isUserError', 'type': 'bool'},
        'estimated_completion_time': {'key': 'properties.estimatedCompletionTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_cancellable': {'key': 'properties.isCancellable', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ElasticPoolOperation, self).__init__(**kwargs)
        self.elastic_pool_name = None
        self.operation = None
        self.operation_friendly_name = None
        self.percent_complete = None
        self.server_name = None
        self.start_time = None
        self.state = None
        self.error_code = None
        self.error_description = None
        self.error_severity = None
        self.is_user_error = None
        self.estimated_completion_time = None
        self.description = None
        self.is_cancellable = None


class ElasticPoolPerDatabaseMaxPerformanceLevelCapability(Model):
    """The max per-database performance level capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar limit: The maximum performance level per database.
    :vartype limit: float
    :ivar unit: Unit type used to measure performance level. Possible values
     include: 'DTU', 'VCores'
    :vartype unit: str or ~azure.mgmt.sql.models.PerformanceLevelUnit
    :ivar supported_per_database_min_performance_levels: The list of supported
     min database performance levels.
    :vartype supported_per_database_min_performance_levels:
     list[~azure.mgmt.sql.models.ElasticPoolPerDatabaseMinPerformanceLevelCapability]
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'limit': {'readonly': True},
        'unit': {'readonly': True},
        'supported_per_database_min_performance_levels': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'supported_per_database_min_performance_levels': {'key': 'supportedPerDatabaseMinPerformanceLevels', 'type': '[ElasticPoolPerDatabaseMinPerformanceLevelCapability]'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ElasticPoolPerDatabaseMaxPerformanceLevelCapability, self).__init__(**kwargs)
        self.limit = None
        self.unit = None
        self.supported_per_database_min_performance_levels = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class ElasticPoolPerDatabaseMinPerformanceLevelCapability(Model):
    """The minimum per-database performance level capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar limit: The minimum performance level per database.
    :vartype limit: float
    :ivar unit: Unit type used to measure performance level. Possible values
     include: 'DTU', 'VCores'
    :vartype unit: str or ~azure.mgmt.sql.models.PerformanceLevelUnit
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'limit': {'readonly': True},
        'unit': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ElasticPoolPerDatabaseMinPerformanceLevelCapability, self).__init__(**kwargs)
        self.limit = None
        self.unit = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class ElasticPoolPerDatabaseSettings(Model):
    """Per database settings of an elastic pool.

    :param min_capacity: The minimum capacity all databases are guaranteed.
    :type min_capacity: float
    :param max_capacity: The maximum capacity any one database can consume.
    :type max_capacity: float
    """

    _attribute_map = {
        'min_capacity': {'key': 'minCapacity', 'type': 'float'},
        'max_capacity': {'key': 'maxCapacity', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ElasticPoolPerDatabaseSettings, self).__init__(**kwargs)
        self.min_capacity = kwargs.get('min_capacity', None)
        self.max_capacity = kwargs.get('max_capacity', None)


class ElasticPoolPerformanceLevelCapability(Model):
    """The Elastic Pool performance level capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar performance_level: The performance level for the pool.
    :vartype performance_level:
     ~azure.mgmt.sql.models.PerformanceLevelCapability
    :ivar sku: The sku.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar supported_license_types: List of supported license types.
    :vartype supported_license_types:
     list[~azure.mgmt.sql.models.LicenseTypeCapability]
    :ivar max_database_count: The maximum number of databases supported.
    :vartype max_database_count: int
    :ivar included_max_size: The included (free) max size for this performance
     level.
    :vartype included_max_size: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar supported_max_sizes: The list of supported max sizes.
    :vartype supported_max_sizes:
     list[~azure.mgmt.sql.models.MaxSizeRangeCapability]
    :ivar supported_per_database_max_sizes: The list of supported per database
     max sizes.
    :vartype supported_per_database_max_sizes:
     list[~azure.mgmt.sql.models.MaxSizeRangeCapability]
    :ivar supported_per_database_max_performance_levels: The list of supported
     per database max performance levels.
    :vartype supported_per_database_max_performance_levels:
     list[~azure.mgmt.sql.models.ElasticPoolPerDatabaseMaxPerformanceLevelCapability]
    :ivar zone_redundant: Whether or not zone redundancy is supported for the
     performance level.
    :vartype zone_redundant: bool
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'performance_level': {'readonly': True},
        'sku': {'readonly': True},
        'supported_license_types': {'readonly': True},
        'max_database_count': {'readonly': True},
        'included_max_size': {'readonly': True},
        'supported_max_sizes': {'readonly': True},
        'supported_per_database_max_sizes': {'readonly': True},
        'supported_per_database_max_performance_levels': {'readonly': True},
        'zone_redundant': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'performance_level': {'key': 'performanceLevel', 'type': 'PerformanceLevelCapability'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'supported_license_types': {'key': 'supportedLicenseTypes', 'type': '[LicenseTypeCapability]'},
        'max_database_count': {'key': 'maxDatabaseCount', 'type': 'int'},
        'included_max_size': {'key': 'includedMaxSize', 'type': 'MaxSizeCapability'},
        'supported_max_sizes': {'key': 'supportedMaxSizes', 'type': '[MaxSizeRangeCapability]'},
        'supported_per_database_max_sizes': {'key': 'supportedPerDatabaseMaxSizes', 'type': '[MaxSizeRangeCapability]'},
        'supported_per_database_max_performance_levels': {'key': 'supportedPerDatabaseMaxPerformanceLevels', 'type': '[ElasticPoolPerDatabaseMaxPerformanceLevelCapability]'},
        'zone_redundant': {'key': 'zoneRedundant', 'type': 'bool'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ElasticPoolPerformanceLevelCapability, self).__init__(**kwargs)
        self.performance_level = None
        self.sku = None
        self.supported_license_types = None
        self.max_database_count = None
        self.included_max_size = None
        self.supported_max_sizes = None
        self.supported_per_database_max_sizes = None
        self.supported_per_database_max_performance_levels = None
        self.zone_redundant = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class ElasticPoolUpdate(Model):
    """An elastic pool update.

    :param sku:
    :type sku: ~azure.mgmt.sql.models.Sku
    :param max_size_bytes: The storage limit for the database elastic pool in
     bytes.
    :type max_size_bytes: long
    :param per_database_settings: The per database settings for the elastic
     pool.
    :type per_database_settings:
     ~azure.mgmt.sql.models.ElasticPoolPerDatabaseSettings
    :param zone_redundant: Whether or not this elastic pool is zone redundant,
     which means the replicas of this elastic pool will be spread across
     multiple availability zones.
    :type zone_redundant: bool
    :param license_type: The license type to apply for this elastic pool.
     Possible values include: 'LicenseIncluded', 'BasePrice'
    :type license_type: str or ~azure.mgmt.sql.models.ElasticPoolLicenseType
    :param maintenance_configuration_id: Maintenance configuration id assigned
     to the elastic pool. This configuration defines the period when the
     maintenance updates will be rolled out.
    :type maintenance_configuration_id: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'long'},
        'per_database_settings': {'key': 'properties.perDatabaseSettings', 'type': 'ElasticPoolPerDatabaseSettings'},
        'zone_redundant': {'key': 'properties.zoneRedundant', 'type': 'bool'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'maintenance_configuration_id': {'key': 'properties.maintenanceConfigurationId', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(ElasticPoolUpdate, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.max_size_bytes = kwargs.get('max_size_bytes', None)
        self.per_database_settings = kwargs.get('per_database_settings', None)
        self.zone_redundant = kwargs.get('zone_redundant', None)
        self.license_type = kwargs.get('license_type', None)
        self.maintenance_configuration_id = kwargs.get('maintenance_configuration_id', None)
        self.tags = kwargs.get('tags', None)


class EncryptionProtector(ProxyResource):
    """The server encryption protector.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Kind of encryption protector. This is metadata used for the
     Azure portal experience.
    :vartype kind: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar subregion: Subregion of the encryption protector.
    :vartype subregion: str
    :param server_key_name: The name of the server key.
    :type server_key_name: str
    :param server_key_type: Required. The encryption protector type like
     'ServiceManaged', 'AzureKeyVault'. Possible values include:
     'ServiceManaged', 'AzureKeyVault'
    :type server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
    :ivar uri: The URI of the server key.
    :vartype uri: str
    :ivar thumbprint: Thumbprint of the server key.
    :vartype thumbprint: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
        'subregion': {'readonly': True},
        'server_key_type': {'required': True},
        'uri': {'readonly': True},
        'thumbprint': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'subregion': {'key': 'properties.subregion', 'type': 'str'},
        'server_key_name': {'key': 'properties.serverKeyName', 'type': 'str'},
        'server_key_type': {'key': 'properties.serverKeyType', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EncryptionProtector, self).__init__(**kwargs)
        self.kind = None
        self.location = None
        self.subregion = None
        self.server_key_name = kwargs.get('server_key_name', None)
        self.server_key_type = kwargs.get('server_key_type', None)
        self.uri = None
        self.thumbprint = None


class ExportDatabaseDefinition(Model):
    """Contains the information necessary to perform export database operation.

    All required parameters must be populated in order to send to Azure.

    :param storage_key_type: Required. Storage key type. Possible values
     include: 'SharedAccessKey', 'StorageAccessKey'
    :type storage_key_type: str or ~azure.mgmt.sql.models.StorageKeyType
    :param storage_key: Required. Storage key.
    :type storage_key: str
    :param storage_uri: Required. Storage Uri.
    :type storage_uri: str
    :param administrator_login: Required. Administrator login name.
    :type administrator_login: str
    :param administrator_login_password: Required. Administrator login
     password.
    :type administrator_login_password: str
    :param authentication_type: Authentication type.
    :type authentication_type: str
    :param network_isolation: Optional resource information to enable network
     isolation for request.
    :type network_isolation: ~azure.mgmt.sql.models.NetworkIsolationSettings
    """

    _validation = {
        'storage_key_type': {'required': True},
        'storage_key': {'required': True},
        'storage_uri': {'required': True},
        'administrator_login': {'required': True},
        'administrator_login_password': {'required': True},
    }

    _attribute_map = {
        'storage_key_type': {'key': 'storageKeyType', 'type': 'str'},
        'storage_key': {'key': 'storageKey', 'type': 'str'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
        'administrator_login': {'key': 'administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'administratorLoginPassword', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'network_isolation': {'key': 'networkIsolation', 'type': 'NetworkIsolationSettings'},
    }

    def __init__(self, **kwargs):
        super(ExportDatabaseDefinition, self).__init__(**kwargs)
        self.storage_key_type = kwargs.get('storage_key_type', None)
        self.storage_key = kwargs.get('storage_key', None)
        self.storage_uri = kwargs.get('storage_uri', None)
        self.administrator_login = kwargs.get('administrator_login', None)
        self.administrator_login_password = kwargs.get('administrator_login_password', None)
        self.authentication_type = kwargs.get('authentication_type', None)
        self.network_isolation = kwargs.get('network_isolation', None)


class ExtendedDatabaseBlobAuditingPolicy(ProxyResource):
    """An extended database blob auditing policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param predicate_expression: Specifies condition of where clause when
     creating an audit.
    :type predicate_expression: str
    :param state: Required. Specifies the state of the policy. If state is
     Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
     Possible values include: 'Enabled', 'Disabled'
    :type state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled,
     storageEndpoint or isAzureMonitorTargetEnabled is required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the
     auditing storage account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed
     identity to access the storage.
     Prerequisites for using managed identity authentication:
     1. Assign SQL Server a system-assigned managed identity in Azure Active
     Directory (AAD).
     2. Grant SQL Server identity access to the storage account by adding
     'Storage Blob Data Contributor' RBAC role to the server identity.
     For more information, see [Auditing to storage using Managed Identity
     authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the audit
     logs in the storage account.
    :type retention_days: int
    :param audit_actions_and_groups: Specifies the Actions-Groups and Actions
     to audit.
     The recommended set of action groups to use is the following combination -
     this will audit all the queries and stored procedures executed against the
     database, as well as successful and failed logins:
     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.
     This above combination is also the set that is configured by default when
     enabling auditing from the Azure portal.
     The supported action groups to audit are (note: choose only specific
     groups that cover your auditing needs. Using unnecessary groups could lead
     to very large quantities of audit records):
     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
     These are groups that cover all sql statements and stored procedures
     executed against the database, and should not be used in combination with
     other groups as this will result in duplicate audit logs.
     For more information, see [Database-Level Audit Action
     Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
     For Database auditing policy, specific Actions can also be specified (note
     that Actions cannot be specified for Server auditing policy). The
     supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES
     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}
     Note that <object> in the above format can refer to an object like a
     table, view, or stored procedure, or an entire database or schema. For the
     latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are
     used, respectively.
     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public
     For more information, see [Database-Level Audit
     Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
    :type audit_actions_and_groups: list[str]
    :param storage_account_subscription_id: Specifies the blob storage
     subscription Id.
    :type storage_account_subscription_id: str
    :param is_storage_secondary_key_in_use: Specifies whether
     storageAccountAccessKey value is the storage's secondary key.
    :type is_storage_secondary_key_in_use: bool
    :param is_azure_monitor_target_enabled: Specifies whether audit events are
     sent to Azure Monitor.
     In order to send the events to Azure Monitor, specify 'state' as 'Enabled'
     and 'isAzureMonitorTargetEnabled' as true.
     When using REST API to configure auditing, Diagnostic Settings with
     'SQLSecurityAuditEvents' diagnostic logs category on the database should
     be also created.
     Note that for server level audit you should use the 'master' database as
     {databaseName}.
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
     For more information, see [Diagnostic Settings REST
     API](https://go.microsoft.com/fwlink/?linkid=2033207)
     or [Diagnostic Settings
     PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
    :type is_azure_monitor_target_enabled: bool
    :param queue_delay_ms: Specifies the amount of time in milliseconds that
     can elapse before audit actions are forced to be processed.
     The default minimum value is 1000 (1 second). The maximum is
     2,147,483,647.
    :type queue_delay_ms: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'predicate_expression': {'key': 'properties.predicateExpression', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'BlobAuditingPolicyState'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'audit_actions_and_groups': {'key': 'properties.auditActionsAndGroups', 'type': '[str]'},
        'storage_account_subscription_id': {'key': 'properties.storageAccountSubscriptionId', 'type': 'str'},
        'is_storage_secondary_key_in_use': {'key': 'properties.isStorageSecondaryKeyInUse', 'type': 'bool'},
        'is_azure_monitor_target_enabled': {'key': 'properties.isAzureMonitorTargetEnabled', 'type': 'bool'},
        'queue_delay_ms': {'key': 'properties.queueDelayMs', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ExtendedDatabaseBlobAuditingPolicy, self).__init__(**kwargs)
        self.predicate_expression = kwargs.get('predicate_expression', None)
        self.state = kwargs.get('state', None)
        self.storage_endpoint = kwargs.get('storage_endpoint', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.retention_days = kwargs.get('retention_days', None)
        self.audit_actions_and_groups = kwargs.get('audit_actions_and_groups', None)
        self.storage_account_subscription_id = kwargs.get('storage_account_subscription_id', None)
        self.is_storage_secondary_key_in_use = kwargs.get('is_storage_secondary_key_in_use', None)
        self.is_azure_monitor_target_enabled = kwargs.get('is_azure_monitor_target_enabled', None)
        self.queue_delay_ms = kwargs.get('queue_delay_ms', None)


class ExtendedServerBlobAuditingPolicy(ProxyResource):
    """An extended server blob auditing policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param predicate_expression: Specifies condition of where clause when
     creating an audit.
    :type predicate_expression: str
    :param state: Required. Specifies the state of the policy. If state is
     Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
     Possible values include: 'Enabled', 'Disabled'
    :type state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled,
     storageEndpoint or isAzureMonitorTargetEnabled is required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the
     auditing storage account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed
     identity to access the storage.
     Prerequisites for using managed identity authentication:
     1. Assign SQL Server a system-assigned managed identity in Azure Active
     Directory (AAD).
     2. Grant SQL Server identity access to the storage account by adding
     'Storage Blob Data Contributor' RBAC role to the server identity.
     For more information, see [Auditing to storage using Managed Identity
     authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the audit
     logs in the storage account.
    :type retention_days: int
    :param audit_actions_and_groups: Specifies the Actions-Groups and Actions
     to audit.
     The recommended set of action groups to use is the following combination -
     this will audit all the queries and stored procedures executed against the
     database, as well as successful and failed logins:
     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.
     This above combination is also the set that is configured by default when
     enabling auditing from the Azure portal.
     The supported action groups to audit are (note: choose only specific
     groups that cover your auditing needs. Using unnecessary groups could lead
     to very large quantities of audit records):
     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
     These are groups that cover all sql statements and stored procedures
     executed against the database, and should not be used in combination with
     other groups as this will result in duplicate audit logs.
     For more information, see [Database-Level Audit Action
     Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
     For Database auditing policy, specific Actions can also be specified (note
     that Actions cannot be specified for Server auditing policy). The
     supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES
     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}
     Note that <object> in the above format can refer to an object like a
     table, view, or stored procedure, or an entire database or schema. For the
     latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are
     used, respectively.
     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public
     For more information, see [Database-Level Audit
     Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
    :type audit_actions_and_groups: list[str]
    :param storage_account_subscription_id: Specifies the blob storage
     subscription Id.
    :type storage_account_subscription_id: str
    :param is_storage_secondary_key_in_use: Specifies whether
     storageAccountAccessKey value is the storage's secondary key.
    :type is_storage_secondary_key_in_use: bool
    :param is_azure_monitor_target_enabled: Specifies whether audit events are
     sent to Azure Monitor.
     In order to send the events to Azure Monitor, specify 'state' as 'Enabled'
     and 'isAzureMonitorTargetEnabled' as true.
     When using REST API to configure auditing, Diagnostic Settings with
     'SQLSecurityAuditEvents' diagnostic logs category on the database should
     be also created.
     Note that for server level audit you should use the 'master' database as
     {databaseName}.
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
     For more information, see [Diagnostic Settings REST
     API](https://go.microsoft.com/fwlink/?linkid=2033207)
     or [Diagnostic Settings
     PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
    :type is_azure_monitor_target_enabled: bool
    :param queue_delay_ms: Specifies the amount of time in milliseconds that
     can elapse before audit actions are forced to be processed.
     The default minimum value is 1000 (1 second). The maximum is
     2,147,483,647.
    :type queue_delay_ms: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'predicate_expression': {'key': 'properties.predicateExpression', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'BlobAuditingPolicyState'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'audit_actions_and_groups': {'key': 'properties.auditActionsAndGroups', 'type': '[str]'},
        'storage_account_subscription_id': {'key': 'properties.storageAccountSubscriptionId', 'type': 'str'},
        'is_storage_secondary_key_in_use': {'key': 'properties.isStorageSecondaryKeyInUse', 'type': 'bool'},
        'is_azure_monitor_target_enabled': {'key': 'properties.isAzureMonitorTargetEnabled', 'type': 'bool'},
        'queue_delay_ms': {'key': 'properties.queueDelayMs', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ExtendedServerBlobAuditingPolicy, self).__init__(**kwargs)
        self.predicate_expression = kwargs.get('predicate_expression', None)
        self.state = kwargs.get('state', None)
        self.storage_endpoint = kwargs.get('storage_endpoint', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.retention_days = kwargs.get('retention_days', None)
        self.audit_actions_and_groups = kwargs.get('audit_actions_and_groups', None)
        self.storage_account_subscription_id = kwargs.get('storage_account_subscription_id', None)
        self.is_storage_secondary_key_in_use = kwargs.get('is_storage_secondary_key_in_use', None)
        self.is_azure_monitor_target_enabled = kwargs.get('is_azure_monitor_target_enabled', None)
        self.queue_delay_ms = kwargs.get('queue_delay_ms', None)


class FailoverGroup(ProxyResource):
    """A failover group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param read_write_endpoint: Required. Read-write endpoint of the failover
     group instance.
    :type read_write_endpoint:
     ~azure.mgmt.sql.models.FailoverGroupReadWriteEndpoint
    :param read_only_endpoint: Read-only endpoint of the failover group
     instance.
    :type read_only_endpoint:
     ~azure.mgmt.sql.models.FailoverGroupReadOnlyEndpoint
    :ivar replication_role: Local replication role of the failover group
     instance. Possible values include: 'Primary', 'Secondary'
    :vartype replication_role: str or
     ~azure.mgmt.sql.models.FailoverGroupReplicationRole
    :ivar replication_state: Replication state of the failover group instance.
    :vartype replication_state: str
    :param partner_servers: Required. List of partner server information for
     the failover group.
    :type partner_servers: list[~azure.mgmt.sql.models.PartnerInfo]
    :param databases: List of databases in the failover group.
    :type databases: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'read_write_endpoint': {'required': True},
        'replication_role': {'readonly': True},
        'replication_state': {'readonly': True},
        'partner_servers': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'read_write_endpoint': {'key': 'properties.readWriteEndpoint', 'type': 'FailoverGroupReadWriteEndpoint'},
        'read_only_endpoint': {'key': 'properties.readOnlyEndpoint', 'type': 'FailoverGroupReadOnlyEndpoint'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
        'replication_state': {'key': 'properties.replicationState', 'type': 'str'},
        'partner_servers': {'key': 'properties.partnerServers', 'type': '[PartnerInfo]'},
        'databases': {'key': 'properties.databases', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(FailoverGroup, self).__init__(**kwargs)
        self.location = None
        self.tags = kwargs.get('tags', None)
        self.read_write_endpoint = kwargs.get('read_write_endpoint', None)
        self.read_only_endpoint = kwargs.get('read_only_endpoint', None)
        self.replication_role = None
        self.replication_state = None
        self.partner_servers = kwargs.get('partner_servers', None)
        self.databases = kwargs.get('databases', None)


class FailoverGroupReadOnlyEndpoint(Model):
    """Read-only endpoint of the failover group instance.

    :param failover_policy: Failover policy of the read-only endpoint for the
     failover group. Possible values include: 'Disabled', 'Enabled'
    :type failover_policy: str or
     ~azure.mgmt.sql.models.ReadOnlyEndpointFailoverPolicy
    """

    _attribute_map = {
        'failover_policy': {'key': 'failoverPolicy', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FailoverGroupReadOnlyEndpoint, self).__init__(**kwargs)
        self.failover_policy = kwargs.get('failover_policy', None)


class FailoverGroupReadWriteEndpoint(Model):
    """Read-write endpoint of the failover group instance.

    All required parameters must be populated in order to send to Azure.

    :param failover_policy: Required. Failover policy of the read-write
     endpoint for the failover group. If failoverPolicy is Automatic then
     failoverWithDataLossGracePeriodMinutes is required. Possible values
     include: 'Manual', 'Automatic'
    :type failover_policy: str or
     ~azure.mgmt.sql.models.ReadWriteEndpointFailoverPolicy
    :param failover_with_data_loss_grace_period_minutes: Grace period before
     failover with data loss is attempted for the read-write endpoint. If
     failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is
     required.
    :type failover_with_data_loss_grace_period_minutes: int
    """

    _validation = {
        'failover_policy': {'required': True},
    }

    _attribute_map = {
        'failover_policy': {'key': 'failoverPolicy', 'type': 'str'},
        'failover_with_data_loss_grace_period_minutes': {'key': 'failoverWithDataLossGracePeriodMinutes', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(FailoverGroupReadWriteEndpoint, self).__init__(**kwargs)
        self.failover_policy = kwargs.get('failover_policy', None)
        self.failover_with_data_loss_grace_period_minutes = kwargs.get('failover_with_data_loss_grace_period_minutes', None)


class FailoverGroupUpdate(Model):
    """A failover group update request.

    :param read_write_endpoint: Read-write endpoint of the failover group
     instance.
    :type read_write_endpoint:
     ~azure.mgmt.sql.models.FailoverGroupReadWriteEndpoint
    :param read_only_endpoint: Read-only endpoint of the failover group
     instance.
    :type read_only_endpoint:
     ~azure.mgmt.sql.models.FailoverGroupReadOnlyEndpoint
    :param databases: List of databases in the failover group.
    :type databases: list[str]
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'read_write_endpoint': {'key': 'properties.readWriteEndpoint', 'type': 'FailoverGroupReadWriteEndpoint'},
        'read_only_endpoint': {'key': 'properties.readOnlyEndpoint', 'type': 'FailoverGroupReadOnlyEndpoint'},
        'databases': {'key': 'properties.databases', 'type': '[str]'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(FailoverGroupUpdate, self).__init__(**kwargs)
        self.read_write_endpoint = kwargs.get('read_write_endpoint', None)
        self.read_only_endpoint = kwargs.get('read_only_endpoint', None)
        self.databases = kwargs.get('databases', None)
        self.tags = kwargs.get('tags', None)


class FirewallRule(ProxyResource):
    """Represents a server firewall rule.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Kind of server that contains this firewall rule.
    :vartype kind: str
    :ivar location: Location of the server that contains this firewall rule.
    :vartype location: str
    :param start_ip_address: Required. The start IP address of the firewall
     rule. Must be IPv4 format. Use value '0.0.0.0' to represent all
     Azure-internal IP addresses.
    :type start_ip_address: str
    :param end_ip_address: Required. The end IP address of the firewall rule.
     Must be IPv4 format. Must be greater than or equal to startIpAddress. Use
     value '0.0.0.0' to represent all Azure-internal IP addresses.
    :type end_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
        'start_ip_address': {'required': True},
        'end_ip_address': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FirewallRule, self).__init__(**kwargs)
        self.kind = None
        self.location = None
        self.start_ip_address = kwargs.get('start_ip_address', None)
        self.end_ip_address = kwargs.get('end_ip_address', None)


class GeoBackupPolicy(ProxyResource):
    """A database geo backup policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param state: Required. The state of the geo backup policy. Possible
     values include: 'Disabled', 'Enabled'
    :type state: str or ~azure.mgmt.sql.models.GeoBackupPolicyState
    :ivar storage_type: The storage type of the geo backup policy.
    :vartype storage_type: str
    :ivar kind: Kind of geo backup policy.  This is metadata used for the
     Azure portal experience.
    :vartype kind: str
    :ivar location: Backup policy location.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'required': True},
        'storage_type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'GeoBackupPolicyState'},
        'storage_type': {'key': 'properties.storageType', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GeoBackupPolicy, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.storage_type = None
        self.kind = None
        self.location = None


class ImportExistingDatabaseDefinition(Model):
    """Contains the information necessary to perform import operation for existing
    database.

    All required parameters must be populated in order to send to Azure.

    :param storage_key_type: Required. Storage key type. Possible values
     include: 'SharedAccessKey', 'StorageAccessKey'
    :type storage_key_type: str or ~azure.mgmt.sql.models.StorageKeyType
    :param storage_key: Required. Storage key.
    :type storage_key: str
    :param storage_uri: Required. Storage Uri.
    :type storage_uri: str
    :param administrator_login: Required. Administrator login name.
    :type administrator_login: str
    :param administrator_login_password: Required. Administrator login
     password.
    :type administrator_login_password: str
    :param authentication_type: Authentication type.
    :type authentication_type: str
    :param network_isolation: Optional resource information to enable network
     isolation for request.
    :type network_isolation: ~azure.mgmt.sql.models.NetworkIsolationSettings
    """

    _validation = {
        'storage_key_type': {'required': True},
        'storage_key': {'required': True},
        'storage_uri': {'required': True},
        'administrator_login': {'required': True},
        'administrator_login_password': {'required': True},
    }

    _attribute_map = {
        'storage_key_type': {'key': 'storageKeyType', 'type': 'str'},
        'storage_key': {'key': 'storageKey', 'type': 'str'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
        'administrator_login': {'key': 'administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'administratorLoginPassword', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'network_isolation': {'key': 'networkIsolation', 'type': 'NetworkIsolationSettings'},
    }

    def __init__(self, **kwargs):
        super(ImportExistingDatabaseDefinition, self).__init__(**kwargs)
        self.storage_key_type = kwargs.get('storage_key_type', None)
        self.storage_key = kwargs.get('storage_key', None)
        self.storage_uri = kwargs.get('storage_uri', None)
        self.administrator_login = kwargs.get('administrator_login', None)
        self.administrator_login_password = kwargs.get('administrator_login_password', None)
        self.authentication_type = kwargs.get('authentication_type', None)
        self.network_isolation = kwargs.get('network_isolation', None)


class ImportExportOperationResult(ProxyResource):
    """An ImportExport operation result resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar request_id: Request Id.
    :vartype request_id: str
    :ivar request_type: Request type.
    :vartype request_type: str
    :ivar queued_time: Queued time.
    :vartype queued_time: str
    :ivar last_modified_time: Last modified time.
    :vartype last_modified_time: str
    :ivar blob_uri: Blob Uri.
    :vartype blob_uri: str
    :ivar server_name: Server name.
    :vartype server_name: str
    :ivar database_name: Database name.
    :vartype database_name: str
    :ivar status: Operation status.
    :vartype status: str
    :ivar error_message: Error message.
    :vartype error_message: str
    :ivar private_endpoint_connections: Gets the status of private endpoints
     associated with this request.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.sql.models.PrivateEndpointConnectionRequestStatus]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'request_id': {'readonly': True},
        'request_type': {'readonly': True},
        'queued_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'blob_uri': {'readonly': True},
        'server_name': {'readonly': True},
        'database_name': {'readonly': True},
        'status': {'readonly': True},
        'error_message': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'request_id': {'key': 'properties.requestId', 'type': 'str'},
        'request_type': {'key': 'properties.requestType', 'type': 'str'},
        'queued_time': {'key': 'properties.queuedTime', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'str'},
        'blob_uri': {'key': 'properties.blobUri', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'error_message': {'key': 'properties.errorMessage', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnectionRequestStatus]'},
    }

    def __init__(self, **kwargs):
        super(ImportExportOperationResult, self).__init__(**kwargs)
        self.request_id = None
        self.request_type = None
        self.queued_time = None
        self.last_modified_time = None
        self.blob_uri = None
        self.server_name = None
        self.database_name = None
        self.status = None
        self.error_message = None
        self.private_endpoint_connections = None


class ImportNewDatabaseDefinition(Model):
    """Contains the information necessary to perform import operation for new
    database.

    All required parameters must be populated in order to send to Azure.

    :param database_name: Name of the import database.
    :type database_name: str
    :param edition: Edition of the import database.
    :type edition: str
    :param service_objective_name: Service level objective name of the import
     database.
    :type service_objective_name: str
    :param max_size_bytes: Max size in bytes for the import database.
    :type max_size_bytes: str
    :param storage_key_type: Required. Storage key type. Possible values
     include: 'SharedAccessKey', 'StorageAccessKey'
    :type storage_key_type: str or ~azure.mgmt.sql.models.StorageKeyType
    :param storage_key: Required. Storage key.
    :type storage_key: str
    :param storage_uri: Required. Storage Uri.
    :type storage_uri: str
    :param administrator_login: Required. Administrator login name.
    :type administrator_login: str
    :param administrator_login_password: Required. Administrator login
     password.
    :type administrator_login_password: str
    :param authentication_type: Authentication type.
    :type authentication_type: str
    :param network_isolation: Optional resource information to enable network
     isolation for request.
    :type network_isolation: ~azure.mgmt.sql.models.NetworkIsolationSettings
    """

    _validation = {
        'storage_key_type': {'required': True},
        'storage_key': {'required': True},
        'storage_uri': {'required': True},
        'administrator_login': {'required': True},
        'administrator_login_password': {'required': True},
    }

    _attribute_map = {
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'edition': {'key': 'edition', 'type': 'str'},
        'service_objective_name': {'key': 'serviceObjectiveName', 'type': 'str'},
        'max_size_bytes': {'key': 'maxSizeBytes', 'type': 'str'},
        'storage_key_type': {'key': 'storageKeyType', 'type': 'str'},
        'storage_key': {'key': 'storageKey', 'type': 'str'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
        'administrator_login': {'key': 'administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'administratorLoginPassword', 'type': 'str'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'network_isolation': {'key': 'networkIsolation', 'type': 'NetworkIsolationSettings'},
    }

    def __init__(self, **kwargs):
        super(ImportNewDatabaseDefinition, self).__init__(**kwargs)
        self.database_name = kwargs.get('database_name', None)
        self.edition = kwargs.get('edition', None)
        self.service_objective_name = kwargs.get('service_objective_name', None)
        self.max_size_bytes = kwargs.get('max_size_bytes', None)
        self.storage_key_type = kwargs.get('storage_key_type', None)
        self.storage_key = kwargs.get('storage_key', None)
        self.storage_uri = kwargs.get('storage_uri', None)
        self.administrator_login = kwargs.get('administrator_login', None)
        self.administrator_login_password = kwargs.get('administrator_login_password', None)
        self.authentication_type = kwargs.get('authentication_type', None)
        self.network_isolation = kwargs.get('network_isolation', None)


class InstanceFailoverGroup(ProxyResource):
    """An instance failover group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param read_write_endpoint: Required. Read-write endpoint of the failover
     group instance.
    :type read_write_endpoint:
     ~azure.mgmt.sql.models.InstanceFailoverGroupReadWriteEndpoint
    :param read_only_endpoint: Read-only endpoint of the failover group
     instance.
    :type read_only_endpoint:
     ~azure.mgmt.sql.models.InstanceFailoverGroupReadOnlyEndpoint
    :ivar replication_role: Local replication role of the failover group
     instance. Possible values include: 'Primary', 'Secondary'
    :vartype replication_role: str or
     ~azure.mgmt.sql.models.InstanceFailoverGroupReplicationRole
    :ivar replication_state: Replication state of the failover group instance.
    :vartype replication_state: str
    :param partner_regions: Required. Partner region information for the
     failover group.
    :type partner_regions: list[~azure.mgmt.sql.models.PartnerRegionInfo]
    :param managed_instance_pairs: Required. List of managed instance pairs in
     the failover group.
    :type managed_instance_pairs:
     list[~azure.mgmt.sql.models.ManagedInstancePairInfo]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'read_write_endpoint': {'required': True},
        'replication_role': {'readonly': True},
        'replication_state': {'readonly': True},
        'partner_regions': {'required': True},
        'managed_instance_pairs': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'read_write_endpoint': {'key': 'properties.readWriteEndpoint', 'type': 'InstanceFailoverGroupReadWriteEndpoint'},
        'read_only_endpoint': {'key': 'properties.readOnlyEndpoint', 'type': 'InstanceFailoverGroupReadOnlyEndpoint'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
        'replication_state': {'key': 'properties.replicationState', 'type': 'str'},
        'partner_regions': {'key': 'properties.partnerRegions', 'type': '[PartnerRegionInfo]'},
        'managed_instance_pairs': {'key': 'properties.managedInstancePairs', 'type': '[ManagedInstancePairInfo]'},
    }

    def __init__(self, **kwargs):
        super(InstanceFailoverGroup, self).__init__(**kwargs)
        self.read_write_endpoint = kwargs.get('read_write_endpoint', None)
        self.read_only_endpoint = kwargs.get('read_only_endpoint', None)
        self.replication_role = None
        self.replication_state = None
        self.partner_regions = kwargs.get('partner_regions', None)
        self.managed_instance_pairs = kwargs.get('managed_instance_pairs', None)


class InstanceFailoverGroupReadOnlyEndpoint(Model):
    """Read-only endpoint of the failover group instance.

    :param failover_policy: Failover policy of the read-only endpoint for the
     failover group. Possible values include: 'Disabled', 'Enabled'
    :type failover_policy: str or
     ~azure.mgmt.sql.models.ReadOnlyEndpointFailoverPolicy
    """

    _attribute_map = {
        'failover_policy': {'key': 'failoverPolicy', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(InstanceFailoverGroupReadOnlyEndpoint, self).__init__(**kwargs)
        self.failover_policy = kwargs.get('failover_policy', None)


class InstanceFailoverGroupReadWriteEndpoint(Model):
    """Read-write endpoint of the failover group instance.

    All required parameters must be populated in order to send to Azure.

    :param failover_policy: Required. Failover policy of the read-write
     endpoint for the failover group. If failoverPolicy is Automatic then
     failoverWithDataLossGracePeriodMinutes is required. Possible values
     include: 'Manual', 'Automatic'
    :type failover_policy: str or
     ~azure.mgmt.sql.models.ReadWriteEndpointFailoverPolicy
    :param failover_with_data_loss_grace_period_minutes: Grace period before
     failover with data loss is attempted for the read-write endpoint. If
     failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is
     required.
    :type failover_with_data_loss_grace_period_minutes: int
    """

    _validation = {
        'failover_policy': {'required': True},
    }

    _attribute_map = {
        'failover_policy': {'key': 'failoverPolicy', 'type': 'str'},
        'failover_with_data_loss_grace_period_minutes': {'key': 'failoverWithDataLossGracePeriodMinutes', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(InstanceFailoverGroupReadWriteEndpoint, self).__init__(**kwargs)
        self.failover_policy = kwargs.get('failover_policy', None)
        self.failover_with_data_loss_grace_period_minutes = kwargs.get('failover_with_data_loss_grace_period_minutes', None)


class InstancePool(TrackedResource):
    """An Azure SQL instance pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param sku: The name and tier of the SKU.
    :type sku: ~azure.mgmt.sql.models.Sku
    :param subnet_id: Required. Resource ID of the subnet to place this
     instance pool in.
    :type subnet_id: str
    :param v_cores: Required. Count of vCores belonging to this instance pool.
    :type v_cores: int
    :param license_type: Required. The license type. Possible values are
     'LicenseIncluded' (price for SQL license is included) and 'BasePrice'
     (without SQL license price). Possible values include: 'LicenseIncluded',
     'BasePrice'
    :type license_type: str or ~azure.mgmt.sql.models.InstancePoolLicenseType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'subnet_id': {'required': True},
        'v_cores': {'required': True},
        'license_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'v_cores': {'key': 'properties.vCores', 'type': 'int'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(InstancePool, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.subnet_id = kwargs.get('subnet_id', None)
        self.v_cores = kwargs.get('v_cores', None)
        self.license_type = kwargs.get('license_type', None)


class InstancePoolEditionCapability(Model):
    """The instance pool capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The instance pool version name.
    :vartype name: str
    :ivar supported_families: The supported families.
    :vartype supported_families:
     list[~azure.mgmt.sql.models.InstancePoolFamilyCapability]
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_families': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_families': {'key': 'supportedFamilies', 'type': '[InstancePoolFamilyCapability]'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(InstancePoolEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_families = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class InstancePoolFamilyCapability(Model):
    """The instance pool family capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Family name.
    :vartype name: str
    :ivar supported_license_types: List of supported license types.
    :vartype supported_license_types:
     list[~azure.mgmt.sql.models.LicenseTypeCapability]
    :ivar supported_vcores_values: List of supported virtual cores values.
    :vartype supported_vcores_values:
     list[~azure.mgmt.sql.models.InstancePoolVcoresCapability]
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_license_types': {'readonly': True},
        'supported_vcores_values': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_license_types': {'key': 'supportedLicenseTypes', 'type': '[LicenseTypeCapability]'},
        'supported_vcores_values': {'key': 'supportedVcoresValues', 'type': '[InstancePoolVcoresCapability]'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(InstancePoolFamilyCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_license_types = None
        self.supported_vcores_values = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class InstancePoolUpdate(Model):
    """An update to an Instance pool.

    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(InstancePoolUpdate, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class InstancePoolVcoresCapability(Model):
    """The managed instance virtual cores capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The virtual cores identifier.
    :vartype name: str
    :ivar value: The virtual cores value.
    :vartype value: int
    :ivar storage_limit: Storage limit.
    :vartype storage_limit: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
        'storage_limit': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
        'storage_limit': {'key': 'storageLimit', 'type': 'MaxSizeCapability'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(InstancePoolVcoresCapability, self).__init__(**kwargs)
        self.name = None
        self.value = None
        self.storage_limit = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class Job(ProxyResource):
    """A job.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param description: User-defined description of the job. Default value: ""
     .
    :type description: str
    :ivar version: The job version number.
    :vartype version: int
    :param schedule: Schedule properties of the job.
    :type schedule: ~azure.mgmt.sql.models.JobSchedule
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'int'},
        'schedule': {'key': 'properties.schedule', 'type': 'JobSchedule'},
    }

    def __init__(self, **kwargs):
        super(Job, self).__init__(**kwargs)
        self.description = kwargs.get('description', "")
        self.version = None
        self.schedule = kwargs.get('schedule', None)


class JobAgent(TrackedResource):
    """An Azure SQL job agent.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param sku: The name and tier of the SKU.
    :type sku: ~azure.mgmt.sql.models.Sku
    :param database_id: Required. Resource ID of the database to store job
     metadata in.
    :type database_id: str
    :ivar state: The state of the job agent. Possible values include:
     'Creating', 'Ready', 'Updating', 'Deleting', 'Disabled'
    :vartype state: str or ~azure.mgmt.sql.models.JobAgentState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'database_id': {'required': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'database_id': {'key': 'properties.databaseId', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobAgent, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.database_id = kwargs.get('database_id', None)
        self.state = None


class JobAgentUpdate(Model):
    """An update to an Azure SQL job agent.

    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(JobAgentUpdate, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class JobCredential(ProxyResource):
    """A stored credential that can be used by a job to connect to target
    databases.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param username: Required. The credential user name.
    :type username: str
    :param password: Required. The credential password.
    :type password: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'username': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'username': {'key': 'properties.username', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobCredential, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)


class JobExecution(ProxyResource):
    """An execution of a job.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar job_version: The job version number.
    :vartype job_version: int
    :ivar step_name: The job step name.
    :vartype step_name: str
    :ivar step_id: The job step id.
    :vartype step_id: int
    :ivar job_execution_id: The unique identifier of the job execution.
    :vartype job_execution_id: str
    :ivar lifecycle: The detailed state of the job execution. Possible values
     include: 'Created', 'InProgress', 'WaitingForChildJobExecutions',
     'WaitingForRetry', 'Succeeded', 'SucceededWithSkipped', 'Failed',
     'TimedOut', 'Canceled', 'Skipped'
    :vartype lifecycle: str or ~azure.mgmt.sql.models.JobExecutionLifecycle
    :ivar provisioning_state: The ARM provisioning state of the job execution.
     Possible values include: 'Created', 'InProgress', 'Succeeded', 'Failed',
     'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.sql.models.ProvisioningState
    :ivar create_time: The time that the job execution was created.
    :vartype create_time: datetime
    :ivar start_time: The time that the job execution started.
    :vartype start_time: datetime
    :ivar end_time: The time that the job execution completed.
    :vartype end_time: datetime
    :param current_attempts: Number of times the job execution has been
     attempted.
    :type current_attempts: int
    :ivar current_attempt_start_time: Start time of the current attempt.
    :vartype current_attempt_start_time: datetime
    :ivar last_message: The last status or error message.
    :vartype last_message: str
    :ivar target: The target that this execution is executed on.
    :vartype target: ~azure.mgmt.sql.models.JobExecutionTarget
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'job_version': {'readonly': True},
        'step_name': {'readonly': True},
        'step_id': {'readonly': True},
        'job_execution_id': {'readonly': True},
        'lifecycle': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'create_time': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'current_attempt_start_time': {'readonly': True},
        'last_message': {'readonly': True},
        'target': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'job_version': {'key': 'properties.jobVersion', 'type': 'int'},
        'step_name': {'key': 'properties.stepName', 'type': 'str'},
        'step_id': {'key': 'properties.stepId', 'type': 'int'},
        'job_execution_id': {'key': 'properties.jobExecutionId', 'type': 'str'},
        'lifecycle': {'key': 'properties.lifecycle', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'create_time': {'key': 'properties.createTime', 'type': 'iso-8601'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'current_attempts': {'key': 'properties.currentAttempts', 'type': 'int'},
        'current_attempt_start_time': {'key': 'properties.currentAttemptStartTime', 'type': 'iso-8601'},
        'last_message': {'key': 'properties.lastMessage', 'type': 'str'},
        'target': {'key': 'properties.target', 'type': 'JobExecutionTarget'},
    }

    def __init__(self, **kwargs):
        super(JobExecution, self).__init__(**kwargs)
        self.job_version = None
        self.step_name = None
        self.step_id = None
        self.job_execution_id = None
        self.lifecycle = None
        self.provisioning_state = None
        self.create_time = None
        self.start_time = None
        self.end_time = None
        self.current_attempts = kwargs.get('current_attempts', None)
        self.current_attempt_start_time = None
        self.last_message = None
        self.target = None


class JobExecutionTarget(Model):
    """The target that a job execution is executed on.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The type of the target. Possible values include:
     'TargetGroup', 'SqlDatabase', 'SqlElasticPool', 'SqlShardMap', 'SqlServer'
    :vartype type: str or ~azure.mgmt.sql.models.JobTargetType
    :ivar server_name: The server name.
    :vartype server_name: str
    :ivar database_name: The database name.
    :vartype database_name: str
    """

    _validation = {
        'type': {'readonly': True},
        'server_name': {'readonly': True},
        'database_name': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobExecutionTarget, self).__init__(**kwargs)
        self.type = None
        self.server_name = None
        self.database_name = None


class JobSchedule(Model):
    """Scheduling properties of a job.

    :param start_time: Schedule start time. Default value:
     "0001-01-01T00:00:00Z" .
    :type start_time: datetime
    :param end_time: Schedule end time. Default value: "9999-12-31T11:59:59Z"
     .
    :type end_time: datetime
    :param type: Schedule interval type. Possible values include: 'Once',
     'Recurring'. Default value: "Once" .
    :type type: str or ~azure.mgmt.sql.models.JobScheduleType
    :param enabled: Whether or not the schedule is enabled.
    :type enabled: bool
    :param interval: Value of the schedule's recurring interval, if the
     schedule type is recurring. ISO8601 duration format.
    :type interval: str
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'JobScheduleType'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'interval': {'key': 'interval', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobSchedule, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', "0001-01-01T00:00:00Z")
        self.end_time = kwargs.get('end_time', "9999-12-31T11:59:59Z")
        self.type = kwargs.get('type', "Once")
        self.enabled = kwargs.get('enabled', None)
        self.interval = kwargs.get('interval', None)


class JobStep(ProxyResource):
    """A job step.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param step_id: The job step's index within the job. If not specified when
     creating the job step, it will be created as the last step. If not
     specified when updating the job step, the step id is not modified.
    :type step_id: int
    :param target_group: Required. The resource ID of the target group that
     the job step will be executed on.
    :type target_group: str
    :param credential: Required. The resource ID of the job credential that
     will be used to connect to the targets.
    :type credential: str
    :param action: Required. The action payload of the job step.
    :type action: ~azure.mgmt.sql.models.JobStepAction
    :param output: Output destination properties of the job step.
    :type output: ~azure.mgmt.sql.models.JobStepOutput
    :param execution_options: Execution options for the job step.
    :type execution_options: ~azure.mgmt.sql.models.JobStepExecutionOptions
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'target_group': {'required': True},
        'credential': {'required': True},
        'action': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'step_id': {'key': 'properties.stepId', 'type': 'int'},
        'target_group': {'key': 'properties.targetGroup', 'type': 'str'},
        'credential': {'key': 'properties.credential', 'type': 'str'},
        'action': {'key': 'properties.action', 'type': 'JobStepAction'},
        'output': {'key': 'properties.output', 'type': 'JobStepOutput'},
        'execution_options': {'key': 'properties.executionOptions', 'type': 'JobStepExecutionOptions'},
    }

    def __init__(self, **kwargs):
        super(JobStep, self).__init__(**kwargs)
        self.step_id = kwargs.get('step_id', None)
        self.target_group = kwargs.get('target_group', None)
        self.credential = kwargs.get('credential', None)
        self.action = kwargs.get('action', None)
        self.output = kwargs.get('output', None)
        self.execution_options = kwargs.get('execution_options', None)


class JobStepAction(Model):
    """The action to be executed by a job step.

    All required parameters must be populated in order to send to Azure.

    :param type: Type of action being executed by the job step. Possible
     values include: 'TSql'. Default value: "TSql" .
    :type type: str or ~azure.mgmt.sql.models.JobStepActionType
    :param source: The source of the action to execute. Possible values
     include: 'Inline'. Default value: "Inline" .
    :type source: str or ~azure.mgmt.sql.models.JobStepActionSource
    :param value: Required. The action value, for example the text of the
     T-SQL script to execute.
    :type value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobStepAction, self).__init__(**kwargs)
        self.type = kwargs.get('type', "TSql")
        self.source = kwargs.get('source', "Inline")
        self.value = kwargs.get('value', None)


class JobStepExecutionOptions(Model):
    """The execution options of a job step.

    :param timeout_seconds: Execution timeout for the job step. Default value:
     43200 .
    :type timeout_seconds: int
    :param retry_attempts: Maximum number of times the job step will be
     reattempted if the first attempt fails. Default value: 10 .
    :type retry_attempts: int
    :param initial_retry_interval_seconds: Initial delay between retries for
     job step execution. Default value: 1 .
    :type initial_retry_interval_seconds: int
    :param maximum_retry_interval_seconds: The maximum amount of time to wait
     between retries for job step execution. Default value: 120 .
    :type maximum_retry_interval_seconds: int
    :param retry_interval_backoff_multiplier: The backoff multiplier for the
     time between retries. Default value: 2 .
    :type retry_interval_backoff_multiplier: float
    """

    _attribute_map = {
        'timeout_seconds': {'key': 'timeoutSeconds', 'type': 'int'},
        'retry_attempts': {'key': 'retryAttempts', 'type': 'int'},
        'initial_retry_interval_seconds': {'key': 'initialRetryIntervalSeconds', 'type': 'int'},
        'maximum_retry_interval_seconds': {'key': 'maximumRetryIntervalSeconds', 'type': 'int'},
        'retry_interval_backoff_multiplier': {'key': 'retryIntervalBackoffMultiplier', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(JobStepExecutionOptions, self).__init__(**kwargs)
        self.timeout_seconds = kwargs.get('timeout_seconds', 43200)
        self.retry_attempts = kwargs.get('retry_attempts', 10)
        self.initial_retry_interval_seconds = kwargs.get('initial_retry_interval_seconds', 1)
        self.maximum_retry_interval_seconds = kwargs.get('maximum_retry_interval_seconds', 120)
        self.retry_interval_backoff_multiplier = kwargs.get('retry_interval_backoff_multiplier', 2)


class JobStepOutput(Model):
    """The output configuration of a job step.

    All required parameters must be populated in order to send to Azure.

    :param type: The output destination type. Possible values include:
     'SqlDatabase'. Default value: "SqlDatabase" .
    :type type: str or ~azure.mgmt.sql.models.JobStepOutputType
    :param subscription_id: The output destination subscription id.
    :type subscription_id: str
    :param resource_group_name: The output destination resource group.
    :type resource_group_name: str
    :param server_name: Required. The output destination server name.
    :type server_name: str
    :param database_name: Required. The output destination database.
    :type database_name: str
    :param schema_name: The output destination schema. Default value: "dbo" .
    :type schema_name: str
    :param table_name: Required. The output destination table.
    :type table_name: str
    :param credential: Required. The resource ID of the credential to use to
     connect to the output destination.
    :type credential: str
    """

    _validation = {
        'server_name': {'required': True},
        'database_name': {'required': True},
        'table_name': {'required': True},
        'credential': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'schema_name': {'key': 'schemaName', 'type': 'str'},
        'table_name': {'key': 'tableName', 'type': 'str'},
        'credential': {'key': 'credential', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobStepOutput, self).__init__(**kwargs)
        self.type = kwargs.get('type', "SqlDatabase")
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_group_name = kwargs.get('resource_group_name', None)
        self.server_name = kwargs.get('server_name', None)
        self.database_name = kwargs.get('database_name', None)
        self.schema_name = kwargs.get('schema_name', "dbo")
        self.table_name = kwargs.get('table_name', None)
        self.credential = kwargs.get('credential', None)


class JobTarget(Model):
    """A job target, for example a specific database or a container of databases
    that is evaluated during job execution.

    All required parameters must be populated in order to send to Azure.

    :param membership_type: Whether the target is included or excluded from
     the group. Possible values include: 'Include', 'Exclude'. Default value:
     "Include" .
    :type membership_type: str or
     ~azure.mgmt.sql.models.JobTargetGroupMembershipType
    :param type: Required. The target type. Possible values include:
     'TargetGroup', 'SqlDatabase', 'SqlElasticPool', 'SqlShardMap', 'SqlServer'
    :type type: str or ~azure.mgmt.sql.models.JobTargetType
    :param server_name: The target server name.
    :type server_name: str
    :param database_name: The target database name.
    :type database_name: str
    :param elastic_pool_name: The target elastic pool name.
    :type elastic_pool_name: str
    :param shard_map_name: The target shard map.
    :type shard_map_name: str
    :param refresh_credential: The resource ID of the credential that is used
     during job execution to connect to the target and determine the list of
     databases inside the target.
    :type refresh_credential: str
    """

    _validation = {
        'type': {'required': True},
    }

    _attribute_map = {
        'membership_type': {'key': 'membershipType', 'type': 'JobTargetGroupMembershipType'},
        'type': {'key': 'type', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'elastic_pool_name': {'key': 'elasticPoolName', 'type': 'str'},
        'shard_map_name': {'key': 'shardMapName', 'type': 'str'},
        'refresh_credential': {'key': 'refreshCredential', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobTarget, self).__init__(**kwargs)
        self.membership_type = kwargs.get('membership_type', "Include")
        self.type = kwargs.get('type', None)
        self.server_name = kwargs.get('server_name', None)
        self.database_name = kwargs.get('database_name', None)
        self.elastic_pool_name = kwargs.get('elastic_pool_name', None)
        self.shard_map_name = kwargs.get('shard_map_name', None)
        self.refresh_credential = kwargs.get('refresh_credential', None)


class JobTargetGroup(ProxyResource):
    """A group of job targets.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param members: Required. Members of the target group.
    :type members: list[~azure.mgmt.sql.models.JobTarget]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'members': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'members': {'key': 'properties.members', 'type': '[JobTarget]'},
    }

    def __init__(self, **kwargs):
        super(JobTargetGroup, self).__init__(**kwargs)
        self.members = kwargs.get('members', None)


class JobVersion(ProxyResource):
    """A job version.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobVersion, self).__init__(**kwargs)


class LicenseTypeCapability(Model):
    """The license type capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: License type identifier.
    :vartype name: str
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LicenseTypeCapability, self).__init__(**kwargs)
        self.name = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class LocationCapabilities(Model):
    """The location capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The location name.
    :vartype name: str
    :ivar supported_server_versions: The list of supported server versions.
    :vartype supported_server_versions:
     list[~azure.mgmt.sql.models.ServerVersionCapability]
    :ivar supported_managed_instance_versions: The list of supported managed
     instance versions.
    :vartype supported_managed_instance_versions:
     list[~azure.mgmt.sql.models.ManagedInstanceVersionCapability]
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_server_versions': {'readonly': True},
        'supported_managed_instance_versions': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_server_versions': {'key': 'supportedServerVersions', 'type': '[ServerVersionCapability]'},
        'supported_managed_instance_versions': {'key': 'supportedManagedInstanceVersions', 'type': '[ManagedInstanceVersionCapability]'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LocationCapabilities, self).__init__(**kwargs)
        self.name = None
        self.supported_server_versions = None
        self.supported_managed_instance_versions = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class LogSizeCapability(Model):
    """The log size capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar limit: The log size limit (see 'unit' for the units).
    :vartype limit: int
    :ivar unit: The units that the limit is expressed in. Possible values
     include: 'Megabytes', 'Gigabytes', 'Terabytes', 'Petabytes', 'Percent'
    :vartype unit: str or ~azure.mgmt.sql.models.LogSizeUnit
    """

    _validation = {
        'limit': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'int'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LogSizeCapability, self).__init__(**kwargs)
        self.limit = None
        self.unit = None


class LongTermRetentionBackup(ProxyResource):
    """A long term retention backup.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar server_name: The server name that the backup database belong to.
    :vartype server_name: str
    :ivar server_create_time: The create time of the server.
    :vartype server_create_time: datetime
    :ivar database_name: The name of the database the backup belong to
    :vartype database_name: str
    :ivar database_deletion_time: The delete time of the database
    :vartype database_deletion_time: datetime
    :ivar backup_time: The time the backup was taken
    :vartype backup_time: datetime
    :ivar backup_expiration_time: The time the long term retention backup will
     expire.
    :vartype backup_expiration_time: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'server_name': {'readonly': True},
        'server_create_time': {'readonly': True},
        'database_name': {'readonly': True},
        'database_deletion_time': {'readonly': True},
        'backup_time': {'readonly': True},
        'backup_expiration_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'server_create_time': {'key': 'properties.serverCreateTime', 'type': 'iso-8601'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'database_deletion_time': {'key': 'properties.databaseDeletionTime', 'type': 'iso-8601'},
        'backup_time': {'key': 'properties.backupTime', 'type': 'iso-8601'},
        'backup_expiration_time': {'key': 'properties.backupExpirationTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(LongTermRetentionBackup, self).__init__(**kwargs)
        self.server_name = None
        self.server_create_time = None
        self.database_name = None
        self.database_deletion_time = None
        self.backup_time = None
        self.backup_expiration_time = None


class ManagedBackupShortTermRetentionPolicy(ProxyResource):
    """A short term retention policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param retention_days: The backup retention period in days. This is how
     many days Point-in-Time Restore will be supported.
    :type retention_days: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ManagedBackupShortTermRetentionPolicy, self).__init__(**kwargs)
        self.retention_days = kwargs.get('retention_days', None)


class ManagedDatabase(TrackedResource):
    """A managed database resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param collation: Collation of the managed database.
    :type collation: str
    :ivar status: Status of the database. Possible values include: 'Online',
     'Offline', 'Shutdown', 'Creating', 'Inaccessible', 'Restoring', 'Updating'
    :vartype status: str or ~azure.mgmt.sql.models.ManagedDatabaseStatus
    :ivar creation_date: Creation date of the database.
    :vartype creation_date: datetime
    :ivar earliest_restore_point: Earliest restore point in time for point in
     time restore.
    :vartype earliest_restore_point: datetime
    :param restore_point_in_time: Conditional. If createMode is
     PointInTimeRestore, this value is required. Specifies the point in time
     (ISO8601 format) of the source database that will be restored to create
     the new database.
    :type restore_point_in_time: datetime
    :ivar default_secondary_location: Geo paired region.
    :vartype default_secondary_location: str
    :param catalog_collation: Collation of the metadata catalog. Possible
     values include: 'DATABASE_DEFAULT', 'SQL_Latin1_General_CP1_CI_AS'
    :type catalog_collation: str or
     ~azure.mgmt.sql.models.CatalogCollationType
    :param create_mode: Managed database create mode. PointInTimeRestore:
     Create a database by restoring a point in time backup of an existing
     database. SourceDatabaseName, SourceManagedInstanceName and PointInTime
     must be specified. RestoreExternalBackup: Create a database by restoring
     from external backup files. Collation, StorageContainerUri and
     StorageContainerSasToken must be specified. Recovery: Creates a database
     by restoring a geo-replicated backup. RecoverableDatabaseId must be
     specified as the recoverable database resource ID to restore.
     RestoreLongTermRetentionBackup: Create a database by restoring from a long
     term retention backup (longTermRetentionBackupResourceId required).
     Possible values include: 'Default', 'RestoreExternalBackup',
     'PointInTimeRestore', 'Recovery', 'RestoreLongTermRetentionBackup'
    :type create_mode: str or ~azure.mgmt.sql.models.ManagedDatabaseCreateMode
    :param storage_container_uri: Conditional. If createMode is
     RestoreExternalBackup, this value is required. Specifies the uri of the
     storage container where backups for this restore are stored.
    :type storage_container_uri: str
    :param source_database_id: The resource identifier of the source database
     associated with create operation of this database.
    :type source_database_id: str
    :param restorable_dropped_database_id: The restorable dropped database
     resource id to restore when creating this database.
    :type restorable_dropped_database_id: str
    :param storage_container_sas_token: Conditional. If createMode is
     RestoreExternalBackup, this value is required. Specifies the storage
     container sas token.
    :type storage_container_sas_token: str
    :ivar failover_group_id: Instance Failover Group resource identifier that
     this managed database belongs to.
    :vartype failover_group_id: str
    :param recoverable_database_id: The resource identifier of the recoverable
     database associated with create operation of this database.
    :type recoverable_database_id: str
    :param long_term_retention_backup_resource_id: The name of the Long Term
     Retention backup to be used for restore of this managed database.
    :type long_term_retention_backup_resource_id: str
    :param auto_complete_restore: Whether to auto complete restore of this
     managed database.
    :type auto_complete_restore: bool
    :param last_backup_name: Last backup file name for restore of this managed
     database.
    :type last_backup_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'status': {'readonly': True},
        'creation_date': {'readonly': True},
        'earliest_restore_point': {'readonly': True},
        'default_secondary_location': {'readonly': True},
        'failover_group_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'earliest_restore_point': {'key': 'properties.earliestRestorePoint', 'type': 'iso-8601'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'default_secondary_location': {'key': 'properties.defaultSecondaryLocation', 'type': 'str'},
        'catalog_collation': {'key': 'properties.catalogCollation', 'type': 'str'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'storage_container_uri': {'key': 'properties.storageContainerUri', 'type': 'str'},
        'source_database_id': {'key': 'properties.sourceDatabaseId', 'type': 'str'},
        'restorable_dropped_database_id': {'key': 'properties.restorableDroppedDatabaseId', 'type': 'str'},
        'storage_container_sas_token': {'key': 'properties.storageContainerSasToken', 'type': 'str'},
        'failover_group_id': {'key': 'properties.failoverGroupId', 'type': 'str'},
        'recoverable_database_id': {'key': 'properties.recoverableDatabaseId', 'type': 'str'},
        'long_term_retention_backup_resource_id': {'key': 'properties.longTermRetentionBackupResourceId', 'type': 'str'},
        'auto_complete_restore': {'key': 'properties.autoCompleteRestore', 'type': 'bool'},
        'last_backup_name': {'key': 'properties.lastBackupName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedDatabase, self).__init__(**kwargs)
        self.collation = kwargs.get('collation', None)
        self.status = None
        self.creation_date = None
        self.earliest_restore_point = None
        self.restore_point_in_time = kwargs.get('restore_point_in_time', None)
        self.default_secondary_location = None
        self.catalog_collation = kwargs.get('catalog_collation', None)
        self.create_mode = kwargs.get('create_mode', None)
        self.storage_container_uri = kwargs.get('storage_container_uri', None)
        self.source_database_id = kwargs.get('source_database_id', None)
        self.restorable_dropped_database_id = kwargs.get('restorable_dropped_database_id', None)
        self.storage_container_sas_token = kwargs.get('storage_container_sas_token', None)
        self.failover_group_id = None
        self.recoverable_database_id = kwargs.get('recoverable_database_id', None)
        self.long_term_retention_backup_resource_id = kwargs.get('long_term_retention_backup_resource_id', None)
        self.auto_complete_restore = kwargs.get('auto_complete_restore', None)
        self.last_backup_name = kwargs.get('last_backup_name', None)


class ManagedDatabaseRestoreDetailsResult(ProxyResource):
    """A managed database restore details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar status: Restore status.
    :vartype status: str
    :ivar current_restoring_file_name: Current restoring file name.
    :vartype current_restoring_file_name: str
    :ivar last_restored_file_name: Last restored file name.
    :vartype last_restored_file_name: str
    :ivar last_restored_file_time: Last restored file time.
    :vartype last_restored_file_time: datetime
    :ivar percent_completed: Percent completed.
    :vartype percent_completed: float
    :ivar unrestorable_files: List of unrestorable files.
    :vartype unrestorable_files: list[str]
    :ivar number_of_files_detected: Number of files detected.
    :vartype number_of_files_detected: long
    :ivar last_uploaded_file_name: Last uploaded file name.
    :vartype last_uploaded_file_name: str
    :ivar last_uploaded_file_time: Last uploaded file time.
    :vartype last_uploaded_file_time: datetime
    :ivar block_reason: The reason why restore is in Blocked state.
    :vartype block_reason: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'current_restoring_file_name': {'readonly': True},
        'last_restored_file_name': {'readonly': True},
        'last_restored_file_time': {'readonly': True},
        'percent_completed': {'readonly': True},
        'unrestorable_files': {'readonly': True},
        'number_of_files_detected': {'readonly': True},
        'last_uploaded_file_name': {'readonly': True},
        'last_uploaded_file_time': {'readonly': True},
        'block_reason': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'current_restoring_file_name': {'key': 'properties.currentRestoringFileName', 'type': 'str'},
        'last_restored_file_name': {'key': 'properties.lastRestoredFileName', 'type': 'str'},
        'last_restored_file_time': {'key': 'properties.lastRestoredFileTime', 'type': 'iso-8601'},
        'percent_completed': {'key': 'properties.percentCompleted', 'type': 'float'},
        'unrestorable_files': {'key': 'properties.unrestorableFiles', 'type': '[str]'},
        'number_of_files_detected': {'key': 'properties.numberOfFilesDetected', 'type': 'long'},
        'last_uploaded_file_name': {'key': 'properties.lastUploadedFileName', 'type': 'str'},
        'last_uploaded_file_time': {'key': 'properties.lastUploadedFileTime', 'type': 'iso-8601'},
        'block_reason': {'key': 'properties.blockReason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedDatabaseRestoreDetailsResult, self).__init__(**kwargs)
        self.status = None
        self.current_restoring_file_name = None
        self.last_restored_file_name = None
        self.last_restored_file_time = None
        self.percent_completed = None
        self.unrestorable_files = None
        self.number_of_files_detected = None
        self.last_uploaded_file_name = None
        self.last_uploaded_file_time = None
        self.block_reason = None


class ManagedDatabaseSecurityAlertPolicy(ProxyResource):
    """A managed database security alert policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param state: Required. Specifies the state of the policy, whether it is
     enabled or disabled or a policy has not been applied yet on the specific
     database. Possible values include: 'New', 'Enabled', 'Disabled'
    :type state: str or ~azure.mgmt.sql.models.SecurityAlertPolicyState
    :param disabled_alerts: Specifies an array of alerts that are disabled.
     Allowed values are: Sql_Injection, Sql_Injection_Vulnerability,
     Access_Anomaly, Data_Exfiltration, Unsafe_Action
    :type disabled_alerts: list[str]
    :param email_addresses: Specifies an array of e-mail addresses to which
     the alert is sent.
    :type email_addresses: list[str]
    :param email_account_admins: Specifies that the alert is sent to the
     account administrators.
    :type email_account_admins: bool
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all
     Threat Detection audit logs.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the
     Threat Detection audit storage account.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the Threat
     Detection audit logs.
    :type retention_days: int
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'required': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'SecurityAlertPolicyState'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': '[str]'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': '[str]'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'bool'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ManagedDatabaseSecurityAlertPolicy, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.disabled_alerts = kwargs.get('disabled_alerts', None)
        self.email_addresses = kwargs.get('email_addresses', None)
        self.email_account_admins = kwargs.get('email_account_admins', None)
        self.storage_endpoint = kwargs.get('storage_endpoint', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.retention_days = kwargs.get('retention_days', None)
        self.creation_time = None


class ManagedDatabaseUpdate(Model):
    """An managed database update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param collation: Collation of the managed database.
    :type collation: str
    :ivar status: Status of the database. Possible values include: 'Online',
     'Offline', 'Shutdown', 'Creating', 'Inaccessible', 'Restoring', 'Updating'
    :vartype status: str or ~azure.mgmt.sql.models.ManagedDatabaseStatus
    :ivar creation_date: Creation date of the database.
    :vartype creation_date: datetime
    :ivar earliest_restore_point: Earliest restore point in time for point in
     time restore.
    :vartype earliest_restore_point: datetime
    :param restore_point_in_time: Conditional. If createMode is
     PointInTimeRestore, this value is required. Specifies the point in time
     (ISO8601 format) of the source database that will be restored to create
     the new database.
    :type restore_point_in_time: datetime
    :ivar default_secondary_location: Geo paired region.
    :vartype default_secondary_location: str
    :param catalog_collation: Collation of the metadata catalog. Possible
     values include: 'DATABASE_DEFAULT', 'SQL_Latin1_General_CP1_CI_AS'
    :type catalog_collation: str or
     ~azure.mgmt.sql.models.CatalogCollationType
    :param create_mode: Managed database create mode. PointInTimeRestore:
     Create a database by restoring a point in time backup of an existing
     database. SourceDatabaseName, SourceManagedInstanceName and PointInTime
     must be specified. RestoreExternalBackup: Create a database by restoring
     from external backup files. Collation, StorageContainerUri and
     StorageContainerSasToken must be specified. Recovery: Creates a database
     by restoring a geo-replicated backup. RecoverableDatabaseId must be
     specified as the recoverable database resource ID to restore.
     RestoreLongTermRetentionBackup: Create a database by restoring from a long
     term retention backup (longTermRetentionBackupResourceId required).
     Possible values include: 'Default', 'RestoreExternalBackup',
     'PointInTimeRestore', 'Recovery', 'RestoreLongTermRetentionBackup'
    :type create_mode: str or ~azure.mgmt.sql.models.ManagedDatabaseCreateMode
    :param storage_container_uri: Conditional. If createMode is
     RestoreExternalBackup, this value is required. Specifies the uri of the
     storage container where backups for this restore are stored.
    :type storage_container_uri: str
    :param source_database_id: The resource identifier of the source database
     associated with create operation of this database.
    :type source_database_id: str
    :param restorable_dropped_database_id: The restorable dropped database
     resource id to restore when creating this database.
    :type restorable_dropped_database_id: str
    :param storage_container_sas_token: Conditional. If createMode is
     RestoreExternalBackup, this value is required. Specifies the storage
     container sas token.
    :type storage_container_sas_token: str
    :ivar failover_group_id: Instance Failover Group resource identifier that
     this managed database belongs to.
    :vartype failover_group_id: str
    :param recoverable_database_id: The resource identifier of the recoverable
     database associated with create operation of this database.
    :type recoverable_database_id: str
    :param long_term_retention_backup_resource_id: The name of the Long Term
     Retention backup to be used for restore of this managed database.
    :type long_term_retention_backup_resource_id: str
    :param auto_complete_restore: Whether to auto complete restore of this
     managed database.
    :type auto_complete_restore: bool
    :param last_backup_name: Last backup file name for restore of this managed
     database.
    :type last_backup_name: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'status': {'readonly': True},
        'creation_date': {'readonly': True},
        'earliest_restore_point': {'readonly': True},
        'default_secondary_location': {'readonly': True},
        'failover_group_id': {'readonly': True},
    }

    _attribute_map = {
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'earliest_restore_point': {'key': 'properties.earliestRestorePoint', 'type': 'iso-8601'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'default_secondary_location': {'key': 'properties.defaultSecondaryLocation', 'type': 'str'},
        'catalog_collation': {'key': 'properties.catalogCollation', 'type': 'str'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'storage_container_uri': {'key': 'properties.storageContainerUri', 'type': 'str'},
        'source_database_id': {'key': 'properties.sourceDatabaseId', 'type': 'str'},
        'restorable_dropped_database_id': {'key': 'properties.restorableDroppedDatabaseId', 'type': 'str'},
        'storage_container_sas_token': {'key': 'properties.storageContainerSasToken', 'type': 'str'},
        'failover_group_id': {'key': 'properties.failoverGroupId', 'type': 'str'},
        'recoverable_database_id': {'key': 'properties.recoverableDatabaseId', 'type': 'str'},
        'long_term_retention_backup_resource_id': {'key': 'properties.longTermRetentionBackupResourceId', 'type': 'str'},
        'auto_complete_restore': {'key': 'properties.autoCompleteRestore', 'type': 'bool'},
        'last_backup_name': {'key': 'properties.lastBackupName', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(ManagedDatabaseUpdate, self).__init__(**kwargs)
        self.collation = kwargs.get('collation', None)
        self.status = None
        self.creation_date = None
        self.earliest_restore_point = None
        self.restore_point_in_time = kwargs.get('restore_point_in_time', None)
        self.default_secondary_location = None
        self.catalog_collation = kwargs.get('catalog_collation', None)
        self.create_mode = kwargs.get('create_mode', None)
        self.storage_container_uri = kwargs.get('storage_container_uri', None)
        self.source_database_id = kwargs.get('source_database_id', None)
        self.restorable_dropped_database_id = kwargs.get('restorable_dropped_database_id', None)
        self.storage_container_sas_token = kwargs.get('storage_container_sas_token', None)
        self.failover_group_id = None
        self.recoverable_database_id = kwargs.get('recoverable_database_id', None)
        self.long_term_retention_backup_resource_id = kwargs.get('long_term_retention_backup_resource_id', None)
        self.auto_complete_restore = kwargs.get('auto_complete_restore', None)
        self.last_backup_name = kwargs.get('last_backup_name', None)
        self.tags = kwargs.get('tags', None)


class ManagedInstance(TrackedResource):
    """An Azure SQL managed instance.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param identity: The Azure Active Directory identity of the managed
     instance.
    :type identity: ~azure.mgmt.sql.models.ResourceIdentity
    :param sku: Managed instance SKU. Allowed values for sku.name: GP_Gen4,
     GP_Gen5, BC_Gen4, BC_Gen5
    :type sku: ~azure.mgmt.sql.models.Sku
    :ivar provisioning_state: Possible values include: 'Creating', 'Deleting',
     'Updating', 'Unknown', 'Succeeded', 'Failed'
    :vartype provisioning_state: str or ~azure.mgmt.sql.models.enum
    :param managed_instance_create_mode: Specifies the mode of database
     creation.
     Default: Regular instance creation.
     Restore: Creates an instance by restoring a set of backups to specific
     point in time. RestorePointInTime and SourceManagedInstanceId must be
     specified. Possible values include: 'Default', 'PointInTimeRestore'
    :type managed_instance_create_mode: str or
     ~azure.mgmt.sql.models.ManagedServerCreateMode
    :ivar fully_qualified_domain_name: The fully qualified domain name of the
     managed instance.
    :vartype fully_qualified_domain_name: str
    :param administrator_login: Administrator username for the managed
     instance. Can only be specified when the managed instance is being created
     (and is required for creation).
    :type administrator_login: str
    :param administrator_login_password: The administrator login password
     (required for managed instance creation).
    :type administrator_login_password: str
    :param subnet_id: Subnet resource ID for the managed instance.
    :type subnet_id: str
    :ivar state: The state of the managed instance.
    :vartype state: str
    :param license_type: The license type. Possible values are
     'LicenseIncluded' (regular price inclusive of a new SQL license) and
     'BasePrice' (discounted AHB price for bringing your own SQL licenses).
     Possible values include: 'LicenseIncluded', 'BasePrice'
    :type license_type: str or
     ~azure.mgmt.sql.models.ManagedInstanceLicenseType
    :param v_cores: The number of vCores. Allowed values: 8, 16, 24, 32, 40,
     64, 80.
    :type v_cores: int
    :param storage_size_in_gb: Storage size in GB. Minimum value: 32. Maximum
     value: 8192. Increments of 32 GB allowed only.
    :type storage_size_in_gb: int
    :param collation: Collation of the managed instance.
    :type collation: str
    :ivar dns_zone: The Dns Zone that the managed instance is in.
    :vartype dns_zone: str
    :param dns_zone_partner: The resource id of another managed instance whose
     DNS zone this managed instance will share after creation.
    :type dns_zone_partner: str
    :param public_data_endpoint_enabled: Whether or not the public data
     endpoint is enabled.
    :type public_data_endpoint_enabled: bool
    :param source_managed_instance_id: The resource identifier of the source
     managed instance associated with create operation of this instance.
    :type source_managed_instance_id: str
    :param restore_point_in_time: Specifies the point in time (ISO8601 format)
     of the source database that will be restored to create the new database.
    :type restore_point_in_time: datetime
    :param proxy_override: Connection type used for connecting to the
     instance. Possible values include: 'Proxy', 'Redirect', 'Default'
    :type proxy_override: str or
     ~azure.mgmt.sql.models.ManagedInstanceProxyOverride
    :param timezone_id: Id of the timezone. Allowed values are timezones
     supported by Windows.
     Windows keeps details on supported timezones, including the id, in
     registry under
     KEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Time
     Zones.
     You can get those registry values via SQL Server by querying SELECT name
     AS timezone_id FROM sys.time_zone_info.
     List of Ids can also be obtained by executing
     [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
     An example of valid timezone id is "Pacific Standard Time" or "W. Europe
     Standard Time".
    :type timezone_id: str
    :param instance_pool_id: The Id of the instance pool this managed server
     belongs to.
    :type instance_pool_id: str
    :param maintenance_configuration_id: Specifies maintenance configuration
     id to apply to this managed instance.
    :type maintenance_configuration_id: str
    :param minimal_tls_version: Minimal TLS version. Allowed values: 'None',
     '1.0', '1.1', '1.2'
    :type minimal_tls_version: str
    :param storage_account_type: The storage account type used to store
     backups for this instance. The options are LRS (LocallyRedundantStorage),
     ZRS (ZoneRedundantStorage) and GRS (GeoRedundantStorage). Possible values
     include: 'GRS', 'LRS', 'ZRS'
    :type storage_account_type: str or
     ~azure.mgmt.sql.models.StorageAccountType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'fully_qualified_domain_name': {'readonly': True},
        'state': {'readonly': True},
        'dns_zone': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'managed_instance_create_mode': {'key': 'properties.managedInstanceCreateMode', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'v_cores': {'key': 'properties.vCores', 'type': 'int'},
        'storage_size_in_gb': {'key': 'properties.storageSizeInGB', 'type': 'int'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'dns_zone': {'key': 'properties.dnsZone', 'type': 'str'},
        'dns_zone_partner': {'key': 'properties.dnsZonePartner', 'type': 'str'},
        'public_data_endpoint_enabled': {'key': 'properties.publicDataEndpointEnabled', 'type': 'bool'},
        'source_managed_instance_id': {'key': 'properties.sourceManagedInstanceId', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'proxy_override': {'key': 'properties.proxyOverride', 'type': 'str'},
        'timezone_id': {'key': 'properties.timezoneId', 'type': 'str'},
        'instance_pool_id': {'key': 'properties.instancePoolId', 'type': 'str'},
        'maintenance_configuration_id': {'key': 'properties.maintenanceConfigurationId', 'type': 'str'},
        'minimal_tls_version': {'key': 'properties.minimalTlsVersion', 'type': 'str'},
        'storage_account_type': {'key': 'properties.storageAccountType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstance, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.sku = kwargs.get('sku', None)
        self.provisioning_state = None
        self.managed_instance_create_mode = kwargs.get('managed_instance_create_mode', None)
        self.fully_qualified_domain_name = None
        self.administrator_login = kwargs.get('administrator_login', None)
        self.administrator_login_password = kwargs.get('administrator_login_password', None)
        self.subnet_id = kwargs.get('subnet_id', None)
        self.state = None
        self.license_type = kwargs.get('license_type', None)
        self.v_cores = kwargs.get('v_cores', None)
        self.storage_size_in_gb = kwargs.get('storage_size_in_gb', None)
        self.collation = kwargs.get('collation', None)
        self.dns_zone = None
        self.dns_zone_partner = kwargs.get('dns_zone_partner', None)
        self.public_data_endpoint_enabled = kwargs.get('public_data_endpoint_enabled', None)
        self.source_managed_instance_id = kwargs.get('source_managed_instance_id', None)
        self.restore_point_in_time = kwargs.get('restore_point_in_time', None)
        self.proxy_override = kwargs.get('proxy_override', None)
        self.timezone_id = kwargs.get('timezone_id', None)
        self.instance_pool_id = kwargs.get('instance_pool_id', None)
        self.maintenance_configuration_id = kwargs.get('maintenance_configuration_id', None)
        self.minimal_tls_version = kwargs.get('minimal_tls_version', None)
        self.storage_account_type = kwargs.get('storage_account_type', None)


class ManagedInstanceAdministrator(ProxyResource):
    """An Azure SQL managed instance administrator.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar administrator_type: Required. Type of the managed instance
     administrator. Default value: "ActiveDirectory" .
    :vartype administrator_type: str
    :param login: Required. Login name of the managed instance administrator.
    :type login: str
    :param sid: Required. SID (object ID) of the managed instance
     administrator.
    :type sid: str
    :param tenant_id: Tenant ID of the managed instance administrator.
    :type tenant_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'administrator_type': {'required': True, 'constant': True},
        'login': {'required': True},
        'sid': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'administrator_type': {'key': 'properties.administratorType', 'type': 'str'},
        'login': {'key': 'properties.login', 'type': 'str'},
        'sid': {'key': 'properties.sid', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    administrator_type = "ActiveDirectory"

    def __init__(self, **kwargs):
        super(ManagedInstanceAdministrator, self).__init__(**kwargs)
        self.login = kwargs.get('login', None)
        self.sid = kwargs.get('sid', None)
        self.tenant_id = kwargs.get('tenant_id', None)


class ManagedInstanceAzureADOnlyAuthentication(ProxyResource):
    """Azure Active Directory only authentication.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param azure_ad_only_authentication: Required. Azure Active Directory only
     Authentication enabled.
    :type azure_ad_only_authentication: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'azure_ad_only_authentication': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'azure_ad_only_authentication': {'key': 'properties.azureADOnlyAuthentication', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstanceAzureADOnlyAuthentication, self).__init__(**kwargs)
        self.azure_ad_only_authentication = kwargs.get('azure_ad_only_authentication', None)


class ManagedInstanceEditionCapability(Model):
    """The managed server capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The managed server version name.
    :vartype name: str
    :ivar supported_families: The supported families.
    :vartype supported_families:
     list[~azure.mgmt.sql.models.ManagedInstanceFamilyCapability]
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_families': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_families': {'key': 'supportedFamilies', 'type': '[ManagedInstanceFamilyCapability]'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstanceEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_families = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class ManagedInstanceEncryptionProtector(ProxyResource):
    """The managed instance encryption protector.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Kind of encryption protector. This is metadata used for the
     Azure portal experience.
    :vartype kind: str
    :param server_key_name: The name of the managed instance key.
    :type server_key_name: str
    :param server_key_type: Required. The encryption protector type like
     'ServiceManaged', 'AzureKeyVault'. Possible values include:
     'ServiceManaged', 'AzureKeyVault'
    :type server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
    :ivar uri: The URI of the server key.
    :vartype uri: str
    :ivar thumbprint: Thumbprint of the server key.
    :vartype thumbprint: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'server_key_type': {'required': True},
        'uri': {'readonly': True},
        'thumbprint': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'server_key_name': {'key': 'properties.serverKeyName', 'type': 'str'},
        'server_key_type': {'key': 'properties.serverKeyType', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstanceEncryptionProtector, self).__init__(**kwargs)
        self.kind = None
        self.server_key_name = kwargs.get('server_key_name', None)
        self.server_key_type = kwargs.get('server_key_type', None)
        self.uri = None
        self.thumbprint = None


class ManagedInstanceFamilyCapability(Model):
    """The managed server family capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Family name.
    :vartype name: str
    :ivar sku: SKU name.
    :vartype sku: str
    :ivar supported_license_types: List of supported license types.
    :vartype supported_license_types:
     list[~azure.mgmt.sql.models.LicenseTypeCapability]
    :ivar supported_vcores_values: List of supported virtual cores values.
    :vartype supported_vcores_values:
     list[~azure.mgmt.sql.models.ManagedInstanceVcoresCapability]
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'sku': {'readonly': True},
        'supported_license_types': {'readonly': True},
        'supported_vcores_values': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'supported_license_types': {'key': 'supportedLicenseTypes', 'type': '[LicenseTypeCapability]'},
        'supported_vcores_values': {'key': 'supportedVcoresValues', 'type': '[ManagedInstanceVcoresCapability]'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstanceFamilyCapability, self).__init__(**kwargs)
        self.name = None
        self.sku = None
        self.supported_license_types = None
        self.supported_vcores_values = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class ManagedInstanceKey(ProxyResource):
    """A managed instance key.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Kind of encryption protector. This is metadata used for the
     Azure portal experience.
    :vartype kind: str
    :param server_key_type: Required. The key type like 'ServiceManaged',
     'AzureKeyVault'. Possible values include: 'ServiceManaged',
     'AzureKeyVault'
    :type server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
    :param uri: The URI of the key. If the ServerKeyType is AzureKeyVault,
     then the URI is required.
    :type uri: str
    :ivar thumbprint: Thumbprint of the key.
    :vartype thumbprint: str
    :ivar creation_date: The key creation date.
    :vartype creation_date: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'server_key_type': {'required': True},
        'thumbprint': {'readonly': True},
        'creation_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'server_key_type': {'key': 'properties.serverKeyType', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstanceKey, self).__init__(**kwargs)
        self.kind = None
        self.server_key_type = kwargs.get('server_key_type', None)
        self.uri = kwargs.get('uri', None)
        self.thumbprint = None
        self.creation_date = None


class ManagedInstanceLongTermRetentionBackup(ProxyResource):
    """A long term retention backup for a managed database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar managed_instance_name: The managed instance that the backup database
     belongs to.
    :vartype managed_instance_name: str
    :ivar managed_instance_create_time: The create time of the instance.
    :vartype managed_instance_create_time: datetime
    :ivar database_name: The name of the database the backup belong to
    :vartype database_name: str
    :ivar database_deletion_time: The delete time of the database
    :vartype database_deletion_time: datetime
    :ivar backup_time: The time the backup was taken
    :vartype backup_time: datetime
    :ivar backup_expiration_time: The time the long term retention backup will
     expire.
    :vartype backup_expiration_time: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'managed_instance_name': {'readonly': True},
        'managed_instance_create_time': {'readonly': True},
        'database_name': {'readonly': True},
        'database_deletion_time': {'readonly': True},
        'backup_time': {'readonly': True},
        'backup_expiration_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'managed_instance_name': {'key': 'properties.managedInstanceName', 'type': 'str'},
        'managed_instance_create_time': {'key': 'properties.managedInstanceCreateTime', 'type': 'iso-8601'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'database_deletion_time': {'key': 'properties.databaseDeletionTime', 'type': 'iso-8601'},
        'backup_time': {'key': 'properties.backupTime', 'type': 'iso-8601'},
        'backup_expiration_time': {'key': 'properties.backupExpirationTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstanceLongTermRetentionBackup, self).__init__(**kwargs)
        self.managed_instance_name = None
        self.managed_instance_create_time = None
        self.database_name = None
        self.database_deletion_time = None
        self.backup_time = None
        self.backup_expiration_time = None


class ManagedInstanceLongTermRetentionPolicy(ProxyResource):
    """A long term retention policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param weekly_retention: The weekly retention policy for an LTR backup in
     an ISO 8601 format.
    :type weekly_retention: str
    :param monthly_retention: The monthly retention policy for an LTR backup
     in an ISO 8601 format.
    :type monthly_retention: str
    :param yearly_retention: The yearly retention policy for an LTR backup in
     an ISO 8601 format.
    :type yearly_retention: str
    :param week_of_year: The week of year to take the yearly backup in an ISO
     8601 format.
    :type week_of_year: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'weekly_retention': {'key': 'properties.weeklyRetention', 'type': 'str'},
        'monthly_retention': {'key': 'properties.monthlyRetention', 'type': 'str'},
        'yearly_retention': {'key': 'properties.yearlyRetention', 'type': 'str'},
        'week_of_year': {'key': 'properties.weekOfYear', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstanceLongTermRetentionPolicy, self).__init__(**kwargs)
        self.weekly_retention = kwargs.get('weekly_retention', None)
        self.monthly_retention = kwargs.get('monthly_retention', None)
        self.yearly_retention = kwargs.get('yearly_retention', None)
        self.week_of_year = kwargs.get('week_of_year', None)


class ManagedInstanceOperation(ProxyResource):
    """A managed instance operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar managed_instance_name: The name of the managed instance the
     operation is being performed on.
    :vartype managed_instance_name: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar percent_complete: The percentage of the operation completed.
    :vartype percent_complete: int
    :ivar start_time: The operation start time.
    :vartype start_time: datetime
    :ivar state: The operation state. Possible values include: 'Pending',
     'InProgress', 'Succeeded', 'Failed', 'CancelInProgress', 'Cancelled'
    :vartype state: str or ~azure.mgmt.sql.models.ManagementOperationState
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar is_user_error: Whether or not the error is a user error.
    :vartype is_user_error: bool
    :ivar estimated_completion_time: The estimated completion time of the
     operation.
    :vartype estimated_completion_time: datetime
    :ivar description: The operation description.
    :vartype description: str
    :ivar is_cancellable: Whether the operation can be cancelled.
    :vartype is_cancellable: bool
    :ivar operation_parameters: The operation parameters.
    :vartype operation_parameters:
     ~azure.mgmt.sql.models.ManagedInstanceOperationParametersPair
    :ivar operation_steps: The operation steps.
    :vartype operation_steps:
     ~azure.mgmt.sql.models.ManagedInstanceOperationSteps
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'managed_instance_name': {'readonly': True},
        'operation': {'readonly': True},
        'operation_friendly_name': {'readonly': True},
        'percent_complete': {'readonly': True},
        'start_time': {'readonly': True},
        'state': {'readonly': True},
        'error_code': {'readonly': True},
        'error_description': {'readonly': True},
        'error_severity': {'readonly': True},
        'is_user_error': {'readonly': True},
        'estimated_completion_time': {'readonly': True},
        'description': {'readonly': True},
        'is_cancellable': {'readonly': True},
        'operation_parameters': {'readonly': True},
        'operation_steps': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'managed_instance_name': {'key': 'properties.managedInstanceName', 'type': 'str'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'operation_friendly_name': {'key': 'properties.operationFriendlyName', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'error_code': {'key': 'properties.errorCode', 'type': 'int'},
        'error_description': {'key': 'properties.errorDescription', 'type': 'str'},
        'error_severity': {'key': 'properties.errorSeverity', 'type': 'int'},
        'is_user_error': {'key': 'properties.isUserError', 'type': 'bool'},
        'estimated_completion_time': {'key': 'properties.estimatedCompletionTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_cancellable': {'key': 'properties.isCancellable', 'type': 'bool'},
        'operation_parameters': {'key': 'properties.operationParameters', 'type': 'ManagedInstanceOperationParametersPair'},
        'operation_steps': {'key': 'properties.operationSteps', 'type': 'ManagedInstanceOperationSteps'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstanceOperation, self).__init__(**kwargs)
        self.managed_instance_name = None
        self.operation = None
        self.operation_friendly_name = None
        self.percent_complete = None
        self.start_time = None
        self.state = None
        self.error_code = None
        self.error_description = None
        self.error_severity = None
        self.is_user_error = None
        self.estimated_completion_time = None
        self.description = None
        self.is_cancellable = None
        self.operation_parameters = None
        self.operation_steps = None


class ManagedInstanceOperationParametersPair(Model):
    """The parameters of a managed instance operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar current_parameters: The current parameters.
    :vartype current_parameters:
     ~azure.mgmt.sql.models.UpsertManagedServerOperationParameters
    :ivar requested_parameters: The requested parameters.
    :vartype requested_parameters:
     ~azure.mgmt.sql.models.UpsertManagedServerOperationParameters
    """

    _validation = {
        'current_parameters': {'readonly': True},
        'requested_parameters': {'readonly': True},
    }

    _attribute_map = {
        'current_parameters': {'key': 'currentParameters', 'type': 'UpsertManagedServerOperationParameters'},
        'requested_parameters': {'key': 'requestedParameters', 'type': 'UpsertManagedServerOperationParameters'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstanceOperationParametersPair, self).__init__(**kwargs)
        self.current_parameters = None
        self.requested_parameters = None


class ManagedInstanceOperationSteps(Model):
    """The steps of a managed instance operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar total_steps: The total number of operation steps.
    :vartype total_steps: str
    :ivar current_step: The number of current operation steps.
    :vartype current_step: int
    :ivar steps_list: The operation steps list.
    :vartype steps_list:
     list[~azure.mgmt.sql.models.UpsertManagedServerOperationStep]
    """

    _validation = {
        'total_steps': {'readonly': True},
        'current_step': {'readonly': True},
        'steps_list': {'readonly': True},
    }

    _attribute_map = {
        'total_steps': {'key': 'totalSteps', 'type': 'str'},
        'current_step': {'key': 'currentStep', 'type': 'int'},
        'steps_list': {'key': 'stepsList', 'type': '[UpsertManagedServerOperationStep]'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstanceOperationSteps, self).__init__(**kwargs)
        self.total_steps = None
        self.current_step = None
        self.steps_list = None


class ManagedInstancePairInfo(Model):
    """Pairs of Managed Instances in the failover group.

    :param primary_managed_instance_id: Id of Primary Managed Instance in
     pair.
    :type primary_managed_instance_id: str
    :param partner_managed_instance_id: Id of Partner Managed Instance in
     pair.
    :type partner_managed_instance_id: str
    """

    _attribute_map = {
        'primary_managed_instance_id': {'key': 'primaryManagedInstanceId', 'type': 'str'},
        'partner_managed_instance_id': {'key': 'partnerManagedInstanceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstancePairInfo, self).__init__(**kwargs)
        self.primary_managed_instance_id = kwargs.get('primary_managed_instance_id', None)
        self.partner_managed_instance_id = kwargs.get('partner_managed_instance_id', None)


class ManagedInstancePrivateLinkServiceConnectionStateProperty(Model):
    """ManagedInstancePrivateLinkServiceConnectionStateProperty.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The private link service connection status.
    :type status: str
    :param description: Required. The private link service connection
     description.
    :type description: str
    :ivar actions_required: The private link service connection description.
    :vartype actions_required: str
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstancePrivateLinkServiceConnectionStateProperty, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.actions_required = None


class ManagedInstanceUpdate(Model):
    """An update request for an Azure SQL Database managed instance.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param sku: Managed instance sku
    :type sku: ~azure.mgmt.sql.models.Sku
    :ivar provisioning_state: Possible values include: 'Creating', 'Deleting',
     'Updating', 'Unknown', 'Succeeded', 'Failed'
    :vartype provisioning_state: str or ~azure.mgmt.sql.models.enum
    :param managed_instance_create_mode: Specifies the mode of database
     creation.
     Default: Regular instance creation.
     Restore: Creates an instance by restoring a set of backups to specific
     point in time. RestorePointInTime and SourceManagedInstanceId must be
     specified. Possible values include: 'Default', 'PointInTimeRestore'
    :type managed_instance_create_mode: str or
     ~azure.mgmt.sql.models.ManagedServerCreateMode
    :ivar fully_qualified_domain_name: The fully qualified domain name of the
     managed instance.
    :vartype fully_qualified_domain_name: str
    :param administrator_login: Administrator username for the managed
     instance. Can only be specified when the managed instance is being created
     (and is required for creation).
    :type administrator_login: str
    :param administrator_login_password: The administrator login password
     (required for managed instance creation).
    :type administrator_login_password: str
    :param subnet_id: Subnet resource ID for the managed instance.
    :type subnet_id: str
    :ivar state: The state of the managed instance.
    :vartype state: str
    :param license_type: The license type. Possible values are
     'LicenseIncluded' (regular price inclusive of a new SQL license) and
     'BasePrice' (discounted AHB price for bringing your own SQL licenses).
     Possible values include: 'LicenseIncluded', 'BasePrice'
    :type license_type: str or
     ~azure.mgmt.sql.models.ManagedInstanceLicenseType
    :param v_cores: The number of vCores. Allowed values: 8, 16, 24, 32, 40,
     64, 80.
    :type v_cores: int
    :param storage_size_in_gb: Storage size in GB. Minimum value: 32. Maximum
     value: 8192. Increments of 32 GB allowed only.
    :type storage_size_in_gb: int
    :param collation: Collation of the managed instance.
    :type collation: str
    :ivar dns_zone: The Dns Zone that the managed instance is in.
    :vartype dns_zone: str
    :param dns_zone_partner: The resource id of another managed instance whose
     DNS zone this managed instance will share after creation.
    :type dns_zone_partner: str
    :param public_data_endpoint_enabled: Whether or not the public data
     endpoint is enabled.
    :type public_data_endpoint_enabled: bool
    :param source_managed_instance_id: The resource identifier of the source
     managed instance associated with create operation of this instance.
    :type source_managed_instance_id: str
    :param restore_point_in_time: Specifies the point in time (ISO8601 format)
     of the source database that will be restored to create the new database.
    :type restore_point_in_time: datetime
    :param proxy_override: Connection type used for connecting to the
     instance. Possible values include: 'Proxy', 'Redirect', 'Default'
    :type proxy_override: str or
     ~azure.mgmt.sql.models.ManagedInstanceProxyOverride
    :param timezone_id: Id of the timezone. Allowed values are timezones
     supported by Windows.
     Windows keeps details on supported timezones, including the id, in
     registry under
     KEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Time
     Zones.
     You can get those registry values via SQL Server by querying SELECT name
     AS timezone_id FROM sys.time_zone_info.
     List of Ids can also be obtained by executing
     [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
     An example of valid timezone id is "Pacific Standard Time" or "W. Europe
     Standard Time".
    :type timezone_id: str
    :param instance_pool_id: The Id of the instance pool this managed server
     belongs to.
    :type instance_pool_id: str
    :param maintenance_configuration_id: Specifies maintenance configuration
     id to apply to this managed instance.
    :type maintenance_configuration_id: str
    :param minimal_tls_version: Minimal TLS version. Allowed values: 'None',
     '1.0', '1.1', '1.2'
    :type minimal_tls_version: str
    :param storage_account_type: The storage account type used to store
     backups for this instance. The options are LRS (LocallyRedundantStorage),
     ZRS (ZoneRedundantStorage) and GRS (GeoRedundantStorage). Possible values
     include: 'GRS', 'LRS', 'ZRS'
    :type storage_account_type: str or
     ~azure.mgmt.sql.models.StorageAccountType
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'fully_qualified_domain_name': {'readonly': True},
        'state': {'readonly': True},
        'dns_zone': {'readonly': True},
    }

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'managed_instance_create_mode': {'key': 'properties.managedInstanceCreateMode', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'v_cores': {'key': 'properties.vCores', 'type': 'int'},
        'storage_size_in_gb': {'key': 'properties.storageSizeInGB', 'type': 'int'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'dns_zone': {'key': 'properties.dnsZone', 'type': 'str'},
        'dns_zone_partner': {'key': 'properties.dnsZonePartner', 'type': 'str'},
        'public_data_endpoint_enabled': {'key': 'properties.publicDataEndpointEnabled', 'type': 'bool'},
        'source_managed_instance_id': {'key': 'properties.sourceManagedInstanceId', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'proxy_override': {'key': 'properties.proxyOverride', 'type': 'str'},
        'timezone_id': {'key': 'properties.timezoneId', 'type': 'str'},
        'instance_pool_id': {'key': 'properties.instancePoolId', 'type': 'str'},
        'maintenance_configuration_id': {'key': 'properties.maintenanceConfigurationId', 'type': 'str'},
        'minimal_tls_version': {'key': 'properties.minimalTlsVersion', 'type': 'str'},
        'storage_account_type': {'key': 'properties.storageAccountType', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstanceUpdate, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.provisioning_state = None
        self.managed_instance_create_mode = kwargs.get('managed_instance_create_mode', None)
        self.fully_qualified_domain_name = None
        self.administrator_login = kwargs.get('administrator_login', None)
        self.administrator_login_password = kwargs.get('administrator_login_password', None)
        self.subnet_id = kwargs.get('subnet_id', None)
        self.state = None
        self.license_type = kwargs.get('license_type', None)
        self.v_cores = kwargs.get('v_cores', None)
        self.storage_size_in_gb = kwargs.get('storage_size_in_gb', None)
        self.collation = kwargs.get('collation', None)
        self.dns_zone = None
        self.dns_zone_partner = kwargs.get('dns_zone_partner', None)
        self.public_data_endpoint_enabled = kwargs.get('public_data_endpoint_enabled', None)
        self.source_managed_instance_id = kwargs.get('source_managed_instance_id', None)
        self.restore_point_in_time = kwargs.get('restore_point_in_time', None)
        self.proxy_override = kwargs.get('proxy_override', None)
        self.timezone_id = kwargs.get('timezone_id', None)
        self.instance_pool_id = kwargs.get('instance_pool_id', None)
        self.maintenance_configuration_id = kwargs.get('maintenance_configuration_id', None)
        self.minimal_tls_version = kwargs.get('minimal_tls_version', None)
        self.storage_account_type = kwargs.get('storage_account_type', None)
        self.tags = kwargs.get('tags', None)


class ManagedInstanceVcoresCapability(Model):
    """The managed instance virtual cores capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The virtual cores identifier.
    :vartype name: str
    :ivar value: The virtual cores value.
    :vartype value: int
    :ivar included_max_size: Included size.
    :vartype included_max_size: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar supported_storage_sizes: Storage size ranges.
    :vartype supported_storage_sizes:
     list[~azure.mgmt.sql.models.MaxSizeRangeCapability]
    :ivar instance_pool_supported: True if this service objective is supported
     for managed instances in an instance pool.
    :vartype instance_pool_supported: bool
    :ivar standalone_supported: True if this service objective is supported
     for standalone managed instances.
    :vartype standalone_supported: bool
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
        'included_max_size': {'readonly': True},
        'supported_storage_sizes': {'readonly': True},
        'instance_pool_supported': {'readonly': True},
        'standalone_supported': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
        'included_max_size': {'key': 'includedMaxSize', 'type': 'MaxSizeCapability'},
        'supported_storage_sizes': {'key': 'supportedStorageSizes', 'type': '[MaxSizeRangeCapability]'},
        'instance_pool_supported': {'key': 'instancePoolSupported', 'type': 'bool'},
        'standalone_supported': {'key': 'standaloneSupported', 'type': 'bool'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstanceVcoresCapability, self).__init__(**kwargs)
        self.name = None
        self.value = None
        self.included_max_size = None
        self.supported_storage_sizes = None
        self.instance_pool_supported = None
        self.standalone_supported = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class ManagedInstanceVersionCapability(Model):
    """The managed instance capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The server version name.
    :vartype name: str
    :ivar supported_editions: The list of supported managed instance editions.
    :vartype supported_editions:
     list[~azure.mgmt.sql.models.ManagedInstanceEditionCapability]
    :ivar supported_instance_pool_editions: The list of supported instance
     pool editions.
    :vartype supported_instance_pool_editions:
     list[~azure.mgmt.sql.models.InstancePoolEditionCapability]
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_editions': {'readonly': True},
        'supported_instance_pool_editions': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_editions': {'key': 'supportedEditions', 'type': '[ManagedInstanceEditionCapability]'},
        'supported_instance_pool_editions': {'key': 'supportedInstancePoolEditions', 'type': '[InstancePoolEditionCapability]'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstanceVersionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_editions = None
        self.supported_instance_pool_editions = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class ManagedInstanceVulnerabilityAssessment(ProxyResource):
    """A managed instance vulnerability assessment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param storage_container_path: Required. A blob storage container path to
     hold the scan results (e.g.
     https://myStorage.blob.core.windows.net/VaScans/).
    :type storage_container_path: str
    :param storage_container_sas_key: A shared access signature (SAS Key) that
     has read and write access to the blob container specified in
     'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't
     specified, StorageContainerSasKey is required.
    :type storage_container_sas_key: str
    :param storage_account_access_key: Specifies the identifier key of the
     storage account for vulnerability assessment scan results. If
     'StorageContainerSasKey' isn't specified, storageAccountAccessKey is
     required.
    :type storage_account_access_key: str
    :param recurring_scans: The recurring scans settings
    :type recurring_scans:
     ~azure.mgmt.sql.models.VulnerabilityAssessmentRecurringScansProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'storage_container_path': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'storage_container_sas_key': {'key': 'properties.storageContainerSasKey', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'recurring_scans': {'key': 'properties.recurringScans', 'type': 'VulnerabilityAssessmentRecurringScansProperties'},
    }

    def __init__(self, **kwargs):
        super(ManagedInstanceVulnerabilityAssessment, self).__init__(**kwargs)
        self.storage_container_path = kwargs.get('storage_container_path', None)
        self.storage_container_sas_key = kwargs.get('storage_container_sas_key', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.recurring_scans = kwargs.get('recurring_scans', None)


class ManagedServerSecurityAlertPolicy(ProxyResource):
    """A managed server security alert policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param state: Required. Specifies the state of the policy, whether it is
     enabled or disabled or a policy has not been applied yet on the specific
     database. Possible values include: 'New', 'Enabled', 'Disabled'
    :type state: str or ~azure.mgmt.sql.models.SecurityAlertPolicyState
    :param disabled_alerts: Specifies an array of alerts that are disabled.
     Allowed values are: Sql_Injection, Sql_Injection_Vulnerability,
     Access_Anomaly, Data_Exfiltration, Unsafe_Action
    :type disabled_alerts: list[str]
    :param email_addresses: Specifies an array of e-mail addresses to which
     the alert is sent.
    :type email_addresses: list[str]
    :param email_account_admins: Specifies that the alert is sent to the
     account administrators.
    :type email_account_admins: bool
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all
     Threat Detection audit logs.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the
     Threat Detection audit storage account.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the Threat
     Detection audit logs.
    :type retention_days: int
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'required': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'SecurityAlertPolicyState'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': '[str]'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': '[str]'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'bool'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ManagedServerSecurityAlertPolicy, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.disabled_alerts = kwargs.get('disabled_alerts', None)
        self.email_addresses = kwargs.get('email_addresses', None)
        self.email_account_admins = kwargs.get('email_account_admins', None)
        self.storage_endpoint = kwargs.get('storage_endpoint', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.retention_days = kwargs.get('retention_days', None)
        self.creation_time = None


class MaxSizeCapability(Model):
    """The maximum size capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar limit: The maximum size limit (see 'unit' for the units).
    :vartype limit: int
    :ivar unit: The units that the limit is expressed in. Possible values
     include: 'Megabytes', 'Gigabytes', 'Terabytes', 'Petabytes'
    :vartype unit: str or ~azure.mgmt.sql.models.MaxSizeUnit
    """

    _validation = {
        'limit': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'int'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MaxSizeCapability, self).__init__(**kwargs)
        self.limit = None
        self.unit = None


class MaxSizeRangeCapability(Model):
    """The maximum size range capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar min_value: Minimum value.
    :vartype min_value: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar max_value: Maximum value.
    :vartype max_value: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar scale_size: Scale/step size for discrete values between the minimum
     value and the maximum value.
    :vartype scale_size: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar log_size: Size of transaction log.
    :vartype log_size: ~azure.mgmt.sql.models.LogSizeCapability
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'min_value': {'readonly': True},
        'max_value': {'readonly': True},
        'scale_size': {'readonly': True},
        'log_size': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'min_value': {'key': 'minValue', 'type': 'MaxSizeCapability'},
        'max_value': {'key': 'maxValue', 'type': 'MaxSizeCapability'},
        'scale_size': {'key': 'scaleSize', 'type': 'MaxSizeCapability'},
        'log_size': {'key': 'logSize', 'type': 'LogSizeCapability'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MaxSizeRangeCapability, self).__init__(**kwargs)
        self.min_value = None
        self.max_value = None
        self.scale_size = None
        self.log_size = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class Metric(Model):
    """Database metrics.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: datetime
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: datetime
    :ivar time_grain: The time step to be used to summarize the metric values.
    :vartype time_grain: str
    :ivar unit: The unit of the metric. Possible values include: 'count',
     'bytes', 'seconds', 'percent', 'countPerSecond', 'bytesPerSecond'
    :vartype unit: str or ~azure.mgmt.sql.models.UnitType
    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.sql.models.MetricName
    :ivar metric_values: The metric values for the specified time window and
     timestep.
    :vartype metric_values: list[~azure.mgmt.sql.models.MetricValue]
    """

    _validation = {
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'time_grain': {'readonly': True},
        'unit': {'readonly': True},
        'name': {'readonly': True},
        'metric_values': {'readonly': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'name': {'key': 'name', 'type': 'MetricName'},
        'metric_values': {'key': 'metricValues', 'type': '[MetricValue]'},
    }

    def __init__(self, **kwargs):
        super(Metric, self).__init__(**kwargs)
        self.start_time = None
        self.end_time = None
        self.time_grain = None
        self.unit = None
        self.name = None
        self.metric_values = None


class MetricAvailability(Model):
    """A metric availability value.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar retention: The length of retention for the database metric.
    :vartype retention: str
    :ivar time_grain: The granularity of the database metric.
    :vartype time_grain: str
    """

    _validation = {
        'retention': {'readonly': True},
        'time_grain': {'readonly': True},
    }

    _attribute_map = {
        'retention': {'key': 'retention', 'type': 'str'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MetricAvailability, self).__init__(**kwargs)
        self.retention = None
        self.time_grain = None


class MetricDefinition(Model):
    """A database metric definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.sql.models.MetricName
    :ivar primary_aggregation_type: The primary aggregation type defining how
     metric values are displayed. Possible values include: 'None', 'Average',
     'Count', 'Minimum', 'Maximum', 'Total'
    :vartype primary_aggregation_type: str or
     ~azure.mgmt.sql.models.PrimaryAggregationType
    :ivar resource_uri: The resource uri of the database.
    :vartype resource_uri: str
    :ivar unit: The unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond'
    :vartype unit: str or ~azure.mgmt.sql.models.UnitDefinitionType
    :ivar metric_availabilities: The list of database metric availabilities
     for the metric.
    :vartype metric_availabilities:
     list[~azure.mgmt.sql.models.MetricAvailability]
    """

    _validation = {
        'name': {'readonly': True},
        'primary_aggregation_type': {'readonly': True},
        'resource_uri': {'readonly': True},
        'unit': {'readonly': True},
        'metric_availabilities': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'MetricName'},
        'primary_aggregation_type': {'key': 'primaryAggregationType', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'metric_availabilities': {'key': 'metricAvailabilities', 'type': '[MetricAvailability]'},
    }

    def __init__(self, **kwargs):
        super(MetricDefinition, self).__init__(**kwargs)
        self.name = None
        self.primary_aggregation_type = None
        self.resource_uri = None
        self.unit = None
        self.metric_availabilities = None


class MetricName(Model):
    """A database metric name.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: The name of the database metric.
    :vartype value: str
    :ivar localized_value: The friendly name of the database metric.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MetricName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class MetricValue(Model):
    """Represents database metrics.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar count: The number of values for the metric.
    :vartype count: float
    :ivar average: The average value of the metric.
    :vartype average: float
    :ivar maximum: The max value of the metric.
    :vartype maximum: float
    :ivar minimum: The min value of the metric.
    :vartype minimum: float
    :ivar timestamp: The metric timestamp (ISO-8601 format).
    :vartype timestamp: datetime
    :ivar total: The total value of the metric.
    :vartype total: float
    """

    _validation = {
        'count': {'readonly': True},
        'average': {'readonly': True},
        'maximum': {'readonly': True},
        'minimum': {'readonly': True},
        'timestamp': {'readonly': True},
        'total': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'float'},
        'average': {'key': 'average', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'total': {'key': 'total', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(MetricValue, self).__init__(**kwargs)
        self.count = None
        self.average = None
        self.maximum = None
        self.minimum = None
        self.timestamp = None
        self.total = None


class MinCapacityCapability(Model):
    """The min capacity capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: Min capacity value
    :vartype value: float
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'value': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'float'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MinCapacityCapability, self).__init__(**kwargs)
        self.value = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class Name(Model):
    """ARM Usage Name.

    :param value: Usage name value
    :type value: str
    :param localized_value: Usage name localized value.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Name, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class NetworkIsolationSettings(Model):
    """Contains the ARM resources for which to create private endpoint connection.

    :param storage_account_resource_id: The resource id for the storage
     account used to store BACPAC file. If set, private endpoint connection
     will be created for the storage account. Must match storage account used
     for StorageUri parameter.
    :type storage_account_resource_id: str
    :param sql_server_resource_id: The resource id for the SQL server which is
     the target of this request. If set, private endpoint connection will be
     created for the SQL server. Must match server which is target of the
     operation.
    :type sql_server_resource_id: str
    """

    _attribute_map = {
        'storage_account_resource_id': {'key': 'storageAccountResourceId', 'type': 'str'},
        'sql_server_resource_id': {'key': 'sqlServerResourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NetworkIsolationSettings, self).__init__(**kwargs)
        self.storage_account_resource_id = kwargs.get('storage_account_resource_id', None)
        self.sql_server_resource_id = kwargs.get('sql_server_resource_id', None)


class Operation(Model):
    """SQL REST API operation definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the operation being performed on this particular
     object.
    :vartype name: str
    :ivar display: The localized display information for this particular
     operation / action.
    :vartype display: ~azure.mgmt.sql.models.OperationDisplay
    :ivar origin: The intended executor of the operation. Possible values
     include: 'user', 'system'
    :vartype origin: str or ~azure.mgmt.sql.models.OperationOrigin
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, object]
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
        'origin': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.origin = None
        self.properties = None


class OperationDisplay(Model):
    """Display metadata associated with the operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provider: The localized friendly form of the resource provider name.
    :vartype provider: str
    :ivar resource: The localized friendly form of the resource type related
     to this action/operation.
    :vartype resource: str
    :ivar operation: The localized friendly name for the operation.
    :vartype operation: str
    :ivar description: The localized friendly description for the operation.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationImpact(Model):
    """The impact of an operation, both in absolute and relative terms.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the impact dimension.
    :vartype name: str
    :ivar unit: The unit in which estimated impact to dimension is measured.
    :vartype unit: str
    :ivar change_value_absolute: The absolute impact to dimension.
    :vartype change_value_absolute: float
    :ivar change_value_relative: The relative impact to dimension (null if not
     applicable)
    :vartype change_value_relative: float
    """

    _validation = {
        'name': {'readonly': True},
        'unit': {'readonly': True},
        'change_value_absolute': {'readonly': True},
        'change_value_relative': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'change_value_absolute': {'key': 'changeValueAbsolute', 'type': 'float'},
        'change_value_relative': {'key': 'changeValueRelative', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(OperationImpact, self).__init__(**kwargs)
        self.name = None
        self.unit = None
        self.change_value_absolute = None
        self.change_value_relative = None


class PartnerInfo(Model):
    """Partner server information for the failover group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Resource identifier of the partner server.
    :type id: str
    :ivar location: Geo location of the partner server.
    :vartype location: str
    :ivar replication_role: Replication role of the partner server. Possible
     values include: 'Primary', 'Secondary'
    :vartype replication_role: str or
     ~azure.mgmt.sql.models.FailoverGroupReplicationRole
    """

    _validation = {
        'id': {'required': True},
        'location': {'readonly': True},
        'replication_role': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'replication_role': {'key': 'replicationRole', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PartnerInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.location = None
        self.replication_role = None


class PartnerRegionInfo(Model):
    """Partner region information for the failover group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param location: Geo location of the partner managed instances.
    :type location: str
    :ivar replication_role: Replication role of the partner managed instances.
     Possible values include: 'Primary', 'Secondary'
    :vartype replication_role: str or
     ~azure.mgmt.sql.models.InstanceFailoverGroupReplicationRole
    """

    _validation = {
        'replication_role': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'replication_role': {'key': 'replicationRole', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PartnerRegionInfo, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.replication_role = None


class PerformanceLevelCapability(Model):
    """The performance level capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: Performance level value.
    :vartype value: float
    :ivar unit: Unit type used to measure performance level. Possible values
     include: 'DTU', 'VCores'
    :vartype unit: str or ~azure.mgmt.sql.models.PerformanceLevelUnit
    """

    _validation = {
        'value': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PerformanceLevelCapability, self).__init__(**kwargs)
        self.value = None
        self.unit = None


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param private_endpoint: Private endpoint which the connection belongs to.
    :type private_endpoint: ~azure.mgmt.sql.models.PrivateEndpointProperty
    :param private_link_service_connection_state: Connection state of the
     private endpoint connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.sql.models.PrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection.
     Possible values include: 'Approving', 'Ready', 'Dropping', 'Failed',
     'Rejecting'
    :vartype provisioning_state: str or
     ~azure.mgmt.sql.models.PrivateEndpointProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionStateProperty'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = None


class PrivateEndpointConnectionProperties(Model):
    """Properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param private_endpoint: Private endpoint which the connection belongs to.
    :type private_endpoint: ~azure.mgmt.sql.models.PrivateEndpointProperty
    :param private_link_service_connection_state: Connection state of the
     private endpoint connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.sql.models.PrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection.
     Possible values include: 'Approving', 'Ready', 'Dropping', 'Failed',
     'Rejecting'
    :vartype provisioning_state: str or
     ~azure.mgmt.sql.models.PrivateEndpointProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionStateProperty'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpointConnectionProperties, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = None


class PrivateEndpointConnectionRequestStatus(Model):
    """Contains the private endpoint connection requests status.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar private_link_service_id: Resource id for which the private endpoint
     is created.
    :vartype private_link_service_id: str
    :ivar private_endpoint_connection_name: The connection name for the
     private endpoint.
    :vartype private_endpoint_connection_name: str
    :ivar status: Status of this private endpoint connection.
    :vartype status: str
    """

    _validation = {
        'private_link_service_id': {'readonly': True},
        'private_endpoint_connection_name': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'private_link_service_id': {'key': 'privateLinkServiceId', 'type': 'str'},
        'private_endpoint_connection_name': {'key': 'privateEndpointConnectionName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpointConnectionRequestStatus, self).__init__(**kwargs)
        self.private_link_service_id = None
        self.private_endpoint_connection_name = None
        self.status = None


class PrivateEndpointProperty(Model):
    """PrivateEndpointProperty.

    :param id: Resource id of the private endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpointProperty, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class PrivateLinkResource(ProxyResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: The private link resource group id.
    :vartype properties: ~azure.mgmt.sql.models.PrivateLinkResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateLinkResourceProperties'},
    }

    def __init__(self, **kwargs):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.properties = None


class PrivateLinkResourceProperties(Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(PrivateLinkResourceProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None


class PrivateLinkServiceConnectionStateProperty(Model):
    """PrivateLinkServiceConnectionStateProperty.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The private link service connection status.
     Possible values include: 'Approved', 'Pending', 'Rejected', 'Disconnected'
    :type status: str or
     ~azure.mgmt.sql.models.PrivateLinkServiceConnectionStateStatus
    :param description: Required. The private link service connection
     description.
    :type description: str
    :ivar actions_required: The actions required for private link service
     connection. Possible values include: 'None'
    :vartype actions_required: str or
     ~azure.mgmt.sql.models.PrivateLinkServiceConnectionStateActionsRequire
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateLinkServiceConnectionStateProperty, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.actions_required = None


class ReadScaleCapability(Model):
    """The read scale capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar max_number_of_replicas: The maximum number of read scale replicas.
    :vartype max_number_of_replicas: int
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'max_number_of_replicas': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'max_number_of_replicas': {'key': 'maxNumberOfReplicas', 'type': 'int'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReadScaleCapability, self).__init__(**kwargs)
        self.max_number_of_replicas = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class RecommendedElasticPool(ProxyResource):
    """Represents a recommended elastic pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar database_edition: The edition of the recommended elastic pool. The
     ElasticPoolEdition enumeration contains all the valid editions. Possible
     values include: 'Basic', 'Standard', 'Premium', 'GeneralPurpose',
     'BusinessCritical'
    :vartype database_edition: str or
     ~azure.mgmt.sql.models.ElasticPoolEdition
    :param dtu: The DTU for the recommended elastic pool.
    :type dtu: float
    :param database_dtu_min: The minimum DTU for the database.
    :type database_dtu_min: float
    :param database_dtu_max: The maximum DTU for the database.
    :type database_dtu_max: float
    :param storage_mb: Gets storage size in megabytes.
    :type storage_mb: float
    :ivar observation_period_start: The observation period start (ISO8601
     format).
    :vartype observation_period_start: datetime
    :ivar observation_period_end: The observation period start (ISO8601
     format).
    :vartype observation_period_end: datetime
    :ivar max_observed_dtu: Gets maximum observed DTU.
    :vartype max_observed_dtu: float
    :ivar max_observed_storage_mb: Gets maximum observed storage in megabytes.
    :vartype max_observed_storage_mb: float
    :ivar databases: The list of databases in this pool. Expanded property
    :vartype databases: list[~azure.mgmt.sql.models.TrackedResource]
    :ivar metrics: The list of databases housed in the server. Expanded
     property
    :vartype metrics:
     list[~azure.mgmt.sql.models.RecommendedElasticPoolMetric]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'database_edition': {'readonly': True},
        'observation_period_start': {'readonly': True},
        'observation_period_end': {'readonly': True},
        'max_observed_dtu': {'readonly': True},
        'max_observed_storage_mb': {'readonly': True},
        'databases': {'readonly': True},
        'metrics': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'database_edition': {'key': 'properties.databaseEdition', 'type': 'str'},
        'dtu': {'key': 'properties.dtu', 'type': 'float'},
        'database_dtu_min': {'key': 'properties.databaseDtuMin', 'type': 'float'},
        'database_dtu_max': {'key': 'properties.databaseDtuMax', 'type': 'float'},
        'storage_mb': {'key': 'properties.storageMB', 'type': 'float'},
        'observation_period_start': {'key': 'properties.observationPeriodStart', 'type': 'iso-8601'},
        'observation_period_end': {'key': 'properties.observationPeriodEnd', 'type': 'iso-8601'},
        'max_observed_dtu': {'key': 'properties.maxObservedDtu', 'type': 'float'},
        'max_observed_storage_mb': {'key': 'properties.maxObservedStorageMB', 'type': 'float'},
        'databases': {'key': 'properties.databases', 'type': '[TrackedResource]'},
        'metrics': {'key': 'properties.metrics', 'type': '[RecommendedElasticPoolMetric]'},
    }

    def __init__(self, **kwargs):
        super(RecommendedElasticPool, self).__init__(**kwargs)
        self.database_edition = None
        self.dtu = kwargs.get('dtu', None)
        self.database_dtu_min = kwargs.get('database_dtu_min', None)
        self.database_dtu_max = kwargs.get('database_dtu_max', None)
        self.storage_mb = kwargs.get('storage_mb', None)
        self.observation_period_start = None
        self.observation_period_end = None
        self.max_observed_dtu = None
        self.max_observed_storage_mb = None
        self.databases = None
        self.metrics = None


class RecommendedElasticPoolMetric(Model):
    """Represents recommended elastic pool metric.

    :param date_time_property: The time of metric (ISO8601 format).
    :type date_time_property: datetime
    :param dtu: Gets or sets the DTUs (Database Transaction Units). See
     https://azure.microsoft.com/documentation/articles/sql-database-what-is-a-dtu/
    :type dtu: float
    :param size_gb: Gets or sets size in gigabytes.
    :type size_gb: float
    """

    _attribute_map = {
        'date_time_property': {'key': 'dateTime', 'type': 'iso-8601'},
        'dtu': {'key': 'dtu', 'type': 'float'},
        'size_gb': {'key': 'sizeGB', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(RecommendedElasticPoolMetric, self).__init__(**kwargs)
        self.date_time_property = kwargs.get('date_time_property', None)
        self.dtu = kwargs.get('dtu', None)
        self.size_gb = kwargs.get('size_gb', None)


class RecommendedIndex(ProxyResource):
    """Represents a database recommended index.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar action: The proposed index action. You can create a missing index,
     drop an unused index, or rebuild an existing index to improve its
     performance. Possible values include: 'Create', 'Drop', 'Rebuild'
    :vartype action: str or ~azure.mgmt.sql.models.RecommendedIndexAction
    :ivar state: The current recommendation state. Possible values include:
     'Active', 'Pending', 'Executing', 'Verifying', 'Pending Revert',
     'Reverting', 'Reverted', 'Ignored', 'Expired', 'Blocked', 'Success'
    :vartype state: str or ~azure.mgmt.sql.models.RecommendedIndexState
    :ivar created: The UTC datetime showing when this resource was created
     (ISO8601 format).
    :vartype created: datetime
    :ivar last_modified: The UTC datetime of when was this resource last
     changed (ISO8601 format).
    :vartype last_modified: datetime
    :ivar index_type: The type of index (CLUSTERED, NONCLUSTERED, COLUMNSTORE,
     CLUSTERED COLUMNSTORE). Possible values include: 'CLUSTERED',
     'NONCLUSTERED', 'COLUMNSTORE', 'CLUSTERED COLUMNSTORE'
    :vartype index_type: str or ~azure.mgmt.sql.models.RecommendedIndexType
    :ivar schema: The schema where table to build index over resides
    :vartype schema: str
    :ivar table: The table on which to build index.
    :vartype table: str
    :ivar columns: Columns over which to build index
    :vartype columns: list[str]
    :ivar included_columns: The list of column names to be included in the
     index
    :vartype included_columns: list[str]
    :ivar index_script: The full build index script
    :vartype index_script: str
    :ivar estimated_impact: The estimated impact of doing recommended index
     action.
    :vartype estimated_impact: list[~azure.mgmt.sql.models.OperationImpact]
    :ivar reported_impact: The values reported after index action is complete.
    :vartype reported_impact: list[~azure.mgmt.sql.models.OperationImpact]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'action': {'readonly': True},
        'state': {'readonly': True},
        'created': {'readonly': True},
        'last_modified': {'readonly': True},
        'index_type': {'readonly': True},
        'schema': {'readonly': True},
        'table': {'readonly': True},
        'columns': {'readonly': True},
        'included_columns': {'readonly': True},
        'index_script': {'readonly': True},
        'estimated_impact': {'readonly': True},
        'reported_impact': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'action': {'key': 'properties.action', 'type': 'RecommendedIndexAction'},
        'state': {'key': 'properties.state', 'type': 'RecommendedIndexState'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'last_modified': {'key': 'properties.lastModified', 'type': 'iso-8601'},
        'index_type': {'key': 'properties.indexType', 'type': 'RecommendedIndexType'},
        'schema': {'key': 'properties.schema', 'type': 'str'},
        'table': {'key': 'properties.table', 'type': 'str'},
        'columns': {'key': 'properties.columns', 'type': '[str]'},
        'included_columns': {'key': 'properties.includedColumns', 'type': '[str]'},
        'index_script': {'key': 'properties.indexScript', 'type': 'str'},
        'estimated_impact': {'key': 'properties.estimatedImpact', 'type': '[OperationImpact]'},
        'reported_impact': {'key': 'properties.reportedImpact', 'type': '[OperationImpact]'},
    }

    def __init__(self, **kwargs):
        super(RecommendedIndex, self).__init__(**kwargs)
        self.action = None
        self.state = None
        self.created = None
        self.last_modified = None
        self.index_type = None
        self.schema = None
        self.table = None
        self.columns = None
        self.included_columns = None
        self.index_script = None
        self.estimated_impact = None
        self.reported_impact = None


class RecoverableDatabase(ProxyResource):
    """A recoverable database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar edition: The edition of the database
    :vartype edition: str
    :ivar service_level_objective: The service level objective name of the
     database
    :vartype service_level_objective: str
    :ivar elastic_pool_name: The elastic pool name of the database
    :vartype elastic_pool_name: str
    :ivar last_available_backup_date: The last available backup date of the
     database (ISO8601 format)
    :vartype last_available_backup_date: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'edition': {'readonly': True},
        'service_level_objective': {'readonly': True},
        'elastic_pool_name': {'readonly': True},
        'last_available_backup_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'edition': {'key': 'properties.edition', 'type': 'str'},
        'service_level_objective': {'key': 'properties.serviceLevelObjective', 'type': 'str'},
        'elastic_pool_name': {'key': 'properties.elasticPoolName', 'type': 'str'},
        'last_available_backup_date': {'key': 'properties.lastAvailableBackupDate', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(RecoverableDatabase, self).__init__(**kwargs)
        self.edition = None
        self.service_level_objective = None
        self.elastic_pool_name = None
        self.last_available_backup_date = None


class RecoverableManagedDatabase(ProxyResource):
    """A recoverable managed database resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar last_available_backup_date: The last available backup date.
    :vartype last_available_backup_date: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_available_backup_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'last_available_backup_date': {'key': 'properties.lastAvailableBackupDate', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RecoverableManagedDatabase, self).__init__(**kwargs)
        self.last_available_backup_date = None


class ReplicationLink(ProxyResource):
    """Represents a database replication link.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Location of the server that contains this firewall rule.
    :vartype location: str
    :ivar is_termination_allowed: Legacy value indicating whether termination
     is allowed.  Currently always returns true.
    :vartype is_termination_allowed: bool
    :ivar replication_mode: Replication mode of this replication link.
    :vartype replication_mode: str
    :ivar partner_server: The name of the server hosting the partner database.
    :vartype partner_server: str
    :ivar partner_database: The name of the partner database.
    :vartype partner_database: str
    :ivar partner_location: The Azure Region of the partner database.
    :vartype partner_location: str
    :ivar role: The role of the database in the replication link. Possible
     values include: 'Primary', 'Secondary', 'NonReadableSecondary', 'Source',
     'Copy'
    :vartype role: str or ~azure.mgmt.sql.models.ReplicationRole
    :ivar partner_role: The role of the partner database in the replication
     link. Possible values include: 'Primary', 'Secondary',
     'NonReadableSecondary', 'Source', 'Copy'
    :vartype partner_role: str or ~azure.mgmt.sql.models.ReplicationRole
    :ivar start_time: The start time for the replication link.
    :vartype start_time: datetime
    :ivar percent_complete: The percentage of seeding complete for the
     replication link.
    :vartype percent_complete: int
    :ivar replication_state: The replication state for the replication link.
     Possible values include: 'PENDING', 'SEEDING', 'CATCH_UP', 'SUSPENDED'
    :vartype replication_state: str or ~azure.mgmt.sql.models.ReplicationState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'is_termination_allowed': {'readonly': True},
        'replication_mode': {'readonly': True},
        'partner_server': {'readonly': True},
        'partner_database': {'readonly': True},
        'partner_location': {'readonly': True},
        'role': {'readonly': True},
        'partner_role': {'readonly': True},
        'start_time': {'readonly': True},
        'percent_complete': {'readonly': True},
        'replication_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'is_termination_allowed': {'key': 'properties.isTerminationAllowed', 'type': 'bool'},
        'replication_mode': {'key': 'properties.replicationMode', 'type': 'str'},
        'partner_server': {'key': 'properties.partnerServer', 'type': 'str'},
        'partner_database': {'key': 'properties.partnerDatabase', 'type': 'str'},
        'partner_location': {'key': 'properties.partnerLocation', 'type': 'str'},
        'role': {'key': 'properties.role', 'type': 'ReplicationRole'},
        'partner_role': {'key': 'properties.partnerRole', 'type': 'ReplicationRole'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'replication_state': {'key': 'properties.replicationState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReplicationLink, self).__init__(**kwargs)
        self.location = None
        self.is_termination_allowed = None
        self.replication_mode = None
        self.partner_server = None
        self.partner_database = None
        self.partner_location = None
        self.role = None
        self.partner_role = None
        self.start_time = None
        self.percent_complete = None
        self.replication_state = None


class ResourceIdentity(Model):
    """Azure Active Directory identity configuration for a resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The Azure Active Directory principal id.
    :vartype principal_id: str
    :param type: The identity type. Set this to 'SystemAssigned' in order to
     automatically create and assign an Azure Active Directory principal for
     the resource. Possible values include: 'SystemAssigned'
    :type type: str or ~azure.mgmt.sql.models.IdentityType
    :ivar tenant_id: The Azure Active Directory tenant id.
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.type = kwargs.get('type', None)
        self.tenant_id = None


class ResourceMoveDefinition(Model):
    """Contains the information necessary to perform a resource move (rename).

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The target ID for the resource
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceMoveDefinition, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class RestorableDroppedDatabase(ProxyResource):
    """A restorable dropped database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: The geo-location where the resource lives
    :vartype location: str
    :ivar database_name: The name of the database
    :vartype database_name: str
    :ivar edition: The edition of the database
    :vartype edition: str
    :ivar max_size_bytes: The max size in bytes of the database
    :vartype max_size_bytes: str
    :ivar service_level_objective: The service level objective name of the
     database
    :vartype service_level_objective: str
    :ivar elastic_pool_name: The elastic pool name of the database
    :vartype elastic_pool_name: str
    :ivar creation_date: The creation date of the database (ISO8601 format)
    :vartype creation_date: datetime
    :ivar deletion_date: The deletion date of the database (ISO8601 format)
    :vartype deletion_date: datetime
    :ivar earliest_restore_date: The earliest restore date of the database
     (ISO8601 format)
    :vartype earliest_restore_date: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'database_name': {'readonly': True},
        'edition': {'readonly': True},
        'max_size_bytes': {'readonly': True},
        'service_level_objective': {'readonly': True},
        'elastic_pool_name': {'readonly': True},
        'creation_date': {'readonly': True},
        'deletion_date': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'edition': {'key': 'properties.edition', 'type': 'str'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'str'},
        'service_level_objective': {'key': 'properties.serviceLevelObjective', 'type': 'str'},
        'elastic_pool_name': {'key': 'properties.elasticPoolName', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'deletion_date': {'key': 'properties.deletionDate', 'type': 'iso-8601'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(RestorableDroppedDatabase, self).__init__(**kwargs)
        self.location = None
        self.database_name = None
        self.edition = None
        self.max_size_bytes = None
        self.service_level_objective = None
        self.elastic_pool_name = None
        self.creation_date = None
        self.deletion_date = None
        self.earliest_restore_date = None


class RestorableDroppedManagedDatabase(TrackedResource):
    """A restorable dropped managed database resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar database_name: The name of the database.
    :vartype database_name: str
    :ivar creation_date: The creation date of the database (ISO8601 format).
    :vartype creation_date: datetime
    :ivar deletion_date: The deletion date of the database (ISO8601 format).
    :vartype deletion_date: datetime
    :ivar earliest_restore_date: The earliest restore date of the database
     (ISO8601 format).
    :vartype earliest_restore_date: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'database_name': {'readonly': True},
        'creation_date': {'readonly': True},
        'deletion_date': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'deletion_date': {'key': 'properties.deletionDate', 'type': 'iso-8601'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(RestorableDroppedManagedDatabase, self).__init__(**kwargs)
        self.database_name = None
        self.creation_date = None
        self.deletion_date = None
        self.earliest_restore_date = None


class RestorePoint(ProxyResource):
    """Database restore points.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar restore_point_type: The type of restore point. Possible values
     include: 'CONTINUOUS', 'DISCRETE'
    :vartype restore_point_type: str or
     ~azure.mgmt.sql.models.RestorePointType
    :ivar earliest_restore_date: The earliest time to which this database can
     be restored
    :vartype earliest_restore_date: datetime
    :ivar restore_point_creation_date: The time the backup was taken
    :vartype restore_point_creation_date: datetime
    :ivar restore_point_label: The label of restore point for backup request
     by user
    :vartype restore_point_label: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'restore_point_type': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
        'restore_point_creation_date': {'readonly': True},
        'restore_point_label': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'restore_point_type': {'key': 'properties.restorePointType', 'type': 'RestorePointType'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
        'restore_point_creation_date': {'key': 'properties.restorePointCreationDate', 'type': 'iso-8601'},
        'restore_point_label': {'key': 'properties.restorePointLabel', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RestorePoint, self).__init__(**kwargs)
        self.location = None
        self.restore_point_type = None
        self.earliest_restore_date = None
        self.restore_point_creation_date = None
        self.restore_point_label = None


class SensitivityLabel(ProxyResource):
    """A sensitivity label.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param label_name: The label name.
    :type label_name: str
    :param label_id: The label ID.
    :type label_id: str
    :param information_type: The information type.
    :type information_type: str
    :param information_type_id: The information type ID.
    :type information_type_id: str
    :ivar is_disabled: Is sensitivity recommendation disabled. Applicable for
     recommended sensitivity label only. Specifies whether the sensitivity
     recommendation on this column is disabled (dismissed) or not.
    :vartype is_disabled: bool
    :param rank: Possible values include: 'None', 'Low', 'Medium', 'High',
     'Critical'
    :type rank: str or ~azure.mgmt.sql.models.SensitivityLabelRank
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'is_disabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'label_name': {'key': 'properties.labelName', 'type': 'str'},
        'label_id': {'key': 'properties.labelId', 'type': 'str'},
        'information_type': {'key': 'properties.informationType', 'type': 'str'},
        'information_type_id': {'key': 'properties.informationTypeId', 'type': 'str'},
        'is_disabled': {'key': 'properties.isDisabled', 'type': 'bool'},
        'rank': {'key': 'properties.rank', 'type': 'SensitivityLabelRank'},
    }

    def __init__(self, **kwargs):
        super(SensitivityLabel, self).__init__(**kwargs)
        self.label_name = kwargs.get('label_name', None)
        self.label_id = kwargs.get('label_id', None)
        self.information_type = kwargs.get('information_type', None)
        self.information_type_id = kwargs.get('information_type_id', None)
        self.is_disabled = None
        self.rank = kwargs.get('rank', None)


class Server(TrackedResource):
    """An Azure SQL Database server.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param identity: The Azure Active Directory identity of the server.
    :type identity: ~azure.mgmt.sql.models.ResourceIdentity
    :ivar kind: Kind of sql server. This is metadata used for the Azure portal
     experience.
    :vartype kind: str
    :param administrator_login: Administrator username for the server. Once
     created it cannot be changed.
    :type administrator_login: str
    :param administrator_login_password: The administrator login password
     (required for server creation).
    :type administrator_login_password: str
    :param version: The version of the server.
    :type version: str
    :ivar state: The state of the server.
    :vartype state: str
    :ivar fully_qualified_domain_name: The fully qualified domain name of the
     server.
    :vartype fully_qualified_domain_name: str
    :ivar private_endpoint_connections: List of private endpoint connections
     on a server
    :vartype private_endpoint_connections:
     list[~azure.mgmt.sql.models.ServerPrivateEndpointConnection]
    :param minimal_tls_version: Minimal TLS version. Allowed values: '1.0',
     '1.1', '1.2'
    :type minimal_tls_version: str
    :param public_network_access: Whether or not public endpoint access is
     allowed for this server.  Value is optional but if passed in, must be
     'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.sql.models.ServerPublicNetworkAccess
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'readonly': True},
        'state': {'readonly': True},
        'fully_qualified_domain_name': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[ServerPrivateEndpointConnection]'},
        'minimal_tls_version': {'key': 'properties.minimalTlsVersion', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Server, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = None
        self.administrator_login = kwargs.get('administrator_login', None)
        self.administrator_login_password = kwargs.get('administrator_login_password', None)
        self.version = kwargs.get('version', None)
        self.state = None
        self.fully_qualified_domain_name = None
        self.private_endpoint_connections = None
        self.minimal_tls_version = kwargs.get('minimal_tls_version', None)
        self.public_network_access = kwargs.get('public_network_access', None)


class ServerAutomaticTuning(ProxyResource):
    """Server-level Automatic Tuning.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param desired_state: Automatic tuning desired state. Possible values
     include: 'Custom', 'Auto', 'Unspecified'
    :type desired_state: str or
     ~azure.mgmt.sql.models.AutomaticTuningServerMode
    :ivar actual_state: Automatic tuning actual state. Possible values
     include: 'Custom', 'Auto', 'Unspecified'
    :vartype actual_state: str or
     ~azure.mgmt.sql.models.AutomaticTuningServerMode
    :param options: Automatic tuning options definition.
    :type options: dict[str,
     ~azure.mgmt.sql.models.AutomaticTuningServerOptions]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'actual_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'desired_state': {'key': 'properties.desiredState', 'type': 'AutomaticTuningServerMode'},
        'actual_state': {'key': 'properties.actualState', 'type': 'AutomaticTuningServerMode'},
        'options': {'key': 'properties.options', 'type': '{AutomaticTuningServerOptions}'},
    }

    def __init__(self, **kwargs):
        super(ServerAutomaticTuning, self).__init__(**kwargs)
        self.desired_state = kwargs.get('desired_state', None)
        self.actual_state = None
        self.options = kwargs.get('options', None)


class ServerAzureADAdministrator(ProxyResource):
    """Azure Active Directory administrator.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar administrator_type: Required. Type of the sever administrator.
     Default value: "ActiveDirectory" .
    :vartype administrator_type: str
    :param login: Required. Login name of the server administrator.
    :type login: str
    :param sid: Required. SID (object ID) of the server administrator.
    :type sid: str
    :param tenant_id: Tenant ID of the administrator.
    :type tenant_id: str
    :ivar azure_ad_only_authentication: Azure Active Directory only
     Authentication enabled.
    :vartype azure_ad_only_authentication: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'administrator_type': {'required': True, 'constant': True},
        'login': {'required': True},
        'sid': {'required': True},
        'azure_ad_only_authentication': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'administrator_type': {'key': 'properties.administratorType', 'type': 'str'},
        'login': {'key': 'properties.login', 'type': 'str'},
        'sid': {'key': 'properties.sid', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'azure_ad_only_authentication': {'key': 'properties.azureADOnlyAuthentication', 'type': 'bool'},
    }

    administrator_type = "ActiveDirectory"

    def __init__(self, **kwargs):
        super(ServerAzureADAdministrator, self).__init__(**kwargs)
        self.login = kwargs.get('login', None)
        self.sid = kwargs.get('sid', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.azure_ad_only_authentication = None


class ServerAzureADOnlyAuthentication(ProxyResource):
    """Azure Active Directory only authentication.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param azure_ad_only_authentication: Required. Azure Active Directory only
     Authentication enabled.
    :type azure_ad_only_authentication: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'azure_ad_only_authentication': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'azure_ad_only_authentication': {'key': 'properties.azureADOnlyAuthentication', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ServerAzureADOnlyAuthentication, self).__init__(**kwargs)
        self.azure_ad_only_authentication = kwargs.get('azure_ad_only_authentication', None)


class ServerBlobAuditingPolicy(ProxyResource):
    """A server blob auditing policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param state: Required. Specifies the state of the policy. If state is
     Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
     Possible values include: 'Enabled', 'Disabled'
    :type state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled,
     storageEndpoint or isAzureMonitorTargetEnabled is required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the
     auditing storage account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed
     identity to access the storage.
     Prerequisites for using managed identity authentication:
     1. Assign SQL Server a system-assigned managed identity in Azure Active
     Directory (AAD).
     2. Grant SQL Server identity access to the storage account by adding
     'Storage Blob Data Contributor' RBAC role to the server identity.
     For more information, see [Auditing to storage using Managed Identity
     authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the audit
     logs in the storage account.
    :type retention_days: int
    :param audit_actions_and_groups: Specifies the Actions-Groups and Actions
     to audit.
     The recommended set of action groups to use is the following combination -
     this will audit all the queries and stored procedures executed against the
     database, as well as successful and failed logins:
     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.
     This above combination is also the set that is configured by default when
     enabling auditing from the Azure portal.
     The supported action groups to audit are (note: choose only specific
     groups that cover your auditing needs. Using unnecessary groups could lead
     to very large quantities of audit records):
     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
     These are groups that cover all sql statements and stored procedures
     executed against the database, and should not be used in combination with
     other groups as this will result in duplicate audit logs.
     For more information, see [Database-Level Audit Action
     Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
     For Database auditing policy, specific Actions can also be specified (note
     that Actions cannot be specified for Server auditing policy). The
     supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES
     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}
     Note that <object> in the above format can refer to an object like a
     table, view, or stored procedure, or an entire database or schema. For the
     latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are
     used, respectively.
     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public
     For more information, see [Database-Level Audit
     Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
    :type audit_actions_and_groups: list[str]
    :param storage_account_subscription_id: Specifies the blob storage
     subscription Id.
    :type storage_account_subscription_id: str
    :param is_storage_secondary_key_in_use: Specifies whether
     storageAccountAccessKey value is the storage's secondary key.
    :type is_storage_secondary_key_in_use: bool
    :param is_azure_monitor_target_enabled: Specifies whether audit events are
     sent to Azure Monitor.
     In order to send the events to Azure Monitor, specify 'state' as 'Enabled'
     and 'isAzureMonitorTargetEnabled' as true.
     When using REST API to configure auditing, Diagnostic Settings with
     'SQLSecurityAuditEvents' diagnostic logs category on the database should
     be also created.
     Note that for server level audit you should use the 'master' database as
     {databaseName}.
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
     For more information, see [Diagnostic Settings REST
     API](https://go.microsoft.com/fwlink/?linkid=2033207)
     or [Diagnostic Settings
     PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
    :type is_azure_monitor_target_enabled: bool
    :param queue_delay_ms: Specifies the amount of time in milliseconds that
     can elapse before audit actions are forced to be processed.
     The default minimum value is 1000 (1 second). The maximum is
     2,147,483,647.
    :type queue_delay_ms: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'BlobAuditingPolicyState'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'audit_actions_and_groups': {'key': 'properties.auditActionsAndGroups', 'type': '[str]'},
        'storage_account_subscription_id': {'key': 'properties.storageAccountSubscriptionId', 'type': 'str'},
        'is_storage_secondary_key_in_use': {'key': 'properties.isStorageSecondaryKeyInUse', 'type': 'bool'},
        'is_azure_monitor_target_enabled': {'key': 'properties.isAzureMonitorTargetEnabled', 'type': 'bool'},
        'queue_delay_ms': {'key': 'properties.queueDelayMs', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ServerBlobAuditingPolicy, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.storage_endpoint = kwargs.get('storage_endpoint', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.retention_days = kwargs.get('retention_days', None)
        self.audit_actions_and_groups = kwargs.get('audit_actions_and_groups', None)
        self.storage_account_subscription_id = kwargs.get('storage_account_subscription_id', None)
        self.is_storage_secondary_key_in_use = kwargs.get('is_storage_secondary_key_in_use', None)
        self.is_azure_monitor_target_enabled = kwargs.get('is_azure_monitor_target_enabled', None)
        self.queue_delay_ms = kwargs.get('queue_delay_ms', None)


class ServerCommunicationLink(ProxyResource):
    """Server communication link.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar state: The state.
    :vartype state: str
    :param partner_server: Required. The name of the partner server.
    :type partner_server: str
    :ivar location: Communication link location.
    :vartype location: str
    :ivar kind: Communication link kind.  This property is used for Azure
     Portal metadata.
    :vartype kind: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'partner_server': {'required': True},
        'location': {'readonly': True},
        'kind': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'partner_server': {'key': 'properties.partnerServer', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServerCommunicationLink, self).__init__(**kwargs)
        self.state = None
        self.partner_server = kwargs.get('partner_server', None)
        self.location = None
        self.kind = None


class ServerConnectionPolicy(ProxyResource):
    """A server secure connection policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Metadata used for the Azure portal experience.
    :vartype kind: str
    :ivar location: Resource location.
    :vartype location: str
    :param connection_type: Required. The server connection type. Possible
     values include: 'Default', 'Proxy', 'Redirect'
    :type connection_type: str or ~azure.mgmt.sql.models.ServerConnectionType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
        'connection_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'ServerConnectionType'},
    }

    def __init__(self, **kwargs):
        super(ServerConnectionPolicy, self).__init__(**kwargs)
        self.kind = None
        self.location = None
        self.connection_type = kwargs.get('connection_type', None)


class ServerDnsAlias(ProxyResource):
    """A server DNS alias.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar azure_dns_record: The fully qualified DNS record for alias
    :vartype azure_dns_record: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'azure_dns_record': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'azure_dns_record': {'key': 'properties.azureDnsRecord', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServerDnsAlias, self).__init__(**kwargs)
        self.azure_dns_record = None


class ServerDnsAliasAcquisition(Model):
    """A server DNS alias acquisition request.

    :param old_server_dns_alias_id: The id of the server alias that will be
     acquired to point to this server instead.
    :type old_server_dns_alias_id: str
    """

    _attribute_map = {
        'old_server_dns_alias_id': {'key': 'oldServerDnsAliasId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServerDnsAliasAcquisition, self).__init__(**kwargs)
        self.old_server_dns_alias_id = kwargs.get('old_server_dns_alias_id', None)


class ServerInfo(Model):
    """Server info for the server trust group.

    All required parameters must be populated in order to send to Azure.

    :param server_id: Required. Server Id.
    :type server_id: str
    """

    _validation = {
        'server_id': {'required': True},
    }

    _attribute_map = {
        'server_id': {'key': 'serverId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServerInfo, self).__init__(**kwargs)
        self.server_id = kwargs.get('server_id', None)


class ServerKey(ProxyResource):
    """A server key.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param kind: Kind of encryption protector. This is metadata used for the
     Azure portal experience.
    :type kind: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar subregion: Subregion of the server key.
    :vartype subregion: str
    :param server_key_type: Required. The server key type like
     'ServiceManaged', 'AzureKeyVault'. Possible values include:
     'ServiceManaged', 'AzureKeyVault'
    :type server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
    :param uri: The URI of the server key.
    :type uri: str
    :param thumbprint: Thumbprint of the server key.
    :type thumbprint: str
    :param creation_date: The server key creation date.
    :type creation_date: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'subregion': {'readonly': True},
        'server_key_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'subregion': {'key': 'properties.subregion', 'type': 'str'},
        'server_key_type': {'key': 'properties.serverKeyType', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ServerKey, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)
        self.location = None
        self.subregion = None
        self.server_key_type = kwargs.get('server_key_type', None)
        self.uri = kwargs.get('uri', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.creation_date = kwargs.get('creation_date', None)


class ServerPrivateEndpointConnection(Model):
    """A private endpoint connection under a server.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar properties: Private endpoint connection properties
    :vartype properties:
     ~azure.mgmt.sql.models.PrivateEndpointConnectionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateEndpointConnectionProperties'},
    }

    def __init__(self, **kwargs):
        super(ServerPrivateEndpointConnection, self).__init__(**kwargs)
        self.id = None
        self.properties = None


class ServerSecurityAlertPolicy(ProxyResource):
    """A server security alert policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param state: Required. Specifies the state of the policy, whether it is
     enabled or disabled or a policy has not been applied yet on the specific
     database. Possible values include: 'New', 'Enabled', 'Disabled'
    :type state: str or ~azure.mgmt.sql.models.SecurityAlertPolicyState
    :param disabled_alerts: Specifies an array of alerts that are disabled.
     Allowed values are: Sql_Injection, Sql_Injection_Vulnerability,
     Access_Anomaly, Data_Exfiltration, Unsafe_Action
    :type disabled_alerts: list[str]
    :param email_addresses: Specifies an array of e-mail addresses to which
     the alert is sent.
    :type email_addresses: list[str]
    :param email_account_admins: Specifies that the alert is sent to the
     account administrators.
    :type email_account_admins: bool
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all
     Threat Detection audit logs.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the
     Threat Detection audit storage account.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the Threat
     Detection audit logs.
    :type retention_days: int
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'required': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'SecurityAlertPolicyState'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': '[str]'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': '[str]'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'bool'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ServerSecurityAlertPolicy, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.disabled_alerts = kwargs.get('disabled_alerts', None)
        self.email_addresses = kwargs.get('email_addresses', None)
        self.email_account_admins = kwargs.get('email_account_admins', None)
        self.storage_endpoint = kwargs.get('storage_endpoint', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.retention_days = kwargs.get('retention_days', None)
        self.creation_time = None


class ServerTrustGroup(ProxyResource):
    """A server trust group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param group_members: Required. Group members information for the server
     trust group.
    :type group_members: list[~azure.mgmt.sql.models.ServerInfo]
    :param trust_scopes: Required. Trust scope of the server trust group.
    :type trust_scopes: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_members': {'required': True},
        'trust_scopes': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_members': {'key': 'properties.groupMembers', 'type': '[ServerInfo]'},
        'trust_scopes': {'key': 'properties.trustScopes', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ServerTrustGroup, self).__init__(**kwargs)
        self.group_members = kwargs.get('group_members', None)
        self.trust_scopes = kwargs.get('trust_scopes', None)


class ServerUpdate(Model):
    """An update request for an Azure SQL Database server.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param administrator_login: Administrator username for the server. Once
     created it cannot be changed.
    :type administrator_login: str
    :param administrator_login_password: The administrator login password
     (required for server creation).
    :type administrator_login_password: str
    :param version: The version of the server.
    :type version: str
    :ivar state: The state of the server.
    :vartype state: str
    :ivar fully_qualified_domain_name: The fully qualified domain name of the
     server.
    :vartype fully_qualified_domain_name: str
    :ivar private_endpoint_connections: List of private endpoint connections
     on a server
    :vartype private_endpoint_connections:
     list[~azure.mgmt.sql.models.ServerPrivateEndpointConnection]
    :param minimal_tls_version: Minimal TLS version. Allowed values: '1.0',
     '1.1', '1.2'
    :type minimal_tls_version: str
    :param public_network_access: Whether or not public endpoint access is
     allowed for this server.  Value is optional but if passed in, must be
     'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.sql.models.ServerPublicNetworkAccess
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'state': {'readonly': True},
        'fully_qualified_domain_name': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[ServerPrivateEndpointConnection]'},
        'minimal_tls_version': {'key': 'properties.minimalTlsVersion', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(ServerUpdate, self).__init__(**kwargs)
        self.administrator_login = kwargs.get('administrator_login', None)
        self.administrator_login_password = kwargs.get('administrator_login_password', None)
        self.version = kwargs.get('version', None)
        self.state = None
        self.fully_qualified_domain_name = None
        self.private_endpoint_connections = None
        self.minimal_tls_version = kwargs.get('minimal_tls_version', None)
        self.public_network_access = kwargs.get('public_network_access', None)
        self.tags = kwargs.get('tags', None)


class ServerUsage(Model):
    """Represents server metrics.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Name of the server usage metric.
    :vartype name: str
    :ivar resource_name: The name of the resource.
    :vartype resource_name: str
    :ivar display_name: The metric display name.
    :vartype display_name: str
    :ivar current_value: The current value of the metric.
    :vartype current_value: float
    :ivar limit: The current limit of the metric.
    :vartype limit: float
    :ivar unit: The units of the metric.
    :vartype unit: str
    :ivar next_reset_time: The next reset time for the metric (ISO8601
     format).
    :vartype next_reset_time: datetime
    """

    _validation = {
        'name': {'readonly': True},
        'resource_name': {'readonly': True},
        'display_name': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'unit': {'readonly': True},
        'next_reset_time': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'limit': {'key': 'limit', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ServerUsage, self).__init__(**kwargs)
        self.name = None
        self.resource_name = None
        self.display_name = None
        self.current_value = None
        self.limit = None
        self.unit = None
        self.next_reset_time = None


class ServerVersionCapability(Model):
    """The server capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The server version name.
    :vartype name: str
    :ivar supported_editions: The list of supported database editions.
    :vartype supported_editions:
     list[~azure.mgmt.sql.models.EditionCapability]
    :ivar supported_elastic_pool_editions: The list of supported elastic pool
     editions.
    :vartype supported_elastic_pool_editions:
     list[~azure.mgmt.sql.models.ElasticPoolEditionCapability]
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'name': {'readonly': True},
        'supported_editions': {'readonly': True},
        'supported_elastic_pool_editions': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_editions': {'key': 'supportedEditions', 'type': '[EditionCapability]'},
        'supported_elastic_pool_editions': {'key': 'supportedElasticPoolEditions', 'type': '[ElasticPoolEditionCapability]'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServerVersionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_editions = None
        self.supported_elastic_pool_editions = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class ServerVulnerabilityAssessment(ProxyResource):
    """A server vulnerability assessment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param storage_container_path: Required. A blob storage container path to
     hold the scan results (e.g.
     https://myStorage.blob.core.windows.net/VaScans/).
    :type storage_container_path: str
    :param storage_container_sas_key: A shared access signature (SAS Key) that
     has read and write access to the blob container specified in
     'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't
     specified, StorageContainerSasKey is required.
    :type storage_container_sas_key: str
    :param storage_account_access_key: Specifies the identifier key of the
     storage account for vulnerability assessment scan results. If
     'StorageContainerSasKey' isn't specified, storageAccountAccessKey is
     required.
    :type storage_account_access_key: str
    :param recurring_scans: The recurring scans settings
    :type recurring_scans:
     ~azure.mgmt.sql.models.VulnerabilityAssessmentRecurringScansProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'storage_container_path': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'storage_container_sas_key': {'key': 'properties.storageContainerSasKey', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'recurring_scans': {'key': 'properties.recurringScans', 'type': 'VulnerabilityAssessmentRecurringScansProperties'},
    }

    def __init__(self, **kwargs):
        super(ServerVulnerabilityAssessment, self).__init__(**kwargs)
        self.storage_container_path = kwargs.get('storage_container_path', None)
        self.storage_container_sas_key = kwargs.get('storage_container_sas_key', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.recurring_scans = kwargs.get('recurring_scans', None)


class ServiceObjective(ProxyResource):
    """Represents a database service objective.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_objective_name: The name for the service objective.
    :vartype service_objective_name: str
    :ivar is_default: Gets whether the service level objective is the default
     service objective.
    :vartype is_default: bool
    :ivar is_system: Gets whether the service level objective is a system
     service objective.
    :vartype is_system: bool
    :ivar description: The description for the service level objective.
    :vartype description: str
    :ivar enabled: Gets whether the service level objective is enabled.
    :vartype enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'service_objective_name': {'readonly': True},
        'is_default': {'readonly': True},
        'is_system': {'readonly': True},
        'description': {'readonly': True},
        'enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_objective_name': {'key': 'properties.serviceObjectiveName', 'type': 'str'},
        'is_default': {'key': 'properties.isDefault', 'type': 'bool'},
        'is_system': {'key': 'properties.isSystem', 'type': 'bool'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ServiceObjective, self).__init__(**kwargs)
        self.service_objective_name = None
        self.is_default = None
        self.is_system = None
        self.description = None
        self.enabled = None


class ServiceObjectiveCapability(Model):
    """The service objectives capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The unique ID of the service objective.
    :vartype id: str
    :ivar name: The service objective name.
    :vartype name: str
    :ivar supported_max_sizes: The list of supported maximum database sizes.
    :vartype supported_max_sizes:
     list[~azure.mgmt.sql.models.MaxSizeRangeCapability]
    :ivar performance_level: The performance level.
    :vartype performance_level:
     ~azure.mgmt.sql.models.PerformanceLevelCapability
    :ivar sku: The sku.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar supported_license_types: List of supported license types.
    :vartype supported_license_types:
     list[~azure.mgmt.sql.models.LicenseTypeCapability]
    :ivar included_max_size: The included (free) max size.
    :vartype included_max_size: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar zone_redundant: Whether or not zone redundancy is supported for the
     service objective.
    :vartype zone_redundant: bool
    :ivar supported_auto_pause_delay: Supported time range for auto pause
     delay
    :vartype supported_auto_pause_delay:
     ~azure.mgmt.sql.models.AutoPauseDelayTimeRange
    :ivar supported_min_capacities: List of supported min capacities
    :vartype supported_min_capacities:
     list[~azure.mgmt.sql.models.MinCapacityCapability]
    :ivar compute_model: The compute model
    :vartype compute_model: str
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'supported_max_sizes': {'readonly': True},
        'performance_level': {'readonly': True},
        'sku': {'readonly': True},
        'supported_license_types': {'readonly': True},
        'included_max_size': {'readonly': True},
        'zone_redundant': {'readonly': True},
        'supported_auto_pause_delay': {'readonly': True},
        'supported_min_capacities': {'readonly': True},
        'compute_model': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'supported_max_sizes': {'key': 'supportedMaxSizes', 'type': '[MaxSizeRangeCapability]'},
        'performance_level': {'key': 'performanceLevel', 'type': 'PerformanceLevelCapability'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'supported_license_types': {'key': 'supportedLicenseTypes', 'type': '[LicenseTypeCapability]'},
        'included_max_size': {'key': 'includedMaxSize', 'type': 'MaxSizeCapability'},
        'zone_redundant': {'key': 'zoneRedundant', 'type': 'bool'},
        'supported_auto_pause_delay': {'key': 'supportedAutoPauseDelay', 'type': 'AutoPauseDelayTimeRange'},
        'supported_min_capacities': {'key': 'supportedMinCapacities', 'type': '[MinCapacityCapability]'},
        'compute_model': {'key': 'computeModel', 'type': 'str'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceObjectiveCapability, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.supported_max_sizes = None
        self.performance_level = None
        self.sku = None
        self.supported_license_types = None
        self.included_max_size = None
        self.zone_redundant = None
        self.supported_auto_pause_delay = None
        self.supported_min_capacities = None
        self.compute_model = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class ServiceTierAdvisor(ProxyResource):
    """Represents a Service Tier Advisor.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar observation_period_start: The observation period start (ISO8601
     format).
    :vartype observation_period_start: datetime
    :ivar observation_period_end: The observation period start (ISO8601
     format).
    :vartype observation_period_end: datetime
    :ivar active_time_ratio: The activeTimeRatio for service tier advisor.
    :vartype active_time_ratio: float
    :ivar min_dtu: Gets or sets minDtu for service tier advisor.
    :vartype min_dtu: float
    :ivar avg_dtu: Gets or sets avgDtu for service tier advisor.
    :vartype avg_dtu: float
    :ivar max_dtu: Gets or sets maxDtu for service tier advisor.
    :vartype max_dtu: float
    :ivar max_size_in_gb: Gets or sets maxSizeInGB for service tier advisor.
    :vartype max_size_in_gb: float
    :ivar service_level_objective_usage_metrics: Gets or sets
     serviceLevelObjectiveUsageMetrics for the service tier advisor.
    :vartype service_level_objective_usage_metrics:
     list[~azure.mgmt.sql.models.SloUsageMetric]
    :ivar current_service_level_objective: Gets or sets
     currentServiceLevelObjective for service tier advisor.
    :vartype current_service_level_objective: str
    :ivar current_service_level_objective_id: Gets or sets
     currentServiceLevelObjectiveId for service tier advisor.
    :vartype current_service_level_objective_id: str
    :ivar usage_based_recommendation_service_level_objective: Gets or sets
     usageBasedRecommendationServiceLevelObjective for service tier advisor.
    :vartype usage_based_recommendation_service_level_objective: str
    :ivar usage_based_recommendation_service_level_objective_id: Gets or sets
     usageBasedRecommendationServiceLevelObjectiveId for service tier advisor.
    :vartype usage_based_recommendation_service_level_objective_id: str
    :ivar database_size_based_recommendation_service_level_objective: Gets or
     sets databaseSizeBasedRecommendationServiceLevelObjective for service tier
     advisor.
    :vartype database_size_based_recommendation_service_level_objective: str
    :ivar database_size_based_recommendation_service_level_objective_id: Gets
     or sets databaseSizeBasedRecommendationServiceLevelObjectiveId for service
     tier advisor.
    :vartype database_size_based_recommendation_service_level_objective_id:
     str
    :ivar disaster_plan_based_recommendation_service_level_objective: Gets or
     sets disasterPlanBasedRecommendationServiceLevelObjective for service tier
     advisor.
    :vartype disaster_plan_based_recommendation_service_level_objective: str
    :ivar disaster_plan_based_recommendation_service_level_objective_id: Gets
     or sets disasterPlanBasedRecommendationServiceLevelObjectiveId for service
     tier advisor.
    :vartype disaster_plan_based_recommendation_service_level_objective_id:
     str
    :ivar overall_recommendation_service_level_objective: Gets or sets
     overallRecommendationServiceLevelObjective for service tier advisor.
    :vartype overall_recommendation_service_level_objective: str
    :ivar overall_recommendation_service_level_objective_id: Gets or sets
     overallRecommendationServiceLevelObjectiveId for service tier advisor.
    :vartype overall_recommendation_service_level_objective_id: str
    :ivar confidence: Gets or sets confidence for service tier advisor.
    :vartype confidence: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'observation_period_start': {'readonly': True},
        'observation_period_end': {'readonly': True},
        'active_time_ratio': {'readonly': True},
        'min_dtu': {'readonly': True},
        'avg_dtu': {'readonly': True},
        'max_dtu': {'readonly': True},
        'max_size_in_gb': {'readonly': True},
        'service_level_objective_usage_metrics': {'readonly': True},
        'current_service_level_objective': {'readonly': True},
        'current_service_level_objective_id': {'readonly': True},
        'usage_based_recommendation_service_level_objective': {'readonly': True},
        'usage_based_recommendation_service_level_objective_id': {'readonly': True},
        'database_size_based_recommendation_service_level_objective': {'readonly': True},
        'database_size_based_recommendation_service_level_objective_id': {'readonly': True},
        'disaster_plan_based_recommendation_service_level_objective': {'readonly': True},
        'disaster_plan_based_recommendation_service_level_objective_id': {'readonly': True},
        'overall_recommendation_service_level_objective': {'readonly': True},
        'overall_recommendation_service_level_objective_id': {'readonly': True},
        'confidence': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'observation_period_start': {'key': 'properties.observationPeriodStart', 'type': 'iso-8601'},
        'observation_period_end': {'key': 'properties.observationPeriodEnd', 'type': 'iso-8601'},
        'active_time_ratio': {'key': 'properties.activeTimeRatio', 'type': 'float'},
        'min_dtu': {'key': 'properties.minDtu', 'type': 'float'},
        'avg_dtu': {'key': 'properties.avgDtu', 'type': 'float'},
        'max_dtu': {'key': 'properties.maxDtu', 'type': 'float'},
        'max_size_in_gb': {'key': 'properties.maxSizeInGB', 'type': 'float'},
        'service_level_objective_usage_metrics': {'key': 'properties.serviceLevelObjectiveUsageMetrics', 'type': '[SloUsageMetric]'},
        'current_service_level_objective': {'key': 'properties.currentServiceLevelObjective', 'type': 'str'},
        'current_service_level_objective_id': {'key': 'properties.currentServiceLevelObjectiveId', 'type': 'str'},
        'usage_based_recommendation_service_level_objective': {'key': 'properties.usageBasedRecommendationServiceLevelObjective', 'type': 'str'},
        'usage_based_recommendation_service_level_objective_id': {'key': 'properties.usageBasedRecommendationServiceLevelObjectiveId', 'type': 'str'},
        'database_size_based_recommendation_service_level_objective': {'key': 'properties.databaseSizeBasedRecommendationServiceLevelObjective', 'type': 'str'},
        'database_size_based_recommendation_service_level_objective_id': {'key': 'properties.databaseSizeBasedRecommendationServiceLevelObjectiveId', 'type': 'str'},
        'disaster_plan_based_recommendation_service_level_objective': {'key': 'properties.disasterPlanBasedRecommendationServiceLevelObjective', 'type': 'str'},
        'disaster_plan_based_recommendation_service_level_objective_id': {'key': 'properties.disasterPlanBasedRecommendationServiceLevelObjectiveId', 'type': 'str'},
        'overall_recommendation_service_level_objective': {'key': 'properties.overallRecommendationServiceLevelObjective', 'type': 'str'},
        'overall_recommendation_service_level_objective_id': {'key': 'properties.overallRecommendationServiceLevelObjectiveId', 'type': 'str'},
        'confidence': {'key': 'properties.confidence', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ServiceTierAdvisor, self).__init__(**kwargs)
        self.observation_period_start = None
        self.observation_period_end = None
        self.active_time_ratio = None
        self.min_dtu = None
        self.avg_dtu = None
        self.max_dtu = None
        self.max_size_in_gb = None
        self.service_level_objective_usage_metrics = None
        self.current_service_level_objective = None
        self.current_service_level_objective_id = None
        self.usage_based_recommendation_service_level_objective = None
        self.usage_based_recommendation_service_level_objective_id = None
        self.database_size_based_recommendation_service_level_objective = None
        self.database_size_based_recommendation_service_level_objective_id = None
        self.disaster_plan_based_recommendation_service_level_objective = None
        self.disaster_plan_based_recommendation_service_level_objective_id = None
        self.overall_recommendation_service_level_objective = None
        self.overall_recommendation_service_level_objective_id = None
        self.confidence = None


class Sku(Model):
    """An ARM Resource SKU.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU, typically, a letter + Number
     code, e.g. P3.
    :type name: str
    :param tier: The tier or edition of the particular SKU, e.g. Basic,
     Premium.
    :type tier: str
    :param size: Size of the particular SKU
    :type size: str
    :param family: If the service has different generations of hardware, for
     the same SKU, then that can be captured here.
    :type family: str
    :param capacity: Capacity of the particular SKU.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.size = kwargs.get('size', None)
        self.family = kwargs.get('family', None)
        self.capacity = kwargs.get('capacity', None)


class SloUsageMetric(Model):
    """A Slo Usage Metric.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar service_level_objective: The serviceLevelObjective for SLO usage
     metric. Possible values include: 'System', 'System0', 'System1',
     'System2', 'System3', 'System4', 'System2L', 'System3L', 'System4L',
     'Free', 'Basic', 'S0', 'S1', 'S2', 'S3', 'S4', 'S6', 'S7', 'S9', 'S12',
     'P1', 'P2', 'P3', 'P4', 'P6', 'P11', 'P15', 'PRS1', 'PRS2', 'PRS4',
     'PRS6', 'DW100', 'DW200', 'DW300', 'DW400', 'DW500', 'DW600', 'DW1000',
     'DW1200', 'DW1000c', 'DW1500', 'DW1500c', 'DW2000', 'DW2000c', 'DW3000',
     'DW2500c', 'DW3000c', 'DW6000', 'DW5000c', 'DW6000c', 'DW7500c',
     'DW10000c', 'DW15000c', 'DW30000c', 'DS100', 'DS200', 'DS300', 'DS400',
     'DS500', 'DS600', 'DS1000', 'DS1200', 'DS1500', 'DS2000', 'ElasticPool'
    :vartype service_level_objective: str or
     ~azure.mgmt.sql.models.ServiceObjectiveName
    :ivar service_level_objective_id: The serviceLevelObjectiveId for SLO
     usage metric.
    :vartype service_level_objective_id: str
    :ivar in_range_time_ratio: Gets or sets inRangeTimeRatio for SLO usage
     metric.
    :vartype in_range_time_ratio: float
    """

    _validation = {
        'service_level_objective': {'readonly': True},
        'service_level_objective_id': {'readonly': True},
        'in_range_time_ratio': {'readonly': True},
    }

    _attribute_map = {
        'service_level_objective': {'key': 'serviceLevelObjective', 'type': 'str'},
        'service_level_objective_id': {'key': 'serviceLevelObjectiveId', 'type': 'str'},
        'in_range_time_ratio': {'key': 'inRangeTimeRatio', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(SloUsageMetric, self).__init__(**kwargs)
        self.service_level_objective = None
        self.service_level_objective_id = None
        self.in_range_time_ratio = None


class StorageCapability(Model):
    """The storage account type capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar storage_account_type: The storage account type for the database's
     backups. Possible values include: 'GRS', 'LRS', 'ZRS'
    :vartype storage_account_type: str or ~azure.mgmt.sql.models.enum
    :ivar status: The status of the capability. Possible values include:
     'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :param reason: The reason for the capability not being available.
    :type reason: str
    """

    _validation = {
        'storage_account_type': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StorageCapability, self).__init__(**kwargs)
        self.storage_account_type = None
        self.status = None
        self.reason = kwargs.get('reason', None)


class SubscriptionUsage(ProxyResource):
    """Usage Metric of a Subscription in a Location.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: User-readable name of the metric.
    :vartype display_name: str
    :ivar current_value: Current value of the metric.
    :vartype current_value: float
    :ivar limit: Boundary value of the metric.
    :vartype limit: float
    :ivar unit: Unit of the metric.
    :vartype unit: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'current_value': {'key': 'properties.currentValue', 'type': 'float'},
        'limit': {'key': 'properties.limit', 'type': 'float'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SubscriptionUsage, self).__init__(**kwargs)
        self.display_name = None
        self.current_value = None
        self.limit = None
        self.unit = None


class SyncAgent(ProxyResource):
    """An Azure SQL Database sync agent.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar sync_agent_name: Name of the sync agent.
    :vartype sync_agent_name: str
    :param sync_database_id: ARM resource id of the sync database in the sync
     agent.
    :type sync_database_id: str
    :ivar last_alive_time: Last alive time of the sync agent.
    :vartype last_alive_time: datetime
    :ivar state: State of the sync agent. Possible values include: 'Online',
     'Offline', 'NeverConnected'
    :vartype state: str or ~azure.mgmt.sql.models.SyncAgentState
    :ivar is_up_to_date: If the sync agent version is up to date.
    :vartype is_up_to_date: bool
    :ivar expiry_time: Expiration time of the sync agent version.
    :vartype expiry_time: datetime
    :ivar version: Version of the sync agent.
    :vartype version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'sync_agent_name': {'readonly': True},
        'last_alive_time': {'readonly': True},
        'state': {'readonly': True},
        'is_up_to_date': {'readonly': True},
        'expiry_time': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sync_agent_name': {'key': 'properties.name', 'type': 'str'},
        'sync_database_id': {'key': 'properties.syncDatabaseId', 'type': 'str'},
        'last_alive_time': {'key': 'properties.lastAliveTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'is_up_to_date': {'key': 'properties.isUpToDate', 'type': 'bool'},
        'expiry_time': {'key': 'properties.expiryTime', 'type': 'iso-8601'},
        'version': {'key': 'properties.version', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SyncAgent, self).__init__(**kwargs)
        self.sync_agent_name = None
        self.sync_database_id = kwargs.get('sync_database_id', None)
        self.last_alive_time = None
        self.state = None
        self.is_up_to_date = None
        self.expiry_time = None
        self.version = None


class SyncAgentKeyProperties(Model):
    """Properties of an Azure SQL Database sync agent key.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar sync_agent_key: Key of sync agent.
    :vartype sync_agent_key: str
    """

    _validation = {
        'sync_agent_key': {'readonly': True},
    }

    _attribute_map = {
        'sync_agent_key': {'key': 'syncAgentKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SyncAgentKeyProperties, self).__init__(**kwargs)
        self.sync_agent_key = None


class SyncAgentLinkedDatabase(ProxyResource):
    """An Azure SQL Database sync agent linked database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar database_type: Type of the sync agent linked database. Possible
     values include: 'AzureSqlDatabase', 'SqlServerDatabase'
    :vartype database_type: str or ~azure.mgmt.sql.models.SyncMemberDbType
    :ivar database_id: Id of the sync agent linked database.
    :vartype database_id: str
    :ivar description: Description of the sync agent linked database.
    :vartype description: str
    :ivar server_name: Server name of the sync agent linked database.
    :vartype server_name: str
    :ivar database_name: Database name of the sync agent linked database.
    :vartype database_name: str
    :ivar user_name: User name of the sync agent linked database.
    :vartype user_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'database_type': {'readonly': True},
        'database_id': {'readonly': True},
        'description': {'readonly': True},
        'server_name': {'readonly': True},
        'database_name': {'readonly': True},
        'user_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'database_type': {'key': 'properties.databaseType', 'type': 'str'},
        'database_id': {'key': 'properties.databaseId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SyncAgentLinkedDatabase, self).__init__(**kwargs)
        self.database_type = None
        self.database_id = None
        self.description = None
        self.server_name = None
        self.database_name = None
        self.user_name = None


class SyncDatabaseIdProperties(Model):
    """Properties of the sync database id.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: ARM resource id of sync database.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SyncDatabaseIdProperties, self).__init__(**kwargs)
        self.id = None


class SyncFullSchemaProperties(Model):
    """Properties of the database full schema.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar tables: List of tables in the database full schema.
    :vartype tables: list[~azure.mgmt.sql.models.SyncFullSchemaTable]
    :ivar last_update_time: Last update time of the database schema.
    :vartype last_update_time: datetime
    """

    _validation = {
        'tables': {'readonly': True},
        'last_update_time': {'readonly': True},
    }

    _attribute_map = {
        'tables': {'key': 'tables', 'type': '[SyncFullSchemaTable]'},
        'last_update_time': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(SyncFullSchemaProperties, self).__init__(**kwargs)
        self.tables = None
        self.last_update_time = None


class SyncFullSchemaTable(Model):
    """Properties of the table in the database full schema.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar columns: List of columns in the table of database full schema.
    :vartype columns: list[~azure.mgmt.sql.models.SyncFullSchemaTableColumn]
    :ivar error_id: Error id of the table.
    :vartype error_id: str
    :ivar has_error: If there is error in the table.
    :vartype has_error: bool
    :ivar name: Name of the table.
    :vartype name: str
    :ivar quoted_name: Quoted name of the table.
    :vartype quoted_name: str
    """

    _validation = {
        'columns': {'readonly': True},
        'error_id': {'readonly': True},
        'has_error': {'readonly': True},
        'name': {'readonly': True},
        'quoted_name': {'readonly': True},
    }

    _attribute_map = {
        'columns': {'key': 'columns', 'type': '[SyncFullSchemaTableColumn]'},
        'error_id': {'key': 'errorId', 'type': 'str'},
        'has_error': {'key': 'hasError', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'quoted_name': {'key': 'quotedName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SyncFullSchemaTable, self).__init__(**kwargs)
        self.columns = None
        self.error_id = None
        self.has_error = None
        self.name = None
        self.quoted_name = None


class SyncFullSchemaTableColumn(Model):
    """Properties of the column in the table of database full schema.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar data_size: Data size of the column.
    :vartype data_size: str
    :ivar data_type: Data type of the column.
    :vartype data_type: str
    :ivar error_id: Error id of the column.
    :vartype error_id: str
    :ivar has_error: If there is error in the table.
    :vartype has_error: bool
    :ivar is_primary_key: If it is the primary key of the table.
    :vartype is_primary_key: bool
    :ivar name: Name of the column.
    :vartype name: str
    :ivar quoted_name: Quoted name of the column.
    :vartype quoted_name: str
    """

    _validation = {
        'data_size': {'readonly': True},
        'data_type': {'readonly': True},
        'error_id': {'readonly': True},
        'has_error': {'readonly': True},
        'is_primary_key': {'readonly': True},
        'name': {'readonly': True},
        'quoted_name': {'readonly': True},
    }

    _attribute_map = {
        'data_size': {'key': 'dataSize', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'error_id': {'key': 'errorId', 'type': 'str'},
        'has_error': {'key': 'hasError', 'type': 'bool'},
        'is_primary_key': {'key': 'isPrimaryKey', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'quoted_name': {'key': 'quotedName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SyncFullSchemaTableColumn, self).__init__(**kwargs)
        self.data_size = None
        self.data_type = None
        self.error_id = None
        self.has_error = None
        self.is_primary_key = None
        self.name = None
        self.quoted_name = None


class SyncGroup(ProxyResource):
    """An Azure SQL Database sync group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param interval: Sync interval of the sync group.
    :type interval: int
    :ivar last_sync_time: Last sync time of the sync group.
    :vartype last_sync_time: datetime
    :param conflict_resolution_policy: Conflict resolution policy of the sync
     group. Possible values include: 'HubWin', 'MemberWin'
    :type conflict_resolution_policy: str or
     ~azure.mgmt.sql.models.SyncConflictResolutionPolicy
    :param sync_database_id: ARM resource id of the sync database in the sync
     group.
    :type sync_database_id: str
    :param hub_database_user_name: User name for the sync group hub database
     credential.
    :type hub_database_user_name: str
    :param hub_database_password: Password for the sync group hub database
     credential.
    :type hub_database_password: str
    :ivar sync_state: Sync state of the sync group. Possible values include:
     'NotReady', 'Error', 'Warning', 'Progressing', 'Good'
    :vartype sync_state: str or ~azure.mgmt.sql.models.SyncGroupState
    :param schema: Sync schema of the sync group.
    :type schema: ~azure.mgmt.sql.models.SyncGroupSchema
    :param use_private_link_connection: If use private link connection is
     enabled.
    :type use_private_link_connection: bool
    :ivar private_endpoint_name: Private endpoint name of the sync group if
     use private link connection is enabled.
    :vartype private_endpoint_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_sync_time': {'readonly': True},
        'sync_state': {'readonly': True},
        'private_endpoint_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'interval': {'key': 'properties.interval', 'type': 'int'},
        'last_sync_time': {'key': 'properties.lastSyncTime', 'type': 'iso-8601'},
        'conflict_resolution_policy': {'key': 'properties.conflictResolutionPolicy', 'type': 'str'},
        'sync_database_id': {'key': 'properties.syncDatabaseId', 'type': 'str'},
        'hub_database_user_name': {'key': 'properties.hubDatabaseUserName', 'type': 'str'},
        'hub_database_password': {'key': 'properties.hubDatabasePassword', 'type': 'str'},
        'sync_state': {'key': 'properties.syncState', 'type': 'str'},
        'schema': {'key': 'properties.schema', 'type': 'SyncGroupSchema'},
        'use_private_link_connection': {'key': 'properties.usePrivateLinkConnection', 'type': 'bool'},
        'private_endpoint_name': {'key': 'properties.privateEndpointName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SyncGroup, self).__init__(**kwargs)
        self.interval = kwargs.get('interval', None)
        self.last_sync_time = None
        self.conflict_resolution_policy = kwargs.get('conflict_resolution_policy', None)
        self.sync_database_id = kwargs.get('sync_database_id', None)
        self.hub_database_user_name = kwargs.get('hub_database_user_name', None)
        self.hub_database_password = kwargs.get('hub_database_password', None)
        self.sync_state = None
        self.schema = kwargs.get('schema', None)
        self.use_private_link_connection = kwargs.get('use_private_link_connection', None)
        self.private_endpoint_name = None


class SyncGroupLogProperties(Model):
    """Properties of an Azure SQL Database sync group log.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar timestamp: Timestamp of the sync group log.
    :vartype timestamp: datetime
    :ivar type: Type of the sync group log. Possible values include: 'All',
     'Error', 'Warning', 'Success'
    :vartype type: str or ~azure.mgmt.sql.models.SyncGroupLogType
    :ivar source: Source of the sync group log.
    :vartype source: str
    :ivar details: Details of the sync group log.
    :vartype details: str
    :ivar tracing_id: TracingId of the sync group log.
    :vartype tracing_id: str
    :ivar operation_status: OperationStatus of the sync group log.
    :vartype operation_status: str
    """

    _validation = {
        'timestamp': {'readonly': True},
        'type': {'readonly': True},
        'source': {'readonly': True},
        'details': {'readonly': True},
        'tracing_id': {'readonly': True},
        'operation_status': {'readonly': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
        'tracing_id': {'key': 'tracingId', 'type': 'str'},
        'operation_status': {'key': 'operationStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SyncGroupLogProperties, self).__init__(**kwargs)
        self.timestamp = None
        self.type = None
        self.source = None
        self.details = None
        self.tracing_id = None
        self.operation_status = None


class SyncGroupSchema(Model):
    """Properties of sync group schema.

    :param tables: List of tables in sync group schema.
    :type tables: list[~azure.mgmt.sql.models.SyncGroupSchemaTable]
    :param master_sync_member_name: Name of master sync member where the
     schema is from.
    :type master_sync_member_name: str
    """

    _attribute_map = {
        'tables': {'key': 'tables', 'type': '[SyncGroupSchemaTable]'},
        'master_sync_member_name': {'key': 'masterSyncMemberName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SyncGroupSchema, self).__init__(**kwargs)
        self.tables = kwargs.get('tables', None)
        self.master_sync_member_name = kwargs.get('master_sync_member_name', None)


class SyncGroupSchemaTable(Model):
    """Properties of table in sync group schema.

    :param columns: List of columns in sync group schema.
    :type columns: list[~azure.mgmt.sql.models.SyncGroupSchemaTableColumn]
    :param quoted_name: Quoted name of sync group schema table.
    :type quoted_name: str
    """

    _attribute_map = {
        'columns': {'key': 'columns', 'type': '[SyncGroupSchemaTableColumn]'},
        'quoted_name': {'key': 'quotedName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SyncGroupSchemaTable, self).__init__(**kwargs)
        self.columns = kwargs.get('columns', None)
        self.quoted_name = kwargs.get('quoted_name', None)


class SyncGroupSchemaTableColumn(Model):
    """Properties of column in sync group table.

    :param quoted_name: Quoted name of sync group table column.
    :type quoted_name: str
    :param data_size: Data size of the column.
    :type data_size: str
    :param data_type: Data type of the column.
    :type data_type: str
    """

    _attribute_map = {
        'quoted_name': {'key': 'quotedName', 'type': 'str'},
        'data_size': {'key': 'dataSize', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SyncGroupSchemaTableColumn, self).__init__(**kwargs)
        self.quoted_name = kwargs.get('quoted_name', None)
        self.data_size = kwargs.get('data_size', None)
        self.data_type = kwargs.get('data_type', None)


class SyncMember(ProxyResource):
    """An Azure SQL Database sync member.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param database_type: Database type of the sync member. Possible values
     include: 'AzureSqlDatabase', 'SqlServerDatabase'
    :type database_type: str or ~azure.mgmt.sql.models.SyncMemberDbType
    :param sync_agent_id: ARM resource id of the sync agent in the sync
     member.
    :type sync_agent_id: str
    :param sql_server_database_id: SQL Server database id of the sync member.
    :type sql_server_database_id: str
    :param sync_member_azure_database_resource_id: ARM resource id of the sync
     member logical database, for sync members in Azure.
    :type sync_member_azure_database_resource_id: str
    :param use_private_link_connection: Whether to use private link
     connection.
    :type use_private_link_connection: bool
    :ivar private_endpoint_name: Private endpoint name of the sync member if
     use private link connection is enabled, for sync members in Azure.
    :vartype private_endpoint_name: str
    :param server_name: Server name of the member database in the sync member
    :type server_name: str
    :param database_name: Database name of the member database in the sync
     member.
    :type database_name: str
    :param user_name: User name of the member database in the sync member.
    :type user_name: str
    :param password: Password of the member database in the sync member.
    :type password: str
    :param sync_direction: Sync direction of the sync member. Possible values
     include: 'Bidirectional', 'OneWayMemberToHub', 'OneWayHubToMember'
    :type sync_direction: str or ~azure.mgmt.sql.models.SyncDirection
    :ivar sync_state: Sync state of the sync member. Possible values include:
     'SyncInProgress', 'SyncSucceeded', 'SyncFailed',
     'DisabledTombstoneCleanup', 'DisabledBackupRestore',
     'SyncSucceededWithWarnings', 'SyncCancelling', 'SyncCancelled',
     'UnProvisioned', 'Provisioning', 'Provisioned', 'ProvisionFailed',
     'DeProvisioning', 'DeProvisioned', 'DeProvisionFailed', 'Reprovisioning',
     'ReprovisionFailed', 'UnReprovisioned'
    :vartype sync_state: str or ~azure.mgmt.sql.models.SyncMemberState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'private_endpoint_name': {'readonly': True},
        'sync_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'database_type': {'key': 'properties.databaseType', 'type': 'str'},
        'sync_agent_id': {'key': 'properties.syncAgentId', 'type': 'str'},
        'sql_server_database_id': {'key': 'properties.sqlServerDatabaseId', 'type': 'str'},
        'sync_member_azure_database_resource_id': {'key': 'properties.syncMemberAzureDatabaseResourceId', 'type': 'str'},
        'use_private_link_connection': {'key': 'properties.usePrivateLinkConnection', 'type': 'bool'},
        'private_endpoint_name': {'key': 'properties.privateEndpointName', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'sync_direction': {'key': 'properties.syncDirection', 'type': 'str'},
        'sync_state': {'key': 'properties.syncState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SyncMember, self).__init__(**kwargs)
        self.database_type = kwargs.get('database_type', None)
        self.sync_agent_id = kwargs.get('sync_agent_id', None)
        self.sql_server_database_id = kwargs.get('sql_server_database_id', None)
        self.sync_member_azure_database_resource_id = kwargs.get('sync_member_azure_database_resource_id', None)
        self.use_private_link_connection = kwargs.get('use_private_link_connection', None)
        self.private_endpoint_name = None
        self.server_name = kwargs.get('server_name', None)
        self.database_name = kwargs.get('database_name', None)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)
        self.sync_direction = kwargs.get('sync_direction', None)
        self.sync_state = None


class TdeCertificate(ProxyResource):
    """A TDE certificate that can be uploaded into a server.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param private_blob: Required. The base64 encoded certificate private
     blob.
    :type private_blob: str
    :param cert_password: The certificate password.
    :type cert_password: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'private_blob': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_blob': {'key': 'properties.privateBlob', 'type': 'str'},
        'cert_password': {'key': 'properties.certPassword', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TdeCertificate, self).__init__(**kwargs)
        self.private_blob = kwargs.get('private_blob', None)
        self.cert_password = kwargs.get('cert_password', None)


class TransparentDataEncryption(ProxyResource):
    """Represents a database transparent data encryption configuration.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :param status: The status of the database transparent data encryption.
     Possible values include: 'Enabled', 'Disabled'
    :type status: str or
     ~azure.mgmt.sql.models.TransparentDataEncryptionStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'TransparentDataEncryptionStatus'},
    }

    def __init__(self, **kwargs):
        super(TransparentDataEncryption, self).__init__(**kwargs)
        self.location = None
        self.status = kwargs.get('status', None)


class TransparentDataEncryptionActivity(ProxyResource):
    """Represents a database transparent data encryption Scan.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar status: The status of the database. Possible values include:
     'Encrypting', 'Decrypting'
    :vartype status: str or
     ~azure.mgmt.sql.models.TransparentDataEncryptionActivityStatus
    :ivar percent_complete: The percent complete of the transparent data
     encryption scan for a database.
    :vartype percent_complete: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'status': {'readonly': True},
        'percent_complete': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(TransparentDataEncryptionActivity, self).__init__(**kwargs)
        self.location = None
        self.status = None
        self.percent_complete = None


class UnlinkParameters(Model):
    """Represents the parameters for Unlink Replication Link request.

    :param forced_termination: Determines whether link will be terminated in a
     forced or a friendly way.
    :type forced_termination: bool
    """

    _attribute_map = {
        'forced_termination': {'key': 'forcedTermination', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(UnlinkParameters, self).__init__(**kwargs)
        self.forced_termination = kwargs.get('forced_termination', None)


class UpsertManagedServerOperationParameters(Model):
    """UpsertManagedServerOperationParameters.

    :param family:
    :type family: str
    :param tier:
    :type tier: str
    :param v_cores:
    :type v_cores: int
    :param storage_size_in_gb:
    :type storage_size_in_gb: int
    """

    _attribute_map = {
        'family': {'key': 'family', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'v_cores': {'key': 'vCores', 'type': 'int'},
        'storage_size_in_gb': {'key': 'storageSizeInGB', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(UpsertManagedServerOperationParameters, self).__init__(**kwargs)
        self.family = kwargs.get('family', None)
        self.tier = kwargs.get('tier', None)
        self.v_cores = kwargs.get('v_cores', None)
        self.storage_size_in_gb = kwargs.get('storage_size_in_gb', None)


class UpsertManagedServerOperationStep(Model):
    """UpsertManagedServerOperationStep.

    :param order:
    :type order: int
    :param name:
    :type name: str
    :param status: Possible values include: 'NotStarted', 'InProgress',
     'SlowedDown', 'Completed', 'Failed', 'Canceled'
    :type status: str or ~azure.mgmt.sql.models.enum
    """

    _attribute_map = {
        'order': {'key': 'order', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UpsertManagedServerOperationStep, self).__init__(**kwargs)
        self.order = kwargs.get('order', None)
        self.name = kwargs.get('name', None)
        self.status = kwargs.get('status', None)


class Usage(Model):
    """ARM usage.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: ~azure.mgmt.sql.models.Name
    :ivar type: Resource type.
    :vartype type: str
    :ivar unit: Usage unit.
    :vartype unit: str
    :ivar current_value: Usage current value.
    :vartype current_value: int
    :ivar limit: Usage limit.
    :vartype limit: int
    :ivar requested_limit: Usage requested limit.
    :vartype requested_limit: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'requested_limit': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'Name'},
        'type': {'key': 'type', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
        'requested_limit': {'key': 'requestedLimit', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(Usage, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.unit = None
        self.current_value = None
        self.limit = None
        self.requested_limit = None


class VirtualCluster(TrackedResource):
    """An Azure SQL virtual cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :ivar subnet_id: Subnet resource ID for the virtual cluster.
    :vartype subnet_id: str
    :param family: If the service has different generations of hardware, for
     the same SKU, then that can be captured here.
    :type family: str
    :ivar child_resources: List of resources in this virtual cluster.
    :vartype child_resources: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'subnet_id': {'readonly': True},
        'child_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'family': {'key': 'properties.family', 'type': 'str'},
        'child_resources': {'key': 'properties.childResources', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(VirtualCluster, self).__init__(**kwargs)
        self.subnet_id = None
        self.family = kwargs.get('family', None)
        self.child_resources = None


class VirtualClusterUpdate(Model):
    """An update request for an Azure SQL Database virtual cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar subnet_id: Subnet resource ID for the virtual cluster.
    :vartype subnet_id: str
    :param family: If the service has different generations of hardware, for
     the same SKU, then that can be captured here.
    :type family: str
    :ivar child_resources: List of resources in this virtual cluster.
    :vartype child_resources: list[str]
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'subnet_id': {'readonly': True},
        'child_resources': {'readonly': True},
    }

    _attribute_map = {
        'subnet_id': {'key': 'properties.subnetId', 'type': 'str'},
        'family': {'key': 'properties.family', 'type': 'str'},
        'child_resources': {'key': 'properties.childResources', 'type': '[str]'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(VirtualClusterUpdate, self).__init__(**kwargs)
        self.subnet_id = None
        self.family = kwargs.get('family', None)
        self.child_resources = None
        self.tags = kwargs.get('tags', None)


class VirtualNetworkRule(ProxyResource):
    """A virtual network rule.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param virtual_network_subnet_id: Required. The ARM resource id of the
     virtual network subnet.
    :type virtual_network_subnet_id: str
    :param ignore_missing_vnet_service_endpoint: Create firewall rule before
     the virtual network has vnet service endpoint enabled.
    :type ignore_missing_vnet_service_endpoint: bool
    :ivar state: Virtual Network Rule State. Possible values include:
     'Initializing', 'InProgress', 'Ready', 'Deleting', 'Unknown'
    :vartype state: str or ~azure.mgmt.sql.models.VirtualNetworkRuleState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_network_subnet_id': {'required': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'virtual_network_subnet_id': {'key': 'properties.virtualNetworkSubnetId', 'type': 'str'},
        'ignore_missing_vnet_service_endpoint': {'key': 'properties.ignoreMissingVnetServiceEndpoint', 'type': 'bool'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.virtual_network_subnet_id = kwargs.get('virtual_network_subnet_id', None)
        self.ignore_missing_vnet_service_endpoint = kwargs.get('ignore_missing_vnet_service_endpoint', None)
        self.state = None


class VulnerabilityAssessmentRecurringScansProperties(Model):
    """Properties of a Vulnerability Assessment recurring scans.

    :param is_enabled: Recurring scans state.
    :type is_enabled: bool
    :param email_subscription_admins: Specifies that the schedule scan
     notification will be is sent to the subscription administrators. Default
     value: True .
    :type email_subscription_admins: bool
    :param emails: Specifies an array of e-mail addresses to which the scan
     notification is sent.
    :type emails: list[str]
    """

    _attribute_map = {
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'email_subscription_admins': {'key': 'emailSubscriptionAdmins', 'type': 'bool'},
        'emails': {'key': 'emails', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(VulnerabilityAssessmentRecurringScansProperties, self).__init__(**kwargs)
        self.is_enabled = kwargs.get('is_enabled', None)
        self.email_subscription_admins = kwargs.get('email_subscription_admins', True)
        self.emails = kwargs.get('emails', None)


class VulnerabilityAssessmentScanError(Model):
    """Properties of a vulnerability assessment scan error.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VulnerabilityAssessmentScanError, self).__init__(**kwargs)
        self.code = None
        self.message = None


class VulnerabilityAssessmentScanRecord(ProxyResource):
    """A vulnerability assessment scan record.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar scan_id: The scan ID.
    :vartype scan_id: str
    :ivar trigger_type: The scan trigger type. Possible values include:
     'OnDemand', 'Recurring'
    :vartype trigger_type: str or
     ~azure.mgmt.sql.models.VulnerabilityAssessmentScanTriggerType
    :ivar state: The scan status. Possible values include: 'Passed', 'Failed',
     'FailedToRun', 'InProgress'
    :vartype state: str or
     ~azure.mgmt.sql.models.VulnerabilityAssessmentScanState
    :ivar start_time: The scan start time (UTC).
    :vartype start_time: datetime
    :ivar end_time: The scan end time (UTC).
    :vartype end_time: datetime
    :ivar errors: The scan errors.
    :vartype errors:
     list[~azure.mgmt.sql.models.VulnerabilityAssessmentScanError]
    :ivar storage_container_path: The scan results storage container path.
    :vartype storage_container_path: str
    :ivar number_of_failed_security_checks: The number of failed security
     checks.
    :vartype number_of_failed_security_checks: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'scan_id': {'readonly': True},
        'trigger_type': {'readonly': True},
        'state': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'errors': {'readonly': True},
        'storage_container_path': {'readonly': True},
        'number_of_failed_security_checks': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scan_id': {'key': 'properties.scanId', 'type': 'str'},
        'trigger_type': {'key': 'properties.triggerType', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'errors': {'key': 'properties.errors', 'type': '[VulnerabilityAssessmentScanError]'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'number_of_failed_security_checks': {'key': 'properties.numberOfFailedSecurityChecks', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(VulnerabilityAssessmentScanRecord, self).__init__(**kwargs)
        self.scan_id = None
        self.trigger_type = None
        self.state = None
        self.start_time = None
        self.end_time = None
        self.errors = None
        self.storage_container_path = None
        self.number_of_failed_security_checks = None


class WorkloadClassifier(ProxyResource):
    """Workload classifier operations for a data warehouse.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param member_name: Required. The workload classifier member name.
    :type member_name: str
    :param label: The workload classifier label.
    :type label: str
    :param context: The workload classifier context.
    :type context: str
    :param start_time: The workload classifier start time for classification.
    :type start_time: str
    :param end_time: The workload classifier end time for classification.
    :type end_time: str
    :param importance: The workload classifier importance.
    :type importance: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'member_name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'member_name': {'key': 'properties.memberName', 'type': 'str'},
        'label': {'key': 'properties.label', 'type': 'str'},
        'context': {'key': 'properties.context', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'str'},
        'end_time': {'key': 'properties.endTime', 'type': 'str'},
        'importance': {'key': 'properties.importance', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WorkloadClassifier, self).__init__(**kwargs)
        self.member_name = kwargs.get('member_name', None)
        self.label = kwargs.get('label', None)
        self.context = kwargs.get('context', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.importance = kwargs.get('importance', None)


class WorkloadGroup(ProxyResource):
    """Workload group operations for a data warehouse.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param min_resource_percent: Required. The workload group minimum
     percentage resource.
    :type min_resource_percent: int
    :param max_resource_percent: Required. The workload group cap percentage
     resource.
    :type max_resource_percent: int
    :param min_resource_percent_per_request: Required. The workload group
     request minimum grant percentage.
    :type min_resource_percent_per_request: float
    :param max_resource_percent_per_request: The workload group request
     maximum grant percentage.
    :type max_resource_percent_per_request: float
    :param importance: The workload group importance level.
    :type importance: str
    :param query_execution_timeout: The workload group query execution
     timeout.
    :type query_execution_timeout: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'min_resource_percent': {'required': True},
        'max_resource_percent': {'required': True},
        'min_resource_percent_per_request': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'min_resource_percent': {'key': 'properties.minResourcePercent', 'type': 'int'},
        'max_resource_percent': {'key': 'properties.maxResourcePercent', 'type': 'int'},
        'min_resource_percent_per_request': {'key': 'properties.minResourcePercentPerRequest', 'type': 'float'},
        'max_resource_percent_per_request': {'key': 'properties.maxResourcePercentPerRequest', 'type': 'float'},
        'importance': {'key': 'properties.importance', 'type': 'str'},
        'query_execution_timeout': {'key': 'properties.queryExecutionTimeout', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(WorkloadGroup, self).__init__(**kwargs)
        self.min_resource_percent = kwargs.get('min_resource_percent', None)
        self.max_resource_percent = kwargs.get('max_resource_percent', None)
        self.min_resource_percent_per_request = kwargs.get('min_resource_percent_per_request', None)
        self.max_resource_percent_per_request = kwargs.get('max_resource_percent_per_request', None)
        self.importance = kwargs.get('importance', None)
        self.query_execution_timeout = kwargs.get('query_execution_timeout', None)
