# -*- coding: utf-8 -*-

from plone.app.robotframework.testing import AUTOLOGIN_LIBRARY_FIXTURE
from plone.app.testing import FunctionalTesting
from plone.app.testing import IntegrationTesting
from plone.app.testing import PLONE_FIXTURE
from plone.app.testing import PloneSandboxLayer
from plone.testing import z2


class Fixture(PloneSandboxLayer):

    defaultBases = (PLONE_FIXTURE,)

    def setUpZope(self, app, configurationContext):
        import interlegis.intranetmodelo.policy
        self.loadZCML(package=interlegis.intranetmodelo.policy)
        import interlegis.intranetmodelo.departments
        self.loadZCML(
            package=interlegis.intranetmodelo.departments,
            name='dependencies.zcml'
        )

        z2.installProduct(app, 'collective.classifieds')
        z2.installProduct(app, 'Products.CMFPlacefulWorkflow')
        z2.installProduct(app, 'Products.DateRecurringIndex')
        z2.installProduct(app, 'Products.SQLAlchemyDA')

    def setUpPloneSite(self, portal):
        # set the default workflow
        workflow_tool = portal['portal_workflow']
        workflow_tool.setDefaultChain('simple_publication_workflow')
        # install the policy package
        self.applyProfile(portal, 'interlegis.intranetmodelo.policy:default')

    def tearDownZope(self, app):
        z2.uninstallProduct(app, 'collective.classifieds')
        z2.uninstallProduct(app, 'Products.CMFPlacefulWorkflow')
        z2.uninstallProduct(app, 'Products.DateRecurringIndex')
        z2.uninstallProduct(app, 'Products.SQLAlchemyDA')

FIXTURE = Fixture()

INTEGRATION_TESTING = IntegrationTesting(
    bases=(FIXTURE,),
    name='interlegis.intranetmodelo.policy:Integration')

FUNCTIONAL_TESTING = FunctionalTesting(
    bases=(FIXTURE,),
    name='interlegis.intranetmodelo.policy:Functional')

ROBOT_TESTING = FunctionalTesting(
    bases=(FIXTURE, AUTOLOGIN_LIBRARY_FIXTURE, z2.ZSERVER_FIXTURE),
    name='interlegis.intranetmodelo.policy:Robot',
)
