/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.testworker;

import java.util.concurrent.TimeoutException;
import org.openqa.selenium.testworker.ThreadStartedAt;
import org.openqa.selenium.testworker.TrackableRunnable;

public class TrackableThread
extends Thread {
    private TrackableRunnable trackedTarget;

    public TrackableThread(TrackableRunnable target, String name) {
        super((Runnable)target, name);
        this.trackedTarget = target;
    }

    public TrackableThread(ThreadGroup group, TrackableRunnable target, String name) {
        super(group, target, name);
        this.trackedTarget = target;
    }

    public TrackableThread(ThreadGroup group, TrackableRunnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
        this.trackedTarget = target;
    }

    public synchronized void start() {
        ThreadStartedAt tsa = new ThreadStartedAt();
        this.trackedTarget.setThreadStartedAt(tsa);
        super.start();
    }

    public void joinOrInterrupt(long millisJoinTimeout, long millisInterruptTimeout) throws Throwable {
        this.join(millisJoinTimeout);
        if (this.isAlive()) {
            this.interrupt();
            this.join(millisInterruptTimeout);
            if (this.isAlive()) {
                throw new TimeoutException("Thread refused to die");
            }
        }
        if (this.trackedTarget.getThrowable() != null) {
            throw new Throwable("Underlying thread had exception", this.trackedTarget.getThrowable());
        }
    }

    public Object getResult(long millisJoinTimeout, long millisInterruptTimeout) throws Throwable {
        this.joinOrInterrupt(millisJoinTimeout, millisInterruptTimeout);
        return this.trackedTarget.getResult();
    }

    public Object getResult() throws Throwable {
        return this.getResult(10000L, 1000L);
    }
}

