# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AzureCapacity(Model):
    """Azure capacity definition.

    All required parameters must be populated in order to send to Azure.

    :param scale_type: Required. Scale type. Possible values include:
     'automatic', 'manual', 'none'
    :type scale_type: str or ~azure.mgmt.kusto.models.AzureScaleType
    :param minimum: Required. Minimum allowed capacity.
    :type minimum: int
    :param maximum: Required. Maximum allowed capacity.
    :type maximum: int
    :param default: Required. The default capacity that would be used.
    :type default: int
    """

    _validation = {
        'scale_type': {'required': True},
        'minimum': {'required': True},
        'maximum': {'required': True},
        'default': {'required': True},
    }

    _attribute_map = {
        'scale_type': {'key': 'scaleType', 'type': 'str'},
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AzureCapacity, self).__init__(**kwargs)
        self.scale_type = kwargs.get('scale_type', None)
        self.minimum = kwargs.get('minimum', None)
        self.maximum = kwargs.get('maximum', None)
        self.default = kwargs.get('default', None)


class Resource(Model):
    """Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for a Azure Resource Manager resource with an
    etag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class AzureResourceSku(Model):
    """Azure resource SKU definition.

    :param resource_type: Resource Namespace and Type.
    :type resource_type: str
    :param sku: The SKU details.
    :type sku: ~azure.mgmt.kusto.models.AzureSku
    :param capacity: The number of instances of the cluster.
    :type capacity: ~azure.mgmt.kusto.models.AzureCapacity
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'AzureSku'},
        'capacity': {'key': 'capacity', 'type': 'AzureCapacity'},
    }

    def __init__(self, **kwargs):
        super(AzureResourceSku, self).__init__(**kwargs)
        self.resource_type = kwargs.get('resource_type', None)
        self.sku = kwargs.get('sku', None)
        self.capacity = kwargs.get('capacity', None)


class AzureSku(Model):
    """Azure SKU definition.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. SKU name. Possible values include:
     'Standard_DS13_v2+1TB_PS', 'Standard_DS13_v2+2TB_PS',
     'Standard_DS14_v2+3TB_PS', 'Standard_DS14_v2+4TB_PS', 'Standard_D13_v2',
     'Standard_D14_v2', 'Standard_L8s', 'Standard_L16s', 'Standard_D11_v2',
     'Standard_D12_v2', 'Standard_L4s', 'Dev(No SLA)_Standard_D11_v2'
    :type name: str or ~azure.mgmt.kusto.models.AzureSkuName
    :param capacity: The number of instances of the cluster.
    :type capacity: int
    :param tier: Required. SKU tier. Possible values include: 'Basic',
     'Standard'
    :type tier: str or ~azure.mgmt.kusto.models.AzureSkuTier
    """

    _validation = {
        'name': {'required': True},
        'tier': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureSku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.capacity = kwargs.get('capacity', None)
        self.tier = kwargs.get('tier', None)


class CheckNameResult(Model):
    """The result returned from a check name availability request.

    :param name_available: Specifies a Boolean value that indicates if the
     name is available.
    :type name_available: bool
    :param name: The name that was checked.
    :type name: str
    :param message: Message indicating an unavailable name due to a conflict,
     or a description of the naming rules that are violated.
    :type message: str
    :param reason: Message providing the reason why the given name is invalid.
     Possible values include: 'Invalid', 'AlreadyExists'
    :type reason: str or ~azure.mgmt.kusto.models.Reason
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckNameResult, self).__init__(**kwargs)
        self.name_available = kwargs.get('name_available', None)
        self.name = kwargs.get('name', None)
        self.message = kwargs.get('message', None)
        self.reason = kwargs.get('reason', None)


class CloudError(Model):
    """An error response from Kusto.

    :param error: An error response from Kusto.
    :type error: ~azure.mgmt.kusto.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(self, **kwargs):
        super(CloudError, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CloudErrorBody(Model):
    """An error response from Kusto.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable
     for displaying in a user interface.
    :type message: str
    :param target: The target of the particular error. For example, the name
     of the property in error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.kusto.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(self, **kwargs):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs.get('location', None)


class Cluster(TrackedResource):
    """Class representing a Kusto cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param sku: Required. The SKU of the cluster.
    :type sku: ~azure.mgmt.kusto.models.AzureSku
    :param zones: The availability zones of the cluster.
    :type zones: list[str]
    :ivar state: The state of the resource. Possible values include:
     'Creating', 'Unavailable', 'Running', 'Deleting', 'Deleted', 'Stopping',
     'Stopped', 'Starting', 'Updating'
    :vartype state: str or ~azure.mgmt.kusto.models.State
    :ivar provisioning_state: The provisioned state of the resource. Possible
     values include: 'Running', 'Creating', 'Deleting', 'Succeeded', 'Failed',
     'Moving'
    :vartype provisioning_state: str or
     ~azure.mgmt.kusto.models.ProvisioningState
    :ivar uri: The cluster URI.
    :vartype uri: str
    :ivar data_ingestion_uri: The cluster data ingestion URI.
    :vartype data_ingestion_uri: str
    :param trusted_external_tenants: The cluster's external tenants.
    :type trusted_external_tenants:
     list[~azure.mgmt.kusto.models.TrustedExternalTenant]
    :param optimized_autoscale: Optimized auto scale definition.
    :type optimized_autoscale: ~azure.mgmt.kusto.models.OptimizedAutoscale
    :param enable_disk_encryption: A boolean value that indicates if the
     cluster's disks are encrypted.
    :type enable_disk_encryption: bool
    :param enable_streaming_ingest: A boolean value that indicates if the
     streaming ingest is enabled. Default value: False .
    :type enable_streaming_ingest: bool
    :param virtual_network_configuration: Virtual network definition.
    :type virtual_network_configuration:
     ~azure.mgmt.kusto.models.VirtualNetworkConfiguration
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'uri': {'readonly': True},
        'data_ingestion_uri': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'AzureSku'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'data_ingestion_uri': {'key': 'properties.dataIngestionUri', 'type': 'str'},
        'trusted_external_tenants': {'key': 'properties.trustedExternalTenants', 'type': '[TrustedExternalTenant]'},
        'optimized_autoscale': {'key': 'properties.optimizedAutoscale', 'type': 'OptimizedAutoscale'},
        'enable_disk_encryption': {'key': 'properties.enableDiskEncryption', 'type': 'bool'},
        'enable_streaming_ingest': {'key': 'properties.enableStreamingIngest', 'type': 'bool'},
        'virtual_network_configuration': {'key': 'properties.virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
    }

    def __init__(self, **kwargs):
        super(Cluster, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.zones = kwargs.get('zones', None)
        self.state = None
        self.provisioning_state = None
        self.uri = None
        self.data_ingestion_uri = None
        self.trusted_external_tenants = kwargs.get('trusted_external_tenants', None)
        self.optimized_autoscale = kwargs.get('optimized_autoscale', None)
        self.enable_disk_encryption = kwargs.get('enable_disk_encryption', None)
        self.enable_streaming_ingest = kwargs.get('enable_streaming_ingest', False)
        self.virtual_network_configuration = kwargs.get('virtual_network_configuration', None)


class ClusterCheckNameRequest(Model):
    """The result returned from a cluster check name availability request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Cluster name.
    :type name: str
    :ivar type: Required. The type of resource, Microsoft.Kusto/clusters.
     Default value: "Microsoft.Kusto/clusters" .
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Kusto/clusters"

    def __init__(self, **kwargs):
        super(ClusterCheckNameRequest, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class ClusterUpdate(Resource):
    """Class representing an update to a Kusto cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Resource location.
    :type location: str
    :param sku: The SKU of the cluster.
    :type sku: ~azure.mgmt.kusto.models.AzureSku
    :ivar state: The state of the resource. Possible values include:
     'Creating', 'Unavailable', 'Running', 'Deleting', 'Deleted', 'Stopping',
     'Stopped', 'Starting', 'Updating'
    :vartype state: str or ~azure.mgmt.kusto.models.State
    :ivar provisioning_state: The provisioned state of the resource. Possible
     values include: 'Running', 'Creating', 'Deleting', 'Succeeded', 'Failed',
     'Moving'
    :vartype provisioning_state: str or
     ~azure.mgmt.kusto.models.ProvisioningState
    :ivar uri: The cluster URI.
    :vartype uri: str
    :ivar data_ingestion_uri: The cluster data ingestion URI.
    :vartype data_ingestion_uri: str
    :param trusted_external_tenants: The cluster's external tenants.
    :type trusted_external_tenants:
     list[~azure.mgmt.kusto.models.TrustedExternalTenant]
    :param optimized_autoscale: Optimized auto scale definition.
    :type optimized_autoscale: ~azure.mgmt.kusto.models.OptimizedAutoscale
    :param enable_disk_encryption: A boolean value that indicates if the
     cluster's disks are encrypted.
    :type enable_disk_encryption: bool
    :param enable_streaming_ingest: A boolean value that indicates if the
     streaming ingest is enabled. Default value: False .
    :type enable_streaming_ingest: bool
    :param virtual_network_configuration: Virtual network definition.
    :type virtual_network_configuration:
     ~azure.mgmt.kusto.models.VirtualNetworkConfiguration
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'uri': {'readonly': True},
        'data_ingestion_uri': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'AzureSku'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'data_ingestion_uri': {'key': 'properties.dataIngestionUri', 'type': 'str'},
        'trusted_external_tenants': {'key': 'properties.trustedExternalTenants', 'type': '[TrustedExternalTenant]'},
        'optimized_autoscale': {'key': 'properties.optimizedAutoscale', 'type': 'OptimizedAutoscale'},
        'enable_disk_encryption': {'key': 'properties.enableDiskEncryption', 'type': 'bool'},
        'enable_streaming_ingest': {'key': 'properties.enableStreamingIngest', 'type': 'bool'},
        'virtual_network_configuration': {'key': 'properties.virtualNetworkConfiguration', 'type': 'VirtualNetworkConfiguration'},
    }

    def __init__(self, **kwargs):
        super(ClusterUpdate, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs.get('location', None)
        self.sku = kwargs.get('sku', None)
        self.state = None
        self.provisioning_state = None
        self.uri = None
        self.data_ingestion_uri = None
        self.trusted_external_tenants = kwargs.get('trusted_external_tenants', None)
        self.optimized_autoscale = kwargs.get('optimized_autoscale', None)
        self.enable_disk_encryption = kwargs.get('enable_disk_encryption', None)
        self.enable_streaming_ingest = kwargs.get('enable_streaming_ingest', False)
        self.virtual_network_configuration = kwargs.get('virtual_network_configuration', None)


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have
    everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProxyResource, self).__init__(**kwargs)


class Database(ProxyResource):
    """Class representing a Kusto database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :ivar provisioning_state: The provisioned state of the resource. Possible
     values include: 'Running', 'Creating', 'Deleting', 'Succeeded', 'Failed',
     'Moving'
    :vartype provisioning_state: str or
     ~azure.mgmt.kusto.models.ProvisioningState
    :param soft_delete_period: The time the data should be kept before it
     stops being accessible to queries in TimeSpan.
    :type soft_delete_period: timedelta
    :param hot_cache_period: The time the data should be kept in cache for
     fast queries in TimeSpan.
    :type hot_cache_period: timedelta
    :param statistics: The statistics of the database.
    :type statistics: ~azure.mgmt.kusto.models.DatabaseStatistics
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'soft_delete_period': {'key': 'properties.softDeletePeriod', 'type': 'duration'},
        'hot_cache_period': {'key': 'properties.hotCachePeriod', 'type': 'duration'},
        'statistics': {'key': 'properties.statistics', 'type': 'DatabaseStatistics'},
    }

    def __init__(self, **kwargs):
        super(Database, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.provisioning_state = None
        self.soft_delete_period = kwargs.get('soft_delete_period', None)
        self.hot_cache_period = kwargs.get('hot_cache_period', None)
        self.statistics = kwargs.get('statistics', None)


class DatabaseCheckNameRequest(Model):
    """The result returned from a database check name availability request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Database name.
    :type name: str
    :ivar type: Required. The type of resource,
     Microsoft.Kusto/clusters/databases. Default value:
     "Microsoft.Kusto/clusters/databases" .
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Kusto/clusters/databases"

    def __init__(self, **kwargs):
        super(DatabaseCheckNameRequest, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class DatabasePrincipal(Model):
    """A class representing database principal entity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param role: Required. Database principal role. Possible values include:
     'Admin', 'Ingestor', 'Monitor', 'User', 'UnrestrictedViewers', 'Viewer'
    :type role: str or ~azure.mgmt.kusto.models.DatabasePrincipalRole
    :param name: Required. Database principal name.
    :type name: str
    :param type: Required. Database principal type. Possible values include:
     'App', 'Group', 'User'
    :type type: str or ~azure.mgmt.kusto.models.DatabasePrincipalType
    :param fqn: Database principal fully qualified name.
    :type fqn: str
    :param email: Database principal email if exists.
    :type email: str
    :param app_id: Application id - relevant only for application principal
     type.
    :type app_id: str
    :ivar tenant_name: The tenant name of the principal
    :vartype tenant_name: str
    """

    _validation = {
        'role': {'required': True},
        'name': {'required': True},
        'type': {'required': True},
        'tenant_name': {'readonly': True},
    }

    _attribute_map = {
        'role': {'key': 'role', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'fqn': {'key': 'fqn', 'type': 'str'},
        'email': {'key': 'email', 'type': 'str'},
        'app_id': {'key': 'appId', 'type': 'str'},
        'tenant_name': {'key': 'tenantName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DatabasePrincipal, self).__init__(**kwargs)
        self.role = kwargs.get('role', None)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)
        self.fqn = kwargs.get('fqn', None)
        self.email = kwargs.get('email', None)
        self.app_id = kwargs.get('app_id', None)
        self.tenant_name = None


class DatabasePrincipalListRequest(Model):
    """The list Kusto database principals operation request.

    :param value: The list of Kusto database principals.
    :type value: list[~azure.mgmt.kusto.models.DatabasePrincipal]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatabasePrincipal]'},
    }

    def __init__(self, **kwargs):
        super(DatabasePrincipalListRequest, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class DatabasePrincipalListResult(Model):
    """The list Kusto database principals operation response.

    :param value: The list of Kusto database principals.
    :type value: list[~azure.mgmt.kusto.models.DatabasePrincipal]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DatabasePrincipal]'},
    }

    def __init__(self, **kwargs):
        super(DatabasePrincipalListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class DatabaseStatistics(Model):
    """A class that contains database statistics information.

    :param size: The database size - the total size of compressed data and
     index in bytes.
    :type size: float
    """

    _attribute_map = {
        'size': {'key': 'size', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(DatabaseStatistics, self).__init__(**kwargs)
        self.size = kwargs.get('size', None)


class DatabaseUpdate(Resource):
    """Class representing an update to a Kusto database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :ivar provisioning_state: The provisioned state of the resource. Possible
     values include: 'Running', 'Creating', 'Deleting', 'Succeeded', 'Failed',
     'Moving'
    :vartype provisioning_state: str or
     ~azure.mgmt.kusto.models.ProvisioningState
    :param soft_delete_period: The time the data should be kept before it
     stops being accessible to queries in TimeSpan.
    :type soft_delete_period: timedelta
    :param hot_cache_period: The time the data should be kept in cache for
     fast queries in TimeSpan.
    :type hot_cache_period: timedelta
    :param statistics: The statistics of the database.
    :type statistics: ~azure.mgmt.kusto.models.DatabaseStatistics
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'soft_delete_period': {'key': 'properties.softDeletePeriod', 'type': 'duration'},
        'hot_cache_period': {'key': 'properties.hotCachePeriod', 'type': 'duration'},
        'statistics': {'key': 'properties.statistics', 'type': 'DatabaseStatistics'},
    }

    def __init__(self, **kwargs):
        super(DatabaseUpdate, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.provisioning_state = None
        self.soft_delete_period = kwargs.get('soft_delete_period', None)
        self.hot_cache_period = kwargs.get('hot_cache_period', None)
        self.statistics = kwargs.get('statistics', None)


class DataConnection(ProxyResource):
    """Class representing an data connection.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EventHubDataConnection, IotHubDataConnection,
    EventGridDataConnection

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'EventHub': 'EventHubDataConnection', 'IotHub': 'IotHubDataConnection', 'EventGrid': 'EventGridDataConnection'}
    }

    def __init__(self, **kwargs):
        super(DataConnection, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.kind = None
        self.kind = 'DataConnection'


class DataConnectionCheckNameRequest(Model):
    """The result returned from a data connections check name availability
    request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Data Connection name.
    :type name: str
    :ivar type: Required. The type of resource,
     Microsoft.Kusto/clusters/databases/dataConnections. Default value:
     "Microsoft.Kusto/clusters/databases/dataConnections" .
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Kusto/clusters/databases/dataConnections"

    def __init__(self, **kwargs):
        super(DataConnectionCheckNameRequest, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class DataConnectionValidation(Model):
    """Class representing an data connection validation.

    :param data_connection_name: The name of the data connection.
    :type data_connection_name: str
    :param properties: The data connection properties to validate.
    :type properties: ~azure.mgmt.kusto.models.DataConnection
    """

    _attribute_map = {
        'data_connection_name': {'key': 'dataConnectionName', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DataConnection'},
    }

    def __init__(self, **kwargs):
        super(DataConnectionValidation, self).__init__(**kwargs)
        self.data_connection_name = kwargs.get('data_connection_name', None)
        self.properties = kwargs.get('properties', None)


class DataConnectionValidationListResult(Model):
    """The list Kusto data connection validation result.

    :param value: The list of Kusto data connection validation errors.
    :type value: list[~azure.mgmt.kusto.models.DataConnectionValidationResult]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataConnectionValidationResult]'},
    }

    def __init__(self, **kwargs):
        super(DataConnectionValidationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class DataConnectionValidationResult(Model):
    """The result returned from a data connection validation request.

    :param error_message: A message which indicates a problem in data
     connection validation.
    :type error_message: str
    """

    _attribute_map = {
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataConnectionValidationResult, self).__init__(**kwargs)
        self.error_message = kwargs.get('error_message', None)


class EventGridDataConnection(DataConnection):
    """Class representing an Event Grid data connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param storage_account_resource_id: Required. The resource ID of the
     storage account where the data resides.
    :type storage_account_resource_id: str
    :param event_hub_resource_id: Required. The resource ID where the event
     grid is configured to send events.
    :type event_hub_resource_id: str
    :param consumer_group: Required. The event hub consumer group.
    :type consumer_group: str
    :param table_name: Required. The table where the data should be ingested.
     Optionally the table information can be added to each message.
    :type table_name: str
    :param mapping_rule_name: The mapping rule to be used to ingest the data.
     Optionally the mapping information can be added to each message.
    :type mapping_rule_name: str
    :param data_format: Required. The data format of the message. Optionally
     the data format can be added to each message. Possible values include:
     'MULTIJSON', 'JSON', 'CSV', 'TSV', 'SCSV', 'SOHSV', 'PSV', 'TXT', 'RAW',
     'SINGLEJSON', 'AVRO'
    :type data_format: str or ~azure.mgmt.kusto.models.DataFormat
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'storage_account_resource_id': {'required': True},
        'event_hub_resource_id': {'required': True},
        'consumer_group': {'required': True},
        'table_name': {'required': True},
        'data_format': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'storage_account_resource_id': {'key': 'properties.storageAccountResourceId', 'type': 'str'},
        'event_hub_resource_id': {'key': 'properties.eventHubResourceId', 'type': 'str'},
        'consumer_group': {'key': 'properties.consumerGroup', 'type': 'str'},
        'table_name': {'key': 'properties.tableName', 'type': 'str'},
        'mapping_rule_name': {'key': 'properties.mappingRuleName', 'type': 'str'},
        'data_format': {'key': 'properties.dataFormat', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EventGridDataConnection, self).__init__(**kwargs)
        self.storage_account_resource_id = kwargs.get('storage_account_resource_id', None)
        self.event_hub_resource_id = kwargs.get('event_hub_resource_id', None)
        self.consumer_group = kwargs.get('consumer_group', None)
        self.table_name = kwargs.get('table_name', None)
        self.mapping_rule_name = kwargs.get('mapping_rule_name', None)
        self.data_format = kwargs.get('data_format', None)
        self.kind = 'EventGrid'


class EventHubDataConnection(DataConnection):
    """Class representing an event hub data connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param event_hub_resource_id: Required. The resource ID of the event hub
     to be used to create a data connection.
    :type event_hub_resource_id: str
    :param consumer_group: Required. The event hub consumer group.
    :type consumer_group: str
    :param table_name: The table where the data should be ingested. Optionally
     the table information can be added to each message.
    :type table_name: str
    :param mapping_rule_name: The mapping rule to be used to ingest the data.
     Optionally the mapping information can be added to each message.
    :type mapping_rule_name: str
    :param data_format: The data format of the message. Optionally the data
     format can be added to each message. Possible values include: 'MULTIJSON',
     'JSON', 'CSV', 'TSV', 'SCSV', 'SOHSV', 'PSV', 'TXT', 'RAW', 'SINGLEJSON',
     'AVRO'
    :type data_format: str or ~azure.mgmt.kusto.models.DataFormat
    :param event_system_properties: System properties of the event hub
    :type event_system_properties: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'event_hub_resource_id': {'required': True},
        'consumer_group': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'event_hub_resource_id': {'key': 'properties.eventHubResourceId', 'type': 'str'},
        'consumer_group': {'key': 'properties.consumerGroup', 'type': 'str'},
        'table_name': {'key': 'properties.tableName', 'type': 'str'},
        'mapping_rule_name': {'key': 'properties.mappingRuleName', 'type': 'str'},
        'data_format': {'key': 'properties.dataFormat', 'type': 'str'},
        'event_system_properties': {'key': 'properties.eventSystemProperties', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(EventHubDataConnection, self).__init__(**kwargs)
        self.event_hub_resource_id = kwargs.get('event_hub_resource_id', None)
        self.consumer_group = kwargs.get('consumer_group', None)
        self.table_name = kwargs.get('table_name', None)
        self.mapping_rule_name = kwargs.get('mapping_rule_name', None)
        self.data_format = kwargs.get('data_format', None)
        self.event_system_properties = kwargs.get('event_system_properties', None)
        self.kind = 'EventHub'


class IotHubDataConnection(DataConnection):
    """Class representing an iot hub data connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param iot_hub_resource_id: Required. The resource ID of the Iot hub to be
     used to create a data connection.
    :type iot_hub_resource_id: str
    :param consumer_group: Required. The iot hub consumer group.
    :type consumer_group: str
    :param table_name: The table where the data should be ingested. Optionally
     the table information can be added to each message.
    :type table_name: str
    :param mapping_rule_name: The mapping rule to be used to ingest the data.
     Optionally the mapping information can be added to each message.
    :type mapping_rule_name: str
    :param data_format: The data format of the message. Optionally the data
     format can be added to each message. Possible values include: 'MULTIJSON',
     'JSON', 'CSV', 'TSV', 'SCSV', 'SOHSV', 'PSV', 'TXT', 'RAW', 'SINGLEJSON',
     'AVRO'
    :type data_format: str or ~azure.mgmt.kusto.models.DataFormat
    :param event_system_properties: System properties of the iot hub
    :type event_system_properties: list[str]
    :param shared_access_policy_name: Required. The name of the share access
     policy name
    :type shared_access_policy_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'iot_hub_resource_id': {'required': True},
        'consumer_group': {'required': True},
        'shared_access_policy_name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'iot_hub_resource_id': {'key': 'properties.iotHubResourceId', 'type': 'str'},
        'consumer_group': {'key': 'properties.consumerGroup', 'type': 'str'},
        'table_name': {'key': 'properties.tableName', 'type': 'str'},
        'mapping_rule_name': {'key': 'properties.mappingRuleName', 'type': 'str'},
        'data_format': {'key': 'properties.dataFormat', 'type': 'str'},
        'event_system_properties': {'key': 'properties.eventSystemProperties', 'type': '[str]'},
        'shared_access_policy_name': {'key': 'properties.sharedAccessPolicyName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IotHubDataConnection, self).__init__(**kwargs)
        self.iot_hub_resource_id = kwargs.get('iot_hub_resource_id', None)
        self.consumer_group = kwargs.get('consumer_group', None)
        self.table_name = kwargs.get('table_name', None)
        self.mapping_rule_name = kwargs.get('mapping_rule_name', None)
        self.data_format = kwargs.get('data_format', None)
        self.event_system_properties = kwargs.get('event_system_properties', None)
        self.shared_access_policy_name = kwargs.get('shared_access_policy_name', None)
        self.kind = 'IotHub'


class Operation(Model):
    """A REST API operation.

    :param name: The operation name. This is of the format
     {provider}/{resource}/{operation}.
    :type name: str
    :param display: The object that describes the operation.
    :type display: ~azure.mgmt.kusto.models.OperationDisplay
    :param origin: The intended executor of the operation.
    :type origin: str
    :param properties: Properties of the operation.
    :type properties: object
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.properties = kwargs.get('properties', None)


class OperationDisplay(Model):
    """The object that describes the operation.

    :param provider: Friendly name of the resource provider.
    :type provider: str
    :param operation: The operation type. For example: read, write, delete.
    :type operation: str
    :param resource: The resource type on which the operation is performed.
    :type resource: str
    :param description: The friendly name of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.operation = kwargs.get('operation', None)
        self.resource = kwargs.get('resource', None)
        self.description = kwargs.get('description', None)


class OptimizedAutoscale(Model):
    """A class that contains the optimized auto scale definition.

    All required parameters must be populated in order to send to Azure.

    :param version: Required. The version of the template defined, for
     instance 1.
    :type version: int
    :param is_enabled: Required. A boolean value that indicate if the
     optimized autoscale feature is enabled or not.
    :type is_enabled: bool
    :param minimum: Required. Minimum allowed instances count.
    :type minimum: int
    :param maximum: Required. Maximum allowed instances count.
    :type maximum: int
    """

    _validation = {
        'version': {'required': True},
        'is_enabled': {'required': True},
        'minimum': {'required': True},
        'maximum': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'int'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(OptimizedAutoscale, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)
        self.is_enabled = kwargs.get('is_enabled', None)
        self.minimum = kwargs.get('minimum', None)
        self.maximum = kwargs.get('maximum', None)


class SkuDescription(Model):
    """The Kusto SKU description of given resource type.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_type: The resource type
    :vartype resource_type: str
    :ivar name: The name of the SKU
    :vartype name: str
    :ivar tier: The tier of the SKU
    :vartype tier: str
    :ivar locations: The set of locations that the SKU is available
    :vartype locations: list[str]
    :ivar location_info: Locations and zones
    :vartype location_info: list[~azure.mgmt.kusto.models.SkuLocationInfoItem]
    :ivar restrictions: The restrictions because of which SKU cannot be used
    :vartype restrictions: list[object]
    """

    _validation = {
        'resource_type': {'readonly': True},
        'name': {'readonly': True},
        'tier': {'readonly': True},
        'locations': {'readonly': True},
        'location_info': {'readonly': True},
        'restrictions': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'location_info': {'key': 'locationInfo', 'type': '[SkuLocationInfoItem]'},
        'restrictions': {'key': 'restrictions', 'type': '[object]'},
    }

    def __init__(self, **kwargs):
        super(SkuDescription, self).__init__(**kwargs)
        self.resource_type = None
        self.name = None
        self.tier = None
        self.locations = None
        self.location_info = None
        self.restrictions = None


class SkuLocationInfoItem(Model):
    """The locations and zones info for SKU.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The available location of the SKU.
    :type location: str
    :param zones: The available zone of the SKU.
    :type zones: list[str]
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(SkuLocationInfoItem, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.zones = kwargs.get('zones', None)


class TrustedExternalTenant(Model):
    """Represents a tenant ID that is trusted by the cluster.

    :param value: GUID representing an external tenant.
    :type value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TrustedExternalTenant, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class VirtualNetworkConfiguration(Model):
    """A class that contains virtual network definition.

    All required parameters must be populated in order to send to Azure.

    :param subnet_id: Required. The subnet resource id.
    :type subnet_id: str
    :param engine_public_ip_id: Required. Engine service's public IP address
     resource id.
    :type engine_public_ip_id: str
    :param data_management_public_ip_id: Required. Data management's service
     public IP address resource id.
    :type data_management_public_ip_id: str
    """

    _validation = {
        'subnet_id': {'required': True},
        'engine_public_ip_id': {'required': True},
        'data_management_public_ip_id': {'required': True},
    }

    _attribute_map = {
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'engine_public_ip_id': {'key': 'enginePublicIpId', 'type': 'str'},
        'data_management_public_ip_id': {'key': 'dataManagementPublicIpId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkConfiguration, self).__init__(**kwargs)
        self.subnet_id = kwargs.get('subnet_id', None)
        self.engine_public_ip_id = kwargs.get('engine_public_ip_id', None)
        self.data_management_public_ip_id = kwargs.get('data_management_public_ip_id', None)
