import datetime
from pysapp.forms import Form
from formencode.validators import Email

class MyForm(Form):
    def __init__(self):
        Form.__init__(self, 'myform')
        
        el = self.add_header('input-els', 'Optional Elements')
        el = self.add_button('button', 'Button', defaultval='PushMe')
        el = self.add_checkbox('checkbox', 'Checkbox')
        el = self.add_file('file', 'File')
        el = self.add_hidden('hidden', defaultval='my hidden val')
        el = self.add_image('image', 'Image', defaultval='my image val', src='images/icons/b_edit.png')
        el = self.add_text('text', 'Text')
        el.add_note('a note')
        el.add_note('an <strong>HTML</strong> note', False)
        el = self.add_text('nolabel', defaultval='No Label')
        el.add_note('a note')
        el = self.add_password('password', 'Password')
        el = self.add_confirm('confirm', 'Confirm Password', match='password')
        el.add_note('confirm characters for password field are automatically masked')
        el = self.add_date('date', 'Date', defaultval=datetime.date(2009, 12, 3))
        el.add_note('note the automatic conversion from datetime object')
        emel = self.add_email('email', 'Email')
        el = self.add_confirm('confirmeml', 'Confirm Email', match=emel)
        el.add_note('note you can confirm with the name of the field or the element object')
        el.add_note('when not confirming password field, characters are not masked')
        el = self.add_time('time', 'Time')
        el = self.add_url('url', 'URL')
        options = [('1', 'one'), ('2','two')]
        el = self.add_select('select', options, 'Select')
        el = self.add_mselect('mselect', options, 'Multi Select')
        el = self.add_textarea('textarea', 'Text Area')
        el = self.add_fixed('fixed', 'Fixed', 'fixed val')
        el = self.add_fixed('fixed-no-label', defaultval = 'fixed no label')
        el = self.add_static('static', 'Static', 'static val')
        el = self.add_static('static-no-label', defaultval='static val no label')
        
        el = self.add_header('radio-els', 'Logical Group Elements')
        el = self.add_radio('radio1', 'Radio 1', 1, 'rgroup1' )
        el = self.add_radio('radio2', 'Radio 2', 2, 'rgroup1' )
        el = self.add_mcheckbox('mcheck1', 'Check 1', 1, 'cgroup1' )
        el = self.add_mcheckbox('mcheck2', 'Check 2', 2, 'cgroup1' )
        
        el = self.add_header('group-submit', 'Groups')
        sg = self.add_elgroup('name-group', 'Name')
        sg.add_text('name_first', 'First')
        sg.add_text('name_last', 'Last')
        el = self.add_text('phone', 'Phone')
        sg = self.add_elgroup('submit-group', class_='submit-only')
        sg.add_submit('submitlge')
        sg.add_reset('resetlge')
        sg.add_cancel('cancellge')
                
        el = self.add_header('hidden-first', 'Hidden First')
        el = self.add_hidden('hfhidden', defaultval='my hidden val')
        el = self.add_text('hftext', 'Text')
        
        
        el = self.add_header('req-els', 'Required Elements')
        el = self.add_checkbox('rcheckbox', 'Checkbox', required=True)
        el = self.add_file('rfile', 'File', required=True)
        el = self.add_text('rtext', 'Text', required=True)
        el = self.add_text('rnolabel', defaultval='No Label', required=True)
        el = self.add_password('rpassword', 'Password', required=True)
        el = self.add_confirm('rconfirm', 'Confirm Password', match='rpassword')
        options = [('1', 'one'), ('2','two')]
        el = self.add_select('rselect', options, 'Select', required=True)
        el = self.add_mselect('rmselect', options, 'Multi Select', required=True)
        el = self.add_textarea('rtextarea', 'Text Area', required=True)
        
        el = self.add_header('rgroup-submit', 'Required Groups')
        sg = self.add_elgroup('rname-group', 'Name')
        sg.add_text('rname_first', 'First', required=True)
        sg.add_text('rname_last', 'Last', required=True)
        el = self.add_text('rphone', 'Phone', required=True)
        sg = self.add_elgroup('rsubmit-group', class_='submit-only')
        sg.add_submit('rsubmitlge')
        sg.add_reset('rresetlge')
        sg.add_cancel('rcancellge')
        
        el = self.add_header('validators-header', 'Processor (validator/converter) Examples')
        el = self.add_url('v1', 'URL')
        el.add_note('enter junk here and see what two error messages for one field looks like')
        el.add_processor(Email())
        el = self.add_url('v2', 'URL2', defaultval='example.com', add_http=True)
        el.add_note('Note that you can set options on the url validator.  See formencode URL validator for explanation of add_http option', False)
        
        el = self.add_header('header-3', 'Extra Buttons')
        self.add_submit('submit')
        self.add_reset('reset')
        self.add_cancel('cancel')
        self.add_submit('submit2', 'sublabel', defaultval='subtext')
        self.add_reset('reset2', 'resetlabel', defaultval='resettext')
        self.add_cancel('cancel2', 'cancellabel', defaultval='canceltext')