# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DataLakeAnalyticsAccountUpdateParameters(Model):
    """The parameters that can be used to update an existing Data Lake Analytics
    account.

    :param tags: Resource tags
    :type tags: dict
    :param max_degree_of_parallelism: the maximum supported degree of
     parallelism for this account.
    :type max_degree_of_parallelism: int
    :param query_store_retention: the number of days that job metadata is
     retained.
    :type query_store_retention: int
    :param max_job_count: the maximum supported jobs running under the account
     at the same time.
    :type max_job_count: int
    """

    _validation = {
        'max_degree_of_parallelism': {'minimum': 1},
        'query_store_retention': {'maximum': 180, 'minimum': 1},
        'max_job_count': {'minimum': 1},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'max_degree_of_parallelism': {'key': 'properties.maxDegreeOfParallelism', 'type': 'int'},
        'query_store_retention': {'key': 'properties.queryStoreRetention', 'type': 'int'},
        'max_job_count': {'key': 'properties.maxJobCount', 'type': 'int'},
    }

    def __init__(self, tags=None, max_degree_of_parallelism=None, query_store_retention=None, max_job_count=None):
        self.tags = tags
        self.max_degree_of_parallelism = max_degree_of_parallelism
        self.query_store_retention = query_store_retention
        self.max_job_count = max_job_count
