/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.core.properties;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.core.properties.PACommonProperties;
import org.ow2.proactive.core.properties.PACommonPropertiesHelper;
import org.ow2.proactive.core.properties.PropertyType;
import org.ow2.proactive.utils.PAPropertiesLazyLoader;

@PublicAPI
public enum PASchedulerProperties implements PACommonProperties
{
    SCHEDULER_DEFAULT_POLICY("pa.scheduler.policy", PropertyType.STRING, "org.ow2.proactive.scheduler.policy.ExtendedSchedulerPolicy"),
    SCHEDULER_POLICY_NBTASKPERLOOP("pa.scheduler.policy.nbtaskperloop", PropertyType.INTEGER, "10"),
    SCHEDULER_POLCY_STRICT_FIFO("pa.scheduler.policy.strict.fifo", PropertyType.BOOLEAN, "true"),
    SCHEDULER_LICENSE_POLICY_CONFIGURATION("pa.scheduler.license.policy.configuration", PropertyType.STRING),
    SCHEDULER_TIME_OUT("pa.scheduler.core.timeout", PropertyType.INTEGER, "100"),
    SCHEDULER_RMCONNECTION_AUTO_CONNECT("pa.scheduler.core.rmconnection.autoconnect", PropertyType.BOOLEAN, "true"),
    SCHEDULER_RMCONNECTION_TIMESPAN("pa.scheduler.core.rmconnection.timespan", PropertyType.INTEGER, "10000"),
    SCHEDULER_RMCONNECTION_ATTEMPTS("pa.scheduler.core.rmconnection.attempts", PropertyType.INTEGER, "360"),
    SCHEDULER_NODE_PING_FREQUENCY("pa.scheduler.core.nodepingfrequency", PropertyType.INTEGER, "20"),
    SCHEDULER_NODE_PING_ATTEMPTS("pa.scheduler.core.node.ping.attempts", PropertyType.INTEGER, "1"),
    SCHEDULER_KILL_DELAY("pa.scheduler.core.killdelay", PropertyType.INTEGER, "2000"),
    SCHEDULER_CLIENT_POOL_NBTHREAD("pa.scheduler.core.clientpoolnbthreads", PropertyType.INTEGER, "5"),
    SCHEDULER_INTERNAL_POOL_NBTHREAD("pa.scheduler.core.internalpoolnbthreads", PropertyType.INTEGER, "5"),
    SCHEDULER_TASK_PINGER_POOL_NBTHREAD("pa.scheduler.core.taskpingerpoolnbthreads", PropertyType.INTEGER, "10"),
    SCHEDULER_SCHEDULED_POOL_NBTHREAD("pa.scheduler.core.scheduledpoolnbthreads", PropertyType.INTEGER, "2"),
    SCHEDULER_HOUSEKEEPING_SCHEDULED_POOL_NBTHREAD("pa.scheduler.core.housekeeping.scheduledpoolnbthreads", PropertyType.INTEGER, "5"),
    SCHEDULER_PARALLEL_SCHEDULER_STATE_RECOVER_NBTHREAD("pa.scheduler.core.parallel.scheduler.state.recover.nbthreads", PropertyType.INTEGER, "16"),
    SCHEDULER_PARALLEL_SCHEDULER_STATE_RECOVER_TIMEOUT("pa.scheduler.core.parallel.scheduler.state.recover.timeout", PropertyType.INTEGER, "60"),
    SCHEDULER_JMX_CONNECTOR_NAME("pa.scheduler.core.jmx.connectorname", PropertyType.STRING, "JMXSchedulerAgent"),
    SCHEDULER_JMX_PORT("pa.scheduler.core.jmx.port", PropertyType.INTEGER, "5822"),
    SCHEDULER_RRD_DATABASE_NAME("pa.scheduler.jmx.rrd.name", PropertyType.STRING, "data/scheduler_statistics.rrd"),
    SCHEDULER_RRD_STEP("pa.scheduler.jmx.rrd.step", PropertyType.INTEGER, "4"),
    SCHEDULER_ACCOUNT_REFRESH_RATE("pa.scheduler.account.refreshrate", PropertyType.INTEGER, "180"),
    SCHEDULER_USER_SESSION_TIME("pa.scheduler.core.usersessiontime", PropertyType.INTEGER, "28800"),
    SCHEDULER_STARTTASK_TIMEOUT("pa.scheduler.core.starttask.timeout", PropertyType.INTEGER, "5000"),
    SCHEDULER_STARTTASK_THREADNUMBER("pa.scheduler.core.starttask.threadnumber", PropertyType.INTEGER, "5"),
    SCHEDULER_LISTENERS_THREADNUMBER("pa.scheduler.core.listener.threadnumber", PropertyType.INTEGER, "5"),
    SCHEDULER_STARTSCRIPTS_PATHS("pa.scheduler.startscripts.paths", PropertyType.LIST),
    SCHEDULER_AUTH_JAAS_PATH("pa.scheduler.auth.jaas.path", PropertyType.STRING, "config/authentication/jaas.config"),
    SCHEDULER_AUTH_PRIVKEY_PATH("pa.scheduler.auth.privkey.path", PropertyType.STRING, "config/authentication/keys/priv.key"),
    SCHEDULER_AUTH_PUBKEY_PATH("pa.scheduler.auth.pubkey.path", PropertyType.STRING, "config/authentication/keys/pub.key"),
    SCHEDULER_AUTH_GLOBAL_DOMAIN("pa.scheduler.auth.global.domain", PropertyType.STRING),
    SCHEDULER_LDAP_CONFIG_FILE_PATH("pa.scheduler.ldap.config.path", PropertyType.STRING, "config/authentication/ldap.cfg"),
    SCHEDULER_LOGIN_FILENAME("pa.scheduler.core.defaultloginfilename", PropertyType.STRING, "config/authentication/login.cfg"),
    SCHEDULER_GROUP_FILENAME("pa.scheduler.core.defaultgroupfilename", PropertyType.STRING, "config/authentication/group.cfg"),
    SCHEDULER_LOGIN_METHOD("pa.scheduler.core.authentication.loginMethod", PropertyType.STRING, "SchedulerFileLoginMethod"),
    POLICY_RELOAD_FREQUENCY_IN_SECONDS("pa.scheduler.auth.policy.refreshperiod.seconds", PropertyType.INTEGER, "30"),
    SCHEDULER_CREATE_CREDENTIALS_WHEN_LOGIN("pa.scheduler.create.credentials.when.login", PropertyType.BOOLEAN, "false"),
    SCHEDULER_REMOVED_JOB_DELAY("pa.scheduler.core.removejobdelay", PropertyType.INTEGER, "0"),
    SCHEDULER_AUTOMATIC_REMOVED_JOB_DELAY("pa.scheduler.core.automaticremovejobdelay", PropertyType.INTEGER, "0"),
    SCHEDULER_AUTOMATIC_REMOVED_JOB_CRON_EXPR("pa.scheduler.core.automaticremovejobexpression", PropertyType.STRING, "*/10 * * * *"),
    JOB_REMOVE_FROM_DB("pa.scheduler.job.removeFromDataBase", PropertyType.BOOLEAN, "true"),
    FILE_ENCODING("pa.file.encoding", PropertyType.STRING, "UTF-8"),
    SCHEDULER_FINISHED_JOBS_LRU_CACHE_SIZE("pa.scheduler.finishedjobs.lru.cache.size", PropertyType.INTEGER, "1000"),
    REEXECUTION_INITIAL_WAITING_TIME("pa.scheduler.task.initialwaitingtime", PropertyType.INTEGER, "1000"),
    NUMBER_OF_EXECUTION_ON_FAILURE("pa.scheduler.task.numberofexecutiononfailure", PropertyType.INTEGER, "2"),
    TASK_FORK("pa.scheduler.task.fork", PropertyType.BOOLEAN, "true"),
    TASK_RUNASME("pa.scheduler.task.runasme", PropertyType.BOOLEAN, "false"),
    TASKS_PAGE_SIZE("pa.scheduler.tasks.page.size", PropertyType.INTEGER, "100"),
    EXECUTE_SCRIPT_AUTHORIZED_DIR("pa.scheduler.script.authorized.dir", PropertyType.STRING),
    EXECUTE_SCRIPT_AUTHORIZED_DIR_REFRESHPERIOD("pa.scheduler.script.authorized.dir.refreshperiod", PropertyType.INTEGER, "60000"),
    DATASPACE_DEFAULTINPUT_URL("pa.scheduler.dataspace.defaultinput.url", PropertyType.LIST),
    DATASPACE_DEFAULTINPUT_LOCALPATH("pa.scheduler.dataspace.defaultinput.localpath", PropertyType.STRING),
    DATASPACE_DEFAULTINPUT_HOSTNAME("pa.scheduler.dataspace.defaultinput.hostname", PropertyType.STRING),
    DATASPACE_DEFAULTOUTPUT_URL("pa.scheduler.dataspace.defaultoutput.url", PropertyType.LIST),
    DATASPACE_DEFAULTOUTPUT_LOCALPATH("pa.scheduler.dataspace.defaultoutput.localpath", PropertyType.STRING),
    DATASPACE_DEFAULTOUTPUT_HOSTNAME("pa.scheduler.dataspace.defaultoutput.hostname", PropertyType.STRING),
    DATASPACE_DEFAULTGLOBAL_URL("pa.scheduler.dataspace.defaultglobal.url", PropertyType.STRING),
    DATASPACE_DEFAULTGLOBAL_LOCALPATH("pa.scheduler.dataspace.defaultglobal.localpath", PropertyType.STRING),
    DATASPACE_DEFAULTGLOBAL_HOSTNAME("pa.scheduler.dataspace.defaultglobal.hostname", PropertyType.STRING),
    DATASPACE_DEFAULTUSER_URL("pa.scheduler.dataspace.defaultuser.url", PropertyType.STRING),
    DATASPACE_DEFAULTUSER_LOCALPATH("pa.scheduler.dataspace.defaultuser.localpath", PropertyType.STRING),
    DATASPACE_DEFAULTUSER_HOSTNAME("pa.scheduler.dataspace.defaultuser.hostname", PropertyType.STRING),
    LOGS_FORWARDING_PROVIDER("pa.scheduler.logs.provider", PropertyType.STRING, "org.ow2.proactive.scheduler.common.util.logforwarder.providers.ProActiveBasedForwardingProvider"),
    SCHEDULER_JOB_LOGS_LOCATION("pa.scheduler.job.logs.location", PropertyType.STRING, "logs/jobs/"),
    SCHEDULER_JOB_LOGS_MAX_SIZE("pa.scheduler.job.logs.max.size", PropertyType.STRING, "10000"),
    SCHEDULER_JOB_LOGS_PATTERN("pa.scheduler.job.task.output.logs.pattern", PropertyType.STRING, "[%X{job.id}t%X{task.id}@%X{host};%d{HH:mm:ss}] %m %n"),
    SCHEDULER_MEM_MONITORING_FREQ("pa.scheduler.mem.monitoring.freq", PropertyType.STRING),
    SCHEDULER_JOB_SUBMISSION_DETAILED_LOGGING("pa.scheduler.job.submission.detailed.logging", PropertyType.BOOLEAN, "true"),
    SCHEDULER_HOME("pa.scheduler.home", PropertyType.STRING),
    HSQLDB_LOCATION("pa.hsqldb.location", PropertyType.STRING),
    SCHEDULER_REST_URL("pa.scheduler.rest.url", PropertyType.STRING),
    CATALOG_REST_URL("pa.catalog.rest.url", PropertyType.STRING),
    RESOURCE_MANAGER_CREDS("pa.scheduler.resourcemanager.authentication.credentials", PropertyType.STRING, "config/authentication/scheduler.cred"),
    RESOURCE_MANAGER_SINGLE_CONNECTION("pa.scheduler.resourcemanager.authentication.single", PropertyType.BOOLEAN, "true"),
    RESOURCE_MANAGER_CONNECTION_TIMEOUT("pa.scheduler.resourcemanager.connection.timeout", PropertyType.INTEGER, "120000"),
    SCHEDULER_DB_HIBERNATE_CONFIG("pa.scheduler.db.hibernate.configuration", PropertyType.STRING, "config/scheduler/database.properties"),
    SCHEDULER_DB_HIBERNATE_DROPDB("pa.scheduler.db.hibernate.dropdb", PropertyType.BOOLEAN, "false"),
    SCHEDULER_DB_LOAD_JOB_PERIOD("pa.scheduler.db.load.job.period", PropertyType.STRING, "0m"),
    SCHEDULER_DB_TRANSACTION_DAMPING_FACTOR("pa.scheduler.db.transactions.damping.factor", PropertyType.INTEGER, "2"),
    SCHEDULER_DB_TRANSACTION_MAXIMUM_RETRIES("pa.scheduler.db.transactions.maximum.retries", PropertyType.INTEGER, "5"),
    SCHEDULER_DB_TRANSACTION_SLEEP_DELAY("pa.scheduler.db.transactions.sleep.delay", PropertyType.INTEGER, "1000"),
    SCHEDULER_DB_RECOVERY_LOAD_JOBS_BATCH_SIZE("pa.scheduler.db.recovery.load.jobs.batch_size", PropertyType.INTEGER, "100"),
    SCHEDULER_DB_FETCH_TASK_RESULTS_BATCH_SIZE("pa.scheduler.db.fetch.batch_size", PropertyType.INTEGER, "50"),
    EMAIL_NOTIFICATIONS_CONFIGURATION("pa.scheduler.notification.email.configuration", PropertyType.STRING, "config/scheduler/emailnotification.properties"),
    EMAIL_NOTIFICATIONS_ENABLED("pa.scheduler.notifications.email.enabled", PropertyType.BOOLEAN, "false"),
    EMAIL_NOTIFICATIONS_SENDER_ADDRESS("pa.scheduler.notifications.email.from", PropertyType.STRING, "example@username.com"),
    LICENSE_SCHEDULING_POLICY_CONFIGURATION("pa.scheduler.license.policy.configuration", PropertyType.STRING),
    LICENSE_SCHEDULING_POLICY_DATABASE("pa.scheduler.license.policy.db", PropertyType.STRING, "data/licenses"),
    SCHEDULER_SYNCHRONIZATION_DATABASE("pa.scheduler.synchronization.db", PropertyType.STRING, "data/synchronization"),
    SCHEDULER_PORTAL_CONFIGURATION("pa.scheduler.portal.configuration", PropertyType.STRING, "config/portal/scheduler-portal-display.conf");

    public static final String PA_SCHEDULER_PROPERTIES_FILEPATH = "pa.scheduler.properties.filepath";
    public static final String PA_SCHEDULER_PROPERTIES_RELATIVE_FILEPATH = "config/scheduler/settings.ini";
    private static PAPropertiesLazyLoader propertiesLoader;
    private static PACommonPropertiesHelper propertiesHelper;
    private String key;
    private PropertyType type;
    private String defaultValue;

    private PASchedulerProperties(String str, PropertyType type) {
        this(str, type, null);
    }

    private PASchedulerProperties(String str, PropertyType type, String defaultValue) {
        this.key = str;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public void updateProperty(String value) {
        propertiesHelper.updateProperty(this.key, value);
    }

    public static Map<String, Object> getPropertiesAsHashMap() {
        return propertiesHelper.getPropertiesAsHashMap();
    }

    public static void loadProperties(String filename) {
        propertiesLoader = new PAPropertiesLazyLoader(PASchedulerProperties.SCHEDULER_HOME.key, PA_SCHEDULER_PROPERTIES_FILEPATH, PA_SCHEDULER_PROPERTIES_RELATIVE_FILEPATH, filename);
        propertiesHelper = new PACommonPropertiesHelper(propertiesLoader);
    }

    public static synchronized void load() {
        propertiesLoader = new PAPropertiesLazyLoader(PASchedulerProperties.SCHEDULER_HOME.key, PA_SCHEDULER_PROPERTIES_FILEPATH, PA_SCHEDULER_PROPERTIES_RELATIVE_FILEPATH);
        propertiesHelper = new PACommonPropertiesHelper(propertiesLoader);
    }

    public static void updateProperties(String filename) {
        propertiesHelper.updateProperties(filename);
    }

    public String getConfigurationFilePathPropertyName() {
        return PA_SCHEDULER_PROPERTIES_FILEPATH;
    }

    public String getConfigurationDefaultRelativeFilePath() {
        return PA_SCHEDULER_PROPERTIES_RELATIVE_FILEPATH;
    }

    public void loadPropertiesFromFile(String filename) {
        PASchedulerProperties.loadProperties(filename);
    }

    public void reloadConfiguration() {
        PASchedulerProperties.load();
    }

    public boolean isSet() {
        return propertiesHelper.isSet(this.key, this.defaultValue);
    }

    public void unSet() {
        propertiesHelper.unSet(this.key);
    }

    public String getCmdLine() {
        return propertiesHelper.getCmdLine(this.key);
    }

    public long getValueAsLong() {
        return propertiesHelper.getValueAsLong(this.key, this.type, this.defaultValue);
    }

    public int getValueAsInt() {
        return propertiesHelper.getValueAsInt(this.key, this.type, this.defaultValue);
    }

    public String getValueAsString() {
        return propertiesHelper.getValueAsString(this.key, this.defaultValue);
    }

    public List<String> getValueAsList(String separator) {
        return propertiesHelper.getValueAsList(this.key, this.type, separator, this.defaultValue);
    }

    public String getValueAsStringOrNull() {
        return propertiesHelper.getValueAsStringOrNull(this.key);
    }

    public boolean getValueAsBoolean() {
        return propertiesHelper.getValueAsBoolean(this.key, this.type, this.defaultValue);
    }

    public PropertyType getType() {
        return this.type;
    }

    public String toString() {
        return this.getValueAsString();
    }

    public static String getAbsolutePath(String userPath) {
        if (new File(userPath).isAbsolute()) {
            return userPath;
        }
        return SCHEDULER_HOME.getValueAsString() + File.separator + userPath;
    }

    static {
        PASchedulerProperties.load();
    }
}

