/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.factory;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.ow2.proactive.http.CommonHttpResourceDownloader;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.Converter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.converter.IdentityConverter;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.BaseParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.AcceptAllValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.ModelValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class ModelFromURLParserValidator
extends BaseParserValidator<String> {
    public static final String MODEL_FROM_URL_TYPE = "MODEL_FROM_URL";
    public static final String LEFT_DELIMITER = "(";
    public static final String RIGHT_DELIMITER = ")";
    protected static final String MODEL_FROM_URL_TYPE_REGEXP = "[Mm][Oo][Dd][Ee][Ll]_[Ff][Rr][Oo][Mm]_[Uu][Rr][Ll]";
    protected static final String LEFT_DELIMITER_REGEXP = "\\(";
    protected static final String RIGHT_DELIMITER_REGEXP = "\\)";

    public ModelFromURLParserValidator(String model) throws ModelSyntaxException {
        super(model);
    }

    private String findFirstNonEmptyLineTrimmed(List<String> lines) {
        String firstNonEmptyLine = null;
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            firstNonEmptyLine = line.trim();
            break;
        }
        return firstNonEmptyLine;
    }

    @Override
    public String getType() {
        return MODEL_FROM_URL_TYPE;
    }

    @Override
    public String getTypeRegexp() {
        return MODEL_FROM_URL_TYPE_REGEXP;
    }

    @Override
    public Class getClassType() {
        return String.class;
    }

    @Override
    protected Converter<String> createConverter(String model) throws ModelSyntaxException {
        return new IdentityConverter();
    }

    @Override
    protected Validator<String> createValidator(String model, Converter<String> converter) throws ModelSyntaxException {
        String modelFromUrlRegexp = "^[Mm][Oo][Dd][Ee][Ll]_[Ff][Rr][Oo][Mm]_[Uu][Rr][Ll]\\((.+)\\)$";
        String urlString = this.parseAndGetOneGroup(model, modelFromUrlRegexp);
        URL url = null;
        if (urlString.contains("${") && urlString.contains("}")) {
            return new AcceptAllValidator<String>();
        }
        try {
            url = new URL(urlString);
            String modelReceivedFromURL = null;
            if (url.getProtocol().equals("http") || url.getProtocol().equals("https")) {
                CommonHttpResourceDownloader.UrlContent content = CommonHttpResourceDownloader.getInstance().getResourceContent(null, url.toExternalForm(), true);
                modelReceivedFromURL = content.getContent().trim();
            } else {
                List lines = IOUtils.readLines((InputStream)url.openStream(), (Charset)Charset.defaultCharset());
                modelReceivedFromURL = this.findFirstNonEmptyLineTrimmed(lines);
            }
            if (Strings.isNullOrEmpty((String)modelReceivedFromURL)) {
                throw new ModelSyntaxException("In " + this.getType() + " expression, model received from defined url '" + urlString + "' is empty.");
            }
            if (modelReceivedFromURL.startsWith(MODEL_FROM_URL_TYPE)) {
                throw new ModelSyntaxException("In " + this.getType() + " expression, model received from defined url '" + urlString + "' is recursive.");
            }
            return new ModelValidator(modelReceivedFromURL);
        }
        catch (MalformedURLException e) {
            throw new ModelSyntaxException("In " + this.getType() + " expression, defined url '" + urlString + "' is invalid: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ModelSyntaxException("In " + this.getType() + " expression, defined url '" + urlString + "' could not be reached: " + e.getMessage(), e);
        }
    }
}

