########################################################################
# test/xslt/pt_20000805.py
# Paul Tchistopolskii <paul@qub.com> wonders whether Saxon or XT has a bug

import os
import cStringIO
import unittest

from amara.lib import treecompare
from amara.test import test_main
from amara.test.xslt import xslt_test, filesource, stringsource

class test_xslt_xt_saxon_bugtest_pt_20000805(xslt_test):
    source = stringsource("""<doc>
<a><code>A</code></a>
<b><code>-1</code></b>
<c><code>0</code></c>
</doc>""")
    transform = stringsource("""<xsl:stylesheet
xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version="1.0">
<xsl:output method="xml" indent="yes"/>

<xsl:template match="/">
<doc>
 <xsl:for-each select="/doc/*">
      <xsl:sort select="code"/>
      <xsl:copy-of select="."/>
 </xsl:for-each>
</doc>
</xsl:template>
</xsl:stylesheet>""")
    parameters = {}
    expected = """<?xml version='1.0' encoding='UTF-8'?>
<doc>
  <b>
    <code>-1</code>
  </b>
  <c>
    <code>0</code>
  </c>
  <a>
    <code>A</code>
  </a>
</doc>"""


saxon_output = """<?xml version="1.0" encoding="utf-8"?>
<doc>
   <b>
      <code>-1</code>
   </b>
   <c>
      <code>0</code>
   </c>
   <a>
      <code>A</code>
   </a>
</doc>"""


#Note that all these sort orders are OK according to thhe spec's lenience
xt_output = """<?xml version="1.0" encoding="utf-8"?>
<doc>
<c>
<code>0</code>
</c>
<b>
<code>-1</code>
</b>
<a>
<code>A</code>
</a>
</doc>"""

if __name__ == '__main__':
    test_main()
