#!/usr/bin/env python
"""API errors definitions."""
from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals


class Error(RuntimeError):
  """Errors generated by API client library."""


class ResourceNotFoundError(Error):
  """Raised when resource is not found."""


class AccessForbiddenError(Error):
  """Raised when resource access is forbidden."""


class ApiNotImplementedError(Error):
  """Raised when API method is not implemented."""


class UnknownError(Error):
  """Unknown server error."""


class PollTimeoutError(Error):
  """Raised when poll operations times out."""


class FlowFailedError(Error):
  """Raised when waiting on a flow that eventually fails."""


class InvalidArgumentError(Error):
  """Raised when invalid argument(s) is/are passed to the API call."""
