"""Determine links to gl, glu, glut and gle documentation

Extremely simple version with directory listing of the
manual directory as a dictionary.
"""
from OpenGL import GL, GLU, GLUT, GLE
import os, string, sys, glob, operator

BASEURL = "http://pyopengl.sourceforge.net/documentation/manual-3.0/"

def findName( name ):
	"""The interface to the module, pass a name to check against
	a list of known documentation.  Returns a fully-qualified URL
	to the document or None."""
	baseName = SPECIALCASES.get( name, name )
	result = FILE_MAPPING.get( baseName )
	if result:
		return BASEURL+result
	else:
		while baseName and baseName[-1] in 'dfiuvbs4321':
			baseName = baseName[:-1]
			result = FILE_MAPPING.get( baseName )
			if result and baseName in ('glut', 'glu', 'gl', 'gle'):
				if name != baseName:
					return None
				else:
					return BASEURL+result
			elif result:
				return BASEURL+result
	return None

SPECIALCASES = {
	'glDisable':"glEnable",
	'glDisableClientState':"glEnableClientState",
	'glEnd':"glBegin",
	'glEndList':"glNewList",
	'glGetBoolean':"glGet",
	'glGetBooleanv':"glGet",
	'glGetDouble':"glGet",
	'glGetDoublev':"glGet",
	'glGetFloatv':"glGet",
	'glGetFloat':"glGet",
	'glGetInteger':"glGet",
	'glGetIntegerv':"glGet",
	'glPopAttrib':"glPushAttrib",
	'glPopClientAttrib':"glPushClientAttrib",
	'glPopMatrix':"glPushMatrix",
	'glPopName':"glPushName",
	
	'gluEndCurve':"gluBeginCurve",
	'gluEndPolygon':"gluBeginPolygon",
	'gluEndSurface':"gluBeginSurface",
	'gluEndTrim':"gluBeginTrim",
	'gluTessEndContour':"gluTessBeginContour",
	
	'glutBitmapLength':"glutBitmapWidth",
	'glutDetachMenu':"glutAttachMenu",
	'glutGetMenu':"glutSetMenu",
	'glutGetWindow':"glutSetWindow",
	'glutHideOverlay':"glutShowOverlay",
	'glutHideWindow':"glutShowWindow",
	'glutIconifyWindow':"glutShowWindow",
	'glutInitWindowSize':"glutInitWindowPosition",
	'glutLeaveGameMode':"glutEnterGameMode",
	'glutMenuStateFunc':"glutMenuStatusFunc",
	'glutPassiveMotionFunc':"glutMotionFunc",
	'glutPostWindowOverlayRedisplay':"glutPostOverlayRedisplay",
	'glutPostWindowRedisplay':"glutPostRedisplay",
	'glutPushWindow':"glutPopWindow",
	'glutSetIconTitle':"glutSetWindowTitle",
	'glutStrokeLength':"glutStrokeWidth",
	'glutStrokeLengthf':"glutStrokeWidth",
	'glutWireCone':"glutSolidCone",
	'glutWireCube':"glutSolidCube",
	'glutWireDodecahedron':"glutSolidDodecahedron",
	'glutWireIcosahedron':"glutSolidIcosahedron",
	'glutWireOctahedron':"glutSolidOctahedron",
	'glutWireSphere':"glutSolidSphere",
	'glutWireTeapot':"glutSolidTeapot",
	'glutWireTetrahedron':"glutSolidTetrahedron",
	'glutWireTorus':"glutSolidTorus",
	"glutRemoveLayer": "glutRemoveOverlay",

	# not there!
	"glutSpaceballMotion":"glutSpaceballMotionFunc",
	"glutRemoveItem":"glutRemoveMenuItem",
	
	'gleGetJoinStyle':"gleSetJoinStyle",
	# not there!
	'gleGetNumSides':"",
	'gleSetNumSides':"",    
}

def exists( baseName, folder ):
	return FILE_MAPPING.get( baseName )

FILE_MAPPING = dict([
	(x.split('.')[0],x)
	for x in [
		'glutJoystickFunc.xhtml',
		'glGetBufferPointerv.xhtml',
		'glutEntryFunc.xhtml',      
		'glOrtho.xhtml',            
		'glStencilOpSeparate.xhtml',
		'glBitmap.xhtml',           
		'glGetPolygonStipple.xhtml',
		'glLoadTransposeMatrix.xhtml',
		'gluUnProject.xhtml',         
		'glMapBuffer.xhtml',          
		'gluBuild3DMipmapLevels.xhtml',
		'glNormalPointer.xhtml',       
		'glutKeyboardUpFunc.xhtml',    
		'glFogCoord.xhtml',            
		'glColorTable.xhtml',          
		'glValidateProgram.xhtml',     
		'glPointParameter.xhtml',      
		'glutChangeToSubMenu.xhtml',   
		'glTexSubImage2D.xhtml',       
		'glCopyConvolutionFilter2D.xhtml',
		'glColorTableParameter.xhtml',    
		'glRotate.xhtml',                 
		'gluBuild1DMipmaps.xhtml',        
		'glGetClipPlane.xhtml',           
		'gluBeginCurve.xhtml',            
		'glPolygonStipple.xhtml',         
		'glIsShader.xhtml',               
		'gleTextureMode.xhtml',           
		'glGetMinmaxParameter.xhtml',     
		'glutGetModifiers.xhtml',         
		'glutStrokeCharacter.xhtml',      
		'gleSpiral.xhtml',                
		'glXMakeCurrent.xhtml',           
		'glBlendEquationSeparate.xhtml',  
		'glutWarpPointer.xhtml',          
		'glCompressedTexImage3D.xhtml',   
		'glutSolidIcosahedron.xhtml',     
		'glutEnterGameMode.xhtml',        
		'gluQuadricCallback.xhtml',       
		'glutIgnoreKeyRepeat.xhtml',      
		'glCompressedTexImage2D.xhtml',   
		'glVertexAttribPointer.xhtml',    
		'glColorPointer.xhtml',           
		'glDeleteProgram.xhtml',          
		'glutAttachMenu.xhtml',           
		'glDeleteLists.xhtml',            
		'glLoadName.xhtml',               
		'gluTessNormal.xhtml',            
		'glEnableVertexAttribArray.xhtml',
		'glCallLists.xhtml',              
		'gluTessVertex.xhtml',            
		'glGetConvolutionFilter.xhtml',   
		'glXDestroyGLXPixmap.xhtml',      
		'glGetString.xhtml',              
		'glWindowPos.xhtml',              
		'glTexImage3D.xhtml',             
		'gluNewQuadric.xhtml',            
		'glGenBuffers.xhtml',             
		'glutCreateMenu.xhtml',           
		'glutMouseFunc.xhtml',            
		'glXDestroyContext.xhtml',        
		'glIsList.xhtml',                 
		'glLight.xhtml',                  
		'gluOrtho2D.xhtml',               
		'glutVisibilityFunc.xhtml',       
		'glDrawArrays.xhtml',             
		'glutSetMenu.xhtml',              
		'glGenLists.xhtml',               
		'glXCopyContext.xhtml',           
		'glInterleavedArrays.xhtml',      
		'glXImportContextEXT.xhtml',      
		'glSeparableFilter2D.xhtml',      
		'glBlendFuncSeparate.xhtml',      
		'glDepthFunc.xhtml',              
		'glLineWidth.xhtml',              
		'glArrayElement.xhtml',           
		'glutSetKeyRepeat.xhtml',         
		'gluDeleteNurbsRenderer.xhtml',   
		'glutTabletButtonFunc.xhtml',     
		'glutDeviceGet.xhtml',            
		'glutSolidTorus.xhtml',           
		'glIndexMask.xhtml',              
		'glXWaitGL.xhtml',                
		'glXChooseFBConfig.xhtml',        
		'glutReshapeWindow.xhtml',        
		'glGetShaderInfoLog.xhtml',       
		'glResetHistogram.xhtml',         
		'glMinmax.xhtml',                 
		'gluCheckExtension.xhtml',        
		'glutCopyColormap.xhtml',         
		'glActiveTexture.xhtml',          
		'glutUseLayer.xhtml',             
		'glutEstablishOverlay.xhtml',     
		'glIsBuffer.xhtml',               
		'glutDestroyMenu.xhtml',          
		'glEvalPoint.xhtml',              
		'glBlendColor.xhtml',             
		'glMultiTexCoord.xhtml',          
		'glClearAccum.xhtml',             
		'glRect.xhtml',                   
		'gleToroid.xhtml',                
		'glPolygonOffset.xhtml',          
		'glMaterial.xhtml',               
		'glViewport.xhtml',               
		'glutAddSubMenu.xhtml',           
		'glNewList.xhtml',                
		'glXCreatePixmap.xhtml',          
		'gluTessBeginPolygon.xhtml',      
		'glRenderMode.xhtml',             
		'glIsEnabled.xhtml',              
		'gluQuadricTexture.xhtml',        
		'glGetTexImage.xhtml',            
		'glFeedbackBuffer.xhtml',         
		'glReadBuffer.xhtml',             
		'glutInitWindowPosition.xhtml',   
		'glutMenuStatusFunc.xhtml',       
		'glMultMatrix.xhtml',             
		'glGetAttribLocation.xhtml',      
		'glRasterPos.xhtml',              
		'glClear.xhtml',                  
		'glCopyPixels.xhtml',             
		'glTexImage2D.xhtml',             
		'glCopyTexSubImage2D.xhtml',      
		'glGetPointerv.xhtml',            
		'glutStrokeWidth.xhtml',          
		'gluNewTess.xhtml',               
		'glPixelMap.xhtml',               
		'glAreTexturesResident.xhtml',    
		'glXCreatePbuffer.xhtml',         
		'glUseProgram.xhtml',             
		'gleLathe.xhtml',                 
		'glGetTexEnv.xhtml',              
		'glMatrixMode.xhtml',             
		'glXCreateWindow.xhtml',          
		'glGetColorTable.xhtml',          
		'gluLoadSamplingMatrices.xhtml',  
		'gluNurbsCurve.xhtml',            
		'gluBeginTrim.xhtml',             
		'glMultiDrawArrays.xhtml',        
		'gluScaleImage.xhtml',            
		'glutShowWindow.xhtml',           
		'glAlphaFunc.xhtml',              
		'glGet.xhtml',                    
		'glColorMask.xhtml',              
		'glLogicOp.xhtml',                
		'glXGetCurrentReadDrawable.xhtml',
		'glutReportErrors.xhtml',         
		'glXGetCurrentDrawable.xhtml',    
		'gluQuadricOrientation.xhtml',    
		'glutGameModeGet.xhtml',          
		'glPolygonMode.xhtml',            
		'glutSetCursor.xhtml',            
		'glPushClientAttrib.xhtml',       
		'glutInitDisplayString.xhtml',    
		'glXMakeContextCurrent.xhtml',    
		'gluPartialDisk.xhtml',           
		'gluDisk.xhtml',                  
		'glXDestroyPbuffer.xhtml',        
		'glGetMaterial.xhtml',            
		'glDepthMask.xhtml',              
		'gluNurbsCallback.xhtml',         
		'glFogCoordPointer.xhtml',        
		'glBufferSubData.xhtml',          
		'glColor.xhtml',                  
		'glEnableClientState.xhtml',      
		'glSampleCoverage.xhtml',         
		'glConvolutionFilter1D.xhtml',    
		'glTranslate.xhtml',              
		'glGetShader.xhtml',              
		'glGetProgramInfoLog.xhtml',      
		'glGetLight.xhtml',               
		'glMultiDrawElements.xhtml',      
		'glCompressedTexSubImage2D.xhtml',
		'glGetBufferSubData.xhtml',       
		'glutSpaceballMotionFunc.xhtml',  
		'glGetColorTableParameter.xhtml', 
		'gleScrew.xhtml',                 
		'glXGetFBConfigs.xhtml',          
		'glIsTexture.xhtml',              
		'glutAddMenuEntry.xhtml',         
		'gluGetString.xhtml',             
		'glScale.xhtml',                  
		'glTexImage1D.xhtml',             
		'glReadPixels.xhtml',             
		'glBindAttribLocation.xhtml',     
		'glPixelStore.xhtml',             
		'glGetVertexAttribPointerv.xhtml',
		'glGetMap.xhtml',                 
		'gluProject.xhtml',               
		'glNormal.xhtml',                 
		'glDrawBuffer.xhtml',             
		'glDetachShader.xhtml',           
		'glBindBuffer.xhtml',             
		'glutBitmapWidth.xhtml',          
		'glAttachShader.xhtml',           
		'glXDestroyWindow.xhtml',         
		'glXChooseVisual.xhtml',          
		'glCopyConvolutionFilter1D.xhtml',
		'glCreateProgram.xhtml',          
		'glGetConvolutionParameter.xhtml',
		'glGetHistogram.xhtml',           
		'glPrioritizeTextures.xhtml',     
		'glXGetCurrentDisplay.xhtml',     
		'glFrustum.xhtml',                
		'glTexCoord.xhtml',               
		'glLightModel.xhtml',             
		'glutSolidDodecahedron.xhtml',    
		'glutSolidCone.xhtml',            
		'glutIdleFunc.xhtml',             
		'gluQuadricNormals.xhtml',        
		'glGetActiveUniform.xhtml',       
		'glXSwapBuffers.xhtml',           
		'glPushAttrib.xhtml',             
		'glGetTexParameter.xhtml',        
		'glFog.xhtml',                    
		'glMapGrid.xhtml',                
		'glStencilMaskSeparate.xhtml',    
		'glIsQuery.xhtml',                
		'gleSuperExtrusion.xhtml',        
		'gluQuadricDrawStyle.xhtml',      
		'glClientActiveTexture.xhtml',    
		'glutLayerGet.xhtml',             
		'glutPostRedisplay.xhtml',        
		'glStencilFuncSeparate.xhtml',    
		'glScissor.xhtml',                
		'glGenTextures.xhtml',            
		'glCullFace.xhtml',               
		'gluBuild3DMipmaps.xhtml',        
		'glGetAttachedShaders.xhtml',     
		'glStencilOp.xhtml',              
		'glPushName.xhtml',               
		'glXCreateContext.xhtml',         
		'glEnable.xhtml',                 
		'glDeleteQueries.xhtml',          
		'glutSpaceballRotateFunc.xhtml',  
		'glXQueryServerString.xhtml',     
		'glutDisplayFunc.xhtml',          
		'gluNewNurbsRenderer.xhtml',      
		'glXGetClientString.xhtml',       
		'gluDeleteTess.xhtml',            
		'glFrontFace.xhtml',              
		'glBeginQuery.xhtml',             
		'glClearColor.xhtml',             
		'glHistogram.xhtml',              
		'glPixelZoom.xhtml',              
		'glTexParameter.xhtml',           
		'gluCylinder.xhtml',              
		'glClearStencil.xhtml',           
		'gluPerspective.xhtml',           
		'glUniform.xhtml',                
		'glutInitDisplayMode.xhtml',      
		'glutDialsFunc.xhtml',            
		'glutOverlayDisplayFunc.xhtml',   
		'glClearDepth.xhtml',             
		'gluNurbsCallbackDataEXT.xhtml',  
		'gleExtrusion.xhtml',             
		'glXQueryContextInfoEXT.xhtml',   
		'gluNurbsCallbackData.xhtml',     
		'glutRemoveMenuItem.xhtml',       
		'glResetMinmax.xhtml',            
		'glutShowOverlay.xhtml',          
		'glLinkProgram.xhtml',            
		'glCompressedTexSubImage1D.xhtml',
		'greypinstripe.png',              
		'glBindTexture.xhtml',            
		'gluBuild1DMipmapLevels.xhtml',   
		'glutCreateWindow.xhtml',         
		'glLineStipple.xhtml',            
		'glGetHistogramParameter.xhtml',  
		'glutTimerFunc.xhtml',            
		'glXGetCurrentContext.xhtml',     
		'glutSolidTetrahedron.xhtml',     
		'glCopyTexSubImage1D.xhtml',      
		'gleTwistExtrusion.xhtml',        
		'glAccum.xhtml',                  
		'glutSolidOctahedron.xhtml',      
		'glTexSubImage1D.xhtml',          
		'gleHelicoid.xhtml',              
		'glDeleteShader.xhtml',           
		'glutCreateSubWindow.xhtml',      
		'glConvolutionParameter.xhtml',   
		'gluGetNurbsProperty.xhtml',      
		'glCompressedTexSubImage3D.xhtml',
		'glutReshapeFunc.xhtml',          
		'glXGetFBConfigAttrib.xhtml',     
		'glMap2.xhtml',                   
		'glGetShaderSource.xhtml',        
		'glDrawBuffers.xhtml',            
		'glBlendEquation.xhtml',          
		'glMultTransposeMatrix.xhtml',    
		'gluErrorString.xhtml',           
		'glPointSize.xhtml',              
		'glXSelectEvent.xhtml',           
		'glutTabletMotionFunc.xhtml',     
		'glutSpecialUpFunc.xhtml',        
		'glIsProgram.xhtml',              
		'glDepthRange.xhtml',             
		'glXIntro.xhtml',                 
		'glCompressedTexImage1D.xhtml',   
		'glGetVertexAttrib.xhtml',        
		'glutPositionWindow.xhtml',       
		'glutSolidTeapot.xhtml',          
		'glPassThrough.xhtml',            
		'glLoadIdentity.xhtml',           
		'glClearIndex.xhtml',             
		'glBlendFunc.xhtml',              
		'glCreateShader.xhtml',           
		'glLoadMatrix.xhtml',             
		'glutPopWindow.xhtml',            
		'glGetPixelMap.xhtml',            
		'glutSetColor.xhtml',             
		'glCompileShader.xhtml',          
		'gluBeginPolygon.xhtml',          
		'gluBeginSurface.xhtml',          
		'glGetTexLevelParameter.xhtml',   
		'manpage.css',                    
		'glFlush.xhtml',                  
		'glEvalCoord.xhtml',              
		'glXGetSelectedEvent.xhtml',      
		'gluSphere.xhtml',                
		'glutRemoveOverlay.xhtml',        
		'glGetTexGen.xhtml',              
		'glutMotionFunc.xhtml',           
		'glXQueryContext.xhtml',          
		'glGetUniform.xhtml',             
		'gluTessProperty.xhtml',          
		'glutExtensionSupported.xhtml',   
		'glStencilFunc.xhtml',            
		'glePolyCone.xhtml',              
		'glSecondaryColorPointer.xhtml',  
		'glutButtonBoxFunc.xhtml',        
		'glutWindowStatusFunc.xhtml',     
		'glXQueryExtension.xhtml',        
		'glPushMatrix.xhtml',             
		'glXGetProcAddress.xhtml',        
		'gluTessEndPolygon.xhtml',        
		'glCopyTexImage1D.xhtml',         
		'glTexEnv.xhtml',                 
		'glXDestroyPixmap.xhtml',         
		'glVertexAttrib.xhtml',           
		'glePolyCylinder.xhtml',          
		'glPixelTransfer.xhtml',          
		'glutChangeToMenuEntry.xhtml',    
		'glutFullScreen.xhtml',           
		'gluGetTessProperty.xhtml',       
		'glGetQueryiv.xhtml',             
		'glMap1.xhtml',                   
		'glTexCoordPointer.xhtml',        
		'glGetCompressedTexImage.xhtml',  
		'glTexGen.xhtml',                 
		'glHint.xhtml',                   
		'glFinish.xhtml',                 
		'glInitNames.xhtml',              
		'glShadeModel.xhtml',             
		'glXGetContextIDEXT.xhtml',       
		'glCopyTexImage2D.xhtml',         
		'glutVideoResizeGet.xhtml',       
		'glDrawElements.xhtml',           
		'glSecondaryColor.xhtml',         
		'glutSetWindowTitle.xhtml',       
		'glCopyColorTable.xhtml',         
		'glXIsDirect.xhtml',              
		'gluNurbsProperty.xhtml',         
		'gluLookAt.xhtml',                
		'glutGet.xhtml',                  
		'glutForceJoystickFunc.xhtml',    
		'glGetQueryObject.xhtml',         
		'glDeleteTextures.xhtml',         
		'glXFreeContextEXT.xhtml',        
		'glListBase.xhtml',               
		'glutGetColor.xhtml',             
		'glXCreateGLXPixmap.xhtml',       
		'glutMainLoop.xhtml',             
		'glShaderSource.xhtml',           
		'glStencilMask.xhtml',            
		'glutSetWindow.xhtml',            
		'gluTessCallback.xhtml',          
		'glDrawRangeElements.xhtml',      
		'glGetBufferParameteriv.xhtml',   
		'glutInit.xhtml',                 
		'glClipPlane.xhtml',              
		'glXQueryDrawable.xhtml',         
		'glVertexPointer.xhtml',          
		'glGetMinmax.xhtml',              
		'glDeleteBuffers.xhtml',          
		'glutBitmapCharacter.xhtml',      
		'index.xhtml',                    
		'glXUseXFont.xhtml',              
		'glutSpaceballButtonFunc.xhtml',  
		'glXQueryExtensionsString.xhtml', 
		'gluTessBeginContour.xhtml',      
		'gluNextContour.xhtml',           
		'gluPickMatrix.xhtml',            
		'gleSetJoinStyle.xhtml',          
		'gluBuild2DMipmaps.xhtml',        
		'glXGetConfig.xhtml',             
		'glGetSeparableFilter.xhtml',     
		'glIndex.xhtml',                  
		'glXGetVisualFromFBConfig.xhtml', 
		'glTexSubImage3D.xhtml',          
		'glXCreateNewContext.xhtml',      
		'glutSwapBuffers.xhtml',          
		'glConvolutionFilter2D.xhtml',    
		'glColorMaterial.xhtml',          
		'glXWaitX.xhtml',                 
		'gluDeleteQuadric.xhtml',         
		'glEvalMesh.xhtml',
		'gluPwlCurve.xhtml',
		'gleSetNumSides.xhtml',
		'glSelectBuffer.xhtml',
		'gluNurbsSurface.xhtml',
		'glGenQueries.xhtml',
		'glEdgeFlagPointer.xhtml',
		'glDrawPixels.xhtml',
		'glutSolidCube.xhtml',
		'glGetActiveAttrib.xhtml',
		'glColorSubTable.xhtml',
		'glCopyTexSubImage3D.xhtml',
		'glIndexPointer.xhtml',
		'glBufferData.xhtml',
		'glCopyColorSubTable.xhtml',
		'glCallList.xhtml',
		'glutKeyboardFunc.xhtml',
		'glGetError.xhtml',
		'gluBuild2DMipmapLevels.xhtml',
		'glutGameModeString.xhtml',
		'glEdgeFlag.xhtml',
		'glutDestroyWindow.xhtml',
		'glVertex.xhtml',
		'glGetUniformLocation.xhtml',
		'glutSolidSphere.xhtml',
		'glGetProgram.xhtml',
		'glutPostOverlayRedisplay.xhtml',
		'gluUnProject4.xhtml',
		'glBegin.xhtml',
		'glXQueryVersion.xhtml',
		'glutSpecialFunc.xhtml'
	]
])

if __name__ == "__main__":
	print 'search gl'
	for name in dir(GL):
		if name[:2] == 'gl' and not findName( name):
			print '\t%s:"",'%( repr(name), )

	print 'search glu'
	for name in dir(GLU):
		if name[:2] == 'gl' and not findName( name):
			print '\t%s:"",'%( repr(name), )

	print 'search glut'
	for name in dir(GLUT):
		if name[:2] == 'gl' and not findName( name):
			print '\t%s:"",'%( repr(name), )

	print 'search gle'
	for name in dir(GLE):
		if name[:2] == 'gl' and not findName( name):
			print '\t%s:"",'%( repr(name), )
	
