# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

import uuid
from msrest.pipeline import ClientRawResponse

from .. import models


class PolicyStatesOperations(object):
    """PolicyStatesOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    :ivar management_groups_namespace: The namespace for Microsoft Management RP; only "Microsoft.Management" is allowed. Constant value: "Microsoft.Management".
    :ivar api_version: API version to use with the client requests. Constant value: "2018-04-04".
    :ivar policy_states_summary_resource: The virtual resource under PolicyStates resource type for summarize action. In a given time range, 'latest' represents the latest policy state(s) and is the only allowed value. Constant value: "latest".
    :ivar authorization_namespace: The namespace for Microsoft Authorization resource provider; only "Microsoft.Authorization" is allowed. Constant value: "Microsoft.Authorization".
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self.management_groups_namespace = "Microsoft.Management"
        self.api_version = "2018-04-04"
        self.policy_states_summary_resource = "latest"
        self.authorization_namespace = "Microsoft.Authorization"

        self.config = config

    def list_query_results_for_management_group(
            self, policy_states_resource, management_group_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Queries policy states for the resources under the management group.

        :param policy_states_resource: The virtual resource under PolicyStates
         resource type. In a given time range, 'latest' represents the latest
         policy state(s), whereas 'default' represents all policy state(s).
         Possible values include: 'default', 'latest'
        :type policy_states_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param management_group_name: Management group name.
        :type management_group_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: PolicyStatesQueryResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.PolicyStatesQueryResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        order_by = None
        if query_options is not None:
            order_by = query_options.order_by
        select = None
        if query_options is not None:
            select = query_options.select
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter
        apply = None
        if query_options is not None:
            apply = query_options.apply

        # Construct URL
        url = self.list_query_results_for_management_group.metadata['url']
        path_format_arguments = {
            'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
            'managementGroupsNamespace': self._serialize.url("self.management_groups_namespace", self.management_groups_namespace, 'str'),
            'managementGroupName': self._serialize.url("management_group_name", management_group_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if order_by is not None:
            query_parameters['$orderby'] = self._serialize.query("order_by", order_by, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
        if apply is not None:
            query_parameters['$apply'] = self._serialize.query("apply", apply, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PolicyStatesQueryResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_query_results_for_management_group.metadata = {'url': '/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}

    def summarize_for_management_group(
            self, management_group_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Summarizes policy states for the resources under the management group.

        :param management_group_name: Management group name.
        :type management_group_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: SummarizeResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter

        # Construct URL
        url = self.summarize_for_management_group.metadata['url']
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("self.policy_states_summary_resource", self.policy_states_summary_resource, 'str'),
            'managementGroupsNamespace': self._serialize.url("self.management_groups_namespace", self.management_groups_namespace, 'str'),
            'managementGroupName': self._serialize.url("management_group_name", management_group_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SummarizeResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    summarize_for_management_group.metadata = {'url': '/providers/{managementGroupsNamespace}/managementGroups/{managementGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}

    def list_query_results_for_subscription(
            self, policy_states_resource, subscription_id, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Queries policy states for the resources under the subscription.

        :param policy_states_resource: The virtual resource under PolicyStates
         resource type. In a given time range, 'latest' represents the latest
         policy state(s), whereas 'default' represents all policy state(s).
         Possible values include: 'default', 'latest'
        :type policy_states_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: PolicyStatesQueryResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.PolicyStatesQueryResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        order_by = None
        if query_options is not None:
            order_by = query_options.order_by
        select = None
        if query_options is not None:
            select = query_options.select
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter
        apply = None
        if query_options is not None:
            apply = query_options.apply

        # Construct URL
        url = self.list_query_results_for_subscription.metadata['url']
        path_format_arguments = {
            'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if order_by is not None:
            query_parameters['$orderby'] = self._serialize.query("order_by", order_by, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
        if apply is not None:
            query_parameters['$apply'] = self._serialize.query("apply", apply, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PolicyStatesQueryResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_query_results_for_subscription.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}

    def summarize_for_subscription(
            self, subscription_id, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Summarizes policy states for the resources under the subscription.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: SummarizeResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter

        # Construct URL
        url = self.summarize_for_subscription.metadata['url']
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("self.policy_states_summary_resource", self.policy_states_summary_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SummarizeResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    summarize_for_subscription.metadata = {'url': '/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}

    def list_query_results_for_resource_group(
            self, policy_states_resource, subscription_id, resource_group_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Queries policy states for the resources under the resource group.

        :param policy_states_resource: The virtual resource under PolicyStates
         resource type. In a given time range, 'latest' represents the latest
         policy state(s), whereas 'default' represents all policy state(s).
         Possible values include: 'default', 'latest'
        :type policy_states_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: PolicyStatesQueryResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.PolicyStatesQueryResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        order_by = None
        if query_options is not None:
            order_by = query_options.order_by
        select = None
        if query_options is not None:
            select = query_options.select
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter
        apply = None
        if query_options is not None:
            apply = query_options.apply

        # Construct URL
        url = self.list_query_results_for_resource_group.metadata['url']
        path_format_arguments = {
            'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if order_by is not None:
            query_parameters['$orderby'] = self._serialize.query("order_by", order_by, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
        if apply is not None:
            query_parameters['$apply'] = self._serialize.query("apply", apply, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PolicyStatesQueryResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_query_results_for_resource_group.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}

    def summarize_for_resource_group(
            self, subscription_id, resource_group_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Summarizes policy states for the resources under the resource group.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: SummarizeResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter

        # Construct URL
        url = self.summarize_for_resource_group.metadata['url']
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("self.policy_states_summary_resource", self.policy_states_summary_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SummarizeResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    summarize_for_resource_group.metadata = {'url': '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}

    def list_query_results_for_resource(
            self, policy_states_resource, resource_id, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Queries policy states for the resource.

        :param policy_states_resource: The virtual resource under PolicyStates
         resource type. In a given time range, 'latest' represents the latest
         policy state(s), whereas 'default' represents all policy state(s).
         Possible values include: 'default', 'latest'
        :type policy_states_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param resource_id: Resource ID.
        :type resource_id: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: PolicyStatesQueryResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.PolicyStatesQueryResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        order_by = None
        if query_options is not None:
            order_by = query_options.order_by
        select = None
        if query_options is not None:
            select = query_options.select
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter
        apply = None
        if query_options is not None:
            apply = query_options.apply

        # Construct URL
        url = self.list_query_results_for_resource.metadata['url']
        path_format_arguments = {
            'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if order_by is not None:
            query_parameters['$orderby'] = self._serialize.query("order_by", order_by, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
        if apply is not None:
            query_parameters['$apply'] = self._serialize.query("apply", apply, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PolicyStatesQueryResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_query_results_for_resource.metadata = {'url': '/{resourceId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}

    def summarize_for_resource(
            self, resource_id, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Summarizes policy states for the resource.

        :param resource_id: Resource ID.
        :type resource_id: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: SummarizeResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter

        # Construct URL
        url = self.summarize_for_resource.metadata['url']
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("self.policy_states_summary_resource", self.policy_states_summary_resource, 'str'),
            'resourceId': self._serialize.url("resource_id", resource_id, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SummarizeResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    summarize_for_resource.metadata = {'url': '/{resourceId}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}

    def list_query_results_for_policy_set_definition(
            self, policy_states_resource, subscription_id, policy_set_definition_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Queries policy states for the subscription level policy set definition.

        :param policy_states_resource: The virtual resource under PolicyStates
         resource type. In a given time range, 'latest' represents the latest
         policy state(s), whereas 'default' represents all policy state(s).
         Possible values include: 'default', 'latest'
        :type policy_states_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param policy_set_definition_name: Policy set definition name.
        :type policy_set_definition_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: PolicyStatesQueryResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.PolicyStatesQueryResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        order_by = None
        if query_options is not None:
            order_by = query_options.order_by
        select = None
        if query_options is not None:
            select = query_options.select
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter
        apply = None
        if query_options is not None:
            apply = query_options.apply

        # Construct URL
        url = self.list_query_results_for_policy_set_definition.metadata['url']
        path_format_arguments = {
            'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'authorizationNamespace': self._serialize.url("self.authorization_namespace", self.authorization_namespace, 'str'),
            'policySetDefinitionName': self._serialize.url("policy_set_definition_name", policy_set_definition_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if order_by is not None:
            query_parameters['$orderby'] = self._serialize.query("order_by", order_by, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
        if apply is not None:
            query_parameters['$apply'] = self._serialize.query("apply", apply, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PolicyStatesQueryResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_query_results_for_policy_set_definition.metadata = {'url': '/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}

    def summarize_for_policy_set_definition(
            self, subscription_id, policy_set_definition_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Summarizes policy states for the subscription level policy set
        definition.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param policy_set_definition_name: Policy set definition name.
        :type policy_set_definition_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: SummarizeResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter

        # Construct URL
        url = self.summarize_for_policy_set_definition.metadata['url']
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("self.policy_states_summary_resource", self.policy_states_summary_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'authorizationNamespace': self._serialize.url("self.authorization_namespace", self.authorization_namespace, 'str'),
            'policySetDefinitionName': self._serialize.url("policy_set_definition_name", policy_set_definition_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SummarizeResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    summarize_for_policy_set_definition.metadata = {'url': '/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policySetDefinitions/{policySetDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}

    def list_query_results_for_policy_definition(
            self, policy_states_resource, subscription_id, policy_definition_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Queries policy states for the subscription level policy definition.

        :param policy_states_resource: The virtual resource under PolicyStates
         resource type. In a given time range, 'latest' represents the latest
         policy state(s), whereas 'default' represents all policy state(s).
         Possible values include: 'default', 'latest'
        :type policy_states_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param policy_definition_name: Policy definition name.
        :type policy_definition_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: PolicyStatesQueryResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.PolicyStatesQueryResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        order_by = None
        if query_options is not None:
            order_by = query_options.order_by
        select = None
        if query_options is not None:
            select = query_options.select
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter
        apply = None
        if query_options is not None:
            apply = query_options.apply

        # Construct URL
        url = self.list_query_results_for_policy_definition.metadata['url']
        path_format_arguments = {
            'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'authorizationNamespace': self._serialize.url("self.authorization_namespace", self.authorization_namespace, 'str'),
            'policyDefinitionName': self._serialize.url("policy_definition_name", policy_definition_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if order_by is not None:
            query_parameters['$orderby'] = self._serialize.query("order_by", order_by, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
        if apply is not None:
            query_parameters['$apply'] = self._serialize.query("apply", apply, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PolicyStatesQueryResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_query_results_for_policy_definition.metadata = {'url': '/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}

    def summarize_for_policy_definition(
            self, subscription_id, policy_definition_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Summarizes policy states for the subscription level policy definition.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param policy_definition_name: Policy definition name.
        :type policy_definition_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: SummarizeResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter

        # Construct URL
        url = self.summarize_for_policy_definition.metadata['url']
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("self.policy_states_summary_resource", self.policy_states_summary_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'authorizationNamespace': self._serialize.url("self.authorization_namespace", self.authorization_namespace, 'str'),
            'policyDefinitionName': self._serialize.url("policy_definition_name", policy_definition_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SummarizeResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    summarize_for_policy_definition.metadata = {'url': '/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyDefinitions/{policyDefinitionName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}

    def list_query_results_for_subscription_level_policy_assignment(
            self, policy_states_resource, subscription_id, policy_assignment_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Queries policy states for the subscription level policy assignment.

        :param policy_states_resource: The virtual resource under PolicyStates
         resource type. In a given time range, 'latest' represents the latest
         policy state(s), whereas 'default' represents all policy state(s).
         Possible values include: 'default', 'latest'
        :type policy_states_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param policy_assignment_name: Policy assignment name.
        :type policy_assignment_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: PolicyStatesQueryResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.PolicyStatesQueryResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        order_by = None
        if query_options is not None:
            order_by = query_options.order_by
        select = None
        if query_options is not None:
            select = query_options.select
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter
        apply = None
        if query_options is not None:
            apply = query_options.apply

        # Construct URL
        url = self.list_query_results_for_subscription_level_policy_assignment.metadata['url']
        path_format_arguments = {
            'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'authorizationNamespace': self._serialize.url("self.authorization_namespace", self.authorization_namespace, 'str'),
            'policyAssignmentName': self._serialize.url("policy_assignment_name", policy_assignment_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if order_by is not None:
            query_parameters['$orderby'] = self._serialize.query("order_by", order_by, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
        if apply is not None:
            query_parameters['$apply'] = self._serialize.query("apply", apply, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PolicyStatesQueryResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_query_results_for_subscription_level_policy_assignment.metadata = {'url': '/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}

    def summarize_for_subscription_level_policy_assignment(
            self, subscription_id, policy_assignment_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Summarizes policy states for the subscription level policy assignment.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param policy_assignment_name: Policy assignment name.
        :type policy_assignment_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: SummarizeResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter

        # Construct URL
        url = self.summarize_for_subscription_level_policy_assignment.metadata['url']
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("self.policy_states_summary_resource", self.policy_states_summary_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'authorizationNamespace': self._serialize.url("self.authorization_namespace", self.authorization_namespace, 'str'),
            'policyAssignmentName': self._serialize.url("policy_assignment_name", policy_assignment_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SummarizeResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    summarize_for_subscription_level_policy_assignment.metadata = {'url': '/subscriptions/{subscriptionId}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}

    def list_query_results_for_resource_group_level_policy_assignment(
            self, policy_states_resource, subscription_id, resource_group_name, policy_assignment_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Queries policy states for the resource group level policy assignment.

        :param policy_states_resource: The virtual resource under PolicyStates
         resource type. In a given time range, 'latest' represents the latest
         policy state(s), whereas 'default' represents all policy state(s).
         Possible values include: 'default', 'latest'
        :type policy_states_resource: str or
         ~azure.mgmt.policyinsights.models.PolicyStatesResource
        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param policy_assignment_name: Policy assignment name.
        :type policy_assignment_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: PolicyStatesQueryResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.PolicyStatesQueryResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        order_by = None
        if query_options is not None:
            order_by = query_options.order_by
        select = None
        if query_options is not None:
            select = query_options.select
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter
        apply = None
        if query_options is not None:
            apply = query_options.apply

        # Construct URL
        url = self.list_query_results_for_resource_group_level_policy_assignment.metadata['url']
        path_format_arguments = {
            'policyStatesResource': self._serialize.url("policy_states_resource", policy_states_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'authorizationNamespace': self._serialize.url("self.authorization_namespace", self.authorization_namespace, 'str'),
            'policyAssignmentName': self._serialize.url("policy_assignment_name", policy_assignment_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if order_by is not None:
            query_parameters['$orderby'] = self._serialize.query("order_by", order_by, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
        if apply is not None:
            query_parameters['$apply'] = self._serialize.query("apply", apply, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PolicyStatesQueryResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    list_query_results_for_resource_group_level_policy_assignment.metadata = {'url': '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesResource}/queryResults'}

    def summarize_for_resource_group_level_policy_assignment(
            self, subscription_id, resource_group_name, policy_assignment_name, query_options=None, custom_headers=None, raw=False, **operation_config):
        """Summarizes policy states for the resource group level policy
        assignment.

        :param subscription_id: Microsoft Azure subscription ID.
        :type subscription_id: str
        :param resource_group_name: Resource group name.
        :type resource_group_name: str
        :param policy_assignment_name: Policy assignment name.
        :type policy_assignment_name: str
        :param query_options: Additional parameters for the operation
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: SummarizeResults or ClientRawResponse if raw=true
        :rtype: ~azure.mgmt.policyinsights.models.SummarizeResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        top = None
        if query_options is not None:
            top = query_options.top
        from_parameter = None
        if query_options is not None:
            from_parameter = query_options.from_property
        to = None
        if query_options is not None:
            to = query_options.to
        filter = None
        if query_options is not None:
            filter = query_options.filter

        # Construct URL
        url = self.summarize_for_resource_group_level_policy_assignment.metadata['url']
        path_format_arguments = {
            'policyStatesSummaryResource': self._serialize.url("self.policy_states_summary_resource", self.policy_states_summary_resource, 'str'),
            'subscriptionId': self._serialize.url("subscription_id", subscription_id, 'str'),
            'resourceGroupName': self._serialize.url("resource_group_name", resource_group_name, 'str'),
            'authorizationNamespace': self._serialize.url("self.authorization_namespace", self.authorization_namespace, 'str'),
            'policyAssignmentName': self._serialize.url("policy_assignment_name", policy_assignment_name, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if top is not None:
            query_parameters['$top'] = self._serialize.query("top", top, 'int', minimum=0)
        if from_parameter is not None:
            query_parameters['$from'] = self._serialize.query("from_parameter", from_parameter, 'iso-8601')
        if to is not None:
            query_parameters['$to'] = self._serialize.query("to", to, 'iso-8601')
        if filter is not None:
            query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SummarizeResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    summarize_for_resource_group_level_policy_assignment.metadata = {'url': '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{authorizationNamespace}/policyAssignments/{policyAssignmentName}/providers/Microsoft.PolicyInsights/policyStates/{policyStatesSummaryResource}/summarize'}

    def get_metadata(
            self, scope, custom_headers=None, raw=False, **operation_config):
        """Gets OData metadata XML document.

        :param scope: A valid scope, i.e. management group, subscription,
         resource group, or resource ID. Scope used has no effect on metadata
         returned.
        :type scope: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: str or ClientRawResponse if raw=true
        :rtype: str or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`QueryFailureException<azure.mgmt.policyinsights.models.QueryFailureException>`
        """
        # Construct URL
        url = self.get_metadata.metadata['url']
        path_format_arguments = {
            'scope': self._serialize.url("scope", scope, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/xml'
        if self.config.generate_client_request_id:
            header_parameters['x-ms-client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.QueryFailureException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('str', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_metadata.metadata = {'url': '/{scope}/providers/Microsoft.PolicyInsights/policyStates/$metadata'}
