# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Remediation(Model):
    """The remediation definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param policy_assignment_id: The resource ID of the policy assignment that
     should be remediated.
    :type policy_assignment_id: str
    :param policy_definition_reference_id: The policy definition reference ID
     of the individual definition that should be remediated. Required when the
     policy assignment being remediated assigns a policy set definition.
    :type policy_definition_reference_id: str
    :ivar provisioning_state: The status of the remediation.
    :vartype provisioning_state: str
    :ivar created_on: The time at which the remediation was created.
    :vartype created_on: datetime
    :ivar last_updated_on: The time at which the remediation was last updated.
    :vartype last_updated_on: datetime
    :param filters: The filters that will be applied to determine which
     resources to remediate.
    :type filters: ~azure.mgmt.policyinsights.models.RemediationFilters
    :param deployment_status: The deployment status summary for all
     deployments created by the remediation.
    :type deployment_status:
     ~azure.mgmt.policyinsights.models.RemediationDeploymentSummary
    :ivar id: The ID of the remediation.
    :vartype id: str
    :ivar type: The type of the remediation.
    :vartype type: str
    :ivar name: The name of the remediation.
    :vartype name: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'last_updated_on': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'policy_assignment_id': {'key': 'properties.policyAssignmentId', 'type': 'str'},
        'policy_definition_reference_id': {'key': 'properties.policyDefinitionReferenceId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'properties.lastUpdatedOn', 'type': 'iso-8601'},
        'filters': {'key': 'properties.filters', 'type': 'RemediationFilters'},
        'deployment_status': {'key': 'properties.deploymentStatus', 'type': 'RemediationDeploymentSummary'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Remediation, self).__init__(**kwargs)
        self.policy_assignment_id = kwargs.get('policy_assignment_id', None)
        self.policy_definition_reference_id = kwargs.get('policy_definition_reference_id', None)
        self.provisioning_state = None
        self.created_on = None
        self.last_updated_on = None
        self.filters = kwargs.get('filters', None)
        self.deployment_status = kwargs.get('deployment_status', None)
        self.id = None
        self.type = None
        self.name = None
