# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AccessKeys(msrest.serialization.Model):
    """Namespace/ServiceBus Connection String.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar primary_connection_string: Primary connection string of the created namespace
     authorization rule.
    :vartype primary_connection_string: str
    :ivar secondary_connection_string: Secondary connection string of the created namespace
     authorization rule.
    :vartype secondary_connection_string: str
    :ivar alias_primary_connection_string: Primary connection string of the alias if GEO DR is
     enabled.
    :vartype alias_primary_connection_string: str
    :ivar alias_secondary_connection_string: Secondary  connection string of the alias if GEO DR is
     enabled.
    :vartype alias_secondary_connection_string: str
    :ivar primary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype primary_key: str
    :ivar secondary_key: A base64-encoded 256-bit primary key for signing and validating the SAS
     token.
    :vartype secondary_key: str
    :ivar key_name: A string that describes the authorization rule.
    :vartype key_name: str
    """

    _validation = {
        'primary_connection_string': {'readonly': True},
        'secondary_connection_string': {'readonly': True},
        'alias_primary_connection_string': {'readonly': True},
        'alias_secondary_connection_string': {'readonly': True},
        'primary_key': {'readonly': True},
        'secondary_key': {'readonly': True},
        'key_name': {'readonly': True},
    }

    _attribute_map = {
        'primary_connection_string': {'key': 'primaryConnectionString', 'type': 'str'},
        'secondary_connection_string': {'key': 'secondaryConnectionString', 'type': 'str'},
        'alias_primary_connection_string': {'key': 'aliasPrimaryConnectionString', 'type': 'str'},
        'alias_secondary_connection_string': {'key': 'aliasSecondaryConnectionString', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessKeys, self).__init__(**kwargs)
        self.primary_connection_string = None
        self.secondary_connection_string = None
        self.alias_primary_connection_string = None
        self.alias_secondary_connection_string = None
        self.primary_key = None
        self.secondary_key = None
        self.key_name = None


class Action(msrest.serialization.Model):
    """Represents the filter actions which are allowed for the transformation of a message that have been matched by a filter expression.

    :param sql_expression: SQL expression. e.g. MyProperty='ABC'.
    :type sql_expression: str
    :param compatibility_level: This property is reserved for future use. An integer value showing
     the compatibility level, currently hard-coded to 20.
    :type compatibility_level: int
    :param requires_preprocessing: Value that indicates whether the rule action requires
     preprocessing.
    :type requires_preprocessing: bool
    """

    _attribute_map = {
        'sql_expression': {'key': 'sqlExpression', 'type': 'str'},
        'compatibility_level': {'key': 'compatibilityLevel', 'type': 'int'},
        'requires_preprocessing': {'key': 'requiresPreprocessing', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Action, self).__init__(**kwargs)
        self.sql_expression = kwargs.get('sql_expression', None)
        self.compatibility_level = kwargs.get('compatibility_level', None)
        self.requires_preprocessing = kwargs.get('requires_preprocessing', True)


class Resource(msrest.serialization.Model):
    """The Resource definition for other than namespace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ArmDisasterRecovery(Resource):
    """Single item in List or Get Alias(Disaster Recovery configuration) operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Provisioning state of the Alias(Disaster Recovery configuration) -
     possible values 'Accepted' or 'Succeeded' or 'Failed'. Possible values include: "Accepted",
     "Succeeded", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.servicebus.models.ProvisioningStateDR
    :ivar pending_replication_operations_count: Number of entities pending to be replicated.
    :vartype pending_replication_operations_count: long
    :param partner_namespace: ARM Id of the Primary/Secondary eventhub namespace name, which is
     part of GEO DR pairing.
    :type partner_namespace: str
    :param alternate_name: Primary/Secondary eventhub namespace name, which is part of GEO DR
     pairing.
    :type alternate_name: str
    :ivar role: role of namespace in GEO DR - possible values 'Primary' or 'PrimaryNotReplicating'
     or 'Secondary'. Possible values include: "Primary", "PrimaryNotReplicating", "Secondary".
    :vartype role: str or ~azure.mgmt.servicebus.models.RoleDisasterRecovery
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'pending_replication_operations_count': {'readonly': True},
        'role': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'pending_replication_operations_count': {'key': 'properties.pendingReplicationOperationsCount', 'type': 'long'},
        'partner_namespace': {'key': 'properties.partnerNamespace', 'type': 'str'},
        'alternate_name': {'key': 'properties.alternateName', 'type': 'str'},
        'role': {'key': 'properties.role', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArmDisasterRecovery, self).__init__(**kwargs)
        self.provisioning_state = None
        self.pending_replication_operations_count = None
        self.partner_namespace = kwargs.get('partner_namespace', None)
        self.alternate_name = kwargs.get('alternate_name', None)
        self.role = None


class ArmDisasterRecoveryListResult(msrest.serialization.Model):
    """The result of the List Alias(Disaster Recovery configuration) operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of Alias(Disaster Recovery configurations).
    :type value: list[~azure.mgmt.servicebus.models.ArmDisasterRecovery]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Alias(Disaster Recovery configuration).
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ArmDisasterRecovery]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArmDisasterRecoveryListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class AuthorizationRuleProperties(msrest.serialization.Model):
    """AuthorizationRule properties.

    All required parameters must be populated in order to send to Azure.

    :param rights: Required. The rights associated with the rule.
    :type rights: list[str or ~azure.mgmt.servicebus.models.AccessRights]
    """

    _validation = {
        'rights': {'required': True},
    }

    _attribute_map = {
        'rights': {'key': 'rights', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthorizationRuleProperties, self).__init__(**kwargs)
        self.rights = kwargs['rights']


class CaptureDescription(msrest.serialization.Model):
    """Properties to configure capture description for eventhub.

    :param enabled: A value that indicates whether capture description is enabled.
    :type enabled: bool
    :param encoding: Enumerates the possible values for the encoding format of capture description.
     Possible values include: "Avro", "AvroDeflate".
    :type encoding: str or ~azure.mgmt.servicebus.models.EncodingCaptureDescription
    :param interval_in_seconds: The time window allows you to set the frequency with which the
     capture to Azure Blobs will happen, value should between 60 to 900 seconds.
    :type interval_in_seconds: int
    :param size_limit_in_bytes: The size window defines the amount of data built up in your Event
     Hub before an capture operation, value should be between 10485760 and 524288000 bytes.
    :type size_limit_in_bytes: int
    :param destination: Properties of Destination where capture will be stored. (Storage Account,
     Blob Names).
    :type destination: ~azure.mgmt.servicebus.models.Destination
    """

    _validation = {
        'interval_in_seconds': {'maximum': 900, 'minimum': 60},
        'size_limit_in_bytes': {'maximum': 524288000, 'minimum': 10485760},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'encoding': {'key': 'encoding', 'type': 'str'},
        'interval_in_seconds': {'key': 'intervalInSeconds', 'type': 'int'},
        'size_limit_in_bytes': {'key': 'sizeLimitInBytes', 'type': 'int'},
        'destination': {'key': 'destination', 'type': 'Destination'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CaptureDescription, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.encoding = kwargs.get('encoding', None)
        self.interval_in_seconds = kwargs.get('interval_in_seconds', None)
        self.size_limit_in_bytes = kwargs.get('size_limit_in_bytes', None)
        self.destination = kwargs.get('destination', None)


class CheckNameAvailability(msrest.serialization.Model):
    """Description of a Check Name availability request properties.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The Name to check the namespace name availability and The namespace name
     can contain only letters, numbers, and hyphens. The namespace must start with a letter, and it
     must end with a letter or number.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailability, self).__init__(**kwargs)
        self.name = kwargs['name']


class CheckNameAvailabilityResult(msrest.serialization.Model):
    """Description of a Check Name availability request properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar message: The detailed info regarding the reason associated with the namespace.
    :vartype message: str
    :param name_available: Value indicating namespace is availability, true if the namespace is
     available; otherwise, false.
    :type name_available: bool
    :param reason: The reason for unavailability of a namespace. Possible values include: "None",
     "InvalidName", "SubscriptionIsDisabled", "NameInUse", "NameInLockdown",
     "TooManyNamespaceInCurrentSubscription".
    :type reason: str or ~azure.mgmt.servicebus.models.UnavailableReason
    """

    _validation = {
        'message': {'readonly': True},
    }

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.message = None
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)


class CorrelationFilter(msrest.serialization.Model):
    """Represents the correlation filter expression.

    :param properties: dictionary object for custom filters.
    :type properties: dict[str, str]
    :param correlation_id: Identifier of the correlation.
    :type correlation_id: str
    :param message_id: Identifier of the message.
    :type message_id: str
    :param to: Address to send to.
    :type to: str
    :param reply_to: Address of the queue to reply to.
    :type reply_to: str
    :param label: Application specific label.
    :type label: str
    :param session_id: Session identifier.
    :type session_id: str
    :param reply_to_session_id: Session identifier to reply to.
    :type reply_to_session_id: str
    :param content_type: Content type of the message.
    :type content_type: str
    :param requires_preprocessing: Value that indicates whether the rule action requires
     preprocessing.
    :type requires_preprocessing: bool
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': '{str}'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'message_id': {'key': 'messageId', 'type': 'str'},
        'to': {'key': 'to', 'type': 'str'},
        'reply_to': {'key': 'replyTo', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'session_id': {'key': 'sessionId', 'type': 'str'},
        'reply_to_session_id': {'key': 'replyToSessionId', 'type': 'str'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'requires_preprocessing': {'key': 'requiresPreprocessing', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CorrelationFilter, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.correlation_id = kwargs.get('correlation_id', None)
        self.message_id = kwargs.get('message_id', None)
        self.to = kwargs.get('to', None)
        self.reply_to = kwargs.get('reply_to', None)
        self.label = kwargs.get('label', None)
        self.session_id = kwargs.get('session_id', None)
        self.reply_to_session_id = kwargs.get('reply_to_session_id', None)
        self.content_type = kwargs.get('content_type', None)
        self.requires_preprocessing = kwargs.get('requires_preprocessing', True)


class Destination(msrest.serialization.Model):
    """Capture storage details for capture description.

    :param name: Name for capture destination.
    :type name: str
    :param storage_account_resource_id: Resource id of the storage account to be used to create the
     blobs.
    :type storage_account_resource_id: str
    :param blob_container: Blob container Name.
    :type blob_container: str
    :param archive_name_format: Blob naming convention for archive, e.g.
     {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}. Here all
     the parameters (Namespace,EventHub .. etc) are mandatory irrespective of order.
    :type archive_name_format: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'storage_account_resource_id': {'key': 'properties.storageAccountResourceId', 'type': 'str'},
        'blob_container': {'key': 'properties.blobContainer', 'type': 'str'},
        'archive_name_format': {'key': 'properties.archiveNameFormat', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Destination, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.storage_account_resource_id = kwargs.get('storage_account_resource_id', None)
        self.blob_container = kwargs.get('blob_container', None)
        self.archive_name_format = kwargs.get('archive_name_format', None)


class ErrorResponse(msrest.serialization.Model):
    """Error response indicates ServiceBus service is not able to process the incoming request. The reason is provided in the error message.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class Eventhub(Resource):
    """Single item in List or Get Event Hub operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar partition_ids: Current number of shards on the Event Hub.
    :vartype partition_ids: list[str]
    :ivar created_at: Exact time the Event Hub was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    :param message_retention_in_days: Number of days to retain the events for this Event Hub, value
     should be 1 to 7 days.
    :type message_retention_in_days: long
    :param partition_count: Number of partitions created for the Event Hub, allowed values are from
     1 to 32 partitions.
    :type partition_count: long
    :param status: Enumerates the possible values for the status of the Event Hub. Possible values
     include: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled", "Creating",
     "Deleting", "Renaming", "Unknown".
    :type status: str or ~azure.mgmt.servicebus.models.EntityStatus
    :param capture_description: Properties of capture description.
    :type capture_description: ~azure.mgmt.servicebus.models.CaptureDescription
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'partition_ids': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
        'message_retention_in_days': {'maximum': 7, 'minimum': 1},
        'partition_count': {'maximum': 32, 'minimum': 1},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'partition_ids': {'key': 'properties.partitionIds', 'type': '[str]'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'message_retention_in_days': {'key': 'properties.messageRetentionInDays', 'type': 'long'},
        'partition_count': {'key': 'properties.partitionCount', 'type': 'long'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'capture_description': {'key': 'properties.captureDescription', 'type': 'CaptureDescription'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Eventhub, self).__init__(**kwargs)
        self.partition_ids = None
        self.created_at = None
        self.updated_at = None
        self.message_retention_in_days = kwargs.get('message_retention_in_days', None)
        self.partition_count = kwargs.get('partition_count', None)
        self.status = kwargs.get('status', None)
        self.capture_description = kwargs.get('capture_description', None)


class EventHubListResult(msrest.serialization.Model):
    """The result of the List EventHubs operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Result of the List EventHubs operation.
    :type value: list[~azure.mgmt.servicebus.models.Eventhub]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of EventHubs.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Eventhub]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventHubListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class MessageCountDetails(msrest.serialization.Model):
    """Message Count Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar active_message_count: Number of active messages in the queue, topic, or subscription.
    :vartype active_message_count: long
    :ivar dead_letter_message_count: Number of messages that are dead lettered.
    :vartype dead_letter_message_count: long
    :ivar scheduled_message_count: Number of scheduled messages.
    :vartype scheduled_message_count: long
    :ivar transfer_message_count: Number of messages transferred to another queue, topic, or
     subscription.
    :vartype transfer_message_count: long
    :ivar transfer_dead_letter_message_count: Number of messages transferred into dead letters.
    :vartype transfer_dead_letter_message_count: long
    """

    _validation = {
        'active_message_count': {'readonly': True},
        'dead_letter_message_count': {'readonly': True},
        'scheduled_message_count': {'readonly': True},
        'transfer_message_count': {'readonly': True},
        'transfer_dead_letter_message_count': {'readonly': True},
    }

    _attribute_map = {
        'active_message_count': {'key': 'activeMessageCount', 'type': 'long'},
        'dead_letter_message_count': {'key': 'deadLetterMessageCount', 'type': 'long'},
        'scheduled_message_count': {'key': 'scheduledMessageCount', 'type': 'long'},
        'transfer_message_count': {'key': 'transferMessageCount', 'type': 'long'},
        'transfer_dead_letter_message_count': {'key': 'transferDeadLetterMessageCount', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MessageCountDetails, self).__init__(**kwargs)
        self.active_message_count = None
        self.dead_letter_message_count = None
        self.scheduled_message_count = None
        self.transfer_message_count = None
        self.transfer_dead_letter_message_count = None


class MigrationConfigListResult(msrest.serialization.Model):
    """The result of the List migrationConfigurations operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of Migration Configs.
    :type value: list[~azure.mgmt.servicebus.models.MigrationConfigProperties]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of migrationConfigurations.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MigrationConfigProperties]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrationConfigListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class MigrationConfigProperties(Resource):
    """Single item in List or Get Migration Config operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Provisioning state of Migration Configuration.
    :vartype provisioning_state: str
    :ivar pending_replication_operations_count: Number of entities pending to be replicated.
    :vartype pending_replication_operations_count: long
    :param target_namespace: Existing premium Namespace ARM Id name which has no entities, will be
     used for migration.
    :type target_namespace: str
    :param post_migration_name: Name to access Standard Namespace after migration.
    :type post_migration_name: str
    :ivar migration_state: State in which Standard to Premium Migration is, possible values :
     Unknown, Reverting, Completing, Initiating, Syncing, Active.
    :vartype migration_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'pending_replication_operations_count': {'readonly': True},
        'migration_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'pending_replication_operations_count': {'key': 'properties.pendingReplicationOperationsCount', 'type': 'long'},
        'target_namespace': {'key': 'properties.targetNamespace', 'type': 'str'},
        'post_migration_name': {'key': 'properties.postMigrationName', 'type': 'str'},
        'migration_state': {'key': 'properties.migrationState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrationConfigProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.pending_replication_operations_count = None
        self.target_namespace = kwargs.get('target_namespace', None)
        self.post_migration_name = kwargs.get('post_migration_name', None)
        self.migration_state = None


class NetworkRuleSet(Resource):
    """Description of NetworkRuleSet resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param default_action: Default Action for Network Rule Set. Possible values include: "Allow",
     "Deny".
    :type default_action: str or ~azure.mgmt.servicebus.models.DefaultAction
    :param virtual_network_rules: List VirtualNetwork Rules.
    :type virtual_network_rules: list[~azure.mgmt.servicebus.models.NWRuleSetVirtualNetworkRules]
    :param ip_rules: List of IpRules.
    :type ip_rules: list[~azure.mgmt.servicebus.models.NWRuleSetIpRules]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'default_action': {'key': 'properties.defaultAction', 'type': 'str'},
        'virtual_network_rules': {'key': 'properties.virtualNetworkRules', 'type': '[NWRuleSetVirtualNetworkRules]'},
        'ip_rules': {'key': 'properties.ipRules', 'type': '[NWRuleSetIpRules]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.default_action = kwargs.get('default_action', None)
        self.virtual_network_rules = kwargs.get('virtual_network_rules', None)
        self.ip_rules = kwargs.get('ip_rules', None)


class NetworkRuleSetListResult(msrest.serialization.Model):
    """The response of the List NetworkRuleSet operation.

    :param value: Result of the List NetworkRuleSet operation.
    :type value: list[~azure.mgmt.servicebus.models.NetworkRuleSet]
    :param next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of NetworkRuleSet.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NetworkRuleSet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkRuleSetListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class NWRuleSetIpRules(msrest.serialization.Model):
    """Description of NetWorkRuleSet - IpRules resource.

    :param ip_mask: IP Mask.
    :type ip_mask: str
    :param action: The IP Filter Action. Possible values include: "Allow". Default value: "Allow".
    :type action: str or ~azure.mgmt.servicebus.models.NetworkRuleIPAction
    """

    _attribute_map = {
        'ip_mask': {'key': 'ipMask', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NWRuleSetIpRules, self).__init__(**kwargs)
        self.ip_mask = kwargs.get('ip_mask', None)
        self.action = kwargs.get('action', "Allow")


class NWRuleSetVirtualNetworkRules(msrest.serialization.Model):
    """Description of VirtualNetworkRules - NetworkRules resource.

    :param subnet: Subnet properties.
    :type subnet: ~azure.mgmt.servicebus.models.Subnet
    :param ignore_missing_vnet_service_endpoint: Value that indicates whether to ignore missing
     VNet Service Endpoint.
    :type ignore_missing_vnet_service_endpoint: bool
    """

    _attribute_map = {
        'subnet': {'key': 'subnet', 'type': 'Subnet'},
        'ignore_missing_vnet_service_endpoint': {'key': 'ignoreMissingVnetServiceEndpoint', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NWRuleSetVirtualNetworkRules, self).__init__(**kwargs)
        self.subnet = kwargs.get('subnet', None)
        self.ignore_missing_vnet_service_endpoint = kwargs.get('ignore_missing_vnet_service_endpoint', None)


class Operation(msrest.serialization.Model):
    """A ServiceBus REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.servicebus.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = kwargs.get('display', None)


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft.ServiceBus.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Invoice, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list ServiceBus operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of ServiceBus operations supported by the Microsoft.ServiceBus resource
     provider.
    :vartype value: list[~azure.mgmt.servicebus.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ResourceNamespacePatch(Resource):
    """The Resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceNamespacePatch, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class PremiumMessagingRegions(ResourceNamespacePatch):
    """Premium Messaging Region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param properties:
    :type properties: ~azure.mgmt.servicebus.models.PremiumMessagingRegionsProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'PremiumMessagingRegionsProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PremiumMessagingRegions, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class PremiumMessagingRegionsListResult(msrest.serialization.Model):
    """The response of the List PremiumMessagingRegions operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Result of the List PremiumMessagingRegions type.
    :type value: list[~azure.mgmt.servicebus.models.PremiumMessagingRegions]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of PremiumMessagingRegions.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PremiumMessagingRegions]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PremiumMessagingRegionsListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class PremiumMessagingRegionsProperties(msrest.serialization.Model):
    """PremiumMessagingRegionsProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Region code.
    :vartype code: str
    :ivar full_name: Full name of the region.
    :vartype full_name: str
    """

    _validation = {
        'code': {'readonly': True},
        'full_name': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'full_name': {'key': 'fullName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PremiumMessagingRegionsProperties, self).__init__(**kwargs)
        self.code = None
        self.full_name = None


class RegenerateAccessKeyParameters(msrest.serialization.Model):
    """Parameters supplied to the Regenerate Authorization Rule operation, specifies which key needs to be reset.

    All required parameters must be populated in order to send to Azure.

    :param key_type: Required. The access key to regenerate. Possible values include: "PrimaryKey",
     "SecondaryKey".
    :type key_type: str or ~azure.mgmt.servicebus.models.KeyType
    :param key: Optional, if the key value provided, is reset for KeyType value or autogenerate Key
     value set for keyType.
    :type key: str
    """

    _validation = {
        'key_type': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegenerateAccessKeyParameters, self).__init__(**kwargs)
        self.key_type = kwargs['key_type']
        self.key = kwargs.get('key', None)


class Rule(Resource):
    """Description of Rule Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param action: Represents the filter actions which are allowed for the transformation of a
     message that have been matched by a filter expression.
    :type action: ~azure.mgmt.servicebus.models.Action
    :param filter_type: Filter type that is evaluated against a BrokeredMessage. Possible values
     include: "SqlFilter", "CorrelationFilter".
    :type filter_type: str or ~azure.mgmt.servicebus.models.FilterType
    :param sql_filter: Properties of sqlFilter.
    :type sql_filter: ~azure.mgmt.servicebus.models.SqlFilter
    :param correlation_filter: Properties of correlationFilter.
    :type correlation_filter: ~azure.mgmt.servicebus.models.CorrelationFilter
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'action': {'key': 'properties.action', 'type': 'Action'},
        'filter_type': {'key': 'properties.filterType', 'type': 'str'},
        'sql_filter': {'key': 'properties.sqlFilter', 'type': 'SqlFilter'},
        'correlation_filter': {'key': 'properties.correlationFilter', 'type': 'CorrelationFilter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Rule, self).__init__(**kwargs)
        self.action = kwargs.get('action', None)
        self.filter_type = kwargs.get('filter_type', None)
        self.sql_filter = kwargs.get('sql_filter', None)
        self.correlation_filter = kwargs.get('correlation_filter', None)


class RuleListResult(msrest.serialization.Model):
    """The response of the List rule operation.

    :param value: Result of the List Rules operation.
    :type value: list[~azure.mgmt.servicebus.models.Rule]
    :param next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of rules.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Rule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class SBAuthorizationRule(Resource):
    """Description of a namespace authorization rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param rights: The rights associated with the rule.
    :type rights: list[str or ~azure.mgmt.servicebus.models.AccessRights]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'rights': {'key': 'properties.rights', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SBAuthorizationRule, self).__init__(**kwargs)
        self.rights = kwargs.get('rights', None)


class SBAuthorizationRuleListResult(msrest.serialization.Model):
    """The response to the List Namespace operation.

    :param value: Result of the List Authorization Rules operation.
    :type value: list[~azure.mgmt.servicebus.models.SBAuthorizationRule]
    :param next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Authorization Rules.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SBAuthorizationRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SBAuthorizationRuleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class TrackedResource(Resource):
    """The Resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. The Geo-location where the resource lives.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class SBNamespace(TrackedResource):
    """Description of a namespace resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. The Geo-location where the resource lives.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Properties of Sku.
    :type sku: ~azure.mgmt.servicebus.models.SBSku
    :ivar provisioning_state: Provisioning state of the namespace.
    :vartype provisioning_state: str
    :ivar created_at: The time the namespace was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The time the namespace was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar service_bus_endpoint: Endpoint you can use to perform Service Bus operations.
    :vartype service_bus_endpoint: str
    :ivar metric_id: Identifier for Azure Insights metrics.
    :vartype metric_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
        'service_bus_endpoint': {'readonly': True},
        'metric_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'SBSku'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'service_bus_endpoint': {'key': 'properties.serviceBusEndpoint', 'type': 'str'},
        'metric_id': {'key': 'properties.metricId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SBNamespace, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.provisioning_state = None
        self.created_at = None
        self.updated_at = None
        self.service_bus_endpoint = None
        self.metric_id = None


class SBNamespaceListResult(msrest.serialization.Model):
    """The response of the List Namespace operation.

    :param value: Result of the List Namespace operation.
    :type value: list[~azure.mgmt.servicebus.models.SBNamespace]
    :param next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Namespaces.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SBNamespace]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SBNamespaceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class SBNamespaceMigrate(msrest.serialization.Model):
    """Namespace Migrate Object.

    All required parameters must be populated in order to send to Azure.

    :param target_namespace_type: Required. Type of namespaces. Possible values include:
     "Messaging", "NotificationHub", "Mixed", "EventHub", "Relay".
    :type target_namespace_type: str or ~azure.mgmt.servicebus.models.NameSpaceType
    """

    _validation = {
        'target_namespace_type': {'required': True},
    }

    _attribute_map = {
        'target_namespace_type': {'key': 'targetNamespaceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SBNamespaceMigrate, self).__init__(**kwargs)
        self.target_namespace_type = kwargs['target_namespace_type']


class SBNamespaceUpdateParameters(ResourceNamespacePatch):
    """Description of a namespace resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Properties of Sku.
    :type sku: ~azure.mgmt.servicebus.models.SBSku
    :ivar provisioning_state: Provisioning state of the namespace.
    :vartype provisioning_state: str
    :ivar created_at: The time the namespace was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The time the namespace was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar service_bus_endpoint: Endpoint you can use to perform Service Bus operations.
    :vartype service_bus_endpoint: str
    :ivar metric_id: Identifier for Azure Insights metrics.
    :vartype metric_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
        'service_bus_endpoint': {'readonly': True},
        'metric_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'SBSku'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'service_bus_endpoint': {'key': 'properties.serviceBusEndpoint', 'type': 'str'},
        'metric_id': {'key': 'properties.metricId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SBNamespaceUpdateParameters, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.provisioning_state = None
        self.created_at = None
        self.updated_at = None
        self.service_bus_endpoint = None
        self.metric_id = None


class SBQueue(Resource):
    """Description of queue Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar count_details: Message Count Details.
    :vartype count_details: ~azure.mgmt.servicebus.models.MessageCountDetails
    :ivar created_at: The exact time the message was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar accessed_at: Last time a message was sent, or the last time there was a receive request
     to this queue.
    :vartype accessed_at: ~datetime.datetime
    :ivar size_in_bytes: The size of the queue, in bytes.
    :vartype size_in_bytes: long
    :ivar message_count: The number of messages in the queue.
    :vartype message_count: long
    :param lock_duration: ISO 8601 timespan duration of a peek-lock; that is, the amount of time
     that the message is locked for other receivers. The maximum value for LockDuration is 5
     minutes; the default value is 1 minute.
    :type lock_duration: ~datetime.timedelta
    :param max_size_in_megabytes: The maximum size of the queue in megabytes, which is the size of
     memory allocated for the queue. Default is 1024.
    :type max_size_in_megabytes: int
    :param requires_duplicate_detection: A value indicating if this queue requires duplicate
     detection.
    :type requires_duplicate_detection: bool
    :param requires_session: A value that indicates whether the queue supports the concept of
     sessions.
    :type requires_session: bool
    :param default_message_time_to_live: ISO 8601 default message timespan to live value. This is
     the duration after which the message expires, starting from when the message is sent to Service
     Bus. This is the default value used when TimeToLive is not set on a message itself.
    :type default_message_time_to_live: ~datetime.timedelta
    :param dead_lettering_on_message_expiration: A value that indicates whether this queue has dead
     letter support when a message expires.
    :type dead_lettering_on_message_expiration: bool
    :param duplicate_detection_history_time_window: ISO 8601 timeSpan structure that defines the
     duration of the duplicate detection history. The default value is 10 minutes.
    :type duplicate_detection_history_time_window: ~datetime.timedelta
    :param max_delivery_count: The maximum delivery count. A message is automatically deadlettered
     after this number of deliveries. default value is 10.
    :type max_delivery_count: int
    :param status: Enumerates the possible values for the status of a messaging entity. Possible
     values include: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled",
     "Creating", "Deleting", "Renaming", "Unknown".
    :type status: str or ~azure.mgmt.servicebus.models.EntityStatus
    :param enable_batched_operations: Value that indicates whether server-side batched operations
     are enabled.
    :type enable_batched_operations: bool
    :param auto_delete_on_idle: ISO 8061 timeSpan idle interval after which the queue is
     automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: ~datetime.timedelta
    :param enable_partitioning: A value that indicates whether the queue is to be partitioned
     across multiple message brokers.
    :type enable_partitioning: bool
    :param enable_express: A value that indicates whether Express Entities are enabled. An express
     queue holds a message in memory temporarily before writing it to persistent storage.
    :type enable_express: bool
    :param forward_to: Queue/Topic name to forward the messages.
    :type forward_to: str
    :param forward_dead_lettered_messages_to: Queue/Topic name to forward the Dead Letter message.
    :type forward_dead_lettered_messages_to: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'count_details': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
        'accessed_at': {'readonly': True},
        'size_in_bytes': {'readonly': True},
        'message_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'count_details': {'key': 'properties.countDetails', 'type': 'MessageCountDetails'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'accessed_at': {'key': 'properties.accessedAt', 'type': 'iso-8601'},
        'size_in_bytes': {'key': 'properties.sizeInBytes', 'type': 'long'},
        'message_count': {'key': 'properties.messageCount', 'type': 'long'},
        'lock_duration': {'key': 'properties.lockDuration', 'type': 'duration'},
        'max_size_in_megabytes': {'key': 'properties.maxSizeInMegabytes', 'type': 'int'},
        'requires_duplicate_detection': {'key': 'properties.requiresDuplicateDetection', 'type': 'bool'},
        'requires_session': {'key': 'properties.requiresSession', 'type': 'bool'},
        'default_message_time_to_live': {'key': 'properties.defaultMessageTimeToLive', 'type': 'duration'},
        'dead_lettering_on_message_expiration': {'key': 'properties.deadLetteringOnMessageExpiration', 'type': 'bool'},
        'duplicate_detection_history_time_window': {'key': 'properties.duplicateDetectionHistoryTimeWindow', 'type': 'duration'},
        'max_delivery_count': {'key': 'properties.maxDeliveryCount', 'type': 'int'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'enable_batched_operations': {'key': 'properties.enableBatchedOperations', 'type': 'bool'},
        'auto_delete_on_idle': {'key': 'properties.autoDeleteOnIdle', 'type': 'duration'},
        'enable_partitioning': {'key': 'properties.enablePartitioning', 'type': 'bool'},
        'enable_express': {'key': 'properties.enableExpress', 'type': 'bool'},
        'forward_to': {'key': 'properties.forwardTo', 'type': 'str'},
        'forward_dead_lettered_messages_to': {'key': 'properties.forwardDeadLetteredMessagesTo', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SBQueue, self).__init__(**kwargs)
        self.count_details = None
        self.created_at = None
        self.updated_at = None
        self.accessed_at = None
        self.size_in_bytes = None
        self.message_count = None
        self.lock_duration = kwargs.get('lock_duration', None)
        self.max_size_in_megabytes = kwargs.get('max_size_in_megabytes', None)
        self.requires_duplicate_detection = kwargs.get('requires_duplicate_detection', None)
        self.requires_session = kwargs.get('requires_session', None)
        self.default_message_time_to_live = kwargs.get('default_message_time_to_live', None)
        self.dead_lettering_on_message_expiration = kwargs.get('dead_lettering_on_message_expiration', None)
        self.duplicate_detection_history_time_window = kwargs.get('duplicate_detection_history_time_window', None)
        self.max_delivery_count = kwargs.get('max_delivery_count', None)
        self.status = kwargs.get('status', None)
        self.enable_batched_operations = kwargs.get('enable_batched_operations', None)
        self.auto_delete_on_idle = kwargs.get('auto_delete_on_idle', None)
        self.enable_partitioning = kwargs.get('enable_partitioning', None)
        self.enable_express = kwargs.get('enable_express', None)
        self.forward_to = kwargs.get('forward_to', None)
        self.forward_dead_lettered_messages_to = kwargs.get('forward_dead_lettered_messages_to', None)


class SBQueueListResult(msrest.serialization.Model):
    """The response to the List Queues operation.

    :param value: Result of the List Queues operation.
    :type value: list[~azure.mgmt.servicebus.models.SBQueue]
    :param next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of queues.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SBQueue]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SBQueueListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class SBSku(msrest.serialization.Model):
    """SKU of the namespace.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of this SKU. Possible values include: "Basic", "Standard",
     "Premium".
    :type name: str or ~azure.mgmt.servicebus.models.SkuName
    :param tier: The billing tier of this particular SKU. Possible values include: "Basic",
     "Standard", "Premium".
    :type tier: str or ~azure.mgmt.servicebus.models.SkuTier
    :param capacity: The specified messaging units for the tier. For Premium tier, capacity are 1,2
     and 4.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SBSku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = kwargs.get('tier', None)
        self.capacity = kwargs.get('capacity', None)


class SBSubscription(Resource):
    """Description of subscription resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar message_count: Number of messages.
    :vartype message_count: long
    :ivar created_at: Exact time the message was created.
    :vartype created_at: ~datetime.datetime
    :ivar accessed_at: Last time there was a receive request to this subscription.
    :vartype accessed_at: ~datetime.datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar count_details: Message count details.
    :vartype count_details: ~azure.mgmt.servicebus.models.MessageCountDetails
    :param lock_duration: ISO 8061 lock duration timespan for the subscription. The default value
     is 1 minute.
    :type lock_duration: ~datetime.timedelta
    :param requires_session: Value indicating if a subscription supports the concept of sessions.
    :type requires_session: bool
    :param default_message_time_to_live: ISO 8061 Default message timespan to live value. This is
     the duration after which the message expires, starting from when the message is sent to Service
     Bus. This is the default value used when TimeToLive is not set on a message itself.
    :type default_message_time_to_live: ~datetime.timedelta
    :param dead_lettering_on_filter_evaluation_exceptions: Value that indicates whether a
     subscription has dead letter support on filter evaluation exceptions.
    :type dead_lettering_on_filter_evaluation_exceptions: bool
    :param dead_lettering_on_message_expiration: Value that indicates whether a subscription has
     dead letter support when a message expires.
    :type dead_lettering_on_message_expiration: bool
    :param duplicate_detection_history_time_window: ISO 8601 timeSpan structure that defines the
     duration of the duplicate detection history. The default value is 10 minutes.
    :type duplicate_detection_history_time_window: ~datetime.timedelta
    :param max_delivery_count: Number of maximum deliveries.
    :type max_delivery_count: int
    :param status: Enumerates the possible values for the status of a messaging entity. Possible
     values include: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled",
     "Creating", "Deleting", "Renaming", "Unknown".
    :type status: str or ~azure.mgmt.servicebus.models.EntityStatus
    :param enable_batched_operations: Value that indicates whether server-side batched operations
     are enabled.
    :type enable_batched_operations: bool
    :param auto_delete_on_idle: ISO 8061 timeSpan idle interval after which the topic is
     automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: ~datetime.timedelta
    :param forward_to: Queue/Topic name to forward the messages.
    :type forward_to: str
    :param forward_dead_lettered_messages_to: Queue/Topic name to forward the Dead Letter message.
    :type forward_dead_lettered_messages_to: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'message_count': {'readonly': True},
        'created_at': {'readonly': True},
        'accessed_at': {'readonly': True},
        'updated_at': {'readonly': True},
        'count_details': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'message_count': {'key': 'properties.messageCount', 'type': 'long'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'accessed_at': {'key': 'properties.accessedAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'count_details': {'key': 'properties.countDetails', 'type': 'MessageCountDetails'},
        'lock_duration': {'key': 'properties.lockDuration', 'type': 'duration'},
        'requires_session': {'key': 'properties.requiresSession', 'type': 'bool'},
        'default_message_time_to_live': {'key': 'properties.defaultMessageTimeToLive', 'type': 'duration'},
        'dead_lettering_on_filter_evaluation_exceptions': {'key': 'properties.deadLetteringOnFilterEvaluationExceptions', 'type': 'bool'},
        'dead_lettering_on_message_expiration': {'key': 'properties.deadLetteringOnMessageExpiration', 'type': 'bool'},
        'duplicate_detection_history_time_window': {'key': 'properties.duplicateDetectionHistoryTimeWindow', 'type': 'duration'},
        'max_delivery_count': {'key': 'properties.maxDeliveryCount', 'type': 'int'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'enable_batched_operations': {'key': 'properties.enableBatchedOperations', 'type': 'bool'},
        'auto_delete_on_idle': {'key': 'properties.autoDeleteOnIdle', 'type': 'duration'},
        'forward_to': {'key': 'properties.forwardTo', 'type': 'str'},
        'forward_dead_lettered_messages_to': {'key': 'properties.forwardDeadLetteredMessagesTo', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SBSubscription, self).__init__(**kwargs)
        self.message_count = None
        self.created_at = None
        self.accessed_at = None
        self.updated_at = None
        self.count_details = None
        self.lock_duration = kwargs.get('lock_duration', None)
        self.requires_session = kwargs.get('requires_session', None)
        self.default_message_time_to_live = kwargs.get('default_message_time_to_live', None)
        self.dead_lettering_on_filter_evaluation_exceptions = kwargs.get('dead_lettering_on_filter_evaluation_exceptions', None)
        self.dead_lettering_on_message_expiration = kwargs.get('dead_lettering_on_message_expiration', None)
        self.duplicate_detection_history_time_window = kwargs.get('duplicate_detection_history_time_window', None)
        self.max_delivery_count = kwargs.get('max_delivery_count', None)
        self.status = kwargs.get('status', None)
        self.enable_batched_operations = kwargs.get('enable_batched_operations', None)
        self.auto_delete_on_idle = kwargs.get('auto_delete_on_idle', None)
        self.forward_to = kwargs.get('forward_to', None)
        self.forward_dead_lettered_messages_to = kwargs.get('forward_dead_lettered_messages_to', None)


class SBSubscriptionListResult(msrest.serialization.Model):
    """The response to the List Subscriptions operation.

    :param value: Result of the List Subscriptions operation.
    :type value: list[~azure.mgmt.servicebus.models.SBSubscription]
    :param next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of subscriptions.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SBSubscription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SBSubscriptionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class SBTopic(Resource):
    """Description of topic resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar size_in_bytes: Size of the topic, in bytes.
    :vartype size_in_bytes: long
    :ivar created_at: Exact time the message was created.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: ~datetime.datetime
    :ivar accessed_at: Last time the message was sent, or a request was received, for this topic.
    :vartype accessed_at: ~datetime.datetime
    :ivar subscription_count: Number of subscriptions.
    :vartype subscription_count: int
    :ivar count_details: Message count details.
    :vartype count_details: ~azure.mgmt.servicebus.models.MessageCountDetails
    :param default_message_time_to_live: ISO 8601 Default message timespan to live value. This is
     the duration after which the message expires, starting from when the message is sent to Service
     Bus. This is the default value used when TimeToLive is not set on a message itself.
    :type default_message_time_to_live: ~datetime.timedelta
    :param max_size_in_megabytes: Maximum size of the topic in megabytes, which is the size of the
     memory allocated for the topic. Default is 1024.
    :type max_size_in_megabytes: int
    :param requires_duplicate_detection: Value indicating if this topic requires duplicate
     detection.
    :type requires_duplicate_detection: bool
    :param duplicate_detection_history_time_window: ISO8601 timespan structure that defines the
     duration of the duplicate detection history. The default value is 10 minutes.
    :type duplicate_detection_history_time_window: ~datetime.timedelta
    :param enable_batched_operations: Value that indicates whether server-side batched operations
     are enabled.
    :type enable_batched_operations: bool
    :param status: Enumerates the possible values for the status of a messaging entity. Possible
     values include: "Active", "Disabled", "Restoring", "SendDisabled", "ReceiveDisabled",
     "Creating", "Deleting", "Renaming", "Unknown".
    :type status: str or ~azure.mgmt.servicebus.models.EntityStatus
    :param support_ordering: Value that indicates whether the topic supports ordering.
    :type support_ordering: bool
    :param auto_delete_on_idle: ISO 8601 timespan idle interval after which the topic is
     automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: ~datetime.timedelta
    :param enable_partitioning: Value that indicates whether the topic to be partitioned across
     multiple message brokers is enabled.
    :type enable_partitioning: bool
    :param enable_express: Value that indicates whether Express Entities are enabled. An express
     topic holds a message in memory temporarily before writing it to persistent storage.
    :type enable_express: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'size_in_bytes': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
        'accessed_at': {'readonly': True},
        'subscription_count': {'readonly': True},
        'count_details': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'size_in_bytes': {'key': 'properties.sizeInBytes', 'type': 'long'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'accessed_at': {'key': 'properties.accessedAt', 'type': 'iso-8601'},
        'subscription_count': {'key': 'properties.subscriptionCount', 'type': 'int'},
        'count_details': {'key': 'properties.countDetails', 'type': 'MessageCountDetails'},
        'default_message_time_to_live': {'key': 'properties.defaultMessageTimeToLive', 'type': 'duration'},
        'max_size_in_megabytes': {'key': 'properties.maxSizeInMegabytes', 'type': 'int'},
        'requires_duplicate_detection': {'key': 'properties.requiresDuplicateDetection', 'type': 'bool'},
        'duplicate_detection_history_time_window': {'key': 'properties.duplicateDetectionHistoryTimeWindow', 'type': 'duration'},
        'enable_batched_operations': {'key': 'properties.enableBatchedOperations', 'type': 'bool'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'support_ordering': {'key': 'properties.supportOrdering', 'type': 'bool'},
        'auto_delete_on_idle': {'key': 'properties.autoDeleteOnIdle', 'type': 'duration'},
        'enable_partitioning': {'key': 'properties.enablePartitioning', 'type': 'bool'},
        'enable_express': {'key': 'properties.enableExpress', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SBTopic, self).__init__(**kwargs)
        self.size_in_bytes = None
        self.created_at = None
        self.updated_at = None
        self.accessed_at = None
        self.subscription_count = None
        self.count_details = None
        self.default_message_time_to_live = kwargs.get('default_message_time_to_live', None)
        self.max_size_in_megabytes = kwargs.get('max_size_in_megabytes', None)
        self.requires_duplicate_detection = kwargs.get('requires_duplicate_detection', None)
        self.duplicate_detection_history_time_window = kwargs.get('duplicate_detection_history_time_window', None)
        self.enable_batched_operations = kwargs.get('enable_batched_operations', None)
        self.status = kwargs.get('status', None)
        self.support_ordering = kwargs.get('support_ordering', None)
        self.auto_delete_on_idle = kwargs.get('auto_delete_on_idle', None)
        self.enable_partitioning = kwargs.get('enable_partitioning', None)
        self.enable_express = kwargs.get('enable_express', None)


class SBTopicListResult(msrest.serialization.Model):
    """The response to the List Topics operation.

    :param value: Result of the List Topics operation.
    :type value: list[~azure.mgmt.servicebus.models.SBTopic]
    :param next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of topics.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SBTopic]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SBTopicListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class SqlFilter(msrest.serialization.Model):
    """Represents a filter which is a composition of an expression and an action that is executed in the pub/sub pipeline.

    :param sql_expression: The SQL expression. e.g. MyProperty='ABC'.
    :type sql_expression: str
    :param compatibility_level: This property is reserved for future use. An integer value showing
     the compatibility level, currently hard-coded to 20.
    :type compatibility_level: int
    :param requires_preprocessing: Value that indicates whether the rule action requires
     preprocessing.
    :type requires_preprocessing: bool
    """

    _validation = {
        'compatibility_level': {'maximum': 20, 'minimum': 20},
    }

    _attribute_map = {
        'sql_expression': {'key': 'sqlExpression', 'type': 'str'},
        'compatibility_level': {'key': 'compatibilityLevel', 'type': 'int'},
        'requires_preprocessing': {'key': 'requiresPreprocessing', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlFilter, self).__init__(**kwargs)
        self.sql_expression = kwargs.get('sql_expression', None)
        self.compatibility_level = kwargs.get('compatibility_level', 20)
        self.requires_preprocessing = kwargs.get('requires_preprocessing', True)


class SqlRuleAction(Action):
    """Represents set of actions written in SQL language-based syntax that is performed against a ServiceBus.Messaging.BrokeredMessage.

    :param sql_expression: SQL expression. e.g. MyProperty='ABC'.
    :type sql_expression: str
    :param compatibility_level: This property is reserved for future use. An integer value showing
     the compatibility level, currently hard-coded to 20.
    :type compatibility_level: int
    :param requires_preprocessing: Value that indicates whether the rule action requires
     preprocessing.
    :type requires_preprocessing: bool
    """

    _attribute_map = {
        'sql_expression': {'key': 'sqlExpression', 'type': 'str'},
        'compatibility_level': {'key': 'compatibilityLevel', 'type': 'int'},
        'requires_preprocessing': {'key': 'requiresPreprocessing', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SqlRuleAction, self).__init__(**kwargs)


class Subnet(msrest.serialization.Model):
    """Properties supplied for Subnet.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Resource ID of Virtual Network Subnet.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Subnet, self).__init__(**kwargs)
        self.id = kwargs['id']
