/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.ref;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import org.jpype.ref.JPypeReference;
import org.jpype.ref.JPypeReferenceSet;

public final class JPypeReferenceQueue
extends ReferenceQueue {
    public long context = 0L;
    private JPypeReferenceSet hostReferences;
    private boolean isStopped = false;
    private Thread queueThread;
    private Object queueStopMutex = new Object();
    PhantomReference sentinel = null;

    public JPypeReferenceQueue() {
    }

    public JPypeReferenceQueue(long l) {
        this.context = l;
        this.hostReferences = new JPypeReferenceSet(l);
        this.addSentinel();
    }

    public void registerRef(Object object, long l, long l2) {
        if (l2 == 0L) {
            return;
        }
        if (this.isStopped) {
            JPypeReferenceQueue.removeHostReference(this.context, l, l2);
        } else {
            JPypeReference jPypeReference = new JPypeReference(this, object, l, l2);
            this.hostReferences.add(jPypeReference);
        }
    }

    public void start() {
        this.isStopped = false;
        this.queueThread = new Thread(new Worker());
        this.queueThread.setDaemon(true);
        this.queueThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            Object object = this.queueStopMutex;
            synchronized (object) {
                JPypeReferenceQueue jPypeReferenceQueue = this;
                synchronized (jPypeReferenceQueue) {
                    this.isStopped = true;
                    this.queueThread.interrupt();
                }
                this.queueStopMutex.wait(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.hostReferences.flush();
    }

    public boolean isRunning() {
        return !this.isStopped;
    }

    public int getQueueSize() {
        return this.hostReferences.size();
    }

    static native void removeHostReference(long var0, long var2, long var4);

    static native void wake(long var0);

    final void addSentinel() {
        this.sentinel = new JPypeReference(this, new byte[0], 0L, 0L);
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            while (!JPypeReferenceQueue.this.isStopped) {
                try {
                    object = (JPypeReference)JPypeReferenceQueue.this.remove(250L);
                    if (object == JPypeReferenceQueue.this.sentinel) {
                        JPypeReferenceQueue.this.addSentinel();
                        JPypeReferenceQueue.wake(JPypeReferenceQueue.this.context);
                        continue;
                    }
                    if (object == null) continue;
                    long l = ((JPypeReference)object).hostReference;
                    long l2 = ((JPypeReference)object).cleanup;
                    JPypeReferenceQueue.this.hostReferences.remove((JPypeReference)object);
                    JPypeReferenceQueue.removeHostReference(JPypeReferenceQueue.this.context, l, l2);
                }
                catch (InterruptedException interruptedException) {}
            }
            object = JPypeReferenceQueue.this.queueStopMutex;
            synchronized (object) {
                JPypeReferenceQueue.this.queueStopMutex.notifyAll();
            }
        }
    }
}

