/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.manager;

import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class MethodResolution {
    long ptr = 0L;
    boolean covered = false;
    Executable executable;
    List<MethodResolution> children = new ArrayList<MethodResolution>();
    static HashMap<Class, Class[]> CONVERSION = new HashMap();

    MethodResolution(Executable executable) {
        CONVERSION.put(Byte.TYPE, MethodResolution.of(Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class));
        CONVERSION.put(Character.TYPE, MethodResolution.of(Character.TYPE, Character.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class));
        CONVERSION.put(Short.TYPE, MethodResolution.of(Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class));
        CONVERSION.put(Integer.TYPE, MethodResolution.of(Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class));
        CONVERSION.put(Long.TYPE, MethodResolution.of(Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class));
        CONVERSION.put(Float.TYPE, MethodResolution.of(Float.TYPE, Float.class, Double.TYPE, Double.class));
        CONVERSION.put(Double.TYPE, MethodResolution.of(Double.TYPE, Double.class));
        this.executable = executable;
    }

    private boolean isCovered() {
        for (MethodResolution methodResolution : this.children) {
            if (methodResolution.covered) continue;
            return false;
        }
        this.covered = true;
        return true;
    }

    public static <T extends Executable> List<MethodResolution> sortMethods(List<T> list) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object : list) {
            linkedList.add(new MethodResolution((Executable)object));
        }
        for (Object object : linkedList) {
            for (MethodResolution methodResolution : linkedList) {
                if (object == methodResolution || !MethodResolution.isMoreSpecificThan(((MethodResolution)object).executable, methodResolution.executable) || MethodResolution.isMoreSpecificThan(methodResolution.executable, ((MethodResolution)object).executable)) continue;
                ((MethodResolution)object).children.add(methodResolution);
            }
        }
        LinkedList linkedList2 = new LinkedList();
        while (!linkedList.isEmpty()) {
            Object object;
            object = (MethodResolution)linkedList.pop();
            boolean bl = super.isCovered();
            if (bl) {
                ((MethodResolution)object).covered = true;
                linkedList2.add(object);
                continue;
            }
            linkedList.add(object);
        }
        return linkedList2;
    }

    static Class[] of(Class ... classArray) {
        return classArray;
    }

    static boolean isAssignableTo(Class clazz, Class clazz2) {
        if (!clazz.isPrimitive()) {
            return clazz2.isAssignableFrom(clazz);
        }
        Class[] classArray = CONVERSION.get(clazz);
        if (classArray == null) {
            return false;
        }
        for (Class clazz3 : classArray) {
            if (!clazz2.equals(clazz3)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMoreSpecificThan(Executable executable, Executable executable2) {
        ArrayList arrayList = new ArrayList(Arrays.asList(executable.getParameterTypes()));
        ArrayList arrayList2 = new ArrayList(Arrays.asList(executable2.getParameterTypes()));
        if (!Modifier.isStatic(executable.getModifiers())) {
            arrayList.add(0, executable.getDeclaringClass());
        }
        if (!Modifier.isStatic(executable2.getModifiers())) {
            arrayList2.add(0, executable2.getDeclaringClass());
        }
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (MethodResolution.isAssignableTo((Class)arrayList.get(i), (Class)arrayList2.get(i))) continue;
            return false;
        }
        return true;
    }
}

