/*
 * Decompiled with CFR 0.152.
 */
package org.jpype;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jpype.manager.TypeFactory;
import org.jpype.manager.TypeFactoryNative;
import org.jpype.manager.TypeManager;
import org.jpype.ref.JPypeReferenceQueue;

public class JPypeContext {
    private static JPypeContext instance = null;
    private long context;
    private TypeFactory typeFactory;
    private TypeManager typeManager;
    private JPypeReferenceQueue referenceQueue;
    private ClassLoader bootLoader;

    public static JPypeContext getInstance() {
        return instance;
    }

    public static JPypeContext createContext(long l, ClassLoader classLoader) {
        instance = new JPypeContext();
        JPypeContext.instance.context = l;
        JPypeContext.instance.bootLoader = classLoader;
        JPypeContext.instance.typeFactory = new TypeFactoryNative();
        JPypeContext.instance.typeManager = new TypeManager(l, JPypeContext.instance.typeFactory);
        JPypeContext.instance.typeManager.typeFactory = JPypeContext.instance.typeFactory;
        JPypeContext.instance.referenceQueue = new JPypeReferenceQueue(l);
        JPypeContext.instance.typeManager.init();
        JPypeContext.instance.referenceQueue.start();
        return instance;
    }

    public void shutdown() {
        this.referenceQueue.stop();
        this.typeManager.shutdown();
    }

    public long getContext() {
        return this.context;
    }

    public ClassLoader getBootLoader() {
        return this.bootLoader;
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public JPypeReferenceQueue getReferenceQueue() {
        return this.referenceQueue;
    }

    public Object callMethod(Method method, Object object, Object[] objectArray) throws Throwable {
        try {
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    private static boolean collect(List list, Object object, int n, int[] nArray, int n2) {
        if (Array.getLength(object) != nArray[n]) {
            return false;
        }
        if (n + 1 == n2) {
            list.add(object);
            return true;
        }
        for (int i = 0; i < nArray[n]; ++i) {
            if (JPypeContext.collect(list, Array.get(object, i), n + 1, nArray, n2)) continue;
            return false;
        }
        return true;
    }

    public Object[] collectRectangular(Object object) {
        int n;
        int n2;
        if (object == null || !object.getClass().isArray()) {
            return null;
        }
        int[] nArray = new int[5];
        int n3 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object2 = object;
        Class<?> clazz = object2.getClass();
        for (n2 = 0; n2 < 5; ++n2) {
            n = Array.getLength(object2);
            if (n == 0) {
                return null;
            }
            nArray[n3++] = n;
            if ((object2 = Array.get(object2, 0)) == null) {
                return null;
            }
            if (!(clazz = clazz.getComponentType()).isArray()) break;
        }
        if (!clazz.isPrimitive()) {
            return null;
        }
        arrayList.add(clazz);
        nArray = Arrays.copyOfRange(nArray, 0, n3);
        arrayList.add(nArray);
        n2 = 1;
        for (n = 0; n < n3 - 1; ++n) {
            n2 *= nArray[n];
        }
        arrayList.ensureCapacity(n2 + 2);
        if (n3 == 5) {
            return null;
        }
        if (!JPypeContext.collect(arrayList, object, 0, nArray, n3)) {
            return null;
        }
        return arrayList.toArray();
    }

    private Object unpack(int n, Object object) {
        Object object2 = Array.get(object, 0);
        Class<?> clazz = object2.getClass();
        int n2 = Array.getLength(object) / n;
        Object object3 = Array.newInstance(clazz, n);
        Object object4 = Array.newInstance(object3.getClass(), n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            while (n4 < n) {
                Object object5 = Array.get(object, n3);
                Array.set(object3, n4, object5);
                ++n4;
                ++n3;
            }
            Array.set(object4, i, object3);
            if (i >= n2 - 1) continue;
            object3 = Array.newInstance(clazz, n);
        }
        return object4;
    }

    public Object assemble(int[] nArray, Object object) {
        int n = nArray.length;
        if (n == 1) {
            return Array.get(object, 0);
        }
        if (n == 2) {
            return Array.get(this.unpack(nArray[0], object), 0);
        }
        for (int i = 0; i < n - 2; ++i) {
            object = this.unpack(nArray[n - i - 2], object);
        }
        return object;
    }

    public long getExcClass(Throwable throwable) {
        if (throwable instanceof PyExceptionProxy) {
            return ((PyExceptionProxy)throwable).cls;
        }
        return 0L;
    }

    public long getExcValue(Throwable throwable) {
        if (throwable instanceof PyExceptionProxy) {
            return ((PyExceptionProxy)throwable).value;
        }
        return 0L;
    }

    public Exception createException(long l, long l2) {
        return new PyExceptionProxy(l, l2);
    }

    public boolean order(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).order() == ByteOrder.LITTLE_ENDIAN;
        }
        if (buffer instanceof ShortBuffer) {
            return ((ShortBuffer)buffer).order() == ByteOrder.LITTLE_ENDIAN;
        }
        if (buffer instanceof CharBuffer) {
            return ((CharBuffer)buffer).order() == ByteOrder.LITTLE_ENDIAN;
        }
        if (buffer instanceof IntBuffer) {
            return ((IntBuffer)buffer).order() == ByteOrder.LITTLE_ENDIAN;
        }
        if (buffer instanceof LongBuffer) {
            return ((LongBuffer)buffer).order() == ByteOrder.LITTLE_ENDIAN;
        }
        if (buffer instanceof FloatBuffer) {
            return ((FloatBuffer)buffer).order() == ByteOrder.LITTLE_ENDIAN;
        }
        if (buffer instanceof DoubleBuffer) {
            return ((DoubleBuffer)buffer).order() == ByteOrder.LITTLE_ENDIAN;
        }
        return true;
    }

    public static class PyExceptionProxy
    extends RuntimeException {
        long cls;
        long value;

        public PyExceptionProxy(long l, long l2) {
            this.cls = l;
            this.value = l2;
        }
    }
}

