# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class VirtualMachineScaleSetVM(Resource):
    """
    Describes a virtual machine scale set virtual machine.

    :param str id: Resource Id
    :param str name: Resource name
    :param str type: Resource type
    :param str location: Resource location
    :param dict tags: Resource tags
    :param str instance_id: Gets the virtual machine instance id.
    :param Sku sku: Gets the virtual machine sku.
    :param Plan plan: Gets or sets the purchase plan when deploying virtual
     machine from VM Marketplace images.
    :param list resources: Gets the virtual machine child extension resources.
    :param bool latest_model_applied: Specifies whether the latest model has
     been applied to the virtual machine.
    :param VirtualMachineInstanceView instance_view: Gets the virtual machine
     instance view.
    :param HardwareProfile hardware_profile: Gets or sets the hardware
     profile.
    :param StorageProfile storage_profile: Gets or sets the storage profile.
    :param OSProfile os_profile: Gets or sets the OS profile.
    :param NetworkProfile network_profile: Gets or sets the network profile.
    :param DiagnosticsProfile diagnostics_profile: Gets or sets the
     diagnostics profile.
    :param SubResource availability_set: Gets or sets the reference Id of the
     availailbity set to which this virtual machine belongs.
    :param str provisioning_state: Gets or sets the provisioning state, which
     only appears in the response.
    :param str license_type: Gets or sets the license type, which is for
     bring your own license scenario.
    """

    _required = []

    _attribute_map = {
        'instance_id': {'key': 'instanceId', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'resources': {'key': 'resources', 'type': '[VirtualMachineExtension]'},
        'latest_model_applied': {'key': 'properties.latestModelApplied', 'type': 'bool', 'flatten': True},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineInstanceView', 'flatten': True},
        'hardware_profile': {'key': 'properties.hardwareProfile', 'type': 'HardwareProfile', 'flatten': True},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile', 'flatten': True},
        'os_profile': {'key': 'properties.osProfile', 'type': 'OSProfile', 'flatten': True},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'NetworkProfile', 'flatten': True},
        'diagnostics_profile': {'key': 'properties.diagnosticsProfile', 'type': 'DiagnosticsProfile', 'flatten': True},
        'availability_set': {'key': 'properties.availabilitySet', 'type': 'SubResource', 'flatten': True},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str', 'flatten': True},
        'license_type': {'key': 'properties.licenseType', 'type': 'str', 'flatten': True},
    }

    def __init__(self, location, id=None, name=None, type=None, tags=None, instance_id=None, sku=None, plan=None, resources=None, latest_model_applied=None, instance_view=None, hardware_profile=None, storage_profile=None, os_profile=None, network_profile=None, diagnostics_profile=None, availability_set=None, provisioning_state=None, license_type=None):
        super(VirtualMachineScaleSetVM, self).__init__(id=id, name=name, type=type, location=location, tags=tags)
        self.instance_id = instance_id
        self.sku = sku
        self.plan = plan
        self.resources = resources
        self.latest_model_applied = latest_model_applied
        self.instance_view = instance_view
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.provisioning_state = provisioning_state
        self.license_type = license_type
