# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class VirtualMachineScaleSetIPConfiguration(SubResource):
    """
    Describes a virtual machine scale set network profile's IP configuration.

    :param str id: Resource Id
    :param str name: Gets or sets the IP configuration name.
    :param ApiEntityReference subnet: Gets or sets the subnet.
    :param list load_balancer_backend_address_pools: Gets or sets the load
     balancer backend address pools.
    """

    _required = ['name', 'subnet']

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'ApiEntityReference', 'flatten': True},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[SubResource]', 'flatten': True},
    }

    def __init__(self, name, subnet, id=None, load_balancer_backend_address_pools=None):
        super(VirtualMachineScaleSetIPConfiguration, self).__init__(id=id)
        self.name = name
        self.subnet = subnet
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
