# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class VirtualMachineImage(SubResource):
    """
    Describes a Virtual Machine Image.

    :param str id: Resource Id
    :param str name: Gets or sets the name of the resource.
    :param str location: Gets or sets the location of the resource.
    :param dict tags: Gets or sets the tags attached to the resource.
    :param PurchasePlan plan:
    :param OSDiskImage os_disk_image:
    :param list data_disk_images:
    """

    _required = ['name', 'location']

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'properties.plan', 'type': 'PurchasePlan', 'flatten': True},
        'os_disk_image': {'key': 'properties.osDiskImage', 'type': 'OSDiskImage', 'flatten': True},
        'data_disk_images': {'key': 'properties.dataDiskImages', 'type': '[DataDiskImage]', 'flatten': True},
    }

    def __init__(self, name, location, id=None, tags=None, plan=None, os_disk_image=None, data_disk_images=None):
        super(VirtualMachineImage, self).__init__(id=id)
        self.name = name
        self.location = location
        self.tags = tags
        self.plan = plan
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images
