# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ImageReference(Model):
    """
    The image reference.

    :param str publisher: Gets or sets the image publisher.
    :param str offer: Gets or sets the image offer.
    :param str sku: Gets or sets the image sku.
    :param str version: Gets or sets the image version. The allowed formats
     are Major.Minor.Build or 'latest'. Major, Minor and Build being decimal
     numbers. Specify 'latest' to use the latest version of image.
    """

    _required = []

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, publisher=None, offer=None, sku=None, version=None):
        self.publisher = publisher
        self.offer = offer
        self.sku = sku
        self.version = version
