# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class AvailabilitySet(Resource):
    """
    Create or update Availability Set parameters.

    :param str id: Resource Id
    :param str name: Resource name
    :param str type: Resource type
    :param str location: Resource location
    :param dict tags: Resource tags
    :param int platform_update_domain_count: Gets or sets Update Domain count.
    :param int platform_fault_domain_count: Gets or sets Fault Domain count.
    :param list virtual_machines: Gets or sets a list containing reference to
     all Virtual Machines  created under this Availability Set.
    :param list statuses: Gets or sets the resource status information.
    """

    _required = []

    _attribute_map = {
        'platform_update_domain_count': {'key': 'properties.platformUpdateDomainCount', 'type': 'int', 'flatten': True},
        'platform_fault_domain_count': {'key': 'properties.platformFaultDomainCount', 'type': 'int', 'flatten': True},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[SubResource]', 'flatten': True},
        'statuses': {'key': 'properties.statuses', 'type': '[InstanceViewStatus]', 'flatten': True},
    }

    def __init__(self, location, id=None, name=None, type=None, tags=None, platform_update_domain_count=None, platform_fault_domain_count=None, virtual_machines=None, statuses=None):
        super(AvailabilitySet, self).__init__(id=id, name=name, type=type, location=location, tags=tags)
        self.platform_update_domain_count = platform_update_domain_count
        self.platform_fault_domain_count = platform_fault_domain_count
        self.virtual_machines = virtual_machines
        self.statuses = statuses
