/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.receivers.net;

import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.component.plugins.Pauseable;
import org.apache.log4j.component.plugins.Plugin;
import org.apache.log4j.component.plugins.Receiver;
import org.apache.log4j.net.ZeroConfSupport;
import org.apache.log4j.receivers.net.PortBased;
import org.apache.log4j.receivers.net.XMLSocketNode;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public class XMLSocketReceiver
extends Receiver
implements Runnable,
PortBased,
Pauseable {
    private boolean paused;
    protected String decoder = "org.apache.log4j.xml.XMLDecoder";
    private ServerSocket serverSocket;
    private List socketList = new Vector();
    private Thread rThread;
    public static final int DEFAULT_PORT = 4448;
    protected int port = 4448;
    private boolean advertiseViaMulticastDNS;
    private ZeroConfSupport zeroConf;
    public static final String ZONE = "_log4j_xml_tcpaccept_receiver.local.";

    public XMLSocketReceiver() {
    }

    public XMLSocketReceiver(int _port) {
        this.port = _port;
    }

    public XMLSocketReceiver(int _port, LoggerRepository _repository) {
        this.port = _port;
        this.repository = _repository;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int _port) {
        this.port = _port;
    }

    public String getDecoder() {
        return this.decoder;
    }

    public void setDecoder(String _decoder) {
        this.decoder = _decoder;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean b) {
        this.paused = b;
    }

    public boolean isEquivalent(Plugin testPlugin) {
        if (testPlugin != null && testPlugin instanceof XMLSocketReceiver) {
            XMLSocketReceiver sReceiver = (XMLSocketReceiver)testPlugin;
            return this.port == sReceiver.getPort() && super.isEquivalent(testPlugin);
        }
        return false;
    }

    public int hashCode() {
        int result = 37 * (this.repository != null ? this.repository.hashCode() : 0);
        result = result * 37 + this.port;
        return result * 37 + (this.getName() != null ? this.getName().hashCode() : 0);
    }

    protected synchronized void setActive(boolean b) {
        this.active = b;
    }

    public void activateOptions() {
        if (!this.isActive()) {
            this.rThread = new Thread(this);
            this.rThread.setDaemon(true);
            this.rThread.start();
            if (this.advertiseViaMulticastDNS) {
                this.zeroConf = new ZeroConfSupport(ZONE, this.port, this.getName());
                this.zeroConf.advertise();
            }
            this.active = true;
        }
    }

    public void setAdvertiseViaMulticastDNS(boolean advertiseViaMulticastDNS) {
        this.advertiseViaMulticastDNS = advertiseViaMulticastDNS;
    }

    public boolean isAdvertiseViaMulticastDNS() {
        return this.advertiseViaMulticastDNS;
    }

    public synchronized void shutdown() {
        this.active = false;
        if (this.rThread != null) {
            this.rThread.interrupt();
            this.rThread = null;
        }
        this.doShutdown();
    }

    private synchronized void doShutdown() {
        this.active = false;
        this.getLogger().debug((Object)"{} doShutdown called", this.getName());
        this.closeServerSocket();
        this.closeAllAcceptedSockets();
        if (this.advertiseViaMulticastDNS) {
            this.zeroConf.unadvertise();
        }
    }

    private void closeServerSocket() {
        this.getLogger().debug((Object)"{} closing server socket", this.getName());
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.serverSocket = null;
    }

    private synchronized void closeAllAcceptedSockets() {
        for (int x = 0; x < this.socketList.size(); ++x) {
            try {
                ((Socket)this.socketList.get(x)).close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socketList.clear();
    }

    public void run() {
        this.getLogger().debug((Object)"performing socket cleanup prior to entering loop for {}", this.name);
        this.closeServerSocket();
        this.closeAllAcceptedSockets();
        this.getLogger().debug((Object)"socket cleanup complete for {}", this.name);
        this.active = true;
        try {
            this.serverSocket = new ServerSocket(this.port);
        }
        catch (Exception e) {
            this.getLogger().error((Object)("error starting SocketReceiver (" + this.getName() + "), receiver did not start"), e);
            this.active = false;
            this.doShutdown();
            return;
        }
        Socket socket = null;
        try {
            this.getLogger().debug("in run-about to enter while isactiveloop");
            this.active = true;
            while (!this.rThread.isInterrupted()) {
                if (socket != null) {
                    this.getLogger().debug("socket not null - creating and starting socketnode");
                    this.socketList.add(socket);
                    XMLSocketNode node = new XMLSocketNode(this.decoder, socket, this);
                    node.setLoggerRepository(this.repository);
                    new Thread(node).start();
                    socket = null;
                }
                this.getLogger().debug("waiting to accept socket");
                socket = this.serverSocket.accept();
                this.getLogger().debug("accepted socket");
            }
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception e) {
            this.getLogger().warn("socket server disconnected, stopping");
        }
    }

    public void doPost(LoggingEvent event) {
        if (!this.isPaused()) {
            super.doPost(event);
        }
    }
}

